goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__15383 = s;
var map__15383__$1 = (((((!((map__15383 == null))))?(((((map__15383.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15383.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15383):map__15383);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15383__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15383__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__15386 = info;
var map__15387 = G__15386;
var map__15387__$1 = (((((!((map__15387 == null))))?(((((map__15387.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15387.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15387):map__15387);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15387__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__15386__$1 = G__15386;
while(true){
var d__$2 = d__$1;
var map__15395 = G__15386__$1;
var map__15395__$1 = (((((!((map__15395 == null))))?(((((map__15395.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15395.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15395):map__15395);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15395__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__16218 = (d__$2 + (1));
var G__16219 = shadow__$2;
d__$1 = G__16218;
G__15386__$1 = G__16219;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__15397){
var map__15400 = p__15397;
var map__15400__$1 = (((((!((map__15400 == null))))?(((((map__15400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15400.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15400):map__15400);
var name_var = map__15400__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15400__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15400__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__15402 = info;
var map__15402__$1 = (((((!((map__15402 == null))))?(((((map__15402.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15402.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15402):map__15402);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15402__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15402__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__15404 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__15404) : cljs.compiler.munge.call(null,G__15404));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__15406 = arguments.length;
switch (G__15406) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__15408 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__15408.cljs$core$IFn$_invoke$arity$1 ? fexpr__15408.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__15408.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__15409 = cp;
switch (G__15409) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__15410_16222 = cljs.core.seq(s);
var chunk__15411_16223 = null;
var count__15412_16224 = (0);
var i__15413_16225 = (0);
while(true){
if((i__15413_16225 < count__15412_16224)){
var c_16226 = chunk__15411_16223.cljs$core$IIndexed$_nth$arity$2(null,i__15413_16225);
sb.append(cljs.compiler.escape_char(c_16226));


var G__16227 = seq__15410_16222;
var G__16228 = chunk__15411_16223;
var G__16229 = count__15412_16224;
var G__16230 = (i__15413_16225 + (1));
seq__15410_16222 = G__16227;
chunk__15411_16223 = G__16228;
count__15412_16224 = G__16229;
i__15413_16225 = G__16230;
continue;
} else {
var temp__5735__auto___16231 = cljs.core.seq(seq__15410_16222);
if(temp__5735__auto___16231){
var seq__15410_16232__$1 = temp__5735__auto___16231;
if(cljs.core.chunked_seq_QMARK_(seq__15410_16232__$1)){
var c__4609__auto___16233 = cljs.core.chunk_first(seq__15410_16232__$1);
var G__16234 = cljs.core.chunk_rest(seq__15410_16232__$1);
var G__16235 = c__4609__auto___16233;
var G__16236 = cljs.core.count(c__4609__auto___16233);
var G__16237 = (0);
seq__15410_16222 = G__16234;
chunk__15411_16223 = G__16235;
count__15412_16224 = G__16236;
i__15413_16225 = G__16237;
continue;
} else {
var c_16238 = cljs.core.first(seq__15410_16232__$1);
sb.append(cljs.compiler.escape_char(c_16238));


var G__16239 = cljs.core.next(seq__15410_16232__$1);
var G__16240 = null;
var G__16241 = (0);
var G__16242 = (0);
seq__15410_16222 = G__16239;
chunk__15411_16223 = G__16240;
count__15412_16224 = G__16241;
i__15413_16225 = G__16242;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15428 = cljs.core.get_global_hierarchy;
return (fexpr__15428.cljs$core$IFn$_invoke$arity$0 ? fexpr__15428.cljs$core$IFn$_invoke$arity$0() : fexpr__15428.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__15429_16243 = ast;
var map__15429_16244__$1 = (((((!((map__15429_16243 == null))))?(((((map__15429_16243.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15429_16243.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15429_16243):map__15429_16243);
var env_16245 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15429_16244__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_16245))){
var map__15431_16246 = env_16245;
var map__15431_16247__$1 = (((((!((map__15431_16246 == null))))?(((((map__15431_16246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15431_16246.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15431_16246):map__15431_16246);
var line_16248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15431_16247__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_16249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15431_16247__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__15433 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__15435 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__15434 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15434.cljs$core$IFn$_invoke$arity$1 ? fexpr__15434.cljs$core$IFn$_invoke$arity$1(G__15435) : fexpr__15434.call(null,G__15435));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15433,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__15433;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_16248 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_16249)?(column_16249 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__15444 = arguments.length;
switch (G__15444) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16251 = arguments.length;
var i__4790__auto___16252 = (0);
while(true){
if((i__4790__auto___16252 < len__4789__auto___16251)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16252]));

var G__16253 = (i__4790__auto___16252 + (1));
i__4790__auto___16252 = G__16253;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_16254 = (function (){var G__15445 = a;
if((!(typeof a === 'string'))){
return G__15445.toString();
} else {
return G__15445;
}
})();
var temp__5739__auto___16255 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___16255 == null)){
} else {
var sm_data_16256 = temp__5739__auto___16255;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_16256,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__15436_SHARP_){
return (p1__15436_SHARP_ + s_16254.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_16254], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15447 = cljs.core.seq(xs);
var chunk__15448 = null;
var count__15449 = (0);
var i__15450 = (0);
while(true){
if((i__15450 < count__15449)){
var x = chunk__15448.cljs$core$IIndexed$_nth$arity$2(null,i__15450);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16257 = seq__15447;
var G__16258 = chunk__15448;
var G__16259 = count__15449;
var G__16260 = (i__15450 + (1));
seq__15447 = G__16257;
chunk__15448 = G__16258;
count__15449 = G__16259;
i__15450 = G__16260;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15447);
if(temp__5735__auto__){
var seq__15447__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15447__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15447__$1);
var G__16261 = cljs.core.chunk_rest(seq__15447__$1);
var G__16262 = c__4609__auto__;
var G__16263 = cljs.core.count(c__4609__auto__);
var G__16264 = (0);
seq__15447 = G__16261;
chunk__15448 = G__16262;
count__15449 = G__16263;
i__15450 = G__16264;
continue;
} else {
var x = cljs.core.first(seq__15447__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16265 = cljs.core.next(seq__15447__$1);
var G__16266 = null;
var G__16267 = (0);
var G__16268 = (0);
seq__15447 = G__16265;
chunk__15448 = G__16266;
count__15449 = G__16267;
i__15450 = G__16268;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq15438){
var G__15439 = cljs.core.first(seq15438);
var seq15438__$1 = cljs.core.next(seq15438);
var G__15440 = cljs.core.first(seq15438__$1);
var seq15438__$2 = cljs.core.next(seq15438__$1);
var G__15441 = cljs.core.first(seq15438__$2);
var seq15438__$3 = cljs.core.next(seq15438__$2);
var G__15442 = cljs.core.first(seq15438__$3);
var seq15438__$4 = cljs.core.next(seq15438__$3);
var G__15443 = cljs.core.first(seq15438__$4);
var seq15438__$5 = cljs.core.next(seq15438__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15439,G__15440,G__15441,G__15442,G__15443,seq15438__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__15453){
var map__15454 = p__15453;
var map__15454__$1 = (((((!((map__15454 == null))))?(((((map__15454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15454):map__15454);
var m = map__15454__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15454__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__15463 = arguments.length;
switch (G__15463) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16270 = arguments.length;
var i__4790__auto___16271 = (0);
while(true){
if((i__4790__auto___16271 < len__4789__auto___16270)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16271]));

var G__16272 = (i__4790__auto___16271 + (1));
i__4790__auto___16271 = G__16272;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15464_16273 = cljs.core.seq(xs);
var chunk__15465_16274 = null;
var count__15466_16275 = (0);
var i__15467_16276 = (0);
while(true){
if((i__15467_16276 < count__15466_16275)){
var x_16277 = chunk__15465_16274.cljs$core$IIndexed$_nth$arity$2(null,i__15467_16276);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16277);


var G__16278 = seq__15464_16273;
var G__16279 = chunk__15465_16274;
var G__16280 = count__15466_16275;
var G__16281 = (i__15467_16276 + (1));
seq__15464_16273 = G__16278;
chunk__15465_16274 = G__16279;
count__15466_16275 = G__16280;
i__15467_16276 = G__16281;
continue;
} else {
var temp__5735__auto___16282 = cljs.core.seq(seq__15464_16273);
if(temp__5735__auto___16282){
var seq__15464_16283__$1 = temp__5735__auto___16282;
if(cljs.core.chunked_seq_QMARK_(seq__15464_16283__$1)){
var c__4609__auto___16284 = cljs.core.chunk_first(seq__15464_16283__$1);
var G__16285 = cljs.core.chunk_rest(seq__15464_16283__$1);
var G__16286 = c__4609__auto___16284;
var G__16287 = cljs.core.count(c__4609__auto___16284);
var G__16288 = (0);
seq__15464_16273 = G__16285;
chunk__15465_16274 = G__16286;
count__15466_16275 = G__16287;
i__15467_16276 = G__16288;
continue;
} else {
var x_16289 = cljs.core.first(seq__15464_16283__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16289);


var G__16290 = cljs.core.next(seq__15464_16283__$1);
var G__16291 = null;
var G__16292 = (0);
var G__16293 = (0);
seq__15464_16273 = G__16290;
chunk__15465_16274 = G__16291;
count__15466_16275 = G__16292;
i__15467_16276 = G__16293;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq15457){
var G__15458 = cljs.core.first(seq15457);
var seq15457__$1 = cljs.core.next(seq15457);
var G__15459 = cljs.core.first(seq15457__$1);
var seq15457__$2 = cljs.core.next(seq15457__$1);
var G__15460 = cljs.core.first(seq15457__$2);
var seq15457__$3 = cljs.core.next(seq15457__$2);
var G__15461 = cljs.core.first(seq15457__$3);
var seq15457__$4 = cljs.core.next(seq15457__$3);
var G__15462 = cljs.core.first(seq15457__$4);
var seq15457__$5 = cljs.core.next(seq15457__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15458,G__15459,G__15460,G__15461,G__15462,seq15457__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__15468_16294 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__15469_16295 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__15470_16296 = true;
var _STAR_print_fn_STAR__temp_val__15471_16297 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__15470_16296);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__15471_16297);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__15469_16295);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__15468_16294);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15472 = cljs.core.get_global_hierarchy;
return (fexpr__15472.cljs$core$IFn$_invoke$arity$0 ? fexpr__15472.cljs$core$IFn$_invoke$arity$0() : fexpr__15472.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__15473 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15473,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15473,(1),null);
var G__15476 = ns;
var G__15477 = name;
var G__15478 = (function (){
var G__15479 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__15479) : cljs.compiler.emit_constant.call(null,G__15479));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__15476,G__15477,G__15478) : cljs.compiler.emit_record_value.call(null,G__15476,G__15477,G__15478));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__15480 = cljs.core.keys(x);
var G__15481 = cljs.core.vals(x);
var G__15482 = cljs.compiler.emit_constants_comma_sep;
var G__15483 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__15480,G__15481,G__15482,G__15483) : cljs.compiler.emit_map.call(null,G__15480,G__15481,G__15482,G__15483));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__15484 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__15485 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__15484,G__15485) : cljs.compiler.emit_with_meta.call(null,G__15484,G__15485));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__15490 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15490,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15490,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15490,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15494 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15494) : x.call(null,G__15494));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15495 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15495) : x.call(null,G__15495));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__15497 = items;
var G__15498 = (function (p1__15496_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__15496_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__15497,G__15498) : cljs.compiler.emit_js_object.call(null,G__15497,G__15498));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__15500){
var map__15501 = p__15500;
var map__15501__$1 = (((((!((map__15501 == null))))?(((((map__15501.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15501.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15501):map__15501);
var ast = map__15501__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15501__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15501__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15501__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__15503 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15503__$1 = (((((!((map__15503 == null))))?(((((map__15503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15503):map__15503);
var cenv = map__15503__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15503__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__15505 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__15508 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__15508) : cljs.compiler.es5_GT__EQ_.call(null,G__15508));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__15505,cljs.analyzer.es5_allowed);
} else {
return G__15505;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__15509 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__15509,reserved);
} else {
return G__15509;
}
})();
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__15510_16298 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__15510_16299__$1 = (((G__15510_16298 instanceof cljs.core.Keyword))?G__15510_16298.fqn:null);
switch (G__15510_16299__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__15516){
var map__15517 = p__15516;
var map__15517__$1 = (((((!((map__15517 == null))))?(((((map__15517.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15517.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15517):map__15517);
var arg = map__15517__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15517__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15517__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15517__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15517__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));


var map__15519 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__15519__$1 = (((((!((map__15519 == null))))?(((((map__15519.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15519.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15519):map__15519);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15519__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__15521){
var map__15522 = p__15521;
var map__15522__$1 = (((((!((map__15522 == null))))?(((((map__15522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15522):map__15522);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__15524_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__15524_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__15526 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15526) : comma_sep.call(null,G__15526));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__15527 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15527) : comma_sep.call(null,G__15527));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__15528){
var map__15529 = p__15528;
var map__15529__$1 = (((((!((map__15529 == null))))?(((((map__15529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15529):map__15529);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15529__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15529__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15529__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__15535){
var map__15536 = p__15535;
var map__15536__$1 = (((((!((map__15536 == null))))?(((((map__15536.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15536.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15536):map__15536);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15536__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15536__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__15541_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__15541_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__15545 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15545) : comma_sep.call(null,G__15545));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__15546){
var map__15547 = p__15546;
var map__15547__$1 = (((((!((map__15547 == null))))?(((((map__15547.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15547.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15547):map__15547);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15547__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15547__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___16301 = cljs.core.seq(items);
if(temp__5735__auto___16301){
var items_16302__$1 = temp__5735__auto___16301;
var vec__15565_16303 = items_16302__$1;
var seq__15566_16304 = cljs.core.seq(vec__15565_16303);
var first__15567_16305 = cljs.core.first(seq__15566_16304);
var seq__15566_16306__$1 = cljs.core.next(seq__15566_16304);
var vec__15568_16307 = first__15567_16305;
var k_16308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15568_16307,(0),null);
var v_16309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15568_16307,(1),null);
var r_16310 = seq__15566_16306__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_16308),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16309) : emit_js_object_val.call(null,v_16309)));

var seq__15571_16311 = cljs.core.seq(r_16310);
var chunk__15572_16312 = null;
var count__15573_16313 = (0);
var i__15574_16314 = (0);
while(true){
if((i__15574_16314 < count__15573_16313)){
var vec__15581_16315 = chunk__15572_16312.cljs$core$IIndexed$_nth$arity$2(null,i__15574_16314);
var k_16316__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15581_16315,(0),null);
var v_16317__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15581_16315,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16316__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16317__$1) : emit_js_object_val.call(null,v_16317__$1)));


var G__16318 = seq__15571_16311;
var G__16319 = chunk__15572_16312;
var G__16320 = count__15573_16313;
var G__16321 = (i__15574_16314 + (1));
seq__15571_16311 = G__16318;
chunk__15572_16312 = G__16319;
count__15573_16313 = G__16320;
i__15574_16314 = G__16321;
continue;
} else {
var temp__5735__auto___16322__$1 = cljs.core.seq(seq__15571_16311);
if(temp__5735__auto___16322__$1){
var seq__15571_16323__$1 = temp__5735__auto___16322__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15571_16323__$1)){
var c__4609__auto___16324 = cljs.core.chunk_first(seq__15571_16323__$1);
var G__16325 = cljs.core.chunk_rest(seq__15571_16323__$1);
var G__16326 = c__4609__auto___16324;
var G__16327 = cljs.core.count(c__4609__auto___16324);
var G__16328 = (0);
seq__15571_16311 = G__16325;
chunk__15572_16312 = G__16326;
count__15573_16313 = G__16327;
i__15574_16314 = G__16328;
continue;
} else {
var vec__15584_16329 = cljs.core.first(seq__15571_16323__$1);
var k_16330__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15584_16329,(0),null);
var v_16331__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15584_16329,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16330__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16331__$1) : emit_js_object_val.call(null,v_16331__$1)));


var G__16332 = cljs.core.next(seq__15571_16323__$1);
var G__16333 = null;
var G__16334 = (0);
var G__16335 = (0);
seq__15571_16311 = G__16332;
chunk__15572_16312 = G__16333;
count__15573_16313 = G__16334;
i__15574_16314 = G__16335;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__15587){
var map__15588 = p__15587;
var map__15588__$1 = (((((!((map__15588 == null))))?(((((map__15588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15588.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15588):map__15588);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__15590){
var map__15591 = p__15590;
var map__15591__$1 = (((((!((map__15591 == null))))?(((((map__15591.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15591.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15591):map__15591);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__15593){
var map__15594 = p__15593;
var map__15594__$1 = (((((!((map__15594 == null))))?(((((map__15594.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15594.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15594):map__15594);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15594__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__15596){
var map__15597 = p__15596;
var map__15597__$1 = (((((!((map__15597 == null))))?(((((map__15597.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15597.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15597):map__15597);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15597__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15597__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__15604 = cljs.analyzer.unwrap_quote(expr);
var map__15604__$1 = (((((!((map__15604 == null))))?(((((map__15604.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15604.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15604):map__15604);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15604__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15604__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15604__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__15606 = cljs.analyzer.unwrap_quote(expr);
var map__15606__$1 = (((((!((map__15606 == null))))?(((((map__15606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15606.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15606):map__15606);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15606__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15606__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15606__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__15609 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__15609.cljs$core$IFn$_invoke$arity$1 ? fexpr__15609.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15609.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__15610){
var map__15611 = p__15610;
var map__15611__$1 = (((((!((map__15611 == null))))?(((((map__15611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15611.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15611):map__15611);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__15613){
var map__15614 = p__15613;
var map__15614__$1 = (((((!((map__15614 == null))))?(((((map__15614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15614.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15614):map__15614);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__15616_16336 = cljs.core.seq(nodes);
var chunk__15617_16337 = null;
var count__15618_16338 = (0);
var i__15619_16339 = (0);
while(true){
if((i__15619_16339 < count__15618_16338)){
var map__15636_16340 = chunk__15617_16337.cljs$core$IIndexed$_nth$arity$2(null,i__15619_16339);
var map__15636_16341__$1 = (((((!((map__15636_16340 == null))))?(((((map__15636_16340.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15636_16340.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15636_16340):map__15636_16340);
var ts_16342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15636_16341__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15637_16343 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15636_16341__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15637_16344__$1 = (((((!((map__15637_16343 == null))))?(((((map__15637_16343.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15637_16343.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15637_16343):map__15637_16343);
var then_16345 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15637_16344__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15640_16346 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16342));
var chunk__15641_16347 = null;
var count__15642_16348 = (0);
var i__15643_16349 = (0);
while(true){
if((i__15643_16349 < count__15642_16348)){
var test_16350 = chunk__15641_16347.cljs$core$IIndexed$_nth$arity$2(null,i__15643_16349);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16350,":");


var G__16351 = seq__15640_16346;
var G__16352 = chunk__15641_16347;
var G__16353 = count__15642_16348;
var G__16354 = (i__15643_16349 + (1));
seq__15640_16346 = G__16351;
chunk__15641_16347 = G__16352;
count__15642_16348 = G__16353;
i__15643_16349 = G__16354;
continue;
} else {
var temp__5735__auto___16355 = cljs.core.seq(seq__15640_16346);
if(temp__5735__auto___16355){
var seq__15640_16356__$1 = temp__5735__auto___16355;
if(cljs.core.chunked_seq_QMARK_(seq__15640_16356__$1)){
var c__4609__auto___16357 = cljs.core.chunk_first(seq__15640_16356__$1);
var G__16358 = cljs.core.chunk_rest(seq__15640_16356__$1);
var G__16359 = c__4609__auto___16357;
var G__16360 = cljs.core.count(c__4609__auto___16357);
var G__16361 = (0);
seq__15640_16346 = G__16358;
chunk__15641_16347 = G__16359;
count__15642_16348 = G__16360;
i__15643_16349 = G__16361;
continue;
} else {
var test_16362 = cljs.core.first(seq__15640_16356__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16362,":");


var G__16363 = cljs.core.next(seq__15640_16356__$1);
var G__16364 = null;
var G__16365 = (0);
var G__16366 = (0);
seq__15640_16346 = G__16363;
chunk__15641_16347 = G__16364;
count__15642_16348 = G__16365;
i__15643_16349 = G__16366;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16345);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16345);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16367 = seq__15616_16336;
var G__16368 = chunk__15617_16337;
var G__16369 = count__15618_16338;
var G__16370 = (i__15619_16339 + (1));
seq__15616_16336 = G__16367;
chunk__15617_16337 = G__16368;
count__15618_16338 = G__16369;
i__15619_16339 = G__16370;
continue;
} else {
var temp__5735__auto___16371 = cljs.core.seq(seq__15616_16336);
if(temp__5735__auto___16371){
var seq__15616_16372__$1 = temp__5735__auto___16371;
if(cljs.core.chunked_seq_QMARK_(seq__15616_16372__$1)){
var c__4609__auto___16373 = cljs.core.chunk_first(seq__15616_16372__$1);
var G__16374 = cljs.core.chunk_rest(seq__15616_16372__$1);
var G__16375 = c__4609__auto___16373;
var G__16376 = cljs.core.count(c__4609__auto___16373);
var G__16377 = (0);
seq__15616_16336 = G__16374;
chunk__15617_16337 = G__16375;
count__15618_16338 = G__16376;
i__15619_16339 = G__16377;
continue;
} else {
var map__15644_16378 = cljs.core.first(seq__15616_16372__$1);
var map__15644_16379__$1 = (((((!((map__15644_16378 == null))))?(((((map__15644_16378.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15644_16378.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15644_16378):map__15644_16378);
var ts_16380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15644_16379__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15645_16381 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15644_16379__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15645_16382__$1 = (((((!((map__15645_16381 == null))))?(((((map__15645_16381.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15645_16381.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15645_16381):map__15645_16381);
var then_16383 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15645_16382__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15648_16384 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16380));
var chunk__15649_16385 = null;
var count__15650_16386 = (0);
var i__15651_16387 = (0);
while(true){
if((i__15651_16387 < count__15650_16386)){
var test_16388 = chunk__15649_16385.cljs$core$IIndexed$_nth$arity$2(null,i__15651_16387);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16388,":");


var G__16389 = seq__15648_16384;
var G__16390 = chunk__15649_16385;
var G__16391 = count__15650_16386;
var G__16392 = (i__15651_16387 + (1));
seq__15648_16384 = G__16389;
chunk__15649_16385 = G__16390;
count__15650_16386 = G__16391;
i__15651_16387 = G__16392;
continue;
} else {
var temp__5735__auto___16393__$1 = cljs.core.seq(seq__15648_16384);
if(temp__5735__auto___16393__$1){
var seq__15648_16394__$1 = temp__5735__auto___16393__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15648_16394__$1)){
var c__4609__auto___16395 = cljs.core.chunk_first(seq__15648_16394__$1);
var G__16396 = cljs.core.chunk_rest(seq__15648_16394__$1);
var G__16397 = c__4609__auto___16395;
var G__16398 = cljs.core.count(c__4609__auto___16395);
var G__16399 = (0);
seq__15648_16384 = G__16396;
chunk__15649_16385 = G__16397;
count__15650_16386 = G__16398;
i__15651_16387 = G__16399;
continue;
} else {
var test_16400 = cljs.core.first(seq__15648_16394__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16400,":");


var G__16401 = cljs.core.next(seq__15648_16394__$1);
var G__16402 = null;
var G__16403 = (0);
var G__16404 = (0);
seq__15648_16384 = G__16401;
chunk__15649_16385 = G__16402;
count__15650_16386 = G__16403;
i__15651_16387 = G__16404;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16383);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16383);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16405 = cljs.core.next(seq__15616_16372__$1);
var G__16406 = null;
var G__16407 = (0);
var G__16408 = (0);
seq__15616_16336 = G__16405;
chunk__15617_16337 = G__16406;
count__15618_16338 = G__16407;
i__15619_16339 = G__16408;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__15652){
var map__15653 = p__15652;
var map__15653__$1 = (((((!((map__15653 == null))))?(((((map__15653.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15653.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15653):map__15653);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15653__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15653__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15658 = env;
var G__15659 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15658,G__15659) : cljs.compiler.resolve_type.call(null,G__15658,G__15659));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__15660 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15660,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15660,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__15655_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__15655_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__15655_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__15663 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__15663,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__15663;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15666 = env;
var G__15667 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15666,G__15667) : cljs.compiler.resolve_type.call(null,G__15666,G__15667));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15668_SHARP_){
return cljs.compiler.resolve_type(env,p1__15668_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__15677 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15678 = cljs.core.seq(vec__15677);
var first__15679 = cljs.core.first(seq__15678);
var seq__15678__$1 = cljs.core.next(seq__15678);
var p = first__15679;
var first__15679__$1 = cljs.core.first(seq__15678__$1);
var seq__15678__$2 = cljs.core.next(seq__15678__$1);
var ts = first__15679__$1;
var first__15679__$2 = cljs.core.first(seq__15678__$2);
var seq__15678__$3 = cljs.core.next(seq__15678__$2);
var n = first__15679__$2;
var xs = seq__15678__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__15680 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15681 = cljs.core.seq(vec__15680);
var first__15682 = cljs.core.first(seq__15681);
var seq__15681__$1 = cljs.core.next(seq__15681);
var p = first__15682;
var first__15682__$1 = cljs.core.first(seq__15681__$1);
var seq__15681__$2 = cljs.core.next(seq__15681__$1);
var ts = first__15682__$1;
var xs = seq__15681__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__15684 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__15683 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__15683.cljs$core$IFn$_invoke$arity$1 ? fexpr__15683.cljs$core$IFn$_invoke$arity$1(G__15684) : fexpr__15683.call(null,G__15684));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__15687 = arguments.length;
switch (G__15687) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__15696 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15685_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__15685_SHARP_);
} else {
return p1__15685_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__15697 = cljs.core.seq(vec__15696);
var first__15698 = cljs.core.first(seq__15697);
var seq__15697__$1 = cljs.core.next(seq__15697);
var x = first__15698;
var ys = seq__15697__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__15699 = cljs.core.seq(ys);
var chunk__15700 = null;
var count__15701 = (0);
var i__15702 = (0);
while(true){
if((i__15702 < count__15701)){
var next_line = chunk__15700.cljs$core$IIndexed$_nth$arity$2(null,i__15702);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__16410 = seq__15699;
var G__16411 = chunk__15700;
var G__16412 = count__15701;
var G__16413 = (i__15702 + (1));
seq__15699 = G__16410;
chunk__15700 = G__16411;
count__15701 = G__16412;
i__15702 = G__16413;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15699);
if(temp__5735__auto__){
var seq__15699__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15699__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15699__$1);
var G__16414 = cljs.core.chunk_rest(seq__15699__$1);
var G__16415 = c__4609__auto__;
var G__16416 = cljs.core.count(c__4609__auto__);
var G__16417 = (0);
seq__15699 = G__16414;
chunk__15700 = G__16415;
count__15701 = G__16416;
i__15702 = G__16417;
continue;
} else {
var next_line = cljs.core.first(seq__15699__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__16418 = cljs.core.next(seq__15699__$1);
var G__16419 = null;
var G__16420 = (0);
var G__16421 = (0);
seq__15699 = G__16418;
chunk__15700 = G__16419;
count__15701 = G__16420;
i__15702 = G__16421;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__15704_16422 = cljs.core.seq(docs__$2);
var chunk__15705_16423 = null;
var count__15706_16424 = (0);
var i__15707_16425 = (0);
while(true){
if((i__15707_16425 < count__15706_16424)){
var e_16426 = chunk__15705_16423.cljs$core$IIndexed$_nth$arity$2(null,i__15707_16425);
if(cljs.core.truth_(e_16426)){
print_comment_lines(e_16426);
} else {
}


var G__16427 = seq__15704_16422;
var G__16428 = chunk__15705_16423;
var G__16429 = count__15706_16424;
var G__16430 = (i__15707_16425 + (1));
seq__15704_16422 = G__16427;
chunk__15705_16423 = G__16428;
count__15706_16424 = G__16429;
i__15707_16425 = G__16430;
continue;
} else {
var temp__5735__auto___16431 = cljs.core.seq(seq__15704_16422);
if(temp__5735__auto___16431){
var seq__15704_16432__$1 = temp__5735__auto___16431;
if(cljs.core.chunked_seq_QMARK_(seq__15704_16432__$1)){
var c__4609__auto___16433 = cljs.core.chunk_first(seq__15704_16432__$1);
var G__16434 = cljs.core.chunk_rest(seq__15704_16432__$1);
var G__16435 = c__4609__auto___16433;
var G__16436 = cljs.core.count(c__4609__auto___16433);
var G__16437 = (0);
seq__15704_16422 = G__16434;
chunk__15705_16423 = G__16435;
count__15706_16424 = G__16436;
i__15707_16425 = G__16437;
continue;
} else {
var e_16438 = cljs.core.first(seq__15704_16432__$1);
if(cljs.core.truth_(e_16438)){
print_comment_lines(e_16438);
} else {
}


var G__16439 = cljs.core.next(seq__15704_16432__$1);
var G__16440 = null;
var G__16441 = (0);
var G__16442 = (0);
seq__15704_16422 = G__16439;
chunk__15705_16423 = G__16440;
count__15706_16424 = G__16441;
i__15707_16425 = G__16442;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__15713_SHARP_){
return goog.string.startsWith(p1__15713_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__15714){
var map__15715 = p__15714;
var map__15715__$1 = (((((!((map__15715 == null))))?(((((map__15715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15715.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15715):map__15715);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__15719){
var map__15720 = p__15719;
var map__15720__$1 = (((((!((map__15720 == null))))?(((((map__15720.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15720.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15720):map__15720);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15720__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15720__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15720__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__15722_16443 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__15723_16444 = null;
var count__15724_16445 = (0);
var i__15725_16446 = (0);
while(true){
if((i__15725_16446 < count__15724_16445)){
var vec__15732_16447 = chunk__15723_16444.cljs$core$IIndexed$_nth$arity$2(null,i__15725_16446);
var i_16448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15732_16447,(0),null);
var param_16449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15732_16447,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_16449);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__16450 = seq__15722_16443;
var G__16451 = chunk__15723_16444;
var G__16452 = count__15724_16445;
var G__16453 = (i__15725_16446 + (1));
seq__15722_16443 = G__16450;
chunk__15723_16444 = G__16451;
count__15724_16445 = G__16452;
i__15725_16446 = G__16453;
continue;
} else {
var temp__5735__auto___16454 = cljs.core.seq(seq__15722_16443);
if(temp__5735__auto___16454){
var seq__15722_16455__$1 = temp__5735__auto___16454;
if(cljs.core.chunked_seq_QMARK_(seq__15722_16455__$1)){
var c__4609__auto___16456 = cljs.core.chunk_first(seq__15722_16455__$1);
var G__16457 = cljs.core.chunk_rest(seq__15722_16455__$1);
var G__16458 = c__4609__auto___16456;
var G__16459 = cljs.core.count(c__4609__auto___16456);
var G__16460 = (0);
seq__15722_16443 = G__16457;
chunk__15723_16444 = G__16458;
count__15724_16445 = G__16459;
i__15725_16446 = G__16460;
continue;
} else {
var vec__15735_16461 = cljs.core.first(seq__15722_16455__$1);
var i_16462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15735_16461,(0),null);
var param_16463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15735_16461,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_16463);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__16464 = cljs.core.next(seq__15722_16455__$1);
var G__16465 = null;
var G__16466 = (0);
var G__16467 = (0);
seq__15722_16443 = G__16464;
chunk__15723_16444 = G__16465;
count__15724_16445 = G__16466;
i__15725_16446 = G__16467;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15738_16468 = cljs.core.seq(params);
var chunk__15739_16469 = null;
var count__15740_16470 = (0);
var i__15741_16471 = (0);
while(true){
if((i__15741_16471 < count__15740_16470)){
var param_16472 = chunk__15739_16469.cljs$core$IIndexed$_nth$arity$2(null,i__15741_16471);
cljs.compiler.emit(param_16472);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16472,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16473 = seq__15738_16468;
var G__16474 = chunk__15739_16469;
var G__16475 = count__15740_16470;
var G__16476 = (i__15741_16471 + (1));
seq__15738_16468 = G__16473;
chunk__15739_16469 = G__16474;
count__15740_16470 = G__16475;
i__15741_16471 = G__16476;
continue;
} else {
var temp__5735__auto___16477 = cljs.core.seq(seq__15738_16468);
if(temp__5735__auto___16477){
var seq__15738_16478__$1 = temp__5735__auto___16477;
if(cljs.core.chunked_seq_QMARK_(seq__15738_16478__$1)){
var c__4609__auto___16479 = cljs.core.chunk_first(seq__15738_16478__$1);
var G__16480 = cljs.core.chunk_rest(seq__15738_16478__$1);
var G__16481 = c__4609__auto___16479;
var G__16482 = cljs.core.count(c__4609__auto___16479);
var G__16483 = (0);
seq__15738_16468 = G__16480;
chunk__15739_16469 = G__16481;
count__15740_16470 = G__16482;
i__15741_16471 = G__16483;
continue;
} else {
var param_16484 = cljs.core.first(seq__15738_16478__$1);
cljs.compiler.emit(param_16484);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16484,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16485 = cljs.core.next(seq__15738_16478__$1);
var G__16486 = null;
var G__16487 = (0);
var G__16488 = (0);
seq__15738_16468 = G__16485;
chunk__15739_16469 = G__16486;
count__15740_16470 = G__16487;
i__15741_16471 = G__16488;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15742_16489 = cljs.core.seq(params);
var chunk__15743_16490 = null;
var count__15744_16491 = (0);
var i__15745_16492 = (0);
while(true){
if((i__15745_16492 < count__15744_16491)){
var param_16493 = chunk__15743_16490.cljs$core$IIndexed$_nth$arity$2(null,i__15745_16492);
cljs.compiler.emit(param_16493);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16493,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16494 = seq__15742_16489;
var G__16495 = chunk__15743_16490;
var G__16496 = count__15744_16491;
var G__16497 = (i__15745_16492 + (1));
seq__15742_16489 = G__16494;
chunk__15743_16490 = G__16495;
count__15744_16491 = G__16496;
i__15745_16492 = G__16497;
continue;
} else {
var temp__5735__auto___16498 = cljs.core.seq(seq__15742_16489);
if(temp__5735__auto___16498){
var seq__15742_16499__$1 = temp__5735__auto___16498;
if(cljs.core.chunked_seq_QMARK_(seq__15742_16499__$1)){
var c__4609__auto___16500 = cljs.core.chunk_first(seq__15742_16499__$1);
var G__16501 = cljs.core.chunk_rest(seq__15742_16499__$1);
var G__16502 = c__4609__auto___16500;
var G__16503 = cljs.core.count(c__4609__auto___16500);
var G__16504 = (0);
seq__15742_16489 = G__16501;
chunk__15743_16490 = G__16502;
count__15744_16491 = G__16503;
i__15745_16492 = G__16504;
continue;
} else {
var param_16505 = cljs.core.first(seq__15742_16499__$1);
cljs.compiler.emit(param_16505);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16505,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16506 = cljs.core.next(seq__15742_16499__$1);
var G__16507 = null;
var G__16508 = (0);
var G__16509 = (0);
seq__15742_16489 = G__16506;
chunk__15743_16490 = G__16507;
count__15744_16491 = G__16508;
i__15745_16492 = G__16509;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__15749 = cljs.core.seq(params);
var chunk__15750 = null;
var count__15751 = (0);
var i__15752 = (0);
while(true){
if((i__15752 < count__15751)){
var param = chunk__15750.cljs$core$IIndexed$_nth$arity$2(null,i__15752);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16510 = seq__15749;
var G__16511 = chunk__15750;
var G__16512 = count__15751;
var G__16513 = (i__15752 + (1));
seq__15749 = G__16510;
chunk__15750 = G__16511;
count__15751 = G__16512;
i__15752 = G__16513;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15749);
if(temp__5735__auto__){
var seq__15749__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15749__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15749__$1);
var G__16514 = cljs.core.chunk_rest(seq__15749__$1);
var G__16515 = c__4609__auto__;
var G__16516 = cljs.core.count(c__4609__auto__);
var G__16517 = (0);
seq__15749 = G__16514;
chunk__15750 = G__16515;
count__15751 = G__16516;
i__15752 = G__16517;
continue;
} else {
var param = cljs.core.first(seq__15749__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16518 = cljs.core.next(seq__15749__$1);
var G__16519 = null;
var G__16520 = (0);
var G__16521 = (0);
seq__15749 = G__16518;
chunk__15750 = G__16519;
count__15751 = G__16520;
i__15752 = G__16521;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__15753){
var map__15754 = p__15753;
var map__15754__$1 = (((((!((map__15754 == null))))?(((((map__15754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15754.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15754):map__15754);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__15756){
var map__15757 = p__15756;
var map__15757__$1 = (((((!((map__15757 == null))))?(((((map__15757.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15757.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15757):map__15757);
var f = map__15757__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15757__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15757__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15757__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15757__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15757__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15757__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15757__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15757__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_16522__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16523 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16522__$1);
var delegate_name_16524 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16523),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_16524," = function (");

var seq__15759_16525 = cljs.core.seq(params);
var chunk__15760_16526 = null;
var count__15761_16527 = (0);
var i__15762_16528 = (0);
while(true){
if((i__15762_16528 < count__15761_16527)){
var param_16529 = chunk__15760_16526.cljs$core$IIndexed$_nth$arity$2(null,i__15762_16528);
cljs.compiler.emit(param_16529);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16529,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16530 = seq__15759_16525;
var G__16531 = chunk__15760_16526;
var G__16532 = count__15761_16527;
var G__16533 = (i__15762_16528 + (1));
seq__15759_16525 = G__16530;
chunk__15760_16526 = G__16531;
count__15761_16527 = G__16532;
i__15762_16528 = G__16533;
continue;
} else {
var temp__5735__auto___16534 = cljs.core.seq(seq__15759_16525);
if(temp__5735__auto___16534){
var seq__15759_16535__$1 = temp__5735__auto___16534;
if(cljs.core.chunked_seq_QMARK_(seq__15759_16535__$1)){
var c__4609__auto___16536 = cljs.core.chunk_first(seq__15759_16535__$1);
var G__16537 = cljs.core.chunk_rest(seq__15759_16535__$1);
var G__16538 = c__4609__auto___16536;
var G__16539 = cljs.core.count(c__4609__auto___16536);
var G__16540 = (0);
seq__15759_16525 = G__16537;
chunk__15760_16526 = G__16538;
count__15761_16527 = G__16539;
i__15762_16528 = G__16540;
continue;
} else {
var param_16541 = cljs.core.first(seq__15759_16535__$1);
cljs.compiler.emit(param_16541);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16541,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16542 = cljs.core.next(seq__15759_16535__$1);
var G__16543 = null;
var G__16544 = (0);
var G__16545 = (0);
seq__15759_16525 = G__16542;
chunk__15760_16526 = G__16543;
count__15761_16527 = G__16544;
i__15762_16528 = G__16545;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_16523," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_16546 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_16546,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_16524,".call(this,");

var seq__15770_16547 = cljs.core.seq(params);
var chunk__15771_16548 = null;
var count__15772_16549 = (0);
var i__15773_16550 = (0);
while(true){
if((i__15773_16550 < count__15772_16549)){
var param_16551 = chunk__15771_16548.cljs$core$IIndexed$_nth$arity$2(null,i__15773_16550);
cljs.compiler.emit(param_16551);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16551,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16552 = seq__15770_16547;
var G__16553 = chunk__15771_16548;
var G__16554 = count__15772_16549;
var G__16555 = (i__15773_16550 + (1));
seq__15770_16547 = G__16552;
chunk__15771_16548 = G__16553;
count__15772_16549 = G__16554;
i__15773_16550 = G__16555;
continue;
} else {
var temp__5735__auto___16556 = cljs.core.seq(seq__15770_16547);
if(temp__5735__auto___16556){
var seq__15770_16557__$1 = temp__5735__auto___16556;
if(cljs.core.chunked_seq_QMARK_(seq__15770_16557__$1)){
var c__4609__auto___16558 = cljs.core.chunk_first(seq__15770_16557__$1);
var G__16559 = cljs.core.chunk_rest(seq__15770_16557__$1);
var G__16560 = c__4609__auto___16558;
var G__16561 = cljs.core.count(c__4609__auto___16558);
var G__16562 = (0);
seq__15770_16547 = G__16559;
chunk__15771_16548 = G__16560;
count__15772_16549 = G__16561;
i__15773_16550 = G__16562;
continue;
} else {
var param_16563 = cljs.core.first(seq__15770_16557__$1);
cljs.compiler.emit(param_16563);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16563,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16564 = cljs.core.next(seq__15770_16557__$1);
var G__16565 = null;
var G__16566 = (0);
var G__16567 = (0);
seq__15770_16547 = G__16564;
chunk__15771_16548 = G__16565;
count__15772_16549 = G__16566;
i__15773_16550 = G__16567;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16523,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_16523,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_16522__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16523,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_16524,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16523,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__15777){
var map__15778 = p__15777;
var map__15778__$1 = (((((!((map__15778 == null))))?(((((map__15778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15778.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15778):map__15778);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__15774_SHARP_){
var and__4174__auto__ = p1__15774_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__15774_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_16568__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16569 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16568__$1);
var maxparams_16570 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_16571 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16569),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_16572 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__15775_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__15775_SHARP_)));
}),cljs.core.seq(mmap_16571));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_16569," = null;");

var seq__15784_16573 = cljs.core.seq(ms_16572);
var chunk__15785_16574 = null;
var count__15786_16575 = (0);
var i__15787_16576 = (0);
while(true){
if((i__15787_16576 < count__15786_16575)){
var vec__15806_16577 = chunk__15785_16574.cljs$core$IIndexed$_nth$arity$2(null,i__15787_16576);
var n_16578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15806_16577,(0),null);
var meth_16579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15806_16577,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16578," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16579))){
cljs.compiler.emit_variadic_fn_method(meth_16579);
} else {
cljs.compiler.emit_fn_method(meth_16579);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16580 = seq__15784_16573;
var G__16581 = chunk__15785_16574;
var G__16582 = count__15786_16575;
var G__16583 = (i__15787_16576 + (1));
seq__15784_16573 = G__16580;
chunk__15785_16574 = G__16581;
count__15786_16575 = G__16582;
i__15787_16576 = G__16583;
continue;
} else {
var temp__5735__auto___16584 = cljs.core.seq(seq__15784_16573);
if(temp__5735__auto___16584){
var seq__15784_16585__$1 = temp__5735__auto___16584;
if(cljs.core.chunked_seq_QMARK_(seq__15784_16585__$1)){
var c__4609__auto___16586 = cljs.core.chunk_first(seq__15784_16585__$1);
var G__16587 = cljs.core.chunk_rest(seq__15784_16585__$1);
var G__16588 = c__4609__auto___16586;
var G__16589 = cljs.core.count(c__4609__auto___16586);
var G__16590 = (0);
seq__15784_16573 = G__16587;
chunk__15785_16574 = G__16588;
count__15786_16575 = G__16589;
i__15787_16576 = G__16590;
continue;
} else {
var vec__15813_16591 = cljs.core.first(seq__15784_16585__$1);
var n_16592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15813_16591,(0),null);
var meth_16593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15813_16591,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16592," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16593))){
cljs.compiler.emit_variadic_fn_method(meth_16593);
} else {
cljs.compiler.emit_fn_method(meth_16593);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16594 = cljs.core.next(seq__15784_16585__$1);
var G__16595 = null;
var G__16596 = (0);
var G__16597 = (0);
seq__15784_16573 = G__16594;
chunk__15785_16574 = G__16595;
count__15786_16575 = G__16596;
i__15787_16576 = G__16597;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16569," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_16570),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_16570)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_16570));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__15816_16598 = cljs.core.seq(ms_16572);
var chunk__15817_16599 = null;
var count__15818_16600 = (0);
var i__15819_16601 = (0);
while(true){
if((i__15819_16601 < count__15818_16600)){
var vec__15860_16602 = chunk__15817_16599.cljs$core$IIndexed$_nth$arity$2(null,i__15819_16601);
var n_16603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15860_16602,(0),null);
var meth_16604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15860_16602,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16604))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16605 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16605," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16606 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16605," = new cljs.core.IndexedSeq(",a_16606,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16603,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16570)),(((cljs.core.count(maxparams_16570) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16605,");"], 0));
} else {
var pcnt_16607 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16604));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16607,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16603,".call(this",(((pcnt_16607 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16607,maxparams_16570)),null,(1),null)),(2),null))),");");
}


var G__16608 = seq__15816_16598;
var G__16609 = chunk__15817_16599;
var G__16610 = count__15818_16600;
var G__16611 = (i__15819_16601 + (1));
seq__15816_16598 = G__16608;
chunk__15817_16599 = G__16609;
count__15818_16600 = G__16610;
i__15819_16601 = G__16611;
continue;
} else {
var temp__5735__auto___16612 = cljs.core.seq(seq__15816_16598);
if(temp__5735__auto___16612){
var seq__15816_16613__$1 = temp__5735__auto___16612;
if(cljs.core.chunked_seq_QMARK_(seq__15816_16613__$1)){
var c__4609__auto___16614 = cljs.core.chunk_first(seq__15816_16613__$1);
var G__16615 = cljs.core.chunk_rest(seq__15816_16613__$1);
var G__16616 = c__4609__auto___16614;
var G__16617 = cljs.core.count(c__4609__auto___16614);
var G__16618 = (0);
seq__15816_16598 = G__16615;
chunk__15817_16599 = G__16616;
count__15818_16600 = G__16617;
i__15819_16601 = G__16618;
continue;
} else {
var vec__15867_16619 = cljs.core.first(seq__15816_16613__$1);
var n_16620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15867_16619,(0),null);
var meth_16621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15867_16619,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16621))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16622 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16622," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16623 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16622," = new cljs.core.IndexedSeq(",a_16623,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16620,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16570)),(((cljs.core.count(maxparams_16570) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16622,");"], 0));
} else {
var pcnt_16624 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16621));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16624,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16620,".call(this",(((pcnt_16624 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16624,maxparams_16570)),null,(1),null)),(2),null))),");");
}


var G__16625 = cljs.core.next(seq__15816_16613__$1);
var G__16626 = null;
var G__16627 = (0);
var G__16628 = (0);
seq__15816_16598 = G__16625;
chunk__15817_16599 = G__16626;
count__15818_16600 = G__16627;
i__15819_16601 = G__16628;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_16629 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_16572)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_16629,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16569,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16569,".cljs$lang$applyTo = ",cljs.core.some((function (p1__15776_SHARP_){
var vec__15870 = p1__15776_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15870,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15870,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_16572),".cljs$lang$applyTo;");
} else {
}

var seq__15873_16630 = cljs.core.seq(ms_16572);
var chunk__15874_16631 = null;
var count__15875_16632 = (0);
var i__15876_16633 = (0);
while(true){
if((i__15876_16633 < count__15875_16632)){
var vec__15901_16634 = chunk__15874_16631.cljs$core$IIndexed$_nth$arity$2(null,i__15876_16633);
var n_16635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15901_16634,(0),null);
var meth_16636 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15901_16634,(1),null);
var c_16637 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16636));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16636))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16569,".cljs$core$IFn$_invoke$arity$variadic = ",n_16635,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16569,".cljs$core$IFn$_invoke$arity$",c_16637," = ",n_16635,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16638 = seq__15873_16630;
var G__16639 = chunk__15874_16631;
var G__16640 = count__15875_16632;
var G__16641 = (i__15876_16633 + (1));
seq__15873_16630 = G__16638;
chunk__15874_16631 = G__16639;
count__15875_16632 = G__16640;
i__15876_16633 = G__16641;
continue;
} else {
var temp__5735__auto___16642 = cljs.core.seq(seq__15873_16630);
if(temp__5735__auto___16642){
var seq__15873_16643__$1 = temp__5735__auto___16642;
if(cljs.core.chunked_seq_QMARK_(seq__15873_16643__$1)){
var c__4609__auto___16644 = cljs.core.chunk_first(seq__15873_16643__$1);
var G__16645 = cljs.core.chunk_rest(seq__15873_16643__$1);
var G__16646 = c__4609__auto___16644;
var G__16647 = cljs.core.count(c__4609__auto___16644);
var G__16648 = (0);
seq__15873_16630 = G__16645;
chunk__15874_16631 = G__16646;
count__15875_16632 = G__16647;
i__15876_16633 = G__16648;
continue;
} else {
var vec__15915_16649 = cljs.core.first(seq__15873_16643__$1);
var n_16650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15915_16649,(0),null);
var meth_16651 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15915_16649,(1),null);
var c_16652 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16651));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16651))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16569,".cljs$core$IFn$_invoke$arity$variadic = ",n_16650,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16569,".cljs$core$IFn$_invoke$arity$",c_16652," = ",n_16650,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16653 = cljs.core.next(seq__15873_16643__$1);
var G__16654 = null;
var G__16655 = (0);
var G__16656 = (0);
seq__15873_16630 = G__16653;
chunk__15874_16631 = G__16654;
count__15875_16632 = G__16655;
i__15876_16633 = G__16656;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16569,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__15924){
var map__15928 = p__15924;
var map__15928__$1 = (((((!((map__15928 == null))))?(((((map__15928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15928.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15928):map__15928);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15928__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15928__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15928__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15944_16657 = cljs.core.seq(statements);
var chunk__15945_16658 = null;
var count__15946_16659 = (0);
var i__15947_16660 = (0);
while(true){
if((i__15947_16660 < count__15946_16659)){
var s_16661 = chunk__15945_16658.cljs$core$IIndexed$_nth$arity$2(null,i__15947_16660);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16661);


var G__16662 = seq__15944_16657;
var G__16663 = chunk__15945_16658;
var G__16664 = count__15946_16659;
var G__16665 = (i__15947_16660 + (1));
seq__15944_16657 = G__16662;
chunk__15945_16658 = G__16663;
count__15946_16659 = G__16664;
i__15947_16660 = G__16665;
continue;
} else {
var temp__5735__auto___16666 = cljs.core.seq(seq__15944_16657);
if(temp__5735__auto___16666){
var seq__15944_16667__$1 = temp__5735__auto___16666;
if(cljs.core.chunked_seq_QMARK_(seq__15944_16667__$1)){
var c__4609__auto___16668 = cljs.core.chunk_first(seq__15944_16667__$1);
var G__16669 = cljs.core.chunk_rest(seq__15944_16667__$1);
var G__16670 = c__4609__auto___16668;
var G__16671 = cljs.core.count(c__4609__auto___16668);
var G__16672 = (0);
seq__15944_16657 = G__16669;
chunk__15945_16658 = G__16670;
count__15946_16659 = G__16671;
i__15947_16660 = G__16672;
continue;
} else {
var s_16673 = cljs.core.first(seq__15944_16667__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16673);


var G__16674 = cljs.core.next(seq__15944_16667__$1);
var G__16675 = null;
var G__16676 = (0);
var G__16677 = (0);
seq__15944_16657 = G__16674;
chunk__15945_16658 = G__16675;
count__15946_16659 = G__16676;
i__15947_16660 = G__16677;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__15952){
var map__15953 = p__15952;
var map__15953__$1 = (((((!((map__15953 == null))))?(((((map__15953.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15953.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15953):map__15953);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15953__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15953__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15953__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15953__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15953__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__15969,is_loop){
var map__15970 = p__15969;
var map__15970__$1 = (((((!((map__15970 == null))))?(((((map__15970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15970):map__15970);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15970__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15970__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15970__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__15973_16678 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__15974_16679 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__15974_16679);

try{var seq__15976_16680 = cljs.core.seq(bindings);
var chunk__15977_16681 = null;
var count__15978_16682 = (0);
var i__15979_16683 = (0);
while(true){
if((i__15979_16683 < count__15978_16682)){
var map__15984_16684 = chunk__15977_16681.cljs$core$IIndexed$_nth$arity$2(null,i__15979_16683);
var map__15984_16685__$1 = (((((!((map__15984_16684 == null))))?(((((map__15984_16684.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15984_16684.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15984_16684):map__15984_16684);
var binding_16686 = map__15984_16685__$1;
var init_16687 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15984_16685__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16686);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16687,";");


var G__16688 = seq__15976_16680;
var G__16689 = chunk__15977_16681;
var G__16690 = count__15978_16682;
var G__16691 = (i__15979_16683 + (1));
seq__15976_16680 = G__16688;
chunk__15977_16681 = G__16689;
count__15978_16682 = G__16690;
i__15979_16683 = G__16691;
continue;
} else {
var temp__5735__auto___16692 = cljs.core.seq(seq__15976_16680);
if(temp__5735__auto___16692){
var seq__15976_16693__$1 = temp__5735__auto___16692;
if(cljs.core.chunked_seq_QMARK_(seq__15976_16693__$1)){
var c__4609__auto___16694 = cljs.core.chunk_first(seq__15976_16693__$1);
var G__16695 = cljs.core.chunk_rest(seq__15976_16693__$1);
var G__16696 = c__4609__auto___16694;
var G__16697 = cljs.core.count(c__4609__auto___16694);
var G__16698 = (0);
seq__15976_16680 = G__16695;
chunk__15977_16681 = G__16696;
count__15978_16682 = G__16697;
i__15979_16683 = G__16698;
continue;
} else {
var map__15988_16699 = cljs.core.first(seq__15976_16693__$1);
var map__15988_16700__$1 = (((((!((map__15988_16699 == null))))?(((((map__15988_16699.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15988_16699.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15988_16699):map__15988_16699);
var binding_16701 = map__15988_16700__$1;
var init_16702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15988_16700__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16701);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16702,";");


var G__16703 = cljs.core.next(seq__15976_16693__$1);
var G__16704 = null;
var G__16705 = (0);
var G__16706 = (0);
seq__15976_16680 = G__16703;
chunk__15977_16681 = G__16704;
count__15978_16682 = G__16705;
i__15979_16683 = G__16706;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__15973_16678);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__15990){
var map__15991 = p__15990;
var map__15991__$1 = (((((!((map__15991 == null))))?(((((map__15991.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15991.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15991):map__15991);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15991__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15991__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15991__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___16707 = cljs.core.count(exprs);
var i_16708 = (0);
while(true){
if((i_16708 < n__4666__auto___16707)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16708) : temps.call(null,i_16708))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_16708) : exprs.call(null,i_16708)),";");

var G__16709 = (i_16708 + (1));
i_16708 = G__16709;
continue;
} else {
}
break;
}

var n__4666__auto___16710 = cljs.core.count(exprs);
var i_16711 = (0);
while(true){
if((i_16711 < n__4666__auto___16710)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_16711) : params.call(null,i_16711)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16711) : temps.call(null,i_16711)),";");

var G__16712 = (i_16711 + (1));
i_16711 = G__16712;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__16001){
var map__16002 = p__16001;
var map__16002__$1 = (((((!((map__16002 == null))))?(((((map__16002.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16002.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16002):map__16002);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16002__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16002__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16002__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__16018_16713 = cljs.core.seq(bindings);
var chunk__16019_16714 = null;
var count__16020_16715 = (0);
var i__16021_16716 = (0);
while(true){
if((i__16021_16716 < count__16020_16715)){
var map__16028_16717 = chunk__16019_16714.cljs$core$IIndexed$_nth$arity$2(null,i__16021_16716);
var map__16028_16718__$1 = (((((!((map__16028_16717 == null))))?(((((map__16028_16717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16028_16717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16028_16717):map__16028_16717);
var binding_16719 = map__16028_16718__$1;
var init_16720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16028_16718__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16719)," = ",init_16720,";");


var G__16721 = seq__16018_16713;
var G__16722 = chunk__16019_16714;
var G__16723 = count__16020_16715;
var G__16724 = (i__16021_16716 + (1));
seq__16018_16713 = G__16721;
chunk__16019_16714 = G__16722;
count__16020_16715 = G__16723;
i__16021_16716 = G__16724;
continue;
} else {
var temp__5735__auto___16725 = cljs.core.seq(seq__16018_16713);
if(temp__5735__auto___16725){
var seq__16018_16726__$1 = temp__5735__auto___16725;
if(cljs.core.chunked_seq_QMARK_(seq__16018_16726__$1)){
var c__4609__auto___16727 = cljs.core.chunk_first(seq__16018_16726__$1);
var G__16728 = cljs.core.chunk_rest(seq__16018_16726__$1);
var G__16729 = c__4609__auto___16727;
var G__16730 = cljs.core.count(c__4609__auto___16727);
var G__16731 = (0);
seq__16018_16713 = G__16728;
chunk__16019_16714 = G__16729;
count__16020_16715 = G__16730;
i__16021_16716 = G__16731;
continue;
} else {
var map__16030_16732 = cljs.core.first(seq__16018_16726__$1);
var map__16030_16733__$1 = (((((!((map__16030_16732 == null))))?(((((map__16030_16732.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16030_16732.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16030_16732):map__16030_16732);
var binding_16734 = map__16030_16733__$1;
var init_16735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16030_16733__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16734)," = ",init_16735,";");


var G__16736 = cljs.core.next(seq__16018_16726__$1);
var G__16737 = null;
var G__16738 = (0);
var G__16739 = (0);
seq__16018_16713 = G__16736;
chunk__16019_16714 = G__16737;
count__16020_16715 = G__16738;
i__16021_16716 = G__16739;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__16034){
var map__16035 = p__16034;
var map__16035__$1 = (((((!((map__16035 == null))))?(((((map__16035.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16035.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16035):map__16035);
var expr = map__16035__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16035__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16035__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16035__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__16050 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__16050.cljs$core$IFn$_invoke$arity$1 ? fexpr__16050.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__16050.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__16052 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__16052.cljs$core$IFn$_invoke$arity$1 ? fexpr__16052.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__16052.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__16037 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__16032_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__16032_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__16033_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__16033_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16037,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16037,(1),null);
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_16740 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_16740,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_16741 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_16741,args)),(((mfa_16741 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_16741,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__16056 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__16055 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__16055.cljs$core$IFn$_invoke$arity$1 ? fexpr__16055.cljs$core$IFn$_invoke$arity$1(G__16056) : fexpr__16055.call(null,G__16056));
} else {
return and__4174__auto__;
}
})())){
var fprop_16742 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16742," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16742,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16742," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16742,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__16057){
var map__16058 = p__16057;
var map__16058__$1 = (((((!((map__16058 == null))))?(((((map__16058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16058.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16058):map__16058);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16058__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16058__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16058__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__16060){
var map__16061 = p__16060;
var map__16061__$1 = (((((!((map__16061 == null))))?(((((map__16061.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16061.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16061):map__16061);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16061__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16061__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16061__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__16073 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__16073__$1 = (((((!((map__16073 == null))))?(((((map__16073.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16073.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16073):map__16073);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16073__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16073__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__16074 = options;
var map__16074__$1 = (((((!((map__16074 == null))))?(((((map__16074.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16074.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16074):map__16074);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16074__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16074__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__16075 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__16081 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__16081__$1 = (((((!((map__16081 == null))))?(((((map__16081.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16081.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16081):map__16081);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16081__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16081__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16075,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16075,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__16083_16743 = cljs.core.seq(libs_to_load);
var chunk__16084_16744 = null;
var count__16085_16745 = (0);
var i__16086_16746 = (0);
while(true){
if((i__16086_16746 < count__16085_16745)){
var lib_16747 = chunk__16084_16744.cljs$core$IIndexed$_nth$arity$2(null,i__16086_16746);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16747)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16747),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16747),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16747),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16747),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16747,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16747),"');");
}

}
}
}


var G__16748 = seq__16083_16743;
var G__16749 = chunk__16084_16744;
var G__16750 = count__16085_16745;
var G__16751 = (i__16086_16746 + (1));
seq__16083_16743 = G__16748;
chunk__16084_16744 = G__16749;
count__16085_16745 = G__16750;
i__16086_16746 = G__16751;
continue;
} else {
var temp__5735__auto___16752 = cljs.core.seq(seq__16083_16743);
if(temp__5735__auto___16752){
var seq__16083_16753__$1 = temp__5735__auto___16752;
if(cljs.core.chunked_seq_QMARK_(seq__16083_16753__$1)){
var c__4609__auto___16754 = cljs.core.chunk_first(seq__16083_16753__$1);
var G__16755 = cljs.core.chunk_rest(seq__16083_16753__$1);
var G__16756 = c__4609__auto___16754;
var G__16757 = cljs.core.count(c__4609__auto___16754);
var G__16758 = (0);
seq__16083_16743 = G__16755;
chunk__16084_16744 = G__16756;
count__16085_16745 = G__16757;
i__16086_16746 = G__16758;
continue;
} else {
var lib_16759 = cljs.core.first(seq__16083_16753__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16759)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16759),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16759),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16759),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16759),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16759,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16759),"');");
}

}
}
}


var G__16760 = cljs.core.next(seq__16083_16753__$1);
var G__16761 = null;
var G__16762 = (0);
var G__16763 = (0);
seq__16083_16743 = G__16760;
chunk__16084_16744 = G__16761;
count__16085_16745 = G__16762;
i__16086_16746 = G__16763;
continue;
}
} else {
}
}
break;
}

var seq__16088_16764 = cljs.core.seq(node_libs);
var chunk__16089_16765 = null;
var count__16090_16766 = (0);
var i__16091_16767 = (0);
while(true){
if((i__16091_16767 < count__16090_16766)){
var lib_16768 = chunk__16089_16765.cljs$core$IIndexed$_nth$arity$2(null,i__16091_16767);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16768)," = require('",lib_16768,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16769 = seq__16088_16764;
var G__16770 = chunk__16089_16765;
var G__16771 = count__16090_16766;
var G__16772 = (i__16091_16767 + (1));
seq__16088_16764 = G__16769;
chunk__16089_16765 = G__16770;
count__16090_16766 = G__16771;
i__16091_16767 = G__16772;
continue;
} else {
var temp__5735__auto___16773 = cljs.core.seq(seq__16088_16764);
if(temp__5735__auto___16773){
var seq__16088_16774__$1 = temp__5735__auto___16773;
if(cljs.core.chunked_seq_QMARK_(seq__16088_16774__$1)){
var c__4609__auto___16775 = cljs.core.chunk_first(seq__16088_16774__$1);
var G__16776 = cljs.core.chunk_rest(seq__16088_16774__$1);
var G__16777 = c__4609__auto___16775;
var G__16778 = cljs.core.count(c__4609__auto___16775);
var G__16779 = (0);
seq__16088_16764 = G__16776;
chunk__16089_16765 = G__16777;
count__16090_16766 = G__16778;
i__16091_16767 = G__16779;
continue;
} else {
var lib_16780 = cljs.core.first(seq__16088_16774__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16780)," = require('",lib_16780,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16781 = cljs.core.next(seq__16088_16774__$1);
var G__16782 = null;
var G__16783 = (0);
var G__16784 = (0);
seq__16088_16764 = G__16781;
chunk__16089_16765 = G__16782;
count__16090_16766 = G__16783;
i__16091_16767 = G__16784;
continue;
}
} else {
}
}
break;
}

var seq__16092_16785 = cljs.core.seq(global_exports_libs);
var chunk__16093_16786 = null;
var count__16094_16787 = (0);
var i__16095_16788 = (0);
while(true){
if((i__16095_16788 < count__16094_16787)){
var lib_16789 = chunk__16093_16786.cljs$core$IIndexed$_nth$arity$2(null,i__16095_16788);
var map__16101_16790 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16789));
var map__16101_16791__$1 = (((((!((map__16101_16790 == null))))?(((((map__16101_16790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16101_16790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16101_16790):map__16101_16790);
var global_exports_16792 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16101_16791__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16792,lib_16789);


var G__16793 = seq__16092_16785;
var G__16794 = chunk__16093_16786;
var G__16795 = count__16094_16787;
var G__16796 = (i__16095_16788 + (1));
seq__16092_16785 = G__16793;
chunk__16093_16786 = G__16794;
count__16094_16787 = G__16795;
i__16095_16788 = G__16796;
continue;
} else {
var temp__5735__auto___16797 = cljs.core.seq(seq__16092_16785);
if(temp__5735__auto___16797){
var seq__16092_16798__$1 = temp__5735__auto___16797;
if(cljs.core.chunked_seq_QMARK_(seq__16092_16798__$1)){
var c__4609__auto___16799 = cljs.core.chunk_first(seq__16092_16798__$1);
var G__16800 = cljs.core.chunk_rest(seq__16092_16798__$1);
var G__16801 = c__4609__auto___16799;
var G__16802 = cljs.core.count(c__4609__auto___16799);
var G__16803 = (0);
seq__16092_16785 = G__16800;
chunk__16093_16786 = G__16801;
count__16094_16787 = G__16802;
i__16095_16788 = G__16803;
continue;
} else {
var lib_16804 = cljs.core.first(seq__16092_16798__$1);
var map__16103_16805 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16804));
var map__16103_16806__$1 = (((((!((map__16103_16805 == null))))?(((((map__16103_16805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16103_16805.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16103_16805):map__16103_16805);
var global_exports_16807 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16103_16806__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16807,lib_16804);


var G__16808 = cljs.core.next(seq__16092_16798__$1);
var G__16809 = null;
var G__16810 = (0);
var G__16811 = (0);
seq__16092_16785 = G__16808;
chunk__16093_16786 = G__16809;
count__16094_16787 = G__16810;
i__16095_16788 = G__16811;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__16105){
var map__16106 = p__16105;
var map__16106__$1 = (((((!((map__16106 == null))))?(((((map__16106.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16106.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16106):map__16106);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16106__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16106__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16106__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16106__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16106__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16106__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16106__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__16108){
var map__16109 = p__16108;
var map__16109__$1 = (((((!((map__16109 == null))))?(((((map__16109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16109.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16109):map__16109);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16109__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16109__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16109__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16109__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16109__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16109__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16109__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__16111){
var map__16112 = p__16111;
var map__16112__$1 = (((((!((map__16112 == null))))?(((((map__16112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16112.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16112):map__16112);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16112__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16112__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16112__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16112__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16112__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__16114_16812 = cljs.core.seq(protocols);
var chunk__16115_16813 = null;
var count__16116_16814 = (0);
var i__16117_16815 = (0);
while(true){
if((i__16117_16815 < count__16116_16814)){
var protocol_16816 = chunk__16115_16813.cljs$core$IIndexed$_nth$arity$2(null,i__16117_16815);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16816)),"}");


var G__16817 = seq__16114_16812;
var G__16818 = chunk__16115_16813;
var G__16819 = count__16116_16814;
var G__16820 = (i__16117_16815 + (1));
seq__16114_16812 = G__16817;
chunk__16115_16813 = G__16818;
count__16116_16814 = G__16819;
i__16117_16815 = G__16820;
continue;
} else {
var temp__5735__auto___16821 = cljs.core.seq(seq__16114_16812);
if(temp__5735__auto___16821){
var seq__16114_16822__$1 = temp__5735__auto___16821;
if(cljs.core.chunked_seq_QMARK_(seq__16114_16822__$1)){
var c__4609__auto___16823 = cljs.core.chunk_first(seq__16114_16822__$1);
var G__16824 = cljs.core.chunk_rest(seq__16114_16822__$1);
var G__16825 = c__4609__auto___16823;
var G__16826 = cljs.core.count(c__4609__auto___16823);
var G__16827 = (0);
seq__16114_16812 = G__16824;
chunk__16115_16813 = G__16825;
count__16116_16814 = G__16826;
i__16117_16815 = G__16827;
continue;
} else {
var protocol_16828 = cljs.core.first(seq__16114_16822__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16828)),"}");


var G__16829 = cljs.core.next(seq__16114_16822__$1);
var G__16830 = null;
var G__16831 = (0);
var G__16832 = (0);
seq__16114_16812 = G__16829;
chunk__16115_16813 = G__16830;
count__16116_16814 = G__16831;
i__16117_16815 = G__16832;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__16125_16833 = cljs.core.seq(fields__$1);
var chunk__16126_16834 = null;
var count__16127_16835 = (0);
var i__16128_16836 = (0);
while(true){
if((i__16128_16836 < count__16127_16835)){
var fld_16837 = chunk__16126_16834.cljs$core$IIndexed$_nth$arity$2(null,i__16128_16836);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16837," = ",fld_16837,";");


var G__16838 = seq__16125_16833;
var G__16839 = chunk__16126_16834;
var G__16840 = count__16127_16835;
var G__16841 = (i__16128_16836 + (1));
seq__16125_16833 = G__16838;
chunk__16126_16834 = G__16839;
count__16127_16835 = G__16840;
i__16128_16836 = G__16841;
continue;
} else {
var temp__5735__auto___16842 = cljs.core.seq(seq__16125_16833);
if(temp__5735__auto___16842){
var seq__16125_16843__$1 = temp__5735__auto___16842;
if(cljs.core.chunked_seq_QMARK_(seq__16125_16843__$1)){
var c__4609__auto___16844 = cljs.core.chunk_first(seq__16125_16843__$1);
var G__16845 = cljs.core.chunk_rest(seq__16125_16843__$1);
var G__16846 = c__4609__auto___16844;
var G__16847 = cljs.core.count(c__4609__auto___16844);
var G__16848 = (0);
seq__16125_16833 = G__16845;
chunk__16126_16834 = G__16846;
count__16127_16835 = G__16847;
i__16128_16836 = G__16848;
continue;
} else {
var fld_16849 = cljs.core.first(seq__16125_16843__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16849," = ",fld_16849,";");


var G__16850 = cljs.core.next(seq__16125_16843__$1);
var G__16851 = null;
var G__16852 = (0);
var G__16853 = (0);
seq__16125_16833 = G__16850;
chunk__16126_16834 = G__16851;
count__16127_16835 = G__16852;
i__16128_16836 = G__16853;
continue;
}
} else {
}
}
break;
}

var seq__16130_16854 = cljs.core.seq(pmasks);
var chunk__16131_16855 = null;
var count__16132_16856 = (0);
var i__16133_16857 = (0);
while(true){
if((i__16133_16857 < count__16132_16856)){
var vec__16141_16858 = chunk__16131_16855.cljs$core$IIndexed$_nth$arity$2(null,i__16133_16857);
var pno_16859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16141_16858,(0),null);
var pmask_16860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16141_16858,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16859,"$ = ",pmask_16860,";");


var G__16861 = seq__16130_16854;
var G__16862 = chunk__16131_16855;
var G__16863 = count__16132_16856;
var G__16864 = (i__16133_16857 + (1));
seq__16130_16854 = G__16861;
chunk__16131_16855 = G__16862;
count__16132_16856 = G__16863;
i__16133_16857 = G__16864;
continue;
} else {
var temp__5735__auto___16865 = cljs.core.seq(seq__16130_16854);
if(temp__5735__auto___16865){
var seq__16130_16866__$1 = temp__5735__auto___16865;
if(cljs.core.chunked_seq_QMARK_(seq__16130_16866__$1)){
var c__4609__auto___16867 = cljs.core.chunk_first(seq__16130_16866__$1);
var G__16868 = cljs.core.chunk_rest(seq__16130_16866__$1);
var G__16869 = c__4609__auto___16867;
var G__16870 = cljs.core.count(c__4609__auto___16867);
var G__16871 = (0);
seq__16130_16854 = G__16868;
chunk__16131_16855 = G__16869;
count__16132_16856 = G__16870;
i__16133_16857 = G__16871;
continue;
} else {
var vec__16146_16872 = cljs.core.first(seq__16130_16866__$1);
var pno_16873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16146_16872,(0),null);
var pmask_16874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16146_16872,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16873,"$ = ",pmask_16874,";");


var G__16875 = cljs.core.next(seq__16130_16866__$1);
var G__16876 = null;
var G__16877 = (0);
var G__16878 = (0);
seq__16130_16854 = G__16875;
chunk__16131_16855 = G__16876;
count__16132_16856 = G__16877;
i__16133_16857 = G__16878;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__16149){
var map__16150 = p__16149;
var map__16150__$1 = (((((!((map__16150 == null))))?(((((map__16150.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16150.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16150):map__16150);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16150__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16150__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16150__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16150__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16150__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__16152_16879 = cljs.core.seq(protocols);
var chunk__16153_16880 = null;
var count__16154_16881 = (0);
var i__16155_16882 = (0);
while(true){
if((i__16155_16882 < count__16154_16881)){
var protocol_16883 = chunk__16153_16880.cljs$core$IIndexed$_nth$arity$2(null,i__16155_16882);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16883)),"}");


var G__16884 = seq__16152_16879;
var G__16885 = chunk__16153_16880;
var G__16886 = count__16154_16881;
var G__16887 = (i__16155_16882 + (1));
seq__16152_16879 = G__16884;
chunk__16153_16880 = G__16885;
count__16154_16881 = G__16886;
i__16155_16882 = G__16887;
continue;
} else {
var temp__5735__auto___16888 = cljs.core.seq(seq__16152_16879);
if(temp__5735__auto___16888){
var seq__16152_16889__$1 = temp__5735__auto___16888;
if(cljs.core.chunked_seq_QMARK_(seq__16152_16889__$1)){
var c__4609__auto___16890 = cljs.core.chunk_first(seq__16152_16889__$1);
var G__16891 = cljs.core.chunk_rest(seq__16152_16889__$1);
var G__16892 = c__4609__auto___16890;
var G__16893 = cljs.core.count(c__4609__auto___16890);
var G__16894 = (0);
seq__16152_16879 = G__16891;
chunk__16153_16880 = G__16892;
count__16154_16881 = G__16893;
i__16155_16882 = G__16894;
continue;
} else {
var protocol_16895 = cljs.core.first(seq__16152_16889__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16895)),"}");


var G__16896 = cljs.core.next(seq__16152_16889__$1);
var G__16897 = null;
var G__16898 = (0);
var G__16899 = (0);
seq__16152_16879 = G__16896;
chunk__16153_16880 = G__16897;
count__16154_16881 = G__16898;
i__16155_16882 = G__16899;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__16158_16900 = cljs.core.seq(fields__$1);
var chunk__16159_16901 = null;
var count__16160_16902 = (0);
var i__16161_16903 = (0);
while(true){
if((i__16161_16903 < count__16160_16902)){
var fld_16904 = chunk__16159_16901.cljs$core$IIndexed$_nth$arity$2(null,i__16161_16903);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16904," = ",fld_16904,";");


var G__16905 = seq__16158_16900;
var G__16906 = chunk__16159_16901;
var G__16907 = count__16160_16902;
var G__16908 = (i__16161_16903 + (1));
seq__16158_16900 = G__16905;
chunk__16159_16901 = G__16906;
count__16160_16902 = G__16907;
i__16161_16903 = G__16908;
continue;
} else {
var temp__5735__auto___16909 = cljs.core.seq(seq__16158_16900);
if(temp__5735__auto___16909){
var seq__16158_16910__$1 = temp__5735__auto___16909;
if(cljs.core.chunked_seq_QMARK_(seq__16158_16910__$1)){
var c__4609__auto___16911 = cljs.core.chunk_first(seq__16158_16910__$1);
var G__16912 = cljs.core.chunk_rest(seq__16158_16910__$1);
var G__16913 = c__4609__auto___16911;
var G__16914 = cljs.core.count(c__4609__auto___16911);
var G__16915 = (0);
seq__16158_16900 = G__16912;
chunk__16159_16901 = G__16913;
count__16160_16902 = G__16914;
i__16161_16903 = G__16915;
continue;
} else {
var fld_16916 = cljs.core.first(seq__16158_16910__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16916," = ",fld_16916,";");


var G__16917 = cljs.core.next(seq__16158_16910__$1);
var G__16918 = null;
var G__16919 = (0);
var G__16920 = (0);
seq__16158_16900 = G__16917;
chunk__16159_16901 = G__16918;
count__16160_16902 = G__16919;
i__16161_16903 = G__16920;
continue;
}
} else {
}
}
break;
}

var seq__16169_16921 = cljs.core.seq(pmasks);
var chunk__16170_16922 = null;
var count__16171_16923 = (0);
var i__16172_16924 = (0);
while(true){
if((i__16172_16924 < count__16171_16923)){
var vec__16179_16925 = chunk__16170_16922.cljs$core$IIndexed$_nth$arity$2(null,i__16172_16924);
var pno_16926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16179_16925,(0),null);
var pmask_16927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16179_16925,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16926,"$ = ",pmask_16927,";");


var G__16928 = seq__16169_16921;
var G__16929 = chunk__16170_16922;
var G__16930 = count__16171_16923;
var G__16931 = (i__16172_16924 + (1));
seq__16169_16921 = G__16928;
chunk__16170_16922 = G__16929;
count__16171_16923 = G__16930;
i__16172_16924 = G__16931;
continue;
} else {
var temp__5735__auto___16932 = cljs.core.seq(seq__16169_16921);
if(temp__5735__auto___16932){
var seq__16169_16933__$1 = temp__5735__auto___16932;
if(cljs.core.chunked_seq_QMARK_(seq__16169_16933__$1)){
var c__4609__auto___16934 = cljs.core.chunk_first(seq__16169_16933__$1);
var G__16935 = cljs.core.chunk_rest(seq__16169_16933__$1);
var G__16936 = c__4609__auto___16934;
var G__16937 = cljs.core.count(c__4609__auto___16934);
var G__16938 = (0);
seq__16169_16921 = G__16935;
chunk__16170_16922 = G__16936;
count__16171_16923 = G__16937;
i__16172_16924 = G__16938;
continue;
} else {
var vec__16182_16939 = cljs.core.first(seq__16169_16933__$1);
var pno_16940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16182_16939,(0),null);
var pmask_16941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16182_16939,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16940,"$ = ",pmask_16941,";");


var G__16942 = cljs.core.next(seq__16169_16933__$1);
var G__16943 = null;
var G__16944 = (0);
var G__16945 = (0);
seq__16169_16921 = G__16942;
chunk__16170_16922 = G__16943;
count__16171_16923 = G__16944;
i__16172_16924 = G__16945;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__16185){
var map__16186 = p__16185;
var map__16186__$1 = (((((!((map__16186 == null))))?(((((map__16186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16186.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16186):map__16186);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16186__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16186__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16186__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16186__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16186__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__16188){
var map__16189 = p__16188;
var map__16189__$1 = (((((!((map__16189 == null))))?(((((map__16189.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16189.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16189):map__16189);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16189__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16189__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16189__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16189__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16189__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__16191 = clojure.string.trim(code);
var G__16192 = "/*";
return goog.string.startsWith(G__16191,G__16192);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__16197 = cljs.core.seq(table);
var chunk__16198 = null;
var count__16199 = (0);
var i__16200 = (0);
while(true){
if((i__16200 < count__16199)){
var vec__16207 = chunk__16198.cljs$core$IIndexed$_nth$arity$2(null,i__16200);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16207,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16207,(1),null);
var ns_16946 = cljs.core.namespace(sym);
var name_16947 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16948 = seq__16197;
var G__16949 = chunk__16198;
var G__16950 = count__16199;
var G__16951 = (i__16200 + (1));
seq__16197 = G__16948;
chunk__16198 = G__16949;
count__16199 = G__16950;
i__16200 = G__16951;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16197);
if(temp__5735__auto__){
var seq__16197__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16197__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16197__$1);
var G__16952 = cljs.core.chunk_rest(seq__16197__$1);
var G__16953 = c__4609__auto__;
var G__16954 = cljs.core.count(c__4609__auto__);
var G__16955 = (0);
seq__16197 = G__16952;
chunk__16198 = G__16953;
count__16199 = G__16954;
i__16200 = G__16955;
continue;
} else {
var vec__16210 = cljs.core.first(seq__16197__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16210,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16210,(1),null);
var ns_16956 = cljs.core.namespace(sym);
var name_16957 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16958 = cljs.core.next(seq__16197__$1);
var G__16959 = null;
var G__16960 = (0);
var G__16961 = (0);
seq__16197 = G__16958;
chunk__16198 = G__16959;
count__16199 = G__16960;
i__16200 = G__16961;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__16214 = arguments.length;
switch (G__16214) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_16963 = cljs.core.first(ks);
var vec__16215_16964 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_16963);
var top_16965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16215_16964,(0),null);
var prefix_SINGLEQUOTE__16966 = vec__16215_16964;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_16963)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__16966) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_16965)) || (cljs.core.contains_QMARK_(known_externs,top_16965)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16966)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_16965);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16966)),";");
}
} else {
}

var m_16967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_16963);
if(cljs.core.empty_QMARK_(m_16967)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__16966,m_16967,top_level,known_externs);
}

var G__16968 = cljs.core.next(ks);
ks = G__16968;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

