goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__13289){
var vec__13293 = p__13289;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__13296 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__13299 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(4),null);
var vec__13302 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__13305 = segmap;
var map__13305__$1 = (((((!((map__13305 == null))))?(((((map__13305.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13305.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13305):map__13305);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__13308 = arguments.length;
switch (G__13308) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13312 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14197 = cljs.core.next(segs__$1);
var G__14198 = nrelseg;
var G__14199 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14197;
relseg__$1 = G__14198;
result__$1 = G__14199;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13312,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13312,(1),null);
var G__14222 = (gline + (1));
var G__14223 = cljs.core.next(lines__$1);
var G__14224 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14225 = result__$1;
gline = G__14222;
lines__$1 = G__14223;
relseg = G__14224;
result = G__14225;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__13316 = segmap;
var map__13316__$1 = (((((!((map__13316 == null))))?(((((map__13316.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13316.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13316):map__13316);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__13315_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__13315_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__13319 = arguments.length;
switch (G__13319) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13323 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14254 = cljs.core.next(segs__$1);
var G__14255 = nrelseg;
var G__14256 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14254;
relseg__$1 = G__14255;
result__$1 = G__14256;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13323,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13323,(1),null);
var G__14260 = (gline + (1));
var G__14261 = cljs.core.next(lines__$1);
var G__14262 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14263 = result__$1;
gline = G__14260;
lines__$1 = G__14261;
relseg = G__14262;
result = G__14263;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13326){
var vec__13327 = p__13326;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__13330){
var vec__13331 = p__13330;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13331,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13331,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13331,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13331,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13331,(4),null);
var seg = vec__13331;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13334){
var vec__13335 = p__13334;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13335,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13335,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13335,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13335,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13335,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__13341 = cljs.core.seq(infos);
var chunk__13342 = null;
var count__13343 = (0);
var i__13344 = (0);
while(true){
if((i__13344 < count__13343)){
var info = chunk__13342.cljs$core$IIndexed$_nth$arity$2(null,i__13344);
var segv_14267 = info__GT_segv(info,source_idx,line,col);
var gline_14268 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14269 = cljs.core.count(cljs.core.deref(lines));
if((gline_14268 > (lc_14269 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13341,chunk__13342,count__13343,i__13344,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14268 - (lc_14269 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14267], null));
});})(seq__13341,chunk__13342,count__13343,i__13344,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13341,chunk__13342,count__13343,i__13344,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14268], null),cljs.core.conj,segv_14267);
});})(seq__13341,chunk__13342,count__13343,i__13344,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14270 = seq__13341;
var G__14271 = chunk__13342;
var G__14272 = count__13343;
var G__14273 = (i__13344 + (1));
seq__13341 = G__14270;
chunk__13342 = G__14271;
count__13343 = G__14272;
i__13344 = G__14273;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__13341);
if(temp__5735__auto__){
var seq__13341__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__13341__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__13341__$1);
var G__14274 = cljs.core.chunk_rest(seq__13341__$1);
var G__14275 = c__4609__auto__;
var G__14276 = cljs.core.count(c__4609__auto__);
var G__14277 = (0);
seq__13341 = G__14274;
chunk__13342 = G__14275;
count__13343 = G__14276;
i__13344 = G__14277;
continue;
} else {
var info = cljs.core.first(seq__13341__$1);
var segv_14278 = info__GT_segv(info,source_idx,line,col);
var gline_14279 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14280 = cljs.core.count(cljs.core.deref(lines));
if((gline_14279 > (lc_14280 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13341,chunk__13342,count__13343,i__13344,segv_14278,gline_14279,lc_14280,info,seq__13341__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14279 - (lc_14280 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14278], null));
});})(seq__13341,chunk__13342,count__13343,i__13344,segv_14278,gline_14279,lc_14280,info,seq__13341__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13341,chunk__13342,count__13343,i__13344,segv_14278,gline_14279,lc_14280,info,seq__13341__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14279], null),cljs.core.conj,segv_14278);
});})(seq__13341,chunk__13342,count__13343,i__13344,segv_14278,gline_14279,lc_14280,info,seq__13341__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14288 = cljs.core.next(seq__13341__$1);
var G__14289 = null;
var G__14290 = (0);
var G__14291 = (0);
seq__13341 = G__14288;
chunk__13342 = G__14289;
count__13343 = G__14290;
i__13344 = G__14291;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__13351_14292 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__13352_14293 = null;
var count__13353_14294 = (0);
var i__13354_14295 = (0);
while(true){
if((i__13354_14295 < count__13353_14294)){
var vec__13570_14296 = chunk__13352_14293.cljs$core$IIndexed$_nth$arity$2(null,i__13354_14295);
var source_idx_14297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13570_14296,(0),null);
var vec__13573_14298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13570_14296,(1),null);
var __14299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13573_14298,(0),null);
var lines_14300__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13573_14298,(1),null);
var seq__13585_14301 = cljs.core.seq(lines_14300__$1);
var chunk__13586_14302 = null;
var count__13587_14303 = (0);
var i__13588_14304 = (0);
while(true){
if((i__13588_14304 < count__13587_14303)){
var vec__13637_14305 = chunk__13586_14302.cljs$core$IIndexed$_nth$arity$2(null,i__13588_14304);
var line_14306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13637_14305,(0),null);
var cols_14307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13637_14305,(1),null);
var seq__13640_14308 = cljs.core.seq(cols_14307);
var chunk__13641_14309 = null;
var count__13642_14310 = (0);
var i__13643_14311 = (0);
while(true){
if((i__13643_14311 < count__13642_14310)){
var vec__13651_14312 = chunk__13641_14309.cljs$core$IIndexed$_nth$arity$2(null,i__13643_14311);
var col_14313 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13651_14312,(0),null);
var infos_14314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13651_14312,(1),null);
encode_cols(infos_14314,source_idx_14297,line_14306,col_14313);


var G__14320 = seq__13640_14308;
var G__14321 = chunk__13641_14309;
var G__14322 = count__13642_14310;
var G__14323 = (i__13643_14311 + (1));
seq__13640_14308 = G__14320;
chunk__13641_14309 = G__14321;
count__13642_14310 = G__14322;
i__13643_14311 = G__14323;
continue;
} else {
var temp__5735__auto___14324 = cljs.core.seq(seq__13640_14308);
if(temp__5735__auto___14324){
var seq__13640_14325__$1 = temp__5735__auto___14324;
if(cljs.core.chunked_seq_QMARK_(seq__13640_14325__$1)){
var c__4609__auto___14326 = cljs.core.chunk_first(seq__13640_14325__$1);
var G__14327 = cljs.core.chunk_rest(seq__13640_14325__$1);
var G__14328 = c__4609__auto___14326;
var G__14329 = cljs.core.count(c__4609__auto___14326);
var G__14330 = (0);
seq__13640_14308 = G__14327;
chunk__13641_14309 = G__14328;
count__13642_14310 = G__14329;
i__13643_14311 = G__14330;
continue;
} else {
var vec__13654_14331 = cljs.core.first(seq__13640_14325__$1);
var col_14332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13654_14331,(0),null);
var infos_14333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13654_14331,(1),null);
encode_cols(infos_14333,source_idx_14297,line_14306,col_14332);


var G__14334 = cljs.core.next(seq__13640_14325__$1);
var G__14335 = null;
var G__14336 = (0);
var G__14337 = (0);
seq__13640_14308 = G__14334;
chunk__13641_14309 = G__14335;
count__13642_14310 = G__14336;
i__13643_14311 = G__14337;
continue;
}
} else {
}
}
break;
}


var G__14338 = seq__13585_14301;
var G__14339 = chunk__13586_14302;
var G__14340 = count__13587_14303;
var G__14341 = (i__13588_14304 + (1));
seq__13585_14301 = G__14338;
chunk__13586_14302 = G__14339;
count__13587_14303 = G__14340;
i__13588_14304 = G__14341;
continue;
} else {
var temp__5735__auto___14344 = cljs.core.seq(seq__13585_14301);
if(temp__5735__auto___14344){
var seq__13585_14345__$1 = temp__5735__auto___14344;
if(cljs.core.chunked_seq_QMARK_(seq__13585_14345__$1)){
var c__4609__auto___14346 = cljs.core.chunk_first(seq__13585_14345__$1);
var G__14347 = cljs.core.chunk_rest(seq__13585_14345__$1);
var G__14348 = c__4609__auto___14346;
var G__14349 = cljs.core.count(c__4609__auto___14346);
var G__14350 = (0);
seq__13585_14301 = G__14347;
chunk__13586_14302 = G__14348;
count__13587_14303 = G__14349;
i__13588_14304 = G__14350;
continue;
} else {
var vec__13659_14351 = cljs.core.first(seq__13585_14345__$1);
var line_14352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13659_14351,(0),null);
var cols_14353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13659_14351,(1),null);
var seq__13662_14356 = cljs.core.seq(cols_14353);
var chunk__13663_14357 = null;
var count__13664_14358 = (0);
var i__13665_14359 = (0);
while(true){
if((i__13665_14359 < count__13664_14358)){
var vec__13672_14360 = chunk__13663_14357.cljs$core$IIndexed$_nth$arity$2(null,i__13665_14359);
var col_14361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13672_14360,(0),null);
var infos_14362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13672_14360,(1),null);
encode_cols(infos_14362,source_idx_14297,line_14352,col_14361);


var G__14363 = seq__13662_14356;
var G__14364 = chunk__13663_14357;
var G__14365 = count__13664_14358;
var G__14366 = (i__13665_14359 + (1));
seq__13662_14356 = G__14363;
chunk__13663_14357 = G__14364;
count__13664_14358 = G__14365;
i__13665_14359 = G__14366;
continue;
} else {
var temp__5735__auto___14367__$1 = cljs.core.seq(seq__13662_14356);
if(temp__5735__auto___14367__$1){
var seq__13662_14368__$1 = temp__5735__auto___14367__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13662_14368__$1)){
var c__4609__auto___14369 = cljs.core.chunk_first(seq__13662_14368__$1);
var G__14370 = cljs.core.chunk_rest(seq__13662_14368__$1);
var G__14371 = c__4609__auto___14369;
var G__14372 = cljs.core.count(c__4609__auto___14369);
var G__14373 = (0);
seq__13662_14356 = G__14370;
chunk__13663_14357 = G__14371;
count__13664_14358 = G__14372;
i__13665_14359 = G__14373;
continue;
} else {
var vec__13684_14374 = cljs.core.first(seq__13662_14368__$1);
var col_14375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13684_14374,(0),null);
var infos_14376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13684_14374,(1),null);
encode_cols(infos_14376,source_idx_14297,line_14352,col_14375);


var G__14377 = cljs.core.next(seq__13662_14368__$1);
var G__14378 = null;
var G__14379 = (0);
var G__14380 = (0);
seq__13662_14356 = G__14377;
chunk__13663_14357 = G__14378;
count__13664_14358 = G__14379;
i__13665_14359 = G__14380;
continue;
}
} else {
}
}
break;
}


var G__14383 = cljs.core.next(seq__13585_14345__$1);
var G__14384 = null;
var G__14385 = (0);
var G__14386 = (0);
seq__13585_14301 = G__14383;
chunk__13586_14302 = G__14384;
count__13587_14303 = G__14385;
i__13588_14304 = G__14386;
continue;
}
} else {
}
}
break;
}


var G__14393 = seq__13351_14292;
var G__14394 = chunk__13352_14293;
var G__14395 = count__13353_14294;
var G__14396 = (i__13354_14295 + (1));
seq__13351_14292 = G__14393;
chunk__13352_14293 = G__14394;
count__13353_14294 = G__14395;
i__13354_14295 = G__14396;
continue;
} else {
var temp__5735__auto___14397 = cljs.core.seq(seq__13351_14292);
if(temp__5735__auto___14397){
var seq__13351_14398__$1 = temp__5735__auto___14397;
if(cljs.core.chunked_seq_QMARK_(seq__13351_14398__$1)){
var c__4609__auto___14399 = cljs.core.chunk_first(seq__13351_14398__$1);
var G__14400 = cljs.core.chunk_rest(seq__13351_14398__$1);
var G__14401 = c__4609__auto___14399;
var G__14402 = cljs.core.count(c__4609__auto___14399);
var G__14403 = (0);
seq__13351_14292 = G__14400;
chunk__13352_14293 = G__14401;
count__13353_14294 = G__14402;
i__13354_14295 = G__14403;
continue;
} else {
var vec__13689_14404 = cljs.core.first(seq__13351_14398__$1);
var source_idx_14405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13689_14404,(0),null);
var vec__13692_14406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13689_14404,(1),null);
var __14407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13692_14406,(0),null);
var lines_14408__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13692_14406,(1),null);
var seq__13695_14409 = cljs.core.seq(lines_14408__$1);
var chunk__13696_14410 = null;
var count__13697_14411 = (0);
var i__13698_14412 = (0);
while(true){
if((i__13698_14412 < count__13697_14411)){
var vec__13742_14413 = chunk__13696_14410.cljs$core$IIndexed$_nth$arity$2(null,i__13698_14412);
var line_14414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13742_14413,(0),null);
var cols_14415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13742_14413,(1),null);
var seq__13747_14416 = cljs.core.seq(cols_14415);
var chunk__13748_14417 = null;
var count__13749_14418 = (0);
var i__13750_14419 = (0);
while(true){
if((i__13750_14419 < count__13749_14418)){
var vec__13758_14420 = chunk__13748_14417.cljs$core$IIndexed$_nth$arity$2(null,i__13750_14419);
var col_14421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13758_14420,(0),null);
var infos_14422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13758_14420,(1),null);
encode_cols(infos_14422,source_idx_14405,line_14414,col_14421);


var G__14425 = seq__13747_14416;
var G__14426 = chunk__13748_14417;
var G__14427 = count__13749_14418;
var G__14428 = (i__13750_14419 + (1));
seq__13747_14416 = G__14425;
chunk__13748_14417 = G__14426;
count__13749_14418 = G__14427;
i__13750_14419 = G__14428;
continue;
} else {
var temp__5735__auto___14429__$1 = cljs.core.seq(seq__13747_14416);
if(temp__5735__auto___14429__$1){
var seq__13747_14430__$1 = temp__5735__auto___14429__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13747_14430__$1)){
var c__4609__auto___14431 = cljs.core.chunk_first(seq__13747_14430__$1);
var G__14432 = cljs.core.chunk_rest(seq__13747_14430__$1);
var G__14433 = c__4609__auto___14431;
var G__14434 = cljs.core.count(c__4609__auto___14431);
var G__14435 = (0);
seq__13747_14416 = G__14432;
chunk__13748_14417 = G__14433;
count__13749_14418 = G__14434;
i__13750_14419 = G__14435;
continue;
} else {
var vec__13765_14436 = cljs.core.first(seq__13747_14430__$1);
var col_14437 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765_14436,(0),null);
var infos_14438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765_14436,(1),null);
encode_cols(infos_14438,source_idx_14405,line_14414,col_14437);


var G__14439 = cljs.core.next(seq__13747_14430__$1);
var G__14440 = null;
var G__14441 = (0);
var G__14442 = (0);
seq__13747_14416 = G__14439;
chunk__13748_14417 = G__14440;
count__13749_14418 = G__14441;
i__13750_14419 = G__14442;
continue;
}
} else {
}
}
break;
}


var G__14443 = seq__13695_14409;
var G__14444 = chunk__13696_14410;
var G__14445 = count__13697_14411;
var G__14446 = (i__13698_14412 + (1));
seq__13695_14409 = G__14443;
chunk__13696_14410 = G__14444;
count__13697_14411 = G__14445;
i__13698_14412 = G__14446;
continue;
} else {
var temp__5735__auto___14450__$1 = cljs.core.seq(seq__13695_14409);
if(temp__5735__auto___14450__$1){
var seq__13695_14451__$1 = temp__5735__auto___14450__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13695_14451__$1)){
var c__4609__auto___14452 = cljs.core.chunk_first(seq__13695_14451__$1);
var G__14453 = cljs.core.chunk_rest(seq__13695_14451__$1);
var G__14454 = c__4609__auto___14452;
var G__14455 = cljs.core.count(c__4609__auto___14452);
var G__14456 = (0);
seq__13695_14409 = G__14453;
chunk__13696_14410 = G__14454;
count__13697_14411 = G__14455;
i__13698_14412 = G__14456;
continue;
} else {
var vec__13768_14457 = cljs.core.first(seq__13695_14451__$1);
var line_14458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13768_14457,(0),null);
var cols_14459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13768_14457,(1),null);
var seq__13771_14460 = cljs.core.seq(cols_14459);
var chunk__13772_14461 = null;
var count__13773_14462 = (0);
var i__13774_14463 = (0);
while(true){
if((i__13774_14463 < count__13773_14462)){
var vec__13781_14464 = chunk__13772_14461.cljs$core$IIndexed$_nth$arity$2(null,i__13774_14463);
var col_14465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13781_14464,(0),null);
var infos_14466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13781_14464,(1),null);
encode_cols(infos_14466,source_idx_14405,line_14458,col_14465);


var G__14467 = seq__13771_14460;
var G__14468 = chunk__13772_14461;
var G__14469 = count__13773_14462;
var G__14470 = (i__13774_14463 + (1));
seq__13771_14460 = G__14467;
chunk__13772_14461 = G__14468;
count__13773_14462 = G__14469;
i__13774_14463 = G__14470;
continue;
} else {
var temp__5735__auto___14471__$2 = cljs.core.seq(seq__13771_14460);
if(temp__5735__auto___14471__$2){
var seq__13771_14484__$1 = temp__5735__auto___14471__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13771_14484__$1)){
var c__4609__auto___14485 = cljs.core.chunk_first(seq__13771_14484__$1);
var G__14488 = cljs.core.chunk_rest(seq__13771_14484__$1);
var G__14489 = c__4609__auto___14485;
var G__14490 = cljs.core.count(c__4609__auto___14485);
var G__14491 = (0);
seq__13771_14460 = G__14488;
chunk__13772_14461 = G__14489;
count__13773_14462 = G__14490;
i__13774_14463 = G__14491;
continue;
} else {
var vec__13791_14492 = cljs.core.first(seq__13771_14484__$1);
var col_14493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13791_14492,(0),null);
var infos_14494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13791_14492,(1),null);
encode_cols(infos_14494,source_idx_14405,line_14458,col_14493);


var G__14495 = cljs.core.next(seq__13771_14484__$1);
var G__14496 = null;
var G__14497 = (0);
var G__14498 = (0);
seq__13771_14460 = G__14495;
chunk__13772_14461 = G__14496;
count__13773_14462 = G__14497;
i__13774_14463 = G__14498;
continue;
}
} else {
}
}
break;
}


var G__14499 = cljs.core.next(seq__13695_14451__$1);
var G__14500 = null;
var G__14501 = (0);
var G__14502 = (0);
seq__13695_14409 = G__14499;
chunk__13696_14410 = G__14500;
count__13697_14411 = G__14501;
i__13698_14412 = G__14502;
continue;
}
} else {
}
}
break;
}


var G__14503 = cljs.core.next(seq__13351_14398__$1);
var G__14504 = null;
var G__14505 = (0);
var G__14506 = (0);
seq__13351_14292 = G__14503;
chunk__13352_14293 = G__14504;
count__13353_14294 = G__14505;
i__13354_14295 = G__14506;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13794 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__13338_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__13338_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__13339_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__13339_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__13340_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__13340_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13797 = G__13794;
var G__13798_14507 = G__13797;
var G__13799_14508 = "sourcesContent";
var G__13800_14509 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__13798_14507,G__13799_14508,G__13800_14509);

return G__13797;
} else {
return G__13794;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13801 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13801,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13801,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13804 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13804,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13804,(1),null);
var G__14520 = cljs.core.next(col_map_seq);
var G__14521 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13804,col,infos,vec__13801,line,col_map){
return (function (v,p__13811){
var map__13812 = p__13811;
var map__13812__$1 = (((((!((map__13812 == null))))?(((((map__13812.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13812.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13812):map__13812);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13812__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13812__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13804,col,infos,vec__13801,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14520;
new_cols = G__14521;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14528 = cljs.core.next(line_map_seq);
var G__14529 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14528;
new_lines = G__14529;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13814_14531 = cljs.core.seq(reverse_map);
var chunk__13815_14533 = null;
var count__13816_14534 = (0);
var i__13817_14535 = (0);
while(true){
if((i__13817_14535 < count__13816_14534)){
var vec__13979_14561 = chunk__13815_14533.cljs$core$IIndexed$_nth$arity$2(null,i__13817_14535);
var line_14562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13979_14561,(0),null);
var columns_14563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13979_14561,(1),null);
var seq__13982_14566 = cljs.core.seq(columns_14563);
var chunk__13983_14567 = null;
var count__13984_14568 = (0);
var i__13985_14569 = (0);
while(true){
if((i__13985_14569 < count__13984_14568)){
var vec__14030_14570 = chunk__13983_14567.cljs$core$IIndexed$_nth$arity$2(null,i__13985_14569);
var column_14571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14030_14570,(0),null);
var column_info_14572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14030_14570,(1),null);
var seq__14033_14575 = cljs.core.seq(column_info_14572);
var chunk__14034_14576 = null;
var count__14035_14577 = (0);
var i__14036_14578 = (0);
while(true){
if((i__14036_14578 < count__14035_14577)){
var map__14053_14579 = chunk__14034_14576.cljs$core$IIndexed$_nth$arity$2(null,i__14036_14578);
var map__14053_14580__$1 = (((((!((map__14053_14579 == null))))?(((((map__14053_14579.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14053_14579.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14053_14579):map__14053_14579);
var gline_14581 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14053_14580__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14582 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14053_14580__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14583 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14053_14580__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14581], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14033_14575,chunk__14034_14576,count__14035_14577,i__14036_14578,seq__13982_14566,chunk__13983_14567,count__13984_14568,i__13985_14569,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14053_14579,map__14053_14580__$1,gline_14581,gcol_14582,name_14583,vec__14030_14570,column_14571,column_info_14572,vec__13979_14561,line_14562,columns_14563,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14582], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14562,new cljs.core.Keyword(null,"col","col",-1959363084),column_14571,new cljs.core.Keyword(null,"name","name",1843675177),name_14583], null));
});})(seq__14033_14575,chunk__14034_14576,count__14035_14577,i__14036_14578,seq__13982_14566,chunk__13983_14567,count__13984_14568,i__13985_14569,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14053_14579,map__14053_14580__$1,gline_14581,gcol_14582,name_14583,vec__14030_14570,column_14571,column_info_14572,vec__13979_14561,line_14562,columns_14563,inverted))
,cljs.core.sorted_map()));


var G__14585 = seq__14033_14575;
var G__14586 = chunk__14034_14576;
var G__14587 = count__14035_14577;
var G__14588 = (i__14036_14578 + (1));
seq__14033_14575 = G__14585;
chunk__14034_14576 = G__14586;
count__14035_14577 = G__14587;
i__14036_14578 = G__14588;
continue;
} else {
var temp__5735__auto___14589 = cljs.core.seq(seq__14033_14575);
if(temp__5735__auto___14589){
var seq__14033_14590__$1 = temp__5735__auto___14589;
if(cljs.core.chunked_seq_QMARK_(seq__14033_14590__$1)){
var c__4609__auto___14594 = cljs.core.chunk_first(seq__14033_14590__$1);
var G__14595 = cljs.core.chunk_rest(seq__14033_14590__$1);
var G__14596 = c__4609__auto___14594;
var G__14597 = cljs.core.count(c__4609__auto___14594);
var G__14598 = (0);
seq__14033_14575 = G__14595;
chunk__14034_14576 = G__14596;
count__14035_14577 = G__14597;
i__14036_14578 = G__14598;
continue;
} else {
var map__14055_14599 = cljs.core.first(seq__14033_14590__$1);
var map__14055_14600__$1 = (((((!((map__14055_14599 == null))))?(((((map__14055_14599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14055_14599.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14055_14599):map__14055_14599);
var gline_14601 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14055_14600__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14055_14600__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14603 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14055_14600__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14601], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14033_14575,chunk__14034_14576,count__14035_14577,i__14036_14578,seq__13982_14566,chunk__13983_14567,count__13984_14568,i__13985_14569,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14055_14599,map__14055_14600__$1,gline_14601,gcol_14602,name_14603,seq__14033_14590__$1,temp__5735__auto___14589,vec__14030_14570,column_14571,column_info_14572,vec__13979_14561,line_14562,columns_14563,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14602], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14562,new cljs.core.Keyword(null,"col","col",-1959363084),column_14571,new cljs.core.Keyword(null,"name","name",1843675177),name_14603], null));
});})(seq__14033_14575,chunk__14034_14576,count__14035_14577,i__14036_14578,seq__13982_14566,chunk__13983_14567,count__13984_14568,i__13985_14569,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14055_14599,map__14055_14600__$1,gline_14601,gcol_14602,name_14603,seq__14033_14590__$1,temp__5735__auto___14589,vec__14030_14570,column_14571,column_info_14572,vec__13979_14561,line_14562,columns_14563,inverted))
,cljs.core.sorted_map()));


var G__14608 = cljs.core.next(seq__14033_14590__$1);
var G__14609 = null;
var G__14610 = (0);
var G__14611 = (0);
seq__14033_14575 = G__14608;
chunk__14034_14576 = G__14609;
count__14035_14577 = G__14610;
i__14036_14578 = G__14611;
continue;
}
} else {
}
}
break;
}


var G__14612 = seq__13982_14566;
var G__14613 = chunk__13983_14567;
var G__14614 = count__13984_14568;
var G__14615 = (i__13985_14569 + (1));
seq__13982_14566 = G__14612;
chunk__13983_14567 = G__14613;
count__13984_14568 = G__14614;
i__13985_14569 = G__14615;
continue;
} else {
var temp__5735__auto___14616 = cljs.core.seq(seq__13982_14566);
if(temp__5735__auto___14616){
var seq__13982_14617__$1 = temp__5735__auto___14616;
if(cljs.core.chunked_seq_QMARK_(seq__13982_14617__$1)){
var c__4609__auto___14621 = cljs.core.chunk_first(seq__13982_14617__$1);
var G__14622 = cljs.core.chunk_rest(seq__13982_14617__$1);
var G__14623 = c__4609__auto___14621;
var G__14624 = cljs.core.count(c__4609__auto___14621);
var G__14625 = (0);
seq__13982_14566 = G__14622;
chunk__13983_14567 = G__14623;
count__13984_14568 = G__14624;
i__13985_14569 = G__14625;
continue;
} else {
var vec__14057_14645 = cljs.core.first(seq__13982_14617__$1);
var column_14646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14057_14645,(0),null);
var column_info_14647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14057_14645,(1),null);
var seq__14060_14649 = cljs.core.seq(column_info_14647);
var chunk__14061_14650 = null;
var count__14062_14651 = (0);
var i__14063_14652 = (0);
while(true){
if((i__14063_14652 < count__14062_14651)){
var map__14068_14656 = chunk__14061_14650.cljs$core$IIndexed$_nth$arity$2(null,i__14063_14652);
var map__14068_14657__$1 = (((((!((map__14068_14656 == null))))?(((((map__14068_14656.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14068_14656.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14068_14656):map__14068_14656);
var gline_14658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14068_14657__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14068_14657__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14068_14657__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14658], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14060_14649,chunk__14061_14650,count__14062_14651,i__14063_14652,seq__13982_14566,chunk__13983_14567,count__13984_14568,i__13985_14569,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14068_14656,map__14068_14657__$1,gline_14658,gcol_14659,name_14660,vec__14057_14645,column_14646,column_info_14647,seq__13982_14617__$1,temp__5735__auto___14616,vec__13979_14561,line_14562,columns_14563,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14659], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14562,new cljs.core.Keyword(null,"col","col",-1959363084),column_14646,new cljs.core.Keyword(null,"name","name",1843675177),name_14660], null));
});})(seq__14060_14649,chunk__14061_14650,count__14062_14651,i__14063_14652,seq__13982_14566,chunk__13983_14567,count__13984_14568,i__13985_14569,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14068_14656,map__14068_14657__$1,gline_14658,gcol_14659,name_14660,vec__14057_14645,column_14646,column_info_14647,seq__13982_14617__$1,temp__5735__auto___14616,vec__13979_14561,line_14562,columns_14563,inverted))
,cljs.core.sorted_map()));


var G__14664 = seq__14060_14649;
var G__14665 = chunk__14061_14650;
var G__14666 = count__14062_14651;
var G__14667 = (i__14063_14652 + (1));
seq__14060_14649 = G__14664;
chunk__14061_14650 = G__14665;
count__14062_14651 = G__14666;
i__14063_14652 = G__14667;
continue;
} else {
var temp__5735__auto___14668__$1 = cljs.core.seq(seq__14060_14649);
if(temp__5735__auto___14668__$1){
var seq__14060_14669__$1 = temp__5735__auto___14668__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14060_14669__$1)){
var c__4609__auto___14670 = cljs.core.chunk_first(seq__14060_14669__$1);
var G__14671 = cljs.core.chunk_rest(seq__14060_14669__$1);
var G__14672 = c__4609__auto___14670;
var G__14673 = cljs.core.count(c__4609__auto___14670);
var G__14674 = (0);
seq__14060_14649 = G__14671;
chunk__14061_14650 = G__14672;
count__14062_14651 = G__14673;
i__14063_14652 = G__14674;
continue;
} else {
var map__14070_14675 = cljs.core.first(seq__14060_14669__$1);
var map__14070_14676__$1 = (((((!((map__14070_14675 == null))))?(((((map__14070_14675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14070_14675.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14070_14675):map__14070_14675);
var gline_14677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14070_14676__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14070_14676__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14070_14676__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14677], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14060_14649,chunk__14061_14650,count__14062_14651,i__14063_14652,seq__13982_14566,chunk__13983_14567,count__13984_14568,i__13985_14569,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14070_14675,map__14070_14676__$1,gline_14677,gcol_14678,name_14679,seq__14060_14669__$1,temp__5735__auto___14668__$1,vec__14057_14645,column_14646,column_info_14647,seq__13982_14617__$1,temp__5735__auto___14616,vec__13979_14561,line_14562,columns_14563,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14678], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14562,new cljs.core.Keyword(null,"col","col",-1959363084),column_14646,new cljs.core.Keyword(null,"name","name",1843675177),name_14679], null));
});})(seq__14060_14649,chunk__14061_14650,count__14062_14651,i__14063_14652,seq__13982_14566,chunk__13983_14567,count__13984_14568,i__13985_14569,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14070_14675,map__14070_14676__$1,gline_14677,gcol_14678,name_14679,seq__14060_14669__$1,temp__5735__auto___14668__$1,vec__14057_14645,column_14646,column_info_14647,seq__13982_14617__$1,temp__5735__auto___14616,vec__13979_14561,line_14562,columns_14563,inverted))
,cljs.core.sorted_map()));


var G__14681 = cljs.core.next(seq__14060_14669__$1);
var G__14682 = null;
var G__14683 = (0);
var G__14684 = (0);
seq__14060_14649 = G__14681;
chunk__14061_14650 = G__14682;
count__14062_14651 = G__14683;
i__14063_14652 = G__14684;
continue;
}
} else {
}
}
break;
}


var G__14685 = cljs.core.next(seq__13982_14617__$1);
var G__14686 = null;
var G__14687 = (0);
var G__14688 = (0);
seq__13982_14566 = G__14685;
chunk__13983_14567 = G__14686;
count__13984_14568 = G__14687;
i__13985_14569 = G__14688;
continue;
}
} else {
}
}
break;
}


var G__14690 = seq__13814_14531;
var G__14691 = chunk__13815_14533;
var G__14692 = count__13816_14534;
var G__14693 = (i__13817_14535 + (1));
seq__13814_14531 = G__14690;
chunk__13815_14533 = G__14691;
count__13816_14534 = G__14692;
i__13817_14535 = G__14693;
continue;
} else {
var temp__5735__auto___14697 = cljs.core.seq(seq__13814_14531);
if(temp__5735__auto___14697){
var seq__13814_14698__$1 = temp__5735__auto___14697;
if(cljs.core.chunked_seq_QMARK_(seq__13814_14698__$1)){
var c__4609__auto___14699 = cljs.core.chunk_first(seq__13814_14698__$1);
var G__14700 = cljs.core.chunk_rest(seq__13814_14698__$1);
var G__14701 = c__4609__auto___14699;
var G__14702 = cljs.core.count(c__4609__auto___14699);
var G__14703 = (0);
seq__13814_14531 = G__14700;
chunk__13815_14533 = G__14701;
count__13816_14534 = G__14702;
i__13817_14535 = G__14703;
continue;
} else {
var vec__14076_14704 = cljs.core.first(seq__13814_14698__$1);
var line_14705 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14076_14704,(0),null);
var columns_14706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14076_14704,(1),null);
var seq__14079_14725 = cljs.core.seq(columns_14706);
var chunk__14080_14726 = null;
var count__14081_14727 = (0);
var i__14082_14728 = (0);
while(true){
if((i__14082_14728 < count__14081_14727)){
var vec__14122_14731 = chunk__14080_14726.cljs$core$IIndexed$_nth$arity$2(null,i__14082_14728);
var column_14732 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14122_14731,(0),null);
var column_info_14733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14122_14731,(1),null);
var seq__14125_14734 = cljs.core.seq(column_info_14733);
var chunk__14126_14735 = null;
var count__14127_14736 = (0);
var i__14128_14737 = (0);
while(true){
if((i__14128_14737 < count__14127_14736)){
var map__14143_14740 = chunk__14126_14735.cljs$core$IIndexed$_nth$arity$2(null,i__14128_14737);
var map__14143_14741__$1 = (((((!((map__14143_14740 == null))))?(((((map__14143_14740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14143_14740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14143_14740):map__14143_14740);
var gline_14742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14143_14741__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14143_14741__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14143_14741__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14742], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14125_14734,chunk__14126_14735,count__14127_14736,i__14128_14737,seq__14079_14725,chunk__14080_14726,count__14081_14727,i__14082_14728,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14143_14740,map__14143_14741__$1,gline_14742,gcol_14743,name_14744,vec__14122_14731,column_14732,column_info_14733,vec__14076_14704,line_14705,columns_14706,seq__13814_14698__$1,temp__5735__auto___14697,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14743], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14705,new cljs.core.Keyword(null,"col","col",-1959363084),column_14732,new cljs.core.Keyword(null,"name","name",1843675177),name_14744], null));
});})(seq__14125_14734,chunk__14126_14735,count__14127_14736,i__14128_14737,seq__14079_14725,chunk__14080_14726,count__14081_14727,i__14082_14728,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14143_14740,map__14143_14741__$1,gline_14742,gcol_14743,name_14744,vec__14122_14731,column_14732,column_info_14733,vec__14076_14704,line_14705,columns_14706,seq__13814_14698__$1,temp__5735__auto___14697,inverted))
,cljs.core.sorted_map()));


var G__14747 = seq__14125_14734;
var G__14748 = chunk__14126_14735;
var G__14749 = count__14127_14736;
var G__14750 = (i__14128_14737 + (1));
seq__14125_14734 = G__14747;
chunk__14126_14735 = G__14748;
count__14127_14736 = G__14749;
i__14128_14737 = G__14750;
continue;
} else {
var temp__5735__auto___14751__$1 = cljs.core.seq(seq__14125_14734);
if(temp__5735__auto___14751__$1){
var seq__14125_14752__$1 = temp__5735__auto___14751__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14125_14752__$1)){
var c__4609__auto___14753 = cljs.core.chunk_first(seq__14125_14752__$1);
var G__14754 = cljs.core.chunk_rest(seq__14125_14752__$1);
var G__14755 = c__4609__auto___14753;
var G__14756 = cljs.core.count(c__4609__auto___14753);
var G__14757 = (0);
seq__14125_14734 = G__14754;
chunk__14126_14735 = G__14755;
count__14127_14736 = G__14756;
i__14128_14737 = G__14757;
continue;
} else {
var map__14145_14758 = cljs.core.first(seq__14125_14752__$1);
var map__14145_14759__$1 = (((((!((map__14145_14758 == null))))?(((((map__14145_14758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14145_14758.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14145_14758):map__14145_14758);
var gline_14760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14145_14759__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14145_14759__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14762 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14145_14759__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14760], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14125_14734,chunk__14126_14735,count__14127_14736,i__14128_14737,seq__14079_14725,chunk__14080_14726,count__14081_14727,i__14082_14728,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14145_14758,map__14145_14759__$1,gline_14760,gcol_14761,name_14762,seq__14125_14752__$1,temp__5735__auto___14751__$1,vec__14122_14731,column_14732,column_info_14733,vec__14076_14704,line_14705,columns_14706,seq__13814_14698__$1,temp__5735__auto___14697,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14761], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14705,new cljs.core.Keyword(null,"col","col",-1959363084),column_14732,new cljs.core.Keyword(null,"name","name",1843675177),name_14762], null));
});})(seq__14125_14734,chunk__14126_14735,count__14127_14736,i__14128_14737,seq__14079_14725,chunk__14080_14726,count__14081_14727,i__14082_14728,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14145_14758,map__14145_14759__$1,gline_14760,gcol_14761,name_14762,seq__14125_14752__$1,temp__5735__auto___14751__$1,vec__14122_14731,column_14732,column_info_14733,vec__14076_14704,line_14705,columns_14706,seq__13814_14698__$1,temp__5735__auto___14697,inverted))
,cljs.core.sorted_map()));


var G__14772 = cljs.core.next(seq__14125_14752__$1);
var G__14773 = null;
var G__14774 = (0);
var G__14775 = (0);
seq__14125_14734 = G__14772;
chunk__14126_14735 = G__14773;
count__14127_14736 = G__14774;
i__14128_14737 = G__14775;
continue;
}
} else {
}
}
break;
}


var G__14778 = seq__14079_14725;
var G__14779 = chunk__14080_14726;
var G__14780 = count__14081_14727;
var G__14781 = (i__14082_14728 + (1));
seq__14079_14725 = G__14778;
chunk__14080_14726 = G__14779;
count__14081_14727 = G__14780;
i__14082_14728 = G__14781;
continue;
} else {
var temp__5735__auto___14783__$1 = cljs.core.seq(seq__14079_14725);
if(temp__5735__auto___14783__$1){
var seq__14079_14784__$1 = temp__5735__auto___14783__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14079_14784__$1)){
var c__4609__auto___14785 = cljs.core.chunk_first(seq__14079_14784__$1);
var G__14787 = cljs.core.chunk_rest(seq__14079_14784__$1);
var G__14788 = c__4609__auto___14785;
var G__14789 = cljs.core.count(c__4609__auto___14785);
var G__14790 = (0);
seq__14079_14725 = G__14787;
chunk__14080_14726 = G__14788;
count__14081_14727 = G__14789;
i__14082_14728 = G__14790;
continue;
} else {
var vec__14151_14791 = cljs.core.first(seq__14079_14784__$1);
var column_14792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14151_14791,(0),null);
var column_info_14793 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14151_14791,(1),null);
var seq__14154_14794 = cljs.core.seq(column_info_14793);
var chunk__14155_14795 = null;
var count__14156_14796 = (0);
var i__14157_14797 = (0);
while(true){
if((i__14157_14797 < count__14156_14796)){
var map__14162_14798 = chunk__14155_14795.cljs$core$IIndexed$_nth$arity$2(null,i__14157_14797);
var map__14162_14799__$1 = (((((!((map__14162_14798 == null))))?(((((map__14162_14798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14162_14798.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14162_14798):map__14162_14798);
var gline_14800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14162_14799__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14162_14799__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14162_14799__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14800], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14154_14794,chunk__14155_14795,count__14156_14796,i__14157_14797,seq__14079_14725,chunk__14080_14726,count__14081_14727,i__14082_14728,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14162_14798,map__14162_14799__$1,gline_14800,gcol_14801,name_14802,vec__14151_14791,column_14792,column_info_14793,seq__14079_14784__$1,temp__5735__auto___14783__$1,vec__14076_14704,line_14705,columns_14706,seq__13814_14698__$1,temp__5735__auto___14697,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14801], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14705,new cljs.core.Keyword(null,"col","col",-1959363084),column_14792,new cljs.core.Keyword(null,"name","name",1843675177),name_14802], null));
});})(seq__14154_14794,chunk__14155_14795,count__14156_14796,i__14157_14797,seq__14079_14725,chunk__14080_14726,count__14081_14727,i__14082_14728,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14162_14798,map__14162_14799__$1,gline_14800,gcol_14801,name_14802,vec__14151_14791,column_14792,column_info_14793,seq__14079_14784__$1,temp__5735__auto___14783__$1,vec__14076_14704,line_14705,columns_14706,seq__13814_14698__$1,temp__5735__auto___14697,inverted))
,cljs.core.sorted_map()));


var G__14805 = seq__14154_14794;
var G__14806 = chunk__14155_14795;
var G__14807 = count__14156_14796;
var G__14808 = (i__14157_14797 + (1));
seq__14154_14794 = G__14805;
chunk__14155_14795 = G__14806;
count__14156_14796 = G__14807;
i__14157_14797 = G__14808;
continue;
} else {
var temp__5735__auto___14809__$2 = cljs.core.seq(seq__14154_14794);
if(temp__5735__auto___14809__$2){
var seq__14154_14810__$1 = temp__5735__auto___14809__$2;
if(cljs.core.chunked_seq_QMARK_(seq__14154_14810__$1)){
var c__4609__auto___14811 = cljs.core.chunk_first(seq__14154_14810__$1);
var G__14816 = cljs.core.chunk_rest(seq__14154_14810__$1);
var G__14817 = c__4609__auto___14811;
var G__14818 = cljs.core.count(c__4609__auto___14811);
var G__14819 = (0);
seq__14154_14794 = G__14816;
chunk__14155_14795 = G__14817;
count__14156_14796 = G__14818;
i__14157_14797 = G__14819;
continue;
} else {
var map__14164_14821 = cljs.core.first(seq__14154_14810__$1);
var map__14164_14822__$1 = (((((!((map__14164_14821 == null))))?(((((map__14164_14821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14164_14821.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14164_14821):map__14164_14821);
var gline_14823 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14164_14822__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14824 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14164_14822__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14164_14822__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14823], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14154_14794,chunk__14155_14795,count__14156_14796,i__14157_14797,seq__14079_14725,chunk__14080_14726,count__14081_14727,i__14082_14728,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14164_14821,map__14164_14822__$1,gline_14823,gcol_14824,name_14825,seq__14154_14810__$1,temp__5735__auto___14809__$2,vec__14151_14791,column_14792,column_info_14793,seq__14079_14784__$1,temp__5735__auto___14783__$1,vec__14076_14704,line_14705,columns_14706,seq__13814_14698__$1,temp__5735__auto___14697,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14824], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14705,new cljs.core.Keyword(null,"col","col",-1959363084),column_14792,new cljs.core.Keyword(null,"name","name",1843675177),name_14825], null));
});})(seq__14154_14794,chunk__14155_14795,count__14156_14796,i__14157_14797,seq__14079_14725,chunk__14080_14726,count__14081_14727,i__14082_14728,seq__13814_14531,chunk__13815_14533,count__13816_14534,i__13817_14535,map__14164_14821,map__14164_14822__$1,gline_14823,gcol_14824,name_14825,seq__14154_14810__$1,temp__5735__auto___14809__$2,vec__14151_14791,column_14792,column_info_14793,seq__14079_14784__$1,temp__5735__auto___14783__$1,vec__14076_14704,line_14705,columns_14706,seq__13814_14698__$1,temp__5735__auto___14697,inverted))
,cljs.core.sorted_map()));


var G__14829 = cljs.core.next(seq__14154_14810__$1);
var G__14830 = null;
var G__14831 = (0);
var G__14832 = (0);
seq__14154_14794 = G__14829;
chunk__14155_14795 = G__14830;
count__14156_14796 = G__14831;
i__14157_14797 = G__14832;
continue;
}
} else {
}
}
break;
}


var G__14833 = cljs.core.next(seq__14079_14784__$1);
var G__14834 = null;
var G__14835 = (0);
var G__14836 = (0);
seq__14079_14725 = G__14833;
chunk__14080_14726 = G__14834;
count__14081_14727 = G__14835;
i__14082_14728 = G__14836;
continue;
}
} else {
}
}
break;
}


var G__14837 = cljs.core.next(seq__13814_14698__$1);
var G__14838 = null;
var G__14839 = (0);
var G__14840 = (0);
seq__13814_14531 = G__14837;
chunk__13815_14533 = G__14838;
count__13816_14534 = G__14839;
i__13817_14535 = G__14840;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
