goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__13296){
var vec__13297 = p__13296;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__13300 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13300,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__13303 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13303,(4),null);
var vec__13306 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13306,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__13328 = segmap;
var map__13328__$1 = (((((!((map__13328 == null))))?(((((map__13328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13328.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13328):map__13328);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13328__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13328__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13328__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13328__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13328__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__13338 = arguments.length;
switch (G__13338) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13354 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14428 = cljs.core.next(segs__$1);
var G__14429 = nrelseg;
var G__14430 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14428;
relseg__$1 = G__14429;
result__$1 = G__14430;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13354,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13354,(1),null);
var G__14432 = (gline + (1));
var G__14433 = cljs.core.next(lines__$1);
var G__14434 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14435 = result__$1;
gline = G__14432;
lines__$1 = G__14433;
relseg = G__14434;
result = G__14435;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__13361 = segmap;
var map__13361__$1 = (((((!((map__13361 == null))))?(((((map__13361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13361.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13361):map__13361);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13361__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13361__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13361__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13361__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13361__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__13360_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__13360_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__13364 = arguments.length;
switch (G__13364) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13368 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14453 = cljs.core.next(segs__$1);
var G__14454 = nrelseg;
var G__14455 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14453;
relseg__$1 = G__14454;
result__$1 = G__14455;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13368,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13368,(1),null);
var G__14456 = (gline + (1));
var G__14457 = cljs.core.next(lines__$1);
var G__14458 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14459 = result__$1;
gline = G__14456;
lines__$1 = G__14457;
relseg = G__14458;
result = G__14459;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13379){
var vec__13380 = p__13379;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13380,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13380,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13380,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13380,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13380,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__13383){
var vec__13384 = p__13383;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13384,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13384,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13384,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13384,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13384,(4),null);
var seg = vec__13384;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13387){
var vec__13388 = p__13387;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13388,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13388,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13388,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13388,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13388,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__13409 = cljs.core.seq(infos);
var chunk__13410 = null;
var count__13411 = (0);
var i__13412 = (0);
while(true){
if((i__13412 < count__13411)){
var info = chunk__13410.cljs$core$IIndexed$_nth$arity$2(null,i__13412);
var segv_14504 = info__GT_segv(info,source_idx,line,col);
var gline_14505 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14506 = cljs.core.count(cljs.core.deref(lines));
if((gline_14505 > (lc_14506 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13409,chunk__13410,count__13411,i__13412,segv_14504,gline_14505,lc_14506,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14505 - (lc_14506 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14504], null));
});})(seq__13409,chunk__13410,count__13411,i__13412,segv_14504,gline_14505,lc_14506,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13409,chunk__13410,count__13411,i__13412,segv_14504,gline_14505,lc_14506,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14505], null),cljs.core.conj,segv_14504);
});})(seq__13409,chunk__13410,count__13411,i__13412,segv_14504,gline_14505,lc_14506,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14509 = seq__13409;
var G__14510 = chunk__13410;
var G__14511 = count__13411;
var G__14512 = (i__13412 + (1));
seq__13409 = G__14509;
chunk__13410 = G__14510;
count__13411 = G__14511;
i__13412 = G__14512;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__13409);
if(temp__5735__auto__){
var seq__13409__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__13409__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__13409__$1);
var G__14543 = cljs.core.chunk_rest(seq__13409__$1);
var G__14544 = c__4609__auto__;
var G__14545 = cljs.core.count(c__4609__auto__);
var G__14546 = (0);
seq__13409 = G__14543;
chunk__13410 = G__14544;
count__13411 = G__14545;
i__13412 = G__14546;
continue;
} else {
var info = cljs.core.first(seq__13409__$1);
var segv_14547 = info__GT_segv(info,source_idx,line,col);
var gline_14548 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14549 = cljs.core.count(cljs.core.deref(lines));
if((gline_14548 > (lc_14549 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13409,chunk__13410,count__13411,i__13412,segv_14547,gline_14548,lc_14549,info,seq__13409__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14548 - (lc_14549 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14547], null));
});})(seq__13409,chunk__13410,count__13411,i__13412,segv_14547,gline_14548,lc_14549,info,seq__13409__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13409,chunk__13410,count__13411,i__13412,segv_14547,gline_14548,lc_14549,info,seq__13409__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14548], null),cljs.core.conj,segv_14547);
});})(seq__13409,chunk__13410,count__13411,i__13412,segv_14547,gline_14548,lc_14549,info,seq__13409__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14556 = cljs.core.next(seq__13409__$1);
var G__14557 = null;
var G__14558 = (0);
var G__14559 = (0);
seq__13409 = G__14556;
chunk__13410 = G__14557;
count__13411 = G__14558;
i__13412 = G__14559;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__13418_14560 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__13419_14561 = null;
var count__13420_14562 = (0);
var i__13421_14563 = (0);
while(true){
if((i__13421_14563 < count__13420_14562)){
var vec__13606_14564 = chunk__13419_14561.cljs$core$IIndexed$_nth$arity$2(null,i__13421_14563);
var source_idx_14565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13606_14564,(0),null);
var vec__13609_14566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13606_14564,(1),null);
var __14567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13609_14566,(0),null);
var lines_14568__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13609_14566,(1),null);
var seq__13612_14569 = cljs.core.seq(lines_14568__$1);
var chunk__13613_14570 = null;
var count__13614_14571 = (0);
var i__13615_14572 = (0);
while(true){
if((i__13615_14572 < count__13614_14571)){
var vec__13658_14573 = chunk__13613_14570.cljs$core$IIndexed$_nth$arity$2(null,i__13615_14572);
var line_14574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13658_14573,(0),null);
var cols_14575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13658_14573,(1),null);
var seq__13661_14576 = cljs.core.seq(cols_14575);
var chunk__13662_14577 = null;
var count__13663_14578 = (0);
var i__13664_14579 = (0);
while(true){
if((i__13664_14579 < count__13663_14578)){
var vec__13671_14580 = chunk__13662_14577.cljs$core$IIndexed$_nth$arity$2(null,i__13664_14579);
var col_14581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13671_14580,(0),null);
var infos_14582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13671_14580,(1),null);
encode_cols(infos_14582,source_idx_14565,line_14574,col_14581);


var G__14583 = seq__13661_14576;
var G__14584 = chunk__13662_14577;
var G__14585 = count__13663_14578;
var G__14586 = (i__13664_14579 + (1));
seq__13661_14576 = G__14583;
chunk__13662_14577 = G__14584;
count__13663_14578 = G__14585;
i__13664_14579 = G__14586;
continue;
} else {
var temp__5735__auto___14587 = cljs.core.seq(seq__13661_14576);
if(temp__5735__auto___14587){
var seq__13661_14588__$1 = temp__5735__auto___14587;
if(cljs.core.chunked_seq_QMARK_(seq__13661_14588__$1)){
var c__4609__auto___14589 = cljs.core.chunk_first(seq__13661_14588__$1);
var G__14590 = cljs.core.chunk_rest(seq__13661_14588__$1);
var G__14591 = c__4609__auto___14589;
var G__14592 = cljs.core.count(c__4609__auto___14589);
var G__14593 = (0);
seq__13661_14576 = G__14590;
chunk__13662_14577 = G__14591;
count__13663_14578 = G__14592;
i__13664_14579 = G__14593;
continue;
} else {
var vec__13674_14594 = cljs.core.first(seq__13661_14588__$1);
var col_14595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13674_14594,(0),null);
var infos_14596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13674_14594,(1),null);
encode_cols(infos_14596,source_idx_14565,line_14574,col_14595);


var G__14597 = cljs.core.next(seq__13661_14588__$1);
var G__14598 = null;
var G__14599 = (0);
var G__14600 = (0);
seq__13661_14576 = G__14597;
chunk__13662_14577 = G__14598;
count__13663_14578 = G__14599;
i__13664_14579 = G__14600;
continue;
}
} else {
}
}
break;
}


var G__14601 = seq__13612_14569;
var G__14602 = chunk__13613_14570;
var G__14603 = count__13614_14571;
var G__14604 = (i__13615_14572 + (1));
seq__13612_14569 = G__14601;
chunk__13613_14570 = G__14602;
count__13614_14571 = G__14603;
i__13615_14572 = G__14604;
continue;
} else {
var temp__5735__auto___14605 = cljs.core.seq(seq__13612_14569);
if(temp__5735__auto___14605){
var seq__13612_14606__$1 = temp__5735__auto___14605;
if(cljs.core.chunked_seq_QMARK_(seq__13612_14606__$1)){
var c__4609__auto___14609 = cljs.core.chunk_first(seq__13612_14606__$1);
var G__14610 = cljs.core.chunk_rest(seq__13612_14606__$1);
var G__14611 = c__4609__auto___14609;
var G__14612 = cljs.core.count(c__4609__auto___14609);
var G__14613 = (0);
seq__13612_14569 = G__14610;
chunk__13613_14570 = G__14611;
count__13614_14571 = G__14612;
i__13615_14572 = G__14613;
continue;
} else {
var vec__13677_14625 = cljs.core.first(seq__13612_14606__$1);
var line_14626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13677_14625,(0),null);
var cols_14627 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13677_14625,(1),null);
var seq__13680_14628 = cljs.core.seq(cols_14627);
var chunk__13681_14629 = null;
var count__13682_14630 = (0);
var i__13683_14631 = (0);
while(true){
if((i__13683_14631 < count__13682_14630)){
var vec__13690_14632 = chunk__13681_14629.cljs$core$IIndexed$_nth$arity$2(null,i__13683_14631);
var col_14633 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13690_14632,(0),null);
var infos_14634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13690_14632,(1),null);
encode_cols(infos_14634,source_idx_14565,line_14626,col_14633);


var G__14635 = seq__13680_14628;
var G__14636 = chunk__13681_14629;
var G__14637 = count__13682_14630;
var G__14638 = (i__13683_14631 + (1));
seq__13680_14628 = G__14635;
chunk__13681_14629 = G__14636;
count__13682_14630 = G__14637;
i__13683_14631 = G__14638;
continue;
} else {
var temp__5735__auto___14639__$1 = cljs.core.seq(seq__13680_14628);
if(temp__5735__auto___14639__$1){
var seq__13680_14640__$1 = temp__5735__auto___14639__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13680_14640__$1)){
var c__4609__auto___14641 = cljs.core.chunk_first(seq__13680_14640__$1);
var G__14642 = cljs.core.chunk_rest(seq__13680_14640__$1);
var G__14643 = c__4609__auto___14641;
var G__14644 = cljs.core.count(c__4609__auto___14641);
var G__14645 = (0);
seq__13680_14628 = G__14642;
chunk__13681_14629 = G__14643;
count__13682_14630 = G__14644;
i__13683_14631 = G__14645;
continue;
} else {
var vec__13693_14646 = cljs.core.first(seq__13680_14640__$1);
var col_14647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13693_14646,(0),null);
var infos_14648 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13693_14646,(1),null);
encode_cols(infos_14648,source_idx_14565,line_14626,col_14647);


var G__14649 = cljs.core.next(seq__13680_14640__$1);
var G__14650 = null;
var G__14651 = (0);
var G__14652 = (0);
seq__13680_14628 = G__14649;
chunk__13681_14629 = G__14650;
count__13682_14630 = G__14651;
i__13683_14631 = G__14652;
continue;
}
} else {
}
}
break;
}


var G__14653 = cljs.core.next(seq__13612_14606__$1);
var G__14654 = null;
var G__14655 = (0);
var G__14656 = (0);
seq__13612_14569 = G__14653;
chunk__13613_14570 = G__14654;
count__13614_14571 = G__14655;
i__13615_14572 = G__14656;
continue;
}
} else {
}
}
break;
}


var G__14657 = seq__13418_14560;
var G__14658 = chunk__13419_14561;
var G__14659 = count__13420_14562;
var G__14660 = (i__13421_14563 + (1));
seq__13418_14560 = G__14657;
chunk__13419_14561 = G__14658;
count__13420_14562 = G__14659;
i__13421_14563 = G__14660;
continue;
} else {
var temp__5735__auto___14661 = cljs.core.seq(seq__13418_14560);
if(temp__5735__auto___14661){
var seq__13418_14662__$1 = temp__5735__auto___14661;
if(cljs.core.chunked_seq_QMARK_(seq__13418_14662__$1)){
var c__4609__auto___14663 = cljs.core.chunk_first(seq__13418_14662__$1);
var G__14664 = cljs.core.chunk_rest(seq__13418_14662__$1);
var G__14665 = c__4609__auto___14663;
var G__14666 = cljs.core.count(c__4609__auto___14663);
var G__14667 = (0);
seq__13418_14560 = G__14664;
chunk__13419_14561 = G__14665;
count__13420_14562 = G__14666;
i__13421_14563 = G__14667;
continue;
} else {
var vec__13696_14668 = cljs.core.first(seq__13418_14662__$1);
var source_idx_14669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13696_14668,(0),null);
var vec__13699_14670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13696_14668,(1),null);
var __14671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13699_14670,(0),null);
var lines_14672__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13699_14670,(1),null);
var seq__13702_14673 = cljs.core.seq(lines_14672__$1);
var chunk__13703_14674 = null;
var count__13704_14675 = (0);
var i__13705_14676 = (0);
while(true){
if((i__13705_14676 < count__13704_14675)){
var vec__13744_14682 = chunk__13703_14674.cljs$core$IIndexed$_nth$arity$2(null,i__13705_14676);
var line_14683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13744_14682,(0),null);
var cols_14684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13744_14682,(1),null);
var seq__13747_14685 = cljs.core.seq(cols_14684);
var chunk__13748_14686 = null;
var count__13749_14687 = (0);
var i__13750_14688 = (0);
while(true){
if((i__13750_14688 < count__13749_14687)){
var vec__13757_14689 = chunk__13748_14686.cljs$core$IIndexed$_nth$arity$2(null,i__13750_14688);
var col_14690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13757_14689,(0),null);
var infos_14691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13757_14689,(1),null);
encode_cols(infos_14691,source_idx_14669,line_14683,col_14690);


var G__14692 = seq__13747_14685;
var G__14693 = chunk__13748_14686;
var G__14694 = count__13749_14687;
var G__14695 = (i__13750_14688 + (1));
seq__13747_14685 = G__14692;
chunk__13748_14686 = G__14693;
count__13749_14687 = G__14694;
i__13750_14688 = G__14695;
continue;
} else {
var temp__5735__auto___14696__$1 = cljs.core.seq(seq__13747_14685);
if(temp__5735__auto___14696__$1){
var seq__13747_14697__$1 = temp__5735__auto___14696__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13747_14697__$1)){
var c__4609__auto___14698 = cljs.core.chunk_first(seq__13747_14697__$1);
var G__14699 = cljs.core.chunk_rest(seq__13747_14697__$1);
var G__14700 = c__4609__auto___14698;
var G__14701 = cljs.core.count(c__4609__auto___14698);
var G__14702 = (0);
seq__13747_14685 = G__14699;
chunk__13748_14686 = G__14700;
count__13749_14687 = G__14701;
i__13750_14688 = G__14702;
continue;
} else {
var vec__13760_14703 = cljs.core.first(seq__13747_14697__$1);
var col_14704 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13760_14703,(0),null);
var infos_14705 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13760_14703,(1),null);
encode_cols(infos_14705,source_idx_14669,line_14683,col_14704);


var G__14706 = cljs.core.next(seq__13747_14697__$1);
var G__14707 = null;
var G__14708 = (0);
var G__14709 = (0);
seq__13747_14685 = G__14706;
chunk__13748_14686 = G__14707;
count__13749_14687 = G__14708;
i__13750_14688 = G__14709;
continue;
}
} else {
}
}
break;
}


var G__14710 = seq__13702_14673;
var G__14711 = chunk__13703_14674;
var G__14712 = count__13704_14675;
var G__14713 = (i__13705_14676 + (1));
seq__13702_14673 = G__14710;
chunk__13703_14674 = G__14711;
count__13704_14675 = G__14712;
i__13705_14676 = G__14713;
continue;
} else {
var temp__5735__auto___14714__$1 = cljs.core.seq(seq__13702_14673);
if(temp__5735__auto___14714__$1){
var seq__13702_14715__$1 = temp__5735__auto___14714__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13702_14715__$1)){
var c__4609__auto___14716 = cljs.core.chunk_first(seq__13702_14715__$1);
var G__14717 = cljs.core.chunk_rest(seq__13702_14715__$1);
var G__14718 = c__4609__auto___14716;
var G__14719 = cljs.core.count(c__4609__auto___14716);
var G__14720 = (0);
seq__13702_14673 = G__14717;
chunk__13703_14674 = G__14718;
count__13704_14675 = G__14719;
i__13705_14676 = G__14720;
continue;
} else {
var vec__13767_14721 = cljs.core.first(seq__13702_14715__$1);
var line_14722 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13767_14721,(0),null);
var cols_14723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13767_14721,(1),null);
var seq__13771_14724 = cljs.core.seq(cols_14723);
var chunk__13772_14725 = null;
var count__13773_14726 = (0);
var i__13774_14727 = (0);
while(true){
if((i__13774_14727 < count__13773_14726)){
var vec__13781_14728 = chunk__13772_14725.cljs$core$IIndexed$_nth$arity$2(null,i__13774_14727);
var col_14729 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13781_14728,(0),null);
var infos_14730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13781_14728,(1),null);
encode_cols(infos_14730,source_idx_14669,line_14722,col_14729);


var G__14731 = seq__13771_14724;
var G__14732 = chunk__13772_14725;
var G__14733 = count__13773_14726;
var G__14734 = (i__13774_14727 + (1));
seq__13771_14724 = G__14731;
chunk__13772_14725 = G__14732;
count__13773_14726 = G__14733;
i__13774_14727 = G__14734;
continue;
} else {
var temp__5735__auto___14735__$2 = cljs.core.seq(seq__13771_14724);
if(temp__5735__auto___14735__$2){
var seq__13771_14736__$1 = temp__5735__auto___14735__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13771_14736__$1)){
var c__4609__auto___14737 = cljs.core.chunk_first(seq__13771_14736__$1);
var G__14738 = cljs.core.chunk_rest(seq__13771_14736__$1);
var G__14739 = c__4609__auto___14737;
var G__14740 = cljs.core.count(c__4609__auto___14737);
var G__14741 = (0);
seq__13771_14724 = G__14738;
chunk__13772_14725 = G__14739;
count__13773_14726 = G__14740;
i__13774_14727 = G__14741;
continue;
} else {
var vec__13784_14742 = cljs.core.first(seq__13771_14736__$1);
var col_14743 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13784_14742,(0),null);
var infos_14744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13784_14742,(1),null);
encode_cols(infos_14744,source_idx_14669,line_14722,col_14743);


var G__14745 = cljs.core.next(seq__13771_14736__$1);
var G__14746 = null;
var G__14747 = (0);
var G__14748 = (0);
seq__13771_14724 = G__14745;
chunk__13772_14725 = G__14746;
count__13773_14726 = G__14747;
i__13774_14727 = G__14748;
continue;
}
} else {
}
}
break;
}


var G__14749 = cljs.core.next(seq__13702_14715__$1);
var G__14750 = null;
var G__14751 = (0);
var G__14752 = (0);
seq__13702_14673 = G__14749;
chunk__13703_14674 = G__14750;
count__13704_14675 = G__14751;
i__13705_14676 = G__14752;
continue;
}
} else {
}
}
break;
}


var G__14753 = cljs.core.next(seq__13418_14662__$1);
var G__14754 = null;
var G__14755 = (0);
var G__14756 = (0);
seq__13418_14560 = G__14753;
chunk__13419_14561 = G__14754;
count__13420_14562 = G__14755;
i__13421_14563 = G__14756;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13787 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__13391_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__13391_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__13392_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__13392_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__13393_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__13393_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13790 = G__13787;
var G__13791_14767 = G__13790;
var G__13792_14768 = "sourcesContent";
var G__13793_14769 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__13791_14767,G__13792_14768,G__13793_14769);

return G__13790;
} else {
return G__13787;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13794 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13794,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13794,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13797 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13797,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13797,(1),null);
var G__14770 = cljs.core.next(col_map_seq);
var G__14771 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13797,col,infos,vec__13794,line,col_map){
return (function (v,p__13800){
var map__13801 = p__13800;
var map__13801__$1 = (((((!((map__13801 == null))))?(((((map__13801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13801.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13801):map__13801);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13801__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13801__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13797,col,infos,vec__13794,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14770;
new_cols = G__14771;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14772 = cljs.core.next(line_map_seq);
var G__14773 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14772;
new_lines = G__14773;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13803_14774 = cljs.core.seq(reverse_map);
var chunk__13804_14775 = null;
var count__13805_14776 = (0);
var i__13806_14777 = (0);
while(true){
if((i__13806_14777 < count__13805_14776)){
var vec__14005_14778 = chunk__13804_14775.cljs$core$IIndexed$_nth$arity$2(null,i__13806_14777);
var line_14779 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14005_14778,(0),null);
var columns_14780 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14005_14778,(1),null);
var seq__14008_14781 = cljs.core.seq(columns_14780);
var chunk__14009_14782 = null;
var count__14010_14783 = (0);
var i__14011_14784 = (0);
while(true){
if((i__14011_14784 < count__14010_14783)){
var vec__14095_14785 = chunk__14009_14782.cljs$core$IIndexed$_nth$arity$2(null,i__14011_14784);
var column_14786 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14095_14785,(0),null);
var column_info_14787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14095_14785,(1),null);
var seq__14099_14788 = cljs.core.seq(column_info_14787);
var chunk__14100_14789 = null;
var count__14101_14790 = (0);
var i__14102_14791 = (0);
while(true){
if((i__14102_14791 < count__14101_14790)){
var map__14136_14792 = chunk__14100_14789.cljs$core$IIndexed$_nth$arity$2(null,i__14102_14791);
var map__14136_14793__$1 = (((((!((map__14136_14792 == null))))?(((((map__14136_14792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14136_14792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14136_14792):map__14136_14792);
var gline_14794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14136_14793__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14795 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14136_14793__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14136_14793__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14794], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14099_14788,chunk__14100_14789,count__14101_14790,i__14102_14791,seq__14008_14781,chunk__14009_14782,count__14010_14783,i__14011_14784,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14136_14792,map__14136_14793__$1,gline_14794,gcol_14795,name_14796,vec__14095_14785,column_14786,column_info_14787,vec__14005_14778,line_14779,columns_14780,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14795], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14779,new cljs.core.Keyword(null,"col","col",-1959363084),column_14786,new cljs.core.Keyword(null,"name","name",1843675177),name_14796], null));
});})(seq__14099_14788,chunk__14100_14789,count__14101_14790,i__14102_14791,seq__14008_14781,chunk__14009_14782,count__14010_14783,i__14011_14784,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14136_14792,map__14136_14793__$1,gline_14794,gcol_14795,name_14796,vec__14095_14785,column_14786,column_info_14787,vec__14005_14778,line_14779,columns_14780,inverted))
,cljs.core.sorted_map()));


var G__14804 = seq__14099_14788;
var G__14805 = chunk__14100_14789;
var G__14806 = count__14101_14790;
var G__14807 = (i__14102_14791 + (1));
seq__14099_14788 = G__14804;
chunk__14100_14789 = G__14805;
count__14101_14790 = G__14806;
i__14102_14791 = G__14807;
continue;
} else {
var temp__5735__auto___14808 = cljs.core.seq(seq__14099_14788);
if(temp__5735__auto___14808){
var seq__14099_14809__$1 = temp__5735__auto___14808;
if(cljs.core.chunked_seq_QMARK_(seq__14099_14809__$1)){
var c__4609__auto___14810 = cljs.core.chunk_first(seq__14099_14809__$1);
var G__14811 = cljs.core.chunk_rest(seq__14099_14809__$1);
var G__14812 = c__4609__auto___14810;
var G__14813 = cljs.core.count(c__4609__auto___14810);
var G__14814 = (0);
seq__14099_14788 = G__14811;
chunk__14100_14789 = G__14812;
count__14101_14790 = G__14813;
i__14102_14791 = G__14814;
continue;
} else {
var map__14141_14815 = cljs.core.first(seq__14099_14809__$1);
var map__14141_14816__$1 = (((((!((map__14141_14815 == null))))?(((((map__14141_14815.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14141_14815.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14141_14815):map__14141_14815);
var gline_14817 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14141_14816__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14818 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14141_14816__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14819 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14141_14816__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14817], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14099_14788,chunk__14100_14789,count__14101_14790,i__14102_14791,seq__14008_14781,chunk__14009_14782,count__14010_14783,i__14011_14784,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14141_14815,map__14141_14816__$1,gline_14817,gcol_14818,name_14819,seq__14099_14809__$1,temp__5735__auto___14808,vec__14095_14785,column_14786,column_info_14787,vec__14005_14778,line_14779,columns_14780,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14818], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14779,new cljs.core.Keyword(null,"col","col",-1959363084),column_14786,new cljs.core.Keyword(null,"name","name",1843675177),name_14819], null));
});})(seq__14099_14788,chunk__14100_14789,count__14101_14790,i__14102_14791,seq__14008_14781,chunk__14009_14782,count__14010_14783,i__14011_14784,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14141_14815,map__14141_14816__$1,gline_14817,gcol_14818,name_14819,seq__14099_14809__$1,temp__5735__auto___14808,vec__14095_14785,column_14786,column_info_14787,vec__14005_14778,line_14779,columns_14780,inverted))
,cljs.core.sorted_map()));


var G__14820 = cljs.core.next(seq__14099_14809__$1);
var G__14821 = null;
var G__14822 = (0);
var G__14823 = (0);
seq__14099_14788 = G__14820;
chunk__14100_14789 = G__14821;
count__14101_14790 = G__14822;
i__14102_14791 = G__14823;
continue;
}
} else {
}
}
break;
}


var G__14824 = seq__14008_14781;
var G__14825 = chunk__14009_14782;
var G__14826 = count__14010_14783;
var G__14827 = (i__14011_14784 + (1));
seq__14008_14781 = G__14824;
chunk__14009_14782 = G__14825;
count__14010_14783 = G__14826;
i__14011_14784 = G__14827;
continue;
} else {
var temp__5735__auto___14828 = cljs.core.seq(seq__14008_14781);
if(temp__5735__auto___14828){
var seq__14008_14829__$1 = temp__5735__auto___14828;
if(cljs.core.chunked_seq_QMARK_(seq__14008_14829__$1)){
var c__4609__auto___14830 = cljs.core.chunk_first(seq__14008_14829__$1);
var G__14831 = cljs.core.chunk_rest(seq__14008_14829__$1);
var G__14832 = c__4609__auto___14830;
var G__14833 = cljs.core.count(c__4609__auto___14830);
var G__14834 = (0);
seq__14008_14781 = G__14831;
chunk__14009_14782 = G__14832;
count__14010_14783 = G__14833;
i__14011_14784 = G__14834;
continue;
} else {
var vec__14147_14835 = cljs.core.first(seq__14008_14829__$1);
var column_14836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14147_14835,(0),null);
var column_info_14837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14147_14835,(1),null);
var seq__14150_14838 = cljs.core.seq(column_info_14837);
var chunk__14151_14839 = null;
var count__14152_14840 = (0);
var i__14153_14841 = (0);
while(true){
if((i__14153_14841 < count__14152_14840)){
var map__14179_14842 = chunk__14151_14839.cljs$core$IIndexed$_nth$arity$2(null,i__14153_14841);
var map__14179_14843__$1 = (((((!((map__14179_14842 == null))))?(((((map__14179_14842.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14179_14842.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14179_14842):map__14179_14842);
var gline_14844 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14179_14843__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14179_14843__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14846 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14179_14843__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14844], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14150_14838,chunk__14151_14839,count__14152_14840,i__14153_14841,seq__14008_14781,chunk__14009_14782,count__14010_14783,i__14011_14784,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14179_14842,map__14179_14843__$1,gline_14844,gcol_14845,name_14846,vec__14147_14835,column_14836,column_info_14837,seq__14008_14829__$1,temp__5735__auto___14828,vec__14005_14778,line_14779,columns_14780,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14845], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14779,new cljs.core.Keyword(null,"col","col",-1959363084),column_14836,new cljs.core.Keyword(null,"name","name",1843675177),name_14846], null));
});})(seq__14150_14838,chunk__14151_14839,count__14152_14840,i__14153_14841,seq__14008_14781,chunk__14009_14782,count__14010_14783,i__14011_14784,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14179_14842,map__14179_14843__$1,gline_14844,gcol_14845,name_14846,vec__14147_14835,column_14836,column_info_14837,seq__14008_14829__$1,temp__5735__auto___14828,vec__14005_14778,line_14779,columns_14780,inverted))
,cljs.core.sorted_map()));


var G__14847 = seq__14150_14838;
var G__14848 = chunk__14151_14839;
var G__14849 = count__14152_14840;
var G__14850 = (i__14153_14841 + (1));
seq__14150_14838 = G__14847;
chunk__14151_14839 = G__14848;
count__14152_14840 = G__14849;
i__14153_14841 = G__14850;
continue;
} else {
var temp__5735__auto___14851__$1 = cljs.core.seq(seq__14150_14838);
if(temp__5735__auto___14851__$1){
var seq__14150_14852__$1 = temp__5735__auto___14851__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14150_14852__$1)){
var c__4609__auto___14853 = cljs.core.chunk_first(seq__14150_14852__$1);
var G__14854 = cljs.core.chunk_rest(seq__14150_14852__$1);
var G__14855 = c__4609__auto___14853;
var G__14856 = cljs.core.count(c__4609__auto___14853);
var G__14857 = (0);
seq__14150_14838 = G__14854;
chunk__14151_14839 = G__14855;
count__14152_14840 = G__14856;
i__14153_14841 = G__14857;
continue;
} else {
var map__14181_14858 = cljs.core.first(seq__14150_14852__$1);
var map__14181_14859__$1 = (((((!((map__14181_14858 == null))))?(((((map__14181_14858.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14181_14858.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14181_14858):map__14181_14858);
var gline_14860 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14181_14859__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14861 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14181_14859__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14862 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14181_14859__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14860], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14150_14838,chunk__14151_14839,count__14152_14840,i__14153_14841,seq__14008_14781,chunk__14009_14782,count__14010_14783,i__14011_14784,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14181_14858,map__14181_14859__$1,gline_14860,gcol_14861,name_14862,seq__14150_14852__$1,temp__5735__auto___14851__$1,vec__14147_14835,column_14836,column_info_14837,seq__14008_14829__$1,temp__5735__auto___14828,vec__14005_14778,line_14779,columns_14780,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14861], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14779,new cljs.core.Keyword(null,"col","col",-1959363084),column_14836,new cljs.core.Keyword(null,"name","name",1843675177),name_14862], null));
});})(seq__14150_14838,chunk__14151_14839,count__14152_14840,i__14153_14841,seq__14008_14781,chunk__14009_14782,count__14010_14783,i__14011_14784,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14181_14858,map__14181_14859__$1,gline_14860,gcol_14861,name_14862,seq__14150_14852__$1,temp__5735__auto___14851__$1,vec__14147_14835,column_14836,column_info_14837,seq__14008_14829__$1,temp__5735__auto___14828,vec__14005_14778,line_14779,columns_14780,inverted))
,cljs.core.sorted_map()));


var G__14881 = cljs.core.next(seq__14150_14852__$1);
var G__14882 = null;
var G__14883 = (0);
var G__14884 = (0);
seq__14150_14838 = G__14881;
chunk__14151_14839 = G__14882;
count__14152_14840 = G__14883;
i__14153_14841 = G__14884;
continue;
}
} else {
}
}
break;
}


var G__14885 = cljs.core.next(seq__14008_14829__$1);
var G__14886 = null;
var G__14887 = (0);
var G__14888 = (0);
seq__14008_14781 = G__14885;
chunk__14009_14782 = G__14886;
count__14010_14783 = G__14887;
i__14011_14784 = G__14888;
continue;
}
} else {
}
}
break;
}


var G__14889 = seq__13803_14774;
var G__14890 = chunk__13804_14775;
var G__14891 = count__13805_14776;
var G__14892 = (i__13806_14777 + (1));
seq__13803_14774 = G__14889;
chunk__13804_14775 = G__14890;
count__13805_14776 = G__14891;
i__13806_14777 = G__14892;
continue;
} else {
var temp__5735__auto___14893 = cljs.core.seq(seq__13803_14774);
if(temp__5735__auto___14893){
var seq__13803_14894__$1 = temp__5735__auto___14893;
if(cljs.core.chunked_seq_QMARK_(seq__13803_14894__$1)){
var c__4609__auto___14895 = cljs.core.chunk_first(seq__13803_14894__$1);
var G__14896 = cljs.core.chunk_rest(seq__13803_14894__$1);
var G__14897 = c__4609__auto___14895;
var G__14898 = cljs.core.count(c__4609__auto___14895);
var G__14899 = (0);
seq__13803_14774 = G__14896;
chunk__13804_14775 = G__14897;
count__13805_14776 = G__14898;
i__13806_14777 = G__14899;
continue;
} else {
var vec__14184_14900 = cljs.core.first(seq__13803_14894__$1);
var line_14901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14184_14900,(0),null);
var columns_14902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14184_14900,(1),null);
var seq__14187_14903 = cljs.core.seq(columns_14902);
var chunk__14188_14904 = null;
var count__14189_14905 = (0);
var i__14190_14906 = (0);
while(true){
if((i__14190_14906 < count__14189_14905)){
var vec__14264_14907 = chunk__14188_14904.cljs$core$IIndexed$_nth$arity$2(null,i__14190_14906);
var column_14908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14264_14907,(0),null);
var column_info_14909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14264_14907,(1),null);
var seq__14267_14910 = cljs.core.seq(column_info_14909);
var chunk__14268_14911 = null;
var count__14269_14912 = (0);
var i__14270_14913 = (0);
while(true){
if((i__14270_14913 < count__14269_14912)){
var map__14310_14914 = chunk__14268_14911.cljs$core$IIndexed$_nth$arity$2(null,i__14270_14913);
var map__14310_14915__$1 = (((((!((map__14310_14914 == null))))?(((((map__14310_14914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14310_14914.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14310_14914):map__14310_14914);
var gline_14916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14310_14915__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14310_14915__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14310_14915__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14916], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14267_14910,chunk__14268_14911,count__14269_14912,i__14270_14913,seq__14187_14903,chunk__14188_14904,count__14189_14905,i__14190_14906,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14310_14914,map__14310_14915__$1,gline_14916,gcol_14917,name_14918,vec__14264_14907,column_14908,column_info_14909,vec__14184_14900,line_14901,columns_14902,seq__13803_14894__$1,temp__5735__auto___14893,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14917], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14901,new cljs.core.Keyword(null,"col","col",-1959363084),column_14908,new cljs.core.Keyword(null,"name","name",1843675177),name_14918], null));
});})(seq__14267_14910,chunk__14268_14911,count__14269_14912,i__14270_14913,seq__14187_14903,chunk__14188_14904,count__14189_14905,i__14190_14906,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14310_14914,map__14310_14915__$1,gline_14916,gcol_14917,name_14918,vec__14264_14907,column_14908,column_info_14909,vec__14184_14900,line_14901,columns_14902,seq__13803_14894__$1,temp__5735__auto___14893,inverted))
,cljs.core.sorted_map()));


var G__14919 = seq__14267_14910;
var G__14920 = chunk__14268_14911;
var G__14921 = count__14269_14912;
var G__14922 = (i__14270_14913 + (1));
seq__14267_14910 = G__14919;
chunk__14268_14911 = G__14920;
count__14269_14912 = G__14921;
i__14270_14913 = G__14922;
continue;
} else {
var temp__5735__auto___14923__$1 = cljs.core.seq(seq__14267_14910);
if(temp__5735__auto___14923__$1){
var seq__14267_14924__$1 = temp__5735__auto___14923__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14267_14924__$1)){
var c__4609__auto___14925 = cljs.core.chunk_first(seq__14267_14924__$1);
var G__14926 = cljs.core.chunk_rest(seq__14267_14924__$1);
var G__14927 = c__4609__auto___14925;
var G__14928 = cljs.core.count(c__4609__auto___14925);
var G__14929 = (0);
seq__14267_14910 = G__14926;
chunk__14268_14911 = G__14927;
count__14269_14912 = G__14928;
i__14270_14913 = G__14929;
continue;
} else {
var map__14318_14930 = cljs.core.first(seq__14267_14924__$1);
var map__14318_14931__$1 = (((((!((map__14318_14930 == null))))?(((((map__14318_14930.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14318_14930.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14318_14930):map__14318_14930);
var gline_14932 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14318_14931__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14933 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14318_14931__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14934 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14318_14931__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14932], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14267_14910,chunk__14268_14911,count__14269_14912,i__14270_14913,seq__14187_14903,chunk__14188_14904,count__14189_14905,i__14190_14906,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14318_14930,map__14318_14931__$1,gline_14932,gcol_14933,name_14934,seq__14267_14924__$1,temp__5735__auto___14923__$1,vec__14264_14907,column_14908,column_info_14909,vec__14184_14900,line_14901,columns_14902,seq__13803_14894__$1,temp__5735__auto___14893,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14933], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14901,new cljs.core.Keyword(null,"col","col",-1959363084),column_14908,new cljs.core.Keyword(null,"name","name",1843675177),name_14934], null));
});})(seq__14267_14910,chunk__14268_14911,count__14269_14912,i__14270_14913,seq__14187_14903,chunk__14188_14904,count__14189_14905,i__14190_14906,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14318_14930,map__14318_14931__$1,gline_14932,gcol_14933,name_14934,seq__14267_14924__$1,temp__5735__auto___14923__$1,vec__14264_14907,column_14908,column_info_14909,vec__14184_14900,line_14901,columns_14902,seq__13803_14894__$1,temp__5735__auto___14893,inverted))
,cljs.core.sorted_map()));


var G__14946 = cljs.core.next(seq__14267_14924__$1);
var G__14947 = null;
var G__14948 = (0);
var G__14949 = (0);
seq__14267_14910 = G__14946;
chunk__14268_14911 = G__14947;
count__14269_14912 = G__14948;
i__14270_14913 = G__14949;
continue;
}
} else {
}
}
break;
}


var G__14950 = seq__14187_14903;
var G__14951 = chunk__14188_14904;
var G__14952 = count__14189_14905;
var G__14953 = (i__14190_14906 + (1));
seq__14187_14903 = G__14950;
chunk__14188_14904 = G__14951;
count__14189_14905 = G__14952;
i__14190_14906 = G__14953;
continue;
} else {
var temp__5735__auto___14954__$1 = cljs.core.seq(seq__14187_14903);
if(temp__5735__auto___14954__$1){
var seq__14187_14955__$1 = temp__5735__auto___14954__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14187_14955__$1)){
var c__4609__auto___14956 = cljs.core.chunk_first(seq__14187_14955__$1);
var G__14957 = cljs.core.chunk_rest(seq__14187_14955__$1);
var G__14958 = c__4609__auto___14956;
var G__14959 = cljs.core.count(c__4609__auto___14956);
var G__14960 = (0);
seq__14187_14903 = G__14957;
chunk__14188_14904 = G__14958;
count__14189_14905 = G__14959;
i__14190_14906 = G__14960;
continue;
} else {
var vec__14326_14961 = cljs.core.first(seq__14187_14955__$1);
var column_14962 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14326_14961,(0),null);
var column_info_14963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14326_14961,(1),null);
var seq__14329_14964 = cljs.core.seq(column_info_14963);
var chunk__14330_14965 = null;
var count__14331_14966 = (0);
var i__14332_14967 = (0);
while(true){
if((i__14332_14967 < count__14331_14966)){
var map__14372_14968 = chunk__14330_14965.cljs$core$IIndexed$_nth$arity$2(null,i__14332_14967);
var map__14372_14969__$1 = (((((!((map__14372_14968 == null))))?(((((map__14372_14968.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14372_14968.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14372_14968):map__14372_14968);
var gline_14970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14372_14969__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14971 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14372_14969__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14372_14969__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14970], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14329_14964,chunk__14330_14965,count__14331_14966,i__14332_14967,seq__14187_14903,chunk__14188_14904,count__14189_14905,i__14190_14906,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14372_14968,map__14372_14969__$1,gline_14970,gcol_14971,name_14972,vec__14326_14961,column_14962,column_info_14963,seq__14187_14955__$1,temp__5735__auto___14954__$1,vec__14184_14900,line_14901,columns_14902,seq__13803_14894__$1,temp__5735__auto___14893,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14971], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14901,new cljs.core.Keyword(null,"col","col",-1959363084),column_14962,new cljs.core.Keyword(null,"name","name",1843675177),name_14972], null));
});})(seq__14329_14964,chunk__14330_14965,count__14331_14966,i__14332_14967,seq__14187_14903,chunk__14188_14904,count__14189_14905,i__14190_14906,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14372_14968,map__14372_14969__$1,gline_14970,gcol_14971,name_14972,vec__14326_14961,column_14962,column_info_14963,seq__14187_14955__$1,temp__5735__auto___14954__$1,vec__14184_14900,line_14901,columns_14902,seq__13803_14894__$1,temp__5735__auto___14893,inverted))
,cljs.core.sorted_map()));


var G__14973 = seq__14329_14964;
var G__14974 = chunk__14330_14965;
var G__14975 = count__14331_14966;
var G__14976 = (i__14332_14967 + (1));
seq__14329_14964 = G__14973;
chunk__14330_14965 = G__14974;
count__14331_14966 = G__14975;
i__14332_14967 = G__14976;
continue;
} else {
var temp__5735__auto___14977__$2 = cljs.core.seq(seq__14329_14964);
if(temp__5735__auto___14977__$2){
var seq__14329_14978__$1 = temp__5735__auto___14977__$2;
if(cljs.core.chunked_seq_QMARK_(seq__14329_14978__$1)){
var c__4609__auto___14979 = cljs.core.chunk_first(seq__14329_14978__$1);
var G__14980 = cljs.core.chunk_rest(seq__14329_14978__$1);
var G__14981 = c__4609__auto___14979;
var G__14982 = cljs.core.count(c__4609__auto___14979);
var G__14983 = (0);
seq__14329_14964 = G__14980;
chunk__14330_14965 = G__14981;
count__14331_14966 = G__14982;
i__14332_14967 = G__14983;
continue;
} else {
var map__14376_14984 = cljs.core.first(seq__14329_14978__$1);
var map__14376_14985__$1 = (((((!((map__14376_14984 == null))))?(((((map__14376_14984.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14376_14984.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14376_14984):map__14376_14984);
var gline_14986 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14376_14985__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14987 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14376_14985__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14988 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14376_14985__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14986], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14329_14964,chunk__14330_14965,count__14331_14966,i__14332_14967,seq__14187_14903,chunk__14188_14904,count__14189_14905,i__14190_14906,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14376_14984,map__14376_14985__$1,gline_14986,gcol_14987,name_14988,seq__14329_14978__$1,temp__5735__auto___14977__$2,vec__14326_14961,column_14962,column_info_14963,seq__14187_14955__$1,temp__5735__auto___14954__$1,vec__14184_14900,line_14901,columns_14902,seq__13803_14894__$1,temp__5735__auto___14893,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14987], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14901,new cljs.core.Keyword(null,"col","col",-1959363084),column_14962,new cljs.core.Keyword(null,"name","name",1843675177),name_14988], null));
});})(seq__14329_14964,chunk__14330_14965,count__14331_14966,i__14332_14967,seq__14187_14903,chunk__14188_14904,count__14189_14905,i__14190_14906,seq__13803_14774,chunk__13804_14775,count__13805_14776,i__13806_14777,map__14376_14984,map__14376_14985__$1,gline_14986,gcol_14987,name_14988,seq__14329_14978__$1,temp__5735__auto___14977__$2,vec__14326_14961,column_14962,column_info_14963,seq__14187_14955__$1,temp__5735__auto___14954__$1,vec__14184_14900,line_14901,columns_14902,seq__13803_14894__$1,temp__5735__auto___14893,inverted))
,cljs.core.sorted_map()));


var G__15008 = cljs.core.next(seq__14329_14978__$1);
var G__15009 = null;
var G__15010 = (0);
var G__15011 = (0);
seq__14329_14964 = G__15008;
chunk__14330_14965 = G__15009;
count__14331_14966 = G__15010;
i__14332_14967 = G__15011;
continue;
}
} else {
}
}
break;
}


var G__15012 = cljs.core.next(seq__14187_14955__$1);
var G__15013 = null;
var G__15014 = (0);
var G__15015 = (0);
seq__14187_14903 = G__15012;
chunk__14188_14904 = G__15013;
count__14189_14905 = G__15014;
i__14190_14906 = G__15015;
continue;
}
} else {
}
}
break;
}


var G__15016 = cljs.core.next(seq__13803_14894__$1);
var G__15017 = null;
var G__15018 = (0);
var G__15019 = (0);
seq__13803_14774 = G__15016;
chunk__13804_14775 = G__15017;
count__13805_14776 = G__15018;
i__13806_14777 = G__15019;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
