goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__15332 = s;
var map__15332__$1 = (((((!((map__15332 == null))))?(((((map__15332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15332.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15332):map__15332);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15332__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15332__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__15335 = info;
var map__15336 = G__15335;
var map__15336__$1 = (((((!((map__15336 == null))))?(((((map__15336.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15336.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15336):map__15336);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15336__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__15335__$1 = G__15335;
while(true){
var d__$2 = d__$1;
var map__15340 = G__15335__$1;
var map__15340__$1 = (((((!((map__15340 == null))))?(((((map__15340.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15340.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15340):map__15340);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15340__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__16044 = (d__$2 + (1));
var G__16045 = shadow__$2;
d__$1 = G__16044;
G__15335__$1 = G__16045;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__15342){
var map__15394 = p__15342;
var map__15394__$1 = (((((!((map__15394 == null))))?(((((map__15394.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15394.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15394):map__15394);
var name_var = map__15394__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15394__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15394__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__15396 = info;
var map__15396__$1 = (((((!((map__15396 == null))))?(((((map__15396.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15396.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15396):map__15396);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15396__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15396__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__15398 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__15398) : cljs.compiler.munge.call(null,G__15398));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__15400 = arguments.length;
switch (G__15400) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__15401 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__15401.cljs$core$IFn$_invoke$arity$1 ? fexpr__15401.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__15401.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__15402 = cp;
switch (G__15402) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__15403_16052 = cljs.core.seq(s);
var chunk__15404_16053 = null;
var count__15405_16054 = (0);
var i__15406_16055 = (0);
while(true){
if((i__15406_16055 < count__15405_16054)){
var c_16056 = chunk__15404_16053.cljs$core$IIndexed$_nth$arity$2(null,i__15406_16055);
sb.append(cljs.compiler.escape_char(c_16056));


var G__16057 = seq__15403_16052;
var G__16058 = chunk__15404_16053;
var G__16059 = count__15405_16054;
var G__16060 = (i__15406_16055 + (1));
seq__15403_16052 = G__16057;
chunk__15404_16053 = G__16058;
count__15405_16054 = G__16059;
i__15406_16055 = G__16060;
continue;
} else {
var temp__5735__auto___16061 = cljs.core.seq(seq__15403_16052);
if(temp__5735__auto___16061){
var seq__15403_16062__$1 = temp__5735__auto___16061;
if(cljs.core.chunked_seq_QMARK_(seq__15403_16062__$1)){
var c__4609__auto___16063 = cljs.core.chunk_first(seq__15403_16062__$1);
var G__16064 = cljs.core.chunk_rest(seq__15403_16062__$1);
var G__16065 = c__4609__auto___16063;
var G__16066 = cljs.core.count(c__4609__auto___16063);
var G__16067 = (0);
seq__15403_16052 = G__16064;
chunk__15404_16053 = G__16065;
count__15405_16054 = G__16066;
i__15406_16055 = G__16067;
continue;
} else {
var c_16068 = cljs.core.first(seq__15403_16062__$1);
sb.append(cljs.compiler.escape_char(c_16068));


var G__16069 = cljs.core.next(seq__15403_16062__$1);
var G__16070 = null;
var G__16071 = (0);
var G__16072 = (0);
seq__15403_16052 = G__16069;
chunk__15404_16053 = G__16070;
count__15405_16054 = G__16071;
i__15406_16055 = G__16072;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15407 = cljs.core.get_global_hierarchy;
return (fexpr__15407.cljs$core$IFn$_invoke$arity$0 ? fexpr__15407.cljs$core$IFn$_invoke$arity$0() : fexpr__15407.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__15408_16073 = ast;
var map__15408_16074__$1 = (((((!((map__15408_16073 == null))))?(((((map__15408_16073.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15408_16073.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15408_16073):map__15408_16073);
var env_16075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15408_16074__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_16075))){
var map__15410_16076 = env_16075;
var map__15410_16077__$1 = (((((!((map__15410_16076 == null))))?(((((map__15410_16076.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15410_16076.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15410_16076):map__15410_16076);
var line_16078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15410_16077__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_16079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15410_16077__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__15412 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__15414 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__15413 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15413.cljs$core$IFn$_invoke$arity$1 ? fexpr__15413.cljs$core$IFn$_invoke$arity$1(G__15414) : fexpr__15413.call(null,G__15414));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15412,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__15412;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_16078 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_16079)?(column_16079 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__15423 = arguments.length;
switch (G__15423) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16097 = arguments.length;
var i__4790__auto___16098 = (0);
while(true){
if((i__4790__auto___16098 < len__4789__auto___16097)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16098]));

var G__16099 = (i__4790__auto___16098 + (1));
i__4790__auto___16098 = G__16099;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_16104 = (function (){var G__15424 = a;
if((!(typeof a === 'string'))){
return G__15424.toString();
} else {
return G__15424;
}
})();
var temp__5739__auto___16106 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___16106 == null)){
} else {
var sm_data_16108 = temp__5739__auto___16106;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_16108,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__15415_SHARP_){
return (p1__15415_SHARP_ + s_16104.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_16104], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15429 = cljs.core.seq(xs);
var chunk__15430 = null;
var count__15431 = (0);
var i__15432 = (0);
while(true){
if((i__15432 < count__15431)){
var x = chunk__15430.cljs$core$IIndexed$_nth$arity$2(null,i__15432);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16121 = seq__15429;
var G__16122 = chunk__15430;
var G__16123 = count__15431;
var G__16124 = (i__15432 + (1));
seq__15429 = G__16121;
chunk__15430 = G__16122;
count__15431 = G__16123;
i__15432 = G__16124;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15429);
if(temp__5735__auto__){
var seq__15429__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15429__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15429__$1);
var G__16125 = cljs.core.chunk_rest(seq__15429__$1);
var G__16126 = c__4609__auto__;
var G__16127 = cljs.core.count(c__4609__auto__);
var G__16128 = (0);
seq__15429 = G__16125;
chunk__15430 = G__16126;
count__15431 = G__16127;
i__15432 = G__16128;
continue;
} else {
var x = cljs.core.first(seq__15429__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16129 = cljs.core.next(seq__15429__$1);
var G__16130 = null;
var G__16131 = (0);
var G__16132 = (0);
seq__15429 = G__16129;
chunk__15430 = G__16130;
count__15431 = G__16131;
i__15432 = G__16132;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq15417){
var G__15418 = cljs.core.first(seq15417);
var seq15417__$1 = cljs.core.next(seq15417);
var G__15419 = cljs.core.first(seq15417__$1);
var seq15417__$2 = cljs.core.next(seq15417__$1);
var G__15420 = cljs.core.first(seq15417__$2);
var seq15417__$3 = cljs.core.next(seq15417__$2);
var G__15421 = cljs.core.first(seq15417__$3);
var seq15417__$4 = cljs.core.next(seq15417__$3);
var G__15422 = cljs.core.first(seq15417__$4);
var seq15417__$5 = cljs.core.next(seq15417__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15418,G__15419,G__15420,G__15421,G__15422,seq15417__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__15433){
var map__15434 = p__15433;
var map__15434__$1 = (((((!((map__15434 == null))))?(((((map__15434.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15434.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15434):map__15434);
var m = map__15434__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15434__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__15446 = arguments.length;
switch (G__15446) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16134 = arguments.length;
var i__4790__auto___16135 = (0);
while(true){
if((i__4790__auto___16135 < len__4789__auto___16134)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16135]));

var G__16136 = (i__4790__auto___16135 + (1));
i__4790__auto___16135 = G__16136;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15460_16137 = cljs.core.seq(xs);
var chunk__15461_16138 = null;
var count__15462_16139 = (0);
var i__15463_16140 = (0);
while(true){
if((i__15463_16140 < count__15462_16139)){
var x_16141 = chunk__15461_16138.cljs$core$IIndexed$_nth$arity$2(null,i__15463_16140);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16141);


var G__16142 = seq__15460_16137;
var G__16143 = chunk__15461_16138;
var G__16144 = count__15462_16139;
var G__16145 = (i__15463_16140 + (1));
seq__15460_16137 = G__16142;
chunk__15461_16138 = G__16143;
count__15462_16139 = G__16144;
i__15463_16140 = G__16145;
continue;
} else {
var temp__5735__auto___16146 = cljs.core.seq(seq__15460_16137);
if(temp__5735__auto___16146){
var seq__15460_16147__$1 = temp__5735__auto___16146;
if(cljs.core.chunked_seq_QMARK_(seq__15460_16147__$1)){
var c__4609__auto___16148 = cljs.core.chunk_first(seq__15460_16147__$1);
var G__16149 = cljs.core.chunk_rest(seq__15460_16147__$1);
var G__16150 = c__4609__auto___16148;
var G__16151 = cljs.core.count(c__4609__auto___16148);
var G__16152 = (0);
seq__15460_16137 = G__16149;
chunk__15461_16138 = G__16150;
count__15462_16139 = G__16151;
i__15463_16140 = G__16152;
continue;
} else {
var x_16153 = cljs.core.first(seq__15460_16147__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16153);


var G__16154 = cljs.core.next(seq__15460_16147__$1);
var G__16155 = null;
var G__16156 = (0);
var G__16157 = (0);
seq__15460_16137 = G__16154;
chunk__15461_16138 = G__16155;
count__15462_16139 = G__16156;
i__15463_16140 = G__16157;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq15440){
var G__15441 = cljs.core.first(seq15440);
var seq15440__$1 = cljs.core.next(seq15440);
var G__15442 = cljs.core.first(seq15440__$1);
var seq15440__$2 = cljs.core.next(seq15440__$1);
var G__15443 = cljs.core.first(seq15440__$2);
var seq15440__$3 = cljs.core.next(seq15440__$2);
var G__15444 = cljs.core.first(seq15440__$3);
var seq15440__$4 = cljs.core.next(seq15440__$3);
var G__15445 = cljs.core.first(seq15440__$4);
var seq15440__$5 = cljs.core.next(seq15440__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15441,G__15442,G__15443,G__15444,G__15445,seq15440__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__15466_16158 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__15467_16159 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__15468_16160 = true;
var _STAR_print_fn_STAR__temp_val__15469_16161 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__15468_16160);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__15469_16161);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__15467_16159);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__15466_16158);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15472 = cljs.core.get_global_hierarchy;
return (fexpr__15472.cljs$core$IFn$_invoke$arity$0 ? fexpr__15472.cljs$core$IFn$_invoke$arity$0() : fexpr__15472.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__15478 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15478,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15478,(1),null);
var G__15481 = ns;
var G__15482 = name;
var G__15483 = (function (){
var G__15484 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__15484) : cljs.compiler.emit_constant.call(null,G__15484));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__15481,G__15482,G__15483) : cljs.compiler.emit_record_value.call(null,G__15481,G__15482,G__15483));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__15485 = cljs.core.keys(x);
var G__15486 = cljs.core.vals(x);
var G__15487 = cljs.compiler.emit_constants_comma_sep;
var G__15488 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__15485,G__15486,G__15487,G__15488) : cljs.compiler.emit_map.call(null,G__15485,G__15486,G__15487,G__15488));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__15489 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__15490 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__15489,G__15490) : cljs.compiler.emit_with_meta.call(null,G__15489,G__15490));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__15491 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15491,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15491,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15491,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15499 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15499) : x.call(null,G__15499));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15500 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15500) : x.call(null,G__15500));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__15502 = items;
var G__15503 = (function (p1__15501_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__15501_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__15502,G__15503) : cljs.compiler.emit_js_object.call(null,G__15502,G__15503));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__15505){
var map__15506 = p__15505;
var map__15506__$1 = (((((!((map__15506 == null))))?(((((map__15506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15506.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15506):map__15506);
var ast = map__15506__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15506__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15506__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15506__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__15508 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15508__$1 = (((((!((map__15508 == null))))?(((((map__15508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15508.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15508):map__15508);
var cenv = map__15508__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15508__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__15512 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__15515 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__15515) : cljs.compiler.es5_GT__EQ_.call(null,G__15515));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__15512,cljs.analyzer.es5_allowed);
} else {
return G__15512;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__15516 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__15516,reserved);
} else {
return G__15516;
}
})();
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__15517_16174 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__15517_16175__$1 = (((G__15517_16174 instanceof cljs.core.Keyword))?G__15517_16174.fqn:null);
switch (G__15517_16175__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__15521){
var map__15522 = p__15521;
var map__15522__$1 = (((((!((map__15522 == null))))?(((((map__15522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15522):map__15522);
var arg = map__15522__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));


var map__15524 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__15524__$1 = (((((!((map__15524 == null))))?(((((map__15524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15524.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15524):map__15524);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15524__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__15548){
var map__15549 = p__15548;
var map__15549__$1 = (((((!((map__15549 == null))))?(((((map__15549.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15549.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15549):map__15549);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15549__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15549__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15549__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__15551_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__15551_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__15552 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15552) : comma_sep.call(null,G__15552));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__15553 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15553) : comma_sep.call(null,G__15553));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__15554){
var map__15555 = p__15554;
var map__15555__$1 = (((((!((map__15555 == null))))?(((((map__15555.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15555.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15555):map__15555);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15555__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15555__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15555__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__15558){
var map__15559 = p__15558;
var map__15559__$1 = (((((!((map__15559 == null))))?(((((map__15559.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15559.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15559):map__15559);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15559__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15559__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__15561_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__15561_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__15565 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15565) : comma_sep.call(null,G__15565));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__15567){
var map__15568 = p__15567;
var map__15568__$1 = (((((!((map__15568 == null))))?(((((map__15568.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15568.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15568):map__15568);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15568__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15568__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___16235 = cljs.core.seq(items);
if(temp__5735__auto___16235){
var items_16236__$1 = temp__5735__auto___16235;
var vec__15570_16237 = items_16236__$1;
var seq__15571_16238 = cljs.core.seq(vec__15570_16237);
var first__15572_16239 = cljs.core.first(seq__15571_16238);
var seq__15571_16240__$1 = cljs.core.next(seq__15571_16238);
var vec__15573_16241 = first__15572_16239;
var k_16242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15573_16241,(0),null);
var v_16243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15573_16241,(1),null);
var r_16244 = seq__15571_16240__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_16242),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16243) : emit_js_object_val.call(null,v_16243)));

var seq__15576_16245 = cljs.core.seq(r_16244);
var chunk__15577_16246 = null;
var count__15578_16247 = (0);
var i__15579_16248 = (0);
while(true){
if((i__15579_16248 < count__15578_16247)){
var vec__15586_16249 = chunk__15577_16246.cljs$core$IIndexed$_nth$arity$2(null,i__15579_16248);
var k_16250__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15586_16249,(0),null);
var v_16251__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15586_16249,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16250__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16251__$1) : emit_js_object_val.call(null,v_16251__$1)));


var G__16253 = seq__15576_16245;
var G__16254 = chunk__15577_16246;
var G__16255 = count__15578_16247;
var G__16256 = (i__15579_16248 + (1));
seq__15576_16245 = G__16253;
chunk__15577_16246 = G__16254;
count__15578_16247 = G__16255;
i__15579_16248 = G__16256;
continue;
} else {
var temp__5735__auto___16257__$1 = cljs.core.seq(seq__15576_16245);
if(temp__5735__auto___16257__$1){
var seq__15576_16259__$1 = temp__5735__auto___16257__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15576_16259__$1)){
var c__4609__auto___16260 = cljs.core.chunk_first(seq__15576_16259__$1);
var G__16261 = cljs.core.chunk_rest(seq__15576_16259__$1);
var G__16262 = c__4609__auto___16260;
var G__16263 = cljs.core.count(c__4609__auto___16260);
var G__16264 = (0);
seq__15576_16245 = G__16261;
chunk__15577_16246 = G__16262;
count__15578_16247 = G__16263;
i__15579_16248 = G__16264;
continue;
} else {
var vec__15589_16265 = cljs.core.first(seq__15576_16259__$1);
var k_16266__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15589_16265,(0),null);
var v_16267__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15589_16265,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16266__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16267__$1) : emit_js_object_val.call(null,v_16267__$1)));


var G__16268 = cljs.core.next(seq__15576_16259__$1);
var G__16269 = null;
var G__16270 = (0);
var G__16271 = (0);
seq__15576_16245 = G__16268;
chunk__15577_16246 = G__16269;
count__15578_16247 = G__16270;
i__15579_16248 = G__16271;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__15592){
var map__15593 = p__15592;
var map__15593__$1 = (((((!((map__15593 == null))))?(((((map__15593.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15593.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15593):map__15593);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15593__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15593__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15593__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__15595){
var map__15596 = p__15595;
var map__15596__$1 = (((((!((map__15596 == null))))?(((((map__15596.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15596.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15596):map__15596);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15596__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15596__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__15598){
var map__15599 = p__15598;
var map__15599__$1 = (((((!((map__15599 == null))))?(((((map__15599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15599.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15599):map__15599);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15599__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__15601){
var map__15602 = p__15601;
var map__15602__$1 = (((((!((map__15602 == null))))?(((((map__15602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15602):map__15602);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15602__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15602__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__15604 = cljs.analyzer.unwrap_quote(expr);
var map__15604__$1 = (((((!((map__15604 == null))))?(((((map__15604.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15604.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15604):map__15604);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15604__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15604__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15604__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__15606 = cljs.analyzer.unwrap_quote(expr);
var map__15606__$1 = (((((!((map__15606 == null))))?(((((map__15606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15606.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15606):map__15606);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15606__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15606__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15606__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__15609 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__15609.cljs$core$IFn$_invoke$arity$1 ? fexpr__15609.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15609.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__15610){
var map__15611 = p__15610;
var map__15611__$1 = (((((!((map__15611 == null))))?(((((map__15611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15611.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15611):map__15611);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__15613){
var map__15614 = p__15613;
var map__15614__$1 = (((((!((map__15614 == null))))?(((((map__15614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15614.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15614):map__15614);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__15616_16274 = cljs.core.seq(nodes);
var chunk__15617_16275 = null;
var count__15618_16276 = (0);
var i__15619_16277 = (0);
while(true){
if((i__15619_16277 < count__15618_16276)){
var map__15636_16278 = chunk__15617_16275.cljs$core$IIndexed$_nth$arity$2(null,i__15619_16277);
var map__15636_16279__$1 = (((((!((map__15636_16278 == null))))?(((((map__15636_16278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15636_16278.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15636_16278):map__15636_16278);
var ts_16280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15636_16279__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15637_16281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15636_16279__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15637_16282__$1 = (((((!((map__15637_16281 == null))))?(((((map__15637_16281.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15637_16281.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15637_16281):map__15637_16281);
var then_16283 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15637_16282__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15640_16284 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16280));
var chunk__15641_16285 = null;
var count__15642_16286 = (0);
var i__15643_16287 = (0);
while(true){
if((i__15643_16287 < count__15642_16286)){
var test_16288 = chunk__15641_16285.cljs$core$IIndexed$_nth$arity$2(null,i__15643_16287);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16288,":");


var G__16289 = seq__15640_16284;
var G__16290 = chunk__15641_16285;
var G__16291 = count__15642_16286;
var G__16292 = (i__15643_16287 + (1));
seq__15640_16284 = G__16289;
chunk__15641_16285 = G__16290;
count__15642_16286 = G__16291;
i__15643_16287 = G__16292;
continue;
} else {
var temp__5735__auto___16293 = cljs.core.seq(seq__15640_16284);
if(temp__5735__auto___16293){
var seq__15640_16294__$1 = temp__5735__auto___16293;
if(cljs.core.chunked_seq_QMARK_(seq__15640_16294__$1)){
var c__4609__auto___16295 = cljs.core.chunk_first(seq__15640_16294__$1);
var G__16296 = cljs.core.chunk_rest(seq__15640_16294__$1);
var G__16297 = c__4609__auto___16295;
var G__16298 = cljs.core.count(c__4609__auto___16295);
var G__16299 = (0);
seq__15640_16284 = G__16296;
chunk__15641_16285 = G__16297;
count__15642_16286 = G__16298;
i__15643_16287 = G__16299;
continue;
} else {
var test_16300 = cljs.core.first(seq__15640_16294__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16300,":");


var G__16301 = cljs.core.next(seq__15640_16294__$1);
var G__16302 = null;
var G__16303 = (0);
var G__16304 = (0);
seq__15640_16284 = G__16301;
chunk__15641_16285 = G__16302;
count__15642_16286 = G__16303;
i__15643_16287 = G__16304;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16283);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16283);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16305 = seq__15616_16274;
var G__16306 = chunk__15617_16275;
var G__16307 = count__15618_16276;
var G__16308 = (i__15619_16277 + (1));
seq__15616_16274 = G__16305;
chunk__15617_16275 = G__16306;
count__15618_16276 = G__16307;
i__15619_16277 = G__16308;
continue;
} else {
var temp__5735__auto___16309 = cljs.core.seq(seq__15616_16274);
if(temp__5735__auto___16309){
var seq__15616_16310__$1 = temp__5735__auto___16309;
if(cljs.core.chunked_seq_QMARK_(seq__15616_16310__$1)){
var c__4609__auto___16311 = cljs.core.chunk_first(seq__15616_16310__$1);
var G__16312 = cljs.core.chunk_rest(seq__15616_16310__$1);
var G__16313 = c__4609__auto___16311;
var G__16314 = cljs.core.count(c__4609__auto___16311);
var G__16315 = (0);
seq__15616_16274 = G__16312;
chunk__15617_16275 = G__16313;
count__15618_16276 = G__16314;
i__15619_16277 = G__16315;
continue;
} else {
var map__15644_16316 = cljs.core.first(seq__15616_16310__$1);
var map__15644_16317__$1 = (((((!((map__15644_16316 == null))))?(((((map__15644_16316.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15644_16316.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15644_16316):map__15644_16316);
var ts_16318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15644_16317__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15645_16319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15644_16317__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15645_16320__$1 = (((((!((map__15645_16319 == null))))?(((((map__15645_16319.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15645_16319.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15645_16319):map__15645_16319);
var then_16321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15645_16320__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15648_16322 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16318));
var chunk__15649_16323 = null;
var count__15650_16324 = (0);
var i__15651_16325 = (0);
while(true){
if((i__15651_16325 < count__15650_16324)){
var test_16326 = chunk__15649_16323.cljs$core$IIndexed$_nth$arity$2(null,i__15651_16325);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16326,":");


var G__16327 = seq__15648_16322;
var G__16328 = chunk__15649_16323;
var G__16329 = count__15650_16324;
var G__16330 = (i__15651_16325 + (1));
seq__15648_16322 = G__16327;
chunk__15649_16323 = G__16328;
count__15650_16324 = G__16329;
i__15651_16325 = G__16330;
continue;
} else {
var temp__5735__auto___16331__$1 = cljs.core.seq(seq__15648_16322);
if(temp__5735__auto___16331__$1){
var seq__15648_16332__$1 = temp__5735__auto___16331__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15648_16332__$1)){
var c__4609__auto___16333 = cljs.core.chunk_first(seq__15648_16332__$1);
var G__16336 = cljs.core.chunk_rest(seq__15648_16332__$1);
var G__16337 = c__4609__auto___16333;
var G__16338 = cljs.core.count(c__4609__auto___16333);
var G__16339 = (0);
seq__15648_16322 = G__16336;
chunk__15649_16323 = G__16337;
count__15650_16324 = G__16338;
i__15651_16325 = G__16339;
continue;
} else {
var test_16340 = cljs.core.first(seq__15648_16332__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16340,":");


var G__16347 = cljs.core.next(seq__15648_16332__$1);
var G__16348 = null;
var G__16349 = (0);
var G__16350 = (0);
seq__15648_16322 = G__16347;
chunk__15649_16323 = G__16348;
count__15650_16324 = G__16349;
i__15651_16325 = G__16350;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16321);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16321);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16357 = cljs.core.next(seq__15616_16310__$1);
var G__16358 = null;
var G__16359 = (0);
var G__16360 = (0);
seq__15616_16274 = G__16357;
chunk__15617_16275 = G__16358;
count__15618_16276 = G__16359;
i__15619_16277 = G__16360;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__15652){
var map__15653 = p__15652;
var map__15653__$1 = (((((!((map__15653 == null))))?(((((map__15653.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15653.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15653):map__15653);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15653__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15653__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15658 = env;
var G__15659 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15658,G__15659) : cljs.compiler.resolve_type.call(null,G__15658,G__15659));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__15660 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15660,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15660,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__15655_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__15655_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__15655_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__15663 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__15663,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__15663;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15666 = env;
var G__15667 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15666,G__15667) : cljs.compiler.resolve_type.call(null,G__15666,G__15667));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15668_SHARP_){
return cljs.compiler.resolve_type(env,p1__15668_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__15669 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15670 = cljs.core.seq(vec__15669);
var first__15671 = cljs.core.first(seq__15670);
var seq__15670__$1 = cljs.core.next(seq__15670);
var p = first__15671;
var first__15671__$1 = cljs.core.first(seq__15670__$1);
var seq__15670__$2 = cljs.core.next(seq__15670__$1);
var ts = first__15671__$1;
var first__15671__$2 = cljs.core.first(seq__15670__$2);
var seq__15670__$3 = cljs.core.next(seq__15670__$2);
var n = first__15671__$2;
var xs = seq__15670__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__15672 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15673 = cljs.core.seq(vec__15672);
var first__15674 = cljs.core.first(seq__15673);
var seq__15673__$1 = cljs.core.next(seq__15673);
var p = first__15674;
var first__15674__$1 = cljs.core.first(seq__15673__$1);
var seq__15673__$2 = cljs.core.next(seq__15673__$1);
var ts = first__15674__$1;
var xs = seq__15673__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__15682 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__15681 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__15681.cljs$core$IFn$_invoke$arity$1 ? fexpr__15681.cljs$core$IFn$_invoke$arity$1(G__15682) : fexpr__15681.call(null,G__15682));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__15687 = arguments.length;
switch (G__15687) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__15695 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15685_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__15685_SHARP_);
} else {
return p1__15685_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__15696 = cljs.core.seq(vec__15695);
var first__15697 = cljs.core.first(seq__15696);
var seq__15696__$1 = cljs.core.next(seq__15696);
var x = first__15697;
var ys = seq__15696__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__15698 = cljs.core.seq(ys);
var chunk__15699 = null;
var count__15700 = (0);
var i__15701 = (0);
while(true){
if((i__15701 < count__15700)){
var next_line = chunk__15699.cljs$core$IIndexed$_nth$arity$2(null,i__15701);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__16372 = seq__15698;
var G__16373 = chunk__15699;
var G__16374 = count__15700;
var G__16375 = (i__15701 + (1));
seq__15698 = G__16372;
chunk__15699 = G__16373;
count__15700 = G__16374;
i__15701 = G__16375;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15698);
if(temp__5735__auto__){
var seq__15698__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15698__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15698__$1);
var G__16376 = cljs.core.chunk_rest(seq__15698__$1);
var G__16377 = c__4609__auto__;
var G__16378 = cljs.core.count(c__4609__auto__);
var G__16379 = (0);
seq__15698 = G__16376;
chunk__15699 = G__16377;
count__15700 = G__16378;
i__15701 = G__16379;
continue;
} else {
var next_line = cljs.core.first(seq__15698__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__16380 = cljs.core.next(seq__15698__$1);
var G__16381 = null;
var G__16382 = (0);
var G__16383 = (0);
seq__15698 = G__16380;
chunk__15699 = G__16381;
count__15700 = G__16382;
i__15701 = G__16383;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__15702_16384 = cljs.core.seq(docs__$2);
var chunk__15703_16385 = null;
var count__15704_16386 = (0);
var i__15705_16387 = (0);
while(true){
if((i__15705_16387 < count__15704_16386)){
var e_16388 = chunk__15703_16385.cljs$core$IIndexed$_nth$arity$2(null,i__15705_16387);
if(cljs.core.truth_(e_16388)){
print_comment_lines(e_16388);
} else {
}


var G__16389 = seq__15702_16384;
var G__16390 = chunk__15703_16385;
var G__16391 = count__15704_16386;
var G__16392 = (i__15705_16387 + (1));
seq__15702_16384 = G__16389;
chunk__15703_16385 = G__16390;
count__15704_16386 = G__16391;
i__15705_16387 = G__16392;
continue;
} else {
var temp__5735__auto___16393 = cljs.core.seq(seq__15702_16384);
if(temp__5735__auto___16393){
var seq__15702_16394__$1 = temp__5735__auto___16393;
if(cljs.core.chunked_seq_QMARK_(seq__15702_16394__$1)){
var c__4609__auto___16395 = cljs.core.chunk_first(seq__15702_16394__$1);
var G__16396 = cljs.core.chunk_rest(seq__15702_16394__$1);
var G__16397 = c__4609__auto___16395;
var G__16398 = cljs.core.count(c__4609__auto___16395);
var G__16399 = (0);
seq__15702_16384 = G__16396;
chunk__15703_16385 = G__16397;
count__15704_16386 = G__16398;
i__15705_16387 = G__16399;
continue;
} else {
var e_16400 = cljs.core.first(seq__15702_16394__$1);
if(cljs.core.truth_(e_16400)){
print_comment_lines(e_16400);
} else {
}


var G__16401 = cljs.core.next(seq__15702_16394__$1);
var G__16402 = null;
var G__16403 = (0);
var G__16404 = (0);
seq__15702_16384 = G__16401;
chunk__15703_16385 = G__16402;
count__15704_16386 = G__16403;
i__15705_16387 = G__16404;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__15707_SHARP_){
return goog.string.startsWith(p1__15707_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__15708){
var map__15709 = p__15708;
var map__15709__$1 = (((((!((map__15709 == null))))?(((((map__15709.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15709.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15709):map__15709);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15709__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__15711){
var map__15712 = p__15711;
var map__15712__$1 = (((((!((map__15712 == null))))?(((((map__15712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15712):map__15712);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15712__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15712__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15712__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__15714_16410 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__15715_16411 = null;
var count__15716_16412 = (0);
var i__15717_16413 = (0);
while(true){
if((i__15717_16413 < count__15716_16412)){
var vec__15724_16414 = chunk__15715_16411.cljs$core$IIndexed$_nth$arity$2(null,i__15717_16413);
var i_16415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15724_16414,(0),null);
var param_16416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15724_16414,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_16416);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__16417 = seq__15714_16410;
var G__16418 = chunk__15715_16411;
var G__16419 = count__15716_16412;
var G__16420 = (i__15717_16413 + (1));
seq__15714_16410 = G__16417;
chunk__15715_16411 = G__16418;
count__15716_16412 = G__16419;
i__15717_16413 = G__16420;
continue;
} else {
var temp__5735__auto___16421 = cljs.core.seq(seq__15714_16410);
if(temp__5735__auto___16421){
var seq__15714_16422__$1 = temp__5735__auto___16421;
if(cljs.core.chunked_seq_QMARK_(seq__15714_16422__$1)){
var c__4609__auto___16423 = cljs.core.chunk_first(seq__15714_16422__$1);
var G__16424 = cljs.core.chunk_rest(seq__15714_16422__$1);
var G__16425 = c__4609__auto___16423;
var G__16426 = cljs.core.count(c__4609__auto___16423);
var G__16427 = (0);
seq__15714_16410 = G__16424;
chunk__15715_16411 = G__16425;
count__15716_16412 = G__16426;
i__15717_16413 = G__16427;
continue;
} else {
var vec__15727_16428 = cljs.core.first(seq__15714_16422__$1);
var i_16429 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15727_16428,(0),null);
var param_16430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15727_16428,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_16430);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__16431 = cljs.core.next(seq__15714_16422__$1);
var G__16432 = null;
var G__16433 = (0);
var G__16434 = (0);
seq__15714_16410 = G__16431;
chunk__15715_16411 = G__16432;
count__15716_16412 = G__16433;
i__15717_16413 = G__16434;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15730_16435 = cljs.core.seq(params);
var chunk__15731_16436 = null;
var count__15732_16437 = (0);
var i__15733_16438 = (0);
while(true){
if((i__15733_16438 < count__15732_16437)){
var param_16439 = chunk__15731_16436.cljs$core$IIndexed$_nth$arity$2(null,i__15733_16438);
cljs.compiler.emit(param_16439);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16439,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16440 = seq__15730_16435;
var G__16441 = chunk__15731_16436;
var G__16442 = count__15732_16437;
var G__16443 = (i__15733_16438 + (1));
seq__15730_16435 = G__16440;
chunk__15731_16436 = G__16441;
count__15732_16437 = G__16442;
i__15733_16438 = G__16443;
continue;
} else {
var temp__5735__auto___16444 = cljs.core.seq(seq__15730_16435);
if(temp__5735__auto___16444){
var seq__15730_16445__$1 = temp__5735__auto___16444;
if(cljs.core.chunked_seq_QMARK_(seq__15730_16445__$1)){
var c__4609__auto___16446 = cljs.core.chunk_first(seq__15730_16445__$1);
var G__16447 = cljs.core.chunk_rest(seq__15730_16445__$1);
var G__16448 = c__4609__auto___16446;
var G__16449 = cljs.core.count(c__4609__auto___16446);
var G__16450 = (0);
seq__15730_16435 = G__16447;
chunk__15731_16436 = G__16448;
count__15732_16437 = G__16449;
i__15733_16438 = G__16450;
continue;
} else {
var param_16451 = cljs.core.first(seq__15730_16445__$1);
cljs.compiler.emit(param_16451);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16451,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16452 = cljs.core.next(seq__15730_16445__$1);
var G__16453 = null;
var G__16454 = (0);
var G__16455 = (0);
seq__15730_16435 = G__16452;
chunk__15731_16436 = G__16453;
count__15732_16437 = G__16454;
i__15733_16438 = G__16455;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15734_16456 = cljs.core.seq(params);
var chunk__15735_16457 = null;
var count__15736_16458 = (0);
var i__15737_16459 = (0);
while(true){
if((i__15737_16459 < count__15736_16458)){
var param_16460 = chunk__15735_16457.cljs$core$IIndexed$_nth$arity$2(null,i__15737_16459);
cljs.compiler.emit(param_16460);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16460,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16461 = seq__15734_16456;
var G__16462 = chunk__15735_16457;
var G__16463 = count__15736_16458;
var G__16464 = (i__15737_16459 + (1));
seq__15734_16456 = G__16461;
chunk__15735_16457 = G__16462;
count__15736_16458 = G__16463;
i__15737_16459 = G__16464;
continue;
} else {
var temp__5735__auto___16465 = cljs.core.seq(seq__15734_16456);
if(temp__5735__auto___16465){
var seq__15734_16466__$1 = temp__5735__auto___16465;
if(cljs.core.chunked_seq_QMARK_(seq__15734_16466__$1)){
var c__4609__auto___16467 = cljs.core.chunk_first(seq__15734_16466__$1);
var G__16468 = cljs.core.chunk_rest(seq__15734_16466__$1);
var G__16469 = c__4609__auto___16467;
var G__16470 = cljs.core.count(c__4609__auto___16467);
var G__16471 = (0);
seq__15734_16456 = G__16468;
chunk__15735_16457 = G__16469;
count__15736_16458 = G__16470;
i__15737_16459 = G__16471;
continue;
} else {
var param_16472 = cljs.core.first(seq__15734_16466__$1);
cljs.compiler.emit(param_16472);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16472,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16473 = cljs.core.next(seq__15734_16466__$1);
var G__16474 = null;
var G__16475 = (0);
var G__16476 = (0);
seq__15734_16456 = G__16473;
chunk__15735_16457 = G__16474;
count__15736_16458 = G__16475;
i__15737_16459 = G__16476;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__15738 = cljs.core.seq(params);
var chunk__15739 = null;
var count__15740 = (0);
var i__15741 = (0);
while(true){
if((i__15741 < count__15740)){
var param = chunk__15739.cljs$core$IIndexed$_nth$arity$2(null,i__15741);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16485 = seq__15738;
var G__16486 = chunk__15739;
var G__16487 = count__15740;
var G__16488 = (i__15741 + (1));
seq__15738 = G__16485;
chunk__15739 = G__16486;
count__15740 = G__16487;
i__15741 = G__16488;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15738);
if(temp__5735__auto__){
var seq__15738__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15738__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15738__$1);
var G__16489 = cljs.core.chunk_rest(seq__15738__$1);
var G__16490 = c__4609__auto__;
var G__16491 = cljs.core.count(c__4609__auto__);
var G__16492 = (0);
seq__15738 = G__16489;
chunk__15739 = G__16490;
count__15740 = G__16491;
i__15741 = G__16492;
continue;
} else {
var param = cljs.core.first(seq__15738__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16493 = cljs.core.next(seq__15738__$1);
var G__16494 = null;
var G__16495 = (0);
var G__16496 = (0);
seq__15738 = G__16493;
chunk__15739 = G__16494;
count__15740 = G__16495;
i__15741 = G__16496;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__15742){
var map__15743 = p__15742;
var map__15743__$1 = (((((!((map__15743 == null))))?(((((map__15743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15743):map__15743);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15743__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15743__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15743__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15743__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15743__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15743__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__15745){
var map__15746 = p__15745;
var map__15746__$1 = (((((!((map__15746 == null))))?(((((map__15746.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15746.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15746):map__15746);
var f = map__15746__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15746__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15746__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15746__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15746__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15746__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15746__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15746__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15746__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_16499__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16500 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16499__$1);
var delegate_name_16501 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16500),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_16501," = function (");

var seq__15748_16502 = cljs.core.seq(params);
var chunk__15749_16503 = null;
var count__15750_16504 = (0);
var i__15751_16505 = (0);
while(true){
if((i__15751_16505 < count__15750_16504)){
var param_16506 = chunk__15749_16503.cljs$core$IIndexed$_nth$arity$2(null,i__15751_16505);
cljs.compiler.emit(param_16506);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16506,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16507 = seq__15748_16502;
var G__16508 = chunk__15749_16503;
var G__16509 = count__15750_16504;
var G__16510 = (i__15751_16505 + (1));
seq__15748_16502 = G__16507;
chunk__15749_16503 = G__16508;
count__15750_16504 = G__16509;
i__15751_16505 = G__16510;
continue;
} else {
var temp__5735__auto___16511 = cljs.core.seq(seq__15748_16502);
if(temp__5735__auto___16511){
var seq__15748_16512__$1 = temp__5735__auto___16511;
if(cljs.core.chunked_seq_QMARK_(seq__15748_16512__$1)){
var c__4609__auto___16513 = cljs.core.chunk_first(seq__15748_16512__$1);
var G__16514 = cljs.core.chunk_rest(seq__15748_16512__$1);
var G__16515 = c__4609__auto___16513;
var G__16516 = cljs.core.count(c__4609__auto___16513);
var G__16517 = (0);
seq__15748_16502 = G__16514;
chunk__15749_16503 = G__16515;
count__15750_16504 = G__16516;
i__15751_16505 = G__16517;
continue;
} else {
var param_16518 = cljs.core.first(seq__15748_16512__$1);
cljs.compiler.emit(param_16518);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16518,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16519 = cljs.core.next(seq__15748_16512__$1);
var G__16520 = null;
var G__16521 = (0);
var G__16522 = (0);
seq__15748_16502 = G__16519;
chunk__15749_16503 = G__16520;
count__15750_16504 = G__16521;
i__15751_16505 = G__16522;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_16500," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_16523 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_16523,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_16501,".call(this,");

var seq__15752_16524 = cljs.core.seq(params);
var chunk__15753_16525 = null;
var count__15754_16526 = (0);
var i__15755_16527 = (0);
while(true){
if((i__15755_16527 < count__15754_16526)){
var param_16528 = chunk__15753_16525.cljs$core$IIndexed$_nth$arity$2(null,i__15755_16527);
cljs.compiler.emit(param_16528);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16528,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16529 = seq__15752_16524;
var G__16530 = chunk__15753_16525;
var G__16531 = count__15754_16526;
var G__16532 = (i__15755_16527 + (1));
seq__15752_16524 = G__16529;
chunk__15753_16525 = G__16530;
count__15754_16526 = G__16531;
i__15755_16527 = G__16532;
continue;
} else {
var temp__5735__auto___16533 = cljs.core.seq(seq__15752_16524);
if(temp__5735__auto___16533){
var seq__15752_16534__$1 = temp__5735__auto___16533;
if(cljs.core.chunked_seq_QMARK_(seq__15752_16534__$1)){
var c__4609__auto___16535 = cljs.core.chunk_first(seq__15752_16534__$1);
var G__16536 = cljs.core.chunk_rest(seq__15752_16534__$1);
var G__16537 = c__4609__auto___16535;
var G__16538 = cljs.core.count(c__4609__auto___16535);
var G__16539 = (0);
seq__15752_16524 = G__16536;
chunk__15753_16525 = G__16537;
count__15754_16526 = G__16538;
i__15755_16527 = G__16539;
continue;
} else {
var param_16540 = cljs.core.first(seq__15752_16534__$1);
cljs.compiler.emit(param_16540);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16540,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16541 = cljs.core.next(seq__15752_16534__$1);
var G__16542 = null;
var G__16543 = (0);
var G__16544 = (0);
seq__15752_16524 = G__16541;
chunk__15753_16525 = G__16542;
count__15754_16526 = G__16543;
i__15755_16527 = G__16544;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16500,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_16500,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_16499__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16500,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_16501,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16500,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__15760){
var map__15761 = p__15760;
var map__15761__$1 = (((((!((map__15761 == null))))?(((((map__15761.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15761.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15761):map__15761);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15761__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15761__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15761__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15761__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15761__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15761__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15761__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15761__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__15756_SHARP_){
var and__4174__auto__ = p1__15756_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__15756_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_16546__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16547 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16546__$1);
var maxparams_16548 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_16549 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16547),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_16550 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__15757_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__15757_SHARP_)));
}),cljs.core.seq(mmap_16549));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_16547," = null;");

var seq__15764_16551 = cljs.core.seq(ms_16550);
var chunk__15765_16552 = null;
var count__15766_16553 = (0);
var i__15767_16554 = (0);
while(true){
if((i__15767_16554 < count__15766_16553)){
var vec__15774_16555 = chunk__15765_16552.cljs$core$IIndexed$_nth$arity$2(null,i__15767_16554);
var n_16556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15774_16555,(0),null);
var meth_16557 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15774_16555,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16556," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16557))){
cljs.compiler.emit_variadic_fn_method(meth_16557);
} else {
cljs.compiler.emit_fn_method(meth_16557);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16558 = seq__15764_16551;
var G__16559 = chunk__15765_16552;
var G__16560 = count__15766_16553;
var G__16561 = (i__15767_16554 + (1));
seq__15764_16551 = G__16558;
chunk__15765_16552 = G__16559;
count__15766_16553 = G__16560;
i__15767_16554 = G__16561;
continue;
} else {
var temp__5735__auto___16562 = cljs.core.seq(seq__15764_16551);
if(temp__5735__auto___16562){
var seq__15764_16563__$1 = temp__5735__auto___16562;
if(cljs.core.chunked_seq_QMARK_(seq__15764_16563__$1)){
var c__4609__auto___16564 = cljs.core.chunk_first(seq__15764_16563__$1);
var G__16565 = cljs.core.chunk_rest(seq__15764_16563__$1);
var G__16566 = c__4609__auto___16564;
var G__16567 = cljs.core.count(c__4609__auto___16564);
var G__16568 = (0);
seq__15764_16551 = G__16565;
chunk__15765_16552 = G__16566;
count__15766_16553 = G__16567;
i__15767_16554 = G__16568;
continue;
} else {
var vec__15777_16569 = cljs.core.first(seq__15764_16563__$1);
var n_16570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15777_16569,(0),null);
var meth_16571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15777_16569,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16570," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16571))){
cljs.compiler.emit_variadic_fn_method(meth_16571);
} else {
cljs.compiler.emit_fn_method(meth_16571);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16572 = cljs.core.next(seq__15764_16563__$1);
var G__16573 = null;
var G__16574 = (0);
var G__16575 = (0);
seq__15764_16551 = G__16572;
chunk__15765_16552 = G__16573;
count__15766_16553 = G__16574;
i__15767_16554 = G__16575;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16547," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_16548),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_16548)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_16548));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__15780_16576 = cljs.core.seq(ms_16550);
var chunk__15781_16577 = null;
var count__15782_16578 = (0);
var i__15783_16579 = (0);
while(true){
if((i__15783_16579 < count__15782_16578)){
var vec__15790_16580 = chunk__15781_16577.cljs$core$IIndexed$_nth$arity$2(null,i__15783_16579);
var n_16581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15790_16580,(0),null);
var meth_16582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15790_16580,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16582))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16583 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16583," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16584 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16583," = new cljs.core.IndexedSeq(",a_16584,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16581,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16548)),(((cljs.core.count(maxparams_16548) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16583,");"], 0));
} else {
var pcnt_16585 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16582));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16585,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16581,".call(this",(((pcnt_16585 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16585,maxparams_16548)),null,(1),null)),(2),null))),");");
}


var G__16586 = seq__15780_16576;
var G__16587 = chunk__15781_16577;
var G__16588 = count__15782_16578;
var G__16589 = (i__15783_16579 + (1));
seq__15780_16576 = G__16586;
chunk__15781_16577 = G__16587;
count__15782_16578 = G__16588;
i__15783_16579 = G__16589;
continue;
} else {
var temp__5735__auto___16590 = cljs.core.seq(seq__15780_16576);
if(temp__5735__auto___16590){
var seq__15780_16591__$1 = temp__5735__auto___16590;
if(cljs.core.chunked_seq_QMARK_(seq__15780_16591__$1)){
var c__4609__auto___16592 = cljs.core.chunk_first(seq__15780_16591__$1);
var G__16593 = cljs.core.chunk_rest(seq__15780_16591__$1);
var G__16594 = c__4609__auto___16592;
var G__16595 = cljs.core.count(c__4609__auto___16592);
var G__16596 = (0);
seq__15780_16576 = G__16593;
chunk__15781_16577 = G__16594;
count__15782_16578 = G__16595;
i__15783_16579 = G__16596;
continue;
} else {
var vec__15796_16597 = cljs.core.first(seq__15780_16591__$1);
var n_16598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15796_16597,(0),null);
var meth_16599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15796_16597,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16599))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16600 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16600," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16601 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16600," = new cljs.core.IndexedSeq(",a_16601,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16598,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16548)),(((cljs.core.count(maxparams_16548) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16600,");"], 0));
} else {
var pcnt_16602 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16599));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16602,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16598,".call(this",(((pcnt_16602 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16602,maxparams_16548)),null,(1),null)),(2),null))),");");
}


var G__16603 = cljs.core.next(seq__15780_16591__$1);
var G__16604 = null;
var G__16605 = (0);
var G__16606 = (0);
seq__15780_16576 = G__16603;
chunk__15781_16577 = G__16604;
count__15782_16578 = G__16605;
i__15783_16579 = G__16606;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_16607 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_16550)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_16607,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16547,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16547,".cljs$lang$applyTo = ",cljs.core.some((function (p1__15759_SHARP_){
var vec__15800 = p1__15759_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15800,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15800,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_16550),".cljs$lang$applyTo;");
} else {
}

var seq__15803_16608 = cljs.core.seq(ms_16550);
var chunk__15804_16609 = null;
var count__15805_16610 = (0);
var i__15806_16611 = (0);
while(true){
if((i__15806_16611 < count__15805_16610)){
var vec__15813_16612 = chunk__15804_16609.cljs$core$IIndexed$_nth$arity$2(null,i__15806_16611);
var n_16613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15813_16612,(0),null);
var meth_16614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15813_16612,(1),null);
var c_16615 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16614));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16614))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16547,".cljs$core$IFn$_invoke$arity$variadic = ",n_16613,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16547,".cljs$core$IFn$_invoke$arity$",c_16615," = ",n_16613,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16616 = seq__15803_16608;
var G__16617 = chunk__15804_16609;
var G__16618 = count__15805_16610;
var G__16619 = (i__15806_16611 + (1));
seq__15803_16608 = G__16616;
chunk__15804_16609 = G__16617;
count__15805_16610 = G__16618;
i__15806_16611 = G__16619;
continue;
} else {
var temp__5735__auto___16620 = cljs.core.seq(seq__15803_16608);
if(temp__5735__auto___16620){
var seq__15803_16621__$1 = temp__5735__auto___16620;
if(cljs.core.chunked_seq_QMARK_(seq__15803_16621__$1)){
var c__4609__auto___16622 = cljs.core.chunk_first(seq__15803_16621__$1);
var G__16623 = cljs.core.chunk_rest(seq__15803_16621__$1);
var G__16624 = c__4609__auto___16622;
var G__16625 = cljs.core.count(c__4609__auto___16622);
var G__16626 = (0);
seq__15803_16608 = G__16623;
chunk__15804_16609 = G__16624;
count__15805_16610 = G__16625;
i__15806_16611 = G__16626;
continue;
} else {
var vec__15816_16627 = cljs.core.first(seq__15803_16621__$1);
var n_16628 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15816_16627,(0),null);
var meth_16629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15816_16627,(1),null);
var c_16630 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16629));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16629))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16547,".cljs$core$IFn$_invoke$arity$variadic = ",n_16628,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16547,".cljs$core$IFn$_invoke$arity$",c_16630," = ",n_16628,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16631 = cljs.core.next(seq__15803_16621__$1);
var G__16632 = null;
var G__16633 = (0);
var G__16634 = (0);
seq__15803_16608 = G__16631;
chunk__15804_16609 = G__16632;
count__15805_16610 = G__16633;
i__15806_16611 = G__16634;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16547,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__15819){
var map__15820 = p__15819;
var map__15820__$1 = (((((!((map__15820 == null))))?(((((map__15820.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15820.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15820):map__15820);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15820__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15820__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15820__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15822_16635 = cljs.core.seq(statements);
var chunk__15823_16636 = null;
var count__15824_16637 = (0);
var i__15825_16638 = (0);
while(true){
if((i__15825_16638 < count__15824_16637)){
var s_16639 = chunk__15823_16636.cljs$core$IIndexed$_nth$arity$2(null,i__15825_16638);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16639);


var G__16640 = seq__15822_16635;
var G__16641 = chunk__15823_16636;
var G__16642 = count__15824_16637;
var G__16643 = (i__15825_16638 + (1));
seq__15822_16635 = G__16640;
chunk__15823_16636 = G__16641;
count__15824_16637 = G__16642;
i__15825_16638 = G__16643;
continue;
} else {
var temp__5735__auto___16644 = cljs.core.seq(seq__15822_16635);
if(temp__5735__auto___16644){
var seq__15822_16645__$1 = temp__5735__auto___16644;
if(cljs.core.chunked_seq_QMARK_(seq__15822_16645__$1)){
var c__4609__auto___16646 = cljs.core.chunk_first(seq__15822_16645__$1);
var G__16647 = cljs.core.chunk_rest(seq__15822_16645__$1);
var G__16648 = c__4609__auto___16646;
var G__16649 = cljs.core.count(c__4609__auto___16646);
var G__16650 = (0);
seq__15822_16635 = G__16647;
chunk__15823_16636 = G__16648;
count__15824_16637 = G__16649;
i__15825_16638 = G__16650;
continue;
} else {
var s_16651 = cljs.core.first(seq__15822_16645__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16651);


var G__16652 = cljs.core.next(seq__15822_16645__$1);
var G__16653 = null;
var G__16654 = (0);
var G__16655 = (0);
seq__15822_16635 = G__16652;
chunk__15823_16636 = G__16653;
count__15824_16637 = G__16654;
i__15825_16638 = G__16655;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__15826){
var map__15827 = p__15826;
var map__15827__$1 = (((((!((map__15827 == null))))?(((((map__15827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15827):map__15827);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15827__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15827__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15827__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15827__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15827__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__15831,is_loop){
var map__15832 = p__15831;
var map__15832__$1 = (((((!((map__15832 == null))))?(((((map__15832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15832.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15832):map__15832);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15832__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15832__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15832__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__15834_16656 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__15835_16657 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__15835_16657);

try{var seq__15836_16658 = cljs.core.seq(bindings);
var chunk__15837_16659 = null;
var count__15838_16660 = (0);
var i__15839_16661 = (0);
while(true){
if((i__15839_16661 < count__15838_16660)){
var map__15844_16662 = chunk__15837_16659.cljs$core$IIndexed$_nth$arity$2(null,i__15839_16661);
var map__15844_16663__$1 = (((((!((map__15844_16662 == null))))?(((((map__15844_16662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15844_16662.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15844_16662):map__15844_16662);
var binding_16664 = map__15844_16663__$1;
var init_16665 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15844_16663__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16664);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16665,";");


var G__16666 = seq__15836_16658;
var G__16667 = chunk__15837_16659;
var G__16668 = count__15838_16660;
var G__16669 = (i__15839_16661 + (1));
seq__15836_16658 = G__16666;
chunk__15837_16659 = G__16667;
count__15838_16660 = G__16668;
i__15839_16661 = G__16669;
continue;
} else {
var temp__5735__auto___16670 = cljs.core.seq(seq__15836_16658);
if(temp__5735__auto___16670){
var seq__15836_16671__$1 = temp__5735__auto___16670;
if(cljs.core.chunked_seq_QMARK_(seq__15836_16671__$1)){
var c__4609__auto___16672 = cljs.core.chunk_first(seq__15836_16671__$1);
var G__16673 = cljs.core.chunk_rest(seq__15836_16671__$1);
var G__16674 = c__4609__auto___16672;
var G__16675 = cljs.core.count(c__4609__auto___16672);
var G__16676 = (0);
seq__15836_16658 = G__16673;
chunk__15837_16659 = G__16674;
count__15838_16660 = G__16675;
i__15839_16661 = G__16676;
continue;
} else {
var map__15846_16677 = cljs.core.first(seq__15836_16671__$1);
var map__15846_16678__$1 = (((((!((map__15846_16677 == null))))?(((((map__15846_16677.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15846_16677.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15846_16677):map__15846_16677);
var binding_16679 = map__15846_16678__$1;
var init_16680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15846_16678__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16679);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16680,";");


var G__16681 = cljs.core.next(seq__15836_16671__$1);
var G__16682 = null;
var G__16683 = (0);
var G__16684 = (0);
seq__15836_16658 = G__16681;
chunk__15837_16659 = G__16682;
count__15838_16660 = G__16683;
i__15839_16661 = G__16684;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__15834_16656);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__15848){
var map__15849 = p__15848;
var map__15849__$1 = (((((!((map__15849 == null))))?(((((map__15849.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15849.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15849):map__15849);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15849__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15849__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15849__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___16685 = cljs.core.count(exprs);
var i_16686 = (0);
while(true){
if((i_16686 < n__4666__auto___16685)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16686) : temps.call(null,i_16686))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_16686) : exprs.call(null,i_16686)),";");

var G__16687 = (i_16686 + (1));
i_16686 = G__16687;
continue;
} else {
}
break;
}

var n__4666__auto___16688 = cljs.core.count(exprs);
var i_16689 = (0);
while(true){
if((i_16689 < n__4666__auto___16688)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_16689) : params.call(null,i_16689)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16689) : temps.call(null,i_16689)),";");

var G__16690 = (i_16689 + (1));
i_16689 = G__16690;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__15851){
var map__15852 = p__15851;
var map__15852__$1 = (((((!((map__15852 == null))))?(((((map__15852.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15852.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15852):map__15852);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15852__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15852__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15852__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15854_16691 = cljs.core.seq(bindings);
var chunk__15855_16692 = null;
var count__15856_16693 = (0);
var i__15857_16694 = (0);
while(true){
if((i__15857_16694 < count__15856_16693)){
var map__15865_16695 = chunk__15855_16692.cljs$core$IIndexed$_nth$arity$2(null,i__15857_16694);
var map__15865_16696__$1 = (((((!((map__15865_16695 == null))))?(((((map__15865_16695.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15865_16695.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15865_16695):map__15865_16695);
var binding_16697 = map__15865_16696__$1;
var init_16698 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15865_16696__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16697)," = ",init_16698,";");


var G__16699 = seq__15854_16691;
var G__16700 = chunk__15855_16692;
var G__16701 = count__15856_16693;
var G__16702 = (i__15857_16694 + (1));
seq__15854_16691 = G__16699;
chunk__15855_16692 = G__16700;
count__15856_16693 = G__16701;
i__15857_16694 = G__16702;
continue;
} else {
var temp__5735__auto___16703 = cljs.core.seq(seq__15854_16691);
if(temp__5735__auto___16703){
var seq__15854_16704__$1 = temp__5735__auto___16703;
if(cljs.core.chunked_seq_QMARK_(seq__15854_16704__$1)){
var c__4609__auto___16705 = cljs.core.chunk_first(seq__15854_16704__$1);
var G__16706 = cljs.core.chunk_rest(seq__15854_16704__$1);
var G__16707 = c__4609__auto___16705;
var G__16708 = cljs.core.count(c__4609__auto___16705);
var G__16709 = (0);
seq__15854_16691 = G__16706;
chunk__15855_16692 = G__16707;
count__15856_16693 = G__16708;
i__15857_16694 = G__16709;
continue;
} else {
var map__15867_16710 = cljs.core.first(seq__15854_16704__$1);
var map__15867_16711__$1 = (((((!((map__15867_16710 == null))))?(((((map__15867_16710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15867_16710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15867_16710):map__15867_16710);
var binding_16712 = map__15867_16711__$1;
var init_16713 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15867_16711__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16712)," = ",init_16713,";");


var G__16715 = cljs.core.next(seq__15854_16704__$1);
var G__16716 = null;
var G__16717 = (0);
var G__16718 = (0);
seq__15854_16691 = G__16715;
chunk__15855_16692 = G__16716;
count__15856_16693 = G__16717;
i__15857_16694 = G__16718;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__15871){
var map__15872 = p__15871;
var map__15872__$1 = (((((!((map__15872 == null))))?(((((map__15872.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15872.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15872):map__15872);
var expr = map__15872__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15872__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15872__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15872__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__15887 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__15887.cljs$core$IFn$_invoke$arity$1 ? fexpr__15887.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15887.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__15889 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__15889.cljs$core$IFn$_invoke$arity$1 ? fexpr__15889.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__15889.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__15877 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__15869_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15869_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__15870_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15870_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15877,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15877,(1),null);
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_16719 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_16719,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_16720 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_16720,args)),(((mfa_16720 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_16720,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__15891 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__15890 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15890.cljs$core$IFn$_invoke$arity$1 ? fexpr__15890.cljs$core$IFn$_invoke$arity$1(G__15891) : fexpr__15890.call(null,G__15891));
} else {
return and__4174__auto__;
}
})())){
var fprop_16721 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16721," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16721,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16721," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16721,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__15892){
var map__15893 = p__15892;
var map__15893__$1 = (((((!((map__15893 == null))))?(((((map__15893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15893.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15893):map__15893);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15893__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15893__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15893__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__15899){
var map__15900 = p__15899;
var map__15900__$1 = (((((!((map__15900 == null))))?(((((map__15900.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15900.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15900):map__15900);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15900__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15900__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15900__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__15902 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15902__$1 = (((((!((map__15902 == null))))?(((((map__15902.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15902.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15902):map__15902);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15902__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15902__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__15903 = options;
var map__15903__$1 = (((((!((map__15903 == null))))?(((((map__15903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15903):map__15903);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15903__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15903__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__15904 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__15909 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__15909__$1 = (((((!((map__15909 == null))))?(((((map__15909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15909.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15909):map__15909);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15909__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15909__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15904,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15904,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__15911_16723 = cljs.core.seq(libs_to_load);
var chunk__15912_16724 = null;
var count__15913_16725 = (0);
var i__15914_16726 = (0);
while(true){
if((i__15914_16726 < count__15913_16725)){
var lib_16727 = chunk__15912_16724.cljs$core$IIndexed$_nth$arity$2(null,i__15914_16726);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16727)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16727),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16727),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16727),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16727),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16727,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16727),"');");
}

}
}
}


var G__16728 = seq__15911_16723;
var G__16729 = chunk__15912_16724;
var G__16730 = count__15913_16725;
var G__16731 = (i__15914_16726 + (1));
seq__15911_16723 = G__16728;
chunk__15912_16724 = G__16729;
count__15913_16725 = G__16730;
i__15914_16726 = G__16731;
continue;
} else {
var temp__5735__auto___16732 = cljs.core.seq(seq__15911_16723);
if(temp__5735__auto___16732){
var seq__15911_16733__$1 = temp__5735__auto___16732;
if(cljs.core.chunked_seq_QMARK_(seq__15911_16733__$1)){
var c__4609__auto___16734 = cljs.core.chunk_first(seq__15911_16733__$1);
var G__16735 = cljs.core.chunk_rest(seq__15911_16733__$1);
var G__16736 = c__4609__auto___16734;
var G__16737 = cljs.core.count(c__4609__auto___16734);
var G__16738 = (0);
seq__15911_16723 = G__16735;
chunk__15912_16724 = G__16736;
count__15913_16725 = G__16737;
i__15914_16726 = G__16738;
continue;
} else {
var lib_16739 = cljs.core.first(seq__15911_16733__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16739)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16739),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16739),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16739),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16739),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16739,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16739),"');");
}

}
}
}


var G__16740 = cljs.core.next(seq__15911_16733__$1);
var G__16741 = null;
var G__16742 = (0);
var G__16743 = (0);
seq__15911_16723 = G__16740;
chunk__15912_16724 = G__16741;
count__15913_16725 = G__16742;
i__15914_16726 = G__16743;
continue;
}
} else {
}
}
break;
}

var seq__15915_16744 = cljs.core.seq(node_libs);
var chunk__15916_16745 = null;
var count__15917_16746 = (0);
var i__15918_16747 = (0);
while(true){
if((i__15918_16747 < count__15917_16746)){
var lib_16748 = chunk__15916_16745.cljs$core$IIndexed$_nth$arity$2(null,i__15918_16747);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16748)," = require('",lib_16748,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16749 = seq__15915_16744;
var G__16750 = chunk__15916_16745;
var G__16751 = count__15917_16746;
var G__16752 = (i__15918_16747 + (1));
seq__15915_16744 = G__16749;
chunk__15916_16745 = G__16750;
count__15917_16746 = G__16751;
i__15918_16747 = G__16752;
continue;
} else {
var temp__5735__auto___16753 = cljs.core.seq(seq__15915_16744);
if(temp__5735__auto___16753){
var seq__15915_16754__$1 = temp__5735__auto___16753;
if(cljs.core.chunked_seq_QMARK_(seq__15915_16754__$1)){
var c__4609__auto___16755 = cljs.core.chunk_first(seq__15915_16754__$1);
var G__16756 = cljs.core.chunk_rest(seq__15915_16754__$1);
var G__16757 = c__4609__auto___16755;
var G__16758 = cljs.core.count(c__4609__auto___16755);
var G__16759 = (0);
seq__15915_16744 = G__16756;
chunk__15916_16745 = G__16757;
count__15917_16746 = G__16758;
i__15918_16747 = G__16759;
continue;
} else {
var lib_16760 = cljs.core.first(seq__15915_16754__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16760)," = require('",lib_16760,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16761 = cljs.core.next(seq__15915_16754__$1);
var G__16762 = null;
var G__16763 = (0);
var G__16764 = (0);
seq__15915_16744 = G__16761;
chunk__15916_16745 = G__16762;
count__15917_16746 = G__16763;
i__15918_16747 = G__16764;
continue;
}
} else {
}
}
break;
}

var seq__15919_16765 = cljs.core.seq(global_exports_libs);
var chunk__15920_16766 = null;
var count__15921_16767 = (0);
var i__15922_16768 = (0);
while(true){
if((i__15922_16768 < count__15921_16767)){
var lib_16769 = chunk__15920_16766.cljs$core$IIndexed$_nth$arity$2(null,i__15922_16768);
var map__15927_16770 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16769));
var map__15927_16771__$1 = (((((!((map__15927_16770 == null))))?(((((map__15927_16770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15927_16770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15927_16770):map__15927_16770);
var global_exports_16772 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15927_16771__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16772,lib_16769);


var G__16773 = seq__15919_16765;
var G__16774 = chunk__15920_16766;
var G__16775 = count__15921_16767;
var G__16776 = (i__15922_16768 + (1));
seq__15919_16765 = G__16773;
chunk__15920_16766 = G__16774;
count__15921_16767 = G__16775;
i__15922_16768 = G__16776;
continue;
} else {
var temp__5735__auto___16777 = cljs.core.seq(seq__15919_16765);
if(temp__5735__auto___16777){
var seq__15919_16778__$1 = temp__5735__auto___16777;
if(cljs.core.chunked_seq_QMARK_(seq__15919_16778__$1)){
var c__4609__auto___16779 = cljs.core.chunk_first(seq__15919_16778__$1);
var G__16780 = cljs.core.chunk_rest(seq__15919_16778__$1);
var G__16781 = c__4609__auto___16779;
var G__16782 = cljs.core.count(c__4609__auto___16779);
var G__16783 = (0);
seq__15919_16765 = G__16780;
chunk__15920_16766 = G__16781;
count__15921_16767 = G__16782;
i__15922_16768 = G__16783;
continue;
} else {
var lib_16784 = cljs.core.first(seq__15919_16778__$1);
var map__15929_16785 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16784));
var map__15929_16786__$1 = (((((!((map__15929_16785 == null))))?(((((map__15929_16785.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15929_16785.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15929_16785):map__15929_16785);
var global_exports_16787 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15929_16786__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16787,lib_16784);


var G__16788 = cljs.core.next(seq__15919_16778__$1);
var G__16789 = null;
var G__16790 = (0);
var G__16791 = (0);
seq__15919_16765 = G__16788;
chunk__15920_16766 = G__16789;
count__15921_16767 = G__16790;
i__15922_16768 = G__16791;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__15931){
var map__15932 = p__15931;
var map__15932__$1 = (((((!((map__15932 == null))))?(((((map__15932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15932.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15932):map__15932);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15932__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15932__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15932__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15932__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15932__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15932__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15932__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__15934){
var map__15935 = p__15934;
var map__15935__$1 = (((((!((map__15935 == null))))?(((((map__15935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15935.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15935):map__15935);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15935__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15935__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15935__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15935__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15935__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15935__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15935__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__15937){
var map__15938 = p__15937;
var map__15938__$1 = (((((!((map__15938 == null))))?(((((map__15938.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15938.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15938):map__15938);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15938__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15938__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15938__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15938__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15938__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15940_16792 = cljs.core.seq(protocols);
var chunk__15941_16793 = null;
var count__15942_16794 = (0);
var i__15943_16795 = (0);
while(true){
if((i__15943_16795 < count__15942_16794)){
var protocol_16796 = chunk__15941_16793.cljs$core$IIndexed$_nth$arity$2(null,i__15943_16795);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16796)),"}");


var G__16797 = seq__15940_16792;
var G__16798 = chunk__15941_16793;
var G__16799 = count__15942_16794;
var G__16800 = (i__15943_16795 + (1));
seq__15940_16792 = G__16797;
chunk__15941_16793 = G__16798;
count__15942_16794 = G__16799;
i__15943_16795 = G__16800;
continue;
} else {
var temp__5735__auto___16801 = cljs.core.seq(seq__15940_16792);
if(temp__5735__auto___16801){
var seq__15940_16802__$1 = temp__5735__auto___16801;
if(cljs.core.chunked_seq_QMARK_(seq__15940_16802__$1)){
var c__4609__auto___16803 = cljs.core.chunk_first(seq__15940_16802__$1);
var G__16804 = cljs.core.chunk_rest(seq__15940_16802__$1);
var G__16805 = c__4609__auto___16803;
var G__16806 = cljs.core.count(c__4609__auto___16803);
var G__16807 = (0);
seq__15940_16792 = G__16804;
chunk__15941_16793 = G__16805;
count__15942_16794 = G__16806;
i__15943_16795 = G__16807;
continue;
} else {
var protocol_16808 = cljs.core.first(seq__15940_16802__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16808)),"}");


var G__16809 = cljs.core.next(seq__15940_16802__$1);
var G__16810 = null;
var G__16811 = (0);
var G__16812 = (0);
seq__15940_16792 = G__16809;
chunk__15941_16793 = G__16810;
count__15942_16794 = G__16811;
i__15943_16795 = G__16812;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15944_16813 = cljs.core.seq(fields__$1);
var chunk__15945_16814 = null;
var count__15946_16815 = (0);
var i__15947_16816 = (0);
while(true){
if((i__15947_16816 < count__15946_16815)){
var fld_16817 = chunk__15945_16814.cljs$core$IIndexed$_nth$arity$2(null,i__15947_16816);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16817," = ",fld_16817,";");


var G__16818 = seq__15944_16813;
var G__16819 = chunk__15945_16814;
var G__16820 = count__15946_16815;
var G__16821 = (i__15947_16816 + (1));
seq__15944_16813 = G__16818;
chunk__15945_16814 = G__16819;
count__15946_16815 = G__16820;
i__15947_16816 = G__16821;
continue;
} else {
var temp__5735__auto___16822 = cljs.core.seq(seq__15944_16813);
if(temp__5735__auto___16822){
var seq__15944_16823__$1 = temp__5735__auto___16822;
if(cljs.core.chunked_seq_QMARK_(seq__15944_16823__$1)){
var c__4609__auto___16824 = cljs.core.chunk_first(seq__15944_16823__$1);
var G__16825 = cljs.core.chunk_rest(seq__15944_16823__$1);
var G__16826 = c__4609__auto___16824;
var G__16827 = cljs.core.count(c__4609__auto___16824);
var G__16828 = (0);
seq__15944_16813 = G__16825;
chunk__15945_16814 = G__16826;
count__15946_16815 = G__16827;
i__15947_16816 = G__16828;
continue;
} else {
var fld_16829 = cljs.core.first(seq__15944_16823__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16829," = ",fld_16829,";");


var G__16830 = cljs.core.next(seq__15944_16823__$1);
var G__16831 = null;
var G__16832 = (0);
var G__16833 = (0);
seq__15944_16813 = G__16830;
chunk__15945_16814 = G__16831;
count__15946_16815 = G__16832;
i__15947_16816 = G__16833;
continue;
}
} else {
}
}
break;
}

var seq__15948_16834 = cljs.core.seq(pmasks);
var chunk__15949_16835 = null;
var count__15950_16836 = (0);
var i__15951_16837 = (0);
while(true){
if((i__15951_16837 < count__15950_16836)){
var vec__15958_16838 = chunk__15949_16835.cljs$core$IIndexed$_nth$arity$2(null,i__15951_16837);
var pno_16839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15958_16838,(0),null);
var pmask_16840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15958_16838,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16839,"$ = ",pmask_16840,";");


var G__16841 = seq__15948_16834;
var G__16842 = chunk__15949_16835;
var G__16843 = count__15950_16836;
var G__16844 = (i__15951_16837 + (1));
seq__15948_16834 = G__16841;
chunk__15949_16835 = G__16842;
count__15950_16836 = G__16843;
i__15951_16837 = G__16844;
continue;
} else {
var temp__5735__auto___16845 = cljs.core.seq(seq__15948_16834);
if(temp__5735__auto___16845){
var seq__15948_16846__$1 = temp__5735__auto___16845;
if(cljs.core.chunked_seq_QMARK_(seq__15948_16846__$1)){
var c__4609__auto___16847 = cljs.core.chunk_first(seq__15948_16846__$1);
var G__16848 = cljs.core.chunk_rest(seq__15948_16846__$1);
var G__16849 = c__4609__auto___16847;
var G__16850 = cljs.core.count(c__4609__auto___16847);
var G__16851 = (0);
seq__15948_16834 = G__16848;
chunk__15949_16835 = G__16849;
count__15950_16836 = G__16850;
i__15951_16837 = G__16851;
continue;
} else {
var vec__15961_16852 = cljs.core.first(seq__15948_16846__$1);
var pno_16853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15961_16852,(0),null);
var pmask_16854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15961_16852,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16853,"$ = ",pmask_16854,";");


var G__16855 = cljs.core.next(seq__15948_16846__$1);
var G__16856 = null;
var G__16857 = (0);
var G__16858 = (0);
seq__15948_16834 = G__16855;
chunk__15949_16835 = G__16856;
count__15950_16836 = G__16857;
i__15951_16837 = G__16858;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__15964){
var map__15965 = p__15964;
var map__15965__$1 = (((((!((map__15965 == null))))?(((((map__15965.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15965.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15965):map__15965);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15965__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15965__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15965__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15965__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15965__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15968_16859 = cljs.core.seq(protocols);
var chunk__15969_16860 = null;
var count__15970_16861 = (0);
var i__15971_16862 = (0);
while(true){
if((i__15971_16862 < count__15970_16861)){
var protocol_16863 = chunk__15969_16860.cljs$core$IIndexed$_nth$arity$2(null,i__15971_16862);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16863)),"}");


var G__16864 = seq__15968_16859;
var G__16865 = chunk__15969_16860;
var G__16866 = count__15970_16861;
var G__16867 = (i__15971_16862 + (1));
seq__15968_16859 = G__16864;
chunk__15969_16860 = G__16865;
count__15970_16861 = G__16866;
i__15971_16862 = G__16867;
continue;
} else {
var temp__5735__auto___16868 = cljs.core.seq(seq__15968_16859);
if(temp__5735__auto___16868){
var seq__15968_16869__$1 = temp__5735__auto___16868;
if(cljs.core.chunked_seq_QMARK_(seq__15968_16869__$1)){
var c__4609__auto___16870 = cljs.core.chunk_first(seq__15968_16869__$1);
var G__16871 = cljs.core.chunk_rest(seq__15968_16869__$1);
var G__16872 = c__4609__auto___16870;
var G__16873 = cljs.core.count(c__4609__auto___16870);
var G__16874 = (0);
seq__15968_16859 = G__16871;
chunk__15969_16860 = G__16872;
count__15970_16861 = G__16873;
i__15971_16862 = G__16874;
continue;
} else {
var protocol_16875 = cljs.core.first(seq__15968_16869__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16875)),"}");


var G__16876 = cljs.core.next(seq__15968_16869__$1);
var G__16877 = null;
var G__16878 = (0);
var G__16879 = (0);
seq__15968_16859 = G__16876;
chunk__15969_16860 = G__16877;
count__15970_16861 = G__16878;
i__15971_16862 = G__16879;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15972_16880 = cljs.core.seq(fields__$1);
var chunk__15973_16881 = null;
var count__15974_16882 = (0);
var i__15975_16883 = (0);
while(true){
if((i__15975_16883 < count__15974_16882)){
var fld_16884 = chunk__15973_16881.cljs$core$IIndexed$_nth$arity$2(null,i__15975_16883);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16884," = ",fld_16884,";");


var G__16885 = seq__15972_16880;
var G__16886 = chunk__15973_16881;
var G__16887 = count__15974_16882;
var G__16888 = (i__15975_16883 + (1));
seq__15972_16880 = G__16885;
chunk__15973_16881 = G__16886;
count__15974_16882 = G__16887;
i__15975_16883 = G__16888;
continue;
} else {
var temp__5735__auto___16889 = cljs.core.seq(seq__15972_16880);
if(temp__5735__auto___16889){
var seq__15972_16890__$1 = temp__5735__auto___16889;
if(cljs.core.chunked_seq_QMARK_(seq__15972_16890__$1)){
var c__4609__auto___16891 = cljs.core.chunk_first(seq__15972_16890__$1);
var G__16892 = cljs.core.chunk_rest(seq__15972_16890__$1);
var G__16893 = c__4609__auto___16891;
var G__16894 = cljs.core.count(c__4609__auto___16891);
var G__16895 = (0);
seq__15972_16880 = G__16892;
chunk__15973_16881 = G__16893;
count__15974_16882 = G__16894;
i__15975_16883 = G__16895;
continue;
} else {
var fld_16896 = cljs.core.first(seq__15972_16890__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16896," = ",fld_16896,";");


var G__16897 = cljs.core.next(seq__15972_16890__$1);
var G__16898 = null;
var G__16899 = (0);
var G__16900 = (0);
seq__15972_16880 = G__16897;
chunk__15973_16881 = G__16898;
count__15974_16882 = G__16899;
i__15975_16883 = G__16900;
continue;
}
} else {
}
}
break;
}

var seq__15976_16901 = cljs.core.seq(pmasks);
var chunk__15977_16902 = null;
var count__15978_16903 = (0);
var i__15979_16904 = (0);
while(true){
if((i__15979_16904 < count__15978_16903)){
var vec__15990_16905 = chunk__15977_16902.cljs$core$IIndexed$_nth$arity$2(null,i__15979_16904);
var pno_16906 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15990_16905,(0),null);
var pmask_16907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15990_16905,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16906,"$ = ",pmask_16907,";");


var G__16908 = seq__15976_16901;
var G__16909 = chunk__15977_16902;
var G__16910 = count__15978_16903;
var G__16911 = (i__15979_16904 + (1));
seq__15976_16901 = G__16908;
chunk__15977_16902 = G__16909;
count__15978_16903 = G__16910;
i__15979_16904 = G__16911;
continue;
} else {
var temp__5735__auto___16912 = cljs.core.seq(seq__15976_16901);
if(temp__5735__auto___16912){
var seq__15976_16913__$1 = temp__5735__auto___16912;
if(cljs.core.chunked_seq_QMARK_(seq__15976_16913__$1)){
var c__4609__auto___16914 = cljs.core.chunk_first(seq__15976_16913__$1);
var G__16915 = cljs.core.chunk_rest(seq__15976_16913__$1);
var G__16916 = c__4609__auto___16914;
var G__16917 = cljs.core.count(c__4609__auto___16914);
var G__16918 = (0);
seq__15976_16901 = G__16915;
chunk__15977_16902 = G__16916;
count__15978_16903 = G__16917;
i__15979_16904 = G__16918;
continue;
} else {
var vec__15993_16919 = cljs.core.first(seq__15976_16913__$1);
var pno_16920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15993_16919,(0),null);
var pmask_16921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15993_16919,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16920,"$ = ",pmask_16921,";");


var G__16922 = cljs.core.next(seq__15976_16913__$1);
var G__16923 = null;
var G__16924 = (0);
var G__16925 = (0);
seq__15976_16901 = G__16922;
chunk__15977_16902 = G__16923;
count__15978_16903 = G__16924;
i__15979_16904 = G__16925;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__15996){
var map__15997 = p__15996;
var map__15997__$1 = (((((!((map__15997 == null))))?(((((map__15997.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15997.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15997):map__15997);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15997__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15997__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15997__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15997__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15997__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__16000){
var map__16001 = p__16000;
var map__16001__$1 = (((((!((map__16001 == null))))?(((((map__16001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16001.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16001):map__16001);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16001__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16001__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16001__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16001__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16001__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__16003 = clojure.string.trim(code);
var G__16004 = "/*";
return goog.string.startsWith(G__16003,G__16004);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__15325__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15325__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__16010 = cljs.core.seq(table);
var chunk__16011 = null;
var count__16012 = (0);
var i__16013 = (0);
while(true){
if((i__16013 < count__16012)){
var vec__16020 = chunk__16011.cljs$core$IIndexed$_nth$arity$2(null,i__16013);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16020,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16020,(1),null);
var ns_16926 = cljs.core.namespace(sym);
var name_16927 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16928 = seq__16010;
var G__16929 = chunk__16011;
var G__16930 = count__16012;
var G__16931 = (i__16013 + (1));
seq__16010 = G__16928;
chunk__16011 = G__16929;
count__16012 = G__16930;
i__16013 = G__16931;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16010);
if(temp__5735__auto__){
var seq__16010__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16010__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16010__$1);
var G__16932 = cljs.core.chunk_rest(seq__16010__$1);
var G__16933 = c__4609__auto__;
var G__16934 = cljs.core.count(c__4609__auto__);
var G__16935 = (0);
seq__16010 = G__16932;
chunk__16011 = G__16933;
count__16012 = G__16934;
i__16013 = G__16935;
continue;
} else {
var vec__16023 = cljs.core.first(seq__16010__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16023,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16023,(1),null);
var ns_16936 = cljs.core.namespace(sym);
var name_16937 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16938 = cljs.core.next(seq__16010__$1);
var G__16939 = null;
var G__16940 = (0);
var G__16941 = (0);
seq__16010 = G__16938;
chunk__16011 = G__16939;
count__16012 = G__16940;
i__16013 = G__16941;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__16031 = arguments.length;
switch (G__16031) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_16943 = cljs.core.first(ks);
var vec__16037_16944 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_16943);
var top_16945 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16037_16944,(0),null);
var prefix_SINGLEQUOTE__16946 = vec__16037_16944;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_16943)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__16946) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_16945)) || (cljs.core.contains_QMARK_(known_externs,top_16945)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16946)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_16945);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16946)),";");
}
} else {
}

var m_16947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_16943);
if(cljs.core.empty_QMARK_(m_16947)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__16946,m_16947,top_level,known_externs);
}

var G__16948 = cljs.core.next(ks);
ks = G__16948;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

