goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__13289){
var vec__13290 = p__13289;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13290,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13290,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__13293 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__13296 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(4),null);
var vec__13299 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__13305 = segmap;
var map__13305__$1 = (((((!((map__13305 == null))))?(((((map__13305.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13305.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13305):map__13305);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13305__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__13308 = arguments.length;
switch (G__13308) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13312 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14252 = cljs.core.next(segs__$1);
var G__14253 = nrelseg;
var G__14254 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14252;
relseg__$1 = G__14253;
result__$1 = G__14254;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13312,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13312,(1),null);
var G__14255 = (gline + (1));
var G__14256 = cljs.core.next(lines__$1);
var G__14257 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14258 = result__$1;
gline = G__14255;
lines__$1 = G__14256;
relseg = G__14257;
result = G__14258;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__13316 = segmap;
var map__13316__$1 = (((((!((map__13316 == null))))?(((((map__13316.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13316.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13316):map__13316);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13316__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__13315_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__13315_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__13323 = arguments.length;
switch (G__13323) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13327 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14260 = cljs.core.next(segs__$1);
var G__14261 = nrelseg;
var G__14262 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14260;
relseg__$1 = G__14261;
result__$1 = G__14262;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(1),null);
var G__14263 = (gline + (1));
var G__14264 = cljs.core.next(lines__$1);
var G__14265 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14266 = result__$1;
gline = G__14263;
lines__$1 = G__14264;
relseg = G__14265;
result = G__14266;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13330){
var vec__13332 = p__13330;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13332,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13332,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13332,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13332,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13332,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__13338){
var vec__13339 = p__13338;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13339,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13339,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13339,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13339,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13339,(4),null);
var seg = vec__13339;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13342){
var vec__13345 = p__13342;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13345,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13345,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13345,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13345,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13345,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__13375 = cljs.core.seq(infos);
var chunk__13376 = null;
var count__13377 = (0);
var i__13378 = (0);
while(true){
if((i__13378 < count__13377)){
var info = chunk__13376.cljs$core$IIndexed$_nth$arity$2(null,i__13378);
var segv_14267 = info__GT_segv(info,source_idx,line,col);
var gline_14268 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14269 = cljs.core.count(cljs.core.deref(lines));
if((gline_14268 > (lc_14269 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13375,chunk__13376,count__13377,i__13378,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14268 - (lc_14269 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14267], null));
});})(seq__13375,chunk__13376,count__13377,i__13378,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13375,chunk__13376,count__13377,i__13378,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14268], null),cljs.core.conj,segv_14267);
});})(seq__13375,chunk__13376,count__13377,i__13378,segv_14267,gline_14268,lc_14269,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14282 = seq__13375;
var G__14283 = chunk__13376;
var G__14284 = count__13377;
var G__14285 = (i__13378 + (1));
seq__13375 = G__14282;
chunk__13376 = G__14283;
count__13377 = G__14284;
i__13378 = G__14285;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__13375);
if(temp__5735__auto__){
var seq__13375__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__13375__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__13375__$1);
var G__14286 = cljs.core.chunk_rest(seq__13375__$1);
var G__14287 = c__4609__auto__;
var G__14288 = cljs.core.count(c__4609__auto__);
var G__14289 = (0);
seq__13375 = G__14286;
chunk__13376 = G__14287;
count__13377 = G__14288;
i__13378 = G__14289;
continue;
} else {
var info = cljs.core.first(seq__13375__$1);
var segv_14290 = info__GT_segv(info,source_idx,line,col);
var gline_14291 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14292 = cljs.core.count(cljs.core.deref(lines));
if((gline_14291 > (lc_14292 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13375,chunk__13376,count__13377,i__13378,segv_14290,gline_14291,lc_14292,info,seq__13375__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14291 - (lc_14292 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14290], null));
});})(seq__13375,chunk__13376,count__13377,i__13378,segv_14290,gline_14291,lc_14292,info,seq__13375__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13375,chunk__13376,count__13377,i__13378,segv_14290,gline_14291,lc_14292,info,seq__13375__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14291], null),cljs.core.conj,segv_14290);
});})(seq__13375,chunk__13376,count__13377,i__13378,segv_14290,gline_14291,lc_14292,info,seq__13375__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14293 = cljs.core.next(seq__13375__$1);
var G__14294 = null;
var G__14295 = (0);
var G__14296 = (0);
seq__13375 = G__14293;
chunk__13376 = G__14294;
count__13377 = G__14295;
i__13378 = G__14296;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__13392_14297 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__13393_14298 = null;
var count__13394_14299 = (0);
var i__13395_14300 = (0);
while(true){
if((i__13395_14300 < count__13394_14299)){
var vec__13610_14301 = chunk__13393_14298.cljs$core$IIndexed$_nth$arity$2(null,i__13395_14300);
var source_idx_14302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13610_14301,(0),null);
var vec__13613_14303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13610_14301,(1),null);
var __14304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13613_14303,(0),null);
var lines_14305__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13613_14303,(1),null);
var seq__13616_14306 = cljs.core.seq(lines_14305__$1);
var chunk__13617_14307 = null;
var count__13618_14308 = (0);
var i__13619_14309 = (0);
while(true){
if((i__13619_14309 < count__13618_14308)){
var vec__13663_14310 = chunk__13617_14307.cljs$core$IIndexed$_nth$arity$2(null,i__13619_14309);
var line_14311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13663_14310,(0),null);
var cols_14312 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13663_14310,(1),null);
var seq__13666_14313 = cljs.core.seq(cols_14312);
var chunk__13667_14314 = null;
var count__13668_14315 = (0);
var i__13669_14316 = (0);
while(true){
if((i__13669_14316 < count__13668_14315)){
var vec__13676_14317 = chunk__13667_14314.cljs$core$IIndexed$_nth$arity$2(null,i__13669_14316);
var col_14318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13676_14317,(0),null);
var infos_14319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13676_14317,(1),null);
encode_cols(infos_14319,source_idx_14302,line_14311,col_14318);


var G__14320 = seq__13666_14313;
var G__14321 = chunk__13667_14314;
var G__14322 = count__13668_14315;
var G__14323 = (i__13669_14316 + (1));
seq__13666_14313 = G__14320;
chunk__13667_14314 = G__14321;
count__13668_14315 = G__14322;
i__13669_14316 = G__14323;
continue;
} else {
var temp__5735__auto___14324 = cljs.core.seq(seq__13666_14313);
if(temp__5735__auto___14324){
var seq__13666_14325__$1 = temp__5735__auto___14324;
if(cljs.core.chunked_seq_QMARK_(seq__13666_14325__$1)){
var c__4609__auto___14326 = cljs.core.chunk_first(seq__13666_14325__$1);
var G__14327 = cljs.core.chunk_rest(seq__13666_14325__$1);
var G__14328 = c__4609__auto___14326;
var G__14329 = cljs.core.count(c__4609__auto___14326);
var G__14330 = (0);
seq__13666_14313 = G__14327;
chunk__13667_14314 = G__14328;
count__13668_14315 = G__14329;
i__13669_14316 = G__14330;
continue;
} else {
var vec__13679_14331 = cljs.core.first(seq__13666_14325__$1);
var col_14332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13679_14331,(0),null);
var infos_14333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13679_14331,(1),null);
encode_cols(infos_14333,source_idx_14302,line_14311,col_14332);


var G__14334 = cljs.core.next(seq__13666_14325__$1);
var G__14335 = null;
var G__14336 = (0);
var G__14337 = (0);
seq__13666_14313 = G__14334;
chunk__13667_14314 = G__14335;
count__13668_14315 = G__14336;
i__13669_14316 = G__14337;
continue;
}
} else {
}
}
break;
}


var G__14338 = seq__13616_14306;
var G__14339 = chunk__13617_14307;
var G__14340 = count__13618_14308;
var G__14341 = (i__13619_14309 + (1));
seq__13616_14306 = G__14338;
chunk__13617_14307 = G__14339;
count__13618_14308 = G__14340;
i__13619_14309 = G__14341;
continue;
} else {
var temp__5735__auto___14342 = cljs.core.seq(seq__13616_14306);
if(temp__5735__auto___14342){
var seq__13616_14343__$1 = temp__5735__auto___14342;
if(cljs.core.chunked_seq_QMARK_(seq__13616_14343__$1)){
var c__4609__auto___14344 = cljs.core.chunk_first(seq__13616_14343__$1);
var G__14345 = cljs.core.chunk_rest(seq__13616_14343__$1);
var G__14346 = c__4609__auto___14344;
var G__14347 = cljs.core.count(c__4609__auto___14344);
var G__14348 = (0);
seq__13616_14306 = G__14345;
chunk__13617_14307 = G__14346;
count__13618_14308 = G__14347;
i__13619_14309 = G__14348;
continue;
} else {
var vec__13682_14349 = cljs.core.first(seq__13616_14343__$1);
var line_14350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13682_14349,(0),null);
var cols_14351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13682_14349,(1),null);
var seq__13685_14364 = cljs.core.seq(cols_14351);
var chunk__13686_14365 = null;
var count__13687_14366 = (0);
var i__13688_14367 = (0);
while(true){
if((i__13688_14367 < count__13687_14366)){
var vec__13695_14368 = chunk__13686_14365.cljs$core$IIndexed$_nth$arity$2(null,i__13688_14367);
var col_14369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13695_14368,(0),null);
var infos_14370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13695_14368,(1),null);
encode_cols(infos_14370,source_idx_14302,line_14350,col_14369);


var G__14371 = seq__13685_14364;
var G__14372 = chunk__13686_14365;
var G__14373 = count__13687_14366;
var G__14374 = (i__13688_14367 + (1));
seq__13685_14364 = G__14371;
chunk__13686_14365 = G__14372;
count__13687_14366 = G__14373;
i__13688_14367 = G__14374;
continue;
} else {
var temp__5735__auto___14375__$1 = cljs.core.seq(seq__13685_14364);
if(temp__5735__auto___14375__$1){
var seq__13685_14376__$1 = temp__5735__auto___14375__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13685_14376__$1)){
var c__4609__auto___14377 = cljs.core.chunk_first(seq__13685_14376__$1);
var G__14378 = cljs.core.chunk_rest(seq__13685_14376__$1);
var G__14379 = c__4609__auto___14377;
var G__14380 = cljs.core.count(c__4609__auto___14377);
var G__14381 = (0);
seq__13685_14364 = G__14378;
chunk__13686_14365 = G__14379;
count__13687_14366 = G__14380;
i__13688_14367 = G__14381;
continue;
} else {
var vec__13698_14382 = cljs.core.first(seq__13685_14376__$1);
var col_14383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13698_14382,(0),null);
var infos_14384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13698_14382,(1),null);
encode_cols(infos_14384,source_idx_14302,line_14350,col_14383);


var G__14385 = cljs.core.next(seq__13685_14376__$1);
var G__14386 = null;
var G__14387 = (0);
var G__14388 = (0);
seq__13685_14364 = G__14385;
chunk__13686_14365 = G__14386;
count__13687_14366 = G__14387;
i__13688_14367 = G__14388;
continue;
}
} else {
}
}
break;
}


var G__14389 = cljs.core.next(seq__13616_14343__$1);
var G__14390 = null;
var G__14391 = (0);
var G__14392 = (0);
seq__13616_14306 = G__14389;
chunk__13617_14307 = G__14390;
count__13618_14308 = G__14391;
i__13619_14309 = G__14392;
continue;
}
} else {
}
}
break;
}


var G__14393 = seq__13392_14297;
var G__14394 = chunk__13393_14298;
var G__14395 = count__13394_14299;
var G__14396 = (i__13395_14300 + (1));
seq__13392_14297 = G__14393;
chunk__13393_14298 = G__14394;
count__13394_14299 = G__14395;
i__13395_14300 = G__14396;
continue;
} else {
var temp__5735__auto___14397 = cljs.core.seq(seq__13392_14297);
if(temp__5735__auto___14397){
var seq__13392_14398__$1 = temp__5735__auto___14397;
if(cljs.core.chunked_seq_QMARK_(seq__13392_14398__$1)){
var c__4609__auto___14399 = cljs.core.chunk_first(seq__13392_14398__$1);
var G__14400 = cljs.core.chunk_rest(seq__13392_14398__$1);
var G__14401 = c__4609__auto___14399;
var G__14402 = cljs.core.count(c__4609__auto___14399);
var G__14403 = (0);
seq__13392_14297 = G__14400;
chunk__13393_14298 = G__14401;
count__13394_14299 = G__14402;
i__13395_14300 = G__14403;
continue;
} else {
var vec__13701_14404 = cljs.core.first(seq__13392_14398__$1);
var source_idx_14405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13701_14404,(0),null);
var vec__13704_14406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13701_14404,(1),null);
var __14407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13704_14406,(0),null);
var lines_14408__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13704_14406,(1),null);
var seq__13707_14409 = cljs.core.seq(lines_14408__$1);
var chunk__13708_14410 = null;
var count__13709_14411 = (0);
var i__13710_14412 = (0);
while(true){
if((i__13710_14412 < count__13709_14411)){
var vec__13751_14413 = chunk__13708_14410.cljs$core$IIndexed$_nth$arity$2(null,i__13710_14412);
var line_14414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13751_14413,(0),null);
var cols_14415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13751_14413,(1),null);
var seq__13754_14416 = cljs.core.seq(cols_14415);
var chunk__13755_14417 = null;
var count__13756_14418 = (0);
var i__13757_14419 = (0);
while(true){
if((i__13757_14419 < count__13756_14418)){
var vec__13764_14420 = chunk__13755_14417.cljs$core$IIndexed$_nth$arity$2(null,i__13757_14419);
var col_14421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13764_14420,(0),null);
var infos_14422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13764_14420,(1),null);
encode_cols(infos_14422,source_idx_14405,line_14414,col_14421);


var G__14423 = seq__13754_14416;
var G__14424 = chunk__13755_14417;
var G__14425 = count__13756_14418;
var G__14426 = (i__13757_14419 + (1));
seq__13754_14416 = G__14423;
chunk__13755_14417 = G__14424;
count__13756_14418 = G__14425;
i__13757_14419 = G__14426;
continue;
} else {
var temp__5735__auto___14427__$1 = cljs.core.seq(seq__13754_14416);
if(temp__5735__auto___14427__$1){
var seq__13754_14428__$1 = temp__5735__auto___14427__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13754_14428__$1)){
var c__4609__auto___14429 = cljs.core.chunk_first(seq__13754_14428__$1);
var G__14430 = cljs.core.chunk_rest(seq__13754_14428__$1);
var G__14431 = c__4609__auto___14429;
var G__14432 = cljs.core.count(c__4609__auto___14429);
var G__14433 = (0);
seq__13754_14416 = G__14430;
chunk__13755_14417 = G__14431;
count__13756_14418 = G__14432;
i__13757_14419 = G__14433;
continue;
} else {
var vec__13772_14434 = cljs.core.first(seq__13754_14428__$1);
var col_14435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13772_14434,(0),null);
var infos_14436 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13772_14434,(1),null);
encode_cols(infos_14436,source_idx_14405,line_14414,col_14435);


var G__14437 = cljs.core.next(seq__13754_14428__$1);
var G__14438 = null;
var G__14439 = (0);
var G__14440 = (0);
seq__13754_14416 = G__14437;
chunk__13755_14417 = G__14438;
count__13756_14418 = G__14439;
i__13757_14419 = G__14440;
continue;
}
} else {
}
}
break;
}


var G__14441 = seq__13707_14409;
var G__14442 = chunk__13708_14410;
var G__14443 = count__13709_14411;
var G__14444 = (i__13710_14412 + (1));
seq__13707_14409 = G__14441;
chunk__13708_14410 = G__14442;
count__13709_14411 = G__14443;
i__13710_14412 = G__14444;
continue;
} else {
var temp__5735__auto___14445__$1 = cljs.core.seq(seq__13707_14409);
if(temp__5735__auto___14445__$1){
var seq__13707_14446__$1 = temp__5735__auto___14445__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13707_14446__$1)){
var c__4609__auto___14447 = cljs.core.chunk_first(seq__13707_14446__$1);
var G__14448 = cljs.core.chunk_rest(seq__13707_14446__$1);
var G__14449 = c__4609__auto___14447;
var G__14450 = cljs.core.count(c__4609__auto___14447);
var G__14451 = (0);
seq__13707_14409 = G__14448;
chunk__13708_14410 = G__14449;
count__13709_14411 = G__14450;
i__13710_14412 = G__14451;
continue;
} else {
var vec__13775_14452 = cljs.core.first(seq__13707_14446__$1);
var line_14453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13775_14452,(0),null);
var cols_14454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13775_14452,(1),null);
var seq__13778_14455 = cljs.core.seq(cols_14454);
var chunk__13779_14456 = null;
var count__13780_14457 = (0);
var i__13781_14458 = (0);
while(true){
if((i__13781_14458 < count__13780_14457)){
var vec__13788_14464 = chunk__13779_14456.cljs$core$IIndexed$_nth$arity$2(null,i__13781_14458);
var col_14465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13788_14464,(0),null);
var infos_14466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13788_14464,(1),null);
encode_cols(infos_14466,source_idx_14405,line_14453,col_14465);


var G__14467 = seq__13778_14455;
var G__14468 = chunk__13779_14456;
var G__14469 = count__13780_14457;
var G__14470 = (i__13781_14458 + (1));
seq__13778_14455 = G__14467;
chunk__13779_14456 = G__14468;
count__13780_14457 = G__14469;
i__13781_14458 = G__14470;
continue;
} else {
var temp__5735__auto___14471__$2 = cljs.core.seq(seq__13778_14455);
if(temp__5735__auto___14471__$2){
var seq__13778_14472__$1 = temp__5735__auto___14471__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13778_14472__$1)){
var c__4609__auto___14473 = cljs.core.chunk_first(seq__13778_14472__$1);
var G__14474 = cljs.core.chunk_rest(seq__13778_14472__$1);
var G__14475 = c__4609__auto___14473;
var G__14476 = cljs.core.count(c__4609__auto___14473);
var G__14477 = (0);
seq__13778_14455 = G__14474;
chunk__13779_14456 = G__14475;
count__13780_14457 = G__14476;
i__13781_14458 = G__14477;
continue;
} else {
var vec__13791_14478 = cljs.core.first(seq__13778_14472__$1);
var col_14479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13791_14478,(0),null);
var infos_14480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13791_14478,(1),null);
encode_cols(infos_14480,source_idx_14405,line_14453,col_14479);


var G__14481 = cljs.core.next(seq__13778_14472__$1);
var G__14482 = null;
var G__14483 = (0);
var G__14484 = (0);
seq__13778_14455 = G__14481;
chunk__13779_14456 = G__14482;
count__13780_14457 = G__14483;
i__13781_14458 = G__14484;
continue;
}
} else {
}
}
break;
}


var G__14485 = cljs.core.next(seq__13707_14446__$1);
var G__14486 = null;
var G__14487 = (0);
var G__14488 = (0);
seq__13707_14409 = G__14485;
chunk__13708_14410 = G__14486;
count__13709_14411 = G__14487;
i__13710_14412 = G__14488;
continue;
}
} else {
}
}
break;
}


var G__14489 = cljs.core.next(seq__13392_14398__$1);
var G__14490 = null;
var G__14491 = (0);
var G__14492 = (0);
seq__13392_14297 = G__14489;
chunk__13393_14298 = G__14490;
count__13394_14299 = G__14491;
i__13395_14300 = G__14492;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13794 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__13352_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__13352_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__13353_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__13353_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__13354_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__13354_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13795 = G__13794;
var G__13802_14493 = G__13795;
var G__13803_14494 = "sourcesContent";
var G__13804_14495 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__13802_14493,G__13803_14494,G__13804_14495);

return G__13795;
} else {
return G__13794;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13805 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13805,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13805,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13808 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13808,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13808,(1),null);
var G__14505 = cljs.core.next(col_map_seq);
var G__14506 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13808,col,infos,vec__13805,line,col_map){
return (function (v,p__13811){
var map__13812 = p__13811;
var map__13812__$1 = (((((!((map__13812 == null))))?(((((map__13812.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13812.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13812):map__13812);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13812__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13812__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13808,col,infos,vec__13805,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14505;
new_cols = G__14506;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14507 = cljs.core.next(line_map_seq);
var G__14508 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14507;
new_lines = G__14508;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13814_14509 = cljs.core.seq(reverse_map);
var chunk__13815_14510 = null;
var count__13816_14511 = (0);
var i__13817_14512 = (0);
while(true){
if((i__13817_14512 < count__13816_14511)){
var vec__14005_14513 = chunk__13815_14510.cljs$core$IIndexed$_nth$arity$2(null,i__13817_14512);
var line_14514 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14005_14513,(0),null);
var columns_14515 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14005_14513,(1),null);
var seq__14010_14516 = cljs.core.seq(columns_14515);
var chunk__14011_14517 = null;
var count__14012_14518 = (0);
var i__14013_14519 = (0);
while(true){
if((i__14013_14519 < count__14012_14518)){
var vec__14112_14520 = chunk__14011_14517.cljs$core$IIndexed$_nth$arity$2(null,i__14013_14519);
var column_14521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14112_14520,(0),null);
var column_info_14522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14112_14520,(1),null);
var seq__14115_14523 = cljs.core.seq(column_info_14522);
var chunk__14116_14524 = null;
var count__14117_14525 = (0);
var i__14118_14526 = (0);
while(true){
if((i__14118_14526 < count__14117_14525)){
var map__14123_14527 = chunk__14116_14524.cljs$core$IIndexed$_nth$arity$2(null,i__14118_14526);
var map__14123_14528__$1 = (((((!((map__14123_14527 == null))))?(((((map__14123_14527.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14123_14527.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14123_14527):map__14123_14527);
var gline_14529 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14123_14528__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14123_14528__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14531 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14123_14528__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14529], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14115_14523,chunk__14116_14524,count__14117_14525,i__14118_14526,seq__14010_14516,chunk__14011_14517,count__14012_14518,i__14013_14519,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14123_14527,map__14123_14528__$1,gline_14529,gcol_14530,name_14531,vec__14112_14520,column_14521,column_info_14522,vec__14005_14513,line_14514,columns_14515,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14530], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14514,new cljs.core.Keyword(null,"col","col",-1959363084),column_14521,new cljs.core.Keyword(null,"name","name",1843675177),name_14531], null));
});})(seq__14115_14523,chunk__14116_14524,count__14117_14525,i__14118_14526,seq__14010_14516,chunk__14011_14517,count__14012_14518,i__14013_14519,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14123_14527,map__14123_14528__$1,gline_14529,gcol_14530,name_14531,vec__14112_14520,column_14521,column_info_14522,vec__14005_14513,line_14514,columns_14515,inverted))
,cljs.core.sorted_map()));


var G__14532 = seq__14115_14523;
var G__14533 = chunk__14116_14524;
var G__14534 = count__14117_14525;
var G__14535 = (i__14118_14526 + (1));
seq__14115_14523 = G__14532;
chunk__14116_14524 = G__14533;
count__14117_14525 = G__14534;
i__14118_14526 = G__14535;
continue;
} else {
var temp__5735__auto___14536 = cljs.core.seq(seq__14115_14523);
if(temp__5735__auto___14536){
var seq__14115_14537__$1 = temp__5735__auto___14536;
if(cljs.core.chunked_seq_QMARK_(seq__14115_14537__$1)){
var c__4609__auto___14538 = cljs.core.chunk_first(seq__14115_14537__$1);
var G__14539 = cljs.core.chunk_rest(seq__14115_14537__$1);
var G__14540 = c__4609__auto___14538;
var G__14541 = cljs.core.count(c__4609__auto___14538);
var G__14542 = (0);
seq__14115_14523 = G__14539;
chunk__14116_14524 = G__14540;
count__14117_14525 = G__14541;
i__14118_14526 = G__14542;
continue;
} else {
var map__14125_14543 = cljs.core.first(seq__14115_14537__$1);
var map__14125_14544__$1 = (((((!((map__14125_14543 == null))))?(((((map__14125_14543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14125_14543.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14125_14543):map__14125_14543);
var gline_14545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14125_14544__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14546 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14125_14544__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14547 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14125_14544__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14545], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14115_14523,chunk__14116_14524,count__14117_14525,i__14118_14526,seq__14010_14516,chunk__14011_14517,count__14012_14518,i__14013_14519,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14125_14543,map__14125_14544__$1,gline_14545,gcol_14546,name_14547,seq__14115_14537__$1,temp__5735__auto___14536,vec__14112_14520,column_14521,column_info_14522,vec__14005_14513,line_14514,columns_14515,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14546], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14514,new cljs.core.Keyword(null,"col","col",-1959363084),column_14521,new cljs.core.Keyword(null,"name","name",1843675177),name_14547], null));
});})(seq__14115_14523,chunk__14116_14524,count__14117_14525,i__14118_14526,seq__14010_14516,chunk__14011_14517,count__14012_14518,i__14013_14519,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14125_14543,map__14125_14544__$1,gline_14545,gcol_14546,name_14547,seq__14115_14537__$1,temp__5735__auto___14536,vec__14112_14520,column_14521,column_info_14522,vec__14005_14513,line_14514,columns_14515,inverted))
,cljs.core.sorted_map()));


var G__14551 = cljs.core.next(seq__14115_14537__$1);
var G__14552 = null;
var G__14553 = (0);
var G__14554 = (0);
seq__14115_14523 = G__14551;
chunk__14116_14524 = G__14552;
count__14117_14525 = G__14553;
i__14118_14526 = G__14554;
continue;
}
} else {
}
}
break;
}


var G__14557 = seq__14010_14516;
var G__14558 = chunk__14011_14517;
var G__14559 = count__14012_14518;
var G__14560 = (i__14013_14519 + (1));
seq__14010_14516 = G__14557;
chunk__14011_14517 = G__14558;
count__14012_14518 = G__14559;
i__14013_14519 = G__14560;
continue;
} else {
var temp__5735__auto___14561 = cljs.core.seq(seq__14010_14516);
if(temp__5735__auto___14561){
var seq__14010_14562__$1 = temp__5735__auto___14561;
if(cljs.core.chunked_seq_QMARK_(seq__14010_14562__$1)){
var c__4609__auto___14563 = cljs.core.chunk_first(seq__14010_14562__$1);
var G__14564 = cljs.core.chunk_rest(seq__14010_14562__$1);
var G__14565 = c__4609__auto___14563;
var G__14566 = cljs.core.count(c__4609__auto___14563);
var G__14567 = (0);
seq__14010_14516 = G__14564;
chunk__14011_14517 = G__14565;
count__14012_14518 = G__14566;
i__14013_14519 = G__14567;
continue;
} else {
var vec__14127_14568 = cljs.core.first(seq__14010_14562__$1);
var column_14569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14127_14568,(0),null);
var column_info_14570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14127_14568,(1),null);
var seq__14130_14571 = cljs.core.seq(column_info_14570);
var chunk__14131_14572 = null;
var count__14132_14573 = (0);
var i__14133_14574 = (0);
while(true){
if((i__14133_14574 < count__14132_14573)){
var map__14138_14575 = chunk__14131_14572.cljs$core$IIndexed$_nth$arity$2(null,i__14133_14574);
var map__14138_14576__$1 = (((((!((map__14138_14575 == null))))?(((((map__14138_14575.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14138_14575.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14138_14575):map__14138_14575);
var gline_14577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14138_14576__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14578 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14138_14576__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14579 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14138_14576__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14577], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14130_14571,chunk__14131_14572,count__14132_14573,i__14133_14574,seq__14010_14516,chunk__14011_14517,count__14012_14518,i__14013_14519,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14138_14575,map__14138_14576__$1,gline_14577,gcol_14578,name_14579,vec__14127_14568,column_14569,column_info_14570,seq__14010_14562__$1,temp__5735__auto___14561,vec__14005_14513,line_14514,columns_14515,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14578], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14514,new cljs.core.Keyword(null,"col","col",-1959363084),column_14569,new cljs.core.Keyword(null,"name","name",1843675177),name_14579], null));
});})(seq__14130_14571,chunk__14131_14572,count__14132_14573,i__14133_14574,seq__14010_14516,chunk__14011_14517,count__14012_14518,i__14013_14519,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14138_14575,map__14138_14576__$1,gline_14577,gcol_14578,name_14579,vec__14127_14568,column_14569,column_info_14570,seq__14010_14562__$1,temp__5735__auto___14561,vec__14005_14513,line_14514,columns_14515,inverted))
,cljs.core.sorted_map()));


var G__14580 = seq__14130_14571;
var G__14581 = chunk__14131_14572;
var G__14582 = count__14132_14573;
var G__14583 = (i__14133_14574 + (1));
seq__14130_14571 = G__14580;
chunk__14131_14572 = G__14581;
count__14132_14573 = G__14582;
i__14133_14574 = G__14583;
continue;
} else {
var temp__5735__auto___14584__$1 = cljs.core.seq(seq__14130_14571);
if(temp__5735__auto___14584__$1){
var seq__14130_14585__$1 = temp__5735__auto___14584__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14130_14585__$1)){
var c__4609__auto___14586 = cljs.core.chunk_first(seq__14130_14585__$1);
var G__14588 = cljs.core.chunk_rest(seq__14130_14585__$1);
var G__14589 = c__4609__auto___14586;
var G__14590 = cljs.core.count(c__4609__auto___14586);
var G__14591 = (0);
seq__14130_14571 = G__14588;
chunk__14131_14572 = G__14589;
count__14132_14573 = G__14590;
i__14133_14574 = G__14591;
continue;
} else {
var map__14144_14595 = cljs.core.first(seq__14130_14585__$1);
var map__14144_14596__$1 = (((((!((map__14144_14595 == null))))?(((((map__14144_14595.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14144_14595.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14144_14595):map__14144_14595);
var gline_14597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14144_14596__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14144_14596__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14144_14596__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14597], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14130_14571,chunk__14131_14572,count__14132_14573,i__14133_14574,seq__14010_14516,chunk__14011_14517,count__14012_14518,i__14013_14519,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14144_14595,map__14144_14596__$1,gline_14597,gcol_14598,name_14599,seq__14130_14585__$1,temp__5735__auto___14584__$1,vec__14127_14568,column_14569,column_info_14570,seq__14010_14562__$1,temp__5735__auto___14561,vec__14005_14513,line_14514,columns_14515,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14598], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14514,new cljs.core.Keyword(null,"col","col",-1959363084),column_14569,new cljs.core.Keyword(null,"name","name",1843675177),name_14599], null));
});})(seq__14130_14571,chunk__14131_14572,count__14132_14573,i__14133_14574,seq__14010_14516,chunk__14011_14517,count__14012_14518,i__14013_14519,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14144_14595,map__14144_14596__$1,gline_14597,gcol_14598,name_14599,seq__14130_14585__$1,temp__5735__auto___14584__$1,vec__14127_14568,column_14569,column_info_14570,seq__14010_14562__$1,temp__5735__auto___14561,vec__14005_14513,line_14514,columns_14515,inverted))
,cljs.core.sorted_map()));


var G__14600 = cljs.core.next(seq__14130_14585__$1);
var G__14601 = null;
var G__14602 = (0);
var G__14603 = (0);
seq__14130_14571 = G__14600;
chunk__14131_14572 = G__14601;
count__14132_14573 = G__14602;
i__14133_14574 = G__14603;
continue;
}
} else {
}
}
break;
}


var G__14604 = cljs.core.next(seq__14010_14562__$1);
var G__14605 = null;
var G__14606 = (0);
var G__14607 = (0);
seq__14010_14516 = G__14604;
chunk__14011_14517 = G__14605;
count__14012_14518 = G__14606;
i__14013_14519 = G__14607;
continue;
}
} else {
}
}
break;
}


var G__14608 = seq__13814_14509;
var G__14609 = chunk__13815_14510;
var G__14610 = count__13816_14511;
var G__14611 = (i__13817_14512 + (1));
seq__13814_14509 = G__14608;
chunk__13815_14510 = G__14609;
count__13816_14511 = G__14610;
i__13817_14512 = G__14611;
continue;
} else {
var temp__5735__auto___14612 = cljs.core.seq(seq__13814_14509);
if(temp__5735__auto___14612){
var seq__13814_14613__$1 = temp__5735__auto___14612;
if(cljs.core.chunked_seq_QMARK_(seq__13814_14613__$1)){
var c__4609__auto___14614 = cljs.core.chunk_first(seq__13814_14613__$1);
var G__14615 = cljs.core.chunk_rest(seq__13814_14613__$1);
var G__14616 = c__4609__auto___14614;
var G__14617 = cljs.core.count(c__4609__auto___14614);
var G__14618 = (0);
seq__13814_14509 = G__14615;
chunk__13815_14510 = G__14616;
count__13816_14511 = G__14617;
i__13817_14512 = G__14618;
continue;
} else {
var vec__14151_14619 = cljs.core.first(seq__13814_14613__$1);
var line_14620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14151_14619,(0),null);
var columns_14621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14151_14619,(1),null);
var seq__14154_14622 = cljs.core.seq(columns_14621);
var chunk__14155_14623 = null;
var count__14156_14624 = (0);
var i__14157_14625 = (0);
while(true){
if((i__14157_14625 < count__14156_14624)){
var vec__14207_14626 = chunk__14155_14623.cljs$core$IIndexed$_nth$arity$2(null,i__14157_14625);
var column_14627 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14207_14626,(0),null);
var column_info_14628 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14207_14626,(1),null);
var seq__14210_14629 = cljs.core.seq(column_info_14628);
var chunk__14211_14630 = null;
var count__14212_14631 = (0);
var i__14213_14632 = (0);
while(true){
if((i__14213_14632 < count__14212_14631)){
var map__14218_14633 = chunk__14211_14630.cljs$core$IIndexed$_nth$arity$2(null,i__14213_14632);
var map__14218_14634__$1 = (((((!((map__14218_14633 == null))))?(((((map__14218_14633.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14218_14633.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14218_14633):map__14218_14633);
var gline_14635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14218_14634__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14218_14634__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14218_14634__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14635], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14210_14629,chunk__14211_14630,count__14212_14631,i__14213_14632,seq__14154_14622,chunk__14155_14623,count__14156_14624,i__14157_14625,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14218_14633,map__14218_14634__$1,gline_14635,gcol_14636,name_14637,vec__14207_14626,column_14627,column_info_14628,vec__14151_14619,line_14620,columns_14621,seq__13814_14613__$1,temp__5735__auto___14612,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14636], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14620,new cljs.core.Keyword(null,"col","col",-1959363084),column_14627,new cljs.core.Keyword(null,"name","name",1843675177),name_14637], null));
});})(seq__14210_14629,chunk__14211_14630,count__14212_14631,i__14213_14632,seq__14154_14622,chunk__14155_14623,count__14156_14624,i__14157_14625,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14218_14633,map__14218_14634__$1,gline_14635,gcol_14636,name_14637,vec__14207_14626,column_14627,column_info_14628,vec__14151_14619,line_14620,columns_14621,seq__13814_14613__$1,temp__5735__auto___14612,inverted))
,cljs.core.sorted_map()));


var G__14638 = seq__14210_14629;
var G__14639 = chunk__14211_14630;
var G__14640 = count__14212_14631;
var G__14641 = (i__14213_14632 + (1));
seq__14210_14629 = G__14638;
chunk__14211_14630 = G__14639;
count__14212_14631 = G__14640;
i__14213_14632 = G__14641;
continue;
} else {
var temp__5735__auto___14642__$1 = cljs.core.seq(seq__14210_14629);
if(temp__5735__auto___14642__$1){
var seq__14210_14643__$1 = temp__5735__auto___14642__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14210_14643__$1)){
var c__4609__auto___14644 = cljs.core.chunk_first(seq__14210_14643__$1);
var G__14645 = cljs.core.chunk_rest(seq__14210_14643__$1);
var G__14646 = c__4609__auto___14644;
var G__14647 = cljs.core.count(c__4609__auto___14644);
var G__14648 = (0);
seq__14210_14629 = G__14645;
chunk__14211_14630 = G__14646;
count__14212_14631 = G__14647;
i__14213_14632 = G__14648;
continue;
} else {
var map__14220_14649 = cljs.core.first(seq__14210_14643__$1);
var map__14220_14650__$1 = (((((!((map__14220_14649 == null))))?(((((map__14220_14649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14220_14649.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14220_14649):map__14220_14649);
var gline_14651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14220_14650__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14220_14650__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14653 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14220_14650__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14651], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14210_14629,chunk__14211_14630,count__14212_14631,i__14213_14632,seq__14154_14622,chunk__14155_14623,count__14156_14624,i__14157_14625,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14220_14649,map__14220_14650__$1,gline_14651,gcol_14652,name_14653,seq__14210_14643__$1,temp__5735__auto___14642__$1,vec__14207_14626,column_14627,column_info_14628,vec__14151_14619,line_14620,columns_14621,seq__13814_14613__$1,temp__5735__auto___14612,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14652], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14620,new cljs.core.Keyword(null,"col","col",-1959363084),column_14627,new cljs.core.Keyword(null,"name","name",1843675177),name_14653], null));
});})(seq__14210_14629,chunk__14211_14630,count__14212_14631,i__14213_14632,seq__14154_14622,chunk__14155_14623,count__14156_14624,i__14157_14625,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14220_14649,map__14220_14650__$1,gline_14651,gcol_14652,name_14653,seq__14210_14643__$1,temp__5735__auto___14642__$1,vec__14207_14626,column_14627,column_info_14628,vec__14151_14619,line_14620,columns_14621,seq__13814_14613__$1,temp__5735__auto___14612,inverted))
,cljs.core.sorted_map()));


var G__14666 = cljs.core.next(seq__14210_14643__$1);
var G__14667 = null;
var G__14668 = (0);
var G__14669 = (0);
seq__14210_14629 = G__14666;
chunk__14211_14630 = G__14667;
count__14212_14631 = G__14668;
i__14213_14632 = G__14669;
continue;
}
} else {
}
}
break;
}


var G__14670 = seq__14154_14622;
var G__14671 = chunk__14155_14623;
var G__14672 = count__14156_14624;
var G__14673 = (i__14157_14625 + (1));
seq__14154_14622 = G__14670;
chunk__14155_14623 = G__14671;
count__14156_14624 = G__14672;
i__14157_14625 = G__14673;
continue;
} else {
var temp__5735__auto___14674__$1 = cljs.core.seq(seq__14154_14622);
if(temp__5735__auto___14674__$1){
var seq__14154_14675__$1 = temp__5735__auto___14674__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14154_14675__$1)){
var c__4609__auto___14676 = cljs.core.chunk_first(seq__14154_14675__$1);
var G__14677 = cljs.core.chunk_rest(seq__14154_14675__$1);
var G__14678 = c__4609__auto___14676;
var G__14679 = cljs.core.count(c__4609__auto___14676);
var G__14680 = (0);
seq__14154_14622 = G__14677;
chunk__14155_14623 = G__14678;
count__14156_14624 = G__14679;
i__14157_14625 = G__14680;
continue;
} else {
var vec__14227_14683 = cljs.core.first(seq__14154_14675__$1);
var column_14684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14227_14683,(0),null);
var column_info_14685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14227_14683,(1),null);
var seq__14230_14688 = cljs.core.seq(column_info_14685);
var chunk__14231_14689 = null;
var count__14232_14690 = (0);
var i__14233_14691 = (0);
while(true){
if((i__14233_14691 < count__14232_14690)){
var map__14238_14693 = chunk__14231_14689.cljs$core$IIndexed$_nth$arity$2(null,i__14233_14691);
var map__14238_14694__$1 = (((((!((map__14238_14693 == null))))?(((((map__14238_14693.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14238_14693.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14238_14693):map__14238_14693);
var gline_14695 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14238_14694__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14696 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14238_14694__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14238_14694__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14695], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14230_14688,chunk__14231_14689,count__14232_14690,i__14233_14691,seq__14154_14622,chunk__14155_14623,count__14156_14624,i__14157_14625,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14238_14693,map__14238_14694__$1,gline_14695,gcol_14696,name_14697,vec__14227_14683,column_14684,column_info_14685,seq__14154_14675__$1,temp__5735__auto___14674__$1,vec__14151_14619,line_14620,columns_14621,seq__13814_14613__$1,temp__5735__auto___14612,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14696], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14620,new cljs.core.Keyword(null,"col","col",-1959363084),column_14684,new cljs.core.Keyword(null,"name","name",1843675177),name_14697], null));
});})(seq__14230_14688,chunk__14231_14689,count__14232_14690,i__14233_14691,seq__14154_14622,chunk__14155_14623,count__14156_14624,i__14157_14625,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14238_14693,map__14238_14694__$1,gline_14695,gcol_14696,name_14697,vec__14227_14683,column_14684,column_info_14685,seq__14154_14675__$1,temp__5735__auto___14674__$1,vec__14151_14619,line_14620,columns_14621,seq__13814_14613__$1,temp__5735__auto___14612,inverted))
,cljs.core.sorted_map()));


var G__14705 = seq__14230_14688;
var G__14706 = chunk__14231_14689;
var G__14707 = count__14232_14690;
var G__14708 = (i__14233_14691 + (1));
seq__14230_14688 = G__14705;
chunk__14231_14689 = G__14706;
count__14232_14690 = G__14707;
i__14233_14691 = G__14708;
continue;
} else {
var temp__5735__auto___14709__$2 = cljs.core.seq(seq__14230_14688);
if(temp__5735__auto___14709__$2){
var seq__14230_14712__$1 = temp__5735__auto___14709__$2;
if(cljs.core.chunked_seq_QMARK_(seq__14230_14712__$1)){
var c__4609__auto___14713 = cljs.core.chunk_first(seq__14230_14712__$1);
var G__14714 = cljs.core.chunk_rest(seq__14230_14712__$1);
var G__14715 = c__4609__auto___14713;
var G__14716 = cljs.core.count(c__4609__auto___14713);
var G__14717 = (0);
seq__14230_14688 = G__14714;
chunk__14231_14689 = G__14715;
count__14232_14690 = G__14716;
i__14233_14691 = G__14717;
continue;
} else {
var map__14240_14718 = cljs.core.first(seq__14230_14712__$1);
var map__14240_14719__$1 = (((((!((map__14240_14718 == null))))?(((((map__14240_14718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14240_14718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14240_14718):map__14240_14718);
var gline_14720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14240_14719__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14240_14719__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14240_14719__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14720], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14230_14688,chunk__14231_14689,count__14232_14690,i__14233_14691,seq__14154_14622,chunk__14155_14623,count__14156_14624,i__14157_14625,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14240_14718,map__14240_14719__$1,gline_14720,gcol_14721,name_14722,seq__14230_14712__$1,temp__5735__auto___14709__$2,vec__14227_14683,column_14684,column_info_14685,seq__14154_14675__$1,temp__5735__auto___14674__$1,vec__14151_14619,line_14620,columns_14621,seq__13814_14613__$1,temp__5735__auto___14612,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14721], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14620,new cljs.core.Keyword(null,"col","col",-1959363084),column_14684,new cljs.core.Keyword(null,"name","name",1843675177),name_14722], null));
});})(seq__14230_14688,chunk__14231_14689,count__14232_14690,i__14233_14691,seq__14154_14622,chunk__14155_14623,count__14156_14624,i__14157_14625,seq__13814_14509,chunk__13815_14510,count__13816_14511,i__13817_14512,map__14240_14718,map__14240_14719__$1,gline_14720,gcol_14721,name_14722,seq__14230_14712__$1,temp__5735__auto___14709__$2,vec__14227_14683,column_14684,column_info_14685,seq__14154_14675__$1,temp__5735__auto___14674__$1,vec__14151_14619,line_14620,columns_14621,seq__13814_14613__$1,temp__5735__auto___14612,inverted))
,cljs.core.sorted_map()));


var G__14725 = cljs.core.next(seq__14230_14712__$1);
var G__14726 = null;
var G__14727 = (0);
var G__14728 = (0);
seq__14230_14688 = G__14725;
chunk__14231_14689 = G__14726;
count__14232_14690 = G__14727;
i__14233_14691 = G__14728;
continue;
}
} else {
}
}
break;
}


var G__14729 = cljs.core.next(seq__14154_14675__$1);
var G__14730 = null;
var G__14731 = (0);
var G__14732 = (0);
seq__14154_14622 = G__14729;
chunk__14155_14623 = G__14730;
count__14156_14624 = G__14731;
i__14157_14625 = G__14732;
continue;
}
} else {
}
}
break;
}


var G__14733 = cljs.core.next(seq__13814_14613__$1);
var G__14734 = null;
var G__14735 = (0);
var G__14736 = (0);
seq__13814_14509 = G__14733;
chunk__13815_14510 = G__14734;
count__13816_14511 = G__14735;
i__13817_14512 = G__14736;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
