goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__15383 = s;
var map__15383__$1 = (((((!((map__15383 == null))))?(((((map__15383.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15383.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15383):map__15383);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15383__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15383__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__15386 = info;
var map__15387 = G__15386;
var map__15387__$1 = (((((!((map__15387 == null))))?(((((map__15387.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15387.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15387):map__15387);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15387__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__15386__$1 = G__15386;
while(true){
var d__$2 = d__$1;
var map__15391 = G__15386__$1;
var map__15391__$1 = (((((!((map__15391 == null))))?(((((map__15391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15391.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15391):map__15391);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15391__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__16209 = (d__$2 + (1));
var G__16210 = shadow__$2;
d__$1 = G__16209;
G__15386__$1 = G__16210;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__15397){
var map__15398 = p__15397;
var map__15398__$1 = (((((!((map__15398 == null))))?(((((map__15398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15398.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15398):map__15398);
var name_var = map__15398__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15398__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15398__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__15400 = info;
var map__15400__$1 = (((((!((map__15400 == null))))?(((((map__15400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15400.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15400):map__15400);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15400__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15400__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__15403 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__15403) : cljs.compiler.munge.call(null,G__15403));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__15406 = arguments.length;
switch (G__15406) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__15425 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__15425.cljs$core$IFn$_invoke$arity$1 ? fexpr__15425.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__15425.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__15426 = cp;
switch (G__15426) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__15427_16222 = cljs.core.seq(s);
var chunk__15428_16223 = null;
var count__15429_16224 = (0);
var i__15430_16225 = (0);
while(true){
if((i__15430_16225 < count__15429_16224)){
var c_16226 = chunk__15428_16223.cljs$core$IIndexed$_nth$arity$2(null,i__15430_16225);
sb.append(cljs.compiler.escape_char(c_16226));


var G__16227 = seq__15427_16222;
var G__16228 = chunk__15428_16223;
var G__16229 = count__15429_16224;
var G__16230 = (i__15430_16225 + (1));
seq__15427_16222 = G__16227;
chunk__15428_16223 = G__16228;
count__15429_16224 = G__16229;
i__15430_16225 = G__16230;
continue;
} else {
var temp__5735__auto___16231 = cljs.core.seq(seq__15427_16222);
if(temp__5735__auto___16231){
var seq__15427_16232__$1 = temp__5735__auto___16231;
if(cljs.core.chunked_seq_QMARK_(seq__15427_16232__$1)){
var c__4609__auto___16233 = cljs.core.chunk_first(seq__15427_16232__$1);
var G__16234 = cljs.core.chunk_rest(seq__15427_16232__$1);
var G__16235 = c__4609__auto___16233;
var G__16236 = cljs.core.count(c__4609__auto___16233);
var G__16237 = (0);
seq__15427_16222 = G__16234;
chunk__15428_16223 = G__16235;
count__15429_16224 = G__16236;
i__15430_16225 = G__16237;
continue;
} else {
var c_16238 = cljs.core.first(seq__15427_16232__$1);
sb.append(cljs.compiler.escape_char(c_16238));


var G__16239 = cljs.core.next(seq__15427_16232__$1);
var G__16240 = null;
var G__16241 = (0);
var G__16242 = (0);
seq__15427_16222 = G__16239;
chunk__15428_16223 = G__16240;
count__15429_16224 = G__16241;
i__15430_16225 = G__16242;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15441 = cljs.core.get_global_hierarchy;
return (fexpr__15441.cljs$core$IFn$_invoke$arity$0 ? fexpr__15441.cljs$core$IFn$_invoke$arity$0() : fexpr__15441.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__15442_16243 = ast;
var map__15442_16244__$1 = (((((!((map__15442_16243 == null))))?(((((map__15442_16243.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15442_16243.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15442_16243):map__15442_16243);
var env_16245 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15442_16244__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_16245))){
var map__15444_16246 = env_16245;
var map__15444_16247__$1 = (((((!((map__15444_16246 == null))))?(((((map__15444_16246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15444_16246.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15444_16246):map__15444_16246);
var line_16248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15444_16247__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_16249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15444_16247__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__15446 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__15448 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__15447 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15447.cljs$core$IFn$_invoke$arity$1 ? fexpr__15447.cljs$core$IFn$_invoke$arity$1(G__15448) : fexpr__15447.call(null,G__15448));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15446,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__15446;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_16248 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_16249)?(column_16249 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__15458 = arguments.length;
switch (G__15458) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16251 = arguments.length;
var i__4790__auto___16252 = (0);
while(true){
if((i__4790__auto___16252 < len__4789__auto___16251)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16252]));

var G__16253 = (i__4790__auto___16252 + (1));
i__4790__auto___16252 = G__16253;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_16254 = (function (){var G__15460 = a;
if((!(typeof a === 'string'))){
return G__15460.toString();
} else {
return G__15460;
}
})();
var temp__5739__auto___16255 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___16255 == null)){
} else {
var sm_data_16256 = temp__5739__auto___16255;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_16256,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__15449_SHARP_){
return (p1__15449_SHARP_ + s_16254.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_16254], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15470 = cljs.core.seq(xs);
var chunk__15471 = null;
var count__15472 = (0);
var i__15473 = (0);
while(true){
if((i__15473 < count__15472)){
var x = chunk__15471.cljs$core$IIndexed$_nth$arity$2(null,i__15473);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16257 = seq__15470;
var G__16258 = chunk__15471;
var G__16259 = count__15472;
var G__16260 = (i__15473 + (1));
seq__15470 = G__16257;
chunk__15471 = G__16258;
count__15472 = G__16259;
i__15473 = G__16260;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15470);
if(temp__5735__auto__){
var seq__15470__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15470__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15470__$1);
var G__16261 = cljs.core.chunk_rest(seq__15470__$1);
var G__16262 = c__4609__auto__;
var G__16263 = cljs.core.count(c__4609__auto__);
var G__16264 = (0);
seq__15470 = G__16261;
chunk__15471 = G__16262;
count__15472 = G__16263;
i__15473 = G__16264;
continue;
} else {
var x = cljs.core.first(seq__15470__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16265 = cljs.core.next(seq__15470__$1);
var G__16266 = null;
var G__16267 = (0);
var G__16268 = (0);
seq__15470 = G__16265;
chunk__15471 = G__16266;
count__15472 = G__16267;
i__15473 = G__16268;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq15452){
var G__15453 = cljs.core.first(seq15452);
var seq15452__$1 = cljs.core.next(seq15452);
var G__15454 = cljs.core.first(seq15452__$1);
var seq15452__$2 = cljs.core.next(seq15452__$1);
var G__15455 = cljs.core.first(seq15452__$2);
var seq15452__$3 = cljs.core.next(seq15452__$2);
var G__15456 = cljs.core.first(seq15452__$3);
var seq15452__$4 = cljs.core.next(seq15452__$3);
var G__15457 = cljs.core.first(seq15452__$4);
var seq15452__$5 = cljs.core.next(seq15452__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15453,G__15454,G__15455,G__15456,G__15457,seq15452__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__15474){
var map__15475 = p__15474;
var map__15475__$1 = (((((!((map__15475 == null))))?(((((map__15475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15475.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15475):map__15475);
var m = map__15475__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15475__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__15500 = arguments.length;
switch (G__15500) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16270 = arguments.length;
var i__4790__auto___16271 = (0);
while(true){
if((i__4790__auto___16271 < len__4789__auto___16270)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16271]));

var G__16272 = (i__4790__auto___16271 + (1));
i__4790__auto___16271 = G__16272;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15501_16273 = cljs.core.seq(xs);
var chunk__15502_16274 = null;
var count__15503_16275 = (0);
var i__15504_16276 = (0);
while(true){
if((i__15504_16276 < count__15503_16275)){
var x_16277 = chunk__15502_16274.cljs$core$IIndexed$_nth$arity$2(null,i__15504_16276);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16277);


var G__16278 = seq__15501_16273;
var G__16279 = chunk__15502_16274;
var G__16280 = count__15503_16275;
var G__16281 = (i__15504_16276 + (1));
seq__15501_16273 = G__16278;
chunk__15502_16274 = G__16279;
count__15503_16275 = G__16280;
i__15504_16276 = G__16281;
continue;
} else {
var temp__5735__auto___16282 = cljs.core.seq(seq__15501_16273);
if(temp__5735__auto___16282){
var seq__15501_16283__$1 = temp__5735__auto___16282;
if(cljs.core.chunked_seq_QMARK_(seq__15501_16283__$1)){
var c__4609__auto___16284 = cljs.core.chunk_first(seq__15501_16283__$1);
var G__16285 = cljs.core.chunk_rest(seq__15501_16283__$1);
var G__16286 = c__4609__auto___16284;
var G__16287 = cljs.core.count(c__4609__auto___16284);
var G__16288 = (0);
seq__15501_16273 = G__16285;
chunk__15502_16274 = G__16286;
count__15503_16275 = G__16287;
i__15504_16276 = G__16288;
continue;
} else {
var x_16289 = cljs.core.first(seq__15501_16283__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16289);


var G__16290 = cljs.core.next(seq__15501_16283__$1);
var G__16291 = null;
var G__16292 = (0);
var G__16293 = (0);
seq__15501_16273 = G__16290;
chunk__15502_16274 = G__16291;
count__15503_16275 = G__16292;
i__15504_16276 = G__16293;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq15494){
var G__15495 = cljs.core.first(seq15494);
var seq15494__$1 = cljs.core.next(seq15494);
var G__15496 = cljs.core.first(seq15494__$1);
var seq15494__$2 = cljs.core.next(seq15494__$1);
var G__15497 = cljs.core.first(seq15494__$2);
var seq15494__$3 = cljs.core.next(seq15494__$2);
var G__15498 = cljs.core.first(seq15494__$3);
var seq15494__$4 = cljs.core.next(seq15494__$3);
var G__15499 = cljs.core.first(seq15494__$4);
var seq15494__$5 = cljs.core.next(seq15494__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15495,G__15496,G__15497,G__15498,G__15499,seq15494__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__15505_16294 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__15506_16295 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__15507_16296 = true;
var _STAR_print_fn_STAR__temp_val__15508_16297 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__15507_16296);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__15508_16297);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__15506_16295);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__15505_16294);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15509 = cljs.core.get_global_hierarchy;
return (fexpr__15509.cljs$core$IFn$_invoke$arity$0 ? fexpr__15509.cljs$core$IFn$_invoke$arity$0() : fexpr__15509.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__15510 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15510,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15510,(1),null);
var G__15513 = ns;
var G__15514 = name;
var G__15515 = (function (){
var G__15516 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__15516) : cljs.compiler.emit_constant.call(null,G__15516));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__15513,G__15514,G__15515) : cljs.compiler.emit_record_value.call(null,G__15513,G__15514,G__15515));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__15517 = cljs.core.keys(x);
var G__15518 = cljs.core.vals(x);
var G__15519 = cljs.compiler.emit_constants_comma_sep;
var G__15520 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__15517,G__15518,G__15519,G__15520) : cljs.compiler.emit_map.call(null,G__15517,G__15518,G__15519,G__15520));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__15526 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__15527 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__15526,G__15527) : cljs.compiler.emit_with_meta.call(null,G__15526,G__15527));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__15528 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15528,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15528,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15528,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15531 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15531) : x.call(null,G__15531));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15532 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15532) : x.call(null,G__15532));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__15534 = items;
var G__15535 = (function (p1__15533_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__15533_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__15534,G__15535) : cljs.compiler.emit_js_object.call(null,G__15534,G__15535));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__15537){
var map__15538 = p__15537;
var map__15538__$1 = (((((!((map__15538 == null))))?(((((map__15538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15538):map__15538);
var ast = map__15538__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15538__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15538__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15538__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__15540 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15540__$1 = (((((!((map__15540 == null))))?(((((map__15540.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15540.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15540):map__15540);
var cenv = map__15540__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15540__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__15542 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__15545 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__15545) : cljs.compiler.es5_GT__EQ_.call(null,G__15545));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__15542,cljs.analyzer.es5_allowed);
} else {
return G__15542;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__15546 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__15546,reserved);
} else {
return G__15546;
}
})();
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__15547_16298 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__15547_16299__$1 = (((G__15547_16298 instanceof cljs.core.Keyword))?G__15547_16298.fqn:null);
switch (G__15547_16299__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__15548){
var map__15549 = p__15548;
var map__15549__$1 = (((((!((map__15549 == null))))?(((((map__15549.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15549.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15549):map__15549);
var arg = map__15549__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15549__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15549__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15549__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15549__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));


var map__15551 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__15551__$1 = (((((!((map__15551 == null))))?(((((map__15551.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15551.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15551):map__15551);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15551__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__15553){
var map__15554 = p__15553;
var map__15554__$1 = (((((!((map__15554 == null))))?(((((map__15554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15554.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15554):map__15554);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15554__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15554__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15554__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__15556_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__15556_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__15557 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15557) : comma_sep.call(null,G__15557));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__15558 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15558) : comma_sep.call(null,G__15558));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__15559){
var map__15560 = p__15559;
var map__15560__$1 = (((((!((map__15560 == null))))?(((((map__15560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15560.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15560):map__15560);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15560__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15560__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15560__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__15562){
var map__15563 = p__15562;
var map__15563__$1 = (((((!((map__15563 == null))))?(((((map__15563.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15563.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15563):map__15563);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15563__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15563__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__15565_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__15565_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__15574 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15574) : comma_sep.call(null,G__15574));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__15575){
var map__15576 = p__15575;
var map__15576__$1 = (((((!((map__15576 == null))))?(((((map__15576.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15576.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15576):map__15576);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15576__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15576__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___16301 = cljs.core.seq(items);
if(temp__5735__auto___16301){
var items_16302__$1 = temp__5735__auto___16301;
var vec__15578_16303 = items_16302__$1;
var seq__15579_16304 = cljs.core.seq(vec__15578_16303);
var first__15580_16305 = cljs.core.first(seq__15579_16304);
var seq__15579_16306__$1 = cljs.core.next(seq__15579_16304);
var vec__15581_16307 = first__15580_16305;
var k_16308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15581_16307,(0),null);
var v_16309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15581_16307,(1),null);
var r_16310 = seq__15579_16306__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_16308),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16309) : emit_js_object_val.call(null,v_16309)));

var seq__15584_16311 = cljs.core.seq(r_16310);
var chunk__15585_16312 = null;
var count__15586_16313 = (0);
var i__15587_16314 = (0);
while(true){
if((i__15587_16314 < count__15586_16313)){
var vec__15594_16315 = chunk__15585_16312.cljs$core$IIndexed$_nth$arity$2(null,i__15587_16314);
var k_16316__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15594_16315,(0),null);
var v_16317__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15594_16315,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16316__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16317__$1) : emit_js_object_val.call(null,v_16317__$1)));


var G__16318 = seq__15584_16311;
var G__16319 = chunk__15585_16312;
var G__16320 = count__15586_16313;
var G__16321 = (i__15587_16314 + (1));
seq__15584_16311 = G__16318;
chunk__15585_16312 = G__16319;
count__15586_16313 = G__16320;
i__15587_16314 = G__16321;
continue;
} else {
var temp__5735__auto___16322__$1 = cljs.core.seq(seq__15584_16311);
if(temp__5735__auto___16322__$1){
var seq__15584_16323__$1 = temp__5735__auto___16322__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15584_16323__$1)){
var c__4609__auto___16324 = cljs.core.chunk_first(seq__15584_16323__$1);
var G__16325 = cljs.core.chunk_rest(seq__15584_16323__$1);
var G__16326 = c__4609__auto___16324;
var G__16327 = cljs.core.count(c__4609__auto___16324);
var G__16328 = (0);
seq__15584_16311 = G__16325;
chunk__15585_16312 = G__16326;
count__15586_16313 = G__16327;
i__15587_16314 = G__16328;
continue;
} else {
var vec__15597_16329 = cljs.core.first(seq__15584_16323__$1);
var k_16330__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15597_16329,(0),null);
var v_16331__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15597_16329,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16330__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16331__$1) : emit_js_object_val.call(null,v_16331__$1)));


var G__16332 = cljs.core.next(seq__15584_16323__$1);
var G__16333 = null;
var G__16334 = (0);
var G__16335 = (0);
seq__15584_16311 = G__16332;
chunk__15585_16312 = G__16333;
count__15586_16313 = G__16334;
i__15587_16314 = G__16335;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__15600){
var map__15601 = p__15600;
var map__15601__$1 = (((((!((map__15601 == null))))?(((((map__15601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15601.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15601):map__15601);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15601__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15601__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15601__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__15603){
var map__15604 = p__15603;
var map__15604__$1 = (((((!((map__15604 == null))))?(((((map__15604.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15604.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15604):map__15604);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15604__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15604__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__15606){
var map__15607 = p__15606;
var map__15607__$1 = (((((!((map__15607 == null))))?(((((map__15607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15607.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15607):map__15607);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15607__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__15609){
var map__15610 = p__15609;
var map__15610__$1 = (((((!((map__15610 == null))))?(((((map__15610.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15610.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15610):map__15610);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15610__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15610__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__15614 = cljs.analyzer.unwrap_quote(expr);
var map__15614__$1 = (((((!((map__15614 == null))))?(((((map__15614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15614.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15614):map__15614);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__15616 = cljs.analyzer.unwrap_quote(expr);
var map__15616__$1 = (((((!((map__15616 == null))))?(((((map__15616.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15616.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15616):map__15616);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15616__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15616__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15616__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__15623 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__15623.cljs$core$IFn$_invoke$arity$1 ? fexpr__15623.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15623.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__15624){
var map__15625 = p__15624;
var map__15625__$1 = (((((!((map__15625 == null))))?(((((map__15625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15625.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15625):map__15625);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15625__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15625__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15625__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15625__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15625__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__15627){
var map__15628 = p__15627;
var map__15628__$1 = (((((!((map__15628 == null))))?(((((map__15628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15628.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15628):map__15628);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15628__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15628__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15628__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15628__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__15632_16336 = cljs.core.seq(nodes);
var chunk__15633_16337 = null;
var count__15634_16338 = (0);
var i__15635_16339 = (0);
while(true){
if((i__15635_16339 < count__15634_16338)){
var map__15652_16340 = chunk__15633_16337.cljs$core$IIndexed$_nth$arity$2(null,i__15635_16339);
var map__15652_16341__$1 = (((((!((map__15652_16340 == null))))?(((((map__15652_16340.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15652_16340.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15652_16340):map__15652_16340);
var ts_16342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15652_16341__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15653_16343 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15652_16341__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15653_16344__$1 = (((((!((map__15653_16343 == null))))?(((((map__15653_16343.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15653_16343.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15653_16343):map__15653_16343);
var then_16345 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15653_16344__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15656_16346 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16342));
var chunk__15657_16347 = null;
var count__15658_16348 = (0);
var i__15659_16349 = (0);
while(true){
if((i__15659_16349 < count__15658_16348)){
var test_16350 = chunk__15657_16347.cljs$core$IIndexed$_nth$arity$2(null,i__15659_16349);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16350,":");


var G__16351 = seq__15656_16346;
var G__16352 = chunk__15657_16347;
var G__16353 = count__15658_16348;
var G__16354 = (i__15659_16349 + (1));
seq__15656_16346 = G__16351;
chunk__15657_16347 = G__16352;
count__15658_16348 = G__16353;
i__15659_16349 = G__16354;
continue;
} else {
var temp__5735__auto___16355 = cljs.core.seq(seq__15656_16346);
if(temp__5735__auto___16355){
var seq__15656_16356__$1 = temp__5735__auto___16355;
if(cljs.core.chunked_seq_QMARK_(seq__15656_16356__$1)){
var c__4609__auto___16357 = cljs.core.chunk_first(seq__15656_16356__$1);
var G__16358 = cljs.core.chunk_rest(seq__15656_16356__$1);
var G__16359 = c__4609__auto___16357;
var G__16360 = cljs.core.count(c__4609__auto___16357);
var G__16361 = (0);
seq__15656_16346 = G__16358;
chunk__15657_16347 = G__16359;
count__15658_16348 = G__16360;
i__15659_16349 = G__16361;
continue;
} else {
var test_16362 = cljs.core.first(seq__15656_16356__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16362,":");


var G__16363 = cljs.core.next(seq__15656_16356__$1);
var G__16364 = null;
var G__16365 = (0);
var G__16366 = (0);
seq__15656_16346 = G__16363;
chunk__15657_16347 = G__16364;
count__15658_16348 = G__16365;
i__15659_16349 = G__16366;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16345);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16345);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16367 = seq__15632_16336;
var G__16368 = chunk__15633_16337;
var G__16369 = count__15634_16338;
var G__16370 = (i__15635_16339 + (1));
seq__15632_16336 = G__16367;
chunk__15633_16337 = G__16368;
count__15634_16338 = G__16369;
i__15635_16339 = G__16370;
continue;
} else {
var temp__5735__auto___16371 = cljs.core.seq(seq__15632_16336);
if(temp__5735__auto___16371){
var seq__15632_16372__$1 = temp__5735__auto___16371;
if(cljs.core.chunked_seq_QMARK_(seq__15632_16372__$1)){
var c__4609__auto___16373 = cljs.core.chunk_first(seq__15632_16372__$1);
var G__16374 = cljs.core.chunk_rest(seq__15632_16372__$1);
var G__16375 = c__4609__auto___16373;
var G__16376 = cljs.core.count(c__4609__auto___16373);
var G__16377 = (0);
seq__15632_16336 = G__16374;
chunk__15633_16337 = G__16375;
count__15634_16338 = G__16376;
i__15635_16339 = G__16377;
continue;
} else {
var map__15660_16378 = cljs.core.first(seq__15632_16372__$1);
var map__15660_16379__$1 = (((((!((map__15660_16378 == null))))?(((((map__15660_16378.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15660_16378.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15660_16378):map__15660_16378);
var ts_16380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15660_16379__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15661_16381 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15660_16379__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15661_16382__$1 = (((((!((map__15661_16381 == null))))?(((((map__15661_16381.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15661_16381.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15661_16381):map__15661_16381);
var then_16383 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15661_16382__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15667_16384 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16380));
var chunk__15668_16385 = null;
var count__15669_16386 = (0);
var i__15670_16387 = (0);
while(true){
if((i__15670_16387 < count__15669_16386)){
var test_16388 = chunk__15668_16385.cljs$core$IIndexed$_nth$arity$2(null,i__15670_16387);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16388,":");


var G__16389 = seq__15667_16384;
var G__16390 = chunk__15668_16385;
var G__16391 = count__15669_16386;
var G__16392 = (i__15670_16387 + (1));
seq__15667_16384 = G__16389;
chunk__15668_16385 = G__16390;
count__15669_16386 = G__16391;
i__15670_16387 = G__16392;
continue;
} else {
var temp__5735__auto___16393__$1 = cljs.core.seq(seq__15667_16384);
if(temp__5735__auto___16393__$1){
var seq__15667_16394__$1 = temp__5735__auto___16393__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15667_16394__$1)){
var c__4609__auto___16395 = cljs.core.chunk_first(seq__15667_16394__$1);
var G__16396 = cljs.core.chunk_rest(seq__15667_16394__$1);
var G__16397 = c__4609__auto___16395;
var G__16398 = cljs.core.count(c__4609__auto___16395);
var G__16399 = (0);
seq__15667_16384 = G__16396;
chunk__15668_16385 = G__16397;
count__15669_16386 = G__16398;
i__15670_16387 = G__16399;
continue;
} else {
var test_16400 = cljs.core.first(seq__15667_16394__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16400,":");


var G__16401 = cljs.core.next(seq__15667_16394__$1);
var G__16402 = null;
var G__16403 = (0);
var G__16404 = (0);
seq__15667_16384 = G__16401;
chunk__15668_16385 = G__16402;
count__15669_16386 = G__16403;
i__15670_16387 = G__16404;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16383);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16383);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16405 = cljs.core.next(seq__15632_16372__$1);
var G__16406 = null;
var G__16407 = (0);
var G__16408 = (0);
seq__15632_16336 = G__16405;
chunk__15633_16337 = G__16406;
count__15634_16338 = G__16407;
i__15635_16339 = G__16408;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__15671){
var map__15672 = p__15671;
var map__15672__$1 = (((((!((map__15672 == null))))?(((((map__15672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15672.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15672):map__15672);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15672__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15672__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15677 = env;
var G__15678 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15677,G__15678) : cljs.compiler.resolve_type.call(null,G__15677,G__15678));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__15679 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15679,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15679,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__15674_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__15674_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__15674_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__15682 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__15682,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__15682;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15685 = env;
var G__15686 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15685,G__15686) : cljs.compiler.resolve_type.call(null,G__15685,G__15686));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15690_SHARP_){
return cljs.compiler.resolve_type(env,p1__15690_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__15695 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15696 = cljs.core.seq(vec__15695);
var first__15697 = cljs.core.first(seq__15696);
var seq__15696__$1 = cljs.core.next(seq__15696);
var p = first__15697;
var first__15697__$1 = cljs.core.first(seq__15696__$1);
var seq__15696__$2 = cljs.core.next(seq__15696__$1);
var ts = first__15697__$1;
var first__15697__$2 = cljs.core.first(seq__15696__$2);
var seq__15696__$3 = cljs.core.next(seq__15696__$2);
var n = first__15697__$2;
var xs = seq__15696__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__15698 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15699 = cljs.core.seq(vec__15698);
var first__15700 = cljs.core.first(seq__15699);
var seq__15699__$1 = cljs.core.next(seq__15699);
var p = first__15700;
var first__15700__$1 = cljs.core.first(seq__15699__$1);
var seq__15699__$2 = cljs.core.next(seq__15699__$1);
var ts = first__15700__$1;
var xs = seq__15699__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__15702 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__15701 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__15701.cljs$core$IFn$_invoke$arity$1 ? fexpr__15701.cljs$core$IFn$_invoke$arity$1(G__15702) : fexpr__15701.call(null,G__15702));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__15705 = arguments.length;
switch (G__15705) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__15718 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15703_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__15703_SHARP_);
} else {
return p1__15703_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__15719 = cljs.core.seq(vec__15718);
var first__15720 = cljs.core.first(seq__15719);
var seq__15719__$1 = cljs.core.next(seq__15719);
var x = first__15720;
var ys = seq__15719__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__15721 = cljs.core.seq(ys);
var chunk__15722 = null;
var count__15723 = (0);
var i__15724 = (0);
while(true){
if((i__15724 < count__15723)){
var next_line = chunk__15722.cljs$core$IIndexed$_nth$arity$2(null,i__15724);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__16411 = seq__15721;
var G__16412 = chunk__15722;
var G__16413 = count__15723;
var G__16414 = (i__15724 + (1));
seq__15721 = G__16411;
chunk__15722 = G__16412;
count__15723 = G__16413;
i__15724 = G__16414;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15721);
if(temp__5735__auto__){
var seq__15721__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15721__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15721__$1);
var G__16415 = cljs.core.chunk_rest(seq__15721__$1);
var G__16416 = c__4609__auto__;
var G__16417 = cljs.core.count(c__4609__auto__);
var G__16418 = (0);
seq__15721 = G__16415;
chunk__15722 = G__16416;
count__15723 = G__16417;
i__15724 = G__16418;
continue;
} else {
var next_line = cljs.core.first(seq__15721__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__16419 = cljs.core.next(seq__15721__$1);
var G__16420 = null;
var G__16421 = (0);
var G__16422 = (0);
seq__15721 = G__16419;
chunk__15722 = G__16420;
count__15723 = G__16421;
i__15724 = G__16422;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__15740_16423 = cljs.core.seq(docs__$2);
var chunk__15741_16424 = null;
var count__15742_16425 = (0);
var i__15743_16426 = (0);
while(true){
if((i__15743_16426 < count__15742_16425)){
var e_16427 = chunk__15741_16424.cljs$core$IIndexed$_nth$arity$2(null,i__15743_16426);
if(cljs.core.truth_(e_16427)){
print_comment_lines(e_16427);
} else {
}


var G__16436 = seq__15740_16423;
var G__16437 = chunk__15741_16424;
var G__16438 = count__15742_16425;
var G__16439 = (i__15743_16426 + (1));
seq__15740_16423 = G__16436;
chunk__15741_16424 = G__16437;
count__15742_16425 = G__16438;
i__15743_16426 = G__16439;
continue;
} else {
var temp__5735__auto___16440 = cljs.core.seq(seq__15740_16423);
if(temp__5735__auto___16440){
var seq__15740_16441__$1 = temp__5735__auto___16440;
if(cljs.core.chunked_seq_QMARK_(seq__15740_16441__$1)){
var c__4609__auto___16442 = cljs.core.chunk_first(seq__15740_16441__$1);
var G__16443 = cljs.core.chunk_rest(seq__15740_16441__$1);
var G__16444 = c__4609__auto___16442;
var G__16445 = cljs.core.count(c__4609__auto___16442);
var G__16446 = (0);
seq__15740_16423 = G__16443;
chunk__15741_16424 = G__16444;
count__15742_16425 = G__16445;
i__15743_16426 = G__16446;
continue;
} else {
var e_16447 = cljs.core.first(seq__15740_16441__$1);
if(cljs.core.truth_(e_16447)){
print_comment_lines(e_16447);
} else {
}


var G__16448 = cljs.core.next(seq__15740_16441__$1);
var G__16449 = null;
var G__16450 = (0);
var G__16451 = (0);
seq__15740_16423 = G__16448;
chunk__15741_16424 = G__16449;
count__15742_16425 = G__16450;
i__15743_16426 = G__16451;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__15745_SHARP_){
return goog.string.startsWith(p1__15745_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__15759){
var map__15760 = p__15759;
var map__15760__$1 = (((((!((map__15760 == null))))?(((((map__15760.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15760.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15760):map__15760);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15760__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__15787){
var map__15788 = p__15787;
var map__15788__$1 = (((((!((map__15788 == null))))?(((((map__15788.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15788.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15788):map__15788);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__15790_16469 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__15791_16470 = null;
var count__15792_16471 = (0);
var i__15793_16472 = (0);
while(true){
if((i__15793_16472 < count__15792_16471)){
var vec__15800_16473 = chunk__15791_16470.cljs$core$IIndexed$_nth$arity$2(null,i__15793_16472);
var i_16474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15800_16473,(0),null);
var param_16475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15800_16473,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_16475);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__16476 = seq__15790_16469;
var G__16477 = chunk__15791_16470;
var G__16478 = count__15792_16471;
var G__16479 = (i__15793_16472 + (1));
seq__15790_16469 = G__16476;
chunk__15791_16470 = G__16477;
count__15792_16471 = G__16478;
i__15793_16472 = G__16479;
continue;
} else {
var temp__5735__auto___16480 = cljs.core.seq(seq__15790_16469);
if(temp__5735__auto___16480){
var seq__15790_16481__$1 = temp__5735__auto___16480;
if(cljs.core.chunked_seq_QMARK_(seq__15790_16481__$1)){
var c__4609__auto___16482 = cljs.core.chunk_first(seq__15790_16481__$1);
var G__16483 = cljs.core.chunk_rest(seq__15790_16481__$1);
var G__16484 = c__4609__auto___16482;
var G__16485 = cljs.core.count(c__4609__auto___16482);
var G__16486 = (0);
seq__15790_16469 = G__16483;
chunk__15791_16470 = G__16484;
count__15792_16471 = G__16485;
i__15793_16472 = G__16486;
continue;
} else {
var vec__15803_16487 = cljs.core.first(seq__15790_16481__$1);
var i_16488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15803_16487,(0),null);
var param_16489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15803_16487,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_16489);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__16490 = cljs.core.next(seq__15790_16481__$1);
var G__16491 = null;
var G__16492 = (0);
var G__16493 = (0);
seq__15790_16469 = G__16490;
chunk__15791_16470 = G__16491;
count__15792_16471 = G__16492;
i__15793_16472 = G__16493;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15806_16494 = cljs.core.seq(params);
var chunk__15807_16495 = null;
var count__15808_16496 = (0);
var i__15809_16497 = (0);
while(true){
if((i__15809_16497 < count__15808_16496)){
var param_16498 = chunk__15807_16495.cljs$core$IIndexed$_nth$arity$2(null,i__15809_16497);
cljs.compiler.emit(param_16498);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16498,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16499 = seq__15806_16494;
var G__16500 = chunk__15807_16495;
var G__16501 = count__15808_16496;
var G__16502 = (i__15809_16497 + (1));
seq__15806_16494 = G__16499;
chunk__15807_16495 = G__16500;
count__15808_16496 = G__16501;
i__15809_16497 = G__16502;
continue;
} else {
var temp__5735__auto___16503 = cljs.core.seq(seq__15806_16494);
if(temp__5735__auto___16503){
var seq__15806_16504__$1 = temp__5735__auto___16503;
if(cljs.core.chunked_seq_QMARK_(seq__15806_16504__$1)){
var c__4609__auto___16505 = cljs.core.chunk_first(seq__15806_16504__$1);
var G__16506 = cljs.core.chunk_rest(seq__15806_16504__$1);
var G__16507 = c__4609__auto___16505;
var G__16508 = cljs.core.count(c__4609__auto___16505);
var G__16509 = (0);
seq__15806_16494 = G__16506;
chunk__15807_16495 = G__16507;
count__15808_16496 = G__16508;
i__15809_16497 = G__16509;
continue;
} else {
var param_16514 = cljs.core.first(seq__15806_16504__$1);
cljs.compiler.emit(param_16514);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16514,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16515 = cljs.core.next(seq__15806_16504__$1);
var G__16516 = null;
var G__16517 = (0);
var G__16518 = (0);
seq__15806_16494 = G__16515;
chunk__15807_16495 = G__16516;
count__15808_16496 = G__16517;
i__15809_16497 = G__16518;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15810_16519 = cljs.core.seq(params);
var chunk__15811_16520 = null;
var count__15812_16521 = (0);
var i__15813_16522 = (0);
while(true){
if((i__15813_16522 < count__15812_16521)){
var param_16523 = chunk__15811_16520.cljs$core$IIndexed$_nth$arity$2(null,i__15813_16522);
cljs.compiler.emit(param_16523);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16523,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16524 = seq__15810_16519;
var G__16525 = chunk__15811_16520;
var G__16526 = count__15812_16521;
var G__16527 = (i__15813_16522 + (1));
seq__15810_16519 = G__16524;
chunk__15811_16520 = G__16525;
count__15812_16521 = G__16526;
i__15813_16522 = G__16527;
continue;
} else {
var temp__5735__auto___16528 = cljs.core.seq(seq__15810_16519);
if(temp__5735__auto___16528){
var seq__15810_16529__$1 = temp__5735__auto___16528;
if(cljs.core.chunked_seq_QMARK_(seq__15810_16529__$1)){
var c__4609__auto___16530 = cljs.core.chunk_first(seq__15810_16529__$1);
var G__16531 = cljs.core.chunk_rest(seq__15810_16529__$1);
var G__16532 = c__4609__auto___16530;
var G__16533 = cljs.core.count(c__4609__auto___16530);
var G__16534 = (0);
seq__15810_16519 = G__16531;
chunk__15811_16520 = G__16532;
count__15812_16521 = G__16533;
i__15813_16522 = G__16534;
continue;
} else {
var param_16535 = cljs.core.first(seq__15810_16529__$1);
cljs.compiler.emit(param_16535);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16535,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16536 = cljs.core.next(seq__15810_16529__$1);
var G__16537 = null;
var G__16538 = (0);
var G__16539 = (0);
seq__15810_16519 = G__16536;
chunk__15811_16520 = G__16537;
count__15812_16521 = G__16538;
i__15813_16522 = G__16539;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__15814 = cljs.core.seq(params);
var chunk__15815 = null;
var count__15816 = (0);
var i__15817 = (0);
while(true){
if((i__15817 < count__15816)){
var param = chunk__15815.cljs$core$IIndexed$_nth$arity$2(null,i__15817);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16540 = seq__15814;
var G__16541 = chunk__15815;
var G__16542 = count__15816;
var G__16543 = (i__15817 + (1));
seq__15814 = G__16540;
chunk__15815 = G__16541;
count__15816 = G__16542;
i__15817 = G__16543;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15814);
if(temp__5735__auto__){
var seq__15814__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15814__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15814__$1);
var G__16544 = cljs.core.chunk_rest(seq__15814__$1);
var G__16545 = c__4609__auto__;
var G__16546 = cljs.core.count(c__4609__auto__);
var G__16547 = (0);
seq__15814 = G__16544;
chunk__15815 = G__16545;
count__15816 = G__16546;
i__15817 = G__16547;
continue;
} else {
var param = cljs.core.first(seq__15814__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16548 = cljs.core.next(seq__15814__$1);
var G__16549 = null;
var G__16550 = (0);
var G__16551 = (0);
seq__15814 = G__16548;
chunk__15815 = G__16549;
count__15816 = G__16550;
i__15817 = G__16551;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__15849){
var map__15850 = p__15849;
var map__15850__$1 = (((((!((map__15850 == null))))?(((((map__15850.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15850.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15850):map__15850);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15850__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15850__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15850__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15850__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15850__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15850__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__15877){
var map__15878 = p__15877;
var map__15878__$1 = (((((!((map__15878 == null))))?(((((map__15878.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15878.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15878):map__15878);
var f = map__15878__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15878__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_16560__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16561 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16560__$1);
var delegate_name_16562 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16561),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_16562," = function (");

var seq__15880_16563 = cljs.core.seq(params);
var chunk__15881_16564 = null;
var count__15882_16565 = (0);
var i__15883_16566 = (0);
while(true){
if((i__15883_16566 < count__15882_16565)){
var param_16567 = chunk__15881_16564.cljs$core$IIndexed$_nth$arity$2(null,i__15883_16566);
cljs.compiler.emit(param_16567);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16567,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16568 = seq__15880_16563;
var G__16569 = chunk__15881_16564;
var G__16570 = count__15882_16565;
var G__16571 = (i__15883_16566 + (1));
seq__15880_16563 = G__16568;
chunk__15881_16564 = G__16569;
count__15882_16565 = G__16570;
i__15883_16566 = G__16571;
continue;
} else {
var temp__5735__auto___16572 = cljs.core.seq(seq__15880_16563);
if(temp__5735__auto___16572){
var seq__15880_16573__$1 = temp__5735__auto___16572;
if(cljs.core.chunked_seq_QMARK_(seq__15880_16573__$1)){
var c__4609__auto___16574 = cljs.core.chunk_first(seq__15880_16573__$1);
var G__16575 = cljs.core.chunk_rest(seq__15880_16573__$1);
var G__16576 = c__4609__auto___16574;
var G__16577 = cljs.core.count(c__4609__auto___16574);
var G__16578 = (0);
seq__15880_16563 = G__16575;
chunk__15881_16564 = G__16576;
count__15882_16565 = G__16577;
i__15883_16566 = G__16578;
continue;
} else {
var param_16579 = cljs.core.first(seq__15880_16573__$1);
cljs.compiler.emit(param_16579);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16579,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16580 = cljs.core.next(seq__15880_16573__$1);
var G__16581 = null;
var G__16582 = (0);
var G__16583 = (0);
seq__15880_16563 = G__16580;
chunk__15881_16564 = G__16581;
count__15882_16565 = G__16582;
i__15883_16566 = G__16583;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_16561," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_16584 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_16584,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_16562,".call(this,");

var seq__15886_16585 = cljs.core.seq(params);
var chunk__15887_16586 = null;
var count__15888_16587 = (0);
var i__15889_16588 = (0);
while(true){
if((i__15889_16588 < count__15888_16587)){
var param_16589 = chunk__15887_16586.cljs$core$IIndexed$_nth$arity$2(null,i__15889_16588);
cljs.compiler.emit(param_16589);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16589,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16590 = seq__15886_16585;
var G__16591 = chunk__15887_16586;
var G__16592 = count__15888_16587;
var G__16593 = (i__15889_16588 + (1));
seq__15886_16585 = G__16590;
chunk__15887_16586 = G__16591;
count__15888_16587 = G__16592;
i__15889_16588 = G__16593;
continue;
} else {
var temp__5735__auto___16594 = cljs.core.seq(seq__15886_16585);
if(temp__5735__auto___16594){
var seq__15886_16595__$1 = temp__5735__auto___16594;
if(cljs.core.chunked_seq_QMARK_(seq__15886_16595__$1)){
var c__4609__auto___16596 = cljs.core.chunk_first(seq__15886_16595__$1);
var G__16597 = cljs.core.chunk_rest(seq__15886_16595__$1);
var G__16598 = c__4609__auto___16596;
var G__16599 = cljs.core.count(c__4609__auto___16596);
var G__16600 = (0);
seq__15886_16585 = G__16597;
chunk__15887_16586 = G__16598;
count__15888_16587 = G__16599;
i__15889_16588 = G__16600;
continue;
} else {
var param_16601 = cljs.core.first(seq__15886_16595__$1);
cljs.compiler.emit(param_16601);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16601,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16602 = cljs.core.next(seq__15886_16595__$1);
var G__16603 = null;
var G__16604 = (0);
var G__16605 = (0);
seq__15886_16585 = G__16602;
chunk__15887_16586 = G__16603;
count__15888_16587 = G__16604;
i__15889_16588 = G__16605;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16561,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_16561,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_16560__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16561,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_16562,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16561,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__15893){
var map__15894 = p__15893;
var map__15894__$1 = (((((!((map__15894 == null))))?(((((map__15894.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15894.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15894):map__15894);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15894__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15894__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15894__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15894__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15894__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15894__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15894__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15894__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__15890_SHARP_){
var and__4174__auto__ = p1__15890_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__15890_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_16606__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16607 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16606__$1);
var maxparams_16608 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_16609 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16607),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_16610 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__15891_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__15891_SHARP_)));
}),cljs.core.seq(mmap_16609));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_16607," = null;");

var seq__15896_16611 = cljs.core.seq(ms_16610);
var chunk__15897_16612 = null;
var count__15898_16613 = (0);
var i__15899_16614 = (0);
while(true){
if((i__15899_16614 < count__15898_16613)){
var vec__15906_16615 = chunk__15897_16612.cljs$core$IIndexed$_nth$arity$2(null,i__15899_16614);
var n_16616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15906_16615,(0),null);
var meth_16617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15906_16615,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16616," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16617))){
cljs.compiler.emit_variadic_fn_method(meth_16617);
} else {
cljs.compiler.emit_fn_method(meth_16617);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16618 = seq__15896_16611;
var G__16619 = chunk__15897_16612;
var G__16620 = count__15898_16613;
var G__16621 = (i__15899_16614 + (1));
seq__15896_16611 = G__16618;
chunk__15897_16612 = G__16619;
count__15898_16613 = G__16620;
i__15899_16614 = G__16621;
continue;
} else {
var temp__5735__auto___16622 = cljs.core.seq(seq__15896_16611);
if(temp__5735__auto___16622){
var seq__15896_16623__$1 = temp__5735__auto___16622;
if(cljs.core.chunked_seq_QMARK_(seq__15896_16623__$1)){
var c__4609__auto___16624 = cljs.core.chunk_first(seq__15896_16623__$1);
var G__16625 = cljs.core.chunk_rest(seq__15896_16623__$1);
var G__16626 = c__4609__auto___16624;
var G__16627 = cljs.core.count(c__4609__auto___16624);
var G__16628 = (0);
seq__15896_16611 = G__16625;
chunk__15897_16612 = G__16626;
count__15898_16613 = G__16627;
i__15899_16614 = G__16628;
continue;
} else {
var vec__15917_16629 = cljs.core.first(seq__15896_16623__$1);
var n_16630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15917_16629,(0),null);
var meth_16631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15917_16629,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16630," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16631))){
cljs.compiler.emit_variadic_fn_method(meth_16631);
} else {
cljs.compiler.emit_fn_method(meth_16631);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16632 = cljs.core.next(seq__15896_16623__$1);
var G__16633 = null;
var G__16634 = (0);
var G__16635 = (0);
seq__15896_16611 = G__16632;
chunk__15897_16612 = G__16633;
count__15898_16613 = G__16634;
i__15899_16614 = G__16635;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16607," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_16608),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_16608)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_16608));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__15924_16639 = cljs.core.seq(ms_16610);
var chunk__15925_16640 = null;
var count__15926_16641 = (0);
var i__15927_16642 = (0);
while(true){
if((i__15927_16642 < count__15926_16641)){
var vec__15934_16643 = chunk__15925_16640.cljs$core$IIndexed$_nth$arity$2(null,i__15927_16642);
var n_16644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15934_16643,(0),null);
var meth_16645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15934_16643,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16645))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16646 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16646," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16647 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16646," = new cljs.core.IndexedSeq(",a_16647,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16644,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16608)),(((cljs.core.count(maxparams_16608) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16646,");"], 0));
} else {
var pcnt_16648 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16645));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16648,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16644,".call(this",(((pcnt_16648 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16648,maxparams_16608)),null,(1),null)),(2),null))),");");
}


var G__16652 = seq__15924_16639;
var G__16653 = chunk__15925_16640;
var G__16654 = count__15926_16641;
var G__16655 = (i__15927_16642 + (1));
seq__15924_16639 = G__16652;
chunk__15925_16640 = G__16653;
count__15926_16641 = G__16654;
i__15927_16642 = G__16655;
continue;
} else {
var temp__5735__auto___16656 = cljs.core.seq(seq__15924_16639);
if(temp__5735__auto___16656){
var seq__15924_16657__$1 = temp__5735__auto___16656;
if(cljs.core.chunked_seq_QMARK_(seq__15924_16657__$1)){
var c__4609__auto___16658 = cljs.core.chunk_first(seq__15924_16657__$1);
var G__16659 = cljs.core.chunk_rest(seq__15924_16657__$1);
var G__16660 = c__4609__auto___16658;
var G__16661 = cljs.core.count(c__4609__auto___16658);
var G__16662 = (0);
seq__15924_16639 = G__16659;
chunk__15925_16640 = G__16660;
count__15926_16641 = G__16661;
i__15927_16642 = G__16662;
continue;
} else {
var vec__15937_16663 = cljs.core.first(seq__15924_16657__$1);
var n_16664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15937_16663,(0),null);
var meth_16665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15937_16663,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16665))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16679 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16679," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16680 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16679," = new cljs.core.IndexedSeq(",a_16680,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16664,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16608)),(((cljs.core.count(maxparams_16608) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16679,");"], 0));
} else {
var pcnt_16681 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16665));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16681,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16664,".call(this",(((pcnt_16681 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16681,maxparams_16608)),null,(1),null)),(2),null))),");");
}


var G__16682 = cljs.core.next(seq__15924_16657__$1);
var G__16683 = null;
var G__16684 = (0);
var G__16685 = (0);
seq__15924_16639 = G__16682;
chunk__15925_16640 = G__16683;
count__15926_16641 = G__16684;
i__15927_16642 = G__16685;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_16686 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_16610)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_16686,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16607,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16607,".cljs$lang$applyTo = ",cljs.core.some((function (p1__15892_SHARP_){
var vec__15940 = p1__15892_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15940,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15940,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_16610),".cljs$lang$applyTo;");
} else {
}

var seq__15943_16687 = cljs.core.seq(ms_16610);
var chunk__15944_16688 = null;
var count__15945_16689 = (0);
var i__15946_16690 = (0);
while(true){
if((i__15946_16690 < count__15945_16689)){
var vec__15955_16691 = chunk__15944_16688.cljs$core$IIndexed$_nth$arity$2(null,i__15946_16690);
var n_16692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15955_16691,(0),null);
var meth_16693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15955_16691,(1),null);
var c_16694 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16693));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16693))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16607,".cljs$core$IFn$_invoke$arity$variadic = ",n_16692,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16607,".cljs$core$IFn$_invoke$arity$",c_16694," = ",n_16692,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16695 = seq__15943_16687;
var G__16696 = chunk__15944_16688;
var G__16697 = count__15945_16689;
var G__16698 = (i__15946_16690 + (1));
seq__15943_16687 = G__16695;
chunk__15944_16688 = G__16696;
count__15945_16689 = G__16697;
i__15946_16690 = G__16698;
continue;
} else {
var temp__5735__auto___16699 = cljs.core.seq(seq__15943_16687);
if(temp__5735__auto___16699){
var seq__15943_16700__$1 = temp__5735__auto___16699;
if(cljs.core.chunked_seq_QMARK_(seq__15943_16700__$1)){
var c__4609__auto___16701 = cljs.core.chunk_first(seq__15943_16700__$1);
var G__16702 = cljs.core.chunk_rest(seq__15943_16700__$1);
var G__16703 = c__4609__auto___16701;
var G__16704 = cljs.core.count(c__4609__auto___16701);
var G__16705 = (0);
seq__15943_16687 = G__16702;
chunk__15944_16688 = G__16703;
count__15945_16689 = G__16704;
i__15946_16690 = G__16705;
continue;
} else {
var vec__15958_16706 = cljs.core.first(seq__15943_16700__$1);
var n_16707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15958_16706,(0),null);
var meth_16708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15958_16706,(1),null);
var c_16709 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16708));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16708))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16607,".cljs$core$IFn$_invoke$arity$variadic = ",n_16707,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16607,".cljs$core$IFn$_invoke$arity$",c_16709," = ",n_16707,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16710 = cljs.core.next(seq__15943_16700__$1);
var G__16711 = null;
var G__16712 = (0);
var G__16713 = (0);
seq__15943_16687 = G__16710;
chunk__15944_16688 = G__16711;
count__15945_16689 = G__16712;
i__15946_16690 = G__16713;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16607,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__15961){
var map__15962 = p__15961;
var map__15962__$1 = (((((!((map__15962 == null))))?(((((map__15962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15962.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15962):map__15962);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15962__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15962__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15962__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15964_16715 = cljs.core.seq(statements);
var chunk__15965_16716 = null;
var count__15966_16717 = (0);
var i__15967_16718 = (0);
while(true){
if((i__15967_16718 < count__15966_16717)){
var s_16719 = chunk__15965_16716.cljs$core$IIndexed$_nth$arity$2(null,i__15967_16718);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16719);


var G__16721 = seq__15964_16715;
var G__16722 = chunk__15965_16716;
var G__16723 = count__15966_16717;
var G__16724 = (i__15967_16718 + (1));
seq__15964_16715 = G__16721;
chunk__15965_16716 = G__16722;
count__15966_16717 = G__16723;
i__15967_16718 = G__16724;
continue;
} else {
var temp__5735__auto___16725 = cljs.core.seq(seq__15964_16715);
if(temp__5735__auto___16725){
var seq__15964_16726__$1 = temp__5735__auto___16725;
if(cljs.core.chunked_seq_QMARK_(seq__15964_16726__$1)){
var c__4609__auto___16727 = cljs.core.chunk_first(seq__15964_16726__$1);
var G__16728 = cljs.core.chunk_rest(seq__15964_16726__$1);
var G__16729 = c__4609__auto___16727;
var G__16730 = cljs.core.count(c__4609__auto___16727);
var G__16731 = (0);
seq__15964_16715 = G__16728;
chunk__15965_16716 = G__16729;
count__15966_16717 = G__16730;
i__15967_16718 = G__16731;
continue;
} else {
var s_16732 = cljs.core.first(seq__15964_16726__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16732);


var G__16733 = cljs.core.next(seq__15964_16726__$1);
var G__16734 = null;
var G__16735 = (0);
var G__16736 = (0);
seq__15964_16715 = G__16733;
chunk__15965_16716 = G__16734;
count__15966_16717 = G__16735;
i__15967_16718 = G__16736;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__15968){
var map__15969 = p__15968;
var map__15969__$1 = (((((!((map__15969 == null))))?(((((map__15969.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15969.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15969):map__15969);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15969__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15969__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15969__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15969__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15969__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__15971,is_loop){
var map__15972 = p__15971;
var map__15972__$1 = (((((!((map__15972 == null))))?(((((map__15972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15972.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15972):map__15972);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15972__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15972__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15972__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__15974_16737 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__15975_16738 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__15975_16738);

try{var seq__15976_16739 = cljs.core.seq(bindings);
var chunk__15977_16740 = null;
var count__15978_16741 = (0);
var i__15979_16742 = (0);
while(true){
if((i__15979_16742 < count__15978_16741)){
var map__15986_16743 = chunk__15977_16740.cljs$core$IIndexed$_nth$arity$2(null,i__15979_16742);
var map__15986_16744__$1 = (((((!((map__15986_16743 == null))))?(((((map__15986_16743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15986_16743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15986_16743):map__15986_16743);
var binding_16745 = map__15986_16744__$1;
var init_16746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15986_16744__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16745);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16746,";");


var G__16747 = seq__15976_16739;
var G__16748 = chunk__15977_16740;
var G__16749 = count__15978_16741;
var G__16750 = (i__15979_16742 + (1));
seq__15976_16739 = G__16747;
chunk__15977_16740 = G__16748;
count__15978_16741 = G__16749;
i__15979_16742 = G__16750;
continue;
} else {
var temp__5735__auto___16751 = cljs.core.seq(seq__15976_16739);
if(temp__5735__auto___16751){
var seq__15976_16752__$1 = temp__5735__auto___16751;
if(cljs.core.chunked_seq_QMARK_(seq__15976_16752__$1)){
var c__4609__auto___16753 = cljs.core.chunk_first(seq__15976_16752__$1);
var G__16754 = cljs.core.chunk_rest(seq__15976_16752__$1);
var G__16755 = c__4609__auto___16753;
var G__16756 = cljs.core.count(c__4609__auto___16753);
var G__16757 = (0);
seq__15976_16739 = G__16754;
chunk__15977_16740 = G__16755;
count__15978_16741 = G__16756;
i__15979_16742 = G__16757;
continue;
} else {
var map__15988_16759 = cljs.core.first(seq__15976_16752__$1);
var map__15988_16760__$1 = (((((!((map__15988_16759 == null))))?(((((map__15988_16759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15988_16759.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15988_16759):map__15988_16759);
var binding_16761 = map__15988_16760__$1;
var init_16762 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15988_16760__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16761);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16762,";");


var G__16767 = cljs.core.next(seq__15976_16752__$1);
var G__16768 = null;
var G__16769 = (0);
var G__16770 = (0);
seq__15976_16739 = G__16767;
chunk__15977_16740 = G__16768;
count__15978_16741 = G__16769;
i__15979_16742 = G__16770;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__15974_16737);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__15990){
var map__15991 = p__15990;
var map__15991__$1 = (((((!((map__15991 == null))))?(((((map__15991.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15991.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15991):map__15991);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15991__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15991__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15991__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___16771 = cljs.core.count(exprs);
var i_16772 = (0);
while(true){
if((i_16772 < n__4666__auto___16771)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16772) : temps.call(null,i_16772))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_16772) : exprs.call(null,i_16772)),";");

var G__16773 = (i_16772 + (1));
i_16772 = G__16773;
continue;
} else {
}
break;
}

var n__4666__auto___16774 = cljs.core.count(exprs);
var i_16775 = (0);
while(true){
if((i_16775 < n__4666__auto___16774)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_16775) : params.call(null,i_16775)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16775) : temps.call(null,i_16775)),";");

var G__16780 = (i_16775 + (1));
i_16775 = G__16780;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__15993){
var map__15994 = p__15993;
var map__15994__$1 = (((((!((map__15994 == null))))?(((((map__15994.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15994.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15994):map__15994);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15994__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15994__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15994__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15996_16781 = cljs.core.seq(bindings);
var chunk__15997_16782 = null;
var count__15998_16783 = (0);
var i__15999_16784 = (0);
while(true){
if((i__15999_16784 < count__15998_16783)){
var map__16004_16785 = chunk__15997_16782.cljs$core$IIndexed$_nth$arity$2(null,i__15999_16784);
var map__16004_16786__$1 = (((((!((map__16004_16785 == null))))?(((((map__16004_16785.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16004_16785.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16004_16785):map__16004_16785);
var binding_16787 = map__16004_16786__$1;
var init_16788 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16004_16786__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16787)," = ",init_16788,";");


var G__16789 = seq__15996_16781;
var G__16790 = chunk__15997_16782;
var G__16791 = count__15998_16783;
var G__16792 = (i__15999_16784 + (1));
seq__15996_16781 = G__16789;
chunk__15997_16782 = G__16790;
count__15998_16783 = G__16791;
i__15999_16784 = G__16792;
continue;
} else {
var temp__5735__auto___16793 = cljs.core.seq(seq__15996_16781);
if(temp__5735__auto___16793){
var seq__15996_16794__$1 = temp__5735__auto___16793;
if(cljs.core.chunked_seq_QMARK_(seq__15996_16794__$1)){
var c__4609__auto___16795 = cljs.core.chunk_first(seq__15996_16794__$1);
var G__16796 = cljs.core.chunk_rest(seq__15996_16794__$1);
var G__16797 = c__4609__auto___16795;
var G__16798 = cljs.core.count(c__4609__auto___16795);
var G__16799 = (0);
seq__15996_16781 = G__16796;
chunk__15997_16782 = G__16797;
count__15998_16783 = G__16798;
i__15999_16784 = G__16799;
continue;
} else {
var map__16006_16800 = cljs.core.first(seq__15996_16794__$1);
var map__16006_16801__$1 = (((((!((map__16006_16800 == null))))?(((((map__16006_16800.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16006_16800.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16006_16800):map__16006_16800);
var binding_16802 = map__16006_16801__$1;
var init_16803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16006_16801__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16802)," = ",init_16803,";");


var G__16804 = cljs.core.next(seq__15996_16794__$1);
var G__16805 = null;
var G__16806 = (0);
var G__16807 = (0);
seq__15996_16781 = G__16804;
chunk__15997_16782 = G__16805;
count__15998_16783 = G__16806;
i__15999_16784 = G__16807;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__16013){
var map__16014 = p__16013;
var map__16014__$1 = (((((!((map__16014 == null))))?(((((map__16014.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16014.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16014):map__16014);
var expr = map__16014__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16014__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16014__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16014__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__16037 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__16037.cljs$core$IFn$_invoke$arity$1 ? fexpr__16037.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__16037.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__16040 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__16040.cljs$core$IFn$_invoke$arity$1 ? fexpr__16040.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__16040.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__16021 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__16008_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__16008_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__16009_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__16009_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16021,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16021,(1),null);
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_16829 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_16829,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_16830 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_16830,args)),(((mfa_16830 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_16830,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__16049 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__16048 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__16048.cljs$core$IFn$_invoke$arity$1 ? fexpr__16048.cljs$core$IFn$_invoke$arity$1(G__16049) : fexpr__16048.call(null,G__16049));
} else {
return and__4174__auto__;
}
})())){
var fprop_16843 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16843," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16843,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16843," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16843,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__16050){
var map__16051 = p__16050;
var map__16051__$1 = (((((!((map__16051 == null))))?(((((map__16051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16051):map__16051);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16051__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16051__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16051__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__16053){
var map__16054 = p__16053;
var map__16054__$1 = (((((!((map__16054 == null))))?(((((map__16054.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16054.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16054):map__16054);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16054__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16054__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16054__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__16056 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__16056__$1 = (((((!((map__16056 == null))))?(((((map__16056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16056.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16056):map__16056);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16056__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16056__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__16057 = options;
var map__16057__$1 = (((((!((map__16057 == null))))?(((((map__16057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16057.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16057):map__16057);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16057__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16057__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__16058 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__16064 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__16064__$1 = (((((!((map__16064 == null))))?(((((map__16064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16064.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16064):map__16064);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16064__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16064__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16058,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16058,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__16067_16874 = cljs.core.seq(libs_to_load);
var chunk__16068_16875 = null;
var count__16069_16876 = (0);
var i__16070_16877 = (0);
while(true){
if((i__16070_16877 < count__16069_16876)){
var lib_16878 = chunk__16068_16875.cljs$core$IIndexed$_nth$arity$2(null,i__16070_16877);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16878)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16878),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16878),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16878),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16878),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16878,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16878),"');");
}

}
}
}


var G__16879 = seq__16067_16874;
var G__16880 = chunk__16068_16875;
var G__16881 = count__16069_16876;
var G__16882 = (i__16070_16877 + (1));
seq__16067_16874 = G__16879;
chunk__16068_16875 = G__16880;
count__16069_16876 = G__16881;
i__16070_16877 = G__16882;
continue;
} else {
var temp__5735__auto___16883 = cljs.core.seq(seq__16067_16874);
if(temp__5735__auto___16883){
var seq__16067_16884__$1 = temp__5735__auto___16883;
if(cljs.core.chunked_seq_QMARK_(seq__16067_16884__$1)){
var c__4609__auto___16885 = cljs.core.chunk_first(seq__16067_16884__$1);
var G__16886 = cljs.core.chunk_rest(seq__16067_16884__$1);
var G__16887 = c__4609__auto___16885;
var G__16888 = cljs.core.count(c__4609__auto___16885);
var G__16889 = (0);
seq__16067_16874 = G__16886;
chunk__16068_16875 = G__16887;
count__16069_16876 = G__16888;
i__16070_16877 = G__16889;
continue;
} else {
var lib_16890 = cljs.core.first(seq__16067_16884__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16890)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16890),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16890),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16890),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16890),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16890,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16890),"');");
}

}
}
}


var G__16891 = cljs.core.next(seq__16067_16884__$1);
var G__16892 = null;
var G__16893 = (0);
var G__16894 = (0);
seq__16067_16874 = G__16891;
chunk__16068_16875 = G__16892;
count__16069_16876 = G__16893;
i__16070_16877 = G__16894;
continue;
}
} else {
}
}
break;
}

var seq__16071_16895 = cljs.core.seq(node_libs);
var chunk__16072_16896 = null;
var count__16073_16897 = (0);
var i__16074_16898 = (0);
while(true){
if((i__16074_16898 < count__16073_16897)){
var lib_16899 = chunk__16072_16896.cljs$core$IIndexed$_nth$arity$2(null,i__16074_16898);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16899)," = require('",lib_16899,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16900 = seq__16071_16895;
var G__16901 = chunk__16072_16896;
var G__16902 = count__16073_16897;
var G__16903 = (i__16074_16898 + (1));
seq__16071_16895 = G__16900;
chunk__16072_16896 = G__16901;
count__16073_16897 = G__16902;
i__16074_16898 = G__16903;
continue;
} else {
var temp__5735__auto___16911 = cljs.core.seq(seq__16071_16895);
if(temp__5735__auto___16911){
var seq__16071_16912__$1 = temp__5735__auto___16911;
if(cljs.core.chunked_seq_QMARK_(seq__16071_16912__$1)){
var c__4609__auto___16913 = cljs.core.chunk_first(seq__16071_16912__$1);
var G__16914 = cljs.core.chunk_rest(seq__16071_16912__$1);
var G__16915 = c__4609__auto___16913;
var G__16916 = cljs.core.count(c__4609__auto___16913);
var G__16917 = (0);
seq__16071_16895 = G__16914;
chunk__16072_16896 = G__16915;
count__16073_16897 = G__16916;
i__16074_16898 = G__16917;
continue;
} else {
var lib_16918 = cljs.core.first(seq__16071_16912__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16918)," = require('",lib_16918,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16919 = cljs.core.next(seq__16071_16912__$1);
var G__16920 = null;
var G__16921 = (0);
var G__16922 = (0);
seq__16071_16895 = G__16919;
chunk__16072_16896 = G__16920;
count__16073_16897 = G__16921;
i__16074_16898 = G__16922;
continue;
}
} else {
}
}
break;
}

var seq__16075_16923 = cljs.core.seq(global_exports_libs);
var chunk__16076_16924 = null;
var count__16077_16925 = (0);
var i__16078_16926 = (0);
while(true){
if((i__16078_16926 < count__16077_16925)){
var lib_16927 = chunk__16076_16924.cljs$core$IIndexed$_nth$arity$2(null,i__16078_16926);
var map__16083_16928 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16927));
var map__16083_16929__$1 = (((((!((map__16083_16928 == null))))?(((((map__16083_16928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16083_16928.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16083_16928):map__16083_16928);
var global_exports_16930 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16083_16929__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16930,lib_16927);


var G__16931 = seq__16075_16923;
var G__16932 = chunk__16076_16924;
var G__16933 = count__16077_16925;
var G__16934 = (i__16078_16926 + (1));
seq__16075_16923 = G__16931;
chunk__16076_16924 = G__16932;
count__16077_16925 = G__16933;
i__16078_16926 = G__16934;
continue;
} else {
var temp__5735__auto___16935 = cljs.core.seq(seq__16075_16923);
if(temp__5735__auto___16935){
var seq__16075_16936__$1 = temp__5735__auto___16935;
if(cljs.core.chunked_seq_QMARK_(seq__16075_16936__$1)){
var c__4609__auto___16937 = cljs.core.chunk_first(seq__16075_16936__$1);
var G__16938 = cljs.core.chunk_rest(seq__16075_16936__$1);
var G__16939 = c__4609__auto___16937;
var G__16940 = cljs.core.count(c__4609__auto___16937);
var G__16941 = (0);
seq__16075_16923 = G__16938;
chunk__16076_16924 = G__16939;
count__16077_16925 = G__16940;
i__16078_16926 = G__16941;
continue;
} else {
var lib_16942 = cljs.core.first(seq__16075_16936__$1);
var map__16085_16943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16942));
var map__16085_16944__$1 = (((((!((map__16085_16943 == null))))?(((((map__16085_16943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16085_16943.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16085_16943):map__16085_16943);
var global_exports_16945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16085_16944__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16945,lib_16942);


var G__16946 = cljs.core.next(seq__16075_16936__$1);
var G__16947 = null;
var G__16948 = (0);
var G__16949 = (0);
seq__16075_16923 = G__16946;
chunk__16076_16924 = G__16947;
count__16077_16925 = G__16948;
i__16078_16926 = G__16949;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__16087){
var map__16088 = p__16087;
var map__16088__$1 = (((((!((map__16088 == null))))?(((((map__16088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16088.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16088):map__16088);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16088__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16088__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16088__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16088__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16088__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16088__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16088__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__16090){
var map__16091 = p__16090;
var map__16091__$1 = (((((!((map__16091 == null))))?(((((map__16091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16091.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16091):map__16091);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16091__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__16098){
var map__16099 = p__16098;
var map__16099__$1 = (((((!((map__16099 == null))))?(((((map__16099.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16099.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16099):map__16099);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16099__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__16101_16960 = cljs.core.seq(protocols);
var chunk__16102_16961 = null;
var count__16103_16962 = (0);
var i__16104_16963 = (0);
while(true){
if((i__16104_16963 < count__16103_16962)){
var protocol_16964 = chunk__16102_16961.cljs$core$IIndexed$_nth$arity$2(null,i__16104_16963);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16964)),"}");


var G__16965 = seq__16101_16960;
var G__16966 = chunk__16102_16961;
var G__16967 = count__16103_16962;
var G__16968 = (i__16104_16963 + (1));
seq__16101_16960 = G__16965;
chunk__16102_16961 = G__16966;
count__16103_16962 = G__16967;
i__16104_16963 = G__16968;
continue;
} else {
var temp__5735__auto___16969 = cljs.core.seq(seq__16101_16960);
if(temp__5735__auto___16969){
var seq__16101_16970__$1 = temp__5735__auto___16969;
if(cljs.core.chunked_seq_QMARK_(seq__16101_16970__$1)){
var c__4609__auto___16971 = cljs.core.chunk_first(seq__16101_16970__$1);
var G__16972 = cljs.core.chunk_rest(seq__16101_16970__$1);
var G__16973 = c__4609__auto___16971;
var G__16974 = cljs.core.count(c__4609__auto___16971);
var G__16975 = (0);
seq__16101_16960 = G__16972;
chunk__16102_16961 = G__16973;
count__16103_16962 = G__16974;
i__16104_16963 = G__16975;
continue;
} else {
var protocol_16976 = cljs.core.first(seq__16101_16970__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16976)),"}");


var G__16977 = cljs.core.next(seq__16101_16970__$1);
var G__16978 = null;
var G__16979 = (0);
var G__16980 = (0);
seq__16101_16960 = G__16977;
chunk__16102_16961 = G__16978;
count__16103_16962 = G__16979;
i__16104_16963 = G__16980;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__16105_16983 = cljs.core.seq(fields__$1);
var chunk__16106_16984 = null;
var count__16107_16985 = (0);
var i__16108_16986 = (0);
while(true){
if((i__16108_16986 < count__16107_16985)){
var fld_16987 = chunk__16106_16984.cljs$core$IIndexed$_nth$arity$2(null,i__16108_16986);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16987," = ",fld_16987,";");


var G__16988 = seq__16105_16983;
var G__16989 = chunk__16106_16984;
var G__16990 = count__16107_16985;
var G__16991 = (i__16108_16986 + (1));
seq__16105_16983 = G__16988;
chunk__16106_16984 = G__16989;
count__16107_16985 = G__16990;
i__16108_16986 = G__16991;
continue;
} else {
var temp__5735__auto___16992 = cljs.core.seq(seq__16105_16983);
if(temp__5735__auto___16992){
var seq__16105_16993__$1 = temp__5735__auto___16992;
if(cljs.core.chunked_seq_QMARK_(seq__16105_16993__$1)){
var c__4609__auto___16994 = cljs.core.chunk_first(seq__16105_16993__$1);
var G__16995 = cljs.core.chunk_rest(seq__16105_16993__$1);
var G__16996 = c__4609__auto___16994;
var G__16997 = cljs.core.count(c__4609__auto___16994);
var G__16998 = (0);
seq__16105_16983 = G__16995;
chunk__16106_16984 = G__16996;
count__16107_16985 = G__16997;
i__16108_16986 = G__16998;
continue;
} else {
var fld_16999 = cljs.core.first(seq__16105_16993__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16999," = ",fld_16999,";");


var G__17000 = cljs.core.next(seq__16105_16993__$1);
var G__17001 = null;
var G__17002 = (0);
var G__17003 = (0);
seq__16105_16983 = G__17000;
chunk__16106_16984 = G__17001;
count__16107_16985 = G__17002;
i__16108_16986 = G__17003;
continue;
}
} else {
}
}
break;
}

var seq__16109_17011 = cljs.core.seq(pmasks);
var chunk__16110_17012 = null;
var count__16111_17013 = (0);
var i__16112_17014 = (0);
while(true){
if((i__16112_17014 < count__16111_17013)){
var vec__16119_17015 = chunk__16110_17012.cljs$core$IIndexed$_nth$arity$2(null,i__16112_17014);
var pno_17016 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16119_17015,(0),null);
var pmask_17017 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16119_17015,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17016,"$ = ",pmask_17017,";");


var G__17018 = seq__16109_17011;
var G__17019 = chunk__16110_17012;
var G__17020 = count__16111_17013;
var G__17021 = (i__16112_17014 + (1));
seq__16109_17011 = G__17018;
chunk__16110_17012 = G__17019;
count__16111_17013 = G__17020;
i__16112_17014 = G__17021;
continue;
} else {
var temp__5735__auto___17022 = cljs.core.seq(seq__16109_17011);
if(temp__5735__auto___17022){
var seq__16109_17023__$1 = temp__5735__auto___17022;
if(cljs.core.chunked_seq_QMARK_(seq__16109_17023__$1)){
var c__4609__auto___17029 = cljs.core.chunk_first(seq__16109_17023__$1);
var G__17030 = cljs.core.chunk_rest(seq__16109_17023__$1);
var G__17031 = c__4609__auto___17029;
var G__17032 = cljs.core.count(c__4609__auto___17029);
var G__17033 = (0);
seq__16109_17011 = G__17030;
chunk__16110_17012 = G__17031;
count__16111_17013 = G__17032;
i__16112_17014 = G__17033;
continue;
} else {
var vec__16122_17034 = cljs.core.first(seq__16109_17023__$1);
var pno_17035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16122_17034,(0),null);
var pmask_17036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16122_17034,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17035,"$ = ",pmask_17036,";");


var G__17037 = cljs.core.next(seq__16109_17023__$1);
var G__17038 = null;
var G__17039 = (0);
var G__17040 = (0);
seq__16109_17011 = G__17037;
chunk__16110_17012 = G__17038;
count__16111_17013 = G__17039;
i__16112_17014 = G__17040;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__16125){
var map__16126 = p__16125;
var map__16126__$1 = (((((!((map__16126 == null))))?(((((map__16126.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16126.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16126):map__16126);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16126__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16126__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16126__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16126__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16126__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__16128_17045 = cljs.core.seq(protocols);
var chunk__16129_17046 = null;
var count__16130_17047 = (0);
var i__16131_17048 = (0);
while(true){
if((i__16131_17048 < count__16130_17047)){
var protocol_17049 = chunk__16129_17046.cljs$core$IIndexed$_nth$arity$2(null,i__16131_17048);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17049)),"}");


var G__17050 = seq__16128_17045;
var G__17051 = chunk__16129_17046;
var G__17052 = count__16130_17047;
var G__17053 = (i__16131_17048 + (1));
seq__16128_17045 = G__17050;
chunk__16129_17046 = G__17051;
count__16130_17047 = G__17052;
i__16131_17048 = G__17053;
continue;
} else {
var temp__5735__auto___17054 = cljs.core.seq(seq__16128_17045);
if(temp__5735__auto___17054){
var seq__16128_17055__$1 = temp__5735__auto___17054;
if(cljs.core.chunked_seq_QMARK_(seq__16128_17055__$1)){
var c__4609__auto___17056 = cljs.core.chunk_first(seq__16128_17055__$1);
var G__17057 = cljs.core.chunk_rest(seq__16128_17055__$1);
var G__17058 = c__4609__auto___17056;
var G__17059 = cljs.core.count(c__4609__auto___17056);
var G__17060 = (0);
seq__16128_17045 = G__17057;
chunk__16129_17046 = G__17058;
count__16130_17047 = G__17059;
i__16131_17048 = G__17060;
continue;
} else {
var protocol_17061 = cljs.core.first(seq__16128_17055__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_17061)),"}");


var G__17062 = cljs.core.next(seq__16128_17055__$1);
var G__17063 = null;
var G__17064 = (0);
var G__17065 = (0);
seq__16128_17045 = G__17062;
chunk__16129_17046 = G__17063;
count__16130_17047 = G__17064;
i__16131_17048 = G__17065;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__16142_17066 = cljs.core.seq(fields__$1);
var chunk__16143_17067 = null;
var count__16144_17068 = (0);
var i__16145_17069 = (0);
while(true){
if((i__16145_17069 < count__16144_17068)){
var fld_17070 = chunk__16143_17067.cljs$core$IIndexed$_nth$arity$2(null,i__16145_17069);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17070," = ",fld_17070,";");


var G__17071 = seq__16142_17066;
var G__17072 = chunk__16143_17067;
var G__17073 = count__16144_17068;
var G__17074 = (i__16145_17069 + (1));
seq__16142_17066 = G__17071;
chunk__16143_17067 = G__17072;
count__16144_17068 = G__17073;
i__16145_17069 = G__17074;
continue;
} else {
var temp__5735__auto___17075 = cljs.core.seq(seq__16142_17066);
if(temp__5735__auto___17075){
var seq__16142_17076__$1 = temp__5735__auto___17075;
if(cljs.core.chunked_seq_QMARK_(seq__16142_17076__$1)){
var c__4609__auto___17078 = cljs.core.chunk_first(seq__16142_17076__$1);
var G__17082 = cljs.core.chunk_rest(seq__16142_17076__$1);
var G__17083 = c__4609__auto___17078;
var G__17084 = cljs.core.count(c__4609__auto___17078);
var G__17085 = (0);
seq__16142_17066 = G__17082;
chunk__16143_17067 = G__17083;
count__16144_17068 = G__17084;
i__16145_17069 = G__17085;
continue;
} else {
var fld_17086 = cljs.core.first(seq__16142_17076__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_17086," = ",fld_17086,";");


var G__17087 = cljs.core.next(seq__16142_17076__$1);
var G__17088 = null;
var G__17089 = (0);
var G__17090 = (0);
seq__16142_17066 = G__17087;
chunk__16143_17067 = G__17088;
count__16144_17068 = G__17089;
i__16145_17069 = G__17090;
continue;
}
} else {
}
}
break;
}

var seq__16146_17091 = cljs.core.seq(pmasks);
var chunk__16147_17092 = null;
var count__16148_17093 = (0);
var i__16149_17094 = (0);
while(true){
if((i__16149_17094 < count__16148_17093)){
var vec__16157_17095 = chunk__16147_17092.cljs$core$IIndexed$_nth$arity$2(null,i__16149_17094);
var pno_17096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16157_17095,(0),null);
var pmask_17097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16157_17095,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17096,"$ = ",pmask_17097,";");


var G__17105 = seq__16146_17091;
var G__17106 = chunk__16147_17092;
var G__17107 = count__16148_17093;
var G__17108 = (i__16149_17094 + (1));
seq__16146_17091 = G__17105;
chunk__16147_17092 = G__17106;
count__16148_17093 = G__17107;
i__16149_17094 = G__17108;
continue;
} else {
var temp__5735__auto___17109 = cljs.core.seq(seq__16146_17091);
if(temp__5735__auto___17109){
var seq__16146_17110__$1 = temp__5735__auto___17109;
if(cljs.core.chunked_seq_QMARK_(seq__16146_17110__$1)){
var c__4609__auto___17111 = cljs.core.chunk_first(seq__16146_17110__$1);
var G__17112 = cljs.core.chunk_rest(seq__16146_17110__$1);
var G__17113 = c__4609__auto___17111;
var G__17114 = cljs.core.count(c__4609__auto___17111);
var G__17115 = (0);
seq__16146_17091 = G__17112;
chunk__16147_17092 = G__17113;
count__16148_17093 = G__17114;
i__16149_17094 = G__17115;
continue;
} else {
var vec__16160_17116 = cljs.core.first(seq__16146_17110__$1);
var pno_17117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16160_17116,(0),null);
var pmask_17118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16160_17116,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_17117,"$ = ",pmask_17118,";");


var G__17119 = cljs.core.next(seq__16146_17110__$1);
var G__17120 = null;
var G__17121 = (0);
var G__17122 = (0);
seq__16146_17091 = G__17119;
chunk__16147_17092 = G__17120;
count__16148_17093 = G__17121;
i__16149_17094 = G__17122;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__16163){
var map__16164 = p__16163;
var map__16164__$1 = (((((!((map__16164 == null))))?(((((map__16164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16164.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16164):map__16164);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16164__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16164__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16164__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16164__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16164__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__16167){
var map__16168 = p__16167;
var map__16168__$1 = (((((!((map__16168 == null))))?(((((map__16168.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16168.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16168):map__16168);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16168__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16168__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16168__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16168__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16168__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__16170 = clojure.string.trim(code);
var G__16171 = "/*";
return goog.string.startsWith(G__16170,G__16171);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__15345__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15345__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__16177 = cljs.core.seq(table);
var chunk__16178 = null;
var count__16179 = (0);
var i__16180 = (0);
while(true){
if((i__16180 < count__16179)){
var vec__16187 = chunk__16178.cljs$core$IIndexed$_nth$arity$2(null,i__16180);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16187,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16187,(1),null);
var ns_17129 = cljs.core.namespace(sym);
var name_17130 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__17131 = seq__16177;
var G__17132 = chunk__16178;
var G__17133 = count__16179;
var G__17134 = (i__16180 + (1));
seq__16177 = G__17131;
chunk__16178 = G__17132;
count__16179 = G__17133;
i__16180 = G__17134;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16177);
if(temp__5735__auto__){
var seq__16177__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16177__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16177__$1);
var G__17135 = cljs.core.chunk_rest(seq__16177__$1);
var G__17136 = c__4609__auto__;
var G__17137 = cljs.core.count(c__4609__auto__);
var G__17138 = (0);
seq__16177 = G__17135;
chunk__16178 = G__17136;
count__16179 = G__17137;
i__16180 = G__17138;
continue;
} else {
var vec__16190 = cljs.core.first(seq__16177__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16190,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16190,(1),null);
var ns_17139 = cljs.core.namespace(sym);
var name_17140 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__17141 = cljs.core.next(seq__16177__$1);
var G__17142 = null;
var G__17143 = (0);
var G__17144 = (0);
seq__16177 = G__17141;
chunk__16178 = G__17142;
count__16179 = G__17143;
i__16180 = G__17144;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__16194 = arguments.length;
switch (G__16194) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_17168 = cljs.core.first(ks);
var vec__16195_17169 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_17168);
var top_17170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16195_17169,(0),null);
var prefix_SINGLEQUOTE__17171 = vec__16195_17169;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_17168)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__17171) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_17170)) || (cljs.core.contains_QMARK_(known_externs,top_17170)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__17171)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_17170);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__17171)),";");
}
} else {
}

var m_17172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_17168);
if(cljs.core.empty_QMARK_(m_17172)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__17171,m_17172,top_level,known_externs);
}

var G__17173 = cljs.core.next(ks);
ks = G__17173;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

