(defproject org.pinkgorilla/notebook-bundel "0.5.1"
  :description "notebook - bundel"
  :url "https://github.com/pink-gorilla/notebook-bundel"
  :license {:name "MIT"}
  :deploy-repositories [["releases" {:url "https://clojars.org/repo"
                                     :username :env/release_username
                                     :password :env/release_password
                                     :sign-releases false}]]

  :release-tasks [["vcs" "assert-committed"]
                  ["bump-version" "release"]
                  ["vcs" "commit" "Release %s"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy"]
                  ["bump-version"]
                  ["vcs" "commit" "Begin %s"]
                  ["vcs" "push"]]

  :source-paths ["src"] ; "test"
  :target-path  "target/jar"
  :resource-paths  ["resources"
                    "target/webly"] ; bundle (will be added to the jar)
  :main ;^:skip-aot 
  pinkgorilla.notebook-ui.app-bundel.app
  ; :aot [pinkgorilla.notebook.app]
  ;; :jar-exclusions   [#"(?:^|\/)foo\/" #"(?:^|\/)demo\/" #"(?:^|\/)compiled.*\/" #"html$"]

  :dependencies [[org.pinkgorilla/notebook "0.5.1"]
                 ; bundled dependencies
                 [org.pinkgorilla/goldly "0.2.31"]
                 [org.pinkgorilla/gorilla-ui "0.3.18" ; brings pinkie
                  :exclusions [org.clojure/clojurescript]]
                 [org.pinkgorilla/gorilla-plot "1.2.6"]]

  :profiles {:dev  {:dependencies [[clj-kondo "2021.03.31"]]
                    :plugins      [[lein-cljfmt "0.6.6"]
                                   [lein-ancient "0.6.15"]
                                   [lein-resource "17.06.1"]
                                   [lein-shell "0.5.0"]]
                    :aliases      {"clj-kondo"
                                   ["run" "-m" "clj-kondo.main"]
                                   "bump-version" ^{:doc "Increases project.clj version number (used by CI)."}
                                   ["change" "version" "leiningen.release/bump-version"]}
                   ;; TODO : Make cljfmt really nice : https://devhub.io/repos/bbatsov-cljfmt
                    :cljfmt       {:indents {as->                [[:inner 0]]
                                             with-debug-bindings [[:inner 0]]
                                             merge-meta          [[:inner 0]]
                                             try-if-let          [[:block 1]]}}}}

  :aliases {"notebook-build"
            ["run" "-m"
             "pinkgorilla.notebook-ui.app-bundel.app"
             "release"]

            "notebook"
            ["run" "-m"
             "pinkgorilla.notebook-ui.app-bundel.app"]})
