goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__67554 = e.target.readyState;
var fexpr__67553 = new cljs.core.PersistentArrayMap(null, 5, [(0),new cljs.core.Keyword(null,"not-initialized","not-initialized",-1937378906),(1),new cljs.core.Keyword(null,"connection-established","connection-established",-1403749733),(2),new cljs.core.Keyword(null,"request-received","request-received",2110590540),(3),new cljs.core.Keyword(null,"processing-request","processing-request",-264947221),(4),new cljs.core.Keyword(null,"response-ready","response-ready",245208276)], null);
return (fexpr__67553.cljs$core$IFn$_invoke$arity$1 ? fexpr__67553.cljs$core$IFn$_invoke$arity$1(G__67554) : fexpr__67553.call(null,G__67554));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():XMLHttpRequest);
(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__67556,handler){
var map__67557 = p__67556;
var map__67557__$1 = (((((!((map__67557 == null))))?(((((map__67557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67557.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67557):map__67557);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67557__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67557__$1,new cljs.core.Keyword(null,"method","method",55703592));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67557__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67557__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__67557__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__67557__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67557__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var this$__$1 = this;
(this$__$1.withCredentials = with_credentials);

(this$__$1.onreadystatechange = (function (p1__67555_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"response-ready","response-ready",245208276),ajax.xml_http_request.ready_state(p1__67555_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
}));

this$__$1.open(method,uri,true);

(this$__$1.timeout = timeout);

var temp__5735__auto___67575 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5735__auto___67575)){
var response_type_67576 = temp__5735__auto___67575;
(this$__$1.responseType = cljs.core.name(response_type_67576));
} else {
}

var seq__67559_67577 = cljs.core.seq(headers);
var chunk__67560_67578 = null;
var count__67561_67579 = (0);
var i__67562_67580 = (0);
while(true){
if((i__67562_67580 < count__67561_67579)){
var vec__67569_67581 = chunk__67560_67578.cljs$core$IIndexed$_nth$arity$2(null,i__67562_67580);
var k_67582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67569_67581,(0),null);
var v_67583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67569_67581,(1),null);
this$__$1.setRequestHeader(k_67582,v_67583);


var G__67584 = seq__67559_67577;
var G__67585 = chunk__67560_67578;
var G__67586 = count__67561_67579;
var G__67587 = (i__67562_67580 + (1));
seq__67559_67577 = G__67584;
chunk__67560_67578 = G__67585;
count__67561_67579 = G__67586;
i__67562_67580 = G__67587;
continue;
} else {
var temp__5735__auto___67588 = cljs.core.seq(seq__67559_67577);
if(temp__5735__auto___67588){
var seq__67559_67589__$1 = temp__5735__auto___67588;
if(cljs.core.chunked_seq_QMARK_(seq__67559_67589__$1)){
var c__4550__auto___67590 = cljs.core.chunk_first(seq__67559_67589__$1);
var G__67593 = cljs.core.chunk_rest(seq__67559_67589__$1);
var G__67594 = c__4550__auto___67590;
var G__67595 = cljs.core.count(c__4550__auto___67590);
var G__67596 = (0);
seq__67559_67577 = G__67593;
chunk__67560_67578 = G__67594;
count__67561_67579 = G__67595;
i__67562_67580 = G__67596;
continue;
} else {
var vec__67572_67597 = cljs.core.first(seq__67559_67589__$1);
var k_67598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67572_67597,(0),null);
var v_67599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67572_67597,(1),null);
this$__$1.setRequestHeader(k_67598,v_67599);


var G__67600 = cljs.core.next(seq__67559_67589__$1);
var G__67601 = null;
var G__67602 = (0);
var G__67603 = (0);
seq__67559_67577 = G__67600;
chunk__67560_67578 = G__67601;
count__67561_67579 = G__67602;
i__67562_67580 = G__67603;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__4120__auto__ = body;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "";
}
})());

return this$__$1;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
}));

//# sourceMappingURL=ajax.xml_http_request.js.map
