goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__70428 = arguments.length;
switch (G__70428) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async70430 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async70430 = (function (f,blockable,meta70431){
this.f = f;
this.blockable = blockable;
this.meta70431 = meta70431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async70430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_70432,meta70431__$1){
var self__ = this;
var _70432__$1 = this;
return (new cljs.core.async.t_cljs$core$async70430(self__.f,self__.blockable,meta70431__$1));
}));

(cljs.core.async.t_cljs$core$async70430.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_70432){
var self__ = this;
var _70432__$1 = this;
return self__.meta70431;
}));

(cljs.core.async.t_cljs$core$async70430.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async70430.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async70430.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async70430.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async70430.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta70431","meta70431",-1291352965,null)], null);
}));

(cljs.core.async.t_cljs$core$async70430.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async70430.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async70430");

(cljs.core.async.t_cljs$core$async70430.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async70430");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async70430.
 */
cljs.core.async.__GT_t_cljs$core$async70430 = (function cljs$core$async$__GT_t_cljs$core$async70430(f__$1,blockable__$1,meta70431){
return (new cljs.core.async.t_cljs$core$async70430(f__$1,blockable__$1,meta70431));
});

}

return (new cljs.core.async.t_cljs$core$async70430(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__70441 = arguments.length;
switch (G__70441) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__70448 = arguments.length;
switch (G__70448) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__70453 = arguments.length;
switch (G__70453) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_71998 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_71998) : fn1.call(null,val_71998));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_71998) : fn1.call(null,val_71998));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__70461 = arguments.length;
switch (G__70461) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___72000 = n;
var x_72001 = (0);
while(true){
if((x_72001 < n__4607__auto___72000)){
(a[x_72001] = x_72001);

var G__72002 = (x_72001 + (1));
x_72001 = G__72002;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async70463 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async70463 = (function (flag,meta70464){
this.flag = flag;
this.meta70464 = meta70464;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async70463.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_70465,meta70464__$1){
var self__ = this;
var _70465__$1 = this;
return (new cljs.core.async.t_cljs$core$async70463(self__.flag,meta70464__$1));
}));

(cljs.core.async.t_cljs$core$async70463.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_70465){
var self__ = this;
var _70465__$1 = this;
return self__.meta70464;
}));

(cljs.core.async.t_cljs$core$async70463.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async70463.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async70463.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async70463.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async70463.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta70464","meta70464",-305555666,null)], null);
}));

(cljs.core.async.t_cljs$core$async70463.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async70463.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async70463");

(cljs.core.async.t_cljs$core$async70463.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async70463");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async70463.
 */
cljs.core.async.__GT_t_cljs$core$async70463 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async70463(flag__$1,meta70464){
return (new cljs.core.async.t_cljs$core$async70463(flag__$1,meta70464));
});

}

return (new cljs.core.async.t_cljs$core$async70463(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async70469 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async70469 = (function (flag,cb,meta70470){
this.flag = flag;
this.cb = cb;
this.meta70470 = meta70470;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async70469.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_70471,meta70470__$1){
var self__ = this;
var _70471__$1 = this;
return (new cljs.core.async.t_cljs$core$async70469(self__.flag,self__.cb,meta70470__$1));
}));

(cljs.core.async.t_cljs$core$async70469.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_70471){
var self__ = this;
var _70471__$1 = this;
return self__.meta70470;
}));

(cljs.core.async.t_cljs$core$async70469.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async70469.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async70469.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async70469.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async70469.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta70470","meta70470",-1019159193,null)], null);
}));

(cljs.core.async.t_cljs$core$async70469.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async70469.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async70469");

(cljs.core.async.t_cljs$core$async70469.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async70469");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async70469.
 */
cljs.core.async.__GT_t_cljs$core$async70469 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async70469(flag__$1,cb__$1,meta70470){
return (new cljs.core.async.t_cljs$core$async70469(flag__$1,cb__$1,meta70470));
});

}

return (new cljs.core.async.t_cljs$core$async70469(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__70476_SHARP_){
var G__70478 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__70476_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__70478) : fret.call(null,G__70478));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__70477_SHARP_){
var G__70480 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__70477_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__70480) : fret.call(null,G__70480));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4120__auto__ = wport;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return port;
}
})()], null));
} else {
var G__72011 = (i + (1));
i = G__72011;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4120__auto__ = ret;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4109__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4109__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4109__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___72016 = arguments.length;
var i__4731__auto___72017 = (0);
while(true){
if((i__4731__auto___72017 < len__4730__auto___72016)){
args__4736__auto__.push((arguments[i__4731__auto___72017]));

var G__72018 = (i__4731__auto___72017 + (1));
i__4731__auto___72017 = G__72018;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__70486){
var map__70487 = p__70486;
var map__70487__$1 = (((((!((map__70487 == null))))?(((((map__70487.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70487.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__70487):map__70487);
var opts = map__70487__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq70484){
var G__70485 = cljs.core.first(seq70484);
var seq70484__$1 = cljs.core.next(seq70484);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70485,seq70484__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__70491 = arguments.length;
switch (G__70491) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__70370__auto___72027 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_70526){
var state_val_70527 = (state_70526[(1)]);
if((state_val_70527 === (7))){
var inst_70522 = (state_70526[(2)]);
var state_70526__$1 = state_70526;
var statearr_70529_72028 = state_70526__$1;
(statearr_70529_72028[(2)] = inst_70522);

(statearr_70529_72028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (1))){
var state_70526__$1 = state_70526;
var statearr_70530_72029 = state_70526__$1;
(statearr_70530_72029[(2)] = null);

(statearr_70530_72029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (4))){
var inst_70502 = (state_70526[(7)]);
var inst_70502__$1 = (state_70526[(2)]);
var inst_70503 = (inst_70502__$1 == null);
var state_70526__$1 = (function (){var statearr_70531 = state_70526;
(statearr_70531[(7)] = inst_70502__$1);

return statearr_70531;
})();
if(cljs.core.truth_(inst_70503)){
var statearr_70532_72033 = state_70526__$1;
(statearr_70532_72033[(1)] = (5));

} else {
var statearr_70533_72034 = state_70526__$1;
(statearr_70533_72034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (13))){
var state_70526__$1 = state_70526;
var statearr_70534_72035 = state_70526__$1;
(statearr_70534_72035[(2)] = null);

(statearr_70534_72035[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (6))){
var inst_70502 = (state_70526[(7)]);
var state_70526__$1 = state_70526;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70526__$1,(11),to,inst_70502);
} else {
if((state_val_70527 === (3))){
var inst_70524 = (state_70526[(2)]);
var state_70526__$1 = state_70526;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70526__$1,inst_70524);
} else {
if((state_val_70527 === (12))){
var state_70526__$1 = state_70526;
var statearr_70535_72037 = state_70526__$1;
(statearr_70535_72037[(2)] = null);

(statearr_70535_72037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (2))){
var state_70526__$1 = state_70526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70526__$1,(4),from);
} else {
if((state_val_70527 === (11))){
var inst_70512 = (state_70526[(2)]);
var state_70526__$1 = state_70526;
if(cljs.core.truth_(inst_70512)){
var statearr_70539_72038 = state_70526__$1;
(statearr_70539_72038[(1)] = (12));

} else {
var statearr_70540_72039 = state_70526__$1;
(statearr_70540_72039[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (9))){
var state_70526__$1 = state_70526;
var statearr_70541_72041 = state_70526__$1;
(statearr_70541_72041[(2)] = null);

(statearr_70541_72041[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (5))){
var state_70526__$1 = state_70526;
if(cljs.core.truth_(close_QMARK_)){
var statearr_70542_72044 = state_70526__$1;
(statearr_70542_72044[(1)] = (8));

} else {
var statearr_70543_72045 = state_70526__$1;
(statearr_70543_72045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (14))){
var inst_70520 = (state_70526[(2)]);
var state_70526__$1 = state_70526;
var statearr_70545_72046 = state_70526__$1;
(statearr_70545_72046[(2)] = inst_70520);

(statearr_70545_72046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (10))){
var inst_70509 = (state_70526[(2)]);
var state_70526__$1 = state_70526;
var statearr_70546_72047 = state_70526__$1;
(statearr_70546_72047[(2)] = inst_70509);

(statearr_70546_72047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70527 === (8))){
var inst_70506 = cljs.core.async.close_BANG_(to);
var state_70526__$1 = state_70526;
var statearr_70547_72049 = state_70526__$1;
(statearr_70547_72049[(2)] = inst_70506);

(statearr_70547_72049[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_70548 = [null,null,null,null,null,null,null,null];
(statearr_70548[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_70548[(1)] = (1));

return statearr_70548;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_70526){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70526);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70549){var ex__70338__auto__ = e70549;
var statearr_70550_72053 = state_70526;
(statearr_70550_72053[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70526[(4)]))){
var statearr_70551_72054 = state_70526;
(statearr_70551_72054[(1)] = cljs.core.first((state_70526[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72055 = state_70526;
state_70526 = G__72055;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_70526){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_70526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_70552 = f__70371__auto__();
(statearr_70552[(6)] = c__70370__auto___72027);

return statearr_70552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__70555){
var vec__70556 = p__70555;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70556,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70556,(1),null);
var job = vec__70556;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__70370__auto___72060 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_70564){
var state_val_70565 = (state_70564[(1)]);
if((state_val_70565 === (1))){
var state_70564__$1 = state_70564;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70564__$1,(2),res,v);
} else {
if((state_val_70565 === (2))){
var inst_70561 = (state_70564[(2)]);
var inst_70562 = cljs.core.async.close_BANG_(res);
var state_70564__$1 = (function (){var statearr_70570 = state_70564;
(statearr_70570[(7)] = inst_70561);

return statearr_70570;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70564__$1,inst_70562);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0 = (function (){
var statearr_70572 = [null,null,null,null,null,null,null,null];
(statearr_70572[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__);

(statearr_70572[(1)] = (1));

return statearr_70572;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1 = (function (state_70564){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70564);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70573){var ex__70338__auto__ = e70573;
var statearr_70574_72065 = state_70564;
(statearr_70574_72065[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70564[(4)]))){
var statearr_70576_72066 = state_70564;
(statearr_70576_72066[(1)] = cljs.core.first((state_70564[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72067 = state_70564;
state_70564 = G__72067;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = function(state_70564){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1.call(this,state_70564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_70577 = f__70371__auto__();
(statearr_70577[(6)] = c__70370__auto___72060);

return statearr_70577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__70578){
var vec__70579 = p__70578;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70579,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70579,(1),null);
var job = vec__70579;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4607__auto___72069 = n;
var __72070 = (0);
while(true){
if((__72070 < n__4607__auto___72069)){
var G__70582_72071 = type;
var G__70582_72072__$1 = (((G__70582_72071 instanceof cljs.core.Keyword))?G__70582_72071.fqn:null);
switch (G__70582_72072__$1) {
case "compute":
var c__70370__auto___72074 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__72070,c__70370__auto___72074,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async){
return (function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = ((function (__72070,c__70370__auto___72074,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async){
return (function (state_70595){
var state_val_70596 = (state_70595[(1)]);
if((state_val_70596 === (1))){
var state_70595__$1 = state_70595;
var statearr_70599_72078 = state_70595__$1;
(statearr_70599_72078[(2)] = null);

(statearr_70599_72078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (2))){
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70595__$1,(4),jobs);
} else {
if((state_val_70596 === (3))){
var inst_70593 = (state_70595[(2)]);
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70595__$1,inst_70593);
} else {
if((state_val_70596 === (4))){
var inst_70585 = (state_70595[(2)]);
var inst_70586 = process(inst_70585);
var state_70595__$1 = state_70595;
if(cljs.core.truth_(inst_70586)){
var statearr_70603_72079 = state_70595__$1;
(statearr_70603_72079[(1)] = (5));

} else {
var statearr_70604_72080 = state_70595__$1;
(statearr_70604_72080[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (5))){
var state_70595__$1 = state_70595;
var statearr_70605_72081 = state_70595__$1;
(statearr_70605_72081[(2)] = null);

(statearr_70605_72081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (6))){
var state_70595__$1 = state_70595;
var statearr_70606_72082 = state_70595__$1;
(statearr_70606_72082[(2)] = null);

(statearr_70606_72082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (7))){
var inst_70591 = (state_70595[(2)]);
var state_70595__$1 = state_70595;
var statearr_70609_72083 = state_70595__$1;
(statearr_70609_72083[(2)] = inst_70591);

(statearr_70609_72083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__72070,c__70370__auto___72074,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async))
;
return ((function (__72070,switch__70334__auto__,c__70370__auto___72074,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0 = (function (){
var statearr_70611 = [null,null,null,null,null,null,null];
(statearr_70611[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__);

(statearr_70611[(1)] = (1));

return statearr_70611;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1 = (function (state_70595){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70595);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70612){var ex__70338__auto__ = e70612;
var statearr_70613_72085 = state_70595;
(statearr_70613_72085[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70595[(4)]))){
var statearr_70616_72088 = state_70595;
(statearr_70616_72088[(1)] = cljs.core.first((state_70595[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72089 = state_70595;
state_70595 = G__72089;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = function(state_70595){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1.call(this,state_70595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__;
})()
;})(__72070,switch__70334__auto__,c__70370__auto___72074,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async))
})();
var state__70372__auto__ = (function (){var statearr_70618 = f__70371__auto__();
(statearr_70618[(6)] = c__70370__auto___72074);

return statearr_70618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
});})(__72070,c__70370__auto___72074,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async))
);


break;
case "async":
var c__70370__auto___72090 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__72070,c__70370__auto___72090,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async){
return (function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = ((function (__72070,c__70370__auto___72090,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async){
return (function (state_70631){
var state_val_70632 = (state_70631[(1)]);
if((state_val_70632 === (1))){
var state_70631__$1 = state_70631;
var statearr_70633_72094 = state_70631__$1;
(statearr_70633_72094[(2)] = null);

(statearr_70633_72094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70632 === (2))){
var state_70631__$1 = state_70631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70631__$1,(4),jobs);
} else {
if((state_val_70632 === (3))){
var inst_70629 = (state_70631[(2)]);
var state_70631__$1 = state_70631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70631__$1,inst_70629);
} else {
if((state_val_70632 === (4))){
var inst_70621 = (state_70631[(2)]);
var inst_70622 = async(inst_70621);
var state_70631__$1 = state_70631;
if(cljs.core.truth_(inst_70622)){
var statearr_70635_72111 = state_70631__$1;
(statearr_70635_72111[(1)] = (5));

} else {
var statearr_70637_72112 = state_70631__$1;
(statearr_70637_72112[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70632 === (5))){
var state_70631__$1 = state_70631;
var statearr_70639_72113 = state_70631__$1;
(statearr_70639_72113[(2)] = null);

(statearr_70639_72113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70632 === (6))){
var state_70631__$1 = state_70631;
var statearr_70640_72115 = state_70631__$1;
(statearr_70640_72115[(2)] = null);

(statearr_70640_72115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70632 === (7))){
var inst_70627 = (state_70631[(2)]);
var state_70631__$1 = state_70631;
var statearr_70641_72116 = state_70631__$1;
(statearr_70641_72116[(2)] = inst_70627);

(statearr_70641_72116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__72070,c__70370__auto___72090,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async))
;
return ((function (__72070,switch__70334__auto__,c__70370__auto___72090,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0 = (function (){
var statearr_70642 = [null,null,null,null,null,null,null];
(statearr_70642[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__);

(statearr_70642[(1)] = (1));

return statearr_70642;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1 = (function (state_70631){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70631);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70643){var ex__70338__auto__ = e70643;
var statearr_70644_72120 = state_70631;
(statearr_70644_72120[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70631[(4)]))){
var statearr_70645_72121 = state_70631;
(statearr_70645_72121[(1)] = cljs.core.first((state_70631[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72124 = state_70631;
state_70631 = G__72124;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = function(state_70631){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1.call(this,state_70631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__;
})()
;})(__72070,switch__70334__auto__,c__70370__auto___72090,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async))
})();
var state__70372__auto__ = (function (){var statearr_70646 = f__70371__auto__();
(statearr_70646[(6)] = c__70370__auto___72090);

return statearr_70646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
});})(__72070,c__70370__auto___72090,G__70582_72071,G__70582_72072__$1,n__4607__auto___72069,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__70582_72072__$1)].join('')));

}

var G__72126 = (__72070 + (1));
__72070 = G__72126;
continue;
} else {
}
break;
}

var c__70370__auto___72128 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_70668){
var state_val_70669 = (state_70668[(1)]);
if((state_val_70669 === (7))){
var inst_70664 = (state_70668[(2)]);
var state_70668__$1 = state_70668;
var statearr_70670_72130 = state_70668__$1;
(statearr_70670_72130[(2)] = inst_70664);

(statearr_70670_72130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70669 === (1))){
var state_70668__$1 = state_70668;
var statearr_70671_72132 = state_70668__$1;
(statearr_70671_72132[(2)] = null);

(statearr_70671_72132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70669 === (4))){
var inst_70649 = (state_70668[(7)]);
var inst_70649__$1 = (state_70668[(2)]);
var inst_70650 = (inst_70649__$1 == null);
var state_70668__$1 = (function (){var statearr_70672 = state_70668;
(statearr_70672[(7)] = inst_70649__$1);

return statearr_70672;
})();
if(cljs.core.truth_(inst_70650)){
var statearr_70673_72136 = state_70668__$1;
(statearr_70673_72136[(1)] = (5));

} else {
var statearr_70674_72137 = state_70668__$1;
(statearr_70674_72137[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70669 === (6))){
var inst_70654 = (state_70668[(8)]);
var inst_70649 = (state_70668[(7)]);
var inst_70654__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70656 = [inst_70649,inst_70654__$1];
var inst_70657 = (new cljs.core.PersistentVector(null,2,(5),inst_70655,inst_70656,null));
var state_70668__$1 = (function (){var statearr_70678 = state_70668;
(statearr_70678[(8)] = inst_70654__$1);

return statearr_70678;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70668__$1,(8),jobs,inst_70657);
} else {
if((state_val_70669 === (3))){
var inst_70666 = (state_70668[(2)]);
var state_70668__$1 = state_70668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70668__$1,inst_70666);
} else {
if((state_val_70669 === (2))){
var state_70668__$1 = state_70668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70668__$1,(4),from);
} else {
if((state_val_70669 === (9))){
var inst_70661 = (state_70668[(2)]);
var state_70668__$1 = (function (){var statearr_70679 = state_70668;
(statearr_70679[(9)] = inst_70661);

return statearr_70679;
})();
var statearr_70680_72142 = state_70668__$1;
(statearr_70680_72142[(2)] = null);

(statearr_70680_72142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70669 === (5))){
var inst_70652 = cljs.core.async.close_BANG_(jobs);
var state_70668__$1 = state_70668;
var statearr_70681_72144 = state_70668__$1;
(statearr_70681_72144[(2)] = inst_70652);

(statearr_70681_72144[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70669 === (8))){
var inst_70654 = (state_70668[(8)]);
var inst_70659 = (state_70668[(2)]);
var state_70668__$1 = (function (){var statearr_70682 = state_70668;
(statearr_70682[(10)] = inst_70659);

return statearr_70682;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70668__$1,(9),results,inst_70654);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0 = (function (){
var statearr_70683 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70683[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__);

(statearr_70683[(1)] = (1));

return statearr_70683;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1 = (function (state_70668){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70668);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70684){var ex__70338__auto__ = e70684;
var statearr_70685_72148 = state_70668;
(statearr_70685_72148[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70668[(4)]))){
var statearr_70686_72149 = state_70668;
(statearr_70686_72149[(1)] = cljs.core.first((state_70668[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72150 = state_70668;
state_70668 = G__72150;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = function(state_70668){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1.call(this,state_70668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_70687 = f__70371__auto__();
(statearr_70687[(6)] = c__70370__auto___72128);

return statearr_70687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


var c__70370__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_70725){
var state_val_70726 = (state_70725[(1)]);
if((state_val_70726 === (7))){
var inst_70721 = (state_70725[(2)]);
var state_70725__$1 = state_70725;
var statearr_70727_72151 = state_70725__$1;
(statearr_70727_72151[(2)] = inst_70721);

(statearr_70727_72151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (20))){
var state_70725__$1 = state_70725;
var statearr_70728_72152 = state_70725__$1;
(statearr_70728_72152[(2)] = null);

(statearr_70728_72152[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (1))){
var state_70725__$1 = state_70725;
var statearr_70729_72153 = state_70725__$1;
(statearr_70729_72153[(2)] = null);

(statearr_70729_72153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (4))){
var inst_70690 = (state_70725[(7)]);
var inst_70690__$1 = (state_70725[(2)]);
var inst_70691 = (inst_70690__$1 == null);
var state_70725__$1 = (function (){var statearr_70733 = state_70725;
(statearr_70733[(7)] = inst_70690__$1);

return statearr_70733;
})();
if(cljs.core.truth_(inst_70691)){
var statearr_70734_72154 = state_70725__$1;
(statearr_70734_72154[(1)] = (5));

} else {
var statearr_70735_72155 = state_70725__$1;
(statearr_70735_72155[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (15))){
var inst_70703 = (state_70725[(8)]);
var state_70725__$1 = state_70725;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70725__$1,(18),to,inst_70703);
} else {
if((state_val_70726 === (21))){
var inst_70716 = (state_70725[(2)]);
var state_70725__$1 = state_70725;
var statearr_70736_72158 = state_70725__$1;
(statearr_70736_72158[(2)] = inst_70716);

(statearr_70736_72158[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (13))){
var inst_70718 = (state_70725[(2)]);
var state_70725__$1 = (function (){var statearr_70737 = state_70725;
(statearr_70737[(9)] = inst_70718);

return statearr_70737;
})();
var statearr_70738_72159 = state_70725__$1;
(statearr_70738_72159[(2)] = null);

(statearr_70738_72159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (6))){
var inst_70690 = (state_70725[(7)]);
var state_70725__$1 = state_70725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70725__$1,(11),inst_70690);
} else {
if((state_val_70726 === (17))){
var inst_70711 = (state_70725[(2)]);
var state_70725__$1 = state_70725;
if(cljs.core.truth_(inst_70711)){
var statearr_70739_72162 = state_70725__$1;
(statearr_70739_72162[(1)] = (19));

} else {
var statearr_70740_72164 = state_70725__$1;
(statearr_70740_72164[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (3))){
var inst_70723 = (state_70725[(2)]);
var state_70725__$1 = state_70725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70725__$1,inst_70723);
} else {
if((state_val_70726 === (12))){
var inst_70700 = (state_70725[(10)]);
var state_70725__$1 = state_70725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70725__$1,(14),inst_70700);
} else {
if((state_val_70726 === (2))){
var state_70725__$1 = state_70725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70725__$1,(4),results);
} else {
if((state_val_70726 === (19))){
var state_70725__$1 = state_70725;
var statearr_70742_72167 = state_70725__$1;
(statearr_70742_72167[(2)] = null);

(statearr_70742_72167[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (11))){
var inst_70700 = (state_70725[(2)]);
var state_70725__$1 = (function (){var statearr_70743 = state_70725;
(statearr_70743[(10)] = inst_70700);

return statearr_70743;
})();
var statearr_70744_72168 = state_70725__$1;
(statearr_70744_72168[(2)] = null);

(statearr_70744_72168[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (9))){
var state_70725__$1 = state_70725;
var statearr_70745_72171 = state_70725__$1;
(statearr_70745_72171[(2)] = null);

(statearr_70745_72171[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (5))){
var state_70725__$1 = state_70725;
if(cljs.core.truth_(close_QMARK_)){
var statearr_70746_72172 = state_70725__$1;
(statearr_70746_72172[(1)] = (8));

} else {
var statearr_70747_72173 = state_70725__$1;
(statearr_70747_72173[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (14))){
var inst_70703 = (state_70725[(8)]);
var inst_70703__$1 = (state_70725[(2)]);
var inst_70704 = (inst_70703__$1 == null);
var inst_70705 = cljs.core.not(inst_70704);
var state_70725__$1 = (function (){var statearr_70748 = state_70725;
(statearr_70748[(8)] = inst_70703__$1);

return statearr_70748;
})();
if(inst_70705){
var statearr_70749_72174 = state_70725__$1;
(statearr_70749_72174[(1)] = (15));

} else {
var statearr_70750_72175 = state_70725__$1;
(statearr_70750_72175[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (16))){
var state_70725__$1 = state_70725;
var statearr_70751_72176 = state_70725__$1;
(statearr_70751_72176[(2)] = false);

(statearr_70751_72176[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (10))){
var inst_70697 = (state_70725[(2)]);
var state_70725__$1 = state_70725;
var statearr_70752_72177 = state_70725__$1;
(statearr_70752_72177[(2)] = inst_70697);

(statearr_70752_72177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (18))){
var inst_70708 = (state_70725[(2)]);
var state_70725__$1 = state_70725;
var statearr_70756_72178 = state_70725__$1;
(statearr_70756_72178[(2)] = inst_70708);

(statearr_70756_72178[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70726 === (8))){
var inst_70694 = cljs.core.async.close_BANG_(to);
var state_70725__$1 = state_70725;
var statearr_70757_72180 = state_70725__$1;
(statearr_70757_72180[(2)] = inst_70694);

(statearr_70757_72180[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0 = (function (){
var statearr_70758 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70758[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__);

(statearr_70758[(1)] = (1));

return statearr_70758;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1 = (function (state_70725){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70725);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70759){var ex__70338__auto__ = e70759;
var statearr_70760_72181 = state_70725;
(statearr_70760_72181[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70725[(4)]))){
var statearr_70761_72182 = state_70725;
(statearr_70761_72182[(1)] = cljs.core.first((state_70725[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72184 = state_70725;
state_70725 = G__72184;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__ = function(state_70725){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1.call(this,state_70725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_70762 = f__70371__auto__();
(statearr_70762[(6)] = c__70370__auto__);

return statearr_70762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));

return c__70370__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__70764 = arguments.length;
switch (G__70764) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__70766 = arguments.length;
switch (G__70766) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__70768 = arguments.length;
switch (G__70768) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__70370__auto___72199 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_70794){
var state_val_70795 = (state_70794[(1)]);
if((state_val_70795 === (7))){
var inst_70790 = (state_70794[(2)]);
var state_70794__$1 = state_70794;
var statearr_70796_72200 = state_70794__$1;
(statearr_70796_72200[(2)] = inst_70790);

(statearr_70796_72200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (1))){
var state_70794__$1 = state_70794;
var statearr_70797_72201 = state_70794__$1;
(statearr_70797_72201[(2)] = null);

(statearr_70797_72201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (4))){
var inst_70771 = (state_70794[(7)]);
var inst_70771__$1 = (state_70794[(2)]);
var inst_70772 = (inst_70771__$1 == null);
var state_70794__$1 = (function (){var statearr_70798 = state_70794;
(statearr_70798[(7)] = inst_70771__$1);

return statearr_70798;
})();
if(cljs.core.truth_(inst_70772)){
var statearr_70799_72202 = state_70794__$1;
(statearr_70799_72202[(1)] = (5));

} else {
var statearr_70800_72203 = state_70794__$1;
(statearr_70800_72203[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (13))){
var state_70794__$1 = state_70794;
var statearr_70801_72204 = state_70794__$1;
(statearr_70801_72204[(2)] = null);

(statearr_70801_72204[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (6))){
var inst_70771 = (state_70794[(7)]);
var inst_70777 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_70771) : p.call(null,inst_70771));
var state_70794__$1 = state_70794;
if(cljs.core.truth_(inst_70777)){
var statearr_70802_72215 = state_70794__$1;
(statearr_70802_72215[(1)] = (9));

} else {
var statearr_70803_72216 = state_70794__$1;
(statearr_70803_72216[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (3))){
var inst_70792 = (state_70794[(2)]);
var state_70794__$1 = state_70794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70794__$1,inst_70792);
} else {
if((state_val_70795 === (12))){
var state_70794__$1 = state_70794;
var statearr_70804_72217 = state_70794__$1;
(statearr_70804_72217[(2)] = null);

(statearr_70804_72217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (2))){
var state_70794__$1 = state_70794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70794__$1,(4),ch);
} else {
if((state_val_70795 === (11))){
var inst_70771 = (state_70794[(7)]);
var inst_70781 = (state_70794[(2)]);
var state_70794__$1 = state_70794;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70794__$1,(8),inst_70781,inst_70771);
} else {
if((state_val_70795 === (9))){
var state_70794__$1 = state_70794;
var statearr_70805_72225 = state_70794__$1;
(statearr_70805_72225[(2)] = tc);

(statearr_70805_72225[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (5))){
var inst_70774 = cljs.core.async.close_BANG_(tc);
var inst_70775 = cljs.core.async.close_BANG_(fc);
var state_70794__$1 = (function (){var statearr_70806 = state_70794;
(statearr_70806[(8)] = inst_70774);

return statearr_70806;
})();
var statearr_70807_72236 = state_70794__$1;
(statearr_70807_72236[(2)] = inst_70775);

(statearr_70807_72236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (14))){
var inst_70788 = (state_70794[(2)]);
var state_70794__$1 = state_70794;
var statearr_70808_72240 = state_70794__$1;
(statearr_70808_72240[(2)] = inst_70788);

(statearr_70808_72240[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (10))){
var state_70794__$1 = state_70794;
var statearr_70809_72246 = state_70794__$1;
(statearr_70809_72246[(2)] = fc);

(statearr_70809_72246[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70795 === (8))){
var inst_70783 = (state_70794[(2)]);
var state_70794__$1 = state_70794;
if(cljs.core.truth_(inst_70783)){
var statearr_70810_72259 = state_70794__$1;
(statearr_70810_72259[(1)] = (12));

} else {
var statearr_70811_72260 = state_70794__$1;
(statearr_70811_72260[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_70812 = [null,null,null,null,null,null,null,null,null];
(statearr_70812[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_70812[(1)] = (1));

return statearr_70812;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_70794){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70794);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70813){var ex__70338__auto__ = e70813;
var statearr_70814_72267 = state_70794;
(statearr_70814_72267[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70794[(4)]))){
var statearr_70815_72268 = state_70794;
(statearr_70815_72268[(1)] = cljs.core.first((state_70794[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72270 = state_70794;
state_70794 = G__72270;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_70794){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_70794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_70816 = f__70371__auto__();
(statearr_70816[(6)] = c__70370__auto___72199);

return statearr_70816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__70370__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_70838){
var state_val_70839 = (state_70838[(1)]);
if((state_val_70839 === (7))){
var inst_70834 = (state_70838[(2)]);
var state_70838__$1 = state_70838;
var statearr_70840_72275 = state_70838__$1;
(statearr_70840_72275[(2)] = inst_70834);

(statearr_70840_72275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (1))){
var inst_70817 = init;
var inst_70818 = inst_70817;
var state_70838__$1 = (function (){var statearr_70841 = state_70838;
(statearr_70841[(7)] = inst_70818);

return statearr_70841;
})();
var statearr_70842_72278 = state_70838__$1;
(statearr_70842_72278[(2)] = null);

(statearr_70842_72278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (4))){
var inst_70821 = (state_70838[(8)]);
var inst_70821__$1 = (state_70838[(2)]);
var inst_70822 = (inst_70821__$1 == null);
var state_70838__$1 = (function (){var statearr_70843 = state_70838;
(statearr_70843[(8)] = inst_70821__$1);

return statearr_70843;
})();
if(cljs.core.truth_(inst_70822)){
var statearr_70844_72279 = state_70838__$1;
(statearr_70844_72279[(1)] = (5));

} else {
var statearr_70845_72281 = state_70838__$1;
(statearr_70845_72281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (6))){
var inst_70825 = (state_70838[(9)]);
var inst_70821 = (state_70838[(8)]);
var inst_70818 = (state_70838[(7)]);
var inst_70825__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_70818,inst_70821) : f.call(null,inst_70818,inst_70821));
var inst_70826 = cljs.core.reduced_QMARK_(inst_70825__$1);
var state_70838__$1 = (function (){var statearr_70846 = state_70838;
(statearr_70846[(9)] = inst_70825__$1);

return statearr_70846;
})();
if(inst_70826){
var statearr_70847_72283 = state_70838__$1;
(statearr_70847_72283[(1)] = (8));

} else {
var statearr_70848_72284 = state_70838__$1;
(statearr_70848_72284[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (3))){
var inst_70836 = (state_70838[(2)]);
var state_70838__$1 = state_70838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70838__$1,inst_70836);
} else {
if((state_val_70839 === (2))){
var state_70838__$1 = state_70838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70838__$1,(4),ch);
} else {
if((state_val_70839 === (9))){
var inst_70825 = (state_70838[(9)]);
var inst_70818 = inst_70825;
var state_70838__$1 = (function (){var statearr_70849 = state_70838;
(statearr_70849[(7)] = inst_70818);

return statearr_70849;
})();
var statearr_70850_72288 = state_70838__$1;
(statearr_70850_72288[(2)] = null);

(statearr_70850_72288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (5))){
var inst_70818 = (state_70838[(7)]);
var state_70838__$1 = state_70838;
var statearr_70851_72290 = state_70838__$1;
(statearr_70851_72290[(2)] = inst_70818);

(statearr_70851_72290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (10))){
var inst_70832 = (state_70838[(2)]);
var state_70838__$1 = state_70838;
var statearr_70852_72293 = state_70838__$1;
(statearr_70852_72293[(2)] = inst_70832);

(statearr_70852_72293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (8))){
var inst_70825 = (state_70838[(9)]);
var inst_70828 = cljs.core.deref(inst_70825);
var state_70838__$1 = state_70838;
var statearr_70853_72295 = state_70838__$1;
(statearr_70853_72295[(2)] = inst_70828);

(statearr_70853_72295[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__70335__auto__ = null;
var cljs$core$async$reduce_$_state_machine__70335__auto____0 = (function (){
var statearr_70854 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70854[(0)] = cljs$core$async$reduce_$_state_machine__70335__auto__);

(statearr_70854[(1)] = (1));

return statearr_70854;
});
var cljs$core$async$reduce_$_state_machine__70335__auto____1 = (function (state_70838){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70838);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70855){var ex__70338__auto__ = e70855;
var statearr_70856_72298 = state_70838;
(statearr_70856_72298[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70838[(4)]))){
var statearr_70857_72301 = state_70838;
(statearr_70857_72301[(1)] = cljs.core.first((state_70838[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72303 = state_70838;
state_70838 = G__72303;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__70335__auto__ = function(state_70838){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__70335__auto____1.call(this,state_70838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__70335__auto____0;
cljs$core$async$reduce_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__70335__auto____1;
return cljs$core$async$reduce_$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_70858 = f__70371__auto__();
(statearr_70858[(6)] = c__70370__auto__);

return statearr_70858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));

return c__70370__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__70370__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_70864){
var state_val_70865 = (state_70864[(1)]);
if((state_val_70865 === (1))){
var inst_70859 = cljs.core.async.reduce(f__$1,init,ch);
var state_70864__$1 = state_70864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70864__$1,(2),inst_70859);
} else {
if((state_val_70865 === (2))){
var inst_70861 = (state_70864[(2)]);
var inst_70862 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_70861) : f__$1.call(null,inst_70861));
var state_70864__$1 = state_70864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70864__$1,inst_70862);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__70335__auto__ = null;
var cljs$core$async$transduce_$_state_machine__70335__auto____0 = (function (){
var statearr_70866 = [null,null,null,null,null,null,null];
(statearr_70866[(0)] = cljs$core$async$transduce_$_state_machine__70335__auto__);

(statearr_70866[(1)] = (1));

return statearr_70866;
});
var cljs$core$async$transduce_$_state_machine__70335__auto____1 = (function (state_70864){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70864);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70867){var ex__70338__auto__ = e70867;
var statearr_70868_72311 = state_70864;
(statearr_70868_72311[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70864[(4)]))){
var statearr_70869_72312 = state_70864;
(statearr_70869_72312[(1)] = cljs.core.first((state_70864[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72314 = state_70864;
state_70864 = G__72314;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__70335__auto__ = function(state_70864){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__70335__auto____1.call(this,state_70864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__70335__auto____0;
cljs$core$async$transduce_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__70335__auto____1;
return cljs$core$async$transduce_$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_70870 = f__70371__auto__();
(statearr_70870[(6)] = c__70370__auto__);

return statearr_70870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));

return c__70370__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__70872 = arguments.length;
switch (G__70872) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__70370__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_70897){
var state_val_70898 = (state_70897[(1)]);
if((state_val_70898 === (7))){
var inst_70879 = (state_70897[(2)]);
var state_70897__$1 = state_70897;
var statearr_70899_72316 = state_70897__$1;
(statearr_70899_72316[(2)] = inst_70879);

(statearr_70899_72316[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (1))){
var inst_70873 = cljs.core.seq(coll);
var inst_70874 = inst_70873;
var state_70897__$1 = (function (){var statearr_70900 = state_70897;
(statearr_70900[(7)] = inst_70874);

return statearr_70900;
})();
var statearr_70901_72317 = state_70897__$1;
(statearr_70901_72317[(2)] = null);

(statearr_70901_72317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (4))){
var inst_70874 = (state_70897[(7)]);
var inst_70877 = cljs.core.first(inst_70874);
var state_70897__$1 = state_70897;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70897__$1,(7),ch,inst_70877);
} else {
if((state_val_70898 === (13))){
var inst_70891 = (state_70897[(2)]);
var state_70897__$1 = state_70897;
var statearr_70902_72318 = state_70897__$1;
(statearr_70902_72318[(2)] = inst_70891);

(statearr_70902_72318[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (6))){
var inst_70882 = (state_70897[(2)]);
var state_70897__$1 = state_70897;
if(cljs.core.truth_(inst_70882)){
var statearr_70903_72319 = state_70897__$1;
(statearr_70903_72319[(1)] = (8));

} else {
var statearr_70904_72320 = state_70897__$1;
(statearr_70904_72320[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (3))){
var inst_70895 = (state_70897[(2)]);
var state_70897__$1 = state_70897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70897__$1,inst_70895);
} else {
if((state_val_70898 === (12))){
var state_70897__$1 = state_70897;
var statearr_70905_72321 = state_70897__$1;
(statearr_70905_72321[(2)] = null);

(statearr_70905_72321[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (2))){
var inst_70874 = (state_70897[(7)]);
var state_70897__$1 = state_70897;
if(cljs.core.truth_(inst_70874)){
var statearr_70906_72322 = state_70897__$1;
(statearr_70906_72322[(1)] = (4));

} else {
var statearr_70907_72323 = state_70897__$1;
(statearr_70907_72323[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (11))){
var inst_70888 = cljs.core.async.close_BANG_(ch);
var state_70897__$1 = state_70897;
var statearr_70908_72325 = state_70897__$1;
(statearr_70908_72325[(2)] = inst_70888);

(statearr_70908_72325[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (9))){
var state_70897__$1 = state_70897;
if(cljs.core.truth_(close_QMARK_)){
var statearr_70909_72326 = state_70897__$1;
(statearr_70909_72326[(1)] = (11));

} else {
var statearr_70910_72327 = state_70897__$1;
(statearr_70910_72327[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (5))){
var inst_70874 = (state_70897[(7)]);
var state_70897__$1 = state_70897;
var statearr_70911_72328 = state_70897__$1;
(statearr_70911_72328[(2)] = inst_70874);

(statearr_70911_72328[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (10))){
var inst_70893 = (state_70897[(2)]);
var state_70897__$1 = state_70897;
var statearr_70912_72330 = state_70897__$1;
(statearr_70912_72330[(2)] = inst_70893);

(statearr_70912_72330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70898 === (8))){
var inst_70874 = (state_70897[(7)]);
var inst_70884 = cljs.core.next(inst_70874);
var inst_70874__$1 = inst_70884;
var state_70897__$1 = (function (){var statearr_70913 = state_70897;
(statearr_70913[(7)] = inst_70874__$1);

return statearr_70913;
})();
var statearr_70914_72331 = state_70897__$1;
(statearr_70914_72331[(2)] = null);

(statearr_70914_72331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_70915 = [null,null,null,null,null,null,null,null];
(statearr_70915[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_70915[(1)] = (1));

return statearr_70915;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_70897){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_70897);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e70916){var ex__70338__auto__ = e70916;
var statearr_70917_72332 = state_70897;
(statearr_70917_72332[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_70897[(4)]))){
var statearr_70918_72333 = state_70897;
(statearr_70918_72333[(1)] = cljs.core.first((state_70897[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72334 = state_70897;
state_70897 = G__72334;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_70897){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_70897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_70919 = f__70371__auto__();
(statearr_70919[(6)] = c__70370__auto__);

return statearr_70919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));

return c__70370__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_72335 = (function (_){
var x__4422__auto__ = (((_ == null))?null:_);
var m__4423__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4423__auto__.call(null,_));
} else {
var m__4420__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4420__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_72335(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_72336 = (function (m,ch,close_QMARK_){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4423__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4420__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4420__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_72336(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_72337 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_72337(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_72338 = (function (m){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4423__auto__.call(null,m));
} else {
var m__4420__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4420__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_72338(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async70920 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async70920 = (function (ch,cs,meta70921){
this.ch = ch;
this.cs = cs;
this.meta70921 = meta70921;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async70920.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_70922,meta70921__$1){
var self__ = this;
var _70922__$1 = this;
return (new cljs.core.async.t_cljs$core$async70920(self__.ch,self__.cs,meta70921__$1));
}));

(cljs.core.async.t_cljs$core$async70920.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_70922){
var self__ = this;
var _70922__$1 = this;
return self__.meta70921;
}));

(cljs.core.async.t_cljs$core$async70920.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async70920.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async70920.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async70920.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async70920.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async70920.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async70920.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta70921","meta70921",-100569498,null)], null);
}));

(cljs.core.async.t_cljs$core$async70920.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async70920.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async70920");

(cljs.core.async.t_cljs$core$async70920.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async70920");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async70920.
 */
cljs.core.async.__GT_t_cljs$core$async70920 = (function cljs$core$async$mult_$___GT_t_cljs$core$async70920(ch__$1,cs__$1,meta70921){
return (new cljs.core.async.t_cljs$core$async70920(ch__$1,cs__$1,meta70921));
});

}

return (new cljs.core.async.t_cljs$core$async70920(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__70370__auto___72339 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71055){
var state_val_71056 = (state_71055[(1)]);
if((state_val_71056 === (7))){
var inst_71051 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71057_72340 = state_71055__$1;
(statearr_71057_72340[(2)] = inst_71051);

(statearr_71057_72340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (20))){
var inst_70956 = (state_71055[(7)]);
var inst_70968 = cljs.core.first(inst_70956);
var inst_70969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70968,(0),null);
var inst_70970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70968,(1),null);
var state_71055__$1 = (function (){var statearr_71058 = state_71055;
(statearr_71058[(8)] = inst_70969);

return statearr_71058;
})();
if(cljs.core.truth_(inst_70970)){
var statearr_71059_72342 = state_71055__$1;
(statearr_71059_72342[(1)] = (22));

} else {
var statearr_71060_72343 = state_71055__$1;
(statearr_71060_72343[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (27))){
var inst_70925 = (state_71055[(9)]);
var inst_71000 = (state_71055[(10)]);
var inst_70998 = (state_71055[(11)]);
var inst_71005 = (state_71055[(12)]);
var inst_71005__$1 = cljs.core._nth(inst_70998,inst_71000);
var inst_71006 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_71005__$1,inst_70925,done);
var state_71055__$1 = (function (){var statearr_71061 = state_71055;
(statearr_71061[(12)] = inst_71005__$1);

return statearr_71061;
})();
if(cljs.core.truth_(inst_71006)){
var statearr_71062_72346 = state_71055__$1;
(statearr_71062_72346[(1)] = (30));

} else {
var statearr_71063_72347 = state_71055__$1;
(statearr_71063_72347[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (1))){
var state_71055__$1 = state_71055;
var statearr_71064_72348 = state_71055__$1;
(statearr_71064_72348[(2)] = null);

(statearr_71064_72348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (24))){
var inst_70956 = (state_71055[(7)]);
var inst_70975 = (state_71055[(2)]);
var inst_70976 = cljs.core.next(inst_70956);
var inst_70934 = inst_70976;
var inst_70935 = null;
var inst_70936 = (0);
var inst_70937 = (0);
var state_71055__$1 = (function (){var statearr_71065 = state_71055;
(statearr_71065[(13)] = inst_70934);

(statearr_71065[(14)] = inst_70935);

(statearr_71065[(15)] = inst_70936);

(statearr_71065[(16)] = inst_70937);

(statearr_71065[(17)] = inst_70975);

return statearr_71065;
})();
var statearr_71066_72351 = state_71055__$1;
(statearr_71066_72351[(2)] = null);

(statearr_71066_72351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (39))){
var state_71055__$1 = state_71055;
var statearr_71070_72353 = state_71055__$1;
(statearr_71070_72353[(2)] = null);

(statearr_71070_72353[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (4))){
var inst_70925 = (state_71055[(9)]);
var inst_70925__$1 = (state_71055[(2)]);
var inst_70926 = (inst_70925__$1 == null);
var state_71055__$1 = (function (){var statearr_71071 = state_71055;
(statearr_71071[(9)] = inst_70925__$1);

return statearr_71071;
})();
if(cljs.core.truth_(inst_70926)){
var statearr_71072_72354 = state_71055__$1;
(statearr_71072_72354[(1)] = (5));

} else {
var statearr_71073_72355 = state_71055__$1;
(statearr_71073_72355[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (15))){
var inst_70934 = (state_71055[(13)]);
var inst_70935 = (state_71055[(14)]);
var inst_70936 = (state_71055[(15)]);
var inst_70937 = (state_71055[(16)]);
var inst_70952 = (state_71055[(2)]);
var inst_70953 = (inst_70937 + (1));
var tmp71067 = inst_70934;
var tmp71068 = inst_70935;
var tmp71069 = inst_70936;
var inst_70934__$1 = tmp71067;
var inst_70935__$1 = tmp71068;
var inst_70936__$1 = tmp71069;
var inst_70937__$1 = inst_70953;
var state_71055__$1 = (function (){var statearr_71074 = state_71055;
(statearr_71074[(13)] = inst_70934__$1);

(statearr_71074[(14)] = inst_70935__$1);

(statearr_71074[(15)] = inst_70936__$1);

(statearr_71074[(16)] = inst_70937__$1);

(statearr_71074[(18)] = inst_70952);

return statearr_71074;
})();
var statearr_71075_72359 = state_71055__$1;
(statearr_71075_72359[(2)] = null);

(statearr_71075_72359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (21))){
var inst_70979 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71079_72360 = state_71055__$1;
(statearr_71079_72360[(2)] = inst_70979);

(statearr_71079_72360[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (31))){
var inst_71005 = (state_71055[(12)]);
var inst_71009 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_71005);
var state_71055__$1 = state_71055;
var statearr_71080_72361 = state_71055__$1;
(statearr_71080_72361[(2)] = inst_71009);

(statearr_71080_72361[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (32))){
var inst_71000 = (state_71055[(10)]);
var inst_70998 = (state_71055[(11)]);
var inst_70997 = (state_71055[(19)]);
var inst_70999 = (state_71055[(20)]);
var inst_71011 = (state_71055[(2)]);
var inst_71012 = (inst_71000 + (1));
var tmp71076 = inst_70998;
var tmp71077 = inst_70997;
var tmp71078 = inst_70999;
var inst_70997__$1 = tmp71077;
var inst_70998__$1 = tmp71076;
var inst_70999__$1 = tmp71078;
var inst_71000__$1 = inst_71012;
var state_71055__$1 = (function (){var statearr_71081 = state_71055;
(statearr_71081[(10)] = inst_71000__$1);

(statearr_71081[(11)] = inst_70998__$1);

(statearr_71081[(21)] = inst_71011);

(statearr_71081[(19)] = inst_70997__$1);

(statearr_71081[(20)] = inst_70999__$1);

return statearr_71081;
})();
var statearr_71082_72362 = state_71055__$1;
(statearr_71082_72362[(2)] = null);

(statearr_71082_72362[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (40))){
var inst_71024 = (state_71055[(22)]);
var inst_71028 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_71024);
var state_71055__$1 = state_71055;
var statearr_71083_72363 = state_71055__$1;
(statearr_71083_72363[(2)] = inst_71028);

(statearr_71083_72363[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (33))){
var inst_71015 = (state_71055[(23)]);
var inst_71017 = cljs.core.chunked_seq_QMARK_(inst_71015);
var state_71055__$1 = state_71055;
if(inst_71017){
var statearr_71084_72364 = state_71055__$1;
(statearr_71084_72364[(1)] = (36));

} else {
var statearr_71085_72365 = state_71055__$1;
(statearr_71085_72365[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (13))){
var inst_70946 = (state_71055[(24)]);
var inst_70949 = cljs.core.async.close_BANG_(inst_70946);
var state_71055__$1 = state_71055;
var statearr_71086_72366 = state_71055__$1;
(statearr_71086_72366[(2)] = inst_70949);

(statearr_71086_72366[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (22))){
var inst_70969 = (state_71055[(8)]);
var inst_70972 = cljs.core.async.close_BANG_(inst_70969);
var state_71055__$1 = state_71055;
var statearr_71087_72367 = state_71055__$1;
(statearr_71087_72367[(2)] = inst_70972);

(statearr_71087_72367[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (36))){
var inst_71015 = (state_71055[(23)]);
var inst_71019 = cljs.core.chunk_first(inst_71015);
var inst_71020 = cljs.core.chunk_rest(inst_71015);
var inst_71021 = cljs.core.count(inst_71019);
var inst_70997 = inst_71020;
var inst_70998 = inst_71019;
var inst_70999 = inst_71021;
var inst_71000 = (0);
var state_71055__$1 = (function (){var statearr_71088 = state_71055;
(statearr_71088[(10)] = inst_71000);

(statearr_71088[(11)] = inst_70998);

(statearr_71088[(19)] = inst_70997);

(statearr_71088[(20)] = inst_70999);

return statearr_71088;
})();
var statearr_71089_72368 = state_71055__$1;
(statearr_71089_72368[(2)] = null);

(statearr_71089_72368[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (41))){
var inst_71015 = (state_71055[(23)]);
var inst_71030 = (state_71055[(2)]);
var inst_71031 = cljs.core.next(inst_71015);
var inst_70997 = inst_71031;
var inst_70998 = null;
var inst_70999 = (0);
var inst_71000 = (0);
var state_71055__$1 = (function (){var statearr_71090 = state_71055;
(statearr_71090[(10)] = inst_71000);

(statearr_71090[(11)] = inst_70998);

(statearr_71090[(19)] = inst_70997);

(statearr_71090[(20)] = inst_70999);

(statearr_71090[(25)] = inst_71030);

return statearr_71090;
})();
var statearr_71091_72369 = state_71055__$1;
(statearr_71091_72369[(2)] = null);

(statearr_71091_72369[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (43))){
var state_71055__$1 = state_71055;
var statearr_71092_72370 = state_71055__$1;
(statearr_71092_72370[(2)] = null);

(statearr_71092_72370[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (29))){
var inst_71039 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71093_72371 = state_71055__$1;
(statearr_71093_72371[(2)] = inst_71039);

(statearr_71093_72371[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (44))){
var inst_71048 = (state_71055[(2)]);
var state_71055__$1 = (function (){var statearr_71094 = state_71055;
(statearr_71094[(26)] = inst_71048);

return statearr_71094;
})();
var statearr_71095_72372 = state_71055__$1;
(statearr_71095_72372[(2)] = null);

(statearr_71095_72372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (6))){
var inst_70989 = (state_71055[(27)]);
var inst_70988 = cljs.core.deref(cs);
var inst_70989__$1 = cljs.core.keys(inst_70988);
var inst_70990 = cljs.core.count(inst_70989__$1);
var inst_70991 = cljs.core.reset_BANG_(dctr,inst_70990);
var inst_70996 = cljs.core.seq(inst_70989__$1);
var inst_70997 = inst_70996;
var inst_70998 = null;
var inst_70999 = (0);
var inst_71000 = (0);
var state_71055__$1 = (function (){var statearr_71096 = state_71055;
(statearr_71096[(27)] = inst_70989__$1);

(statearr_71096[(10)] = inst_71000);

(statearr_71096[(11)] = inst_70998);

(statearr_71096[(28)] = inst_70991);

(statearr_71096[(19)] = inst_70997);

(statearr_71096[(20)] = inst_70999);

return statearr_71096;
})();
var statearr_71097_72373 = state_71055__$1;
(statearr_71097_72373[(2)] = null);

(statearr_71097_72373[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (28))){
var inst_71015 = (state_71055[(23)]);
var inst_70997 = (state_71055[(19)]);
var inst_71015__$1 = cljs.core.seq(inst_70997);
var state_71055__$1 = (function (){var statearr_71098 = state_71055;
(statearr_71098[(23)] = inst_71015__$1);

return statearr_71098;
})();
if(inst_71015__$1){
var statearr_71099_72374 = state_71055__$1;
(statearr_71099_72374[(1)] = (33));

} else {
var statearr_71100_72375 = state_71055__$1;
(statearr_71100_72375[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (25))){
var inst_71000 = (state_71055[(10)]);
var inst_70999 = (state_71055[(20)]);
var inst_71002 = (inst_71000 < inst_70999);
var inst_71003 = inst_71002;
var state_71055__$1 = state_71055;
if(cljs.core.truth_(inst_71003)){
var statearr_71101_72379 = state_71055__$1;
(statearr_71101_72379[(1)] = (27));

} else {
var statearr_71102_72380 = state_71055__$1;
(statearr_71102_72380[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (34))){
var state_71055__$1 = state_71055;
var statearr_71103_72381 = state_71055__$1;
(statearr_71103_72381[(2)] = null);

(statearr_71103_72381[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (17))){
var state_71055__$1 = state_71055;
var statearr_71104_72382 = state_71055__$1;
(statearr_71104_72382[(2)] = null);

(statearr_71104_72382[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (3))){
var inst_71053 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71055__$1,inst_71053);
} else {
if((state_val_71056 === (12))){
var inst_70984 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71105_72383 = state_71055__$1;
(statearr_71105_72383[(2)] = inst_70984);

(statearr_71105_72383[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (2))){
var state_71055__$1 = state_71055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71055__$1,(4),ch);
} else {
if((state_val_71056 === (23))){
var state_71055__$1 = state_71055;
var statearr_71106_72385 = state_71055__$1;
(statearr_71106_72385[(2)] = null);

(statearr_71106_72385[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (35))){
var inst_71037 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71107_72386 = state_71055__$1;
(statearr_71107_72386[(2)] = inst_71037);

(statearr_71107_72386[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (19))){
var inst_70956 = (state_71055[(7)]);
var inst_70960 = cljs.core.chunk_first(inst_70956);
var inst_70961 = cljs.core.chunk_rest(inst_70956);
var inst_70962 = cljs.core.count(inst_70960);
var inst_70934 = inst_70961;
var inst_70935 = inst_70960;
var inst_70936 = inst_70962;
var inst_70937 = (0);
var state_71055__$1 = (function (){var statearr_71108 = state_71055;
(statearr_71108[(13)] = inst_70934);

(statearr_71108[(14)] = inst_70935);

(statearr_71108[(15)] = inst_70936);

(statearr_71108[(16)] = inst_70937);

return statearr_71108;
})();
var statearr_71109_72387 = state_71055__$1;
(statearr_71109_72387[(2)] = null);

(statearr_71109_72387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (11))){
var inst_70934 = (state_71055[(13)]);
var inst_70956 = (state_71055[(7)]);
var inst_70956__$1 = cljs.core.seq(inst_70934);
var state_71055__$1 = (function (){var statearr_71110 = state_71055;
(statearr_71110[(7)] = inst_70956__$1);

return statearr_71110;
})();
if(inst_70956__$1){
var statearr_71111_72388 = state_71055__$1;
(statearr_71111_72388[(1)] = (16));

} else {
var statearr_71112_72389 = state_71055__$1;
(statearr_71112_72389[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (9))){
var inst_70986 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71113_72390 = state_71055__$1;
(statearr_71113_72390[(2)] = inst_70986);

(statearr_71113_72390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (5))){
var inst_70932 = cljs.core.deref(cs);
var inst_70933 = cljs.core.seq(inst_70932);
var inst_70934 = inst_70933;
var inst_70935 = null;
var inst_70936 = (0);
var inst_70937 = (0);
var state_71055__$1 = (function (){var statearr_71114 = state_71055;
(statearr_71114[(13)] = inst_70934);

(statearr_71114[(14)] = inst_70935);

(statearr_71114[(15)] = inst_70936);

(statearr_71114[(16)] = inst_70937);

return statearr_71114;
})();
var statearr_71115_72391 = state_71055__$1;
(statearr_71115_72391[(2)] = null);

(statearr_71115_72391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (14))){
var state_71055__$1 = state_71055;
var statearr_71116_72392 = state_71055__$1;
(statearr_71116_72392[(2)] = null);

(statearr_71116_72392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (45))){
var inst_71045 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71117_72393 = state_71055__$1;
(statearr_71117_72393[(2)] = inst_71045);

(statearr_71117_72393[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (26))){
var inst_70989 = (state_71055[(27)]);
var inst_71041 = (state_71055[(2)]);
var inst_71042 = cljs.core.seq(inst_70989);
var state_71055__$1 = (function (){var statearr_71118 = state_71055;
(statearr_71118[(29)] = inst_71041);

return statearr_71118;
})();
if(inst_71042){
var statearr_71119_72394 = state_71055__$1;
(statearr_71119_72394[(1)] = (42));

} else {
var statearr_71120_72395 = state_71055__$1;
(statearr_71120_72395[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (16))){
var inst_70956 = (state_71055[(7)]);
var inst_70958 = cljs.core.chunked_seq_QMARK_(inst_70956);
var state_71055__$1 = state_71055;
if(inst_70958){
var statearr_71121_72396 = state_71055__$1;
(statearr_71121_72396[(1)] = (19));

} else {
var statearr_71122_72397 = state_71055__$1;
(statearr_71122_72397[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (38))){
var inst_71034 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71123_72398 = state_71055__$1;
(statearr_71123_72398[(2)] = inst_71034);

(statearr_71123_72398[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (30))){
var state_71055__$1 = state_71055;
var statearr_71124_72399 = state_71055__$1;
(statearr_71124_72399[(2)] = null);

(statearr_71124_72399[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (10))){
var inst_70935 = (state_71055[(14)]);
var inst_70937 = (state_71055[(16)]);
var inst_70945 = cljs.core._nth(inst_70935,inst_70937);
var inst_70946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70945,(0),null);
var inst_70947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70945,(1),null);
var state_71055__$1 = (function (){var statearr_71125 = state_71055;
(statearr_71125[(24)] = inst_70946);

return statearr_71125;
})();
if(cljs.core.truth_(inst_70947)){
var statearr_71126_72400 = state_71055__$1;
(statearr_71126_72400[(1)] = (13));

} else {
var statearr_71127_72401 = state_71055__$1;
(statearr_71127_72401[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (18))){
var inst_70982 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71128_72402 = state_71055__$1;
(statearr_71128_72402[(2)] = inst_70982);

(statearr_71128_72402[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (42))){
var state_71055__$1 = state_71055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71055__$1,(45),dchan);
} else {
if((state_val_71056 === (37))){
var inst_70925 = (state_71055[(9)]);
var inst_71024 = (state_71055[(22)]);
var inst_71015 = (state_71055[(23)]);
var inst_71024__$1 = cljs.core.first(inst_71015);
var inst_71025 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_71024__$1,inst_70925,done);
var state_71055__$1 = (function (){var statearr_71129 = state_71055;
(statearr_71129[(22)] = inst_71024__$1);

return statearr_71129;
})();
if(cljs.core.truth_(inst_71025)){
var statearr_71130_72403 = state_71055__$1;
(statearr_71130_72403[(1)] = (39));

} else {
var statearr_71131_72404 = state_71055__$1;
(statearr_71131_72404[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (8))){
var inst_70936 = (state_71055[(15)]);
var inst_70937 = (state_71055[(16)]);
var inst_70939 = (inst_70937 < inst_70936);
var inst_70940 = inst_70939;
var state_71055__$1 = state_71055;
if(cljs.core.truth_(inst_70940)){
var statearr_71132_72405 = state_71055__$1;
(statearr_71132_72405[(1)] = (10));

} else {
var statearr_71133_72406 = state_71055__$1;
(statearr_71133_72406[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__70335__auto__ = null;
var cljs$core$async$mult_$_state_machine__70335__auto____0 = (function (){
var statearr_71134 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71134[(0)] = cljs$core$async$mult_$_state_machine__70335__auto__);

(statearr_71134[(1)] = (1));

return statearr_71134;
});
var cljs$core$async$mult_$_state_machine__70335__auto____1 = (function (state_71055){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71055);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71135){var ex__70338__auto__ = e71135;
var statearr_71136_72408 = state_71055;
(statearr_71136_72408[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71055[(4)]))){
var statearr_71137_72409 = state_71055;
(statearr_71137_72409[(1)] = cljs.core.first((state_71055[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72410 = state_71055;
state_71055 = G__72410;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__70335__auto__ = function(state_71055){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__70335__auto____1.call(this,state_71055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__70335__auto____0;
cljs$core$async$mult_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__70335__auto____1;
return cljs$core$async$mult_$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71138 = f__70371__auto__();
(statearr_71138[(6)] = c__70370__auto___72339);

return statearr_71138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__71140 = arguments.length;
switch (G__71140) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_72412 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_72412(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_72415 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_72415(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_72418 = (function (m){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4423__auto__.call(null,m));
} else {
var m__4420__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4420__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_72418(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_72421 = (function (m,state_map){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4423__auto__.call(null,m,state_map));
} else {
var m__4420__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4420__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_72421(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_72424 = (function (m,mode){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4423__auto__.call(null,m,mode));
} else {
var m__4420__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4420__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_72424(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___72427 = arguments.length;
var i__4731__auto___72428 = (0);
while(true){
if((i__4731__auto___72428 < len__4730__auto___72427)){
args__4736__auto__.push((arguments[i__4731__auto___72428]));

var G__72430 = (i__4731__auto___72428 + (1));
i__4731__auto___72428 = G__72430;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__71145){
var map__71146 = p__71145;
var map__71146__$1 = (((((!((map__71146 == null))))?(((((map__71146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71146.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__71146):map__71146);
var opts = map__71146__$1;
var statearr_71148_72433 = state;
(statearr_71148_72433[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_71149_72434 = state;
(statearr_71149_72434[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_71150_72436 = state;
(statearr_71150_72436[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq71141){
var G__71142 = cljs.core.first(seq71141);
var seq71141__$1 = cljs.core.next(seq71141);
var G__71143 = cljs.core.first(seq71141__$1);
var seq71141__$2 = cljs.core.next(seq71141__$1);
var G__71144 = cljs.core.first(seq71141__$2);
var seq71141__$3 = cljs.core.next(seq71141__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71142,G__71143,G__71144,seq71141__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71151 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71151 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta71152){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta71152 = meta71152;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71153,meta71152__$1){
var self__ = this;
var _71153__$1 = this;
return (new cljs.core.async.t_cljs$core$async71151(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta71152__$1));
}));

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71153){
var self__ = this;
var _71153__$1 = this;
return self__.meta71152;
}));

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71151.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71151.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta71152","meta71152",-1645601078,null)], null);
}));

(cljs.core.async.t_cljs$core$async71151.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71151.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71151");

(cljs.core.async.t_cljs$core$async71151.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71151");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71151.
 */
cljs.core.async.__GT_t_cljs$core$async71151 = (function cljs$core$async$mix_$___GT_t_cljs$core$async71151(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta71152){
return (new cljs.core.async.t_cljs$core$async71151(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta71152));
});

}

return (new cljs.core.async.t_cljs$core$async71151(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__70370__auto___72447 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71255){
var state_val_71256 = (state_71255[(1)]);
if((state_val_71256 === (7))){
var inst_71170 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
var statearr_71257_72448 = state_71255__$1;
(statearr_71257_72448[(2)] = inst_71170);

(statearr_71257_72448[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (20))){
var inst_71182 = (state_71255[(7)]);
var state_71255__$1 = state_71255;
var statearr_71258_72449 = state_71255__$1;
(statearr_71258_72449[(2)] = inst_71182);

(statearr_71258_72449[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (27))){
var state_71255__$1 = state_71255;
var statearr_71259_72450 = state_71255__$1;
(statearr_71259_72450[(2)] = null);

(statearr_71259_72450[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (1))){
var inst_71157 = (state_71255[(8)]);
var inst_71157__$1 = calc_state();
var inst_71159 = (inst_71157__$1 == null);
var inst_71160 = cljs.core.not(inst_71159);
var state_71255__$1 = (function (){var statearr_71260 = state_71255;
(statearr_71260[(8)] = inst_71157__$1);

return statearr_71260;
})();
if(inst_71160){
var statearr_71261_72451 = state_71255__$1;
(statearr_71261_72451[(1)] = (2));

} else {
var statearr_71262_72452 = state_71255__$1;
(statearr_71262_72452[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (24))){
var inst_71215 = (state_71255[(9)]);
var inst_71206 = (state_71255[(10)]);
var inst_71229 = (state_71255[(11)]);
var inst_71229__$1 = (inst_71206.cljs$core$IFn$_invoke$arity$1 ? inst_71206.cljs$core$IFn$_invoke$arity$1(inst_71215) : inst_71206.call(null,inst_71215));
var state_71255__$1 = (function (){var statearr_71263 = state_71255;
(statearr_71263[(11)] = inst_71229__$1);

return statearr_71263;
})();
if(cljs.core.truth_(inst_71229__$1)){
var statearr_71264_72453 = state_71255__$1;
(statearr_71264_72453[(1)] = (29));

} else {
var statearr_71265_72454 = state_71255__$1;
(statearr_71265_72454[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (4))){
var inst_71173 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
if(cljs.core.truth_(inst_71173)){
var statearr_71266_72455 = state_71255__$1;
(statearr_71266_72455[(1)] = (8));

} else {
var statearr_71267_72456 = state_71255__$1;
(statearr_71267_72456[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (15))){
var inst_71200 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
if(cljs.core.truth_(inst_71200)){
var statearr_71268_72457 = state_71255__$1;
(statearr_71268_72457[(1)] = (19));

} else {
var statearr_71269_72458 = state_71255__$1;
(statearr_71269_72458[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (21))){
var inst_71205 = (state_71255[(12)]);
var inst_71205__$1 = (state_71255[(2)]);
var inst_71206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71205__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_71207 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71205__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_71208 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71205__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_71255__$1 = (function (){var statearr_71270 = state_71255;
(statearr_71270[(10)] = inst_71206);

(statearr_71270[(13)] = inst_71207);

(statearr_71270[(12)] = inst_71205__$1);

return statearr_71270;
})();
return cljs.core.async.ioc_alts_BANG_(state_71255__$1,(22),inst_71208);
} else {
if((state_val_71256 === (31))){
var inst_71237 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
if(cljs.core.truth_(inst_71237)){
var statearr_71271_72459 = state_71255__$1;
(statearr_71271_72459[(1)] = (32));

} else {
var statearr_71272_72460 = state_71255__$1;
(statearr_71272_72460[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (32))){
var inst_71214 = (state_71255[(14)]);
var state_71255__$1 = state_71255;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71255__$1,(35),out,inst_71214);
} else {
if((state_val_71256 === (33))){
var inst_71205 = (state_71255[(12)]);
var inst_71182 = inst_71205;
var state_71255__$1 = (function (){var statearr_71273 = state_71255;
(statearr_71273[(7)] = inst_71182);

return statearr_71273;
})();
var statearr_71274_72461 = state_71255__$1;
(statearr_71274_72461[(2)] = null);

(statearr_71274_72461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (13))){
var inst_71182 = (state_71255[(7)]);
var inst_71189 = inst_71182.cljs$lang$protocol_mask$partition0$;
var inst_71190 = (inst_71189 & (64));
var inst_71191 = inst_71182.cljs$core$ISeq$;
var inst_71192 = (cljs.core.PROTOCOL_SENTINEL === inst_71191);
var inst_71193 = ((inst_71190) || (inst_71192));
var state_71255__$1 = state_71255;
if(cljs.core.truth_(inst_71193)){
var statearr_71275_72462 = state_71255__$1;
(statearr_71275_72462[(1)] = (16));

} else {
var statearr_71276_72463 = state_71255__$1;
(statearr_71276_72463[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (22))){
var inst_71215 = (state_71255[(9)]);
var inst_71214 = (state_71255[(14)]);
var inst_71213 = (state_71255[(2)]);
var inst_71214__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71213,(0),null);
var inst_71215__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71213,(1),null);
var inst_71216 = (inst_71214__$1 == null);
var inst_71217 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71215__$1,change);
var inst_71218 = ((inst_71216) || (inst_71217));
var state_71255__$1 = (function (){var statearr_71277 = state_71255;
(statearr_71277[(9)] = inst_71215__$1);

(statearr_71277[(14)] = inst_71214__$1);

return statearr_71277;
})();
if(cljs.core.truth_(inst_71218)){
var statearr_71278_72464 = state_71255__$1;
(statearr_71278_72464[(1)] = (23));

} else {
var statearr_71279_72465 = state_71255__$1;
(statearr_71279_72465[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (36))){
var inst_71205 = (state_71255[(12)]);
var inst_71182 = inst_71205;
var state_71255__$1 = (function (){var statearr_71280 = state_71255;
(statearr_71280[(7)] = inst_71182);

return statearr_71280;
})();
var statearr_71281_72466 = state_71255__$1;
(statearr_71281_72466[(2)] = null);

(statearr_71281_72466[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (29))){
var inst_71229 = (state_71255[(11)]);
var state_71255__$1 = state_71255;
var statearr_71282_72467 = state_71255__$1;
(statearr_71282_72467[(2)] = inst_71229);

(statearr_71282_72467[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (6))){
var state_71255__$1 = state_71255;
var statearr_71283_72468 = state_71255__$1;
(statearr_71283_72468[(2)] = false);

(statearr_71283_72468[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (28))){
var inst_71225 = (state_71255[(2)]);
var inst_71226 = calc_state();
var inst_71182 = inst_71226;
var state_71255__$1 = (function (){var statearr_71284 = state_71255;
(statearr_71284[(7)] = inst_71182);

(statearr_71284[(15)] = inst_71225);

return statearr_71284;
})();
var statearr_71285_72469 = state_71255__$1;
(statearr_71285_72469[(2)] = null);

(statearr_71285_72469[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (25))){
var inst_71251 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
var statearr_71286_72470 = state_71255__$1;
(statearr_71286_72470[(2)] = inst_71251);

(statearr_71286_72470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (34))){
var inst_71249 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
var statearr_71287_72471 = state_71255__$1;
(statearr_71287_72471[(2)] = inst_71249);

(statearr_71287_72471[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (17))){
var state_71255__$1 = state_71255;
var statearr_71288_72472 = state_71255__$1;
(statearr_71288_72472[(2)] = false);

(statearr_71288_72472[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (3))){
var state_71255__$1 = state_71255;
var statearr_71289_72473 = state_71255__$1;
(statearr_71289_72473[(2)] = false);

(statearr_71289_72473[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (12))){
var inst_71253 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71255__$1,inst_71253);
} else {
if((state_val_71256 === (2))){
var inst_71157 = (state_71255[(8)]);
var inst_71162 = inst_71157.cljs$lang$protocol_mask$partition0$;
var inst_71163 = (inst_71162 & (64));
var inst_71164 = inst_71157.cljs$core$ISeq$;
var inst_71165 = (cljs.core.PROTOCOL_SENTINEL === inst_71164);
var inst_71166 = ((inst_71163) || (inst_71165));
var state_71255__$1 = state_71255;
if(cljs.core.truth_(inst_71166)){
var statearr_71290_72474 = state_71255__$1;
(statearr_71290_72474[(1)] = (5));

} else {
var statearr_71291_72475 = state_71255__$1;
(statearr_71291_72475[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (23))){
var inst_71214 = (state_71255[(14)]);
var inst_71220 = (inst_71214 == null);
var state_71255__$1 = state_71255;
if(cljs.core.truth_(inst_71220)){
var statearr_71292_72476 = state_71255__$1;
(statearr_71292_72476[(1)] = (26));

} else {
var statearr_71293_72477 = state_71255__$1;
(statearr_71293_72477[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (35))){
var inst_71240 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
if(cljs.core.truth_(inst_71240)){
var statearr_71294_72478 = state_71255__$1;
(statearr_71294_72478[(1)] = (36));

} else {
var statearr_71295_72479 = state_71255__$1;
(statearr_71295_72479[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (19))){
var inst_71182 = (state_71255[(7)]);
var inst_71202 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_71182);
var state_71255__$1 = state_71255;
var statearr_71296_72480 = state_71255__$1;
(statearr_71296_72480[(2)] = inst_71202);

(statearr_71296_72480[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (11))){
var inst_71182 = (state_71255[(7)]);
var inst_71186 = (inst_71182 == null);
var inst_71187 = cljs.core.not(inst_71186);
var state_71255__$1 = state_71255;
if(inst_71187){
var statearr_71297_72481 = state_71255__$1;
(statearr_71297_72481[(1)] = (13));

} else {
var statearr_71298_72482 = state_71255__$1;
(statearr_71298_72482[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (9))){
var inst_71157 = (state_71255[(8)]);
var state_71255__$1 = state_71255;
var statearr_71299_72483 = state_71255__$1;
(statearr_71299_72483[(2)] = inst_71157);

(statearr_71299_72483[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (5))){
var state_71255__$1 = state_71255;
var statearr_71300_72484 = state_71255__$1;
(statearr_71300_72484[(2)] = true);

(statearr_71300_72484[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (14))){
var state_71255__$1 = state_71255;
var statearr_71301_72485 = state_71255__$1;
(statearr_71301_72485[(2)] = false);

(statearr_71301_72485[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (26))){
var inst_71215 = (state_71255[(9)]);
var inst_71222 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_71215);
var state_71255__$1 = state_71255;
var statearr_71302_72486 = state_71255__$1;
(statearr_71302_72486[(2)] = inst_71222);

(statearr_71302_72486[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (16))){
var state_71255__$1 = state_71255;
var statearr_71303_72487 = state_71255__$1;
(statearr_71303_72487[(2)] = true);

(statearr_71303_72487[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (38))){
var inst_71245 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
var statearr_71304_72488 = state_71255__$1;
(statearr_71304_72488[(2)] = inst_71245);

(statearr_71304_72488[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (30))){
var inst_71215 = (state_71255[(9)]);
var inst_71206 = (state_71255[(10)]);
var inst_71207 = (state_71255[(13)]);
var inst_71232 = cljs.core.empty_QMARK_(inst_71206);
var inst_71233 = (inst_71207.cljs$core$IFn$_invoke$arity$1 ? inst_71207.cljs$core$IFn$_invoke$arity$1(inst_71215) : inst_71207.call(null,inst_71215));
var inst_71234 = cljs.core.not(inst_71233);
var inst_71235 = ((inst_71232) && (inst_71234));
var state_71255__$1 = state_71255;
var statearr_71305_72489 = state_71255__$1;
(statearr_71305_72489[(2)] = inst_71235);

(statearr_71305_72489[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (10))){
var inst_71157 = (state_71255[(8)]);
var inst_71178 = (state_71255[(2)]);
var inst_71179 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71178,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_71180 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71178,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_71181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71178,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_71182 = inst_71157;
var state_71255__$1 = (function (){var statearr_71306 = state_71255;
(statearr_71306[(16)] = inst_71181);

(statearr_71306[(7)] = inst_71182);

(statearr_71306[(17)] = inst_71180);

(statearr_71306[(18)] = inst_71179);

return statearr_71306;
})();
var statearr_71307_72490 = state_71255__$1;
(statearr_71307_72490[(2)] = null);

(statearr_71307_72490[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (18))){
var inst_71197 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
var statearr_71308_72491 = state_71255__$1;
(statearr_71308_72491[(2)] = inst_71197);

(statearr_71308_72491[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (37))){
var state_71255__$1 = state_71255;
var statearr_71309_72492 = state_71255__$1;
(statearr_71309_72492[(2)] = null);

(statearr_71309_72492[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (8))){
var inst_71157 = (state_71255[(8)]);
var inst_71175 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_71157);
var state_71255__$1 = state_71255;
var statearr_71310_72493 = state_71255__$1;
(statearr_71310_72493[(2)] = inst_71175);

(statearr_71310_72493[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__70335__auto__ = null;
var cljs$core$async$mix_$_state_machine__70335__auto____0 = (function (){
var statearr_71311 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71311[(0)] = cljs$core$async$mix_$_state_machine__70335__auto__);

(statearr_71311[(1)] = (1));

return statearr_71311;
});
var cljs$core$async$mix_$_state_machine__70335__auto____1 = (function (state_71255){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71255);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71312){var ex__70338__auto__ = e71312;
var statearr_71313_72494 = state_71255;
(statearr_71313_72494[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71255[(4)]))){
var statearr_71314_72495 = state_71255;
(statearr_71314_72495[(1)] = cljs.core.first((state_71255[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72496 = state_71255;
state_71255 = G__72496;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__70335__auto__ = function(state_71255){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__70335__auto____1.call(this,state_71255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__70335__auto____0;
cljs$core$async$mix_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__70335__auto____1;
return cljs$core$async$mix_$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71315 = f__70371__auto__();
(statearr_71315[(6)] = c__70370__auto___72447);

return statearr_71315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_72497 = (function (p,v,ch,close_QMARK_){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4423__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4420__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4420__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_72497(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_72498 = (function (p,v,ch){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4423__auto__.call(null,p,v,ch));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4420__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_72498(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_72499 = (function() {
var G__72500 = null;
var G__72500__1 = (function (p){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4423__auto__.call(null,p));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4420__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__72500__2 = (function (p,v){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4423__auto__.call(null,p,v));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4420__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__72500 = function(p,v){
switch(arguments.length){
case 1:
return G__72500__1.call(this,p);
case 2:
return G__72500__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__72500.cljs$core$IFn$_invoke$arity$1 = G__72500__1;
G__72500.cljs$core$IFn$_invoke$arity$2 = G__72500__2;
return G__72500;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__71317 = arguments.length;
switch (G__71317) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_72499(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_72499(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__71320 = arguments.length;
switch (G__71320) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4120__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__71318_SHARP_){
if(cljs.core.truth_((p1__71318_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__71318_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__71318_SHARP_.call(null,topic)))){
return p1__71318_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__71318_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71321 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71321 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta71322){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta71322 = meta71322;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71323,meta71322__$1){
var self__ = this;
var _71323__$1 = this;
return (new cljs.core.async.t_cljs$core$async71321(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta71322__$1));
}));

(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71323){
var self__ = this;
var _71323__$1 = this;
return self__.meta71322;
}));

(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async71321.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async71321.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta71322","meta71322",931725491,null)], null);
}));

(cljs.core.async.t_cljs$core$async71321.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71321.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71321");

(cljs.core.async.t_cljs$core$async71321.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71321");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71321.
 */
cljs.core.async.__GT_t_cljs$core$async71321 = (function cljs$core$async$__GT_t_cljs$core$async71321(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta71322){
return (new cljs.core.async.t_cljs$core$async71321(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta71322));
});

}

return (new cljs.core.async.t_cljs$core$async71321(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__70370__auto___72507 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71395){
var state_val_71396 = (state_71395[(1)]);
if((state_val_71396 === (7))){
var inst_71391 = (state_71395[(2)]);
var state_71395__$1 = state_71395;
var statearr_71397_72509 = state_71395__$1;
(statearr_71397_72509[(2)] = inst_71391);

(statearr_71397_72509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (20))){
var state_71395__$1 = state_71395;
var statearr_71398_72510 = state_71395__$1;
(statearr_71398_72510[(2)] = null);

(statearr_71398_72510[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (1))){
var state_71395__$1 = state_71395;
var statearr_71399_72511 = state_71395__$1;
(statearr_71399_72511[(2)] = null);

(statearr_71399_72511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (24))){
var inst_71374 = (state_71395[(7)]);
var inst_71383 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_71374);
var state_71395__$1 = state_71395;
var statearr_71400_72515 = state_71395__$1;
(statearr_71400_72515[(2)] = inst_71383);

(statearr_71400_72515[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (4))){
var inst_71326 = (state_71395[(8)]);
var inst_71326__$1 = (state_71395[(2)]);
var inst_71327 = (inst_71326__$1 == null);
var state_71395__$1 = (function (){var statearr_71401 = state_71395;
(statearr_71401[(8)] = inst_71326__$1);

return statearr_71401;
})();
if(cljs.core.truth_(inst_71327)){
var statearr_71402_72516 = state_71395__$1;
(statearr_71402_72516[(1)] = (5));

} else {
var statearr_71403_72517 = state_71395__$1;
(statearr_71403_72517[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (15))){
var inst_71368 = (state_71395[(2)]);
var state_71395__$1 = state_71395;
var statearr_71404_72518 = state_71395__$1;
(statearr_71404_72518[(2)] = inst_71368);

(statearr_71404_72518[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (21))){
var inst_71388 = (state_71395[(2)]);
var state_71395__$1 = (function (){var statearr_71405 = state_71395;
(statearr_71405[(9)] = inst_71388);

return statearr_71405;
})();
var statearr_71406_72519 = state_71395__$1;
(statearr_71406_72519[(2)] = null);

(statearr_71406_72519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (13))){
var inst_71350 = (state_71395[(10)]);
var inst_71352 = cljs.core.chunked_seq_QMARK_(inst_71350);
var state_71395__$1 = state_71395;
if(inst_71352){
var statearr_71407_72520 = state_71395__$1;
(statearr_71407_72520[(1)] = (16));

} else {
var statearr_71408_72521 = state_71395__$1;
(statearr_71408_72521[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (22))){
var inst_71380 = (state_71395[(2)]);
var state_71395__$1 = state_71395;
if(cljs.core.truth_(inst_71380)){
var statearr_71409_72523 = state_71395__$1;
(statearr_71409_72523[(1)] = (23));

} else {
var statearr_71410_72524 = state_71395__$1;
(statearr_71410_72524[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (6))){
var inst_71376 = (state_71395[(11)]);
var inst_71374 = (state_71395[(7)]);
var inst_71326 = (state_71395[(8)]);
var inst_71374__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_71326) : topic_fn.call(null,inst_71326));
var inst_71375 = cljs.core.deref(mults);
var inst_71376__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71375,inst_71374__$1);
var state_71395__$1 = (function (){var statearr_71411 = state_71395;
(statearr_71411[(11)] = inst_71376__$1);

(statearr_71411[(7)] = inst_71374__$1);

return statearr_71411;
})();
if(cljs.core.truth_(inst_71376__$1)){
var statearr_71412_72528 = state_71395__$1;
(statearr_71412_72528[(1)] = (19));

} else {
var statearr_71413_72529 = state_71395__$1;
(statearr_71413_72529[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (25))){
var inst_71385 = (state_71395[(2)]);
var state_71395__$1 = state_71395;
var statearr_71414_72530 = state_71395__$1;
(statearr_71414_72530[(2)] = inst_71385);

(statearr_71414_72530[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (17))){
var inst_71350 = (state_71395[(10)]);
var inst_71359 = cljs.core.first(inst_71350);
var inst_71360 = cljs.core.async.muxch_STAR_(inst_71359);
var inst_71361 = cljs.core.async.close_BANG_(inst_71360);
var inst_71362 = cljs.core.next(inst_71350);
var inst_71336 = inst_71362;
var inst_71337 = null;
var inst_71338 = (0);
var inst_71339 = (0);
var state_71395__$1 = (function (){var statearr_71415 = state_71395;
(statearr_71415[(12)] = inst_71337);

(statearr_71415[(13)] = inst_71336);

(statearr_71415[(14)] = inst_71339);

(statearr_71415[(15)] = inst_71361);

(statearr_71415[(16)] = inst_71338);

return statearr_71415;
})();
var statearr_71416_72532 = state_71395__$1;
(statearr_71416_72532[(2)] = null);

(statearr_71416_72532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (3))){
var inst_71393 = (state_71395[(2)]);
var state_71395__$1 = state_71395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71395__$1,inst_71393);
} else {
if((state_val_71396 === (12))){
var inst_71370 = (state_71395[(2)]);
var state_71395__$1 = state_71395;
var statearr_71417_72533 = state_71395__$1;
(statearr_71417_72533[(2)] = inst_71370);

(statearr_71417_72533[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (2))){
var state_71395__$1 = state_71395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71395__$1,(4),ch);
} else {
if((state_val_71396 === (23))){
var state_71395__$1 = state_71395;
var statearr_71418_72537 = state_71395__$1;
(statearr_71418_72537[(2)] = null);

(statearr_71418_72537[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (19))){
var inst_71376 = (state_71395[(11)]);
var inst_71326 = (state_71395[(8)]);
var inst_71378 = cljs.core.async.muxch_STAR_(inst_71376);
var state_71395__$1 = state_71395;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71395__$1,(22),inst_71378,inst_71326);
} else {
if((state_val_71396 === (11))){
var inst_71336 = (state_71395[(13)]);
var inst_71350 = (state_71395[(10)]);
var inst_71350__$1 = cljs.core.seq(inst_71336);
var state_71395__$1 = (function (){var statearr_71419 = state_71395;
(statearr_71419[(10)] = inst_71350__$1);

return statearr_71419;
})();
if(inst_71350__$1){
var statearr_71420_72538 = state_71395__$1;
(statearr_71420_72538[(1)] = (13));

} else {
var statearr_71421_72539 = state_71395__$1;
(statearr_71421_72539[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (9))){
var inst_71372 = (state_71395[(2)]);
var state_71395__$1 = state_71395;
var statearr_71422_72540 = state_71395__$1;
(statearr_71422_72540[(2)] = inst_71372);

(statearr_71422_72540[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (5))){
var inst_71333 = cljs.core.deref(mults);
var inst_71334 = cljs.core.vals(inst_71333);
var inst_71335 = cljs.core.seq(inst_71334);
var inst_71336 = inst_71335;
var inst_71337 = null;
var inst_71338 = (0);
var inst_71339 = (0);
var state_71395__$1 = (function (){var statearr_71423 = state_71395;
(statearr_71423[(12)] = inst_71337);

(statearr_71423[(13)] = inst_71336);

(statearr_71423[(14)] = inst_71339);

(statearr_71423[(16)] = inst_71338);

return statearr_71423;
})();
var statearr_71424_72541 = state_71395__$1;
(statearr_71424_72541[(2)] = null);

(statearr_71424_72541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (14))){
var state_71395__$1 = state_71395;
var statearr_71428_72542 = state_71395__$1;
(statearr_71428_72542[(2)] = null);

(statearr_71428_72542[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (16))){
var inst_71350 = (state_71395[(10)]);
var inst_71354 = cljs.core.chunk_first(inst_71350);
var inst_71355 = cljs.core.chunk_rest(inst_71350);
var inst_71356 = cljs.core.count(inst_71354);
var inst_71336 = inst_71355;
var inst_71337 = inst_71354;
var inst_71338 = inst_71356;
var inst_71339 = (0);
var state_71395__$1 = (function (){var statearr_71429 = state_71395;
(statearr_71429[(12)] = inst_71337);

(statearr_71429[(13)] = inst_71336);

(statearr_71429[(14)] = inst_71339);

(statearr_71429[(16)] = inst_71338);

return statearr_71429;
})();
var statearr_71430_72546 = state_71395__$1;
(statearr_71430_72546[(2)] = null);

(statearr_71430_72546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (10))){
var inst_71337 = (state_71395[(12)]);
var inst_71336 = (state_71395[(13)]);
var inst_71339 = (state_71395[(14)]);
var inst_71338 = (state_71395[(16)]);
var inst_71344 = cljs.core._nth(inst_71337,inst_71339);
var inst_71345 = cljs.core.async.muxch_STAR_(inst_71344);
var inst_71346 = cljs.core.async.close_BANG_(inst_71345);
var inst_71347 = (inst_71339 + (1));
var tmp71425 = inst_71337;
var tmp71426 = inst_71336;
var tmp71427 = inst_71338;
var inst_71336__$1 = tmp71426;
var inst_71337__$1 = tmp71425;
var inst_71338__$1 = tmp71427;
var inst_71339__$1 = inst_71347;
var state_71395__$1 = (function (){var statearr_71431 = state_71395;
(statearr_71431[(12)] = inst_71337__$1);

(statearr_71431[(17)] = inst_71346);

(statearr_71431[(13)] = inst_71336__$1);

(statearr_71431[(14)] = inst_71339__$1);

(statearr_71431[(16)] = inst_71338__$1);

return statearr_71431;
})();
var statearr_71432_72547 = state_71395__$1;
(statearr_71432_72547[(2)] = null);

(statearr_71432_72547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (18))){
var inst_71365 = (state_71395[(2)]);
var state_71395__$1 = state_71395;
var statearr_71433_72548 = state_71395__$1;
(statearr_71433_72548[(2)] = inst_71365);

(statearr_71433_72548[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71396 === (8))){
var inst_71339 = (state_71395[(14)]);
var inst_71338 = (state_71395[(16)]);
var inst_71341 = (inst_71339 < inst_71338);
var inst_71342 = inst_71341;
var state_71395__$1 = state_71395;
if(cljs.core.truth_(inst_71342)){
var statearr_71434_72549 = state_71395__$1;
(statearr_71434_72549[(1)] = (10));

} else {
var statearr_71435_72550 = state_71395__$1;
(statearr_71435_72550[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_71436 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71436[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_71436[(1)] = (1));

return statearr_71436;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_71395){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71395);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71437){var ex__70338__auto__ = e71437;
var statearr_71438_72551 = state_71395;
(statearr_71438_72551[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71395[(4)]))){
var statearr_71439_72552 = state_71395;
(statearr_71439_72552[(1)] = cljs.core.first((state_71395[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72553 = state_71395;
state_71395 = G__72553;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_71395){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_71395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71440 = f__70371__auto__();
(statearr_71440[(6)] = c__70370__auto___72507);

return statearr_71440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__71442 = arguments.length;
switch (G__71442) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__71444 = arguments.length;
switch (G__71444) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__71446 = arguments.length;
switch (G__71446) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__70370__auto___72560 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71489){
var state_val_71490 = (state_71489[(1)]);
if((state_val_71490 === (7))){
var state_71489__$1 = state_71489;
var statearr_71491_72564 = state_71489__$1;
(statearr_71491_72564[(2)] = null);

(statearr_71491_72564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (1))){
var state_71489__$1 = state_71489;
var statearr_71492_72565 = state_71489__$1;
(statearr_71492_72565[(2)] = null);

(statearr_71492_72565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (4))){
var inst_71450 = (state_71489[(7)]);
var inst_71449 = (state_71489[(8)]);
var inst_71452 = (inst_71450 < inst_71449);
var state_71489__$1 = state_71489;
if(cljs.core.truth_(inst_71452)){
var statearr_71493_72566 = state_71489__$1;
(statearr_71493_72566[(1)] = (6));

} else {
var statearr_71494_72567 = state_71489__$1;
(statearr_71494_72567[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (15))){
var inst_71475 = (state_71489[(9)]);
var inst_71480 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_71475);
var state_71489__$1 = state_71489;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71489__$1,(17),out,inst_71480);
} else {
if((state_val_71490 === (13))){
var inst_71475 = (state_71489[(9)]);
var inst_71475__$1 = (state_71489[(2)]);
var inst_71476 = cljs.core.some(cljs.core.nil_QMARK_,inst_71475__$1);
var state_71489__$1 = (function (){var statearr_71495 = state_71489;
(statearr_71495[(9)] = inst_71475__$1);

return statearr_71495;
})();
if(cljs.core.truth_(inst_71476)){
var statearr_71496_72571 = state_71489__$1;
(statearr_71496_72571[(1)] = (14));

} else {
var statearr_71497_72572 = state_71489__$1;
(statearr_71497_72572[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (6))){
var state_71489__$1 = state_71489;
var statearr_71498_72573 = state_71489__$1;
(statearr_71498_72573[(2)] = null);

(statearr_71498_72573[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (17))){
var inst_71482 = (state_71489[(2)]);
var state_71489__$1 = (function (){var statearr_71500 = state_71489;
(statearr_71500[(10)] = inst_71482);

return statearr_71500;
})();
var statearr_71501_72574 = state_71489__$1;
(statearr_71501_72574[(2)] = null);

(statearr_71501_72574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (3))){
var inst_71487 = (state_71489[(2)]);
var state_71489__$1 = state_71489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71489__$1,inst_71487);
} else {
if((state_val_71490 === (12))){
var _ = (function (){var statearr_71502 = state_71489;
(statearr_71502[(4)] = cljs.core.rest((state_71489[(4)])));

return statearr_71502;
})();
var state_71489__$1 = state_71489;
var ex71499 = (state_71489__$1[(2)]);
var statearr_71503_72575 = state_71489__$1;
(statearr_71503_72575[(5)] = ex71499);


if((ex71499 instanceof Object)){
var statearr_71504_72576 = state_71489__$1;
(statearr_71504_72576[(1)] = (11));

(statearr_71504_72576[(5)] = null);

} else {
throw ex71499;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (2))){
var inst_71448 = cljs.core.reset_BANG_(dctr,cnt);
var inst_71449 = cnt;
var inst_71450 = (0);
var state_71489__$1 = (function (){var statearr_71505 = state_71489;
(statearr_71505[(7)] = inst_71450);

(statearr_71505[(11)] = inst_71448);

(statearr_71505[(8)] = inst_71449);

return statearr_71505;
})();
var statearr_71506_72577 = state_71489__$1;
(statearr_71506_72577[(2)] = null);

(statearr_71506_72577[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (11))){
var inst_71454 = (state_71489[(2)]);
var inst_71455 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_71489__$1 = (function (){var statearr_71507 = state_71489;
(statearr_71507[(12)] = inst_71454);

return statearr_71507;
})();
var statearr_71508_72578 = state_71489__$1;
(statearr_71508_72578[(2)] = inst_71455);

(statearr_71508_72578[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (9))){
var inst_71450 = (state_71489[(7)]);
var _ = (function (){var statearr_71509 = state_71489;
(statearr_71509[(4)] = cljs.core.cons((12),(state_71489[(4)])));

return statearr_71509;
})();
var inst_71461 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_71450) : chs__$1.call(null,inst_71450));
var inst_71462 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_71450) : done.call(null,inst_71450));
var inst_71463 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_71461,inst_71462);
var ___$1 = (function (){var statearr_71510 = state_71489;
(statearr_71510[(4)] = cljs.core.rest((state_71489[(4)])));

return statearr_71510;
})();
var state_71489__$1 = state_71489;
var statearr_71511_72579 = state_71489__$1;
(statearr_71511_72579[(2)] = inst_71463);

(statearr_71511_72579[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (5))){
var inst_71473 = (state_71489[(2)]);
var state_71489__$1 = (function (){var statearr_71512 = state_71489;
(statearr_71512[(13)] = inst_71473);

return statearr_71512;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71489__$1,(13),dchan);
} else {
if((state_val_71490 === (14))){
var inst_71478 = cljs.core.async.close_BANG_(out);
var state_71489__$1 = state_71489;
var statearr_71513_72580 = state_71489__$1;
(statearr_71513_72580[(2)] = inst_71478);

(statearr_71513_72580[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (16))){
var inst_71485 = (state_71489[(2)]);
var state_71489__$1 = state_71489;
var statearr_71514_72581 = state_71489__$1;
(statearr_71514_72581[(2)] = inst_71485);

(statearr_71514_72581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (10))){
var inst_71450 = (state_71489[(7)]);
var inst_71466 = (state_71489[(2)]);
var inst_71467 = (inst_71450 + (1));
var inst_71450__$1 = inst_71467;
var state_71489__$1 = (function (){var statearr_71515 = state_71489;
(statearr_71515[(7)] = inst_71450__$1);

(statearr_71515[(14)] = inst_71466);

return statearr_71515;
})();
var statearr_71516_72582 = state_71489__$1;
(statearr_71516_72582[(2)] = null);

(statearr_71516_72582[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71490 === (8))){
var inst_71471 = (state_71489[(2)]);
var state_71489__$1 = state_71489;
var statearr_71517_72583 = state_71489__$1;
(statearr_71517_72583[(2)] = inst_71471);

(statearr_71517_72583[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_71518 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71518[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_71518[(1)] = (1));

return statearr_71518;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_71489){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71489);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71519){var ex__70338__auto__ = e71519;
var statearr_71520_72584 = state_71489;
(statearr_71520_72584[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71489[(4)]))){
var statearr_71521_72585 = state_71489;
(statearr_71521_72585[(1)] = cljs.core.first((state_71489[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72586 = state_71489;
state_71489 = G__72586;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_71489){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_71489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71522 = f__70371__auto__();
(statearr_71522[(6)] = c__70370__auto___72560);

return statearr_71522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__71525 = arguments.length;
switch (G__71525) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70370__auto___72588 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71557){
var state_val_71558 = (state_71557[(1)]);
if((state_val_71558 === (7))){
var inst_71536 = (state_71557[(7)]);
var inst_71537 = (state_71557[(8)]);
var inst_71536__$1 = (state_71557[(2)]);
var inst_71537__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71536__$1,(0),null);
var inst_71538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71536__$1,(1),null);
var inst_71539 = (inst_71537__$1 == null);
var state_71557__$1 = (function (){var statearr_71559 = state_71557;
(statearr_71559[(9)] = inst_71538);

(statearr_71559[(7)] = inst_71536__$1);

(statearr_71559[(8)] = inst_71537__$1);

return statearr_71559;
})();
if(cljs.core.truth_(inst_71539)){
var statearr_71560_72589 = state_71557__$1;
(statearr_71560_72589[(1)] = (8));

} else {
var statearr_71561_72590 = state_71557__$1;
(statearr_71561_72590[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71558 === (1))){
var inst_71526 = cljs.core.vec(chs);
var inst_71527 = inst_71526;
var state_71557__$1 = (function (){var statearr_71562 = state_71557;
(statearr_71562[(10)] = inst_71527);

return statearr_71562;
})();
var statearr_71563_72591 = state_71557__$1;
(statearr_71563_72591[(2)] = null);

(statearr_71563_72591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71558 === (4))){
var inst_71527 = (state_71557[(10)]);
var state_71557__$1 = state_71557;
return cljs.core.async.ioc_alts_BANG_(state_71557__$1,(7),inst_71527);
} else {
if((state_val_71558 === (6))){
var inst_71553 = (state_71557[(2)]);
var state_71557__$1 = state_71557;
var statearr_71564_72592 = state_71557__$1;
(statearr_71564_72592[(2)] = inst_71553);

(statearr_71564_72592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71558 === (3))){
var inst_71555 = (state_71557[(2)]);
var state_71557__$1 = state_71557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71557__$1,inst_71555);
} else {
if((state_val_71558 === (2))){
var inst_71527 = (state_71557[(10)]);
var inst_71529 = cljs.core.count(inst_71527);
var inst_71530 = (inst_71529 > (0));
var state_71557__$1 = state_71557;
if(cljs.core.truth_(inst_71530)){
var statearr_71566_72593 = state_71557__$1;
(statearr_71566_72593[(1)] = (4));

} else {
var statearr_71567_72594 = state_71557__$1;
(statearr_71567_72594[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71558 === (11))){
var inst_71527 = (state_71557[(10)]);
var inst_71546 = (state_71557[(2)]);
var tmp71565 = inst_71527;
var inst_71527__$1 = tmp71565;
var state_71557__$1 = (function (){var statearr_71568 = state_71557;
(statearr_71568[(10)] = inst_71527__$1);

(statearr_71568[(11)] = inst_71546);

return statearr_71568;
})();
var statearr_71569_72595 = state_71557__$1;
(statearr_71569_72595[(2)] = null);

(statearr_71569_72595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71558 === (9))){
var inst_71537 = (state_71557[(8)]);
var state_71557__$1 = state_71557;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71557__$1,(11),out,inst_71537);
} else {
if((state_val_71558 === (5))){
var inst_71551 = cljs.core.async.close_BANG_(out);
var state_71557__$1 = state_71557;
var statearr_71570_72596 = state_71557__$1;
(statearr_71570_72596[(2)] = inst_71551);

(statearr_71570_72596[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71558 === (10))){
var inst_71549 = (state_71557[(2)]);
var state_71557__$1 = state_71557;
var statearr_71571_72597 = state_71557__$1;
(statearr_71571_72597[(2)] = inst_71549);

(statearr_71571_72597[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71558 === (8))){
var inst_71527 = (state_71557[(10)]);
var inst_71538 = (state_71557[(9)]);
var inst_71536 = (state_71557[(7)]);
var inst_71537 = (state_71557[(8)]);
var inst_71541 = (function (){var cs = inst_71527;
var vec__71532 = inst_71536;
var v = inst_71537;
var c = inst_71538;
return (function (p1__71523_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__71523_SHARP_);
});
})();
var inst_71542 = cljs.core.filterv(inst_71541,inst_71527);
var inst_71527__$1 = inst_71542;
var state_71557__$1 = (function (){var statearr_71572 = state_71557;
(statearr_71572[(10)] = inst_71527__$1);

return statearr_71572;
})();
var statearr_71573_72598 = state_71557__$1;
(statearr_71573_72598[(2)] = null);

(statearr_71573_72598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_71574 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71574[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_71574[(1)] = (1));

return statearr_71574;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_71557){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71557);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71575){var ex__70338__auto__ = e71575;
var statearr_71576_72599 = state_71557;
(statearr_71576_72599[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71557[(4)]))){
var statearr_71577_72600 = state_71557;
(statearr_71577_72600[(1)] = cljs.core.first((state_71557[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72601 = state_71557;
state_71557 = G__72601;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_71557){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_71557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71578 = f__70371__auto__();
(statearr_71578[(6)] = c__70370__auto___72588);

return statearr_71578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__71580 = arguments.length;
switch (G__71580) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70370__auto___72603 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71604){
var state_val_71605 = (state_71604[(1)]);
if((state_val_71605 === (7))){
var inst_71586 = (state_71604[(7)]);
var inst_71586__$1 = (state_71604[(2)]);
var inst_71587 = (inst_71586__$1 == null);
var inst_71588 = cljs.core.not(inst_71587);
var state_71604__$1 = (function (){var statearr_71606 = state_71604;
(statearr_71606[(7)] = inst_71586__$1);

return statearr_71606;
})();
if(inst_71588){
var statearr_71607_72604 = state_71604__$1;
(statearr_71607_72604[(1)] = (8));

} else {
var statearr_71608_72605 = state_71604__$1;
(statearr_71608_72605[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71605 === (1))){
var inst_71581 = (0);
var state_71604__$1 = (function (){var statearr_71609 = state_71604;
(statearr_71609[(8)] = inst_71581);

return statearr_71609;
})();
var statearr_71610_72606 = state_71604__$1;
(statearr_71610_72606[(2)] = null);

(statearr_71610_72606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71605 === (4))){
var state_71604__$1 = state_71604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71604__$1,(7),ch);
} else {
if((state_val_71605 === (6))){
var inst_71599 = (state_71604[(2)]);
var state_71604__$1 = state_71604;
var statearr_71611_72607 = state_71604__$1;
(statearr_71611_72607[(2)] = inst_71599);

(statearr_71611_72607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71605 === (3))){
var inst_71601 = (state_71604[(2)]);
var inst_71602 = cljs.core.async.close_BANG_(out);
var state_71604__$1 = (function (){var statearr_71612 = state_71604;
(statearr_71612[(9)] = inst_71601);

return statearr_71612;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_71604__$1,inst_71602);
} else {
if((state_val_71605 === (2))){
var inst_71581 = (state_71604[(8)]);
var inst_71583 = (inst_71581 < n);
var state_71604__$1 = state_71604;
if(cljs.core.truth_(inst_71583)){
var statearr_71613_72612 = state_71604__$1;
(statearr_71613_72612[(1)] = (4));

} else {
var statearr_71614_72613 = state_71604__$1;
(statearr_71614_72613[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71605 === (11))){
var inst_71581 = (state_71604[(8)]);
var inst_71591 = (state_71604[(2)]);
var inst_71592 = (inst_71581 + (1));
var inst_71581__$1 = inst_71592;
var state_71604__$1 = (function (){var statearr_71615 = state_71604;
(statearr_71615[(10)] = inst_71591);

(statearr_71615[(8)] = inst_71581__$1);

return statearr_71615;
})();
var statearr_71616_72614 = state_71604__$1;
(statearr_71616_72614[(2)] = null);

(statearr_71616_72614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71605 === (9))){
var state_71604__$1 = state_71604;
var statearr_71617_72615 = state_71604__$1;
(statearr_71617_72615[(2)] = null);

(statearr_71617_72615[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71605 === (5))){
var state_71604__$1 = state_71604;
var statearr_71618_72616 = state_71604__$1;
(statearr_71618_72616[(2)] = null);

(statearr_71618_72616[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71605 === (10))){
var inst_71596 = (state_71604[(2)]);
var state_71604__$1 = state_71604;
var statearr_71619_72617 = state_71604__$1;
(statearr_71619_72617[(2)] = inst_71596);

(statearr_71619_72617[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71605 === (8))){
var inst_71586 = (state_71604[(7)]);
var state_71604__$1 = state_71604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71604__$1,(11),out,inst_71586);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_71620 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71620[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_71620[(1)] = (1));

return statearr_71620;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_71604){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71604);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71621){var ex__70338__auto__ = e71621;
var statearr_71622_72618 = state_71604;
(statearr_71622_72618[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71604[(4)]))){
var statearr_71623_72619 = state_71604;
(statearr_71623_72619[(1)] = cljs.core.first((state_71604[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72620 = state_71604;
state_71604 = G__72620;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_71604){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_71604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71624 = f__70371__auto__();
(statearr_71624[(6)] = c__70370__auto___72603);

return statearr_71624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71626 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71626 = (function (f,ch,meta71627){
this.f = f;
this.ch = ch;
this.meta71627 = meta71627;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71628,meta71627__$1){
var self__ = this;
var _71628__$1 = this;
return (new cljs.core.async.t_cljs$core$async71626(self__.f,self__.ch,meta71627__$1));
}));

(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71628){
var self__ = this;
var _71628__$1 = this;
return self__.meta71627;
}));

(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71629 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71629 = (function (f,ch,meta71627,_,fn1,meta71630){
this.f = f;
this.ch = ch;
this.meta71627 = meta71627;
this._ = _;
this.fn1 = fn1;
this.meta71630 = meta71630;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71629.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71631,meta71630__$1){
var self__ = this;
var _71631__$1 = this;
return (new cljs.core.async.t_cljs$core$async71629(self__.f,self__.ch,self__.meta71627,self__._,self__.fn1,meta71630__$1));
}));

(cljs.core.async.t_cljs$core$async71629.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71631){
var self__ = this;
var _71631__$1 = this;
return self__.meta71630;
}));

(cljs.core.async.t_cljs$core$async71629.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71629.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async71629.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async71629.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__71625_SHARP_){
var G__71632 = (((p1__71625_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__71625_SHARP_) : self__.f.call(null,p1__71625_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__71632) : f1.call(null,G__71632));
});
}));

(cljs.core.async.t_cljs$core$async71629.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta71627","meta71627",1966003181,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async71626","cljs.core.async/t_cljs$core$async71626",-736011314,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta71630","meta71630",409972826,null)], null);
}));

(cljs.core.async.t_cljs$core$async71629.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71629.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71629");

(cljs.core.async.t_cljs$core$async71629.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71629");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71629.
 */
cljs.core.async.__GT_t_cljs$core$async71629 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async71629(f__$1,ch__$1,meta71627__$1,___$2,fn1__$1,meta71630){
return (new cljs.core.async.t_cljs$core$async71629(f__$1,ch__$1,meta71627__$1,___$2,fn1__$1,meta71630));
});

}

return (new cljs.core.async.t_cljs$core$async71629(self__.f,self__.ch,self__.meta71627,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4109__auto__ = ret;
if(cljs.core.truth_(and__4109__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4109__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__71633 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__71633) : self__.f.call(null,G__71633));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71626.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async71626.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta71627","meta71627",1966003181,null)], null);
}));

(cljs.core.async.t_cljs$core$async71626.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71626.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71626");

(cljs.core.async.t_cljs$core$async71626.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71626");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71626.
 */
cljs.core.async.__GT_t_cljs$core$async71626 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async71626(f__$1,ch__$1,meta71627){
return (new cljs.core.async.t_cljs$core$async71626(f__$1,ch__$1,meta71627));
});

}

return (new cljs.core.async.t_cljs$core$async71626(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71634 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71634 = (function (f,ch,meta71635){
this.f = f;
this.ch = ch;
this.meta71635 = meta71635;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71634.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71636,meta71635__$1){
var self__ = this;
var _71636__$1 = this;
return (new cljs.core.async.t_cljs$core$async71634(self__.f,self__.ch,meta71635__$1));
}));

(cljs.core.async.t_cljs$core$async71634.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71636){
var self__ = this;
var _71636__$1 = this;
return self__.meta71635;
}));

(cljs.core.async.t_cljs$core$async71634.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71634.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async71634.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71634.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async71634.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71634.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async71634.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta71635","meta71635",1641964996,null)], null);
}));

(cljs.core.async.t_cljs$core$async71634.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71634.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71634");

(cljs.core.async.t_cljs$core$async71634.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71634");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71634.
 */
cljs.core.async.__GT_t_cljs$core$async71634 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async71634(f__$1,ch__$1,meta71635){
return (new cljs.core.async.t_cljs$core$async71634(f__$1,ch__$1,meta71635));
});

}

return (new cljs.core.async.t_cljs$core$async71634(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71637 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71637 = (function (p,ch,meta71638){
this.p = p;
this.ch = ch;
this.meta71638 = meta71638;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71639,meta71638__$1){
var self__ = this;
var _71639__$1 = this;
return (new cljs.core.async.t_cljs$core$async71637(self__.p,self__.ch,meta71638__$1));
}));

(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71639){
var self__ = this;
var _71639__$1 = this;
return self__.meta71638;
}));

(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71637.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async71637.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta71638","meta71638",242023686,null)], null);
}));

(cljs.core.async.t_cljs$core$async71637.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71637.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71637");

(cljs.core.async.t_cljs$core$async71637.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71637");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71637.
 */
cljs.core.async.__GT_t_cljs$core$async71637 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async71637(p__$1,ch__$1,meta71638){
return (new cljs.core.async.t_cljs$core$async71637(p__$1,ch__$1,meta71638));
});

}

return (new cljs.core.async.t_cljs$core$async71637(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__71641 = arguments.length;
switch (G__71641) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70370__auto___72629 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71662){
var state_val_71663 = (state_71662[(1)]);
if((state_val_71663 === (7))){
var inst_71658 = (state_71662[(2)]);
var state_71662__$1 = state_71662;
var statearr_71664_72630 = state_71662__$1;
(statearr_71664_72630[(2)] = inst_71658);

(statearr_71664_72630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71663 === (1))){
var state_71662__$1 = state_71662;
var statearr_71665_72631 = state_71662__$1;
(statearr_71665_72631[(2)] = null);

(statearr_71665_72631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71663 === (4))){
var inst_71644 = (state_71662[(7)]);
var inst_71644__$1 = (state_71662[(2)]);
var inst_71645 = (inst_71644__$1 == null);
var state_71662__$1 = (function (){var statearr_71666 = state_71662;
(statearr_71666[(7)] = inst_71644__$1);

return statearr_71666;
})();
if(cljs.core.truth_(inst_71645)){
var statearr_71667_72632 = state_71662__$1;
(statearr_71667_72632[(1)] = (5));

} else {
var statearr_71668_72633 = state_71662__$1;
(statearr_71668_72633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71663 === (6))){
var inst_71644 = (state_71662[(7)]);
var inst_71649 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_71644) : p.call(null,inst_71644));
var state_71662__$1 = state_71662;
if(cljs.core.truth_(inst_71649)){
var statearr_71669_72634 = state_71662__$1;
(statearr_71669_72634[(1)] = (8));

} else {
var statearr_71670_72635 = state_71662__$1;
(statearr_71670_72635[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71663 === (3))){
var inst_71660 = (state_71662[(2)]);
var state_71662__$1 = state_71662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71662__$1,inst_71660);
} else {
if((state_val_71663 === (2))){
var state_71662__$1 = state_71662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71662__$1,(4),ch);
} else {
if((state_val_71663 === (11))){
var inst_71652 = (state_71662[(2)]);
var state_71662__$1 = state_71662;
var statearr_71671_72636 = state_71662__$1;
(statearr_71671_72636[(2)] = inst_71652);

(statearr_71671_72636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71663 === (9))){
var state_71662__$1 = state_71662;
var statearr_71672_72637 = state_71662__$1;
(statearr_71672_72637[(2)] = null);

(statearr_71672_72637[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71663 === (5))){
var inst_71647 = cljs.core.async.close_BANG_(out);
var state_71662__$1 = state_71662;
var statearr_71673_72638 = state_71662__$1;
(statearr_71673_72638[(2)] = inst_71647);

(statearr_71673_72638[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71663 === (10))){
var inst_71655 = (state_71662[(2)]);
var state_71662__$1 = (function (){var statearr_71674 = state_71662;
(statearr_71674[(8)] = inst_71655);

return statearr_71674;
})();
var statearr_71675_72639 = state_71662__$1;
(statearr_71675_72639[(2)] = null);

(statearr_71675_72639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71663 === (8))){
var inst_71644 = (state_71662[(7)]);
var state_71662__$1 = state_71662;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71662__$1,(11),out,inst_71644);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_71676 = [null,null,null,null,null,null,null,null,null];
(statearr_71676[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_71676[(1)] = (1));

return statearr_71676;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_71662){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71662);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71677){var ex__70338__auto__ = e71677;
var statearr_71678_72640 = state_71662;
(statearr_71678_72640[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71662[(4)]))){
var statearr_71679_72641 = state_71662;
(statearr_71679_72641[(1)] = cljs.core.first((state_71662[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72642 = state_71662;
state_71662 = G__72642;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_71662){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_71662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71680 = f__70371__auto__();
(statearr_71680[(6)] = c__70370__auto___72629);

return statearr_71680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__71682 = arguments.length;
switch (G__71682) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__70370__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71744){
var state_val_71745 = (state_71744[(1)]);
if((state_val_71745 === (7))){
var inst_71740 = (state_71744[(2)]);
var state_71744__$1 = state_71744;
var statearr_71746_72644 = state_71744__$1;
(statearr_71746_72644[(2)] = inst_71740);

(statearr_71746_72644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (20))){
var inst_71710 = (state_71744[(7)]);
var inst_71721 = (state_71744[(2)]);
var inst_71722 = cljs.core.next(inst_71710);
var inst_71696 = inst_71722;
var inst_71697 = null;
var inst_71698 = (0);
var inst_71699 = (0);
var state_71744__$1 = (function (){var statearr_71747 = state_71744;
(statearr_71747[(8)] = inst_71699);

(statearr_71747[(9)] = inst_71697);

(statearr_71747[(10)] = inst_71696);

(statearr_71747[(11)] = inst_71721);

(statearr_71747[(12)] = inst_71698);

return statearr_71747;
})();
var statearr_71748_72645 = state_71744__$1;
(statearr_71748_72645[(2)] = null);

(statearr_71748_72645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (1))){
var state_71744__$1 = state_71744;
var statearr_71749_72646 = state_71744__$1;
(statearr_71749_72646[(2)] = null);

(statearr_71749_72646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (4))){
var inst_71685 = (state_71744[(13)]);
var inst_71685__$1 = (state_71744[(2)]);
var inst_71686 = (inst_71685__$1 == null);
var state_71744__$1 = (function (){var statearr_71750 = state_71744;
(statearr_71750[(13)] = inst_71685__$1);

return statearr_71750;
})();
if(cljs.core.truth_(inst_71686)){
var statearr_71751_72647 = state_71744__$1;
(statearr_71751_72647[(1)] = (5));

} else {
var statearr_71752_72648 = state_71744__$1;
(statearr_71752_72648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (15))){
var state_71744__$1 = state_71744;
var statearr_71756_72649 = state_71744__$1;
(statearr_71756_72649[(2)] = null);

(statearr_71756_72649[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (21))){
var state_71744__$1 = state_71744;
var statearr_71757_72651 = state_71744__$1;
(statearr_71757_72651[(2)] = null);

(statearr_71757_72651[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (13))){
var inst_71699 = (state_71744[(8)]);
var inst_71697 = (state_71744[(9)]);
var inst_71696 = (state_71744[(10)]);
var inst_71698 = (state_71744[(12)]);
var inst_71706 = (state_71744[(2)]);
var inst_71707 = (inst_71699 + (1));
var tmp71753 = inst_71697;
var tmp71754 = inst_71696;
var tmp71755 = inst_71698;
var inst_71696__$1 = tmp71754;
var inst_71697__$1 = tmp71753;
var inst_71698__$1 = tmp71755;
var inst_71699__$1 = inst_71707;
var state_71744__$1 = (function (){var statearr_71758 = state_71744;
(statearr_71758[(8)] = inst_71699__$1);

(statearr_71758[(9)] = inst_71697__$1);

(statearr_71758[(10)] = inst_71696__$1);

(statearr_71758[(14)] = inst_71706);

(statearr_71758[(12)] = inst_71698__$1);

return statearr_71758;
})();
var statearr_71759_72654 = state_71744__$1;
(statearr_71759_72654[(2)] = null);

(statearr_71759_72654[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (22))){
var state_71744__$1 = state_71744;
var statearr_71760_72655 = state_71744__$1;
(statearr_71760_72655[(2)] = null);

(statearr_71760_72655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (6))){
var inst_71685 = (state_71744[(13)]);
var inst_71694 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_71685) : f.call(null,inst_71685));
var inst_71695 = cljs.core.seq(inst_71694);
var inst_71696 = inst_71695;
var inst_71697 = null;
var inst_71698 = (0);
var inst_71699 = (0);
var state_71744__$1 = (function (){var statearr_71761 = state_71744;
(statearr_71761[(8)] = inst_71699);

(statearr_71761[(9)] = inst_71697);

(statearr_71761[(10)] = inst_71696);

(statearr_71761[(12)] = inst_71698);

return statearr_71761;
})();
var statearr_71762_72657 = state_71744__$1;
(statearr_71762_72657[(2)] = null);

(statearr_71762_72657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (17))){
var inst_71710 = (state_71744[(7)]);
var inst_71714 = cljs.core.chunk_first(inst_71710);
var inst_71715 = cljs.core.chunk_rest(inst_71710);
var inst_71716 = cljs.core.count(inst_71714);
var inst_71696 = inst_71715;
var inst_71697 = inst_71714;
var inst_71698 = inst_71716;
var inst_71699 = (0);
var state_71744__$1 = (function (){var statearr_71763 = state_71744;
(statearr_71763[(8)] = inst_71699);

(statearr_71763[(9)] = inst_71697);

(statearr_71763[(10)] = inst_71696);

(statearr_71763[(12)] = inst_71698);

return statearr_71763;
})();
var statearr_71764_72658 = state_71744__$1;
(statearr_71764_72658[(2)] = null);

(statearr_71764_72658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (3))){
var inst_71742 = (state_71744[(2)]);
var state_71744__$1 = state_71744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71744__$1,inst_71742);
} else {
if((state_val_71745 === (12))){
var inst_71730 = (state_71744[(2)]);
var state_71744__$1 = state_71744;
var statearr_71765_72659 = state_71744__$1;
(statearr_71765_72659[(2)] = inst_71730);

(statearr_71765_72659[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (2))){
var state_71744__$1 = state_71744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71744__$1,(4),in$);
} else {
if((state_val_71745 === (23))){
var inst_71738 = (state_71744[(2)]);
var state_71744__$1 = state_71744;
var statearr_71766_72660 = state_71744__$1;
(statearr_71766_72660[(2)] = inst_71738);

(statearr_71766_72660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (19))){
var inst_71725 = (state_71744[(2)]);
var state_71744__$1 = state_71744;
var statearr_71767_72661 = state_71744__$1;
(statearr_71767_72661[(2)] = inst_71725);

(statearr_71767_72661[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (11))){
var inst_71710 = (state_71744[(7)]);
var inst_71696 = (state_71744[(10)]);
var inst_71710__$1 = cljs.core.seq(inst_71696);
var state_71744__$1 = (function (){var statearr_71768 = state_71744;
(statearr_71768[(7)] = inst_71710__$1);

return statearr_71768;
})();
if(inst_71710__$1){
var statearr_71769_72662 = state_71744__$1;
(statearr_71769_72662[(1)] = (14));

} else {
var statearr_71770_72663 = state_71744__$1;
(statearr_71770_72663[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (9))){
var inst_71732 = (state_71744[(2)]);
var inst_71733 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_71744__$1 = (function (){var statearr_71771 = state_71744;
(statearr_71771[(15)] = inst_71732);

return statearr_71771;
})();
if(cljs.core.truth_(inst_71733)){
var statearr_71772_72664 = state_71744__$1;
(statearr_71772_72664[(1)] = (21));

} else {
var statearr_71773_72665 = state_71744__$1;
(statearr_71773_72665[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (5))){
var inst_71688 = cljs.core.async.close_BANG_(out);
var state_71744__$1 = state_71744;
var statearr_71774_72668 = state_71744__$1;
(statearr_71774_72668[(2)] = inst_71688);

(statearr_71774_72668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (14))){
var inst_71710 = (state_71744[(7)]);
var inst_71712 = cljs.core.chunked_seq_QMARK_(inst_71710);
var state_71744__$1 = state_71744;
if(inst_71712){
var statearr_71775_72669 = state_71744__$1;
(statearr_71775_72669[(1)] = (17));

} else {
var statearr_71776_72670 = state_71744__$1;
(statearr_71776_72670[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (16))){
var inst_71728 = (state_71744[(2)]);
var state_71744__$1 = state_71744;
var statearr_71777_72671 = state_71744__$1;
(statearr_71777_72671[(2)] = inst_71728);

(statearr_71777_72671[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71745 === (10))){
var inst_71699 = (state_71744[(8)]);
var inst_71697 = (state_71744[(9)]);
var inst_71704 = cljs.core._nth(inst_71697,inst_71699);
var state_71744__$1 = state_71744;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71744__$1,(13),out,inst_71704);
} else {
if((state_val_71745 === (18))){
var inst_71710 = (state_71744[(7)]);
var inst_71719 = cljs.core.first(inst_71710);
var state_71744__$1 = state_71744;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71744__$1,(20),out,inst_71719);
} else {
if((state_val_71745 === (8))){
var inst_71699 = (state_71744[(8)]);
var inst_71698 = (state_71744[(12)]);
var inst_71701 = (inst_71699 < inst_71698);
var inst_71702 = inst_71701;
var state_71744__$1 = state_71744;
if(cljs.core.truth_(inst_71702)){
var statearr_71778_72672 = state_71744__$1;
(statearr_71778_72672[(1)] = (10));

} else {
var statearr_71779_72673 = state_71744__$1;
(statearr_71779_72673[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__70335__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__70335__auto____0 = (function (){
var statearr_71780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71780[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__70335__auto__);

(statearr_71780[(1)] = (1));

return statearr_71780;
});
var cljs$core$async$mapcat_STAR__$_state_machine__70335__auto____1 = (function (state_71744){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71744);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71781){var ex__70338__auto__ = e71781;
var statearr_71782_72674 = state_71744;
(statearr_71782_72674[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71744[(4)]))){
var statearr_71783_72675 = state_71744;
(statearr_71783_72675[(1)] = cljs.core.first((state_71744[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72676 = state_71744;
state_71744 = G__72676;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__70335__auto__ = function(state_71744){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__70335__auto____1.call(this,state_71744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__70335__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__70335__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71784 = f__70371__auto__();
(statearr_71784[(6)] = c__70370__auto__);

return statearr_71784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));

return c__70370__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__71786 = arguments.length;
switch (G__71786) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__71788 = arguments.length;
switch (G__71788) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__71790 = arguments.length;
switch (G__71790) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70370__auto___72680 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71814){
var state_val_71815 = (state_71814[(1)]);
if((state_val_71815 === (7))){
var inst_71809 = (state_71814[(2)]);
var state_71814__$1 = state_71814;
var statearr_71816_72681 = state_71814__$1;
(statearr_71816_72681[(2)] = inst_71809);

(statearr_71816_72681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71815 === (1))){
var inst_71791 = null;
var state_71814__$1 = (function (){var statearr_71817 = state_71814;
(statearr_71817[(7)] = inst_71791);

return statearr_71817;
})();
var statearr_71818_72682 = state_71814__$1;
(statearr_71818_72682[(2)] = null);

(statearr_71818_72682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71815 === (4))){
var inst_71794 = (state_71814[(8)]);
var inst_71794__$1 = (state_71814[(2)]);
var inst_71795 = (inst_71794__$1 == null);
var inst_71796 = cljs.core.not(inst_71795);
var state_71814__$1 = (function (){var statearr_71819 = state_71814;
(statearr_71819[(8)] = inst_71794__$1);

return statearr_71819;
})();
if(inst_71796){
var statearr_71820_72683 = state_71814__$1;
(statearr_71820_72683[(1)] = (5));

} else {
var statearr_71821_72684 = state_71814__$1;
(statearr_71821_72684[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71815 === (6))){
var state_71814__$1 = state_71814;
var statearr_71822_72685 = state_71814__$1;
(statearr_71822_72685[(2)] = null);

(statearr_71822_72685[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71815 === (3))){
var inst_71811 = (state_71814[(2)]);
var inst_71812 = cljs.core.async.close_BANG_(out);
var state_71814__$1 = (function (){var statearr_71823 = state_71814;
(statearr_71823[(9)] = inst_71811);

return statearr_71823;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_71814__$1,inst_71812);
} else {
if((state_val_71815 === (2))){
var state_71814__$1 = state_71814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71814__$1,(4),ch);
} else {
if((state_val_71815 === (11))){
var inst_71794 = (state_71814[(8)]);
var inst_71803 = (state_71814[(2)]);
var inst_71791 = inst_71794;
var state_71814__$1 = (function (){var statearr_71824 = state_71814;
(statearr_71824[(10)] = inst_71803);

(statearr_71824[(7)] = inst_71791);

return statearr_71824;
})();
var statearr_71825_72686 = state_71814__$1;
(statearr_71825_72686[(2)] = null);

(statearr_71825_72686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71815 === (9))){
var inst_71794 = (state_71814[(8)]);
var state_71814__$1 = state_71814;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71814__$1,(11),out,inst_71794);
} else {
if((state_val_71815 === (5))){
var inst_71794 = (state_71814[(8)]);
var inst_71791 = (state_71814[(7)]);
var inst_71798 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71794,inst_71791);
var state_71814__$1 = state_71814;
if(inst_71798){
var statearr_71827_72687 = state_71814__$1;
(statearr_71827_72687[(1)] = (8));

} else {
var statearr_71828_72688 = state_71814__$1;
(statearr_71828_72688[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71815 === (10))){
var inst_71806 = (state_71814[(2)]);
var state_71814__$1 = state_71814;
var statearr_71829_72689 = state_71814__$1;
(statearr_71829_72689[(2)] = inst_71806);

(statearr_71829_72689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71815 === (8))){
var inst_71791 = (state_71814[(7)]);
var tmp71826 = inst_71791;
var inst_71791__$1 = tmp71826;
var state_71814__$1 = (function (){var statearr_71830 = state_71814;
(statearr_71830[(7)] = inst_71791__$1);

return statearr_71830;
})();
var statearr_71831_72690 = state_71814__$1;
(statearr_71831_72690[(2)] = null);

(statearr_71831_72690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_71832 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71832[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_71832[(1)] = (1));

return statearr_71832;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_71814){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71814);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71833){var ex__70338__auto__ = e71833;
var statearr_71834_72691 = state_71814;
(statearr_71834_72691[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71814[(4)]))){
var statearr_71835_72692 = state_71814;
(statearr_71835_72692[(1)] = cljs.core.first((state_71814[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72693 = state_71814;
state_71814 = G__72693;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_71814){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_71814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71836 = f__70371__auto__();
(statearr_71836[(6)] = c__70370__auto___72680);

return statearr_71836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__71838 = arguments.length;
switch (G__71838) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70370__auto___72695 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71876){
var state_val_71877 = (state_71876[(1)]);
if((state_val_71877 === (7))){
var inst_71872 = (state_71876[(2)]);
var state_71876__$1 = state_71876;
var statearr_71878_72696 = state_71876__$1;
(statearr_71878_72696[(2)] = inst_71872);

(statearr_71878_72696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (1))){
var inst_71839 = (new Array(n));
var inst_71840 = inst_71839;
var inst_71841 = (0);
var state_71876__$1 = (function (){var statearr_71879 = state_71876;
(statearr_71879[(7)] = inst_71841);

(statearr_71879[(8)] = inst_71840);

return statearr_71879;
})();
var statearr_71880_72697 = state_71876__$1;
(statearr_71880_72697[(2)] = null);

(statearr_71880_72697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (4))){
var inst_71844 = (state_71876[(9)]);
var inst_71844__$1 = (state_71876[(2)]);
var inst_71845 = (inst_71844__$1 == null);
var inst_71846 = cljs.core.not(inst_71845);
var state_71876__$1 = (function (){var statearr_71881 = state_71876;
(statearr_71881[(9)] = inst_71844__$1);

return statearr_71881;
})();
if(inst_71846){
var statearr_71882_72698 = state_71876__$1;
(statearr_71882_72698[(1)] = (5));

} else {
var statearr_71883_72699 = state_71876__$1;
(statearr_71883_72699[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (15))){
var inst_71866 = (state_71876[(2)]);
var state_71876__$1 = state_71876;
var statearr_71884_72700 = state_71876__$1;
(statearr_71884_72700[(2)] = inst_71866);

(statearr_71884_72700[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (13))){
var state_71876__$1 = state_71876;
var statearr_71885_72701 = state_71876__$1;
(statearr_71885_72701[(2)] = null);

(statearr_71885_72701[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (6))){
var inst_71841 = (state_71876[(7)]);
var inst_71862 = (inst_71841 > (0));
var state_71876__$1 = state_71876;
if(cljs.core.truth_(inst_71862)){
var statearr_71886_72702 = state_71876__$1;
(statearr_71886_72702[(1)] = (12));

} else {
var statearr_71887_72703 = state_71876__$1;
(statearr_71887_72703[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (3))){
var inst_71874 = (state_71876[(2)]);
var state_71876__$1 = state_71876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71876__$1,inst_71874);
} else {
if((state_val_71877 === (12))){
var inst_71840 = (state_71876[(8)]);
var inst_71864 = cljs.core.vec(inst_71840);
var state_71876__$1 = state_71876;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71876__$1,(15),out,inst_71864);
} else {
if((state_val_71877 === (2))){
var state_71876__$1 = state_71876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71876__$1,(4),ch);
} else {
if((state_val_71877 === (11))){
var inst_71856 = (state_71876[(2)]);
var inst_71857 = (new Array(n));
var inst_71840 = inst_71857;
var inst_71841 = (0);
var state_71876__$1 = (function (){var statearr_71888 = state_71876;
(statearr_71888[(7)] = inst_71841);

(statearr_71888[(8)] = inst_71840);

(statearr_71888[(10)] = inst_71856);

return statearr_71888;
})();
var statearr_71889_72704 = state_71876__$1;
(statearr_71889_72704[(2)] = null);

(statearr_71889_72704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (9))){
var inst_71840 = (state_71876[(8)]);
var inst_71854 = cljs.core.vec(inst_71840);
var state_71876__$1 = state_71876;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71876__$1,(11),out,inst_71854);
} else {
if((state_val_71877 === (5))){
var inst_71841 = (state_71876[(7)]);
var inst_71840 = (state_71876[(8)]);
var inst_71849 = (state_71876[(11)]);
var inst_71844 = (state_71876[(9)]);
var inst_71848 = (inst_71840[inst_71841] = inst_71844);
var inst_71849__$1 = (inst_71841 + (1));
var inst_71850 = (inst_71849__$1 < n);
var state_71876__$1 = (function (){var statearr_71890 = state_71876;
(statearr_71890[(11)] = inst_71849__$1);

(statearr_71890[(12)] = inst_71848);

return statearr_71890;
})();
if(cljs.core.truth_(inst_71850)){
var statearr_71891_72705 = state_71876__$1;
(statearr_71891_72705[(1)] = (8));

} else {
var statearr_71892_72706 = state_71876__$1;
(statearr_71892_72706[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (14))){
var inst_71869 = (state_71876[(2)]);
var inst_71870 = cljs.core.async.close_BANG_(out);
var state_71876__$1 = (function (){var statearr_71894 = state_71876;
(statearr_71894[(13)] = inst_71869);

return statearr_71894;
})();
var statearr_71895_72708 = state_71876__$1;
(statearr_71895_72708[(2)] = inst_71870);

(statearr_71895_72708[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (10))){
var inst_71860 = (state_71876[(2)]);
var state_71876__$1 = state_71876;
var statearr_71896_72709 = state_71876__$1;
(statearr_71896_72709[(2)] = inst_71860);

(statearr_71896_72709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71877 === (8))){
var inst_71840 = (state_71876[(8)]);
var inst_71849 = (state_71876[(11)]);
var tmp71893 = inst_71840;
var inst_71840__$1 = tmp71893;
var inst_71841 = inst_71849;
var state_71876__$1 = (function (){var statearr_71897 = state_71876;
(statearr_71897[(7)] = inst_71841);

(statearr_71897[(8)] = inst_71840__$1);

return statearr_71897;
})();
var statearr_71898_72711 = state_71876__$1;
(statearr_71898_72711[(2)] = null);

(statearr_71898_72711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_71899 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71899[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_71899[(1)] = (1));

return statearr_71899;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_71876){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71876);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71900){var ex__70338__auto__ = e71900;
var statearr_71901_72712 = state_71876;
(statearr_71901_72712[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71876[(4)]))){
var statearr_71902_72714 = state_71876;
(statearr_71902_72714[(1)] = cljs.core.first((state_71876[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72717 = state_71876;
state_71876 = G__72717;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_71876){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_71876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71903 = f__70371__auto__();
(statearr_71903[(6)] = c__70370__auto___72695);

return statearr_71903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__71905 = arguments.length;
switch (G__71905) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70370__auto___72720 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_71947){
var state_val_71948 = (state_71947[(1)]);
if((state_val_71948 === (7))){
var inst_71943 = (state_71947[(2)]);
var state_71947__$1 = state_71947;
var statearr_71949_72721 = state_71947__$1;
(statearr_71949_72721[(2)] = inst_71943);

(statearr_71949_72721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (1))){
var inst_71906 = [];
var inst_71907 = inst_71906;
var inst_71908 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_71947__$1 = (function (){var statearr_71950 = state_71947;
(statearr_71950[(7)] = inst_71908);

(statearr_71950[(8)] = inst_71907);

return statearr_71950;
})();
var statearr_71951_72722 = state_71947__$1;
(statearr_71951_72722[(2)] = null);

(statearr_71951_72722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (4))){
var inst_71911 = (state_71947[(9)]);
var inst_71911__$1 = (state_71947[(2)]);
var inst_71912 = (inst_71911__$1 == null);
var inst_71913 = cljs.core.not(inst_71912);
var state_71947__$1 = (function (){var statearr_71952 = state_71947;
(statearr_71952[(9)] = inst_71911__$1);

return statearr_71952;
})();
if(inst_71913){
var statearr_71953_72723 = state_71947__$1;
(statearr_71953_72723[(1)] = (5));

} else {
var statearr_71954_72724 = state_71947__$1;
(statearr_71954_72724[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (15))){
var inst_71937 = (state_71947[(2)]);
var state_71947__$1 = state_71947;
var statearr_71955_72725 = state_71947__$1;
(statearr_71955_72725[(2)] = inst_71937);

(statearr_71955_72725[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (13))){
var state_71947__$1 = state_71947;
var statearr_71956_72726 = state_71947__$1;
(statearr_71956_72726[(2)] = null);

(statearr_71956_72726[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (6))){
var inst_71907 = (state_71947[(8)]);
var inst_71932 = inst_71907.length;
var inst_71933 = (inst_71932 > (0));
var state_71947__$1 = state_71947;
if(cljs.core.truth_(inst_71933)){
var statearr_71957_72727 = state_71947__$1;
(statearr_71957_72727[(1)] = (12));

} else {
var statearr_71958_72728 = state_71947__$1;
(statearr_71958_72728[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (3))){
var inst_71945 = (state_71947[(2)]);
var state_71947__$1 = state_71947;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71947__$1,inst_71945);
} else {
if((state_val_71948 === (12))){
var inst_71907 = (state_71947[(8)]);
var inst_71935 = cljs.core.vec(inst_71907);
var state_71947__$1 = state_71947;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71947__$1,(15),out,inst_71935);
} else {
if((state_val_71948 === (2))){
var state_71947__$1 = state_71947;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71947__$1,(4),ch);
} else {
if((state_val_71948 === (11))){
var inst_71911 = (state_71947[(9)]);
var inst_71915 = (state_71947[(10)]);
var inst_71925 = (state_71947[(2)]);
var inst_71926 = [];
var inst_71927 = inst_71926.push(inst_71911);
var inst_71907 = inst_71926;
var inst_71908 = inst_71915;
var state_71947__$1 = (function (){var statearr_71959 = state_71947;
(statearr_71959[(7)] = inst_71908);

(statearr_71959[(11)] = inst_71927);

(statearr_71959[(8)] = inst_71907);

(statearr_71959[(12)] = inst_71925);

return statearr_71959;
})();
var statearr_71960_72732 = state_71947__$1;
(statearr_71960_72732[(2)] = null);

(statearr_71960_72732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (9))){
var inst_71907 = (state_71947[(8)]);
var inst_71923 = cljs.core.vec(inst_71907);
var state_71947__$1 = state_71947;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71947__$1,(11),out,inst_71923);
} else {
if((state_val_71948 === (5))){
var inst_71911 = (state_71947[(9)]);
var inst_71908 = (state_71947[(7)]);
var inst_71915 = (state_71947[(10)]);
var inst_71915__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_71911) : f.call(null,inst_71911));
var inst_71916 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71915__$1,inst_71908);
var inst_71917 = cljs.core.keyword_identical_QMARK_(inst_71908,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_71918 = ((inst_71916) || (inst_71917));
var state_71947__$1 = (function (){var statearr_71961 = state_71947;
(statearr_71961[(10)] = inst_71915__$1);

return statearr_71961;
})();
if(cljs.core.truth_(inst_71918)){
var statearr_71962_72733 = state_71947__$1;
(statearr_71962_72733[(1)] = (8));

} else {
var statearr_71963_72734 = state_71947__$1;
(statearr_71963_72734[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (14))){
var inst_71940 = (state_71947[(2)]);
var inst_71941 = cljs.core.async.close_BANG_(out);
var state_71947__$1 = (function (){var statearr_71965 = state_71947;
(statearr_71965[(13)] = inst_71940);

return statearr_71965;
})();
var statearr_71966_72735 = state_71947__$1;
(statearr_71966_72735[(2)] = inst_71941);

(statearr_71966_72735[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (10))){
var inst_71930 = (state_71947[(2)]);
var state_71947__$1 = state_71947;
var statearr_71967_72737 = state_71947__$1;
(statearr_71967_72737[(2)] = inst_71930);

(statearr_71967_72737[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71948 === (8))){
var inst_71911 = (state_71947[(9)]);
var inst_71915 = (state_71947[(10)]);
var inst_71907 = (state_71947[(8)]);
var inst_71920 = inst_71907.push(inst_71911);
var tmp71964 = inst_71907;
var inst_71907__$1 = tmp71964;
var inst_71908 = inst_71915;
var state_71947__$1 = (function (){var statearr_71968 = state_71947;
(statearr_71968[(7)] = inst_71908);

(statearr_71968[(8)] = inst_71907__$1);

(statearr_71968[(14)] = inst_71920);

return statearr_71968;
})();
var statearr_71969_72738 = state_71947__$1;
(statearr_71969_72738[(2)] = null);

(statearr_71969_72738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70335__auto__ = null;
var cljs$core$async$state_machine__70335__auto____0 = (function (){
var statearr_71970 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71970[(0)] = cljs$core$async$state_machine__70335__auto__);

(statearr_71970[(1)] = (1));

return statearr_71970;
});
var cljs$core$async$state_machine__70335__auto____1 = (function (state_71947){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_71947);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e71971){var ex__70338__auto__ = e71971;
var statearr_71972_72740 = state_71947;
(statearr_71972_72740[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_71947[(4)]))){
var statearr_71973_72742 = state_71947;
(statearr_71973_72742[(1)] = cljs.core.first((state_71947[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72745 = state_71947;
state_71947 = G__72745;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
cljs$core$async$state_machine__70335__auto__ = function(state_71947){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70335__auto____1.call(this,state_71947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70335__auto____0;
cljs$core$async$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70335__auto____1;
return cljs$core$async$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_71974 = f__70371__auto__();
(statearr_71974[(6)] = c__70370__auto___72720);

return statearr_71974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
