goog.provide('pinkgorilla.nrepl.op.eval');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('reagent.core');
goog.require('pinkgorilla.nrepl.ws.client');
/**
 * converts (:value message)
 * nrepl has to serialize the value before it hits clojure.
 * So this value gets formatted with edn.
 * Since the message is packaged as edn too, we have edn within edn.
 * 
 */
pinkgorilla.nrepl.op.eval.parse_value = (function pinkgorilla$nrepl$op$eval$parse_value(value){
try{var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.op.eval","/tmp/form-init2571683730222641663.clj",19,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["value: ",value], null);
}),null)),null,474263882);
var data = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.op.eval","/tmp/form-init2571683730222641663.clj",21,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["converted: ",data], null);
}),null)),null,1826176125);
return data;
}catch (e75708){if((e75708 instanceof Error)){
var e = e75708;
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.nrepl.op.eval","/tmp/form-init2571683730222641663.clj",27,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["parse-value ex: ",e," tried to parse: ",value], null);
}),null)),null,256345294);
} else {
throw e75708;

}
}});
/**
 * result is an atom, containing the eval result.
 * processes a fragment-response and modifies result-atom accordingly.
 */
pinkgorilla.nrepl.op.eval.on_eval_fragment = (function pinkgorilla$nrepl$op$eval$on_eval_fragment(result,p__75709){
var map__75710 = p__75709;
var map__75710__$1 = (((((!((map__75710 == null))))?(((((map__75710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75710):map__75710);
var message = map__75710__$1;
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75710__$1,new cljs.core.Keyword(null,"out","out",-910545517));
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75710__$1,new cljs.core.Keyword(null,"err","err",-2089457205));
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75710__$1,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75710__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75710__$1,new cljs.core.Keyword(null,"value","value",305978217));
var picasso__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75710__$1,new cljs.core.Keyword(null,"picasso","picasso",-1388478491));
var datafy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75710__$1,new cljs.core.Keyword(null,"datafy","datafy",863837122));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75710__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
if(cljs.core.truth_(out)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"out","out",-910545517),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"out","out",-910545517).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(out)].join(''));
} else {
}

if(cljs.core.truth_(err)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"err","err",-2089457205),err);
} else {
}

if(cljs.core.truth_(datafy)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"datafy","datafy",863837122),datafy);
} else {
}

if(cljs.core.truth_(ns)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"ns","ns",441598760),ns);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"value","value",305978217),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result)),value));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"picasso","picasso",-1388478491),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"picasso","picasso",-1388478491).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result)),pinkgorilla.nrepl.op.eval.parse_value(picasso__$1)));
} else {
}

if(cljs.core.truth_(root_ex)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778),root_ex);
} else {
return null;
}
});
/**
 * evaluates a clj-snippet
 */
pinkgorilla.nrepl.op.eval.nrepl_eval = (function pinkgorilla$nrepl$op$eval$nrepl_eval(conn,code){
var result = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"picasso","picasso",-1388478491),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"ns","ns",441598760),null,new cljs.core.Keyword(null,"out","out",-910545517),"",new cljs.core.Keyword(null,"err","err",-2089457205),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778),null], null));
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),code], null),(function (fragments){
var seq__75712_75735 = cljs.core.seq(fragments);
var chunk__75713_75736 = null;
var count__75714_75737 = (0);
var i__75715_75738 = (0);
while(true){
if((i__75715_75738 < count__75714_75737)){
var f_75739 = chunk__75713_75736.cljs$core$IIndexed$_nth$arity$2(null,i__75715_75738);
pinkgorilla.nrepl.op.eval.on_eval_fragment(result,f_75739);


var G__75740 = seq__75712_75735;
var G__75741 = chunk__75713_75736;
var G__75742 = count__75714_75737;
var G__75743 = (i__75715_75738 + (1));
seq__75712_75735 = G__75740;
chunk__75713_75736 = G__75741;
count__75714_75737 = G__75742;
i__75715_75738 = G__75743;
continue;
} else {
var temp__5735__auto___75744 = cljs.core.seq(seq__75712_75735);
if(temp__5735__auto___75744){
var seq__75712_75745__$1 = temp__5735__auto___75744;
if(cljs.core.chunked_seq_QMARK_(seq__75712_75745__$1)){
var c__4550__auto___75746 = cljs.core.chunk_first(seq__75712_75745__$1);
var G__75747 = cljs.core.chunk_rest(seq__75712_75745__$1);
var G__75748 = c__4550__auto___75746;
var G__75749 = cljs.core.count(c__4550__auto___75746);
var G__75750 = (0);
seq__75712_75735 = G__75747;
chunk__75713_75736 = G__75748;
count__75714_75737 = G__75749;
i__75715_75738 = G__75750;
continue;
} else {
var f_75751 = cljs.core.first(seq__75712_75745__$1);
pinkgorilla.nrepl.op.eval.on_eval_fragment(result,f_75751);


var G__75752 = cljs.core.next(seq__75712_75745__$1);
var G__75753 = null;
var G__75754 = (0);
var G__75755 = (0);
seq__75712_75735 = G__75752;
chunk__75713_75736 = G__75753;
count__75714_75737 = G__75754;
i__75715_75738 = G__75755;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(result);
}));
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.nrepl_eval', pinkgorilla.nrepl.op.eval.nrepl_eval);
/**
 * evaluates a clojure expression
 * returns result via callback
 * 
 * execute this in browser console:
 * pinkgorilla.kernel.nrepl.clj_eval_cb ("(+ 7 9 )", 
 *  (function (r) {console.log ("result!!: " +r);}))
 * 
 */
pinkgorilla.nrepl.op.eval.nrepl_eval_cb = (function pinkgorilla$nrepl$op$eval$nrepl_eval_cb(conn,snippet,cb){
var ch = pinkgorilla.nrepl.op.eval.nrepl_eval(conn,snippet);
var c__70370__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_75720){
var state_val_75721 = (state_75720[(1)]);
if((state_val_75721 === (1))){
var state_75720__$1 = state_75720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75720__$1,(2),ch);
} else {
if((state_val_75721 === (2))){
var inst_75717 = (state_75720[(2)]);
var inst_75718 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_75717) : cb.call(null,inst_75717));
var state_75720__$1 = state_75720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75720__$1,inst_75718);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto__ = null;
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto____0 = (function (){
var statearr_75722 = [null,null,null,null,null,null,null];
(statearr_75722[(0)] = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto__);

(statearr_75722[(1)] = (1));

return statearr_75722;
});
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto____1 = (function (state_75720){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_75720);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e75723){var ex__70338__auto__ = e75723;
var statearr_75724_75756 = state_75720;
(statearr_75724_75756[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_75720[(4)]))){
var statearr_75725_75757 = state_75720;
(statearr_75725_75757[(1)] = cljs.core.first((state_75720[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75758 = state_75720;
state_75720 = G__75758;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto__ = function(state_75720){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto____1.call(this,state_75720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto____0;
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto____1;
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_75726 = f__70371__auto__();
(statearr_75726[(6)] = c__70370__auto__);

return statearr_75726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));

return c__70370__auto__;
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.nrepl_eval_cb', pinkgorilla.nrepl.op.eval.nrepl_eval_cb);
/**
 * executes a clojure ```function-as-string``` (from clojurescript) 
 */
pinkgorilla.nrepl.op.eval.fn_eval = (function pinkgorilla$nrepl$op$eval$fn_eval(var_args){
var args__4736__auto__ = [];
var len__4730__auto___75759 = arguments.length;
var i__4731__auto___75760 = (0);
while(true){
if((i__4731__auto___75760 < len__4730__auto___75759)){
args__4736__auto__.push((arguments[i__4731__auto___75760]));

var G__75761 = (i__4731__auto___75760 + (1));
i__4731__auto___75760 = G__75761;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return pinkgorilla.nrepl.op.eval.fn_eval.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.fn_eval', pinkgorilla.nrepl.op.eval.fn_eval);

(pinkgorilla.nrepl.op.eval.fn_eval.cljs$core$IFn$_invoke$arity$variadic = (function (conn,function_as_string,params){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.nrepl.op.eval","/tmp/form-init2571683730222641663.clj",82,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["params: ",params], null);
}),null)),null,-1309723681);
var code = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
return pinkgorilla.nrepl.op.eval.nrepl_eval(conn,code);
}));

(pinkgorilla.nrepl.op.eval.fn_eval.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.nrepl.op.eval.fn_eval.cljs$lang$applyTo = (function (seq75727){
var G__75728 = cljs.core.first(seq75727);
var seq75727__$1 = cljs.core.next(seq75727);
var G__75729 = cljs.core.first(seq75727__$1);
var seq75727__$2 = cljs.core.next(seq75727__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75728,G__75729,seq75727__$2);
}));


//# sourceMappingURL=pinkgorilla.nrepl.op.eval.js.map
