goog.provide('pinkgorilla.nrepl.ws.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('reagent.core');
goog.require('pinkgorilla.nrepl.ws.connection');
/**
 * make-request 
 * - sends `message` to websocket (so nrepl/cider can process the request)
 * - returns the eval id.
 * parameter:
 * - state: this gets returned by (ws-start!)
 * - message: a nrepl message (with or without request-id)
 * - callback: optional callback that return all fragments of a request
 * returns:
 * - cannel with response fragments
 */
pinkgorilla.nrepl.ws.client.nrepl_op = (function pinkgorilla$nrepl$ws$client$nrepl_op(conn,message){
var request_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var map__75449 = conn;
var map__75449__$1 = (((((!((map__75449 == null))))?(((((map__75449.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75449.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75449):map__75449);
var requests = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75449__$1,new cljs.core.Keyword(null,"requests","requests",-733055638));
var input_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75449__$1,new cljs.core.Keyword(null,"input-ch","input-ch",-1864212482));
var request_id = (function (){var or__4120__auto__ = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(message);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
}
})();
var nrepl_msg = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),request_id], null)], 0));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(requests,cljs.core.assoc,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(request_id),request_ch);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init2571683730222641663.clj",52,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ws sending ws message: ",nrepl_msg], null);
}),null)),null,-575055263);

var c__70370__auto___75608 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_75459){
var state_val_75460 = (state_75459[(1)]);
if((state_val_75460 === (1))){
var state_75459__$1 = state_75459;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75459__$1,(2),input_ch,nrepl_msg);
} else {
if((state_val_75460 === (2))){
var inst_75456 = (state_75459[(2)]);
var state_75459__$1 = state_75459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75459__$1,inst_75456);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto__ = null;
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto____0 = (function (){
var statearr_75463 = [null,null,null,null,null,null,null];
(statearr_75463[(0)] = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto__);

(statearr_75463[(1)] = (1));

return statearr_75463;
});
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto____1 = (function (state_75459){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_75459);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e75464){var ex__70338__auto__ = e75464;
var statearr_75466_75610 = state_75459;
(statearr_75466_75610[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_75459[(4)]))){
var statearr_75467_75611 = state_75459;
(statearr_75467_75611[(1)] = cljs.core.first((state_75459[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75612 = state_75459;
state_75459 = G__75612;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto__ = function(state_75459){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto____1.call(this,state_75459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto____0;
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto____1;
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_75469 = f__70371__auto__();
(statearr_75469[(6)] = c__70370__auto___75608);

return statearr_75469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return request_ch;
});
pinkgorilla.nrepl.ws.client.nrepl_op_complete = (function pinkgorilla$nrepl$ws$client$nrepl_op_complete(var_args){
var G__75474 = arguments.length;
switch (G__75474) {
case 2:
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$2 = (function (conn,msg){
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,msg,null);
}));

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3 = (function (conn,msg,transform_fn){
var result_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var fragments = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
var fragments_ch = pinkgorilla.nrepl.ws.client.nrepl_op(conn,msg);
var result_fn = (function (){
if(cljs.core.truth_(transform_fn)){
var G__75479 = cljs.core.deref(fragments);
return (transform_fn.cljs$core$IFn$_invoke$arity$1 ? transform_fn.cljs$core$IFn$_invoke$arity$1(G__75479) : transform_fn.call(null,G__75479));
} else {
return cljs.core.deref(fragments);
}
});
var c__70370__auto___75614 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_75499){
var state_val_75500 = (state_75499[(1)]);
if((state_val_75500 === (7))){
var inst_75495 = (state_75499[(2)]);
var state_75499__$1 = state_75499;
var statearr_75507_75616 = state_75499__$1;
(statearr_75507_75616[(2)] = inst_75495);

(statearr_75507_75616[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75500 === (1))){
var state_75499__$1 = state_75499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75499__$1,(2),fragments_ch);
} else {
if((state_val_75500 === (4))){
var inst_75497 = (state_75499[(2)]);
var state_75499__$1 = state_75499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75499__$1,inst_75497);
} else {
if((state_val_75500 === (6))){
var inst_75490 = result_fn();
var state_75499__$1 = state_75499;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75499__$1,(9),result_ch,inst_75490);
} else {
if((state_val_75500 === (3))){
var inst_75482 = (state_75499[(7)]);
var state_75499__$1 = state_75499;
if(cljs.core.truth_(inst_75482)){
var statearr_75511_75620 = state_75499__$1;
(statearr_75511_75620[(1)] = (5));

} else {
var statearr_75513_75621 = state_75499__$1;
(statearr_75513_75621[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75500 === (2))){
var inst_75481 = (state_75499[(2)]);
var inst_75482 = inst_75481;
var state_75499__$1 = (function (){var statearr_75515 = state_75499;
(statearr_75515[(7)] = inst_75482);

return statearr_75515;
})();
var statearr_75516_75622 = state_75499__$1;
(statearr_75516_75622[(2)] = null);

(statearr_75516_75622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75500 === (9))){
var inst_75492 = (state_75499[(2)]);
var inst_75493 = cljs.core.async.close_BANG_(fragments_ch);
var state_75499__$1 = (function (){var statearr_75517 = state_75499;
(statearr_75517[(8)] = inst_75492);

return statearr_75517;
})();
var statearr_75518_75625 = state_75499__$1;
(statearr_75518_75625[(2)] = inst_75493);

(statearr_75518_75625[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75500 === (5))){
var inst_75482 = (state_75499[(7)]);
var inst_75485 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fragments,cljs.core.conj,inst_75482);
var state_75499__$1 = (function (){var statearr_75519 = state_75499;
(statearr_75519[(9)] = inst_75485);

return statearr_75519;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75499__$1,(8),fragments_ch);
} else {
if((state_val_75500 === (8))){
var inst_75487 = (state_75499[(2)]);
var inst_75482 = inst_75487;
var state_75499__$1 = (function (){var statearr_75521 = state_75499;
(statearr_75521[(7)] = inst_75482);

return statearr_75521;
})();
var statearr_75523_75629 = state_75499__$1;
(statearr_75523_75629[(2)] = null);

(statearr_75523_75629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$state_machine__70335__auto__ = null;
var pinkgorilla$nrepl$ws$client$state_machine__70335__auto____0 = (function (){
var statearr_75524 = [null,null,null,null,null,null,null,null,null,null];
(statearr_75524[(0)] = pinkgorilla$nrepl$ws$client$state_machine__70335__auto__);

(statearr_75524[(1)] = (1));

return statearr_75524;
});
var pinkgorilla$nrepl$ws$client$state_machine__70335__auto____1 = (function (state_75499){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_75499);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e75527){var ex__70338__auto__ = e75527;
var statearr_75528_75631 = state_75499;
(statearr_75528_75631[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_75499[(4)]))){
var statearr_75530_75632 = state_75499;
(statearr_75530_75632[(1)] = cljs.core.first((state_75499[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75635 = state_75499;
state_75499 = G__75635;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$state_machine__70335__auto__ = function(state_75499){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$state_machine__70335__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$state_machine__70335__auto____1.call(this,state_75499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$state_machine__70335__auto____0;
pinkgorilla$nrepl$ws$client$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$state_machine__70335__auto____1;
return pinkgorilla$nrepl$ws$client$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_75532 = f__70371__auto__();
(statearr_75532[(6)] = c__70370__auto___75614);

return statearr_75532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return result_ch;
}));

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$lang$maxFixedArity = 3);

/**
 * processes an incoming message that comes from channel (which comes 
 * via websocket via websocket-relay from nrepl)
 * Returns the corresponding request chan.
 */
pinkgorilla.nrepl.ws.client.chan_for_incoming_nrepl_msg = (function pinkgorilla$nrepl$ws$client$chan_for_incoming_nrepl_msg(requests,message){
var map__75534 = message;
var map__75534__$1 = (((((!((map__75534 == null))))?(((((map__75534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75534):map__75534);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75534__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75534__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var request_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(id);
var request_ch = (function (){var G__75536 = cljs.core.deref(requests);
return (request_id.cljs$core$IFn$_invoke$arity$1 ? request_id.cljs$core$IFn$_invoke$arity$1(G__75536) : request_id.call(null,G__75536));
})();
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init2571683730222641663.clj",85,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s fragment rcvd.",request_id], null);
}),null)),null,627537436);

if(cljs.core.truth_(request_ch)){
if(cljs.core.contains_QMARK_(status,new cljs.core.Keyword(null,"done","done",-889844188))){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init2571683730222641663.clj",89,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s request done.",request_id], null);
}),null)),null,1083026605);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(requests,cljs.core.dissoc,request_id);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_ch,true], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_ch,false], null);
}
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,false], null);
}
});
pinkgorilla.nrepl.ws.client.dump_msg = (function pinkgorilla$nrepl$ws$client$dump_msg(msg){
var request_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(msg);
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"pinkgorilla.nrepl.ws.client","/tmp/form-init2571683730222641663.clj",97,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s dumping response. No associated request found: %s",request_id,msg], null);
}),null)),null,1636401011);
});
/**
 * creates a nrepl connection via websocket
 * Intended to be used with nrepl-op
 */
pinkgorilla.nrepl.ws.client.nrepl_client_BANG_ = (function pinkgorilla$nrepl$ws$client$nrepl_client_BANG_(ws_url){
var conn = pinkgorilla.nrepl.ws.connection.ws_connect_BANG_(ws_url);
var requests = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var output_ch = new cljs.core.Keyword(null,"output-ch","output-ch",1069791231).cljs$core$IFn$_invoke$arity$1(conn);
var c__70370__auto___75637 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_75572){
var state_val_75573 = (state_75572[(1)]);
if((state_val_75573 === (7))){
var inst_75566 = (state_75572[(2)]);
var state_75572__$1 = (function (){var statearr_75574 = state_75572;
(statearr_75574[(7)] = inst_75566);

return statearr_75574;
})();
var statearr_75575_75638 = state_75572__$1;
(statearr_75575_75638[(2)] = null);

(statearr_75575_75638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75573 === (1))){
var state_75572__$1 = state_75572;
var statearr_75576_75639 = state_75572__$1;
(statearr_75576_75639[(2)] = null);

(statearr_75576_75639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75573 === (4))){
var inst_75545 = (state_75572[(8)]);
var inst_75548 = (state_75572[(9)]);
var inst_75547 = (state_75572[(10)]);
var inst_75545__$1 = (state_75572[(2)]);
var inst_75547__$1 = pinkgorilla.nrepl.ws.client.chan_for_incoming_nrepl_msg(requests,inst_75545__$1);
var inst_75548__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75547__$1,(0),null);
var inst_75549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75547__$1,(1),null);
var state_75572__$1 = (function (){var statearr_75579 = state_75572;
(statearr_75579[(8)] = inst_75545__$1);

(statearr_75579[(9)] = inst_75548__$1);

(statearr_75579[(10)] = inst_75547__$1);

(statearr_75579[(11)] = inst_75549);

return statearr_75579;
})();
if(cljs.core.truth_(inst_75548__$1)){
var statearr_75580_75640 = state_75572__$1;
(statearr_75580_75640[(1)] = (5));

} else {
var statearr_75581_75641 = state_75572__$1;
(statearr_75581_75641[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75573 === (6))){
var inst_75545 = (state_75572[(8)]);
var inst_75564 = pinkgorilla.nrepl.ws.client.dump_msg(inst_75545);
var state_75572__$1 = state_75572;
var statearr_75583_75642 = state_75572__$1;
(statearr_75583_75642[(2)] = inst_75564);

(statearr_75583_75642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75573 === (3))){
var inst_75570 = (state_75572[(2)]);
var state_75572__$1 = state_75572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75572__$1,inst_75570);
} else {
if((state_val_75573 === (2))){
var state_75572__$1 = state_75572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75572__$1,(4),output_ch);
} else {
if((state_val_75573 === (11))){
var inst_75562 = (state_75572[(2)]);
var state_75572__$1 = state_75572;
var statearr_75584_75643 = state_75572__$1;
(statearr_75584_75643[(2)] = inst_75562);

(statearr_75584_75643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75573 === (9))){
var inst_75545 = (state_75572[(8)]);
var inst_75548 = (state_75572[(9)]);
var inst_75547 = (state_75572[(10)]);
var inst_75549 = (state_75572[(11)]);
var inst_75554 = (function (){var msg = inst_75545;
var vec__75541 = inst_75547;
var req_ch = inst_75548;
var done_QMARK_ = inst_75549;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s closing channel.",new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(msg)], null);
});
})();
var inst_75555 = (new cljs.core.Delay(inst_75554,null));
var inst_75556 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init2571683730222641663.clj",113,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_75555,null,2086201815);
var inst_75558 = cljs.core.async.close_BANG_(inst_75548);
var state_75572__$1 = (function (){var statearr_75588 = state_75572;
(statearr_75588[(12)] = inst_75556);

return statearr_75588;
})();
var statearr_75589_75644 = state_75572__$1;
(statearr_75589_75644[(2)] = inst_75558);

(statearr_75589_75644[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75573 === (5))){
var inst_75545 = (state_75572[(8)]);
var inst_75548 = (state_75572[(9)]);
var state_75572__$1 = state_75572;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75572__$1,(8),inst_75548,inst_75545);
} else {
if((state_val_75573 === (10))){
var state_75572__$1 = state_75572;
var statearr_75592_75645 = state_75572__$1;
(statearr_75592_75645[(2)] = null);

(statearr_75592_75645[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75573 === (8))){
var inst_75549 = (state_75572[(11)]);
var inst_75552 = (state_75572[(2)]);
var state_75572__$1 = (function (){var statearr_75593 = state_75572;
(statearr_75593[(13)] = inst_75552);

return statearr_75593;
})();
if(cljs.core.truth_(inst_75549)){
var statearr_75595_75646 = state_75572__$1;
(statearr_75595_75646[(1)] = (9));

} else {
var statearr_75596_75647 = state_75572__$1;
(statearr_75596_75647[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto__ = null;
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto____0 = (function (){
var statearr_75597 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75597[(0)] = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto__);

(statearr_75597[(1)] = (1));

return statearr_75597;
});
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto____1 = (function (state_75572){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_75572);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e75600){var ex__70338__auto__ = e75600;
var statearr_75601_75648 = state_75572;
(statearr_75601_75648[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_75572[(4)]))){
var statearr_75602_75649 = state_75572;
(statearr_75602_75649[(1)] = cljs.core.first((state_75572[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75650 = state_75572;
state_75572 = G__75650;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto__ = function(state_75572){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto____1.call(this,state_75572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto____0;
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto____1;
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_75603 = f__70371__auto__();
(statearr_75603[(6)] = c__70370__auto___75637);

return statearr_75603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"requests","requests",-733055638),requests);
});

//# sourceMappingURL=pinkgorilla.nrepl.ws.client.js.map
