goog.provide('pinkgorilla.storage.filename_encoding');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('clojure.string');
pinkgorilla.storage.filename_encoding.encoding__GT_extension = (function pinkgorilla$storage$filename_encoding$encoding__GT_extension(encoding){
var G__67123 = encoding;
var G__67123__$1 = (((G__67123 instanceof cljs.core.Keyword))?G__67123.fqn:null);
switch (G__67123__$1) {
case "gorilla":
return "cljg";

break;
case "jupyter":
return "ipynb";

break;
case "clj":
return "clj";

break;
default:
return "xxx";

}
});
pinkgorilla.storage.filename_encoding.extension__GT_encoding = (function pinkgorilla$storage$filename_encoding$extension__GT_encoding(extension){
var G__67124 = clojure.string.lower_case(extension);
switch (G__67124) {
case "cljg":
return new cljs.core.Keyword(null,"gorilla","gorilla",-211534157);

break;
case "ipynb":
return new cljs.core.Keyword(null,"jupyter","jupyter",-1124807371);

break;
case "clj":
return new cljs.core.Keyword(null,"clojure","clojure",438975815);

break;
default:
return new cljs.core.Keyword(null,"unknown","unknown",-935977881);

}
});
/**
 * extracts the only the name of the file, without extension and path
 */
pinkgorilla.storage.filename_encoding.split_filename = (function pinkgorilla$storage$filename_encoding$split_filename(file_name){
if(clojure.string.blank_QMARK_(file_name)){
return null;
} else {
var temp__5735__auto__ = cljs.core.re_find(/(.+?)([\w-]*).(cljg|ipynb)*$/i,file_name);
if(cljs.core.truth_(temp__5735__auto__)){
var match = temp__5735__auto__;
var vec__67125 = match;
var full = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67125,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67125,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67125,(2),null);
var ext = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67125,(3),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"full","full",436801220),full,new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"ext","ext",-996964541),ext,new cljs.core.Keyword(null,"encoding","encoding",1728578272),pinkgorilla.storage.filename_encoding.extension__GT_encoding(ext)], null);
} else {
return null;
}
}
});
pinkgorilla.storage.filename_encoding.filename__GT_encoding = (function pinkgorilla$storage$filename_encoding$filename__GT_encoding(this$,k){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.storage.filename-encoding","/tmp/form-init2571683730222641663.clj",35,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["filename->encoding: ",this$], null);
}),null)),null,-998735417);

return new cljs.core.Keyword(null,"encoding","encoding",1728578272).cljs$core$IFn$_invoke$arity$1(pinkgorilla.storage.filename_encoding.split_filename((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(this$) : k.call(null,this$))));
});
pinkgorilla.storage.filename_encoding.filename__GT_name = (function pinkgorilla$storage$filename_encoding$filename__GT_name(this$,k){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pinkgorilla.storage.filename_encoding.split_filename((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(this$) : k.call(null,this$))));
});

//# sourceMappingURL=pinkgorilla.storage.filename_encoding.js.map
