(ns pinkgorilla.notebook.config
  (:require
   [clojure.string :as str]
   [cemerick.url :as url]
   [pinkgorilla.explorer.default-config :refer [config-client config-server]] ; side-effects
   [pinkgorilla.notebook-ui.keybindings.default :refer [keybindings-default]]))

#?(:cljs
   (do

    ;; common url convenience stolen from gorilla-notebook
     (defn application-url []
       (url/url (-> js/window .-location .-href)))

     (defn ws-origin [path app-url]
       (let [proto (if (= (:protocol app-url) "http") "ws" "wss")
             port-postfix  (let [port (:port app-url)]
                             (if (< 0 port)
                               (str ":" port)
                               ""))]
         (str proto ":" (:host app-url) port-postfix (str/replace (:path app-url) #"[^/]*$" path))))

    ;
     ))

(def notebook-frontend-config
  {;:gorilla-ui-prefix "/"
   :keybindings keybindings-default
   :nrepl-endpoint "ws://localhost:9000/nrepl"
   ;:routes demo-routes-api
   :explorer config-client
   :title "PinkGorilla Notebook"})

(def notebook-backend-config
  {:nrepl-server {:port 12000}
   :relay {:port 9000   ; this is jetty server + nrepl-relay
           :route "/nrepl"}
   :explorer config-server}) ; todo: use route to determine this.

(def notebook-config
  {:timbre-loglevel :debug
   :backend notebook-backend-config
   :frontend notebook-frontend-config})