goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__68322 = e.target.readyState;
var fexpr__68321 = new cljs.core.PersistentArrayMap(null, 5, [(0),new cljs.core.Keyword(null,"not-initialized","not-initialized",-1937378906),(1),new cljs.core.Keyword(null,"connection-established","connection-established",-1403749733),(2),new cljs.core.Keyword(null,"request-received","request-received",2110590540),(3),new cljs.core.Keyword(null,"processing-request","processing-request",-264947221),(4),new cljs.core.Keyword(null,"response-ready","response-ready",245208276)], null);
return (fexpr__68321.cljs$core$IFn$_invoke$arity$1 ? fexpr__68321.cljs$core$IFn$_invoke$arity$1(G__68322) : fexpr__68321.call(null,G__68322));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():XMLHttpRequest);
(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__68324,handler){
var map__68325 = p__68324;
var map__68325__$1 = (((((!((map__68325 == null))))?(((((map__68325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68325.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68325):map__68325);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68325__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68325__$1,new cljs.core.Keyword(null,"method","method",55703592));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68325__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68325__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68325__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68325__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68325__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var this$__$1 = this;
(this$__$1.withCredentials = with_credentials);

(this$__$1.onreadystatechange = (function (p1__68323_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"response-ready","response-ready",245208276),ajax.xml_http_request.ready_state(p1__68323_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
}));

this$__$1.open(method,uri,true);

(this$__$1.timeout = timeout);

var temp__5735__auto___68343 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5735__auto___68343)){
var response_type_68344 = temp__5735__auto___68343;
(this$__$1.responseType = cljs.core.name(response_type_68344));
} else {
}

var seq__68327_68345 = cljs.core.seq(headers);
var chunk__68328_68346 = null;
var count__68329_68347 = (0);
var i__68330_68348 = (0);
while(true){
if((i__68330_68348 < count__68329_68347)){
var vec__68337_68349 = chunk__68328_68346.cljs$core$IIndexed$_nth$arity$2(null,i__68330_68348);
var k_68350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68337_68349,(0),null);
var v_68351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68337_68349,(1),null);
this$__$1.setRequestHeader(k_68350,v_68351);


var G__68352 = seq__68327_68345;
var G__68353 = chunk__68328_68346;
var G__68354 = count__68329_68347;
var G__68355 = (i__68330_68348 + (1));
seq__68327_68345 = G__68352;
chunk__68328_68346 = G__68353;
count__68329_68347 = G__68354;
i__68330_68348 = G__68355;
continue;
} else {
var temp__5735__auto___68358 = cljs.core.seq(seq__68327_68345);
if(temp__5735__auto___68358){
var seq__68327_68359__$1 = temp__5735__auto___68358;
if(cljs.core.chunked_seq_QMARK_(seq__68327_68359__$1)){
var c__4550__auto___68360 = cljs.core.chunk_first(seq__68327_68359__$1);
var G__68361 = cljs.core.chunk_rest(seq__68327_68359__$1);
var G__68362 = c__4550__auto___68360;
var G__68363 = cljs.core.count(c__4550__auto___68360);
var G__68364 = (0);
seq__68327_68345 = G__68361;
chunk__68328_68346 = G__68362;
count__68329_68347 = G__68363;
i__68330_68348 = G__68364;
continue;
} else {
var vec__68340_68365 = cljs.core.first(seq__68327_68359__$1);
var k_68366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68340_68365,(0),null);
var v_68367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68340_68365,(1),null);
this$__$1.setRequestHeader(k_68366,v_68367);


var G__68368 = cljs.core.next(seq__68327_68359__$1);
var G__68369 = null;
var G__68370 = (0);
var G__68371 = (0);
seq__68327_68345 = G__68368;
chunk__68328_68346 = G__68369;
count__68329_68347 = G__68370;
i__68330_68348 = G__68371;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__4120__auto__ = body;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "";
}
})());

return this$__$1;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
}));

//# sourceMappingURL=ajax.xml_http_request.js.map
