goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e75768){var e = e75768;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___75884 = arguments.length;
var i__4731__auto___75885 = (0);
while(true){
if((i__4731__auto___75885 < len__4730__auto___75884)){
args__4736__auto__.push((arguments[i__4731__auto___75885]));

var G__75886 = (i__4731__auto___75885 + (1));
i__4731__auto___75885 = G__75886;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__75773){
var vec__75774 = p__75773;
var map__75777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75774,(0),null);
var map__75777__$1 = (((((!((map__75777 == null))))?(((((map__75777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75777.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75777):map__75777);
var opts = map__75777__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75777__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75777__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75777__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75777__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__75779 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4120__auto__ = read_ch;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4120__auto__ = write_ch;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__75779__$1 = (((((!((map__75779 == null))))?(((((map__75779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75779):map__75779);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75779__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75779__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__75769_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__75769_SHARP_);
}));

(web_socket.onclose = (function (p1__75770_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__75770_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__71138__auto___75887 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_75848){
var state_val_75849 = (state_75848[(1)]);
if((state_val_75849 === (7))){
var inst_75844 = (state_75848[(2)]);
var state_75848__$1 = state_75848;
var statearr_75850_75888 = state_75848__$1;
(statearr_75850_75888[(2)] = inst_75844);

(statearr_75850_75888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (20))){
var state_75848__$1 = state_75848;
var statearr_75851_75889 = state_75848__$1;
(statearr_75851_75889[(2)] = null);

(statearr_75851_75889[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (1))){
var inst_75781 = false;
var state_75848__$1 = (function (){var statearr_75852 = state_75848;
(statearr_75852[(7)] = inst_75781);

return statearr_75852;
})();
var statearr_75853_75890 = state_75848__$1;
(statearr_75853_75890[(2)] = null);

(statearr_75853_75890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (4))){
var inst_75790 = (state_75848[(8)]);
var inst_75796 = (state_75848[(9)]);
var inst_75798 = (state_75848[(10)]);
var inst_75796__$1 = (state_75848[(2)]);
var inst_75797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75796__$1,(0),null);
var inst_75798__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75796__$1,(1),null);
var inst_75799 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75798__$1,inst_75790);
var state_75848__$1 = (function (){var statearr_75854 = state_75848;
(statearr_75854[(11)] = inst_75797);

(statearr_75854[(9)] = inst_75796__$1);

(statearr_75854[(10)] = inst_75798__$1);

return statearr_75854;
})();
if(inst_75799){
var statearr_75855_75891 = state_75848__$1;
(statearr_75855_75891[(1)] = (5));

} else {
var statearr_75856_75892 = state_75848__$1;
(statearr_75856_75892[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (15))){
var inst_75829 = (state_75848[(2)]);
var state_75848__$1 = state_75848;
var statearr_75857_75899 = state_75848__$1;
(statearr_75857_75899[(2)] = inst_75829);

(statearr_75857_75899[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (21))){
var inst_75840 = (state_75848[(2)]);
var state_75848__$1 = state_75848;
var statearr_75858_75946 = state_75848__$1;
(statearr_75858_75946[(2)] = inst_75840);

(statearr_75858_75946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (13))){
var state_75848__$1 = state_75848;
var statearr_75859_75947 = state_75848__$1;
(statearr_75859_75947[(2)] = null);

(statearr_75859_75947[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (6))){
var inst_75791 = (state_75848[(12)]);
var inst_75798 = (state_75848[(10)]);
var inst_75813 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75798,inst_75791);
var state_75848__$1 = state_75848;
if(inst_75813){
var statearr_75860_75948 = state_75848__$1;
(statearr_75860_75948[(1)] = (9));

} else {
var statearr_75861_75949 = state_75848__$1;
(statearr_75861_75949[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (17))){
var state_75848__$1 = state_75848;
var statearr_75862_75950 = state_75848__$1;
(statearr_75862_75950[(2)] = initial_ch);

(statearr_75862_75950[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (3))){
var inst_75846 = (state_75848[(2)]);
var state_75848__$1 = state_75848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75848__$1,inst_75846);
} else {
if((state_val_75849 === (12))){
var inst_75781 = (state_75848[(7)]);
var state_75848__$1 = state_75848;
if(cljs.core.truth_(inst_75781)){
var statearr_75863_75966 = state_75848__$1;
(statearr_75863_75966[(1)] = (16));

} else {
var statearr_75864_75967 = state_75848__$1;
(statearr_75864_75967[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (2))){
var inst_75790 = (state_75848[(8)]);
var inst_75791 = (state_75848[(12)]);
var inst_75790__$1 = open_ch;
var inst_75791__$1 = close_ch;
var inst_75792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75793 = [inst_75790__$1,inst_75791__$1];
var inst_75794 = (new cljs.core.PersistentVector(null,2,(5),inst_75792,inst_75793,null));
var state_75848__$1 = (function (){var statearr_75865 = state_75848;
(statearr_75865[(8)] = inst_75790__$1);

(statearr_75865[(12)] = inst_75791__$1);

return statearr_75865;
})();
return cljs.core.async.ioc_alts_BANG_(state_75848__$1,(4),inst_75794);
} else {
if((state_val_75849 === (19))){
var inst_75797 = (state_75848[(11)]);
var state_75848__$1 = state_75848;
var statearr_75866_75970 = state_75848__$1;
(statearr_75866_75970[(2)] = inst_75797);

(statearr_75866_75970[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (11))){
var inst_75842 = (state_75848[(2)]);
var state_75848__$1 = state_75848;
var statearr_75867_75971 = state_75848__$1;
(statearr_75867_75971[(2)] = inst_75842);

(statearr_75867_75971[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (9))){
var inst_75796 = (state_75848[(9)]);
var inst_75819 = (state_75848[(13)]);
var inst_75818 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75796,(0),null);
var inst_75819__$1 = chord.client.close_event__GT_maybe_error(inst_75818);
var state_75848__$1 = (function (){var statearr_75868 = state_75848;
(statearr_75868[(13)] = inst_75819__$1);

return statearr_75868;
})();
if(cljs.core.truth_(inst_75819__$1)){
var statearr_75869_75973 = state_75848__$1;
(statearr_75869_75973[(1)] = (12));

} else {
var statearr_75870_75974 = state_75848__$1;
(statearr_75870_75974[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (5))){
var inst_75796 = (state_75848[(9)]);
var inst_75804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75796,(0),null);
var inst_75805 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_75806 = [ws_chan];
var inst_75807 = cljs.core.PersistentHashMap.fromArrays(inst_75805,inst_75806);
var state_75848__$1 = (function (){var statearr_75871 = state_75848;
(statearr_75871[(14)] = inst_75804);

return statearr_75871;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75848__$1,(8),initial_ch,inst_75807);
} else {
if((state_val_75849 === (14))){
var inst_75832 = (state_75848[(2)]);
var inst_75833 = cljs.core.async.close_BANG_(ws_chan);
var inst_75834 = cljs.core.async.close_BANG_(initial_ch);
var state_75848__$1 = (function (){var statearr_75872 = state_75848;
(statearr_75872[(15)] = inst_75832);

(statearr_75872[(16)] = inst_75833);

return statearr_75872;
})();
var statearr_75873_75979 = state_75848__$1;
(statearr_75873_75979[(2)] = inst_75834);

(statearr_75873_75979[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (16))){
var state_75848__$1 = state_75848;
var statearr_75874_75980 = state_75848__$1;
(statearr_75874_75980[(2)] = read_ch__$1);

(statearr_75874_75980[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (10))){
var inst_75798 = (state_75848[(10)]);
var inst_75836 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75798,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_75848__$1 = state_75848;
if(inst_75836){
var statearr_75875_75981 = state_75848__$1;
(statearr_75875_75981[(1)] = (19));

} else {
var statearr_75876_75982 = state_75848__$1;
(statearr_75876_75982[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75849 === (18))){
var inst_75819 = (state_75848[(13)]);
var inst_75824 = (state_75848[(2)]);
var inst_75825 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75826 = [inst_75819];
var inst_75827 = cljs.core.PersistentHashMap.fromArrays(inst_75825,inst_75826);
var state_75848__$1 = state_75848;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75848__$1,(15),inst_75824,inst_75827);
} else {
if((state_val_75849 === (8))){
var inst_75809 = (state_75848[(2)]);
var inst_75810 = cljs.core.async.close_BANG_(initial_ch);
var inst_75781 = true;
var state_75848__$1 = (function (){var statearr_75877 = state_75848;
(statearr_75877[(17)] = inst_75810);

(statearr_75877[(18)] = inst_75809);

(statearr_75877[(7)] = inst_75781);

return statearr_75877;
})();
var statearr_75878_75987 = state_75848__$1;
(statearr_75878_75987[(2)] = null);

(statearr_75878_75987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__71103__auto__ = null;
var chord$client$state_machine__71103__auto____0 = (function (){
var statearr_75879 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75879[(0)] = chord$client$state_machine__71103__auto__);

(statearr_75879[(1)] = (1));

return statearr_75879;
});
var chord$client$state_machine__71103__auto____1 = (function (state_75848){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_75848);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e75880){var ex__71106__auto__ = e75880;
var statearr_75881_75989 = state_75848;
(statearr_75881_75989[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_75848[(4)]))){
var statearr_75882_75990 = state_75848;
(statearr_75882_75990[(1)] = cljs.core.first((state_75848[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75991 = state_75848;
state_75848 = G__75991;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
chord$client$state_machine__71103__auto__ = function(state_75848){
switch(arguments.length){
case 0:
return chord$client$state_machine__71103__auto____0.call(this);
case 1:
return chord$client$state_machine__71103__auto____1.call(this,state_75848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__71103__auto____0;
chord$client$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__71103__auto____1;
return chord$client$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_75883 = f__71139__auto__();
(statearr_75883[(6)] = c__71138__auto___75887);

return statearr_75883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq75771){
var G__75772 = cljs.core.first(seq75771);
var seq75771__$1 = cljs.core.next(seq75771);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75772,seq75771__$1);
}));


//# sourceMappingURL=chord.client.js.map
