goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__71196 = arguments.length;
switch (G__71196) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71198 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71198 = (function (f,blockable,meta71199){
this.f = f;
this.blockable = blockable;
this.meta71199 = meta71199;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71198.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71200,meta71199__$1){
var self__ = this;
var _71200__$1 = this;
return (new cljs.core.async.t_cljs$core$async71198(self__.f,self__.blockable,meta71199__$1));
}));

(cljs.core.async.t_cljs$core$async71198.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71200){
var self__ = this;
var _71200__$1 = this;
return self__.meta71199;
}));

(cljs.core.async.t_cljs$core$async71198.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71198.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async71198.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async71198.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async71198.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta71199","meta71199",182270411,null)], null);
}));

(cljs.core.async.t_cljs$core$async71198.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71198.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71198");

(cljs.core.async.t_cljs$core$async71198.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71198");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71198.
 */
cljs.core.async.__GT_t_cljs$core$async71198 = (function cljs$core$async$__GT_t_cljs$core$async71198(f__$1,blockable__$1,meta71199){
return (new cljs.core.async.t_cljs$core$async71198(f__$1,blockable__$1,meta71199));
});

}

return (new cljs.core.async.t_cljs$core$async71198(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__71209 = arguments.length;
switch (G__71209) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__71219 = arguments.length;
switch (G__71219) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__71225 = arguments.length;
switch (G__71225) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_72766 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_72766) : fn1.call(null,val_72766));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_72766) : fn1.call(null,val_72766));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__71229 = arguments.length;
switch (G__71229) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___72773 = n;
var x_72774 = (0);
while(true){
if((x_72774 < n__4607__auto___72773)){
(a[x_72774] = x_72774);

var G__72777 = (x_72774 + (1));
x_72774 = G__72777;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71232 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71232 = (function (flag,meta71233){
this.flag = flag;
this.meta71233 = meta71233;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71232.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71234,meta71233__$1){
var self__ = this;
var _71234__$1 = this;
return (new cljs.core.async.t_cljs$core$async71232(self__.flag,meta71233__$1));
}));

(cljs.core.async.t_cljs$core$async71232.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71234){
var self__ = this;
var _71234__$1 = this;
return self__.meta71233;
}));

(cljs.core.async.t_cljs$core$async71232.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71232.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async71232.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async71232.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async71232.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta71233","meta71233",-1065445848,null)], null);
}));

(cljs.core.async.t_cljs$core$async71232.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71232.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71232");

(cljs.core.async.t_cljs$core$async71232.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71232");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71232.
 */
cljs.core.async.__GT_t_cljs$core$async71232 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async71232(flag__$1,meta71233){
return (new cljs.core.async.t_cljs$core$async71232(flag__$1,meta71233));
});

}

return (new cljs.core.async.t_cljs$core$async71232(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71241 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71241 = (function (flag,cb,meta71242){
this.flag = flag;
this.cb = cb;
this.meta71242 = meta71242;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71241.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71243,meta71242__$1){
var self__ = this;
var _71243__$1 = this;
return (new cljs.core.async.t_cljs$core$async71241(self__.flag,self__.cb,meta71242__$1));
}));

(cljs.core.async.t_cljs$core$async71241.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71243){
var self__ = this;
var _71243__$1 = this;
return self__.meta71242;
}));

(cljs.core.async.t_cljs$core$async71241.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71241.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async71241.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async71241.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async71241.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta71242","meta71242",-389545891,null)], null);
}));

(cljs.core.async.t_cljs$core$async71241.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71241.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71241");

(cljs.core.async.t_cljs$core$async71241.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71241");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71241.
 */
cljs.core.async.__GT_t_cljs$core$async71241 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async71241(flag__$1,cb__$1,meta71242){
return (new cljs.core.async.t_cljs$core$async71241(flag__$1,cb__$1,meta71242));
});

}

return (new cljs.core.async.t_cljs$core$async71241(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71245_SHARP_){
var G__71250 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71245_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__71250) : fret.call(null,G__71250));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71247_SHARP_){
var G__71251 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71247_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__71251) : fret.call(null,G__71251));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4120__auto__ = wport;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return port;
}
})()], null));
} else {
var G__72790 = (i + (1));
i = G__72790;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4120__auto__ = ret;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4109__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4109__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4109__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___72793 = arguments.length;
var i__4731__auto___72794 = (0);
while(true){
if((i__4731__auto___72794 < len__4730__auto___72793)){
args__4736__auto__.push((arguments[i__4731__auto___72794]));

var G__72796 = (i__4731__auto___72794 + (1));
i__4731__auto___72794 = G__72796;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__71255){
var map__71256 = p__71255;
var map__71256__$1 = (((((!((map__71256 == null))))?(((((map__71256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__71256):map__71256);
var opts = map__71256__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq71252){
var G__71253 = cljs.core.first(seq71252);
var seq71252__$1 = cljs.core.next(seq71252);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71253,seq71252__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__71263 = arguments.length;
switch (G__71263) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__71138__auto___72802 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71295){
var state_val_71296 = (state_71295[(1)]);
if((state_val_71296 === (7))){
var inst_71291 = (state_71295[(2)]);
var state_71295__$1 = state_71295;
var statearr_71300_72806 = state_71295__$1;
(statearr_71300_72806[(2)] = inst_71291);

(statearr_71300_72806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (1))){
var state_71295__$1 = state_71295;
var statearr_71301_72808 = state_71295__$1;
(statearr_71301_72808[(2)] = null);

(statearr_71301_72808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (4))){
var inst_71273 = (state_71295[(7)]);
var inst_71273__$1 = (state_71295[(2)]);
var inst_71275 = (inst_71273__$1 == null);
var state_71295__$1 = (function (){var statearr_71303 = state_71295;
(statearr_71303[(7)] = inst_71273__$1);

return statearr_71303;
})();
if(cljs.core.truth_(inst_71275)){
var statearr_71304_72809 = state_71295__$1;
(statearr_71304_72809[(1)] = (5));

} else {
var statearr_71305_72810 = state_71295__$1;
(statearr_71305_72810[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (13))){
var state_71295__$1 = state_71295;
var statearr_71306_72811 = state_71295__$1;
(statearr_71306_72811[(2)] = null);

(statearr_71306_72811[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (6))){
var inst_71273 = (state_71295[(7)]);
var state_71295__$1 = state_71295;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71295__$1,(11),to,inst_71273);
} else {
if((state_val_71296 === (3))){
var inst_71293 = (state_71295[(2)]);
var state_71295__$1 = state_71295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71295__$1,inst_71293);
} else {
if((state_val_71296 === (12))){
var state_71295__$1 = state_71295;
var statearr_71307_72815 = state_71295__$1;
(statearr_71307_72815[(2)] = null);

(statearr_71307_72815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (2))){
var state_71295__$1 = state_71295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71295__$1,(4),from);
} else {
if((state_val_71296 === (11))){
var inst_71284 = (state_71295[(2)]);
var state_71295__$1 = state_71295;
if(cljs.core.truth_(inst_71284)){
var statearr_71308_72817 = state_71295__$1;
(statearr_71308_72817[(1)] = (12));

} else {
var statearr_71309_72818 = state_71295__$1;
(statearr_71309_72818[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (9))){
var state_71295__$1 = state_71295;
var statearr_71311_72819 = state_71295__$1;
(statearr_71311_72819[(2)] = null);

(statearr_71311_72819[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (5))){
var state_71295__$1 = state_71295;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71312_72822 = state_71295__$1;
(statearr_71312_72822[(1)] = (8));

} else {
var statearr_71313_72824 = state_71295__$1;
(statearr_71313_72824[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (14))){
var inst_71289 = (state_71295[(2)]);
var state_71295__$1 = state_71295;
var statearr_71314_72825 = state_71295__$1;
(statearr_71314_72825[(2)] = inst_71289);

(statearr_71314_72825[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (10))){
var inst_71281 = (state_71295[(2)]);
var state_71295__$1 = state_71295;
var statearr_71315_72827 = state_71295__$1;
(statearr_71315_72827[(2)] = inst_71281);

(statearr_71315_72827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71296 === (8))){
var inst_71278 = cljs.core.async.close_BANG_(to);
var state_71295__$1 = state_71295;
var statearr_71317_72828 = state_71295__$1;
(statearr_71317_72828[(2)] = inst_71278);

(statearr_71317_72828[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_71319 = [null,null,null,null,null,null,null,null];
(statearr_71319[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_71319[(1)] = (1));

return statearr_71319;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_71295){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71295);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71322){var ex__71106__auto__ = e71322;
var statearr_71324_72830 = state_71295;
(statearr_71324_72830[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71295[(4)]))){
var statearr_71325_72831 = state_71295;
(statearr_71325_72831[(1)] = cljs.core.first((state_71295[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72832 = state_71295;
state_71295 = G__72832;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_71295){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_71295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71327 = f__71139__auto__();
(statearr_71327[(6)] = c__71138__auto___72802);

return statearr_71327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__71330){
var vec__71331 = p__71330;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71331,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71331,(1),null);
var job = vec__71331;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__71138__auto___72836 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71338){
var state_val_71339 = (state_71338[(1)]);
if((state_val_71339 === (1))){
var state_71338__$1 = state_71338;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71338__$1,(2),res,v);
} else {
if((state_val_71339 === (2))){
var inst_71335 = (state_71338[(2)]);
var inst_71336 = cljs.core.async.close_BANG_(res);
var state_71338__$1 = (function (){var statearr_71345 = state_71338;
(statearr_71345[(7)] = inst_71335);

return statearr_71345;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_71338__$1,inst_71336);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0 = (function (){
var statearr_71346 = [null,null,null,null,null,null,null,null];
(statearr_71346[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__);

(statearr_71346[(1)] = (1));

return statearr_71346;
});
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1 = (function (state_71338){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71338);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71349){var ex__71106__auto__ = e71349;
var statearr_71351_72837 = state_71338;
(statearr_71351_72837[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71338[(4)]))){
var statearr_71352_72838 = state_71338;
(statearr_71352_72838[(1)] = cljs.core.first((state_71338[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72840 = state_71338;
state_71338 = G__72840;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = function(state_71338){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1.call(this,state_71338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71353 = f__71139__auto__();
(statearr_71353[(6)] = c__71138__auto___72836);

return statearr_71353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__71357){
var vec__71358 = p__71357;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71358,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71358,(1),null);
var job = vec__71358;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4607__auto___72843 = n;
var __72844 = (0);
while(true){
if((__72844 < n__4607__auto___72843)){
var G__71361_72845 = type;
var G__71361_72846__$1 = (((G__71361_72845 instanceof cljs.core.Keyword))?G__71361_72845.fqn:null);
switch (G__71361_72846__$1) {
case "compute":
var c__71138__auto___72848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__72844,c__71138__auto___72848,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async){
return (function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = ((function (__72844,c__71138__auto___72848,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async){
return (function (state_71374){
var state_val_71375 = (state_71374[(1)]);
if((state_val_71375 === (1))){
var state_71374__$1 = state_71374;
var statearr_71376_72852 = state_71374__$1;
(statearr_71376_72852[(2)] = null);

(statearr_71376_72852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71375 === (2))){
var state_71374__$1 = state_71374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71374__$1,(4),jobs);
} else {
if((state_val_71375 === (3))){
var inst_71372 = (state_71374[(2)]);
var state_71374__$1 = state_71374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71374__$1,inst_71372);
} else {
if((state_val_71375 === (4))){
var inst_71364 = (state_71374[(2)]);
var inst_71365 = process(inst_71364);
var state_71374__$1 = state_71374;
if(cljs.core.truth_(inst_71365)){
var statearr_71377_72869 = state_71374__$1;
(statearr_71377_72869[(1)] = (5));

} else {
var statearr_71378_72870 = state_71374__$1;
(statearr_71378_72870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71375 === (5))){
var state_71374__$1 = state_71374;
var statearr_71381_72871 = state_71374__$1;
(statearr_71381_72871[(2)] = null);

(statearr_71381_72871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71375 === (6))){
var state_71374__$1 = state_71374;
var statearr_71383_72872 = state_71374__$1;
(statearr_71383_72872[(2)] = null);

(statearr_71383_72872[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71375 === (7))){
var inst_71370 = (state_71374[(2)]);
var state_71374__$1 = state_71374;
var statearr_71384_72874 = state_71374__$1;
(statearr_71384_72874[(2)] = inst_71370);

(statearr_71384_72874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__72844,c__71138__auto___72848,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async))
;
return ((function (__72844,switch__71102__auto__,c__71138__auto___72848,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0 = (function (){
var statearr_71385 = [null,null,null,null,null,null,null];
(statearr_71385[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__);

(statearr_71385[(1)] = (1));

return statearr_71385;
});
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1 = (function (state_71374){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71374);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71386){var ex__71106__auto__ = e71386;
var statearr_71387_72877 = state_71374;
(statearr_71387_72877[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71374[(4)]))){
var statearr_71388_72879 = state_71374;
(statearr_71388_72879[(1)] = cljs.core.first((state_71374[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72881 = state_71374;
state_71374 = G__72881;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = function(state_71374){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1.call(this,state_71374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__;
})()
;})(__72844,switch__71102__auto__,c__71138__auto___72848,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async))
})();
var state__71140__auto__ = (function (){var statearr_71389 = f__71139__auto__();
(statearr_71389[(6)] = c__71138__auto___72848);

return statearr_71389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
});})(__72844,c__71138__auto___72848,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async))
);


break;
case "async":
var c__71138__auto___72884 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__72844,c__71138__auto___72884,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async){
return (function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = ((function (__72844,c__71138__auto___72884,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async){
return (function (state_71402){
var state_val_71403 = (state_71402[(1)]);
if((state_val_71403 === (1))){
var state_71402__$1 = state_71402;
var statearr_71404_72887 = state_71402__$1;
(statearr_71404_72887[(2)] = null);

(statearr_71404_72887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71403 === (2))){
var state_71402__$1 = state_71402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71402__$1,(4),jobs);
} else {
if((state_val_71403 === (3))){
var inst_71400 = (state_71402[(2)]);
var state_71402__$1 = state_71402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71402__$1,inst_71400);
} else {
if((state_val_71403 === (4))){
var inst_71392 = (state_71402[(2)]);
var inst_71393 = async(inst_71392);
var state_71402__$1 = state_71402;
if(cljs.core.truth_(inst_71393)){
var statearr_71405_72891 = state_71402__$1;
(statearr_71405_72891[(1)] = (5));

} else {
var statearr_71406_72893 = state_71402__$1;
(statearr_71406_72893[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71403 === (5))){
var state_71402__$1 = state_71402;
var statearr_71407_72894 = state_71402__$1;
(statearr_71407_72894[(2)] = null);

(statearr_71407_72894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71403 === (6))){
var state_71402__$1 = state_71402;
var statearr_71408_72896 = state_71402__$1;
(statearr_71408_72896[(2)] = null);

(statearr_71408_72896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71403 === (7))){
var inst_71398 = (state_71402[(2)]);
var state_71402__$1 = state_71402;
var statearr_71409_72898 = state_71402__$1;
(statearr_71409_72898[(2)] = inst_71398);

(statearr_71409_72898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__72844,c__71138__auto___72884,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async))
;
return ((function (__72844,switch__71102__auto__,c__71138__auto___72884,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0 = (function (){
var statearr_71410 = [null,null,null,null,null,null,null];
(statearr_71410[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__);

(statearr_71410[(1)] = (1));

return statearr_71410;
});
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1 = (function (state_71402){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71402);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71411){var ex__71106__auto__ = e71411;
var statearr_71412_72901 = state_71402;
(statearr_71412_72901[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71402[(4)]))){
var statearr_71413_72902 = state_71402;
(statearr_71413_72902[(1)] = cljs.core.first((state_71402[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72904 = state_71402;
state_71402 = G__72904;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = function(state_71402){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1.call(this,state_71402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__;
})()
;})(__72844,switch__71102__auto__,c__71138__auto___72884,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async))
})();
var state__71140__auto__ = (function (){var statearr_71414 = f__71139__auto__();
(statearr_71414[(6)] = c__71138__auto___72884);

return statearr_71414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
});})(__72844,c__71138__auto___72884,G__71361_72845,G__71361_72846__$1,n__4607__auto___72843,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__71361_72846__$1)].join('')));

}

var G__72905 = (__72844 + (1));
__72844 = G__72905;
continue;
} else {
}
break;
}

var c__71138__auto___72906 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71439){
var state_val_71440 = (state_71439[(1)]);
if((state_val_71440 === (7))){
var inst_71435 = (state_71439[(2)]);
var state_71439__$1 = state_71439;
var statearr_71441_72910 = state_71439__$1;
(statearr_71441_72910[(2)] = inst_71435);

(statearr_71441_72910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71440 === (1))){
var state_71439__$1 = state_71439;
var statearr_71442_72911 = state_71439__$1;
(statearr_71442_72911[(2)] = null);

(statearr_71442_72911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71440 === (4))){
var inst_71417 = (state_71439[(7)]);
var inst_71417__$1 = (state_71439[(2)]);
var inst_71418 = (inst_71417__$1 == null);
var state_71439__$1 = (function (){var statearr_71443 = state_71439;
(statearr_71443[(7)] = inst_71417__$1);

return statearr_71443;
})();
if(cljs.core.truth_(inst_71418)){
var statearr_71444_72912 = state_71439__$1;
(statearr_71444_72912[(1)] = (5));

} else {
var statearr_71445_72913 = state_71439__$1;
(statearr_71445_72913[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71440 === (6))){
var inst_71424 = (state_71439[(8)]);
var inst_71417 = (state_71439[(7)]);
var inst_71424__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_71426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71427 = [inst_71417,inst_71424__$1];
var inst_71428 = (new cljs.core.PersistentVector(null,2,(5),inst_71426,inst_71427,null));
var state_71439__$1 = (function (){var statearr_71446 = state_71439;
(statearr_71446[(8)] = inst_71424__$1);

return statearr_71446;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71439__$1,(8),jobs,inst_71428);
} else {
if((state_val_71440 === (3))){
var inst_71437 = (state_71439[(2)]);
var state_71439__$1 = state_71439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71439__$1,inst_71437);
} else {
if((state_val_71440 === (2))){
var state_71439__$1 = state_71439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71439__$1,(4),from);
} else {
if((state_val_71440 === (9))){
var inst_71432 = (state_71439[(2)]);
var state_71439__$1 = (function (){var statearr_71447 = state_71439;
(statearr_71447[(9)] = inst_71432);

return statearr_71447;
})();
var statearr_71448_72914 = state_71439__$1;
(statearr_71448_72914[(2)] = null);

(statearr_71448_72914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71440 === (5))){
var inst_71421 = cljs.core.async.close_BANG_(jobs);
var state_71439__$1 = state_71439;
var statearr_71449_72915 = state_71439__$1;
(statearr_71449_72915[(2)] = inst_71421);

(statearr_71449_72915[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71440 === (8))){
var inst_71424 = (state_71439[(8)]);
var inst_71430 = (state_71439[(2)]);
var state_71439__$1 = (function (){var statearr_71450 = state_71439;
(statearr_71450[(10)] = inst_71430);

return statearr_71450;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71439__$1,(9),results,inst_71424);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0 = (function (){
var statearr_71451 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71451[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__);

(statearr_71451[(1)] = (1));

return statearr_71451;
});
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1 = (function (state_71439){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71439);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71452){var ex__71106__auto__ = e71452;
var statearr_71453_72918 = state_71439;
(statearr_71453_72918[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71439[(4)]))){
var statearr_71454_72921 = state_71439;
(statearr_71454_72921[(1)] = cljs.core.first((state_71439[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72923 = state_71439;
state_71439 = G__72923;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = function(state_71439){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1.call(this,state_71439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71457 = f__71139__auto__();
(statearr_71457[(6)] = c__71138__auto___72906);

return statearr_71457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


var c__71138__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71496){
var state_val_71497 = (state_71496[(1)]);
if((state_val_71497 === (7))){
var inst_71492 = (state_71496[(2)]);
var state_71496__$1 = state_71496;
var statearr_71498_72925 = state_71496__$1;
(statearr_71498_72925[(2)] = inst_71492);

(statearr_71498_72925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (20))){
var state_71496__$1 = state_71496;
var statearr_71500_72926 = state_71496__$1;
(statearr_71500_72926[(2)] = null);

(statearr_71500_72926[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (1))){
var state_71496__$1 = state_71496;
var statearr_71501_72927 = state_71496__$1;
(statearr_71501_72927[(2)] = null);

(statearr_71501_72927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (4))){
var inst_71461 = (state_71496[(7)]);
var inst_71461__$1 = (state_71496[(2)]);
var inst_71462 = (inst_71461__$1 == null);
var state_71496__$1 = (function (){var statearr_71502 = state_71496;
(statearr_71502[(7)] = inst_71461__$1);

return statearr_71502;
})();
if(cljs.core.truth_(inst_71462)){
var statearr_71503_72928 = state_71496__$1;
(statearr_71503_72928[(1)] = (5));

} else {
var statearr_71504_72929 = state_71496__$1;
(statearr_71504_72929[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (15))){
var inst_71474 = (state_71496[(8)]);
var state_71496__$1 = state_71496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71496__$1,(18),to,inst_71474);
} else {
if((state_val_71497 === (21))){
var inst_71487 = (state_71496[(2)]);
var state_71496__$1 = state_71496;
var statearr_71505_72930 = state_71496__$1;
(statearr_71505_72930[(2)] = inst_71487);

(statearr_71505_72930[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (13))){
var inst_71489 = (state_71496[(2)]);
var state_71496__$1 = (function (){var statearr_71506 = state_71496;
(statearr_71506[(9)] = inst_71489);

return statearr_71506;
})();
var statearr_71507_72932 = state_71496__$1;
(statearr_71507_72932[(2)] = null);

(statearr_71507_72932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (6))){
var inst_71461 = (state_71496[(7)]);
var state_71496__$1 = state_71496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71496__$1,(11),inst_71461);
} else {
if((state_val_71497 === (17))){
var inst_71482 = (state_71496[(2)]);
var state_71496__$1 = state_71496;
if(cljs.core.truth_(inst_71482)){
var statearr_71508_72935 = state_71496__$1;
(statearr_71508_72935[(1)] = (19));

} else {
var statearr_71509_72937 = state_71496__$1;
(statearr_71509_72937[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (3))){
var inst_71494 = (state_71496[(2)]);
var state_71496__$1 = state_71496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71496__$1,inst_71494);
} else {
if((state_val_71497 === (12))){
var inst_71471 = (state_71496[(10)]);
var state_71496__$1 = state_71496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71496__$1,(14),inst_71471);
} else {
if((state_val_71497 === (2))){
var state_71496__$1 = state_71496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71496__$1,(4),results);
} else {
if((state_val_71497 === (19))){
var state_71496__$1 = state_71496;
var statearr_71513_72938 = state_71496__$1;
(statearr_71513_72938[(2)] = null);

(statearr_71513_72938[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (11))){
var inst_71471 = (state_71496[(2)]);
var state_71496__$1 = (function (){var statearr_71514 = state_71496;
(statearr_71514[(10)] = inst_71471);

return statearr_71514;
})();
var statearr_71515_72939 = state_71496__$1;
(statearr_71515_72939[(2)] = null);

(statearr_71515_72939[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (9))){
var state_71496__$1 = state_71496;
var statearr_71516_72940 = state_71496__$1;
(statearr_71516_72940[(2)] = null);

(statearr_71516_72940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (5))){
var state_71496__$1 = state_71496;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71517_72943 = state_71496__$1;
(statearr_71517_72943[(1)] = (8));

} else {
var statearr_71518_72944 = state_71496__$1;
(statearr_71518_72944[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (14))){
var inst_71474 = (state_71496[(8)]);
var inst_71474__$1 = (state_71496[(2)]);
var inst_71475 = (inst_71474__$1 == null);
var inst_71476 = cljs.core.not(inst_71475);
var state_71496__$1 = (function (){var statearr_71519 = state_71496;
(statearr_71519[(8)] = inst_71474__$1);

return statearr_71519;
})();
if(inst_71476){
var statearr_71520_72945 = state_71496__$1;
(statearr_71520_72945[(1)] = (15));

} else {
var statearr_71521_72946 = state_71496__$1;
(statearr_71521_72946[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (16))){
var state_71496__$1 = state_71496;
var statearr_71522_72947 = state_71496__$1;
(statearr_71522_72947[(2)] = false);

(statearr_71522_72947[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (10))){
var inst_71468 = (state_71496[(2)]);
var state_71496__$1 = state_71496;
var statearr_71523_72948 = state_71496__$1;
(statearr_71523_72948[(2)] = inst_71468);

(statearr_71523_72948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (18))){
var inst_71479 = (state_71496[(2)]);
var state_71496__$1 = state_71496;
var statearr_71524_72953 = state_71496__$1;
(statearr_71524_72953[(2)] = inst_71479);

(statearr_71524_72953[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71497 === (8))){
var inst_71465 = cljs.core.async.close_BANG_(to);
var state_71496__$1 = state_71496;
var statearr_71525_72954 = state_71496__$1;
(statearr_71525_72954[(2)] = inst_71465);

(statearr_71525_72954[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0 = (function (){
var statearr_71526 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71526[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__);

(statearr_71526[(1)] = (1));

return statearr_71526;
});
var cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1 = (function (state_71496){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71496);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71527){var ex__71106__auto__ = e71527;
var statearr_71528_72958 = state_71496;
(statearr_71528_72958[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71496[(4)]))){
var statearr_71529_72959 = state_71496;
(statearr_71529_72959[(1)] = cljs.core.first((state_71496[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72960 = state_71496;
state_71496 = G__72960;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__ = function(state_71496){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1.call(this,state_71496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__71103__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71530 = f__71139__auto__();
(statearr_71530[(6)] = c__71138__auto__);

return statearr_71530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));

return c__71138__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__71532 = arguments.length;
switch (G__71532) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__71534 = arguments.length;
switch (G__71534) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__71536 = arguments.length;
switch (G__71536) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__71138__auto___72984 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71562){
var state_val_71563 = (state_71562[(1)]);
if((state_val_71563 === (7))){
var inst_71558 = (state_71562[(2)]);
var state_71562__$1 = state_71562;
var statearr_71564_72993 = state_71562__$1;
(statearr_71564_72993[(2)] = inst_71558);

(statearr_71564_72993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (1))){
var state_71562__$1 = state_71562;
var statearr_71565_72999 = state_71562__$1;
(statearr_71565_72999[(2)] = null);

(statearr_71565_72999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (4))){
var inst_71539 = (state_71562[(7)]);
var inst_71539__$1 = (state_71562[(2)]);
var inst_71540 = (inst_71539__$1 == null);
var state_71562__$1 = (function (){var statearr_71566 = state_71562;
(statearr_71566[(7)] = inst_71539__$1);

return statearr_71566;
})();
if(cljs.core.truth_(inst_71540)){
var statearr_71567_73017 = state_71562__$1;
(statearr_71567_73017[(1)] = (5));

} else {
var statearr_71568_73018 = state_71562__$1;
(statearr_71568_73018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (13))){
var state_71562__$1 = state_71562;
var statearr_71569_73019 = state_71562__$1;
(statearr_71569_73019[(2)] = null);

(statearr_71569_73019[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (6))){
var inst_71539 = (state_71562[(7)]);
var inst_71545 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_71539) : p.call(null,inst_71539));
var state_71562__$1 = state_71562;
if(cljs.core.truth_(inst_71545)){
var statearr_71570_73025 = state_71562__$1;
(statearr_71570_73025[(1)] = (9));

} else {
var statearr_71571_73027 = state_71562__$1;
(statearr_71571_73027[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (3))){
var inst_71560 = (state_71562[(2)]);
var state_71562__$1 = state_71562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71562__$1,inst_71560);
} else {
if((state_val_71563 === (12))){
var state_71562__$1 = state_71562;
var statearr_71572_73028 = state_71562__$1;
(statearr_71572_73028[(2)] = null);

(statearr_71572_73028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (2))){
var state_71562__$1 = state_71562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71562__$1,(4),ch);
} else {
if((state_val_71563 === (11))){
var inst_71539 = (state_71562[(7)]);
var inst_71549 = (state_71562[(2)]);
var state_71562__$1 = state_71562;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71562__$1,(8),inst_71549,inst_71539);
} else {
if((state_val_71563 === (9))){
var state_71562__$1 = state_71562;
var statearr_71573_73032 = state_71562__$1;
(statearr_71573_73032[(2)] = tc);

(statearr_71573_73032[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (5))){
var inst_71542 = cljs.core.async.close_BANG_(tc);
var inst_71543 = cljs.core.async.close_BANG_(fc);
var state_71562__$1 = (function (){var statearr_71574 = state_71562;
(statearr_71574[(8)] = inst_71542);

return statearr_71574;
})();
var statearr_71575_73035 = state_71562__$1;
(statearr_71575_73035[(2)] = inst_71543);

(statearr_71575_73035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (14))){
var inst_71556 = (state_71562[(2)]);
var state_71562__$1 = state_71562;
var statearr_71576_73036 = state_71562__$1;
(statearr_71576_73036[(2)] = inst_71556);

(statearr_71576_73036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (10))){
var state_71562__$1 = state_71562;
var statearr_71577_73039 = state_71562__$1;
(statearr_71577_73039[(2)] = fc);

(statearr_71577_73039[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71563 === (8))){
var inst_71551 = (state_71562[(2)]);
var state_71562__$1 = state_71562;
if(cljs.core.truth_(inst_71551)){
var statearr_71578_73040 = state_71562__$1;
(statearr_71578_73040[(1)] = (12));

} else {
var statearr_71579_73042 = state_71562__$1;
(statearr_71579_73042[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_71580 = [null,null,null,null,null,null,null,null,null];
(statearr_71580[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_71580[(1)] = (1));

return statearr_71580;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_71562){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71562);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71581){var ex__71106__auto__ = e71581;
var statearr_71582_73044 = state_71562;
(statearr_71582_73044[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71562[(4)]))){
var statearr_71583_73045 = state_71562;
(statearr_71583_73045[(1)] = cljs.core.first((state_71562[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73047 = state_71562;
state_71562 = G__73047;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_71562){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_71562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71584 = f__71139__auto__();
(statearr_71584[(6)] = c__71138__auto___72984);

return statearr_71584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__71138__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71606){
var state_val_71607 = (state_71606[(1)]);
if((state_val_71607 === (7))){
var inst_71602 = (state_71606[(2)]);
var state_71606__$1 = state_71606;
var statearr_71608_73053 = state_71606__$1;
(statearr_71608_73053[(2)] = inst_71602);

(statearr_71608_73053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71607 === (1))){
var inst_71585 = init;
var inst_71586 = inst_71585;
var state_71606__$1 = (function (){var statearr_71609 = state_71606;
(statearr_71609[(7)] = inst_71586);

return statearr_71609;
})();
var statearr_71610_73055 = state_71606__$1;
(statearr_71610_73055[(2)] = null);

(statearr_71610_73055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71607 === (4))){
var inst_71589 = (state_71606[(8)]);
var inst_71589__$1 = (state_71606[(2)]);
var inst_71590 = (inst_71589__$1 == null);
var state_71606__$1 = (function (){var statearr_71611 = state_71606;
(statearr_71611[(8)] = inst_71589__$1);

return statearr_71611;
})();
if(cljs.core.truth_(inst_71590)){
var statearr_71612_73058 = state_71606__$1;
(statearr_71612_73058[(1)] = (5));

} else {
var statearr_71613_73059 = state_71606__$1;
(statearr_71613_73059[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71607 === (6))){
var inst_71589 = (state_71606[(8)]);
var inst_71586 = (state_71606[(7)]);
var inst_71593 = (state_71606[(9)]);
var inst_71593__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_71586,inst_71589) : f.call(null,inst_71586,inst_71589));
var inst_71594 = cljs.core.reduced_QMARK_(inst_71593__$1);
var state_71606__$1 = (function (){var statearr_71614 = state_71606;
(statearr_71614[(9)] = inst_71593__$1);

return statearr_71614;
})();
if(inst_71594){
var statearr_71615_73063 = state_71606__$1;
(statearr_71615_73063[(1)] = (8));

} else {
var statearr_71616_73064 = state_71606__$1;
(statearr_71616_73064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71607 === (3))){
var inst_71604 = (state_71606[(2)]);
var state_71606__$1 = state_71606;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71606__$1,inst_71604);
} else {
if((state_val_71607 === (2))){
var state_71606__$1 = state_71606;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71606__$1,(4),ch);
} else {
if((state_val_71607 === (9))){
var inst_71593 = (state_71606[(9)]);
var inst_71586 = inst_71593;
var state_71606__$1 = (function (){var statearr_71617 = state_71606;
(statearr_71617[(7)] = inst_71586);

return statearr_71617;
})();
var statearr_71618_73068 = state_71606__$1;
(statearr_71618_73068[(2)] = null);

(statearr_71618_73068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71607 === (5))){
var inst_71586 = (state_71606[(7)]);
var state_71606__$1 = state_71606;
var statearr_71619_73069 = state_71606__$1;
(statearr_71619_73069[(2)] = inst_71586);

(statearr_71619_73069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71607 === (10))){
var inst_71600 = (state_71606[(2)]);
var state_71606__$1 = state_71606;
var statearr_71620_73071 = state_71606__$1;
(statearr_71620_73071[(2)] = inst_71600);

(statearr_71620_73071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71607 === (8))){
var inst_71593 = (state_71606[(9)]);
var inst_71596 = cljs.core.deref(inst_71593);
var state_71606__$1 = state_71606;
var statearr_71621_73075 = state_71606__$1;
(statearr_71621_73075[(2)] = inst_71596);

(statearr_71621_73075[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__71103__auto__ = null;
var cljs$core$async$reduce_$_state_machine__71103__auto____0 = (function (){
var statearr_71622 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71622[(0)] = cljs$core$async$reduce_$_state_machine__71103__auto__);

(statearr_71622[(1)] = (1));

return statearr_71622;
});
var cljs$core$async$reduce_$_state_machine__71103__auto____1 = (function (state_71606){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71606);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71623){var ex__71106__auto__ = e71623;
var statearr_71624_73077 = state_71606;
(statearr_71624_73077[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71606[(4)]))){
var statearr_71625_73078 = state_71606;
(statearr_71625_73078[(1)] = cljs.core.first((state_71606[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73079 = state_71606;
state_71606 = G__73079;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__71103__auto__ = function(state_71606){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__71103__auto____1.call(this,state_71606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__71103__auto____0;
cljs$core$async$reduce_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__71103__auto____1;
return cljs$core$async$reduce_$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71626 = f__71139__auto__();
(statearr_71626[(6)] = c__71138__auto__);

return statearr_71626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));

return c__71138__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__71138__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71632){
var state_val_71633 = (state_71632[(1)]);
if((state_val_71633 === (1))){
var inst_71627 = cljs.core.async.reduce(f__$1,init,ch);
var state_71632__$1 = state_71632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71632__$1,(2),inst_71627);
} else {
if((state_val_71633 === (2))){
var inst_71629 = (state_71632[(2)]);
var inst_71630 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_71629) : f__$1.call(null,inst_71629));
var state_71632__$1 = state_71632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71632__$1,inst_71630);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__71103__auto__ = null;
var cljs$core$async$transduce_$_state_machine__71103__auto____0 = (function (){
var statearr_71634 = [null,null,null,null,null,null,null];
(statearr_71634[(0)] = cljs$core$async$transduce_$_state_machine__71103__auto__);

(statearr_71634[(1)] = (1));

return statearr_71634;
});
var cljs$core$async$transduce_$_state_machine__71103__auto____1 = (function (state_71632){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71632);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71635){var ex__71106__auto__ = e71635;
var statearr_71636_73080 = state_71632;
(statearr_71636_73080[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71632[(4)]))){
var statearr_71637_73081 = state_71632;
(statearr_71637_73081[(1)] = cljs.core.first((state_71632[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73082 = state_71632;
state_71632 = G__73082;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__71103__auto__ = function(state_71632){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__71103__auto____1.call(this,state_71632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__71103__auto____0;
cljs$core$async$transduce_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__71103__auto____1;
return cljs$core$async$transduce_$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71638 = f__71139__auto__();
(statearr_71638[(6)] = c__71138__auto__);

return statearr_71638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));

return c__71138__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__71640 = arguments.length;
switch (G__71640) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__71138__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71665){
var state_val_71666 = (state_71665[(1)]);
if((state_val_71666 === (7))){
var inst_71647 = (state_71665[(2)]);
var state_71665__$1 = state_71665;
var statearr_71667_73085 = state_71665__$1;
(statearr_71667_73085[(2)] = inst_71647);

(statearr_71667_73085[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (1))){
var inst_71641 = cljs.core.seq(coll);
var inst_71642 = inst_71641;
var state_71665__$1 = (function (){var statearr_71668 = state_71665;
(statearr_71668[(7)] = inst_71642);

return statearr_71668;
})();
var statearr_71669_73086 = state_71665__$1;
(statearr_71669_73086[(2)] = null);

(statearr_71669_73086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (4))){
var inst_71642 = (state_71665[(7)]);
var inst_71645 = cljs.core.first(inst_71642);
var state_71665__$1 = state_71665;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71665__$1,(7),ch,inst_71645);
} else {
if((state_val_71666 === (13))){
var inst_71659 = (state_71665[(2)]);
var state_71665__$1 = state_71665;
var statearr_71670_73088 = state_71665__$1;
(statearr_71670_73088[(2)] = inst_71659);

(statearr_71670_73088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (6))){
var inst_71650 = (state_71665[(2)]);
var state_71665__$1 = state_71665;
if(cljs.core.truth_(inst_71650)){
var statearr_71671_73089 = state_71665__$1;
(statearr_71671_73089[(1)] = (8));

} else {
var statearr_71672_73090 = state_71665__$1;
(statearr_71672_73090[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (3))){
var inst_71663 = (state_71665[(2)]);
var state_71665__$1 = state_71665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71665__$1,inst_71663);
} else {
if((state_val_71666 === (12))){
var state_71665__$1 = state_71665;
var statearr_71673_73091 = state_71665__$1;
(statearr_71673_73091[(2)] = null);

(statearr_71673_73091[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (2))){
var inst_71642 = (state_71665[(7)]);
var state_71665__$1 = state_71665;
if(cljs.core.truth_(inst_71642)){
var statearr_71674_73092 = state_71665__$1;
(statearr_71674_73092[(1)] = (4));

} else {
var statearr_71675_73093 = state_71665__$1;
(statearr_71675_73093[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (11))){
var inst_71656 = cljs.core.async.close_BANG_(ch);
var state_71665__$1 = state_71665;
var statearr_71676_73094 = state_71665__$1;
(statearr_71676_73094[(2)] = inst_71656);

(statearr_71676_73094[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (9))){
var state_71665__$1 = state_71665;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71677_73095 = state_71665__$1;
(statearr_71677_73095[(1)] = (11));

} else {
var statearr_71678_73096 = state_71665__$1;
(statearr_71678_73096[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (5))){
var inst_71642 = (state_71665[(7)]);
var state_71665__$1 = state_71665;
var statearr_71679_73097 = state_71665__$1;
(statearr_71679_73097[(2)] = inst_71642);

(statearr_71679_73097[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (10))){
var inst_71661 = (state_71665[(2)]);
var state_71665__$1 = state_71665;
var statearr_71680_73098 = state_71665__$1;
(statearr_71680_73098[(2)] = inst_71661);

(statearr_71680_73098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71666 === (8))){
var inst_71642 = (state_71665[(7)]);
var inst_71652 = cljs.core.next(inst_71642);
var inst_71642__$1 = inst_71652;
var state_71665__$1 = (function (){var statearr_71681 = state_71665;
(statearr_71681[(7)] = inst_71642__$1);

return statearr_71681;
})();
var statearr_71682_73099 = state_71665__$1;
(statearr_71682_73099[(2)] = null);

(statearr_71682_73099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_71683 = [null,null,null,null,null,null,null,null];
(statearr_71683[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_71683[(1)] = (1));

return statearr_71683;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_71665){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71665);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71684){var ex__71106__auto__ = e71684;
var statearr_71685_73100 = state_71665;
(statearr_71685_73100[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71665[(4)]))){
var statearr_71686_73101 = state_71665;
(statearr_71686_73101[(1)] = cljs.core.first((state_71665[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73102 = state_71665;
state_71665 = G__73102;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_71665){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_71665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71687 = f__71139__auto__();
(statearr_71687[(6)] = c__71138__auto__);

return statearr_71687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));

return c__71138__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_73103 = (function (_){
var x__4422__auto__ = (((_ == null))?null:_);
var m__4423__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4423__auto__.call(null,_));
} else {
var m__4420__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4420__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_73103(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_73104 = (function (m,ch,close_QMARK_){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4423__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4420__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4420__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_73104(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_73105 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_73105(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_73106 = (function (m){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4423__auto__.call(null,m));
} else {
var m__4420__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4420__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_73106(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71688 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71688 = (function (ch,cs,meta71689){
this.ch = ch;
this.cs = cs;
this.meta71689 = meta71689;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71688.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71690,meta71689__$1){
var self__ = this;
var _71690__$1 = this;
return (new cljs.core.async.t_cljs$core$async71688(self__.ch,self__.cs,meta71689__$1));
}));

(cljs.core.async.t_cljs$core$async71688.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71690){
var self__ = this;
var _71690__$1 = this;
return self__.meta71689;
}));

(cljs.core.async.t_cljs$core$async71688.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71688.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async71688.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71688.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async71688.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async71688.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async71688.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta71689","meta71689",281343437,null)], null);
}));

(cljs.core.async.t_cljs$core$async71688.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71688.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71688");

(cljs.core.async.t_cljs$core$async71688.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71688");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71688.
 */
cljs.core.async.__GT_t_cljs$core$async71688 = (function cljs$core$async$mult_$___GT_t_cljs$core$async71688(ch__$1,cs__$1,meta71689){
return (new cljs.core.async.t_cljs$core$async71688(ch__$1,cs__$1,meta71689));
});

}

return (new cljs.core.async.t_cljs$core$async71688(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__71138__auto___73107 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_71823){
var state_val_71824 = (state_71823[(1)]);
if((state_val_71824 === (7))){
var inst_71819 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71825_73109 = state_71823__$1;
(statearr_71825_73109[(2)] = inst_71819);

(statearr_71825_73109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (20))){
var inst_71724 = (state_71823[(7)]);
var inst_71736 = cljs.core.first(inst_71724);
var inst_71737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71736,(0),null);
var inst_71738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71736,(1),null);
var state_71823__$1 = (function (){var statearr_71826 = state_71823;
(statearr_71826[(8)] = inst_71737);

return statearr_71826;
})();
if(cljs.core.truth_(inst_71738)){
var statearr_71827_73110 = state_71823__$1;
(statearr_71827_73110[(1)] = (22));

} else {
var statearr_71828_73111 = state_71823__$1;
(statearr_71828_73111[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (27))){
var inst_71766 = (state_71823[(9)]);
var inst_71773 = (state_71823[(10)]);
var inst_71768 = (state_71823[(11)]);
var inst_71693 = (state_71823[(12)]);
var inst_71773__$1 = cljs.core._nth(inst_71766,inst_71768);
var inst_71774 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_71773__$1,inst_71693,done);
var state_71823__$1 = (function (){var statearr_71829 = state_71823;
(statearr_71829[(10)] = inst_71773__$1);

return statearr_71829;
})();
if(cljs.core.truth_(inst_71774)){
var statearr_71830_73115 = state_71823__$1;
(statearr_71830_73115[(1)] = (30));

} else {
var statearr_71831_73116 = state_71823__$1;
(statearr_71831_73116[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (1))){
var state_71823__$1 = state_71823;
var statearr_71832_73117 = state_71823__$1;
(statearr_71832_73117[(2)] = null);

(statearr_71832_73117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (24))){
var inst_71724 = (state_71823[(7)]);
var inst_71743 = (state_71823[(2)]);
var inst_71744 = cljs.core.next(inst_71724);
var inst_71702 = inst_71744;
var inst_71703 = null;
var inst_71704 = (0);
var inst_71705 = (0);
var state_71823__$1 = (function (){var statearr_71833 = state_71823;
(statearr_71833[(13)] = inst_71705);

(statearr_71833[(14)] = inst_71703);

(statearr_71833[(15)] = inst_71702);

(statearr_71833[(16)] = inst_71743);

(statearr_71833[(17)] = inst_71704);

return statearr_71833;
})();
var statearr_71834_73119 = state_71823__$1;
(statearr_71834_73119[(2)] = null);

(statearr_71834_73119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (39))){
var state_71823__$1 = state_71823;
var statearr_71838_73120 = state_71823__$1;
(statearr_71838_73120[(2)] = null);

(statearr_71838_73120[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (4))){
var inst_71693 = (state_71823[(12)]);
var inst_71693__$1 = (state_71823[(2)]);
var inst_71694 = (inst_71693__$1 == null);
var state_71823__$1 = (function (){var statearr_71839 = state_71823;
(statearr_71839[(12)] = inst_71693__$1);

return statearr_71839;
})();
if(cljs.core.truth_(inst_71694)){
var statearr_71840_73122 = state_71823__$1;
(statearr_71840_73122[(1)] = (5));

} else {
var statearr_71841_73123 = state_71823__$1;
(statearr_71841_73123[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (15))){
var inst_71705 = (state_71823[(13)]);
var inst_71703 = (state_71823[(14)]);
var inst_71702 = (state_71823[(15)]);
var inst_71704 = (state_71823[(17)]);
var inst_71720 = (state_71823[(2)]);
var inst_71721 = (inst_71705 + (1));
var tmp71835 = inst_71703;
var tmp71836 = inst_71702;
var tmp71837 = inst_71704;
var inst_71702__$1 = tmp71836;
var inst_71703__$1 = tmp71835;
var inst_71704__$1 = tmp71837;
var inst_71705__$1 = inst_71721;
var state_71823__$1 = (function (){var statearr_71842 = state_71823;
(statearr_71842[(13)] = inst_71705__$1);

(statearr_71842[(14)] = inst_71703__$1);

(statearr_71842[(18)] = inst_71720);

(statearr_71842[(15)] = inst_71702__$1);

(statearr_71842[(17)] = inst_71704__$1);

return statearr_71842;
})();
var statearr_71843_73127 = state_71823__$1;
(statearr_71843_73127[(2)] = null);

(statearr_71843_73127[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (21))){
var inst_71747 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71847_73128 = state_71823__$1;
(statearr_71847_73128[(2)] = inst_71747);

(statearr_71847_73128[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (31))){
var inst_71773 = (state_71823[(10)]);
var inst_71777 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_71773);
var state_71823__$1 = state_71823;
var statearr_71848_73129 = state_71823__$1;
(statearr_71848_73129[(2)] = inst_71777);

(statearr_71848_73129[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (32))){
var inst_71766 = (state_71823[(9)]);
var inst_71765 = (state_71823[(19)]);
var inst_71768 = (state_71823[(11)]);
var inst_71767 = (state_71823[(20)]);
var inst_71779 = (state_71823[(2)]);
var inst_71780 = (inst_71768 + (1));
var tmp71844 = inst_71766;
var tmp71845 = inst_71765;
var tmp71846 = inst_71767;
var inst_71765__$1 = tmp71845;
var inst_71766__$1 = tmp71844;
var inst_71767__$1 = tmp71846;
var inst_71768__$1 = inst_71780;
var state_71823__$1 = (function (){var statearr_71849 = state_71823;
(statearr_71849[(9)] = inst_71766__$1);

(statearr_71849[(21)] = inst_71779);

(statearr_71849[(19)] = inst_71765__$1);

(statearr_71849[(11)] = inst_71768__$1);

(statearr_71849[(20)] = inst_71767__$1);

return statearr_71849;
})();
var statearr_71850_73130 = state_71823__$1;
(statearr_71850_73130[(2)] = null);

(statearr_71850_73130[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (40))){
var inst_71792 = (state_71823[(22)]);
var inst_71796 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_71792);
var state_71823__$1 = state_71823;
var statearr_71851_73131 = state_71823__$1;
(statearr_71851_73131[(2)] = inst_71796);

(statearr_71851_73131[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (33))){
var inst_71783 = (state_71823[(23)]);
var inst_71785 = cljs.core.chunked_seq_QMARK_(inst_71783);
var state_71823__$1 = state_71823;
if(inst_71785){
var statearr_71852_73132 = state_71823__$1;
(statearr_71852_73132[(1)] = (36));

} else {
var statearr_71853_73133 = state_71823__$1;
(statearr_71853_73133[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (13))){
var inst_71714 = (state_71823[(24)]);
var inst_71717 = cljs.core.async.close_BANG_(inst_71714);
var state_71823__$1 = state_71823;
var statearr_71854_73134 = state_71823__$1;
(statearr_71854_73134[(2)] = inst_71717);

(statearr_71854_73134[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (22))){
var inst_71737 = (state_71823[(8)]);
var inst_71740 = cljs.core.async.close_BANG_(inst_71737);
var state_71823__$1 = state_71823;
var statearr_71855_73135 = state_71823__$1;
(statearr_71855_73135[(2)] = inst_71740);

(statearr_71855_73135[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (36))){
var inst_71783 = (state_71823[(23)]);
var inst_71787 = cljs.core.chunk_first(inst_71783);
var inst_71788 = cljs.core.chunk_rest(inst_71783);
var inst_71789 = cljs.core.count(inst_71787);
var inst_71765 = inst_71788;
var inst_71766 = inst_71787;
var inst_71767 = inst_71789;
var inst_71768 = (0);
var state_71823__$1 = (function (){var statearr_71856 = state_71823;
(statearr_71856[(9)] = inst_71766);

(statearr_71856[(19)] = inst_71765);

(statearr_71856[(11)] = inst_71768);

(statearr_71856[(20)] = inst_71767);

return statearr_71856;
})();
var statearr_71857_73136 = state_71823__$1;
(statearr_71857_73136[(2)] = null);

(statearr_71857_73136[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (41))){
var inst_71783 = (state_71823[(23)]);
var inst_71798 = (state_71823[(2)]);
var inst_71799 = cljs.core.next(inst_71783);
var inst_71765 = inst_71799;
var inst_71766 = null;
var inst_71767 = (0);
var inst_71768 = (0);
var state_71823__$1 = (function (){var statearr_71858 = state_71823;
(statearr_71858[(9)] = inst_71766);

(statearr_71858[(25)] = inst_71798);

(statearr_71858[(19)] = inst_71765);

(statearr_71858[(11)] = inst_71768);

(statearr_71858[(20)] = inst_71767);

return statearr_71858;
})();
var statearr_71859_73137 = state_71823__$1;
(statearr_71859_73137[(2)] = null);

(statearr_71859_73137[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (43))){
var state_71823__$1 = state_71823;
var statearr_71860_73138 = state_71823__$1;
(statearr_71860_73138[(2)] = null);

(statearr_71860_73138[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (29))){
var inst_71807 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71861_73139 = state_71823__$1;
(statearr_71861_73139[(2)] = inst_71807);

(statearr_71861_73139[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (44))){
var inst_71816 = (state_71823[(2)]);
var state_71823__$1 = (function (){var statearr_71862 = state_71823;
(statearr_71862[(26)] = inst_71816);

return statearr_71862;
})();
var statearr_71863_73140 = state_71823__$1;
(statearr_71863_73140[(2)] = null);

(statearr_71863_73140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (6))){
var inst_71757 = (state_71823[(27)]);
var inst_71756 = cljs.core.deref(cs);
var inst_71757__$1 = cljs.core.keys(inst_71756);
var inst_71758 = cljs.core.count(inst_71757__$1);
var inst_71759 = cljs.core.reset_BANG_(dctr,inst_71758);
var inst_71764 = cljs.core.seq(inst_71757__$1);
var inst_71765 = inst_71764;
var inst_71766 = null;
var inst_71767 = (0);
var inst_71768 = (0);
var state_71823__$1 = (function (){var statearr_71864 = state_71823;
(statearr_71864[(9)] = inst_71766);

(statearr_71864[(19)] = inst_71765);

(statearr_71864[(28)] = inst_71759);

(statearr_71864[(11)] = inst_71768);

(statearr_71864[(20)] = inst_71767);

(statearr_71864[(27)] = inst_71757__$1);

return statearr_71864;
})();
var statearr_71865_73141 = state_71823__$1;
(statearr_71865_73141[(2)] = null);

(statearr_71865_73141[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (28))){
var inst_71765 = (state_71823[(19)]);
var inst_71783 = (state_71823[(23)]);
var inst_71783__$1 = cljs.core.seq(inst_71765);
var state_71823__$1 = (function (){var statearr_71866 = state_71823;
(statearr_71866[(23)] = inst_71783__$1);

return statearr_71866;
})();
if(inst_71783__$1){
var statearr_71867_73142 = state_71823__$1;
(statearr_71867_73142[(1)] = (33));

} else {
var statearr_71868_73143 = state_71823__$1;
(statearr_71868_73143[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (25))){
var inst_71768 = (state_71823[(11)]);
var inst_71767 = (state_71823[(20)]);
var inst_71770 = (inst_71768 < inst_71767);
var inst_71771 = inst_71770;
var state_71823__$1 = state_71823;
if(cljs.core.truth_(inst_71771)){
var statearr_71869_73144 = state_71823__$1;
(statearr_71869_73144[(1)] = (27));

} else {
var statearr_71870_73145 = state_71823__$1;
(statearr_71870_73145[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (34))){
var state_71823__$1 = state_71823;
var statearr_71871_73146 = state_71823__$1;
(statearr_71871_73146[(2)] = null);

(statearr_71871_73146[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (17))){
var state_71823__$1 = state_71823;
var statearr_71872_73147 = state_71823__$1;
(statearr_71872_73147[(2)] = null);

(statearr_71872_73147[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (3))){
var inst_71821 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71823__$1,inst_71821);
} else {
if((state_val_71824 === (12))){
var inst_71752 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71873_73148 = state_71823__$1;
(statearr_71873_73148[(2)] = inst_71752);

(statearr_71873_73148[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (2))){
var state_71823__$1 = state_71823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71823__$1,(4),ch);
} else {
if((state_val_71824 === (23))){
var state_71823__$1 = state_71823;
var statearr_71874_73151 = state_71823__$1;
(statearr_71874_73151[(2)] = null);

(statearr_71874_73151[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (35))){
var inst_71805 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71875_73153 = state_71823__$1;
(statearr_71875_73153[(2)] = inst_71805);

(statearr_71875_73153[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (19))){
var inst_71724 = (state_71823[(7)]);
var inst_71728 = cljs.core.chunk_first(inst_71724);
var inst_71729 = cljs.core.chunk_rest(inst_71724);
var inst_71730 = cljs.core.count(inst_71728);
var inst_71702 = inst_71729;
var inst_71703 = inst_71728;
var inst_71704 = inst_71730;
var inst_71705 = (0);
var state_71823__$1 = (function (){var statearr_71876 = state_71823;
(statearr_71876[(13)] = inst_71705);

(statearr_71876[(14)] = inst_71703);

(statearr_71876[(15)] = inst_71702);

(statearr_71876[(17)] = inst_71704);

return statearr_71876;
})();
var statearr_71877_73154 = state_71823__$1;
(statearr_71877_73154[(2)] = null);

(statearr_71877_73154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (11))){
var inst_71702 = (state_71823[(15)]);
var inst_71724 = (state_71823[(7)]);
var inst_71724__$1 = cljs.core.seq(inst_71702);
var state_71823__$1 = (function (){var statearr_71878 = state_71823;
(statearr_71878[(7)] = inst_71724__$1);

return statearr_71878;
})();
if(inst_71724__$1){
var statearr_71879_73155 = state_71823__$1;
(statearr_71879_73155[(1)] = (16));

} else {
var statearr_71880_73156 = state_71823__$1;
(statearr_71880_73156[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (9))){
var inst_71754 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71881_73157 = state_71823__$1;
(statearr_71881_73157[(2)] = inst_71754);

(statearr_71881_73157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (5))){
var inst_71700 = cljs.core.deref(cs);
var inst_71701 = cljs.core.seq(inst_71700);
var inst_71702 = inst_71701;
var inst_71703 = null;
var inst_71704 = (0);
var inst_71705 = (0);
var state_71823__$1 = (function (){var statearr_71882 = state_71823;
(statearr_71882[(13)] = inst_71705);

(statearr_71882[(14)] = inst_71703);

(statearr_71882[(15)] = inst_71702);

(statearr_71882[(17)] = inst_71704);

return statearr_71882;
})();
var statearr_71883_73159 = state_71823__$1;
(statearr_71883_73159[(2)] = null);

(statearr_71883_73159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (14))){
var state_71823__$1 = state_71823;
var statearr_71884_73160 = state_71823__$1;
(statearr_71884_73160[(2)] = null);

(statearr_71884_73160[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (45))){
var inst_71813 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71885_73161 = state_71823__$1;
(statearr_71885_73161[(2)] = inst_71813);

(statearr_71885_73161[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (26))){
var inst_71757 = (state_71823[(27)]);
var inst_71809 = (state_71823[(2)]);
var inst_71810 = cljs.core.seq(inst_71757);
var state_71823__$1 = (function (){var statearr_71886 = state_71823;
(statearr_71886[(29)] = inst_71809);

return statearr_71886;
})();
if(inst_71810){
var statearr_71887_73162 = state_71823__$1;
(statearr_71887_73162[(1)] = (42));

} else {
var statearr_71888_73163 = state_71823__$1;
(statearr_71888_73163[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (16))){
var inst_71724 = (state_71823[(7)]);
var inst_71726 = cljs.core.chunked_seq_QMARK_(inst_71724);
var state_71823__$1 = state_71823;
if(inst_71726){
var statearr_71889_73164 = state_71823__$1;
(statearr_71889_73164[(1)] = (19));

} else {
var statearr_71890_73165 = state_71823__$1;
(statearr_71890_73165[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (38))){
var inst_71802 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71891_73166 = state_71823__$1;
(statearr_71891_73166[(2)] = inst_71802);

(statearr_71891_73166[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (30))){
var state_71823__$1 = state_71823;
var statearr_71892_73167 = state_71823__$1;
(statearr_71892_73167[(2)] = null);

(statearr_71892_73167[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (10))){
var inst_71705 = (state_71823[(13)]);
var inst_71703 = (state_71823[(14)]);
var inst_71713 = cljs.core._nth(inst_71703,inst_71705);
var inst_71714 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71713,(0),null);
var inst_71715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71713,(1),null);
var state_71823__$1 = (function (){var statearr_71893 = state_71823;
(statearr_71893[(24)] = inst_71714);

return statearr_71893;
})();
if(cljs.core.truth_(inst_71715)){
var statearr_71894_73168 = state_71823__$1;
(statearr_71894_73168[(1)] = (13));

} else {
var statearr_71895_73169 = state_71823__$1;
(statearr_71895_73169[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (18))){
var inst_71750 = (state_71823[(2)]);
var state_71823__$1 = state_71823;
var statearr_71896_73170 = state_71823__$1;
(statearr_71896_73170[(2)] = inst_71750);

(statearr_71896_73170[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (42))){
var state_71823__$1 = state_71823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71823__$1,(45),dchan);
} else {
if((state_val_71824 === (37))){
var inst_71792 = (state_71823[(22)]);
var inst_71693 = (state_71823[(12)]);
var inst_71783 = (state_71823[(23)]);
var inst_71792__$1 = cljs.core.first(inst_71783);
var inst_71793 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_71792__$1,inst_71693,done);
var state_71823__$1 = (function (){var statearr_71897 = state_71823;
(statearr_71897[(22)] = inst_71792__$1);

return statearr_71897;
})();
if(cljs.core.truth_(inst_71793)){
var statearr_71898_73171 = state_71823__$1;
(statearr_71898_73171[(1)] = (39));

} else {
var statearr_71899_73172 = state_71823__$1;
(statearr_71899_73172[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71824 === (8))){
var inst_71705 = (state_71823[(13)]);
var inst_71704 = (state_71823[(17)]);
var inst_71707 = (inst_71705 < inst_71704);
var inst_71708 = inst_71707;
var state_71823__$1 = state_71823;
if(cljs.core.truth_(inst_71708)){
var statearr_71900_73173 = state_71823__$1;
(statearr_71900_73173[(1)] = (10));

} else {
var statearr_71901_73174 = state_71823__$1;
(statearr_71901_73174[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__71103__auto__ = null;
var cljs$core$async$mult_$_state_machine__71103__auto____0 = (function (){
var statearr_71902 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71902[(0)] = cljs$core$async$mult_$_state_machine__71103__auto__);

(statearr_71902[(1)] = (1));

return statearr_71902;
});
var cljs$core$async$mult_$_state_machine__71103__auto____1 = (function (state_71823){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_71823);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e71903){var ex__71106__auto__ = e71903;
var statearr_71904_73175 = state_71823;
(statearr_71904_73175[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_71823[(4)]))){
var statearr_71905_73176 = state_71823;
(statearr_71905_73176[(1)] = cljs.core.first((state_71823[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73177 = state_71823;
state_71823 = G__73177;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__71103__auto__ = function(state_71823){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__71103__auto____1.call(this,state_71823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__71103__auto____0;
cljs$core$async$mult_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__71103__auto____1;
return cljs$core$async$mult_$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_71906 = f__71139__auto__();
(statearr_71906[(6)] = c__71138__auto___73107);

return statearr_71906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__71908 = arguments.length;
switch (G__71908) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_73179 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_73179(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_73181 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_73181(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_73182 = (function (m){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4423__auto__.call(null,m));
} else {
var m__4420__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4420__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_73182(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_73183 = (function (m,state_map){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4423__auto__.call(null,m,state_map));
} else {
var m__4420__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4420__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_73183(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_73186 = (function (m,mode){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4423__auto__.call(null,m,mode));
} else {
var m__4420__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4420__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_73186(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___73190 = arguments.length;
var i__4731__auto___73191 = (0);
while(true){
if((i__4731__auto___73191 < len__4730__auto___73190)){
args__4736__auto__.push((arguments[i__4731__auto___73191]));

var G__73192 = (i__4731__auto___73191 + (1));
i__4731__auto___73191 = G__73192;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__71913){
var map__71914 = p__71913;
var map__71914__$1 = (((((!((map__71914 == null))))?(((((map__71914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71914.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__71914):map__71914);
var opts = map__71914__$1;
var statearr_71916_73195 = state;
(statearr_71916_73195[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_71917_73197 = state;
(statearr_71917_73197[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_71918_73198 = state;
(statearr_71918_73198[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq71909){
var G__71910 = cljs.core.first(seq71909);
var seq71909__$1 = cljs.core.next(seq71909);
var G__71911 = cljs.core.first(seq71909__$1);
var seq71909__$2 = cljs.core.next(seq71909__$1);
var G__71912 = cljs.core.first(seq71909__$2);
var seq71909__$3 = cljs.core.next(seq71909__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71910,G__71911,G__71912,seq71909__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71919 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71919 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta71920){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta71920 = meta71920;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71921,meta71920__$1){
var self__ = this;
var _71921__$1 = this;
return (new cljs.core.async.t_cljs$core$async71919(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta71920__$1));
}));

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71921){
var self__ = this;
var _71921__$1 = this;
return self__.meta71920;
}));

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71919.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71919.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta71920","meta71920",1098904105,null)], null);
}));

(cljs.core.async.t_cljs$core$async71919.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71919.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71919");

(cljs.core.async.t_cljs$core$async71919.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71919");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71919.
 */
cljs.core.async.__GT_t_cljs$core$async71919 = (function cljs$core$async$mix_$___GT_t_cljs$core$async71919(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta71920){
return (new cljs.core.async.t_cljs$core$async71919(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta71920));
});

}

return (new cljs.core.async.t_cljs$core$async71919(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__71138__auto___73213 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72023){
var state_val_72024 = (state_72023[(1)]);
if((state_val_72024 === (7))){
var inst_71938 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
var statearr_72025_73216 = state_72023__$1;
(statearr_72025_73216[(2)] = inst_71938);

(statearr_72025_73216[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (20))){
var inst_71950 = (state_72023[(7)]);
var state_72023__$1 = state_72023;
var statearr_72026_73217 = state_72023__$1;
(statearr_72026_73217[(2)] = inst_71950);

(statearr_72026_73217[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (27))){
var state_72023__$1 = state_72023;
var statearr_72027_73218 = state_72023__$1;
(statearr_72027_73218[(2)] = null);

(statearr_72027_73218[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (1))){
var inst_71925 = (state_72023[(8)]);
var inst_71925__$1 = calc_state();
var inst_71927 = (inst_71925__$1 == null);
var inst_71928 = cljs.core.not(inst_71927);
var state_72023__$1 = (function (){var statearr_72028 = state_72023;
(statearr_72028[(8)] = inst_71925__$1);

return statearr_72028;
})();
if(inst_71928){
var statearr_72029_73219 = state_72023__$1;
(statearr_72029_73219[(1)] = (2));

} else {
var statearr_72030_73220 = state_72023__$1;
(statearr_72030_73220[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (24))){
var inst_71997 = (state_72023[(9)]);
var inst_71983 = (state_72023[(10)]);
var inst_71974 = (state_72023[(11)]);
var inst_71997__$1 = (inst_71974.cljs$core$IFn$_invoke$arity$1 ? inst_71974.cljs$core$IFn$_invoke$arity$1(inst_71983) : inst_71974.call(null,inst_71983));
var state_72023__$1 = (function (){var statearr_72031 = state_72023;
(statearr_72031[(9)] = inst_71997__$1);

return statearr_72031;
})();
if(cljs.core.truth_(inst_71997__$1)){
var statearr_72032_73221 = state_72023__$1;
(statearr_72032_73221[(1)] = (29));

} else {
var statearr_72033_73222 = state_72023__$1;
(statearr_72033_73222[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (4))){
var inst_71941 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
if(cljs.core.truth_(inst_71941)){
var statearr_72034_73223 = state_72023__$1;
(statearr_72034_73223[(1)] = (8));

} else {
var statearr_72035_73224 = state_72023__$1;
(statearr_72035_73224[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (15))){
var inst_71968 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
if(cljs.core.truth_(inst_71968)){
var statearr_72036_73225 = state_72023__$1;
(statearr_72036_73225[(1)] = (19));

} else {
var statearr_72037_73226 = state_72023__$1;
(statearr_72037_73226[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (21))){
var inst_71973 = (state_72023[(12)]);
var inst_71973__$1 = (state_72023[(2)]);
var inst_71974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71973__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_71975 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71973__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_71976 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71973__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_72023__$1 = (function (){var statearr_72038 = state_72023;
(statearr_72038[(12)] = inst_71973__$1);

(statearr_72038[(13)] = inst_71975);

(statearr_72038[(11)] = inst_71974);

return statearr_72038;
})();
return cljs.core.async.ioc_alts_BANG_(state_72023__$1,(22),inst_71976);
} else {
if((state_val_72024 === (31))){
var inst_72005 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
if(cljs.core.truth_(inst_72005)){
var statearr_72039_73227 = state_72023__$1;
(statearr_72039_73227[(1)] = (32));

} else {
var statearr_72040_73228 = state_72023__$1;
(statearr_72040_73228[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (32))){
var inst_71982 = (state_72023[(14)]);
var state_72023__$1 = state_72023;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72023__$1,(35),out,inst_71982);
} else {
if((state_val_72024 === (33))){
var inst_71973 = (state_72023[(12)]);
var inst_71950 = inst_71973;
var state_72023__$1 = (function (){var statearr_72041 = state_72023;
(statearr_72041[(7)] = inst_71950);

return statearr_72041;
})();
var statearr_72042_73229 = state_72023__$1;
(statearr_72042_73229[(2)] = null);

(statearr_72042_73229[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (13))){
var inst_71950 = (state_72023[(7)]);
var inst_71957 = inst_71950.cljs$lang$protocol_mask$partition0$;
var inst_71958 = (inst_71957 & (64));
var inst_71959 = inst_71950.cljs$core$ISeq$;
var inst_71960 = (cljs.core.PROTOCOL_SENTINEL === inst_71959);
var inst_71961 = ((inst_71958) || (inst_71960));
var state_72023__$1 = state_72023;
if(cljs.core.truth_(inst_71961)){
var statearr_72043_73230 = state_72023__$1;
(statearr_72043_73230[(1)] = (16));

} else {
var statearr_72044_73231 = state_72023__$1;
(statearr_72044_73231[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (22))){
var inst_71983 = (state_72023[(10)]);
var inst_71982 = (state_72023[(14)]);
var inst_71981 = (state_72023[(2)]);
var inst_71982__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71981,(0),null);
var inst_71983__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71981,(1),null);
var inst_71984 = (inst_71982__$1 == null);
var inst_71985 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71983__$1,change);
var inst_71986 = ((inst_71984) || (inst_71985));
var state_72023__$1 = (function (){var statearr_72045 = state_72023;
(statearr_72045[(10)] = inst_71983__$1);

(statearr_72045[(14)] = inst_71982__$1);

return statearr_72045;
})();
if(cljs.core.truth_(inst_71986)){
var statearr_72046_73232 = state_72023__$1;
(statearr_72046_73232[(1)] = (23));

} else {
var statearr_72047_73233 = state_72023__$1;
(statearr_72047_73233[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (36))){
var inst_71973 = (state_72023[(12)]);
var inst_71950 = inst_71973;
var state_72023__$1 = (function (){var statearr_72048 = state_72023;
(statearr_72048[(7)] = inst_71950);

return statearr_72048;
})();
var statearr_72049_73234 = state_72023__$1;
(statearr_72049_73234[(2)] = null);

(statearr_72049_73234[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (29))){
var inst_71997 = (state_72023[(9)]);
var state_72023__$1 = state_72023;
var statearr_72050_73235 = state_72023__$1;
(statearr_72050_73235[(2)] = inst_71997);

(statearr_72050_73235[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (6))){
var state_72023__$1 = state_72023;
var statearr_72051_73236 = state_72023__$1;
(statearr_72051_73236[(2)] = false);

(statearr_72051_73236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (28))){
var inst_71993 = (state_72023[(2)]);
var inst_71994 = calc_state();
var inst_71950 = inst_71994;
var state_72023__$1 = (function (){var statearr_72052 = state_72023;
(statearr_72052[(15)] = inst_71993);

(statearr_72052[(7)] = inst_71950);

return statearr_72052;
})();
var statearr_72053_73237 = state_72023__$1;
(statearr_72053_73237[(2)] = null);

(statearr_72053_73237[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (25))){
var inst_72019 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
var statearr_72054_73238 = state_72023__$1;
(statearr_72054_73238[(2)] = inst_72019);

(statearr_72054_73238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (34))){
var inst_72017 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
var statearr_72055_73239 = state_72023__$1;
(statearr_72055_73239[(2)] = inst_72017);

(statearr_72055_73239[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (17))){
var state_72023__$1 = state_72023;
var statearr_72056_73240 = state_72023__$1;
(statearr_72056_73240[(2)] = false);

(statearr_72056_73240[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (3))){
var state_72023__$1 = state_72023;
var statearr_72057_73241 = state_72023__$1;
(statearr_72057_73241[(2)] = false);

(statearr_72057_73241[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (12))){
var inst_72021 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72023__$1,inst_72021);
} else {
if((state_val_72024 === (2))){
var inst_71925 = (state_72023[(8)]);
var inst_71930 = inst_71925.cljs$lang$protocol_mask$partition0$;
var inst_71931 = (inst_71930 & (64));
var inst_71932 = inst_71925.cljs$core$ISeq$;
var inst_71933 = (cljs.core.PROTOCOL_SENTINEL === inst_71932);
var inst_71934 = ((inst_71931) || (inst_71933));
var state_72023__$1 = state_72023;
if(cljs.core.truth_(inst_71934)){
var statearr_72058_73242 = state_72023__$1;
(statearr_72058_73242[(1)] = (5));

} else {
var statearr_72059_73243 = state_72023__$1;
(statearr_72059_73243[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (23))){
var inst_71982 = (state_72023[(14)]);
var inst_71988 = (inst_71982 == null);
var state_72023__$1 = state_72023;
if(cljs.core.truth_(inst_71988)){
var statearr_72060_73244 = state_72023__$1;
(statearr_72060_73244[(1)] = (26));

} else {
var statearr_72061_73245 = state_72023__$1;
(statearr_72061_73245[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (35))){
var inst_72008 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
if(cljs.core.truth_(inst_72008)){
var statearr_72062_73246 = state_72023__$1;
(statearr_72062_73246[(1)] = (36));

} else {
var statearr_72063_73247 = state_72023__$1;
(statearr_72063_73247[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (19))){
var inst_71950 = (state_72023[(7)]);
var inst_71970 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_71950);
var state_72023__$1 = state_72023;
var statearr_72064_73248 = state_72023__$1;
(statearr_72064_73248[(2)] = inst_71970);

(statearr_72064_73248[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (11))){
var inst_71950 = (state_72023[(7)]);
var inst_71954 = (inst_71950 == null);
var inst_71955 = cljs.core.not(inst_71954);
var state_72023__$1 = state_72023;
if(inst_71955){
var statearr_72065_73249 = state_72023__$1;
(statearr_72065_73249[(1)] = (13));

} else {
var statearr_72066_73250 = state_72023__$1;
(statearr_72066_73250[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (9))){
var inst_71925 = (state_72023[(8)]);
var state_72023__$1 = state_72023;
var statearr_72067_73251 = state_72023__$1;
(statearr_72067_73251[(2)] = inst_71925);

(statearr_72067_73251[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (5))){
var state_72023__$1 = state_72023;
var statearr_72068_73252 = state_72023__$1;
(statearr_72068_73252[(2)] = true);

(statearr_72068_73252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (14))){
var state_72023__$1 = state_72023;
var statearr_72069_73253 = state_72023__$1;
(statearr_72069_73253[(2)] = false);

(statearr_72069_73253[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (26))){
var inst_71983 = (state_72023[(10)]);
var inst_71990 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_71983);
var state_72023__$1 = state_72023;
var statearr_72070_73254 = state_72023__$1;
(statearr_72070_73254[(2)] = inst_71990);

(statearr_72070_73254[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (16))){
var state_72023__$1 = state_72023;
var statearr_72071_73255 = state_72023__$1;
(statearr_72071_73255[(2)] = true);

(statearr_72071_73255[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (38))){
var inst_72013 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
var statearr_72072_73256 = state_72023__$1;
(statearr_72072_73256[(2)] = inst_72013);

(statearr_72072_73256[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (30))){
var inst_71975 = (state_72023[(13)]);
var inst_71983 = (state_72023[(10)]);
var inst_71974 = (state_72023[(11)]);
var inst_72000 = cljs.core.empty_QMARK_(inst_71974);
var inst_72001 = (inst_71975.cljs$core$IFn$_invoke$arity$1 ? inst_71975.cljs$core$IFn$_invoke$arity$1(inst_71983) : inst_71975.call(null,inst_71983));
var inst_72002 = cljs.core.not(inst_72001);
var inst_72003 = ((inst_72000) && (inst_72002));
var state_72023__$1 = state_72023;
var statearr_72073_73257 = state_72023__$1;
(statearr_72073_73257[(2)] = inst_72003);

(statearr_72073_73257[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (10))){
var inst_71925 = (state_72023[(8)]);
var inst_71946 = (state_72023[(2)]);
var inst_71947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71946,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_71948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71946,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_71949 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71946,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_71950 = inst_71925;
var state_72023__$1 = (function (){var statearr_72074 = state_72023;
(statearr_72074[(16)] = inst_71947);

(statearr_72074[(17)] = inst_71948);

(statearr_72074[(7)] = inst_71950);

(statearr_72074[(18)] = inst_71949);

return statearr_72074;
})();
var statearr_72075_73258 = state_72023__$1;
(statearr_72075_73258[(2)] = null);

(statearr_72075_73258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (18))){
var inst_71965 = (state_72023[(2)]);
var state_72023__$1 = state_72023;
var statearr_72076_73259 = state_72023__$1;
(statearr_72076_73259[(2)] = inst_71965);

(statearr_72076_73259[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (37))){
var state_72023__$1 = state_72023;
var statearr_72077_73260 = state_72023__$1;
(statearr_72077_73260[(2)] = null);

(statearr_72077_73260[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72024 === (8))){
var inst_71925 = (state_72023[(8)]);
var inst_71943 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_71925);
var state_72023__$1 = state_72023;
var statearr_72078_73261 = state_72023__$1;
(statearr_72078_73261[(2)] = inst_71943);

(statearr_72078_73261[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__71103__auto__ = null;
var cljs$core$async$mix_$_state_machine__71103__auto____0 = (function (){
var statearr_72079 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72079[(0)] = cljs$core$async$mix_$_state_machine__71103__auto__);

(statearr_72079[(1)] = (1));

return statearr_72079;
});
var cljs$core$async$mix_$_state_machine__71103__auto____1 = (function (state_72023){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72023);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72080){var ex__71106__auto__ = e72080;
var statearr_72081_73262 = state_72023;
(statearr_72081_73262[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72023[(4)]))){
var statearr_72082_73263 = state_72023;
(statearr_72082_73263[(1)] = cljs.core.first((state_72023[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73264 = state_72023;
state_72023 = G__73264;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__71103__auto__ = function(state_72023){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__71103__auto____1.call(this,state_72023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__71103__auto____0;
cljs$core$async$mix_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__71103__auto____1;
return cljs$core$async$mix_$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72083 = f__71139__auto__();
(statearr_72083[(6)] = c__71138__auto___73213);

return statearr_72083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_73265 = (function (p,v,ch,close_QMARK_){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4423__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4420__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4420__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_73265(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_73266 = (function (p,v,ch){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4423__auto__.call(null,p,v,ch));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4420__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_73266(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_73267 = (function() {
var G__73268 = null;
var G__73268__1 = (function (p){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4423__auto__.call(null,p));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4420__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__73268__2 = (function (p,v){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4423__auto__.call(null,p,v));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4420__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__73268 = function(p,v){
switch(arguments.length){
case 1:
return G__73268__1.call(this,p);
case 2:
return G__73268__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__73268.cljs$core$IFn$_invoke$arity$1 = G__73268__1;
G__73268.cljs$core$IFn$_invoke$arity$2 = G__73268__2;
return G__73268;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__72085 = arguments.length;
switch (G__72085) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_73267(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_73267(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__72088 = arguments.length;
switch (G__72088) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4120__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__72086_SHARP_){
if(cljs.core.truth_((p1__72086_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__72086_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__72086_SHARP_.call(null,topic)))){
return p1__72086_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__72086_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72089 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72089 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta72090){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta72090 = meta72090;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72091,meta72090__$1){
var self__ = this;
var _72091__$1 = this;
return (new cljs.core.async.t_cljs$core$async72089(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta72090__$1));
}));

(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72091){
var self__ = this;
var _72091__$1 = this;
return self__.meta72090;
}));

(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async72089.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async72089.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta72090","meta72090",-604293647,null)], null);
}));

(cljs.core.async.t_cljs$core$async72089.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72089.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72089");

(cljs.core.async.t_cljs$core$async72089.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72089");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72089.
 */
cljs.core.async.__GT_t_cljs$core$async72089 = (function cljs$core$async$__GT_t_cljs$core$async72089(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta72090){
return (new cljs.core.async.t_cljs$core$async72089(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta72090));
});

}

return (new cljs.core.async.t_cljs$core$async72089(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__71138__auto___73271 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72163){
var state_val_72164 = (state_72163[(1)]);
if((state_val_72164 === (7))){
var inst_72159 = (state_72163[(2)]);
var state_72163__$1 = state_72163;
var statearr_72165_73272 = state_72163__$1;
(statearr_72165_73272[(2)] = inst_72159);

(statearr_72165_73272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (20))){
var state_72163__$1 = state_72163;
var statearr_72166_73273 = state_72163__$1;
(statearr_72166_73273[(2)] = null);

(statearr_72166_73273[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (1))){
var state_72163__$1 = state_72163;
var statearr_72167_73274 = state_72163__$1;
(statearr_72167_73274[(2)] = null);

(statearr_72167_73274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (24))){
var inst_72142 = (state_72163[(7)]);
var inst_72151 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_72142);
var state_72163__$1 = state_72163;
var statearr_72168_73275 = state_72163__$1;
(statearr_72168_73275[(2)] = inst_72151);

(statearr_72168_73275[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (4))){
var inst_72094 = (state_72163[(8)]);
var inst_72094__$1 = (state_72163[(2)]);
var inst_72095 = (inst_72094__$1 == null);
var state_72163__$1 = (function (){var statearr_72169 = state_72163;
(statearr_72169[(8)] = inst_72094__$1);

return statearr_72169;
})();
if(cljs.core.truth_(inst_72095)){
var statearr_72170_73276 = state_72163__$1;
(statearr_72170_73276[(1)] = (5));

} else {
var statearr_72171_73277 = state_72163__$1;
(statearr_72171_73277[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (15))){
var inst_72136 = (state_72163[(2)]);
var state_72163__$1 = state_72163;
var statearr_72172_73278 = state_72163__$1;
(statearr_72172_73278[(2)] = inst_72136);

(statearr_72172_73278[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (21))){
var inst_72156 = (state_72163[(2)]);
var state_72163__$1 = (function (){var statearr_72173 = state_72163;
(statearr_72173[(9)] = inst_72156);

return statearr_72173;
})();
var statearr_72174_73280 = state_72163__$1;
(statearr_72174_73280[(2)] = null);

(statearr_72174_73280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (13))){
var inst_72118 = (state_72163[(10)]);
var inst_72120 = cljs.core.chunked_seq_QMARK_(inst_72118);
var state_72163__$1 = state_72163;
if(inst_72120){
var statearr_72175_73281 = state_72163__$1;
(statearr_72175_73281[(1)] = (16));

} else {
var statearr_72176_73282 = state_72163__$1;
(statearr_72176_73282[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (22))){
var inst_72148 = (state_72163[(2)]);
var state_72163__$1 = state_72163;
if(cljs.core.truth_(inst_72148)){
var statearr_72177_73286 = state_72163__$1;
(statearr_72177_73286[(1)] = (23));

} else {
var statearr_72178_73287 = state_72163__$1;
(statearr_72178_73287[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (6))){
var inst_72144 = (state_72163[(11)]);
var inst_72142 = (state_72163[(7)]);
var inst_72094 = (state_72163[(8)]);
var inst_72142__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_72094) : topic_fn.call(null,inst_72094));
var inst_72143 = cljs.core.deref(mults);
var inst_72144__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72143,inst_72142__$1);
var state_72163__$1 = (function (){var statearr_72179 = state_72163;
(statearr_72179[(11)] = inst_72144__$1);

(statearr_72179[(7)] = inst_72142__$1);

return statearr_72179;
})();
if(cljs.core.truth_(inst_72144__$1)){
var statearr_72180_73288 = state_72163__$1;
(statearr_72180_73288[(1)] = (19));

} else {
var statearr_72181_73289 = state_72163__$1;
(statearr_72181_73289[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (25))){
var inst_72153 = (state_72163[(2)]);
var state_72163__$1 = state_72163;
var statearr_72182_73290 = state_72163__$1;
(statearr_72182_73290[(2)] = inst_72153);

(statearr_72182_73290[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (17))){
var inst_72118 = (state_72163[(10)]);
var inst_72127 = cljs.core.first(inst_72118);
var inst_72128 = cljs.core.async.muxch_STAR_(inst_72127);
var inst_72129 = cljs.core.async.close_BANG_(inst_72128);
var inst_72130 = cljs.core.next(inst_72118);
var inst_72104 = inst_72130;
var inst_72105 = null;
var inst_72106 = (0);
var inst_72107 = (0);
var state_72163__$1 = (function (){var statearr_72183 = state_72163;
(statearr_72183[(12)] = inst_72106);

(statearr_72183[(13)] = inst_72104);

(statearr_72183[(14)] = inst_72129);

(statearr_72183[(15)] = inst_72107);

(statearr_72183[(16)] = inst_72105);

return statearr_72183;
})();
var statearr_72184_73291 = state_72163__$1;
(statearr_72184_73291[(2)] = null);

(statearr_72184_73291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (3))){
var inst_72161 = (state_72163[(2)]);
var state_72163__$1 = state_72163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72163__$1,inst_72161);
} else {
if((state_val_72164 === (12))){
var inst_72138 = (state_72163[(2)]);
var state_72163__$1 = state_72163;
var statearr_72185_73293 = state_72163__$1;
(statearr_72185_73293[(2)] = inst_72138);

(statearr_72185_73293[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (2))){
var state_72163__$1 = state_72163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72163__$1,(4),ch);
} else {
if((state_val_72164 === (23))){
var state_72163__$1 = state_72163;
var statearr_72186_73294 = state_72163__$1;
(statearr_72186_73294[(2)] = null);

(statearr_72186_73294[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (19))){
var inst_72144 = (state_72163[(11)]);
var inst_72094 = (state_72163[(8)]);
var inst_72146 = cljs.core.async.muxch_STAR_(inst_72144);
var state_72163__$1 = state_72163;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72163__$1,(22),inst_72146,inst_72094);
} else {
if((state_val_72164 === (11))){
var inst_72104 = (state_72163[(13)]);
var inst_72118 = (state_72163[(10)]);
var inst_72118__$1 = cljs.core.seq(inst_72104);
var state_72163__$1 = (function (){var statearr_72187 = state_72163;
(statearr_72187[(10)] = inst_72118__$1);

return statearr_72187;
})();
if(inst_72118__$1){
var statearr_72188_73298 = state_72163__$1;
(statearr_72188_73298[(1)] = (13));

} else {
var statearr_72189_73299 = state_72163__$1;
(statearr_72189_73299[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (9))){
var inst_72140 = (state_72163[(2)]);
var state_72163__$1 = state_72163;
var statearr_72190_73300 = state_72163__$1;
(statearr_72190_73300[(2)] = inst_72140);

(statearr_72190_73300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (5))){
var inst_72101 = cljs.core.deref(mults);
var inst_72102 = cljs.core.vals(inst_72101);
var inst_72103 = cljs.core.seq(inst_72102);
var inst_72104 = inst_72103;
var inst_72105 = null;
var inst_72106 = (0);
var inst_72107 = (0);
var state_72163__$1 = (function (){var statearr_72191 = state_72163;
(statearr_72191[(12)] = inst_72106);

(statearr_72191[(13)] = inst_72104);

(statearr_72191[(15)] = inst_72107);

(statearr_72191[(16)] = inst_72105);

return statearr_72191;
})();
var statearr_72192_73301 = state_72163__$1;
(statearr_72192_73301[(2)] = null);

(statearr_72192_73301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (14))){
var state_72163__$1 = state_72163;
var statearr_72196_73302 = state_72163__$1;
(statearr_72196_73302[(2)] = null);

(statearr_72196_73302[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (16))){
var inst_72118 = (state_72163[(10)]);
var inst_72122 = cljs.core.chunk_first(inst_72118);
var inst_72123 = cljs.core.chunk_rest(inst_72118);
var inst_72124 = cljs.core.count(inst_72122);
var inst_72104 = inst_72123;
var inst_72105 = inst_72122;
var inst_72106 = inst_72124;
var inst_72107 = (0);
var state_72163__$1 = (function (){var statearr_72197 = state_72163;
(statearr_72197[(12)] = inst_72106);

(statearr_72197[(13)] = inst_72104);

(statearr_72197[(15)] = inst_72107);

(statearr_72197[(16)] = inst_72105);

return statearr_72197;
})();
var statearr_72198_73304 = state_72163__$1;
(statearr_72198_73304[(2)] = null);

(statearr_72198_73304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (10))){
var inst_72106 = (state_72163[(12)]);
var inst_72104 = (state_72163[(13)]);
var inst_72107 = (state_72163[(15)]);
var inst_72105 = (state_72163[(16)]);
var inst_72112 = cljs.core._nth(inst_72105,inst_72107);
var inst_72113 = cljs.core.async.muxch_STAR_(inst_72112);
var inst_72114 = cljs.core.async.close_BANG_(inst_72113);
var inst_72115 = (inst_72107 + (1));
var tmp72193 = inst_72106;
var tmp72194 = inst_72104;
var tmp72195 = inst_72105;
var inst_72104__$1 = tmp72194;
var inst_72105__$1 = tmp72195;
var inst_72106__$1 = tmp72193;
var inst_72107__$1 = inst_72115;
var state_72163__$1 = (function (){var statearr_72199 = state_72163;
(statearr_72199[(12)] = inst_72106__$1);

(statearr_72199[(13)] = inst_72104__$1);

(statearr_72199[(17)] = inst_72114);

(statearr_72199[(15)] = inst_72107__$1);

(statearr_72199[(16)] = inst_72105__$1);

return statearr_72199;
})();
var statearr_72200_73308 = state_72163__$1;
(statearr_72200_73308[(2)] = null);

(statearr_72200_73308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (18))){
var inst_72133 = (state_72163[(2)]);
var state_72163__$1 = state_72163;
var statearr_72201_73310 = state_72163__$1;
(statearr_72201_73310[(2)] = inst_72133);

(statearr_72201_73310[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72164 === (8))){
var inst_72106 = (state_72163[(12)]);
var inst_72107 = (state_72163[(15)]);
var inst_72109 = (inst_72107 < inst_72106);
var inst_72110 = inst_72109;
var state_72163__$1 = state_72163;
if(cljs.core.truth_(inst_72110)){
var statearr_72202_73311 = state_72163__$1;
(statearr_72202_73311[(1)] = (10));

} else {
var statearr_72203_73312 = state_72163__$1;
(statearr_72203_73312[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_72204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72204[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_72204[(1)] = (1));

return statearr_72204;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_72163){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72163);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72205){var ex__71106__auto__ = e72205;
var statearr_72206_73316 = state_72163;
(statearr_72206_73316[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72163[(4)]))){
var statearr_72207_73317 = state_72163;
(statearr_72207_73317[(1)] = cljs.core.first((state_72163[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73318 = state_72163;
state_72163 = G__73318;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_72163){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_72163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72208 = f__71139__auto__();
(statearr_72208[(6)] = c__71138__auto___73271);

return statearr_72208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__72210 = arguments.length;
switch (G__72210) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__72212 = arguments.length;
switch (G__72212) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__72214 = arguments.length;
switch (G__72214) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__71138__auto___73325 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72257){
var state_val_72258 = (state_72257[(1)]);
if((state_val_72258 === (7))){
var state_72257__$1 = state_72257;
var statearr_72259_73326 = state_72257__$1;
(statearr_72259_73326[(2)] = null);

(statearr_72259_73326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (1))){
var state_72257__$1 = state_72257;
var statearr_72260_73327 = state_72257__$1;
(statearr_72260_73327[(2)] = null);

(statearr_72260_73327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (4))){
var inst_72218 = (state_72257[(7)]);
var inst_72217 = (state_72257[(8)]);
var inst_72220 = (inst_72218 < inst_72217);
var state_72257__$1 = state_72257;
if(cljs.core.truth_(inst_72220)){
var statearr_72261_73328 = state_72257__$1;
(statearr_72261_73328[(1)] = (6));

} else {
var statearr_72262_73329 = state_72257__$1;
(statearr_72262_73329[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (15))){
var inst_72243 = (state_72257[(9)]);
var inst_72248 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_72243);
var state_72257__$1 = state_72257;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72257__$1,(17),out,inst_72248);
} else {
if((state_val_72258 === (13))){
var inst_72243 = (state_72257[(9)]);
var inst_72243__$1 = (state_72257[(2)]);
var inst_72244 = cljs.core.some(cljs.core.nil_QMARK_,inst_72243__$1);
var state_72257__$1 = (function (){var statearr_72263 = state_72257;
(statearr_72263[(9)] = inst_72243__$1);

return statearr_72263;
})();
if(cljs.core.truth_(inst_72244)){
var statearr_72264_73330 = state_72257__$1;
(statearr_72264_73330[(1)] = (14));

} else {
var statearr_72265_73331 = state_72257__$1;
(statearr_72265_73331[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (6))){
var state_72257__$1 = state_72257;
var statearr_72266_73332 = state_72257__$1;
(statearr_72266_73332[(2)] = null);

(statearr_72266_73332[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (17))){
var inst_72250 = (state_72257[(2)]);
var state_72257__$1 = (function (){var statearr_72268 = state_72257;
(statearr_72268[(10)] = inst_72250);

return statearr_72268;
})();
var statearr_72269_73333 = state_72257__$1;
(statearr_72269_73333[(2)] = null);

(statearr_72269_73333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (3))){
var inst_72255 = (state_72257[(2)]);
var state_72257__$1 = state_72257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72257__$1,inst_72255);
} else {
if((state_val_72258 === (12))){
var _ = (function (){var statearr_72270 = state_72257;
(statearr_72270[(4)] = cljs.core.rest((state_72257[(4)])));

return statearr_72270;
})();
var state_72257__$1 = state_72257;
var ex72267 = (state_72257__$1[(2)]);
var statearr_72271_73334 = state_72257__$1;
(statearr_72271_73334[(5)] = ex72267);


if((ex72267 instanceof Object)){
var statearr_72272_73335 = state_72257__$1;
(statearr_72272_73335[(1)] = (11));

(statearr_72272_73335[(5)] = null);

} else {
throw ex72267;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (2))){
var inst_72216 = cljs.core.reset_BANG_(dctr,cnt);
var inst_72217 = cnt;
var inst_72218 = (0);
var state_72257__$1 = (function (){var statearr_72273 = state_72257;
(statearr_72273[(7)] = inst_72218);

(statearr_72273[(8)] = inst_72217);

(statearr_72273[(11)] = inst_72216);

return statearr_72273;
})();
var statearr_72274_73339 = state_72257__$1;
(statearr_72274_73339[(2)] = null);

(statearr_72274_73339[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (11))){
var inst_72222 = (state_72257[(2)]);
var inst_72223 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_72257__$1 = (function (){var statearr_72275 = state_72257;
(statearr_72275[(12)] = inst_72222);

return statearr_72275;
})();
var statearr_72276_73340 = state_72257__$1;
(statearr_72276_73340[(2)] = inst_72223);

(statearr_72276_73340[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (9))){
var inst_72218 = (state_72257[(7)]);
var _ = (function (){var statearr_72277 = state_72257;
(statearr_72277[(4)] = cljs.core.cons((12),(state_72257[(4)])));

return statearr_72277;
})();
var inst_72229 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_72218) : chs__$1.call(null,inst_72218));
var inst_72230 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_72218) : done.call(null,inst_72218));
var inst_72231 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72229,inst_72230);
var ___$1 = (function (){var statearr_72278 = state_72257;
(statearr_72278[(4)] = cljs.core.rest((state_72257[(4)])));

return statearr_72278;
})();
var state_72257__$1 = state_72257;
var statearr_72279_73341 = state_72257__$1;
(statearr_72279_73341[(2)] = inst_72231);

(statearr_72279_73341[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (5))){
var inst_72241 = (state_72257[(2)]);
var state_72257__$1 = (function (){var statearr_72280 = state_72257;
(statearr_72280[(13)] = inst_72241);

return statearr_72280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72257__$1,(13),dchan);
} else {
if((state_val_72258 === (14))){
var inst_72246 = cljs.core.async.close_BANG_(out);
var state_72257__$1 = state_72257;
var statearr_72281_73342 = state_72257__$1;
(statearr_72281_73342[(2)] = inst_72246);

(statearr_72281_73342[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (16))){
var inst_72253 = (state_72257[(2)]);
var state_72257__$1 = state_72257;
var statearr_72282_73343 = state_72257__$1;
(statearr_72282_73343[(2)] = inst_72253);

(statearr_72282_73343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (10))){
var inst_72218 = (state_72257[(7)]);
var inst_72234 = (state_72257[(2)]);
var inst_72235 = (inst_72218 + (1));
var inst_72218__$1 = inst_72235;
var state_72257__$1 = (function (){var statearr_72283 = state_72257;
(statearr_72283[(14)] = inst_72234);

(statearr_72283[(7)] = inst_72218__$1);

return statearr_72283;
})();
var statearr_72284_73347 = state_72257__$1;
(statearr_72284_73347[(2)] = null);

(statearr_72284_73347[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72258 === (8))){
var inst_72239 = (state_72257[(2)]);
var state_72257__$1 = state_72257;
var statearr_72285_73348 = state_72257__$1;
(statearr_72285_73348[(2)] = inst_72239);

(statearr_72285_73348[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_72286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72286[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_72286[(1)] = (1));

return statearr_72286;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_72257){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72257);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72287){var ex__71106__auto__ = e72287;
var statearr_72288_73349 = state_72257;
(statearr_72288_73349[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72257[(4)]))){
var statearr_72289_73350 = state_72257;
(statearr_72289_73350[(1)] = cljs.core.first((state_72257[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73353 = state_72257;
state_72257 = G__73353;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_72257){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_72257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72290 = f__71139__auto__();
(statearr_72290[(6)] = c__71138__auto___73325);

return statearr_72290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__72293 = arguments.length;
switch (G__72293) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__71138__auto___73356 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72325){
var state_val_72326 = (state_72325[(1)]);
if((state_val_72326 === (7))){
var inst_72304 = (state_72325[(7)]);
var inst_72305 = (state_72325[(8)]);
var inst_72304__$1 = (state_72325[(2)]);
var inst_72305__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72304__$1,(0),null);
var inst_72306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72304__$1,(1),null);
var inst_72307 = (inst_72305__$1 == null);
var state_72325__$1 = (function (){var statearr_72327 = state_72325;
(statearr_72327[(7)] = inst_72304__$1);

(statearr_72327[(8)] = inst_72305__$1);

(statearr_72327[(9)] = inst_72306);

return statearr_72327;
})();
if(cljs.core.truth_(inst_72307)){
var statearr_72328_73357 = state_72325__$1;
(statearr_72328_73357[(1)] = (8));

} else {
var statearr_72329_73358 = state_72325__$1;
(statearr_72329_73358[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72326 === (1))){
var inst_72294 = cljs.core.vec(chs);
var inst_72295 = inst_72294;
var state_72325__$1 = (function (){var statearr_72330 = state_72325;
(statearr_72330[(10)] = inst_72295);

return statearr_72330;
})();
var statearr_72331_73359 = state_72325__$1;
(statearr_72331_73359[(2)] = null);

(statearr_72331_73359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72326 === (4))){
var inst_72295 = (state_72325[(10)]);
var state_72325__$1 = state_72325;
return cljs.core.async.ioc_alts_BANG_(state_72325__$1,(7),inst_72295);
} else {
if((state_val_72326 === (6))){
var inst_72321 = (state_72325[(2)]);
var state_72325__$1 = state_72325;
var statearr_72332_73360 = state_72325__$1;
(statearr_72332_73360[(2)] = inst_72321);

(statearr_72332_73360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72326 === (3))){
var inst_72323 = (state_72325[(2)]);
var state_72325__$1 = state_72325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72325__$1,inst_72323);
} else {
if((state_val_72326 === (2))){
var inst_72295 = (state_72325[(10)]);
var inst_72297 = cljs.core.count(inst_72295);
var inst_72298 = (inst_72297 > (0));
var state_72325__$1 = state_72325;
if(cljs.core.truth_(inst_72298)){
var statearr_72334_73361 = state_72325__$1;
(statearr_72334_73361[(1)] = (4));

} else {
var statearr_72335_73362 = state_72325__$1;
(statearr_72335_73362[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72326 === (11))){
var inst_72295 = (state_72325[(10)]);
var inst_72314 = (state_72325[(2)]);
var tmp72333 = inst_72295;
var inst_72295__$1 = tmp72333;
var state_72325__$1 = (function (){var statearr_72336 = state_72325;
(statearr_72336[(11)] = inst_72314);

(statearr_72336[(10)] = inst_72295__$1);

return statearr_72336;
})();
var statearr_72337_73363 = state_72325__$1;
(statearr_72337_73363[(2)] = null);

(statearr_72337_73363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72326 === (9))){
var inst_72305 = (state_72325[(8)]);
var state_72325__$1 = state_72325;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72325__$1,(11),out,inst_72305);
} else {
if((state_val_72326 === (5))){
var inst_72319 = cljs.core.async.close_BANG_(out);
var state_72325__$1 = state_72325;
var statearr_72338_73364 = state_72325__$1;
(statearr_72338_73364[(2)] = inst_72319);

(statearr_72338_73364[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72326 === (10))){
var inst_72317 = (state_72325[(2)]);
var state_72325__$1 = state_72325;
var statearr_72339_73365 = state_72325__$1;
(statearr_72339_73365[(2)] = inst_72317);

(statearr_72339_73365[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72326 === (8))){
var inst_72304 = (state_72325[(7)]);
var inst_72305 = (state_72325[(8)]);
var inst_72306 = (state_72325[(9)]);
var inst_72295 = (state_72325[(10)]);
var inst_72309 = (function (){var cs = inst_72295;
var vec__72300 = inst_72304;
var v = inst_72305;
var c = inst_72306;
return (function (p1__72291_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__72291_SHARP_);
});
})();
var inst_72310 = cljs.core.filterv(inst_72309,inst_72295);
var inst_72295__$1 = inst_72310;
var state_72325__$1 = (function (){var statearr_72340 = state_72325;
(statearr_72340[(10)] = inst_72295__$1);

return statearr_72340;
})();
var statearr_72341_73366 = state_72325__$1;
(statearr_72341_73366[(2)] = null);

(statearr_72341_73366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_72342 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72342[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_72342[(1)] = (1));

return statearr_72342;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_72325){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72325);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72343){var ex__71106__auto__ = e72343;
var statearr_72344_73367 = state_72325;
(statearr_72344_73367[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72325[(4)]))){
var statearr_72345_73368 = state_72325;
(statearr_72345_73368[(1)] = cljs.core.first((state_72325[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73369 = state_72325;
state_72325 = G__73369;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_72325){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_72325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72346 = f__71139__auto__();
(statearr_72346[(6)] = c__71138__auto___73356);

return statearr_72346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__72348 = arguments.length;
switch (G__72348) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__71138__auto___73371 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72372){
var state_val_72373 = (state_72372[(1)]);
if((state_val_72373 === (7))){
var inst_72354 = (state_72372[(7)]);
var inst_72354__$1 = (state_72372[(2)]);
var inst_72355 = (inst_72354__$1 == null);
var inst_72356 = cljs.core.not(inst_72355);
var state_72372__$1 = (function (){var statearr_72374 = state_72372;
(statearr_72374[(7)] = inst_72354__$1);

return statearr_72374;
})();
if(inst_72356){
var statearr_72375_73372 = state_72372__$1;
(statearr_72375_73372[(1)] = (8));

} else {
var statearr_72376_73373 = state_72372__$1;
(statearr_72376_73373[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72373 === (1))){
var inst_72349 = (0);
var state_72372__$1 = (function (){var statearr_72377 = state_72372;
(statearr_72377[(8)] = inst_72349);

return statearr_72377;
})();
var statearr_72378_73374 = state_72372__$1;
(statearr_72378_73374[(2)] = null);

(statearr_72378_73374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72373 === (4))){
var state_72372__$1 = state_72372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72372__$1,(7),ch);
} else {
if((state_val_72373 === (6))){
var inst_72367 = (state_72372[(2)]);
var state_72372__$1 = state_72372;
var statearr_72379_73375 = state_72372__$1;
(statearr_72379_73375[(2)] = inst_72367);

(statearr_72379_73375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72373 === (3))){
var inst_72369 = (state_72372[(2)]);
var inst_72370 = cljs.core.async.close_BANG_(out);
var state_72372__$1 = (function (){var statearr_72380 = state_72372;
(statearr_72380[(9)] = inst_72369);

return statearr_72380;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72372__$1,inst_72370);
} else {
if((state_val_72373 === (2))){
var inst_72349 = (state_72372[(8)]);
var inst_72351 = (inst_72349 < n);
var state_72372__$1 = state_72372;
if(cljs.core.truth_(inst_72351)){
var statearr_72381_73376 = state_72372__$1;
(statearr_72381_73376[(1)] = (4));

} else {
var statearr_72382_73377 = state_72372__$1;
(statearr_72382_73377[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72373 === (11))){
var inst_72349 = (state_72372[(8)]);
var inst_72359 = (state_72372[(2)]);
var inst_72360 = (inst_72349 + (1));
var inst_72349__$1 = inst_72360;
var state_72372__$1 = (function (){var statearr_72383 = state_72372;
(statearr_72383[(10)] = inst_72359);

(statearr_72383[(8)] = inst_72349__$1);

return statearr_72383;
})();
var statearr_72384_73378 = state_72372__$1;
(statearr_72384_73378[(2)] = null);

(statearr_72384_73378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72373 === (9))){
var state_72372__$1 = state_72372;
var statearr_72385_73379 = state_72372__$1;
(statearr_72385_73379[(2)] = null);

(statearr_72385_73379[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72373 === (5))){
var state_72372__$1 = state_72372;
var statearr_72386_73380 = state_72372__$1;
(statearr_72386_73380[(2)] = null);

(statearr_72386_73380[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72373 === (10))){
var inst_72364 = (state_72372[(2)]);
var state_72372__$1 = state_72372;
var statearr_72387_73381 = state_72372__$1;
(statearr_72387_73381[(2)] = inst_72364);

(statearr_72387_73381[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72373 === (8))){
var inst_72354 = (state_72372[(7)]);
var state_72372__$1 = state_72372;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72372__$1,(11),out,inst_72354);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_72388 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72388[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_72388[(1)] = (1));

return statearr_72388;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_72372){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72372);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72389){var ex__71106__auto__ = e72389;
var statearr_72390_73382 = state_72372;
(statearr_72390_73382[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72372[(4)]))){
var statearr_72391_73383 = state_72372;
(statearr_72391_73383[(1)] = cljs.core.first((state_72372[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73384 = state_72372;
state_72372 = G__73384;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_72372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_72372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72392 = f__71139__auto__();
(statearr_72392[(6)] = c__71138__auto___73371);

return statearr_72392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72394 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72394 = (function (f,ch,meta72395){
this.f = f;
this.ch = ch;
this.meta72395 = meta72395;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72396,meta72395__$1){
var self__ = this;
var _72396__$1 = this;
return (new cljs.core.async.t_cljs$core$async72394(self__.f,self__.ch,meta72395__$1));
}));

(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72396){
var self__ = this;
var _72396__$1 = this;
return self__.meta72395;
}));

(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72397 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72397 = (function (f,ch,meta72395,_,fn1,meta72398){
this.f = f;
this.ch = ch;
this.meta72395 = meta72395;
this._ = _;
this.fn1 = fn1;
this.meta72398 = meta72398;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72397.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72399,meta72398__$1){
var self__ = this;
var _72399__$1 = this;
return (new cljs.core.async.t_cljs$core$async72397(self__.f,self__.ch,self__.meta72395,self__._,self__.fn1,meta72398__$1));
}));

(cljs.core.async.t_cljs$core$async72397.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72399){
var self__ = this;
var _72399__$1 = this;
return self__.meta72398;
}));

(cljs.core.async.t_cljs$core$async72397.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72397.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async72397.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async72397.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__72393_SHARP_){
var G__72400 = (((p1__72393_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__72393_SHARP_) : self__.f.call(null,p1__72393_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__72400) : f1.call(null,G__72400));
});
}));

(cljs.core.async.t_cljs$core$async72397.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72395","meta72395",298266441,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async72394","cljs.core.async/t_cljs$core$async72394",-542435738,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta72398","meta72398",-433000829,null)], null);
}));

(cljs.core.async.t_cljs$core$async72397.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72397.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72397");

(cljs.core.async.t_cljs$core$async72397.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72397");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72397.
 */
cljs.core.async.__GT_t_cljs$core$async72397 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async72397(f__$1,ch__$1,meta72395__$1,___$2,fn1__$1,meta72398){
return (new cljs.core.async.t_cljs$core$async72397(f__$1,ch__$1,meta72395__$1,___$2,fn1__$1,meta72398));
});

}

return (new cljs.core.async.t_cljs$core$async72397(self__.f,self__.ch,self__.meta72395,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4109__auto__ = ret;
if(cljs.core.truth_(and__4109__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4109__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__72401 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__72401) : self__.f.call(null,G__72401));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72394.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async72394.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72395","meta72395",298266441,null)], null);
}));

(cljs.core.async.t_cljs$core$async72394.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72394.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72394");

(cljs.core.async.t_cljs$core$async72394.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72394");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72394.
 */
cljs.core.async.__GT_t_cljs$core$async72394 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async72394(f__$1,ch__$1,meta72395){
return (new cljs.core.async.t_cljs$core$async72394(f__$1,ch__$1,meta72395));
});

}

return (new cljs.core.async.t_cljs$core$async72394(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72402 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72402 = (function (f,ch,meta72403){
this.f = f;
this.ch = ch;
this.meta72403 = meta72403;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72402.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72404,meta72403__$1){
var self__ = this;
var _72404__$1 = this;
return (new cljs.core.async.t_cljs$core$async72402(self__.f,self__.ch,meta72403__$1));
}));

(cljs.core.async.t_cljs$core$async72402.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72404){
var self__ = this;
var _72404__$1 = this;
return self__.meta72403;
}));

(cljs.core.async.t_cljs$core$async72402.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72402.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72402.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72402.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async72402.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72402.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async72402.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72403","meta72403",1481550595,null)], null);
}));

(cljs.core.async.t_cljs$core$async72402.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72402.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72402");

(cljs.core.async.t_cljs$core$async72402.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72402");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72402.
 */
cljs.core.async.__GT_t_cljs$core$async72402 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async72402(f__$1,ch__$1,meta72403){
return (new cljs.core.async.t_cljs$core$async72402(f__$1,ch__$1,meta72403));
});

}

return (new cljs.core.async.t_cljs$core$async72402(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72405 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72405 = (function (p,ch,meta72406){
this.p = p;
this.ch = ch;
this.meta72406 = meta72406;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72407,meta72406__$1){
var self__ = this;
var _72407__$1 = this;
return (new cljs.core.async.t_cljs$core$async72405(self__.p,self__.ch,meta72406__$1));
}));

(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72407){
var self__ = this;
var _72407__$1 = this;
return self__.meta72406;
}));

(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72405.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async72405.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72406","meta72406",13880318,null)], null);
}));

(cljs.core.async.t_cljs$core$async72405.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72405.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72405");

(cljs.core.async.t_cljs$core$async72405.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72405");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72405.
 */
cljs.core.async.__GT_t_cljs$core$async72405 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async72405(p__$1,ch__$1,meta72406){
return (new cljs.core.async.t_cljs$core$async72405(p__$1,ch__$1,meta72406));
});

}

return (new cljs.core.async.t_cljs$core$async72405(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__72409 = arguments.length;
switch (G__72409) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__71138__auto___73390 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72430){
var state_val_72431 = (state_72430[(1)]);
if((state_val_72431 === (7))){
var inst_72426 = (state_72430[(2)]);
var state_72430__$1 = state_72430;
var statearr_72432_73391 = state_72430__$1;
(statearr_72432_73391[(2)] = inst_72426);

(statearr_72432_73391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72431 === (1))){
var state_72430__$1 = state_72430;
var statearr_72433_73392 = state_72430__$1;
(statearr_72433_73392[(2)] = null);

(statearr_72433_73392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72431 === (4))){
var inst_72412 = (state_72430[(7)]);
var inst_72412__$1 = (state_72430[(2)]);
var inst_72413 = (inst_72412__$1 == null);
var state_72430__$1 = (function (){var statearr_72434 = state_72430;
(statearr_72434[(7)] = inst_72412__$1);

return statearr_72434;
})();
if(cljs.core.truth_(inst_72413)){
var statearr_72435_73393 = state_72430__$1;
(statearr_72435_73393[(1)] = (5));

} else {
var statearr_72436_73394 = state_72430__$1;
(statearr_72436_73394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72431 === (6))){
var inst_72412 = (state_72430[(7)]);
var inst_72417 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_72412) : p.call(null,inst_72412));
var state_72430__$1 = state_72430;
if(cljs.core.truth_(inst_72417)){
var statearr_72437_73395 = state_72430__$1;
(statearr_72437_73395[(1)] = (8));

} else {
var statearr_72438_73396 = state_72430__$1;
(statearr_72438_73396[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72431 === (3))){
var inst_72428 = (state_72430[(2)]);
var state_72430__$1 = state_72430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72430__$1,inst_72428);
} else {
if((state_val_72431 === (2))){
var state_72430__$1 = state_72430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72430__$1,(4),ch);
} else {
if((state_val_72431 === (11))){
var inst_72420 = (state_72430[(2)]);
var state_72430__$1 = state_72430;
var statearr_72439_73398 = state_72430__$1;
(statearr_72439_73398[(2)] = inst_72420);

(statearr_72439_73398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72431 === (9))){
var state_72430__$1 = state_72430;
var statearr_72440_73399 = state_72430__$1;
(statearr_72440_73399[(2)] = null);

(statearr_72440_73399[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72431 === (5))){
var inst_72415 = cljs.core.async.close_BANG_(out);
var state_72430__$1 = state_72430;
var statearr_72441_73403 = state_72430__$1;
(statearr_72441_73403[(2)] = inst_72415);

(statearr_72441_73403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72431 === (10))){
var inst_72423 = (state_72430[(2)]);
var state_72430__$1 = (function (){var statearr_72442 = state_72430;
(statearr_72442[(8)] = inst_72423);

return statearr_72442;
})();
var statearr_72443_73404 = state_72430__$1;
(statearr_72443_73404[(2)] = null);

(statearr_72443_73404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72431 === (8))){
var inst_72412 = (state_72430[(7)]);
var state_72430__$1 = state_72430;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72430__$1,(11),out,inst_72412);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_72444 = [null,null,null,null,null,null,null,null,null];
(statearr_72444[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_72444[(1)] = (1));

return statearr_72444;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_72430){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72430);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72445){var ex__71106__auto__ = e72445;
var statearr_72446_73408 = state_72430;
(statearr_72446_73408[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72430[(4)]))){
var statearr_72447_73409 = state_72430;
(statearr_72447_73409[(1)] = cljs.core.first((state_72430[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73410 = state_72430;
state_72430 = G__73410;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_72430){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_72430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72448 = f__71139__auto__();
(statearr_72448[(6)] = c__71138__auto___73390);

return statearr_72448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__72450 = arguments.length;
switch (G__72450) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__71138__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72512){
var state_val_72513 = (state_72512[(1)]);
if((state_val_72513 === (7))){
var inst_72508 = (state_72512[(2)]);
var state_72512__$1 = state_72512;
var statearr_72514_73412 = state_72512__$1;
(statearr_72514_73412[(2)] = inst_72508);

(statearr_72514_73412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (20))){
var inst_72478 = (state_72512[(7)]);
var inst_72489 = (state_72512[(2)]);
var inst_72490 = cljs.core.next(inst_72478);
var inst_72464 = inst_72490;
var inst_72465 = null;
var inst_72466 = (0);
var inst_72467 = (0);
var state_72512__$1 = (function (){var statearr_72515 = state_72512;
(statearr_72515[(8)] = inst_72489);

(statearr_72515[(9)] = inst_72466);

(statearr_72515[(10)] = inst_72465);

(statearr_72515[(11)] = inst_72464);

(statearr_72515[(12)] = inst_72467);

return statearr_72515;
})();
var statearr_72516_73413 = state_72512__$1;
(statearr_72516_73413[(2)] = null);

(statearr_72516_73413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (1))){
var state_72512__$1 = state_72512;
var statearr_72517_73414 = state_72512__$1;
(statearr_72517_73414[(2)] = null);

(statearr_72517_73414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (4))){
var inst_72453 = (state_72512[(13)]);
var inst_72453__$1 = (state_72512[(2)]);
var inst_72454 = (inst_72453__$1 == null);
var state_72512__$1 = (function (){var statearr_72518 = state_72512;
(statearr_72518[(13)] = inst_72453__$1);

return statearr_72518;
})();
if(cljs.core.truth_(inst_72454)){
var statearr_72519_73415 = state_72512__$1;
(statearr_72519_73415[(1)] = (5));

} else {
var statearr_72520_73416 = state_72512__$1;
(statearr_72520_73416[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (15))){
var state_72512__$1 = state_72512;
var statearr_72524_73417 = state_72512__$1;
(statearr_72524_73417[(2)] = null);

(statearr_72524_73417[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (21))){
var state_72512__$1 = state_72512;
var statearr_72525_73418 = state_72512__$1;
(statearr_72525_73418[(2)] = null);

(statearr_72525_73418[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (13))){
var inst_72466 = (state_72512[(9)]);
var inst_72465 = (state_72512[(10)]);
var inst_72464 = (state_72512[(11)]);
var inst_72467 = (state_72512[(12)]);
var inst_72474 = (state_72512[(2)]);
var inst_72475 = (inst_72467 + (1));
var tmp72521 = inst_72466;
var tmp72522 = inst_72465;
var tmp72523 = inst_72464;
var inst_72464__$1 = tmp72523;
var inst_72465__$1 = tmp72522;
var inst_72466__$1 = tmp72521;
var inst_72467__$1 = inst_72475;
var state_72512__$1 = (function (){var statearr_72526 = state_72512;
(statearr_72526[(9)] = inst_72466__$1);

(statearr_72526[(10)] = inst_72465__$1);

(statearr_72526[(11)] = inst_72464__$1);

(statearr_72526[(14)] = inst_72474);

(statearr_72526[(12)] = inst_72467__$1);

return statearr_72526;
})();
var statearr_72527_73419 = state_72512__$1;
(statearr_72527_73419[(2)] = null);

(statearr_72527_73419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (22))){
var state_72512__$1 = state_72512;
var statearr_72528_73420 = state_72512__$1;
(statearr_72528_73420[(2)] = null);

(statearr_72528_73420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (6))){
var inst_72453 = (state_72512[(13)]);
var inst_72462 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_72453) : f.call(null,inst_72453));
var inst_72463 = cljs.core.seq(inst_72462);
var inst_72464 = inst_72463;
var inst_72465 = null;
var inst_72466 = (0);
var inst_72467 = (0);
var state_72512__$1 = (function (){var statearr_72529 = state_72512;
(statearr_72529[(9)] = inst_72466);

(statearr_72529[(10)] = inst_72465);

(statearr_72529[(11)] = inst_72464);

(statearr_72529[(12)] = inst_72467);

return statearr_72529;
})();
var statearr_72530_73421 = state_72512__$1;
(statearr_72530_73421[(2)] = null);

(statearr_72530_73421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (17))){
var inst_72478 = (state_72512[(7)]);
var inst_72482 = cljs.core.chunk_first(inst_72478);
var inst_72483 = cljs.core.chunk_rest(inst_72478);
var inst_72484 = cljs.core.count(inst_72482);
var inst_72464 = inst_72483;
var inst_72465 = inst_72482;
var inst_72466 = inst_72484;
var inst_72467 = (0);
var state_72512__$1 = (function (){var statearr_72531 = state_72512;
(statearr_72531[(9)] = inst_72466);

(statearr_72531[(10)] = inst_72465);

(statearr_72531[(11)] = inst_72464);

(statearr_72531[(12)] = inst_72467);

return statearr_72531;
})();
var statearr_72532_73422 = state_72512__$1;
(statearr_72532_73422[(2)] = null);

(statearr_72532_73422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (3))){
var inst_72510 = (state_72512[(2)]);
var state_72512__$1 = state_72512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72512__$1,inst_72510);
} else {
if((state_val_72513 === (12))){
var inst_72498 = (state_72512[(2)]);
var state_72512__$1 = state_72512;
var statearr_72533_73423 = state_72512__$1;
(statearr_72533_73423[(2)] = inst_72498);

(statearr_72533_73423[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (2))){
var state_72512__$1 = state_72512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72512__$1,(4),in$);
} else {
if((state_val_72513 === (23))){
var inst_72506 = (state_72512[(2)]);
var state_72512__$1 = state_72512;
var statearr_72534_73424 = state_72512__$1;
(statearr_72534_73424[(2)] = inst_72506);

(statearr_72534_73424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (19))){
var inst_72493 = (state_72512[(2)]);
var state_72512__$1 = state_72512;
var statearr_72535_73425 = state_72512__$1;
(statearr_72535_73425[(2)] = inst_72493);

(statearr_72535_73425[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (11))){
var inst_72478 = (state_72512[(7)]);
var inst_72464 = (state_72512[(11)]);
var inst_72478__$1 = cljs.core.seq(inst_72464);
var state_72512__$1 = (function (){var statearr_72536 = state_72512;
(statearr_72536[(7)] = inst_72478__$1);

return statearr_72536;
})();
if(inst_72478__$1){
var statearr_72537_73426 = state_72512__$1;
(statearr_72537_73426[(1)] = (14));

} else {
var statearr_72538_73427 = state_72512__$1;
(statearr_72538_73427[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (9))){
var inst_72500 = (state_72512[(2)]);
var inst_72501 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_72512__$1 = (function (){var statearr_72539 = state_72512;
(statearr_72539[(15)] = inst_72500);

return statearr_72539;
})();
if(cljs.core.truth_(inst_72501)){
var statearr_72540_73428 = state_72512__$1;
(statearr_72540_73428[(1)] = (21));

} else {
var statearr_72541_73429 = state_72512__$1;
(statearr_72541_73429[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (5))){
var inst_72456 = cljs.core.async.close_BANG_(out);
var state_72512__$1 = state_72512;
var statearr_72542_73430 = state_72512__$1;
(statearr_72542_73430[(2)] = inst_72456);

(statearr_72542_73430[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (14))){
var inst_72478 = (state_72512[(7)]);
var inst_72480 = cljs.core.chunked_seq_QMARK_(inst_72478);
var state_72512__$1 = state_72512;
if(inst_72480){
var statearr_72543_73431 = state_72512__$1;
(statearr_72543_73431[(1)] = (17));

} else {
var statearr_72544_73432 = state_72512__$1;
(statearr_72544_73432[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (16))){
var inst_72496 = (state_72512[(2)]);
var state_72512__$1 = state_72512;
var statearr_72545_73433 = state_72512__$1;
(statearr_72545_73433[(2)] = inst_72496);

(statearr_72545_73433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (10))){
var inst_72465 = (state_72512[(10)]);
var inst_72467 = (state_72512[(12)]);
var inst_72472 = cljs.core._nth(inst_72465,inst_72467);
var state_72512__$1 = state_72512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72512__$1,(13),out,inst_72472);
} else {
if((state_val_72513 === (18))){
var inst_72478 = (state_72512[(7)]);
var inst_72487 = cljs.core.first(inst_72478);
var state_72512__$1 = state_72512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72512__$1,(20),out,inst_72487);
} else {
if((state_val_72513 === (8))){
var inst_72466 = (state_72512[(9)]);
var inst_72467 = (state_72512[(12)]);
var inst_72469 = (inst_72467 < inst_72466);
var inst_72470 = inst_72469;
var state_72512__$1 = state_72512;
if(cljs.core.truth_(inst_72470)){
var statearr_72546_73434 = state_72512__$1;
(statearr_72546_73434[(1)] = (10));

} else {
var statearr_72547_73435 = state_72512__$1;
(statearr_72547_73435[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__71103__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__71103__auto____0 = (function (){
var statearr_72548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72548[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__71103__auto__);

(statearr_72548[(1)] = (1));

return statearr_72548;
});
var cljs$core$async$mapcat_STAR__$_state_machine__71103__auto____1 = (function (state_72512){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72512);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72549){var ex__71106__auto__ = e72549;
var statearr_72550_73439 = state_72512;
(statearr_72550_73439[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72512[(4)]))){
var statearr_72551_73440 = state_72512;
(statearr_72551_73440[(1)] = cljs.core.first((state_72512[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73441 = state_72512;
state_72512 = G__73441;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__71103__auto__ = function(state_72512){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__71103__auto____1.call(this,state_72512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__71103__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__71103__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72552 = f__71139__auto__();
(statearr_72552[(6)] = c__71138__auto__);

return statearr_72552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));

return c__71138__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__72554 = arguments.length;
switch (G__72554) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__72556 = arguments.length;
switch (G__72556) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__72558 = arguments.length;
switch (G__72558) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__71138__auto___73446 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72582){
var state_val_72583 = (state_72582[(1)]);
if((state_val_72583 === (7))){
var inst_72577 = (state_72582[(2)]);
var state_72582__$1 = state_72582;
var statearr_72584_73447 = state_72582__$1;
(statearr_72584_73447[(2)] = inst_72577);

(statearr_72584_73447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72583 === (1))){
var inst_72559 = null;
var state_72582__$1 = (function (){var statearr_72585 = state_72582;
(statearr_72585[(7)] = inst_72559);

return statearr_72585;
})();
var statearr_72586_73448 = state_72582__$1;
(statearr_72586_73448[(2)] = null);

(statearr_72586_73448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72583 === (4))){
var inst_72562 = (state_72582[(8)]);
var inst_72562__$1 = (state_72582[(2)]);
var inst_72563 = (inst_72562__$1 == null);
var inst_72564 = cljs.core.not(inst_72563);
var state_72582__$1 = (function (){var statearr_72587 = state_72582;
(statearr_72587[(8)] = inst_72562__$1);

return statearr_72587;
})();
if(inst_72564){
var statearr_72588_73449 = state_72582__$1;
(statearr_72588_73449[(1)] = (5));

} else {
var statearr_72589_73450 = state_72582__$1;
(statearr_72589_73450[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72583 === (6))){
var state_72582__$1 = state_72582;
var statearr_72590_73451 = state_72582__$1;
(statearr_72590_73451[(2)] = null);

(statearr_72590_73451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72583 === (3))){
var inst_72579 = (state_72582[(2)]);
var inst_72580 = cljs.core.async.close_BANG_(out);
var state_72582__$1 = (function (){var statearr_72591 = state_72582;
(statearr_72591[(9)] = inst_72579);

return statearr_72591;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72582__$1,inst_72580);
} else {
if((state_val_72583 === (2))){
var state_72582__$1 = state_72582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72582__$1,(4),ch);
} else {
if((state_val_72583 === (11))){
var inst_72562 = (state_72582[(8)]);
var inst_72571 = (state_72582[(2)]);
var inst_72559 = inst_72562;
var state_72582__$1 = (function (){var statearr_72592 = state_72582;
(statearr_72592[(7)] = inst_72559);

(statearr_72592[(10)] = inst_72571);

return statearr_72592;
})();
var statearr_72593_73454 = state_72582__$1;
(statearr_72593_73454[(2)] = null);

(statearr_72593_73454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72583 === (9))){
var inst_72562 = (state_72582[(8)]);
var state_72582__$1 = state_72582;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72582__$1,(11),out,inst_72562);
} else {
if((state_val_72583 === (5))){
var inst_72562 = (state_72582[(8)]);
var inst_72559 = (state_72582[(7)]);
var inst_72566 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72562,inst_72559);
var state_72582__$1 = state_72582;
if(inst_72566){
var statearr_72595_73455 = state_72582__$1;
(statearr_72595_73455[(1)] = (8));

} else {
var statearr_72596_73456 = state_72582__$1;
(statearr_72596_73456[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72583 === (10))){
var inst_72574 = (state_72582[(2)]);
var state_72582__$1 = state_72582;
var statearr_72597_73457 = state_72582__$1;
(statearr_72597_73457[(2)] = inst_72574);

(statearr_72597_73457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72583 === (8))){
var inst_72559 = (state_72582[(7)]);
var tmp72594 = inst_72559;
var inst_72559__$1 = tmp72594;
var state_72582__$1 = (function (){var statearr_72598 = state_72582;
(statearr_72598[(7)] = inst_72559__$1);

return statearr_72598;
})();
var statearr_72599_73458 = state_72582__$1;
(statearr_72599_73458[(2)] = null);

(statearr_72599_73458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_72600 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72600[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_72600[(1)] = (1));

return statearr_72600;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_72582){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72582);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72601){var ex__71106__auto__ = e72601;
var statearr_72602_73459 = state_72582;
(statearr_72602_73459[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72582[(4)]))){
var statearr_72603_73460 = state_72582;
(statearr_72603_73460[(1)] = cljs.core.first((state_72582[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73461 = state_72582;
state_72582 = G__73461;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_72582){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_72582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72604 = f__71139__auto__();
(statearr_72604[(6)] = c__71138__auto___73446);

return statearr_72604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__72606 = arguments.length;
switch (G__72606) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__71138__auto___73463 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72644){
var state_val_72645 = (state_72644[(1)]);
if((state_val_72645 === (7))){
var inst_72640 = (state_72644[(2)]);
var state_72644__$1 = state_72644;
var statearr_72646_73464 = state_72644__$1;
(statearr_72646_73464[(2)] = inst_72640);

(statearr_72646_73464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (1))){
var inst_72607 = (new Array(n));
var inst_72608 = inst_72607;
var inst_72609 = (0);
var state_72644__$1 = (function (){var statearr_72647 = state_72644;
(statearr_72647[(7)] = inst_72608);

(statearr_72647[(8)] = inst_72609);

return statearr_72647;
})();
var statearr_72648_73465 = state_72644__$1;
(statearr_72648_73465[(2)] = null);

(statearr_72648_73465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (4))){
var inst_72612 = (state_72644[(9)]);
var inst_72612__$1 = (state_72644[(2)]);
var inst_72613 = (inst_72612__$1 == null);
var inst_72614 = cljs.core.not(inst_72613);
var state_72644__$1 = (function (){var statearr_72649 = state_72644;
(statearr_72649[(9)] = inst_72612__$1);

return statearr_72649;
})();
if(inst_72614){
var statearr_72650_73466 = state_72644__$1;
(statearr_72650_73466[(1)] = (5));

} else {
var statearr_72651_73467 = state_72644__$1;
(statearr_72651_73467[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (15))){
var inst_72634 = (state_72644[(2)]);
var state_72644__$1 = state_72644;
var statearr_72652_73468 = state_72644__$1;
(statearr_72652_73468[(2)] = inst_72634);

(statearr_72652_73468[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (13))){
var state_72644__$1 = state_72644;
var statearr_72653_73469 = state_72644__$1;
(statearr_72653_73469[(2)] = null);

(statearr_72653_73469[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (6))){
var inst_72609 = (state_72644[(8)]);
var inst_72630 = (inst_72609 > (0));
var state_72644__$1 = state_72644;
if(cljs.core.truth_(inst_72630)){
var statearr_72654_73470 = state_72644__$1;
(statearr_72654_73470[(1)] = (12));

} else {
var statearr_72655_73471 = state_72644__$1;
(statearr_72655_73471[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (3))){
var inst_72642 = (state_72644[(2)]);
var state_72644__$1 = state_72644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72644__$1,inst_72642);
} else {
if((state_val_72645 === (12))){
var inst_72608 = (state_72644[(7)]);
var inst_72632 = cljs.core.vec(inst_72608);
var state_72644__$1 = state_72644;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72644__$1,(15),out,inst_72632);
} else {
if((state_val_72645 === (2))){
var state_72644__$1 = state_72644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72644__$1,(4),ch);
} else {
if((state_val_72645 === (11))){
var inst_72624 = (state_72644[(2)]);
var inst_72625 = (new Array(n));
var inst_72608 = inst_72625;
var inst_72609 = (0);
var state_72644__$1 = (function (){var statearr_72656 = state_72644;
(statearr_72656[(7)] = inst_72608);

(statearr_72656[(10)] = inst_72624);

(statearr_72656[(8)] = inst_72609);

return statearr_72656;
})();
var statearr_72657_73472 = state_72644__$1;
(statearr_72657_73472[(2)] = null);

(statearr_72657_73472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (9))){
var inst_72608 = (state_72644[(7)]);
var inst_72622 = cljs.core.vec(inst_72608);
var state_72644__$1 = state_72644;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72644__$1,(11),out,inst_72622);
} else {
if((state_val_72645 === (5))){
var inst_72612 = (state_72644[(9)]);
var inst_72608 = (state_72644[(7)]);
var inst_72617 = (state_72644[(11)]);
var inst_72609 = (state_72644[(8)]);
var inst_72616 = (inst_72608[inst_72609] = inst_72612);
var inst_72617__$1 = (inst_72609 + (1));
var inst_72618 = (inst_72617__$1 < n);
var state_72644__$1 = (function (){var statearr_72658 = state_72644;
(statearr_72658[(12)] = inst_72616);

(statearr_72658[(11)] = inst_72617__$1);

return statearr_72658;
})();
if(cljs.core.truth_(inst_72618)){
var statearr_72659_73473 = state_72644__$1;
(statearr_72659_73473[(1)] = (8));

} else {
var statearr_72660_73474 = state_72644__$1;
(statearr_72660_73474[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (14))){
var inst_72637 = (state_72644[(2)]);
var inst_72638 = cljs.core.async.close_BANG_(out);
var state_72644__$1 = (function (){var statearr_72662 = state_72644;
(statearr_72662[(13)] = inst_72637);

return statearr_72662;
})();
var statearr_72663_73475 = state_72644__$1;
(statearr_72663_73475[(2)] = inst_72638);

(statearr_72663_73475[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (10))){
var inst_72628 = (state_72644[(2)]);
var state_72644__$1 = state_72644;
var statearr_72664_73476 = state_72644__$1;
(statearr_72664_73476[(2)] = inst_72628);

(statearr_72664_73476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72645 === (8))){
var inst_72608 = (state_72644[(7)]);
var inst_72617 = (state_72644[(11)]);
var tmp72661 = inst_72608;
var inst_72608__$1 = tmp72661;
var inst_72609 = inst_72617;
var state_72644__$1 = (function (){var statearr_72665 = state_72644;
(statearr_72665[(7)] = inst_72608__$1);

(statearr_72665[(8)] = inst_72609);

return statearr_72665;
})();
var statearr_72666_73477 = state_72644__$1;
(statearr_72666_73477[(2)] = null);

(statearr_72666_73477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_72667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72667[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_72667[(1)] = (1));

return statearr_72667;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_72644){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72644);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72668){var ex__71106__auto__ = e72668;
var statearr_72669_73478 = state_72644;
(statearr_72669_73478[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72644[(4)]))){
var statearr_72670_73479 = state_72644;
(statearr_72670_73479[(1)] = cljs.core.first((state_72644[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73480 = state_72644;
state_72644 = G__73480;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_72644){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_72644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72671 = f__71139__auto__();
(statearr_72671[(6)] = c__71138__auto___73463);

return statearr_72671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__72673 = arguments.length;
switch (G__72673) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__71138__auto___73482 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_72715){
var state_val_72716 = (state_72715[(1)]);
if((state_val_72716 === (7))){
var inst_72711 = (state_72715[(2)]);
var state_72715__$1 = state_72715;
var statearr_72717_73483 = state_72715__$1;
(statearr_72717_73483[(2)] = inst_72711);

(statearr_72717_73483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (1))){
var inst_72674 = [];
var inst_72675 = inst_72674;
var inst_72676 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_72715__$1 = (function (){var statearr_72718 = state_72715;
(statearr_72718[(7)] = inst_72676);

(statearr_72718[(8)] = inst_72675);

return statearr_72718;
})();
var statearr_72719_73484 = state_72715__$1;
(statearr_72719_73484[(2)] = null);

(statearr_72719_73484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (4))){
var inst_72679 = (state_72715[(9)]);
var inst_72679__$1 = (state_72715[(2)]);
var inst_72680 = (inst_72679__$1 == null);
var inst_72681 = cljs.core.not(inst_72680);
var state_72715__$1 = (function (){var statearr_72720 = state_72715;
(statearr_72720[(9)] = inst_72679__$1);

return statearr_72720;
})();
if(inst_72681){
var statearr_72721_73485 = state_72715__$1;
(statearr_72721_73485[(1)] = (5));

} else {
var statearr_72722_73486 = state_72715__$1;
(statearr_72722_73486[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (15))){
var inst_72705 = (state_72715[(2)]);
var state_72715__$1 = state_72715;
var statearr_72723_73487 = state_72715__$1;
(statearr_72723_73487[(2)] = inst_72705);

(statearr_72723_73487[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (13))){
var state_72715__$1 = state_72715;
var statearr_72724_73488 = state_72715__$1;
(statearr_72724_73488[(2)] = null);

(statearr_72724_73488[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (6))){
var inst_72675 = (state_72715[(8)]);
var inst_72700 = inst_72675.length;
var inst_72701 = (inst_72700 > (0));
var state_72715__$1 = state_72715;
if(cljs.core.truth_(inst_72701)){
var statearr_72725_73489 = state_72715__$1;
(statearr_72725_73489[(1)] = (12));

} else {
var statearr_72726_73490 = state_72715__$1;
(statearr_72726_73490[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (3))){
var inst_72713 = (state_72715[(2)]);
var state_72715__$1 = state_72715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72715__$1,inst_72713);
} else {
if((state_val_72716 === (12))){
var inst_72675 = (state_72715[(8)]);
var inst_72703 = cljs.core.vec(inst_72675);
var state_72715__$1 = state_72715;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72715__$1,(15),out,inst_72703);
} else {
if((state_val_72716 === (2))){
var state_72715__$1 = state_72715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72715__$1,(4),ch);
} else {
if((state_val_72716 === (11))){
var inst_72683 = (state_72715[(10)]);
var inst_72679 = (state_72715[(9)]);
var inst_72693 = (state_72715[(2)]);
var inst_72694 = [];
var inst_72695 = inst_72694.push(inst_72679);
var inst_72675 = inst_72694;
var inst_72676 = inst_72683;
var state_72715__$1 = (function (){var statearr_72727 = state_72715;
(statearr_72727[(7)] = inst_72676);

(statearr_72727[(11)] = inst_72693);

(statearr_72727[(12)] = inst_72695);

(statearr_72727[(8)] = inst_72675);

return statearr_72727;
})();
var statearr_72728_73491 = state_72715__$1;
(statearr_72728_73491[(2)] = null);

(statearr_72728_73491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (9))){
var inst_72675 = (state_72715[(8)]);
var inst_72691 = cljs.core.vec(inst_72675);
var state_72715__$1 = state_72715;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72715__$1,(11),out,inst_72691);
} else {
if((state_val_72716 === (5))){
var inst_72676 = (state_72715[(7)]);
var inst_72683 = (state_72715[(10)]);
var inst_72679 = (state_72715[(9)]);
var inst_72683__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_72679) : f.call(null,inst_72679));
var inst_72684 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72683__$1,inst_72676);
var inst_72685 = cljs.core.keyword_identical_QMARK_(inst_72676,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_72686 = ((inst_72684) || (inst_72685));
var state_72715__$1 = (function (){var statearr_72729 = state_72715;
(statearr_72729[(10)] = inst_72683__$1);

return statearr_72729;
})();
if(cljs.core.truth_(inst_72686)){
var statearr_72730_73492 = state_72715__$1;
(statearr_72730_73492[(1)] = (8));

} else {
var statearr_72731_73493 = state_72715__$1;
(statearr_72731_73493[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (14))){
var inst_72708 = (state_72715[(2)]);
var inst_72709 = cljs.core.async.close_BANG_(out);
var state_72715__$1 = (function (){var statearr_72733 = state_72715;
(statearr_72733[(13)] = inst_72708);

return statearr_72733;
})();
var statearr_72734_73494 = state_72715__$1;
(statearr_72734_73494[(2)] = inst_72709);

(statearr_72734_73494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (10))){
var inst_72698 = (state_72715[(2)]);
var state_72715__$1 = state_72715;
var statearr_72735_73496 = state_72715__$1;
(statearr_72735_73496[(2)] = inst_72698);

(statearr_72735_73496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72716 === (8))){
var inst_72683 = (state_72715[(10)]);
var inst_72679 = (state_72715[(9)]);
var inst_72675 = (state_72715[(8)]);
var inst_72688 = inst_72675.push(inst_72679);
var tmp72732 = inst_72675;
var inst_72675__$1 = tmp72732;
var inst_72676 = inst_72683;
var state_72715__$1 = (function (){var statearr_72736 = state_72715;
(statearr_72736[(7)] = inst_72676);

(statearr_72736[(14)] = inst_72688);

(statearr_72736[(8)] = inst_72675__$1);

return statearr_72736;
})();
var statearr_72737_73498 = state_72715__$1;
(statearr_72737_73498[(2)] = null);

(statearr_72737_73498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__71103__auto__ = null;
var cljs$core$async$state_machine__71103__auto____0 = (function (){
var statearr_72738 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72738[(0)] = cljs$core$async$state_machine__71103__auto__);

(statearr_72738[(1)] = (1));

return statearr_72738;
});
var cljs$core$async$state_machine__71103__auto____1 = (function (state_72715){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_72715);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e72739){var ex__71106__auto__ = e72739;
var statearr_72740_73502 = state_72715;
(statearr_72740_73502[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_72715[(4)]))){
var statearr_72741_73503 = state_72715;
(statearr_72741_73503[(1)] = cljs.core.first((state_72715[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73504 = state_72715;
state_72715 = G__73504;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
cljs$core$async$state_machine__71103__auto__ = function(state_72715){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__71103__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__71103__auto____1.call(this,state_72715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__71103__auto____0;
cljs$core$async$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__71103__auto____1;
return cljs$core$async$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_72742 = f__71139__auto__();
(statearr_72742[(6)] = c__71138__auto___73482);

return statearr_72742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
