goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__75201__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__75201 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__75202__i = 0, G__75202__a = new Array(arguments.length -  0);
while (G__75202__i < G__75202__a.length) {G__75202__a[G__75202__i] = arguments[G__75202__i + 0]; ++G__75202__i;}
  args = new cljs.core.IndexedSeq(G__75202__a,0,null);
} 
return G__75201__delegate.call(this,args);};
G__75201.cljs$lang$maxFixedArity = 0;
G__75201.cljs$lang$applyTo = (function (arglist__75203){
var args = cljs.core.seq(arglist__75203);
return G__75201__delegate(args);
});
G__75201.cljs$core$IFn$_invoke$arity$variadic = G__75201__delegate;
return G__75201;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4736__auto__ = [];
var len__4730__auto___75204 = arguments.length;
var i__4731__auto___75205 = (0);
while(true){
if((i__4731__auto___75205 < len__4730__auto___75204)){
args__4736__auto__.push((arguments[i__4731__auto___75205]));

var G__75207 = (i__4731__auto___75205 + (1));
i__4731__auto___75205 = G__75207;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq74870){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq74870));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__74871 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74872 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__74871,G__74872) : com.rpl.specter.compiled_select.call(null,G__74871,G__74872));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__74873 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74874 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__74873,G__74874) : com.rpl.specter.compiled_select_one.call(null,G__74873,G__74874));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__74875 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74876 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__74875,G__74876) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__74875,G__74876));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__74878 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74879 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__74878,G__74879) : com.rpl.specter.compiled_select_first.call(null,G__74878,G__74879));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__74880 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74881 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__74880,G__74881) : com.rpl.specter.compiled_select_any.call(null,G__74880,G__74881));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__74882 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74883 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__74882,G__74883) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__74882,G__74883));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__74884 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__74885 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__74884,G__74885) : com.rpl.specter.compiled_traverse.call(null,G__74884,G__74885));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__74886 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__74886) : com.rpl.specter.compiled_traverse_all.call(null,G__74886));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__74887 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74888 = transform_fn;
var G__74889 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__74887,G__74888,G__74889) : com.rpl.specter.compiled_transform.call(null,G__74887,G__74888,G__74889));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__74890 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74891 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__74890,G__74891) : com.rpl.specter.compiled_multi_transform.call(null,G__74890,G__74891));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__74892 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74893 = val;
var G__74894 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__74892,G__74893,G__74894) : com.rpl.specter.compiled_setval.call(null,G__74892,G__74893,G__74894));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___75208 = arguments.length;
var i__4731__auto___75209 = (0);
while(true){
if((i__4731__auto___75209 < len__4730__auto___75208)){
args__4736__auto__.push((arguments[i__4731__auto___75209]));

var G__75210 = (i__4731__auto___75209 + (1));
i__4731__auto___75209 = G__75210;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__74899){
var map__74900 = p__74899;
var map__74900__$1 = (((((!((map__74900 == null))))?(((((map__74900.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74900.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__74900):map__74900);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74900__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__74902 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74903 = transform_fn;
var G__74904 = structure;
var G__74905 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__74906 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__74902,G__74903,G__74904,G__74905,G__74906) : com.rpl.specter.compiled_replace_in.call(null,G__74902,G__74903,G__74904,G__74905,G__74906));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq74895){
var G__74896 = cljs.core.first(seq74895);
var seq74895__$1 = cljs.core.next(seq74895);
var G__74897 = cljs.core.first(seq74895__$1);
var seq74895__$2 = cljs.core.next(seq74895__$1);
var G__74898 = cljs.core.first(seq74895__$2);
var seq74895__$3 = cljs.core.next(seq74895__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74896,G__74897,G__74898,seq74895__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75211__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__75211 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__75212__i = 0, G__75212__a = new Array(arguments.length -  0);
while (G__75212__i < G__75212__a.length) {G__75212__a[G__75212__i] = arguments[G__75212__i + 0]; ++G__75212__i;}
  args = new cljs.core.IndexedSeq(G__75212__a,0,null);
} 
return G__75211__delegate.call(this,args);};
G__75211.cljs$lang$maxFixedArity = 0;
G__75211.cljs$lang$applyTo = (function (arglist__75213){
var args = cljs.core.seq(arglist__75213);
return G__75211__delegate(args);
});
G__75211.cljs$core$IFn$_invoke$arity$variadic = G__75211__delegate;
return G__75211;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74908 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74908 = (function (meta74909){
this.meta74909 = meta74909;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74908.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74910,meta74909__$1){
var self__ = this;
var _74910__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74908(meta74909__$1));
}));

(com.rpl.specter.t_com$rpl$specter74908.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74910){
var self__ = this;
var _74910__$1 = this;
return self__.meta74909;
}));

(com.rpl.specter.t_com$rpl$specter74908.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74908.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74908.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter74908.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74909","meta74909",368832654,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74908.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74908.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74908");

(com.rpl.specter.t_com$rpl$specter74908.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74908");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74908.
 */
com.rpl.specter.__GT_t_com$rpl$specter74908 = (function com$rpl$specter$__GT_t_com$rpl$specter74908(meta74909){
return (new com.rpl.specter.t_com$rpl$specter74908(meta74909));
});

}

return (new com.rpl.specter.t_com$rpl$specter74908(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74911 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74911 = (function (afn,meta74912){
this.afn = afn;
this.meta74912 = meta74912;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74911.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74913,meta74912__$1){
var self__ = this;
var _74913__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74911(self__.afn,meta74912__$1));
}));

(com.rpl.specter.t_com$rpl$specter74911.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74913){
var self__ = this;
var _74913__$1 = this;
return self__.meta74912;
}));

(com.rpl.specter.t_com$rpl$specter74911.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74911.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74911.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter74911.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta74912","meta74912",220292361,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74911.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74911.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74911");

(com.rpl.specter.t_com$rpl$specter74911.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74911");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74911.
 */
com.rpl.specter.__GT_t_com$rpl$specter74911 = (function com$rpl$specter$__GT_t_com$rpl$specter74911(afn__$1,meta74912){
return (new com.rpl.specter.t_com$rpl$specter74911(afn__$1,meta74912));
});

}

return (new com.rpl.specter.t_com$rpl$specter74911(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74914 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74914 = (function (afn,meta74915){
this.afn = afn;
this.meta74915 = meta74915;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74914.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74916,meta74915__$1){
var self__ = this;
var _74916__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74914(self__.afn,meta74915__$1));
}));

(com.rpl.specter.t_com$rpl$specter74914.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74916){
var self__ = this;
var _74916__$1 = this;
return self__.meta74915;
}));

(com.rpl.specter.t_com$rpl$specter74914.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74914.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74914.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter74914.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta74915","meta74915",-1371648917,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74914.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74914.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74914");

(com.rpl.specter.t_com$rpl$specter74914.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74914");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74914.
 */
com.rpl.specter.__GT_t_com$rpl$specter74914 = (function com$rpl$specter$__GT_t_com$rpl$specter74914(afn__$1,meta74915){
return (new com.rpl.specter.t_com$rpl$specter74914(afn__$1,meta74915));
});

}

return (new com.rpl.specter.t_com$rpl$specter74914(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__74917 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__74917) : com.rpl.specter.terminal.call(null,G__74917));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74918 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74918 = (function (meta74919){
this.meta74919 = meta74919;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74918.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74920,meta74919__$1){
var self__ = this;
var _74920__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74918(meta74919__$1));
}));

(com.rpl.specter.t_com$rpl$specter74918.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74920){
var self__ = this;
var _74920__$1 = this;
return self__.meta74919;
}));

(com.rpl.specter.t_com$rpl$specter74918.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74918.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74918.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74918.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74919","meta74919",-161489701,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74918.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74918.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74918");

(com.rpl.specter.t_com$rpl$specter74918.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74918");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74918.
 */
com.rpl.specter.__GT_t_com$rpl$specter74918 = (function com$rpl$specter$__GT_t_com$rpl$specter74918(meta74919){
return (new com.rpl.specter.t_com$rpl$specter74918(meta74919));
});

}

return (new com.rpl.specter.t_com$rpl$specter74918(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74922 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74922 = (function (meta74923){
this.meta74923 = meta74923;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74922.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74924,meta74923__$1){
var self__ = this;
var _74924__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74922(meta74923__$1));
}));

(com.rpl.specter.t_com$rpl$specter74922.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74924){
var self__ = this;
var _74924__$1 = this;
return self__.meta74923;
}));

(com.rpl.specter.t_com$rpl$specter74922.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74922.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74922.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter74922.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74923","meta74923",-2101275528,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74922.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74922.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74922");

(com.rpl.specter.t_com$rpl$specter74922.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74922");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74922.
 */
com.rpl.specter.__GT_t_com$rpl$specter74922 = (function com$rpl$specter$__GT_t_com$rpl$specter74922(meta74923){
return (new com.rpl.specter.t_com$rpl$specter74922(meta74923));
});

}

return (new com.rpl.specter.t_com$rpl$specter74922(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,v){
var ret__38246__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74925 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74925 = (function (meta74926){
this.meta74926 = meta74926;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74925.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74927,meta74926__$1){
var self__ = this;
var _74927__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74925(meta74926__$1));
}));

(com.rpl.specter.t_com$rpl$specter74925.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74927){
var self__ = this;
var _74927__$1 = this;
return self__.meta74926;
}));

(com.rpl.specter.t_com$rpl$specter74925.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74925.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,v){
var ret__38246__auto__ = next_fn(v);
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter74925.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74925.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74926","meta74926",619920832,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74925.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74925.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74925");

(com.rpl.specter.t_com$rpl$specter74925.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74925");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74925.
 */
com.rpl.specter.__GT_t_com$rpl$specter74925 = (function com$rpl$specter$__GT_t_com$rpl$specter74925(meta74926){
return (new com.rpl.specter.t_com$rpl$specter74925(meta74926));
});

}

return (new com.rpl.specter.t_com$rpl$specter74925(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,k){
var ret__38246__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74928 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74928 = (function (meta74929){
this.meta74929 = meta74929;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74928.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74930,meta74929__$1){
var self__ = this;
var _74930__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74928(meta74929__$1));
}));

(com.rpl.specter.t_com$rpl$specter74928.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74930){
var self__ = this;
var _74930__$1 = this;
return self__.meta74929;
}));

(com.rpl.specter.t_com$rpl$specter74928.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74928.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,k){
var ret__38246__auto__ = next_fn(k);
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter74928.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74928.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74929","meta74929",700268242,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74928.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74928.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74928");

(com.rpl.specter.t_com$rpl$specter74928.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74928");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74928.
 */
com.rpl.specter.__GT_t_com$rpl$specter74928 = (function com$rpl$specter$__GT_t_com$rpl$specter74928(meta74929){
return (new com.rpl.specter.t_com$rpl$specter74928(meta74929));
});

}

return (new com.rpl.specter.t_com$rpl$specter74928(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74932 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74932 = (function (meta74933){
this.meta74933 = meta74933;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74932.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74934,meta74933__$1){
var self__ = this;
var _74934__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74932(meta74933__$1));
}));

(com.rpl.specter.t_com$rpl$specter74932.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74934){
var self__ = this;
var _74934__$1 = this;
return self__.meta74933;
}));

(com.rpl.specter.t_com$rpl$specter74932.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74932.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39928__auto__,vals__39929__auto__,structure,next_fn__39930__auto__){
var self__ = this;
var this__39928__auto____$1 = this;
var G__74935 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39929__auto__,structure);
var G__74936 = structure;
return (next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2(G__74935,G__74936) : next_fn__39930__auto__.call(null,G__74935,G__74936));
}));

(com.rpl.specter.t_com$rpl$specter74932.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39928__auto__,vals__39929__auto__,structure,next_fn__39930__auto__){
var self__ = this;
var this__39928__auto____$1 = this;
var G__74937 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39929__auto__,structure);
var G__74938 = structure;
return (next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2(G__74937,G__74938) : next_fn__39930__auto__.call(null,G__74937,G__74938));
}));

(com.rpl.specter.t_com$rpl$specter74932.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74933","meta74933",1374451706,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74932.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74932.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74932");

(com.rpl.specter.t_com$rpl$specter74932.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74932");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74932.
 */
com.rpl.specter.__GT_t_com$rpl$specter74932 = (function com$rpl$specter$__GT_t_com$rpl$specter74932(meta74933){
return (new com.rpl.specter.t_com$rpl$specter74932(meta74933));
});

}

return (new com.rpl.specter.t_com$rpl$specter74932(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__74939 = structure;
var G__74940 = s;
var G__74941 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__74942 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__74939,G__74940,G__74941,G__74942) : com.rpl.specter.navs.srange_transform.call(null,G__74939,G__74940,G__74941,G__74942));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74943 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74943 = (function (start_index_fn,end_index_fn,meta74944){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta74944 = meta74944;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74943.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74945,meta74944__$1){
var self__ = this;
var _74945__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74943(self__.start_index_fn,self__.end_index_fn,meta74944__$1));
}));

(com.rpl.specter.t_com$rpl$specter74943.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74945){
var self__ = this;
var _74945__$1 = this;
return self__.meta74944;
}));

(com.rpl.specter.t_com$rpl$specter74943.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74943.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74943.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__74946 = structure;
var G__74947 = s;
var G__74948 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__74949 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__74946,G__74947,G__74948,G__74949) : com.rpl.specter.navs.srange_transform.call(null,G__74946,G__74947,G__74948,G__74949));
}));

(com.rpl.specter.t_com$rpl$specter74943.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta74944","meta74944",-674490162,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74943.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74943.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74943");

(com.rpl.specter.t_com$rpl$specter74943.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74943");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74943.
 */
com.rpl.specter.__GT_t_com$rpl$specter74943 = (function com$rpl$specter$__GT_t_com$rpl$specter74943(start_index_fn__$1,end_index_fn__$1,meta74944){
return (new com.rpl.specter.t_com$rpl$specter74943(start_index_fn__$1,end_index_fn__$1,meta74944));
});

}

return (new com.rpl.specter.t_com$rpl$specter74943(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74950 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74950 = (function (start,end,meta74951){
this.start = start;
this.end = end;
this.meta74951 = meta74951;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74950.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74952,meta74951__$1){
var self__ = this;
var _74952__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74950(self__.start,self__.end,meta74951__$1));
}));

(com.rpl.specter.t_com$rpl$specter74950.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74952){
var self__ = this;
var _74952__$1 = this;
return self__.meta74951;
}));

(com.rpl.specter.t_com$rpl$specter74950.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74950.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74950.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter74950.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta74951","meta74951",-2124820868,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74950.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74950.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74950");

(com.rpl.specter.t_com$rpl$specter74950.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74950");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74950.
 */
com.rpl.specter.__GT_t_com$rpl$specter74950 = (function com$rpl$specter$__GT_t_com$rpl$specter74950(start__$1,end__$1,meta74951){
return (new com.rpl.specter.t_com$rpl$specter74950(start__$1,end__$1,meta74951));
});

}

return (new com.rpl.specter.t_com$rpl$specter74950(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,p__74954){
var vec__74955 = p__74954;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74955,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74955,(1),null);
var ret__38246__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74958 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74958 = (function (pred,meta74959){
this.pred = pred;
this.meta74959 = meta74959;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74958.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74960,meta74959__$1){
var self__ = this;
var _74960__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74958(self__.pred,meta74959__$1));
}));

(com.rpl.specter.t_com$rpl$specter74958.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74960){
var self__ = this;
var _74960__$1 = this;
return self__.meta74959;
}));

(com.rpl.specter.t_com$rpl$specter74958.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74958.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,p__74961){
var vec__74962 = p__74961;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74962,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74962,(1),null);
var ret__38246__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter74958.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74958.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta74959","meta74959",-1051925341,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74958.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74958.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74958");

(com.rpl.specter.t_com$rpl$specter74958.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74958");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74958.
 */
com.rpl.specter.__GT_t_com$rpl$specter74958 = (function com$rpl$specter$__GT_t_com$rpl$specter74958(pred__$1,meta74959){
return (new com.rpl.specter.t_com$rpl$specter74958(pred__$1,meta74959));
});

}

return (new com.rpl.specter.t_com$rpl$specter74958(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__74965 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74965) : next_fn.call(null,G__74965));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__74966 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74966) : next_fn.call(null,G__74966));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74967 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74967 = (function (meta74968){
this.meta74968 = meta74968;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74967.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74969,meta74968__$1){
var self__ = this;
var _74969__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74967(meta74968__$1));
}));

(com.rpl.specter.t_com$rpl$specter74967.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74969){
var self__ = this;
var _74969__$1 = this;
return self__.meta74968;
}));

(com.rpl.specter.t_com$rpl$specter74967.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74967.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter74967.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter74967.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74968","meta74968",-885350508,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74967.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74967.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74967");

(com.rpl.specter.t_com$rpl$specter74967.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74967");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74967.
 */
com.rpl.specter.__GT_t_com$rpl$specter74967 = (function com$rpl$specter$__GT_t_com$rpl$specter74967(meta74968){
return (new com.rpl.specter.t_com$rpl$specter74967(meta74968));
});

}

return (new com.rpl.specter.t_com$rpl$specter74967(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__74970 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74970) : next_fn.call(null,G__74970));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__74971 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74971) : next_fn.call(null,G__74971));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74972 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74972 = (function (meta74973){
this.meta74973 = meta74973;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74972.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74974,meta74973__$1){
var self__ = this;
var _74974__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74972(meta74973__$1));
}));

(com.rpl.specter.t_com$rpl$specter74972.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74974){
var self__ = this;
var _74974__$1 = this;
return self__.meta74973;
}));

(com.rpl.specter.t_com$rpl$specter74972.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74972.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter74972.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter74972.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74973","meta74973",-559986300,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74972.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74972.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74972");

(com.rpl.specter.t_com$rpl$specter74972.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74972");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74972.
 */
com.rpl.specter.__GT_t_com$rpl$specter74972 = (function com$rpl$specter$__GT_t_com$rpl$specter74972(meta74973){
return (new com.rpl.specter.t_com$rpl$specter74972(meta74973));
});

}

return (new com.rpl.specter.t_com$rpl$specter74972(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74976 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74976 = (function (meta74977){
this.meta74977 = meta74977;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74976.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74978,meta74977__$1){
var self__ = this;
var _74978__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74976(meta74977__$1));
}));

(com.rpl.specter.t_com$rpl$specter74976.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74978){
var self__ = this;
var _74978__$1 = this;
return self__.meta74977;
}));

(com.rpl.specter.t_com$rpl$specter74976.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74976.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74976.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter74976.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74977","meta74977",999826756,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74976.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74976.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74976");

(com.rpl.specter.t_com$rpl$specter74976.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74976");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74976.
 */
com.rpl.specter.__GT_t_com$rpl$specter74976 = (function com$rpl$specter$__GT_t_com$rpl$specter74976(meta74977){
return (new com.rpl.specter.t_com$rpl$specter74976(meta74977));
});

}

return (new com.rpl.specter.t_com$rpl$specter74976(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74979 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74979 = (function (meta74980){
this.meta74980 = meta74980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74981,meta74980__$1){
var self__ = this;
var _74981__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74979(meta74980__$1));
}));

(com.rpl.specter.t_com$rpl$specter74979.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74981){
var self__ = this;
var _74981__$1 = this;
return self__.meta74980;
}));

(com.rpl.specter.t_com$rpl$specter74979.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74979.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74979.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter74979.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74980","meta74980",-581704675,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74979.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74979.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74979");

(com.rpl.specter.t_com$rpl$specter74979.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74979");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74979.
 */
com.rpl.specter.__GT_t_com$rpl$specter74979 = (function com$rpl$specter$__GT_t_com$rpl$specter74979(meta74980){
return (new com.rpl.specter.t_com$rpl$specter74979(meta74980));
});

}

return (new com.rpl.specter.t_com$rpl$specter74979(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74982 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74982 = (function (meta74983){
this.meta74983 = meta74983;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74982.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74984,meta74983__$1){
var self__ = this;
var _74984__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74982(meta74983__$1));
}));

(com.rpl.specter.t_com$rpl$specter74982.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74984){
var self__ = this;
var _74984__$1 = this;
return self__.meta74983;
}));

(com.rpl.specter.t_com$rpl$specter74982.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74982.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74982.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter74982.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74983","meta74983",1051535968,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74982.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74982.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74982");

(com.rpl.specter.t_com$rpl$specter74982.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74982");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74982.
 */
com.rpl.specter.__GT_t_com$rpl$specter74982 = (function com$rpl$specter$__GT_t_com$rpl$specter74982(meta74983){
return (new com.rpl.specter.t_com$rpl$specter74982(meta74983));
});

}

return (new com.rpl.specter.t_com$rpl$specter74982(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__74985 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74985) : next_fn.call(null,G__74985));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74987 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74987 = (function (aset,meta74988){
this.aset = aset;
this.meta74988 = meta74988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74989,meta74988__$1){
var self__ = this;
var _74989__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74987(self__.aset,meta74988__$1));
}));

(com.rpl.specter.t_com$rpl$specter74987.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74989){
var self__ = this;
var _74989__$1 = this;
return self__.meta74988;
}));

(com.rpl.specter.t_com$rpl$specter74987.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74987.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter74987.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter74987.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta74988","meta74988",841153965,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74987.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74987.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74987");

(com.rpl.specter.t_com$rpl$specter74987.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74987");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74987.
 */
com.rpl.specter.__GT_t_com$rpl$specter74987 = (function com$rpl$specter$__GT_t_com$rpl$specter74987(aset__$1,meta74988){
return (new com.rpl.specter.t_com$rpl$specter74987(aset__$1,meta74988));
});

}

return (new com.rpl.specter.t_com$rpl$specter74987(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__74990 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74990) : next_fn.call(null,G__74990));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74991 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74991 = (function (m_keys,meta74992){
this.m_keys = m_keys;
this.meta74992 = meta74992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74993,meta74992__$1){
var self__ = this;
var _74993__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74991(self__.m_keys,meta74992__$1));
}));

(com.rpl.specter.t_com$rpl$specter74991.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74993){
var self__ = this;
var _74993__$1 = this;
return self__.meta74992;
}));

(com.rpl.specter.t_com$rpl$specter74991.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74991.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter74991.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter74991.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta74992","meta74992",-526365917,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74991.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74991.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74991");

(com.rpl.specter.t_com$rpl$specter74991.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74991");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74991.
 */
com.rpl.specter.__GT_t_com$rpl$specter74991 = (function com$rpl$specter$__GT_t_com$rpl$specter74991(m_keys__$1,meta74992){
return (new com.rpl.specter.t_com$rpl$specter74991(m_keys__$1,meta74992));
});

}

return (new com.rpl.specter.t_com$rpl$specter74991(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75215__delegate = function (path){
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74994 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74994 = (function (path,late,meta74995){
this.path = path;
this.late = late;
this.meta74995 = meta74995;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74994.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74996,meta74995__$1){
var self__ = this;
var _74996__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74994(self__.path,self__.late,meta74995__$1));
}));

(com.rpl.specter.t_com$rpl$specter74994.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74996){
var self__ = this;
var _74996__$1 = this;
return self__.meta74995;
}));

(com.rpl.specter.t_com$rpl$specter74994.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74994.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74994.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__74997 = self__.late;
var G__74998 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__74999 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__74997,G__74998,G__74999) : com.rpl.specter.compiled_transform.call(null,G__74997,G__74998,G__74999));
}));

(com.rpl.specter.t_com$rpl$specter74994.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74995","meta74995",-259228371,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74994.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74994.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74994");

(com.rpl.specter.t_com$rpl$specter74994.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74994");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74994.
 */
com.rpl.specter.__GT_t_com$rpl$specter74994 = (function com$rpl$specter$__GT_t_com$rpl$specter74994(path__$1,late__$1,meta74995){
return (new com.rpl.specter.t_com$rpl$specter74994(path__$1,late__$1,meta74995));
});

}

return (new com.rpl.specter.t_com$rpl$specter74994(path,late,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
};
var G__75215 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75216__i = 0, G__75216__a = new Array(arguments.length -  0);
while (G__75216__i < G__75216__a.length) {G__75216__a[G__75216__i] = arguments[G__75216__i + 0]; ++G__75216__i;}
  path = new cljs.core.IndexedSeq(G__75216__a,0,null);
} 
return G__75215__delegate.call(this,path);};
G__75215.cljs$lang$maxFixedArity = 0;
G__75215.cljs$lang$applyTo = (function (arglist__75217){
var path = cljs.core.seq(arglist__75217);
return G__75215__delegate(path);
});
G__75215.cljs$core$IFn$_invoke$arity$variadic = G__75215__delegate;
return G__75215;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75000 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75000 = (function (key,meta75001){
this.key = key;
this.meta75001 = meta75001;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75000.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75002,meta75001__$1){
var self__ = this;
var _75002__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75000(self__.key,meta75001__$1));
}));

(com.rpl.specter.t_com$rpl$specter75000.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75002){
var self__ = this;
var _75002__$1 = this;
return self__.meta75001;
}));

(com.rpl.specter.t_com$rpl$specter75000.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75000.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter75000.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter75000.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta75001","meta75001",1945880906,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75000.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75000.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75000");

(com.rpl.specter.t_com$rpl$specter75000.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75000");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75000.
 */
com.rpl.specter.__GT_t_com$rpl$specter75000 = (function com$rpl$specter$__GT_t_com$rpl$specter75000(key__$1,meta75001){
return (new com.rpl.specter.t_com$rpl$specter75000(key__$1,meta75001));
});

}

return (new com.rpl.specter.t_com$rpl$specter75000(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75003 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75003 = (function (elem,meta75004){
this.elem = elem;
this.meta75004 = meta75004;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75003.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75005,meta75004__$1){
var self__ = this;
var _75005__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75003(self__.elem,meta75004__$1));
}));

(com.rpl.specter.t_com$rpl$specter75003.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75005){
var self__ = this;
var _75005__$1 = this;
return self__.meta75004;
}));

(com.rpl.specter.t_com$rpl$specter75003.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75003.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter75003.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter75003.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta75004","meta75004",1006634456,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75003.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75003.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75003");

(com.rpl.specter.t_com$rpl$specter75003.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75003");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75003.
 */
com.rpl.specter.__GT_t_com$rpl$specter75003 = (function com$rpl$specter$__GT_t_com$rpl$specter75003(elem__$1,meta75004){
return (new com.rpl.specter.t_com$rpl$specter75003(elem__$1,meta75004));
});

}

return (new com.rpl.specter.t_com$rpl$specter75003(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75007 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75007 = (function (index,meta75008){
this.index = index;
this.meta75008 = meta75008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75009,meta75008__$1){
var self__ = this;
var _75009__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75007(self__.index,meta75008__$1));
}));

(com.rpl.specter.t_com$rpl$specter75007.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75009){
var self__ = this;
var _75009__$1 = this;
return self__.meta75008;
}));

(com.rpl.specter.t_com$rpl$specter75007.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75007.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter75007.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75010;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75011 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,755,758,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache75010 = info75011;

return info75011;
})():info__39938__auto__);
var precompiled75012 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75013 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled75012.cljs$core$IFn$_invoke$arity$1 ? precompiled75012.cljs$core$IFn$_invoke$arity$1(G__75013) : precompiled75012.call(null,G__75013));
} else {
return precompiled75012;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter75007.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta75008","meta75008",2000221338,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75007.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75007.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75007");

(com.rpl.specter.t_com$rpl$specter75007.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75007");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75007.
 */
com.rpl.specter.__GT_t_com$rpl$specter75007 = (function com$rpl$specter$__GT_t_com$rpl$specter75007(index__$1,meta75008){
return (new com.rpl.specter.t_com$rpl$specter75007(index__$1,meta75008));
});

}

return (new com.rpl.specter.t_com$rpl$specter75007(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75014 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75014 = (function (i,meta75015){
this.i = i;
this.meta75015 = meta75015;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75014.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75016,meta75015__$1){
var self__ = this;
var _75016__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75014(self__.i,meta75015__$1));
}));

(com.rpl.specter.t_com$rpl$specter75014.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75016){
var self__ = this;
var _75016__$1 = this;
return self__.meta75015;
}));

(com.rpl.specter.t_com$rpl$specter75014.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75014.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter75014.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__75219 = (j - (1));
var G__75220 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__75219;
s = G__75220;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__75221 = (j + (1));
var G__75222 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__75221;
s = G__75222;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75017;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75018 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,968,971,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache75017 = info75018;

return info75018;
})():info__39938__auto__);
var precompiled75019 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75020 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled75019.cljs$core$IFn$_invoke$arity$1 ? precompiled75019.cljs$core$IFn$_invoke$arity$1(G__75020) : precompiled75019.call(null,G__75020));
} else {
return precompiled75019;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75021;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75022 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache75021 = info75022;

return info75022;
})():info__39938__auto__);
var precompiled75023 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75024 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled75023.cljs$core$IFn$_invoke$arity$1 ? precompiled75023.cljs$core$IFn$_invoke$arity$1(G__75024) : precompiled75023.call(null,G__75024));
} else {
return precompiled75023;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter75014.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta75015","meta75015",-661270952,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75014.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75014.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75014");

(com.rpl.specter.t_com$rpl$specter75014.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75014");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75014.
 */
com.rpl.specter.__GT_t_com$rpl$specter75014 = (function com$rpl$specter$__GT_t_com$rpl$specter75014(i__$1,meta75015){
return (new com.rpl.specter.t_com$rpl$specter75014(i__$1,meta75015));
});

}

return (new com.rpl.specter.t_com$rpl$specter75014(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,e){
var ret__38246__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__75027 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75027) : next_fn.call(null,G__75027));
})()
;
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__75028 = (function (){var G__75031 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75031) : next_fn.call(null,G__75031));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75028,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75028,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75032;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75033 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__75025_SHARP_){
return (p1__75025_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__75026_SHARP_){
return (p1__75026_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache75032 = info75033;

return info75033;
})():info__39938__auto__);
var precompiled75034 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75035 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__75025_SHARP_){
return (p1__75025_SHARP_ >= (curri + (1)));
}),(function (p1__75026_SHARP_){
return (p1__75026_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__75025_SHARP_){
return (p1__75025_SHARP_ >= (curri + (1)));
}),(function (p1__75026_SHARP_){
return (p1__75026_SHARP_ <= newi);
})], null);
return (precompiled75034.cljs$core$IFn$_invoke$arity$1 ? precompiled75034.cljs$core$IFn$_invoke$arity$1(G__75035) : precompiled75034.call(null,G__75035));
} else {
return precompiled75034;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75036;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75037 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache75036 = info75037;

return info75037;
})():info__39938__auto__);
var precompiled75038 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75039 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled75038.cljs$core$IFn$_invoke$arity$1 ? precompiled75038.cljs$core$IFn$_invoke$arity$1(G__75039) : precompiled75038.call(null,G__75039));
} else {
return precompiled75038;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75040;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75041 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache75040 = info75041;

return info75041;
})():info__39938__auto__);
var precompiled75042 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75044 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled75042.cljs$core$IFn$_invoke$arity$1 ? precompiled75042.cljs$core$IFn$_invoke$arity$1(G__75044) : precompiled75042.call(null,G__75044));
} else {
return precompiled75042;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75045 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75045 = (function (start,meta75046){
this.start = start;
this.meta75046 = meta75046;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75045.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75047,meta75046__$1){
var self__ = this;
var _75047__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75045(self__.start,meta75046__$1));
}));

(com.rpl.specter.t_com$rpl$specter75045.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75047){
var self__ = this;
var _75047__$1 = this;
return self__.meta75046;
}));

(com.rpl.specter.t_com$rpl$specter75045.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75045.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,e){
var ret__38246__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter75045.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__75048 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75048,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75048,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75051;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75052 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__75025_SHARP_){
return (p1__75025_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__75026_SHARP_){
return (p1__75026_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__75025#","p1__75025#",-666398962,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__75026#","p1__75026#",1695204665,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache75051 = info75052;

return info75052;
})():info__39938__auto__);
var precompiled75053 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75054 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__75025_SHARP_){
return (p1__75025_SHARP_ >= (curri + (1)));
}),(function (p1__75026_SHARP_){
return (p1__75026_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__75025_SHARP_){
return (p1__75025_SHARP_ >= (curri + (1)));
}),(function (p1__75026_SHARP_){
return (p1__75026_SHARP_ <= newi);
})], null);
return (precompiled75053.cljs$core$IFn$_invoke$arity$1 ? precompiled75053.cljs$core$IFn$_invoke$arity$1(G__75054) : precompiled75053.call(null,G__75054));
} else {
return precompiled75053;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75055;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75056 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache75055 = info75056;

return info75056;
})():info__39938__auto__);
var precompiled75057 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75058 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled75057.cljs$core$IFn$_invoke$arity$1 ? precompiled75057.cljs$core$IFn$_invoke$arity$1(G__75058) : precompiled75057.call(null,G__75058));
} else {
return precompiled75057;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39938__auto__ = com.rpl.specter.pathcache75059;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75060 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache75059 = info75060;

return info75060;
})():info__39938__auto__);
var precompiled75061 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75062 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled75061.cljs$core$IFn$_invoke$arity$1 ? precompiled75061.cljs$core$IFn$_invoke$arity$1(G__75062) : precompiled75061.call(null,G__75062));
} else {
return precompiled75061;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter75045.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta75046","meta75046",1184761851,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75045.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75045.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75045");

(com.rpl.specter.t_com$rpl$specter75045.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75045");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75045.
 */
com.rpl.specter.__GT_t_com$rpl$specter75045 = (function com$rpl$specter$__GT_t_com$rpl$specter75045(start__$1,meta75046){
return (new com.rpl.specter.t_com$rpl$specter75045(start__$1,meta75046));
});

}

return (new com.rpl.specter.t_com$rpl$specter75045(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75063 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75063 = (function (afn,meta75064){
this.afn = afn;
this.meta75064 = meta75064;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75063.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75065,meta75064__$1){
var self__ = this;
var _75065__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75063(self__.afn,meta75064__$1));
}));

(com.rpl.specter.t_com$rpl$specter75063.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75065){
var self__ = this;
var _75065__$1 = this;
return self__.meta75064;
}));

(com.rpl.specter.t_com$rpl$specter75063.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75063.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__75066 = vals;
var G__75067 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__75066,G__75067) : next_fn.call(null,G__75066,G__75067));
}));

(com.rpl.specter.t_com$rpl$specter75063.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__75068 = vals;
var G__75069 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__75068,G__75069) : next_fn.call(null,G__75068,G__75069));
}));

(com.rpl.specter.t_com$rpl$specter75063.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta75064","meta75064",1427935448,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75063.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75063.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75063");

(com.rpl.specter.t_com$rpl$specter75063.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75063");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75063.
 */
com.rpl.specter.__GT_t_com$rpl$specter75063 = (function com$rpl$specter$__GT_t_com$rpl$specter75063(afn__$1,meta75064){
return (new com.rpl.specter.t_com$rpl$specter75063(afn__$1,meta75064));
});

}

return (new com.rpl.specter.t_com$rpl$specter75063(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__75070 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75070) : next_fn.call(null,G__75070));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__75071 = (function (){var G__75072 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75072) : next_fn.call(null,G__75072));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__75071) : unparse_fn.call(null,G__75071));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75073 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75073 = (function (parse_fn,unparse_fn,meta75074){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta75074 = meta75074;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75073.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75075,meta75074__$1){
var self__ = this;
var _75075__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75073(self__.parse_fn,self__.unparse_fn,meta75074__$1));
}));

(com.rpl.specter.t_com$rpl$specter75073.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75075){
var self__ = this;
var _75075__$1 = this;
return self__.meta75074;
}));

(com.rpl.specter.t_com$rpl$specter75073.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75073.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter75073.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var G__75076 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__75076) : self__.unparse_fn.call(null,G__75076));
}));

(com.rpl.specter.t_com$rpl$specter75073.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta75074","meta75074",-726763840,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75073.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75073.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75073");

(com.rpl.specter.t_com$rpl$specter75073.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75073");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75073.
 */
com.rpl.specter.__GT_t_com$rpl$specter75073 = (function com$rpl$specter$__GT_t_com$rpl$specter75073(parse_fn__$1,unparse_fn__$1,meta75074){
return (new com.rpl.specter.t_com$rpl$specter75073(parse_fn__$1,unparse_fn__$1,meta75074));
});

}

return (new com.rpl.specter.t_com$rpl$specter75073(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__75078 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75078) : next_fn.call(null,G__75078));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75079 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75079 = (function (meta75080){
this.meta75080 = meta75080;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75079.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75081,meta75080__$1){
var self__ = this;
var _75081__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75079(meta75080__$1));
}));

(com.rpl.specter.t_com$rpl$specter75079.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75081){
var self__ = this;
var _75081__$1 = this;
return self__.meta75080;
}));

(com.rpl.specter.t_com$rpl$specter75079.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75079.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter75079.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter75079.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta75080","meta75080",-18392979,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75079.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75079.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75079");

(com.rpl.specter.t_com$rpl$specter75079.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75079");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75079.
 */
com.rpl.specter.__GT_t_com$rpl$specter75079 = (function com$rpl$specter$__GT_t_com$rpl$specter75079(meta75080){
return (new com.rpl.specter.t_com$rpl$specter75079(meta75080));
});

}

return (new com.rpl.specter.t_com$rpl$specter75079(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,s){
var ret__38246__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75082 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75082 = (function (re,meta75083){
this.re = re;
this.meta75083 = meta75083;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75082.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75084,meta75083__$1){
var self__ = this;
var _75084__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75082(self__.re,meta75083__$1));
}));

(com.rpl.specter.t_com$rpl$specter75082.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75084){
var self__ = this;
var _75084__$1 = this;
return self__.meta75083;
}));

(com.rpl.specter.t_com$rpl$specter75082.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75082.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38245__auto__,s){
var ret__38246__auto__ = next_fn(s);
if((ret__38246__auto__ === com.rpl.specter.NONE)){
return curr__38245__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38246__auto__)){
return cljs.core.reduced(ret__38246__auto__);
} else {
return ret__38246__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter75082.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter75082.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta75083","meta75083",-238102509,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75082.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75082.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75082");

(com.rpl.specter.t_com$rpl$specter75082.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75082");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75082.
 */
com.rpl.specter.__GT_t_com$rpl$specter75082 = (function com$rpl$specter$__GT_t_com$rpl$specter75082(re__$1,meta75083){
return (new com.rpl.specter.t_com$rpl$specter75082(re__$1,meta75083));
});

}

return (new com.rpl.specter.t_com$rpl$specter75082(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75224__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75087 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75087 = (function (path,temp__5733__auto__,late,meta75088){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta75088 = meta75088;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75089,meta75088__$1){
var self__ = this;
var _75089__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75087(self__.path,self__.temp__5733__auto__,self__.late,meta75088__$1));
}));

(com.rpl.specter.t_com$rpl$specter75087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75089){
var self__ = this;
var _75089__$1 = this;
return self__.meta75088;
}));

(com.rpl.specter.t_com$rpl$specter75087.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75087.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__75085_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__75085_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter75087.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__75086_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__75086_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter75087.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta75088","meta75088",-793984039,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75087.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75087.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75087");

(com.rpl.specter.t_com$rpl$specter75087.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75087");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75087.
 */
com.rpl.specter.__GT_t_com$rpl$specter75087 = (function com$rpl$specter$__GT_t_com$rpl$specter75087(path__$1,temp__5733__auto____$1,late__$1,meta75088){
return (new com.rpl.specter.t_com$rpl$specter75087(path__$1,temp__5733__auto____$1,late__$1,meta75088));
});

}

return (new com.rpl.specter.t_com$rpl$specter75087(path,temp__5733__auto__,late,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
}
};
var G__75224 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75225__i = 0, G__75225__a = new Array(arguments.length -  0);
while (G__75225__i < G__75225__a.length) {G__75225__a[G__75225__i] = arguments[G__75225__i + 0]; ++G__75225__i;}
  path = new cljs.core.IndexedSeq(G__75225__a,0,null);
} 
return G__75224__delegate.call(this,path);};
G__75224.cljs$lang$maxFixedArity = 0;
G__75224.cljs$lang$applyTo = (function (arglist__75226){
var path = cljs.core.seq(arglist__75226);
return G__75224__delegate(path);
});
G__75224.cljs$core$IFn$_invoke$arity$variadic = G__75224__delegate;
return G__75224;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75227__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75092 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75092 = (function (path,temp__5733__auto__,late,meta75093){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta75093 = meta75093;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75092.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75094,meta75093__$1){
var self__ = this;
var _75094__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75092(self__.path,self__.temp__5733__auto__,self__.late,meta75093__$1));
}));

(com.rpl.specter.t_com$rpl$specter75092.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75094){
var self__ = this;
var _75094__$1 = this;
return self__.meta75093;
}));

(com.rpl.specter.t_com$rpl$specter75092.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75092.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__75090_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__75090_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter75092.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__75091_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__75091_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter75092.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta75093","meta75093",-956575824,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75092.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75092.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75092");

(com.rpl.specter.t_com$rpl$specter75092.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75092");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75092.
 */
com.rpl.specter.__GT_t_com$rpl$specter75092 = (function com$rpl$specter$__GT_t_com$rpl$specter75092(path__$1,temp__5733__auto____$1,late__$1,meta75093){
return (new com.rpl.specter.t_com$rpl$specter75092(path__$1,temp__5733__auto____$1,late__$1,meta75093));
});

}

return (new com.rpl.specter.t_com$rpl$specter75092(path,temp__5733__auto__,late,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
}
};
var G__75227 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75228__i = 0, G__75228__a = new Array(arguments.length -  0);
while (G__75228__i < G__75228__a.length) {G__75228__a[G__75228__i] = arguments[G__75228__i + 0]; ++G__75228__i;}
  path = new cljs.core.IndexedSeq(G__75228__a,0,null);
} 
return G__75227__delegate.call(this,path);};
G__75227.cljs$lang$maxFixedArity = 0;
G__75227.cljs$lang$applyTo = (function (arglist__75229){
var path = cljs.core.seq(arglist__75229);
return G__75227__delegate(path);
});
G__75227.cljs$core$IFn$_invoke$arity$variadic = G__75227__delegate;
return G__75227;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75230__delegate = function (path){
var G__75095 = com.rpl.specter.ALL;
var G__75096 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__75095,G__75096) : com.rpl.specter.subselect.call(null,G__75095,G__75096));
};
var G__75230 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75231__i = 0, G__75231__a = new Array(arguments.length -  0);
while (G__75231__i < G__75231__a.length) {G__75231__a[G__75231__i] = arguments[G__75231__i + 0]; ++G__75231__i;}
  path = new cljs.core.IndexedSeq(G__75231__a,0,null);
} 
return G__75230__delegate.call(this,path);};
G__75230.cljs$lang$maxFixedArity = 0;
G__75230.cljs$lang$applyTo = (function (arglist__75232){
var path = cljs.core.seq(arglist__75232);
return G__75230__delegate(path);
});
G__75230.cljs$core$IFn$_invoke$arity$variadic = G__75230__delegate;
return G__75230;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75097 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75097 = (function (path,update_fn,late,late_fn,meta75098){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta75098 = meta75098;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75097.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75099,meta75098__$1){
var self__ = this;
var _75099__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75097(self__.path,self__.update_fn,self__.late,self__.late_fn,meta75098__$1));
}));

(com.rpl.specter.t_com$rpl$specter75097.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75099){
var self__ = this;
var _75099__$1 = this;
return self__.meta75098;
}));

(com.rpl.specter.t_com$rpl$specter75097.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75097.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter75097.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter75097.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta75098","meta75098",-651319583,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75097.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75097.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75097");

(com.rpl.specter.t_com$rpl$specter75097.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75097");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75097.
 */
com.rpl.specter.__GT_t_com$rpl$specter75097 = (function com$rpl$specter$__GT_t_com$rpl$specter75097(path__$1,update_fn__$1,late__$1,late_fn__$1,meta75098){
return (new com.rpl.specter.t_com$rpl$specter75097(path__$1,update_fn__$1,late__$1,late_fn__$1,meta75098));
});

}

return (new com.rpl.specter.t_com$rpl$specter75097(path,update_fn,late,late_fn,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75101 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75101 = (function (path,reduce_fn,late,late_fn,meta75102){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta75102 = meta75102;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75101.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75103,meta75102__$1){
var self__ = this;
var _75103__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75101(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta75102__$1));
}));

(com.rpl.specter.t_com$rpl$specter75101.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75103){
var self__ = this;
var _75103__$1 = this;
return self__.meta75102;
}));

(com.rpl.specter.t_com$rpl$specter75101.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75101.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter75101.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter75101.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta75102","meta75102",-1758119006,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75101.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75101.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75101");

(com.rpl.specter.t_com$rpl$specter75101.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75101");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75101.
 */
com.rpl.specter.__GT_t_com$rpl$specter75101 = (function com$rpl$specter$__GT_t_com$rpl$specter75101(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta75102){
return (new com.rpl.specter.t_com$rpl$specter75101(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta75102));
});

}

return (new com.rpl.specter.t_com$rpl$specter75101(path,reduce_fn,late,late_fn,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__75105 = (function (p1__75104_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__75104_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__75105) : com.rpl.specter.pred.call(null,G__75105));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__75107 = (function (p1__75106_SHARP_){
return (p1__75106_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__75107) : com.rpl.specter.pred.call(null,G__75107));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__75109 = (function (p1__75108_SHARP_){
return (p1__75108_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__75109) : com.rpl.specter.pred.call(null,G__75109));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__75111 = (function (p1__75110_SHARP_){
return (p1__75110_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__75111) : com.rpl.specter.pred.call(null,G__75111));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__75113 = (function (p1__75112_SHARP_){
return (p1__75112_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__75113) : com.rpl.specter.pred.call(null,G__75113));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__75114 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75114) : next_fn.call(null,G__75114));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__75115 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75115) : next_fn.call(null,G__75115));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75116 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75116 = (function (v,meta75117){
this.v = v;
this.meta75117 = meta75117;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75116.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75118,meta75117__$1){
var self__ = this;
var _75118__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75116(self__.v,meta75117__$1));
}));

(com.rpl.specter.t_com$rpl$specter75116.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75118){
var self__ = this;
var _75118__$1 = this;
return self__.meta75117;
}));

(com.rpl.specter.t_com$rpl$specter75116.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75116.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter75116.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter75116.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta75117","meta75117",1396867203,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75116.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75116.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75116");

(com.rpl.specter.t_com$rpl$specter75116.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75116");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75116.
 */
com.rpl.specter.__GT_t_com$rpl$specter75116 = (function com$rpl$specter$__GT_t_com$rpl$specter75116(v__$1,meta75117){
return (new com.rpl.specter.t_com$rpl$specter75116(v__$1,meta75117));
});

}

return (new com.rpl.specter.t_com$rpl$specter75116(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__75119 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__75119) : com.rpl.specter.nil__GT_val.call(null,G__75119));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__75120 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__75120) : com.rpl.specter.nil__GT_val.call(null,G__75120));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__75121 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__75121) : com.rpl.specter.nil__GT_val.call(null,G__75121));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__75122 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75122) : next_fn.call(null,G__75122));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__75123 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75123) : next_fn.call(null,G__75123));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75124 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75124 = (function (meta75125){
this.meta75125 = meta75125;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75124.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75126,meta75125__$1){
var self__ = this;
var _75126__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75124(meta75125__$1));
}));

(com.rpl.specter.t_com$rpl$specter75124.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75126){
var self__ = this;
var _75126__$1 = this;
return self__.meta75125;
}));

(com.rpl.specter.t_com$rpl$specter75124.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75124.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter75124.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter75124.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta75125","meta75125",1770852102,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75124.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75124.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75124");

(com.rpl.specter.t_com$rpl$specter75124.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75124");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75124.
 */
com.rpl.specter.__GT_t_com$rpl$specter75124 = (function com$rpl$specter$__GT_t_com$rpl$specter75124(meta75125){
return (new com.rpl.specter.t_com$rpl$specter75124(meta75125));
});

}

return (new com.rpl.specter.t_com$rpl$specter75124(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__75127 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75127) : next_fn.call(null,G__75127));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__75128 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75128) : next_fn.call(null,G__75128));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75129 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75129 = (function (meta75130){
this.meta75130 = meta75130;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75129.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75131,meta75130__$1){
var self__ = this;
var _75131__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75129(meta75130__$1));
}));

(com.rpl.specter.t_com$rpl$specter75129.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75131){
var self__ = this;
var _75131__$1 = this;
return self__.meta75130;
}));

(com.rpl.specter.t_com$rpl$specter75129.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75129.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter75129.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter75129.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta75130","meta75130",-371253713,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75129.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75129.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75129");

(com.rpl.specter.t_com$rpl$specter75129.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75129");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75129.
 */
com.rpl.specter.__GT_t_com$rpl$specter75129 = (function com$rpl$specter$__GT_t_com$rpl$specter75129(meta75130){
return (new com.rpl.specter.t_com$rpl$specter75129(meta75130));
});

}

return (new com.rpl.specter.t_com$rpl$specter75129(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__75133 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75133) : next_fn.call(null,G__75133));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__75134 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__75134) : next_fn.call(null,G__75134));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75135 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75135 = (function (meta75136){
this.meta75136 = meta75136;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75135.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75137,meta75136__$1){
var self__ = this;
var _75137__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75135(meta75136__$1));
}));

(com.rpl.specter.t_com$rpl$specter75135.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75137){
var self__ = this;
var _75137__$1 = this;
return self__.meta75136;
}));

(com.rpl.specter.t_com$rpl$specter75135.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75135.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter75135.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39144__auto__,vals__39145__auto__,structure,next_fn__39146__auto__){
var self__ = this;
var this__39144__auto____$1 = this;
var next_fn = (function (s__39147__auto__){
return (next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39146__auto__.cljs$core$IFn$_invoke$arity$2(vals__39145__auto__,s__39147__auto__) : next_fn__39146__auto__.call(null,vals__39145__auto__,s__39147__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter75135.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta75136","meta75136",1469001587,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75135.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75135.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75135");

(com.rpl.specter.t_com$rpl$specter75135.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75135");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75135.
 */
com.rpl.specter.__GT_t_com$rpl$specter75135 = (function com$rpl$specter$__GT_t_com$rpl$specter75135(meta75136){
return (new com.rpl.specter.t_com$rpl$specter75135(meta75136));
});

}

return (new com.rpl.specter.t_com$rpl$specter75135(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75242__delegate = function (path){
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75138 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75138 = (function (path,late,meta75139){
this.path = path;
this.late = late;
this.meta75139 = meta75139;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75138.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75140,meta75139__$1){
var self__ = this;
var _75140__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75138(self__.path,self__.late,meta75139__$1));
}));

(com.rpl.specter.t_com$rpl$specter75138.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75140){
var self__ = this;
var _75140__$1 = this;
return self__.meta75139;
}));

(com.rpl.specter.t_com$rpl$specter75138.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75138.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39928__auto__,vals__39929__auto__,structure,next_fn__39930__auto__){
var self__ = this;
var this__39928__auto____$1 = this;
var G__75141 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39929__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__75142 = structure;
return (next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2(G__75141,G__75142) : next_fn__39930__auto__.call(null,G__75141,G__75142));
}));

(com.rpl.specter.t_com$rpl$specter75138.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39928__auto__,vals__39929__auto__,structure,next_fn__39930__auto__){
var self__ = this;
var this__39928__auto____$1 = this;
var G__75143 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39929__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__75144 = structure;
return (next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2(G__75143,G__75144) : next_fn__39930__auto__.call(null,G__75143,G__75144));
}));

(com.rpl.specter.t_com$rpl$specter75138.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta75139","meta75139",-560103912,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75138.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75138.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75138");

(com.rpl.specter.t_com$rpl$specter75138.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75138");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75138.
 */
com.rpl.specter.__GT_t_com$rpl$specter75138 = (function com$rpl$specter$__GT_t_com$rpl$specter75138(path__$1,late__$1,meta75139){
return (new com.rpl.specter.t_com$rpl$specter75138(path__$1,late__$1,meta75139));
});

}

return (new com.rpl.specter.t_com$rpl$specter75138(path,late,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
};
var G__75242 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75243__i = 0, G__75243__a = new Array(arguments.length -  0);
while (G__75243__i < G__75243__a.length) {G__75243__a[G__75243__i] = arguments[G__75243__i + 0]; ++G__75243__i;}
  path = new cljs.core.IndexedSeq(G__75243__a,0,null);
} 
return G__75242__delegate.call(this,path);};
G__75242.cljs$lang$maxFixedArity = 0;
G__75242.cljs$lang$applyTo = (function (arglist__75244){
var path = cljs.core.seq(arglist__75244);
return G__75242__delegate(path);
});
G__75242.cljs$core$IFn$_invoke$arity$variadic = G__75242__delegate;
return G__75242;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75245__delegate = function (path){
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75145 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75145 = (function (path,late,meta75146){
this.path = path;
this.late = late;
this.meta75146 = meta75146;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75145.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75147,meta75146__$1){
var self__ = this;
var _75147__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75145(self__.path,self__.late,meta75146__$1));
}));

(com.rpl.specter.t_com$rpl$specter75145.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75147){
var self__ = this;
var _75147__$1 = this;
return self__.meta75146;
}));

(com.rpl.specter.t_com$rpl$specter75145.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75145.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39928__auto__,vals__39929__auto__,structure,next_fn__39930__auto__){
var self__ = this;
var this__39928__auto____$1 = this;
var G__75148 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39929__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__75149 = structure;
return (next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2(G__75148,G__75149) : next_fn__39930__auto__.call(null,G__75148,G__75149));
}));

(com.rpl.specter.t_com$rpl$specter75145.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39928__auto__,vals__39929__auto__,structure,next_fn__39930__auto__){
var self__ = this;
var this__39928__auto____$1 = this;
var G__75150 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39929__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__75151 = structure;
return (next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2(G__75150,G__75151) : next_fn__39930__auto__.call(null,G__75150,G__75151));
}));

(com.rpl.specter.t_com$rpl$specter75145.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta75146","meta75146",1281791678,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75145.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75145.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75145");

(com.rpl.specter.t_com$rpl$specter75145.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75145");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75145.
 */
com.rpl.specter.__GT_t_com$rpl$specter75145 = (function com$rpl$specter$__GT_t_com$rpl$specter75145(path__$1,late__$1,meta75146){
return (new com.rpl.specter.t_com$rpl$specter75145(path__$1,late__$1,meta75146));
});

}

return (new com.rpl.specter.t_com$rpl$specter75145(path,late,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
};
var G__75245 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75246__i = 0, G__75246__a = new Array(arguments.length -  0);
while (G__75246__i < G__75246__a.length) {G__75246__a[G__75246__i] = arguments[G__75246__i + 0]; ++G__75246__i;}
  path = new cljs.core.IndexedSeq(G__75246__a,0,null);
} 
return G__75245__delegate.call(this,path);};
G__75245.cljs$lang$maxFixedArity = 0;
G__75245.cljs$lang$applyTo = (function (arglist__75247){
var path = cljs.core.seq(arglist__75247);
return G__75245__delegate(path);
});
G__75245.cljs$core$IFn$_invoke$arity$variadic = G__75245__delegate;
return G__75245;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75152 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75152 = (function (val,meta75153){
this.val = val;
this.meta75153 = meta75153;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75152.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75154,meta75153__$1){
var self__ = this;
var _75154__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75152(self__.val,meta75153__$1));
}));

(com.rpl.specter.t_com$rpl$specter75152.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75154){
var self__ = this;
var _75154__$1 = this;
return self__.meta75153;
}));

(com.rpl.specter.t_com$rpl$specter75152.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75152.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39928__auto__,vals__39929__auto__,structure,next_fn__39930__auto__){
var self__ = this;
var this__39928__auto____$1 = this;
var G__75155 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39929__auto__,self__.val);
var G__75156 = structure;
return (next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2(G__75155,G__75156) : next_fn__39930__auto__.call(null,G__75155,G__75156));
}));

(com.rpl.specter.t_com$rpl$specter75152.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39928__auto__,vals__39929__auto__,structure,next_fn__39930__auto__){
var self__ = this;
var this__39928__auto____$1 = this;
var G__75157 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39929__auto__,self__.val);
var G__75158 = structure;
return (next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39930__auto__.cljs$core$IFn$_invoke$arity$2(G__75157,G__75158) : next_fn__39930__auto__.call(null,G__75157,G__75158));
}));

(com.rpl.specter.t_com$rpl$specter75152.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta75153","meta75153",859409534,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75152.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75152.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75152");

(com.rpl.specter.t_com$rpl$specter75152.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75152");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75152.
 */
com.rpl.specter.__GT_t_com$rpl$specter75152 = (function com$rpl$specter$__GT_t_com$rpl$specter75152(val__$1,meta75153){
return (new com.rpl.specter.t_com$rpl$specter75152(val__$1,meta75153));
});

}

return (new com.rpl.specter.t_com$rpl$specter75152(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75248__delegate = function (path){
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75159 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75159 = (function (path,late,meta75160){
this.path = path;
this.late = late;
this.meta75160 = meta75160;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75159.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75161,meta75160__$1){
var self__ = this;
var _75161__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75159(self__.path,self__.late,meta75160__$1));
}));

(com.rpl.specter.t_com$rpl$specter75159.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75161){
var self__ = this;
var _75161__$1 = this;
return self__.meta75160;
}));

(com.rpl.specter.t_com$rpl$specter75159.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75159.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter75159.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter75159.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta75160","meta75160",-1115415866,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75159.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75159.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75159");

(com.rpl.specter.t_com$rpl$specter75159.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75159");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75159.
 */
com.rpl.specter.__GT_t_com$rpl$specter75159 = (function com$rpl$specter$__GT_t_com$rpl$specter75159(path__$1,late__$1,meta75160){
return (new com.rpl.specter.t_com$rpl$specter75159(path__$1,late__$1,meta75160));
});

}

return (new com.rpl.specter.t_com$rpl$specter75159(path,late,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
};
var G__75248 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75249__i = 0, G__75249__a = new Array(arguments.length -  0);
while (G__75249__i < G__75249__a.length) {G__75249__a[G__75249__i] = arguments[G__75249__i + 0]; ++G__75249__i;}
  path = new cljs.core.IndexedSeq(G__75249__a,0,null);
} 
return G__75248__delegate.call(this,path);};
G__75248.cljs$lang$maxFixedArity = 0;
G__75248.cljs$lang$applyTo = (function (arglist__75250){
var path = cljs.core.seq(arglist__75250);
return G__75248__delegate(path);
});
G__75248.cljs$core$IFn$_invoke$arity$variadic = G__75248__delegate;
return G__75248;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75164 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75164 = (function (meta75165){
this.meta75165 = meta75165;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75164.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75166,meta75165__$1){
var self__ = this;
var _75166__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75164(meta75165__$1));
}));

(com.rpl.specter.t_com$rpl$specter75164.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75166){
var self__ = this;
var _75166__$1 = this;
return self__.meta75165;
}));

(com.rpl.specter.t_com$rpl$specter75164.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75164.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__75167 = cljs.core.PersistentVector.EMPTY;
var G__75168 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__75167,G__75168) : next_fn.call(null,G__75167,G__75168));
}));

(com.rpl.specter.t_com$rpl$specter75164.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__75169 = cljs.core.PersistentVector.EMPTY;
var G__75170 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__75169,G__75170) : next_fn.call(null,G__75169,G__75170));
}));

(com.rpl.specter.t_com$rpl$specter75164.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta75165","meta75165",1524797165,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75164.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75164.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75164");

(com.rpl.specter.t_com$rpl$specter75164.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75164");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75164.
 */
com.rpl.specter.__GT_t_com$rpl$specter75164 = (function com$rpl$specter$__GT_t_com$rpl$specter75164(meta75165){
return (new com.rpl.specter.t_com$rpl$specter75164(meta75165));
});

}

return (new com.rpl.specter.t_com$rpl$specter75164(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__75251 = null;
var G__75251__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__75251__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75174 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75174 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta75175){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta75175 = meta75175;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75174.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75176,meta75175__$1){
var self__ = this;
var _75176__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75174(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta75175__$1));
}));

(com.rpl.specter.t_com$rpl$specter75174.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75176){
var self__ = this;
var _75176__$1 = this;
return self__.meta75175;
}));

(com.rpl.specter.t_com$rpl$specter75174.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75174.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter75174.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter75174.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta75175","meta75175",-385306197,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75174.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75174.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75174");

(com.rpl.specter.t_com$rpl$specter75174.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75174");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75174.
 */
com.rpl.specter.__GT_t_com$rpl$specter75174 = (function com$rpl$specter$__GT_t_com$rpl$specter75174(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta75175){
return (new com.rpl.specter.t_com$rpl$specter75174(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta75175));
});

}

return (new com.rpl.specter.t_com$rpl$specter75174(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
} else {
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75177 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75177 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta75178){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta75178 = meta75178;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75177.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75179,meta75178__$1){
var self__ = this;
var _75179__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75177(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta75178__$1));
}));

(com.rpl.specter.t_com$rpl$specter75177.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75179){
var self__ = this;
var _75179__$1 = this;
return self__.meta75178;
}));

(com.rpl.specter.t_com$rpl$specter75177.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75177.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__75172_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__75172_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter75177.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__75173_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__75173_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter75177.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta75178","meta75178",2014517317,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75177.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75177.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75177");

(com.rpl.specter.t_com$rpl$specter75177.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75177");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75177.
 */
com.rpl.specter.__GT_t_com$rpl$specter75177 = (function com$rpl$specter$__GT_t_com$rpl$specter75177(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta75178){
return (new com.rpl.specter.t_com$rpl$specter75177(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta75178));
});

}

return (new com.rpl.specter.t_com$rpl$specter75177(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
}
});
G__75251 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__75251__2.call(this,cond_p,then_path);
case 3:
return G__75251__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__75251.cljs$core$IFn$_invoke$arity$2 = G__75251__2;
G__75251.cljs$core$IFn$_invoke$arity$3 = G__75251__3;
return G__75251;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75252__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__75180){
var vec__75181 = p__75180;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75181,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75181,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__75252 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__75253__i = 0, G__75253__a = new Array(arguments.length -  0);
while (G__75253__i < G__75253__a.length) {G__75253__a[G__75253__i] = arguments[G__75253__i + 0]; ++G__75253__i;}
  conds = new cljs.core.IndexedSeq(G__75253__a,0,null);
} 
return G__75252__delegate.call(this,conds);};
G__75252.cljs$lang$maxFixedArity = 0;
G__75252.cljs$lang$applyTo = (function (arglist__75254){
var conds = cljs.core.seq(arglist__75254);
return G__75252__delegate(conds);
});
G__75252.cljs$core$IFn$_invoke$arity$variadic = G__75252__delegate;
return G__75252;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__75255 = null;
var G__75255__0 = (function (){
return com.rpl.specter.STAY;
});
var G__75255__1 = (function (path){
return path;
});
var G__75255__2 = (function (path1,path2){
var builder__39931__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter75184 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter75184 = (function (path1,path2,late1,late2,meta75185){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta75185 = meta75185;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter75184.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_75186,meta75185__$1){
var self__ = this;
var _75186__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter75184(self__.path1,self__.path2,self__.late1,self__.late2,meta75185__$1));
}));

(com.rpl.specter.t_com$rpl$specter75184.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_75186){
var self__ = this;
var _75186__$1 = this;
return self__.meta75185;
}));

(com.rpl.specter.t_com$rpl$specter75184.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter75184.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter75184.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter75184.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta75185","meta75185",-1684420651,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter75184.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter75184.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter75184");

(com.rpl.specter.t_com$rpl$specter75184.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter75184");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter75184.
 */
com.rpl.specter.__GT_t_com$rpl$specter75184 = (function com$rpl$specter$__GT_t_com$rpl$specter75184(path1__$1,path2__$1,late1__$1,late2__$1,meta75185){
return (new com.rpl.specter.t_com$rpl$specter75184(path1__$1,path2__$1,late1__$1,late2__$1,meta75185));
});

}

return (new com.rpl.specter.t_com$rpl$specter75184(path1,path2,late1,late2,null));
}));
var curr_params__39932__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39932__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39931__auto__,curr_params__39932__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39931__auto__,curr_params__39932__auto__,null);
}
});
var G__75255__3 = (function() { 
var G__75256__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__75256 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__75257__i = 0, G__75257__a = new Array(arguments.length -  2);
while (G__75257__i < G__75257__a.length) {G__75257__a[G__75257__i] = arguments[G__75257__i + 2]; ++G__75257__i;}
  paths = new cljs.core.IndexedSeq(G__75257__a,0,null);
} 
return G__75256__delegate.call(this,path1,path2,paths);};
G__75256.cljs$lang$maxFixedArity = 2;
G__75256.cljs$lang$applyTo = (function (arglist__75258){
var path1 = cljs.core.first(arglist__75258);
arglist__75258 = cljs.core.next(arglist__75258);
var path2 = cljs.core.first(arglist__75258);
var paths = cljs.core.rest(arglist__75258);
return G__75256__delegate(path1,path2,paths);
});
G__75256.cljs$core$IFn$_invoke$arity$variadic = G__75256__delegate;
return G__75256;
})()
;
G__75255 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__75255__0.call(this);
case 1:
return G__75255__1.call(this,path1);
case 2:
return G__75255__2.call(this,path1,path2);
default:
var G__75259 = null;
if (arguments.length > 2) {
var G__75260__i = 0, G__75260__a = new Array(arguments.length -  2);
while (G__75260__i < G__75260__a.length) {G__75260__a[G__75260__i] = arguments[G__75260__i + 2]; ++G__75260__i;}
G__75259 = new cljs.core.IndexedSeq(G__75260__a,0,null);
}
return G__75255__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__75259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__75255.cljs$lang$maxFixedArity = 2;
G__75255.cljs$lang$applyTo = G__75255__3.cljs$lang$applyTo;
G__75255.cljs$core$IFn$_invoke$arity$0 = G__75255__0;
G__75255.cljs$core$IFn$_invoke$arity$1 = G__75255__1;
G__75255.cljs$core$IFn$_invoke$arity$2 = G__75255__2;
G__75255.cljs$core$IFn$_invoke$arity$variadic = G__75255__3.cljs$core$IFn$_invoke$arity$variadic;
return G__75255;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75261__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__75261 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75262__i = 0, G__75262__a = new Array(arguments.length -  0);
while (G__75262__i < G__75262__a.length) {G__75262__a[G__75262__i] = arguments[G__75262__i + 0]; ++G__75262__i;}
  path = new cljs.core.IndexedSeq(G__75262__a,0,null);
} 
return G__75261__delegate.call(this,path);};
G__75261.cljs$lang$maxFixedArity = 0;
G__75261.cljs$lang$applyTo = (function (arglist__75263){
var path = cljs.core.seq(arglist__75263);
return G__75261__delegate(path);
});
G__75261.cljs$core$IFn$_invoke$arity$variadic = G__75261__delegate;
return G__75261;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75264__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__75264 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75265__i = 0, G__75265__a = new Array(arguments.length -  0);
while (G__75265__i < G__75265__a.length) {G__75265__a[G__75265__i] = arguments[G__75265__i + 0]; ++G__75265__i;}
  path = new cljs.core.IndexedSeq(G__75265__a,0,null);
} 
return G__75264__delegate.call(this,path);};
G__75264.cljs$lang$maxFixedArity = 0;
G__75264.cljs$lang$applyTo = (function (arglist__75266){
var path = cljs.core.seq(arglist__75266);
return G__75264__delegate(path);
});
G__75264.cljs$core$IFn$_invoke$arity$variadic = G__75264__delegate;
return G__75264;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__39938__auto__ = com.rpl.specter.pathcache75191;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75192 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache75191 = info75192;

return info75192;
})():info__39938__auto__);
var precompiled75193 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75194 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled75193.cljs$core$IFn$_invoke$arity$1 ? precompiled75193.cljs$core$IFn$_invoke$arity$1(G__75194) : precompiled75193.call(null,G__75194));
} else {
return precompiled75193;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__39938__auto__ = com.rpl.specter.pathcache75195;
var info__39938__auto____$1 = (((info__39938__auto__ == null))?(function (){var info75196 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,689,691,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache75195 = info75196;

return info75196;
})():info__39938__auto__);
var precompiled75197 = com.rpl.specter.impl.cached_path_info_precompiled(info__39938__auto____$1);
var dynamic_QMARK___39939__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39938__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39939__auto__)){
var G__75198 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled75197.cljs$core$IFn$_invoke$arity$1 ? precompiled75197.cljs$core$IFn$_invoke$arity$1(G__75198) : precompiled75197.call(null,G__75198));
} else {
return precompiled75197;
}
})());

return p;
}));
var empty__GT_NONE_75267 = (function (){var G__75199 = cljs.core.empty_QMARK_;
var G__75200 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__75199,G__75200) : com.rpl.specter.if_path.call(null,G__75199,G__75200));
})();
var compact_STAR__75268 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_75267) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_75267));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75269__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__75268,path);
};
var G__75269 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75270__i = 0, G__75270__a = new Array(arguments.length -  0);
while (G__75270__i < G__75270__a.length) {G__75270__a[G__75270__i] = arguments[G__75270__i + 0]; ++G__75270__i;}
  path = new cljs.core.IndexedSeq(G__75270__a,0,null);
} 
return G__75269__delegate.call(this,path);};
G__75269.cljs$lang$maxFixedArity = 0;
G__75269.cljs$lang$applyTo = (function (arglist__75271){
var path = cljs.core.seq(arglist__75271);
return G__75269__delegate(path);
});
G__75269.cljs$core$IFn$_invoke$arity$variadic = G__75269__delegate;
return G__75269;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
