goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__66979 = (line + (1));
var G__66980 = (1);
var G__66981 = (counter + (1));
line = G__66979;
col = G__66980;
counter = G__66981;
continue;
} else {
var G__66984 = line;
var G__66985 = (col + (1));
var G__66986 = (counter + (1));
line = G__66984;
col = G__66985;
counter = G__66986;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__66987 = cljs.core.next(chars);
var G__66988 = (n__$1 - (1));
chars = G__66987;
n__$1 = G__66988;
continue;
} else {
var G__66989 = cljs.core.next(chars);
var G__66990 = n__$1;
chars = G__66989;
n__$1 = G__66990;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__66960){
var map__66961 = p__66960;
var map__66961__$1 = (((((!((map__66961 == null))))?(((((map__66961.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66961.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66961):map__66961);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66961__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66961__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66961__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66961__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__66963_66994 = cljs.core.seq(full_reasons);
var chunk__66964_66995 = null;
var count__66965_66996 = (0);
var i__66966_66997 = (0);
while(true){
if((i__66966_66997 < count__66965_66996)){
var r_66998 = chunk__66964_66995.cljs$core$IIndexed$_nth$arity$2(null,i__66966_66997);
instaparse.failure.print_reason(r_66998);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__66999 = seq__66963_66994;
var G__67000 = chunk__66964_66995;
var G__67001 = count__66965_66996;
var G__67002 = (i__66966_66997 + (1));
seq__66963_66994 = G__66999;
chunk__66964_66995 = G__67000;
count__66965_66996 = G__67001;
i__66966_66997 = G__67002;
continue;
} else {
var temp__5735__auto___67003 = cljs.core.seq(seq__66963_66994);
if(temp__5735__auto___67003){
var seq__66963_67004__$1 = temp__5735__auto___67003;
if(cljs.core.chunked_seq_QMARK_(seq__66963_67004__$1)){
var c__4550__auto___67005 = cljs.core.chunk_first(seq__66963_67004__$1);
var G__67006 = cljs.core.chunk_rest(seq__66963_67004__$1);
var G__67007 = c__4550__auto___67005;
var G__67008 = cljs.core.count(c__4550__auto___67005);
var G__67009 = (0);
seq__66963_66994 = G__67006;
chunk__66964_66995 = G__67007;
count__66965_66996 = G__67008;
i__66966_66997 = G__67009;
continue;
} else {
var r_67010 = cljs.core.first(seq__66963_67004__$1);
instaparse.failure.print_reason(r_67010);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__67011 = cljs.core.next(seq__66963_67004__$1);
var G__67012 = null;
var G__67013 = (0);
var G__67014 = (0);
seq__66963_66994 = G__67011;
chunk__66964_66995 = G__67012;
count__66965_66996 = G__67013;
i__66966_66997 = G__67014;
continue;
}
} else {
}
}
break;
}

var seq__66968 = cljs.core.seq(partial_reasons);
var chunk__66969 = null;
var count__66970 = (0);
var i__66971 = (0);
while(true){
if((i__66971 < count__66970)){
var r = chunk__66969.cljs$core$IIndexed$_nth$arity$2(null,i__66971);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__67015 = seq__66968;
var G__67016 = chunk__66969;
var G__67017 = count__66970;
var G__67018 = (i__66971 + (1));
seq__66968 = G__67015;
chunk__66969 = G__67016;
count__66970 = G__67017;
i__66971 = G__67018;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__66968);
if(temp__5735__auto__){
var seq__66968__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__66968__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__66968__$1);
var G__67019 = cljs.core.chunk_rest(seq__66968__$1);
var G__67020 = c__4550__auto__;
var G__67021 = cljs.core.count(c__4550__auto__);
var G__67022 = (0);
seq__66968 = G__67019;
chunk__66969 = G__67020;
count__66970 = G__67021;
i__66971 = G__67022;
continue;
} else {
var r = cljs.core.first(seq__66968__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__67023 = cljs.core.next(seq__66968__$1);
var G__67024 = null;
var G__67025 = (0);
var G__67026 = (0);
seq__66968 = G__67023;
chunk__66969 = G__67024;
count__66970 = G__67025;
i__66971 = G__67026;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=instaparse.failure.js.map
