goog.provide('pinkgorilla.notebook_ui.codemirror.editor');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('reagent.core');
goog.require('reagent.dom');
goog.require('re_frame.core');
var module$node_modules$codemirror$lib$codemirror=shadow.js.require("module$node_modules$codemirror$lib$codemirror", {});
var module$node_modules$codemirror$addon$edit$closebrackets=shadow.js.require("module$node_modules$codemirror$addon$edit$closebrackets", {});
var module$node_modules$codemirror$addon$edit$matchbrackets=shadow.js.require("module$node_modules$codemirror$addon$edit$matchbrackets", {});
var module$node_modules$codemirror$addon$hint$show_hint=shadow.js.require("module$node_modules$codemirror$addon$hint$show_hint", {});
var module$node_modules$codemirror$addon$runmode$runmode=shadow.js.require("module$node_modules$codemirror$addon$runmode$runmode", {});
var module$node_modules$codemirror$addon$runmode$colorize=shadow.js.require("module$node_modules$codemirror$addon$runmode$colorize", {});
var module$node_modules$codemirror$mode$clojure$clojure=shadow.js.require("module$node_modules$codemirror$mode$clojure$clojure", {});
var module$node_modules$codemirror$mode$markdown$markdown=shadow.js.require("module$node_modules$codemirror$mode$markdown$markdown", {});
goog.require('pinkgorilla.ui.config');
goog.require('pinkgorilla.notebook_ui.codemirror.theme');
goog.require('pinkgorilla.notebook_ui.codemirror.highlight');
goog.require('pinkgorilla.notebook_ui.codemirror.key_binding');
goog.require('pinkgorilla.notebook_ui.codemirror.options');
goog.require('pinkgorilla.notebook_ui.codemirror.extension');
goog.require('pinkgorilla.notebook_ui.codemirror.extensions');
pinkgorilla.notebook_ui.codemirror.editor.on_mousedown = (function pinkgorilla$notebook_ui$codemirror$editor$on_mousedown(cm,evt){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.notebook-ui.codemirror.editor","/tmp/form-init5480154391856654582.clj",33,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["on-mousedown"], null);
}),null)),null,612422908);
});
pinkgorilla.notebook_ui.codemirror.editor.focus_cm_BANG_ = (function pinkgorilla$notebook_ui$codemirror$editor$focus_cm_BANG_(cm){
if(cljs.core.truth_(cm)){
return cm.focus();
} else {
return null;
}
});
pinkgorilla.notebook_ui.codemirror.editor.destroy_editor = (function pinkgorilla$notebook_ui$codemirror$editor$destroy_editor(cm_a){
if(cljs.core.truth_(cljs.core.deref(cm_a))){
cljs.core.deref(cm_a).toTextArea();

return cljs.core.reset_BANG_(cm_a,null);
} else {
return console.warn("Could not kill CodeMirror instance");
}
});
/**
 * Create a code-mirror editor that knows a fair amount about being a good
 *   repl. The parameters:
 *   :style (reagent style map) will be applied to the container element
 */
pinkgorilla.notebook_ui.codemirror.editor.codemirror_reagent = (function pinkgorilla$notebook_ui$codemirror$editor$codemirror_reagent(buffer,cm_opts){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(buffer))], null),pinkgorilla.notebook_ui.codemirror.extensions.cm_fun,pinkgorilla.notebook_ui.codemirror.options.cm_default_opts,cm_opts], 0));
var buffer_a = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(buffer);
var cm = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var run = (function (handler){
return pinkgorilla.notebook_ui.codemirror.extension.run_extension(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"cm-opts","cm-opts",-794223420),opts,new cljs.core.Keyword(null,"cm","cm",540591536),cm,new cljs.core.Keyword(null,"buffer","buffer",617295198),cljs.core.deref(buffer_a)], null),handler);
});
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),(function (this$){
var el = reagent.dom.dom_node(this$);
var opts_js = cljs.core.clj__GT_js(opts);
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.editor","/tmp/form-init5480154391856654582.clj",67,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["creating cm for: ",el," opts: ",opts], null);
}),null)),null,296122096);
var cm_ = module$node_modules$codemirror$lib$codemirror.fromTextArea(el,opts_js);
cljs.core.reset_BANG_(cm,cm_);

cm_.setValue(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(buffer)));

cm_.on("change",(function (){
return run(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"save-code","save-code",-329313726)], null));
}));

cm_.on("keydown",cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook_ui.codemirror.key_binding.on_key_down,opts));

cm_.on("mousedown",pinkgorilla.notebook_ui.codemirror.editor.on_mousedown);

return cm_.setSize("100%","100%");
}),new cljs.core.Keyword(null,"component-will-unmount","component-will-unmount",-2058314698),(function (this$){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.editor","/tmp/form-init5480154391856654582.clj",84,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cm component-will-unmount"], null);
}),null)),null,805013044);

return pinkgorilla.notebook_ui.codemirror.editor.destroy_editor(cm);
}),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),(function (this$,old_argv){
var vec__75463 = reagent.core.argv(this$);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75463,(0),null);
var buffer__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75463,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75463,(2),null);
cljs.core.reset_BANG_(buffer_a,buffer__$1);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.editor","/tmp/form-init5480154391856654582.clj",91,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["current buffer: ",new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(buffer__$1))], null);
}),null)),null,100680174);

return run(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"load-code","load-code",-2141491586)], null));
}),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824)], null);
})], null));
});
pinkgorilla.notebook_ui.codemirror.editor.code_mirror = (function pinkgorilla$notebook_ui$codemirror$editor$code_mirror(buffer_id,options){
var buffer = (function (){var G__75466 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("buffer","view","buffer/view",1627879294),buffer_id], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__75466) : re_frame.core.subscribe.call(null,G__75466));
})();
return (function (buffer_id__$1,options__$1){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.w-full.h-full.bg-red-200","div.w-full.h-full.bg-red-200",1175842994),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.config.link_css,"codemirror/lib/codemirror.css"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.notebook_ui.codemirror.editor.codemirror_reagent,buffer,options__$1], null)], null);
});
});

//# sourceMappingURL=pinkgorilla.notebook_ui.codemirror.editor.js.map
