goog.provide('pinkgorilla.notebook_ui.codemirror.extension.completion');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('re_frame.core');
goog.require('cljs.reader');
goog.require('reagent.core');
goog.require('cljs.tools.reader');
pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars = "[^\\s\\(\\)\\[\\]\\{\\},`']*";
pinkgorilla.notebook_ui.codemirror.extension.completion.word_in_line = (function pinkgorilla$notebook_ui$codemirror$extension$completion$word_in_line(line,lno,cno){
var back = cljs.core.get.cljs$core$IFn$_invoke$arity$2(line.slice((0),cno).match((new RegExp([pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars,"$"].join('')))),(0));
var forward = cljs.core.get.cljs$core$IFn$_invoke$arity$2(line.slice(cno).match((new RegExp(["^",pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars].join('')))),(0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),({"line": lno, "ch": (cno - cljs.core.count(back))}),new cljs.core.Keyword(null,"end","end",-268185958),({"line": lno, "ch": (cno + cljs.core.count(forward))})], null);
});
pinkgorilla.notebook_ui.codemirror.extension.completion.cm_get_range = (function pinkgorilla$notebook_ui$codemirror$extension$completion$cm_get_range(cm,range){
return cm.getRange(new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(range),new cljs.core.Keyword(null,"end","end",-268185958).cljs$core$IFn$_invoke$arity$1(range));
});
/**
 * Find the current 'word' according to CodeMirror's `wordChars' list
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.cm_current_word = (function pinkgorilla$notebook_ui$codemirror$extension$completion$cm_current_word(cm){
var pos = cm.getCursor();
var line_no = pos.line;
var column_no = pos.ch;
var line_range = cm.getLine(column_no,line_no);
if(cljs.core.truth_(line_range)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5480154391856654582.clj",92,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-range: ",line_range], null);
}),null)),null,1215861569);

return pinkgorilla.notebook_ui.codemirror.extension.completion.cm_get_range(cm,pinkgorilla.notebook_ui.codemirror.extension.completion.word_in_line(line_range,line_no,column_no));
} else {
return null;
}
});
pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates = (function pinkgorilla$notebook_ui$codemirror$extension$completion$get_completion_candidates(cm){
var word = pinkgorilla.notebook_ui.codemirror.extension.completion.cm_current_word(cm);
if(cljs.core.empty_QMARK_(word)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5480154391856654582.clj",99,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["no current word - cannot get hint!"], null);
}),null)),null,-1878544438);
} else {
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5480154391856654582.clj",101,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["getting code-completion for word: ",word], null);
}),null)),null,-785579019);

var G__75448_75460 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","hint","completion/hint",-1183694070),word,"user",""], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__75448_75460) : re_frame.core.dispatch.call(null,G__75448_75460));

return true;
}
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint(p__75449){
var map__75450 = p__75449;
var map__75450__$1 = (((((!((map__75450 == null))))?(((((map__75450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75450.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75450):map__75450);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75450__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75450__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5480154391856654582.clj",108,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-get .. "], null);
}),null)),null,-344710396);

if(cljs.core.truth_(cm)){
pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates(cm);
} else {
}

return e.preventDefault();
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint_prior = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint_prior(p__75452){
var map__75453 = p__75452;
var map__75453__$1 = (((((!((map__75453 == null))))?(((((map__75453.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75453.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75453):map__75453);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75453__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75453__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5480154391856654582.clj",116,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-prior .. "], null);
}),null)),null,-1699586177);

var G__75455_75461 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","prior","completion/prior",-481875588)], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__75455_75461) : re_frame.core.dispatch.call(null,G__75455_75461));

return e.preventDefault();
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint_next = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint_next(p__75456){
var map__75457 = p__75456;
var map__75457__$1 = (((((!((map__75457 == null))))?(((((map__75457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75457.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75457):map__75457);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75457__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75457__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5480154391856654582.clj",123,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-next .. "], null);
}),null)),null,547410898);

pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates(cm);

var G__75459_75462 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","next","completion/next",1497262191)], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__75459_75462) : re_frame.core.dispatch.call(null,G__75459_75462));

return e.preventDefault();
});

//# sourceMappingURL=pinkgorilla.notebook_ui.codemirror.extension.completion.js.map
