goog.provide('pinkgorilla.nrepl.op.cider');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('pinkgorilla.nrepl.ws.client');
/**
 * Query the REPL server for autocompletion suggestions. 
 * Relies on the cider-nrepl middleware.
 */
pinkgorilla.nrepl.op.cider.completions = (function pinkgorilla$nrepl$op$cider$completions(conn,symbol,ns,context){
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns,new cljs.core.Keyword(null,"context","context",-830191113),context], null),(function (fragments){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"candidates","candidates",1964038664),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"completions","completions",-190930179),fragments)))], null);
}));
});
/**
 * Queries the REPL server for docs for the given symbol. 
 * Relies on the cider-nrepl middleware.
 */
pinkgorilla.nrepl.op.cider.doc_string = (function pinkgorilla$nrepl$op$cider$doc_string(conn,symbol,ns){
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"complete-doc",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (fragments){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"docstring","docstring",879233117),new cljs.core.Keyword(null,"completion-doc","completion-doc",792734283).cljs$core$IFn$_invoke$arity$1(cljs.core.first(fragments))], null);
}));
});
/**
 * resolve a symbol to get its namespace takes the symbol and the namespace 
 * that should be used as context.
 * Relies on the cider-nrepl middleware. 
 * Returns:
 * - the symbol and the symbol's namespace
 */
pinkgorilla.nrepl.op.cider.resolve_symbol = (function pinkgorilla$nrepl$op$cider$resolve_symbol(conn,symbol,ns){
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"info",new cljs.core.Keyword(null,"symbol","symbol",-1038572696),symbol,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null),(function (fragments){
var last_status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(cljs.core.last(fragments));
var no_info_QMARK_ = cljs.core.contains_QMARK_(last_status,new cljs.core.Keyword(null,"no-info","no-info",1834151693));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"resolve","resolve",-1584445482),((no_info_QMARK_)?new cljs.core.Keyword(null,"no-info","no-info",1834151693):cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__76419_SHARP_){
return cljs.core.select_keys(p1__76419_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"ns","ns",441598760)], null));
}),fragments))], null);
}));
});
/**
 * resolve a symbol to get its namespace takes the symbol and the namespace that should be used as context.
 *   Relies on the cider-nrepl middleware. Calls back with the symbol and the symbol's namespace
 */
pinkgorilla.nrepl.op.cider.stacktrace = (function pinkgorilla$nrepl$op$cider$stacktrace(conn){
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op","op",-1882987955),"stacktrace"], null),(function (fragments){
var stacktraces = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),fragments));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,stacktraces);
}));
});

//# sourceMappingURL=pinkgorilla.nrepl.op.cider.js.map
