goog.provide('pinkgorilla.nrepl.op.eval');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('reagent.core');
goog.require('pinkgorilla.nrepl.ws.client');
/**
 * converts (:value message)
 * nrepl has to serialize the value before it hits clojure.
 * So this value gets formatted with edn.
 * Since the message is packaged as edn too, we have edn within edn.
 * 
 */
pinkgorilla.nrepl.op.eval.parse_value = (function pinkgorilla$nrepl$op$eval$parse_value(value){
try{var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.op.eval","/tmp/form-init5480154391856654582.clj",19,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["value: ",value], null);
}),null)),null,765827233);
var data = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.op.eval","/tmp/form-init5480154391856654582.clj",21,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["converted: ",data], null);
}),null)),null,1163171058);
return data;
}catch (e76476){if((e76476 instanceof Error)){
var e = e76476;
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.nrepl.op.eval","/tmp/form-init5480154391856654582.clj",27,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["parse-value ex: ",e," tried to parse: ",value], null);
}),null)),null,1457685830);
} else {
throw e76476;

}
}});
/**
 * result is an atom, containing the eval result.
 * processes a fragment-response and modifies result-atom accordingly.
 */
pinkgorilla.nrepl.op.eval.on_eval_fragment = (function pinkgorilla$nrepl$op$eval$on_eval_fragment(result,p__76477){
var map__76478 = p__76477;
var map__76478__$1 = (((((!((map__76478 == null))))?(((((map__76478.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76478.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__76478):map__76478);
var message = map__76478__$1;
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76478__$1,new cljs.core.Keyword(null,"out","out",-910545517));
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76478__$1,new cljs.core.Keyword(null,"err","err",-2089457205));
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76478__$1,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76478__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76478__$1,new cljs.core.Keyword(null,"value","value",305978217));
var picasso__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76478__$1,new cljs.core.Keyword(null,"picasso","picasso",-1388478491));
var datafy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76478__$1,new cljs.core.Keyword(null,"datafy","datafy",863837122));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76478__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
if(cljs.core.truth_(out)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"out","out",-910545517),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"out","out",-910545517).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(out)].join(''));
} else {
}

if(cljs.core.truth_(err)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"err","err",-2089457205),err);
} else {
}

if(cljs.core.truth_(datafy)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"datafy","datafy",863837122),datafy);
} else {
}

if(cljs.core.truth_(ns)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"ns","ns",441598760),ns);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"value","value",305978217),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result)),value));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"picasso","picasso",-1388478491),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"picasso","picasso",-1388478491).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result)),pinkgorilla.nrepl.op.eval.parse_value(picasso__$1)));
} else {
}

if(cljs.core.truth_(root_ex)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778),root_ex);
} else {
return null;
}
});
/**
 * evaluates a clj-snippet
 */
pinkgorilla.nrepl.op.eval.nrepl_eval = (function pinkgorilla$nrepl$op$eval$nrepl_eval(conn,code){
var result = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"picasso","picasso",-1388478491),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"ns","ns",441598760),null,new cljs.core.Keyword(null,"out","out",-910545517),"",new cljs.core.Keyword(null,"err","err",-2089457205),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778),null], null));
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),code], null),(function (fragments){
var seq__76480_76498 = cljs.core.seq(fragments);
var chunk__76481_76499 = null;
var count__76482_76500 = (0);
var i__76483_76501 = (0);
while(true){
if((i__76483_76501 < count__76482_76500)){
var f_76502 = chunk__76481_76499.cljs$core$IIndexed$_nth$arity$2(null,i__76483_76501);
pinkgorilla.nrepl.op.eval.on_eval_fragment(result,f_76502);


var G__76503 = seq__76480_76498;
var G__76504 = chunk__76481_76499;
var G__76505 = count__76482_76500;
var G__76506 = (i__76483_76501 + (1));
seq__76480_76498 = G__76503;
chunk__76481_76499 = G__76504;
count__76482_76500 = G__76505;
i__76483_76501 = G__76506;
continue;
} else {
var temp__5735__auto___76507 = cljs.core.seq(seq__76480_76498);
if(temp__5735__auto___76507){
var seq__76480_76508__$1 = temp__5735__auto___76507;
if(cljs.core.chunked_seq_QMARK_(seq__76480_76508__$1)){
var c__4550__auto___76509 = cljs.core.chunk_first(seq__76480_76508__$1);
var G__76510 = cljs.core.chunk_rest(seq__76480_76508__$1);
var G__76511 = c__4550__auto___76509;
var G__76512 = cljs.core.count(c__4550__auto___76509);
var G__76513 = (0);
seq__76480_76498 = G__76510;
chunk__76481_76499 = G__76511;
count__76482_76500 = G__76512;
i__76483_76501 = G__76513;
continue;
} else {
var f_76514 = cljs.core.first(seq__76480_76508__$1);
pinkgorilla.nrepl.op.eval.on_eval_fragment(result,f_76514);


var G__76515 = cljs.core.next(seq__76480_76508__$1);
var G__76516 = null;
var G__76517 = (0);
var G__76518 = (0);
seq__76480_76498 = G__76515;
chunk__76481_76499 = G__76516;
count__76482_76500 = G__76517;
i__76483_76501 = G__76518;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(result);
}));
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.nrepl_eval', pinkgorilla.nrepl.op.eval.nrepl_eval);
/**
 * evaluates a clojure expression
 * returns result via callback
 * 
 * execute this in browser console:
 * pinkgorilla.kernel.nrepl.clj_eval_cb ("(+ 7 9 )", 
 *  (function (r) {console.log ("result!!: " +r);}))
 * 
 */
pinkgorilla.nrepl.op.eval.nrepl_eval_cb = (function pinkgorilla$nrepl$op$eval$nrepl_eval_cb(conn,snippet,cb){
var ch = pinkgorilla.nrepl.op.eval.nrepl_eval(conn,snippet);
var c__71138__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_76488){
var state_val_76489 = (state_76488[(1)]);
if((state_val_76489 === (1))){
var state_76488__$1 = state_76488;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76488__$1,(2),ch);
} else {
if((state_val_76489 === (2))){
var inst_76485 = (state_76488[(2)]);
var inst_76486 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_76485) : cb.call(null,inst_76485));
var state_76488__$1 = state_76488;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76488__$1,inst_76486);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto__ = null;
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto____0 = (function (){
var statearr_76490 = [null,null,null,null,null,null,null];
(statearr_76490[(0)] = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto__);

(statearr_76490[(1)] = (1));

return statearr_76490;
});
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto____1 = (function (state_76488){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_76488);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e76491){var ex__71106__auto__ = e76491;
var statearr_76492_76519 = state_76488;
(statearr_76492_76519[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_76488[(4)]))){
var statearr_76493_76520 = state_76488;
(statearr_76493_76520[(1)] = cljs.core.first((state_76488[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76521 = state_76488;
state_76488 = G__76521;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto__ = function(state_76488){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto____1.call(this,state_76488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto____0;
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto____1;
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_76494 = f__71139__auto__();
(statearr_76494[(6)] = c__71138__auto__);

return statearr_76494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));

return c__71138__auto__;
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.nrepl_eval_cb', pinkgorilla.nrepl.op.eval.nrepl_eval_cb);
/**
 * executes a clojure ```function-as-string``` (from clojurescript) 
 */
pinkgorilla.nrepl.op.eval.fn_eval = (function pinkgorilla$nrepl$op$eval$fn_eval(var_args){
var args__4736__auto__ = [];
var len__4730__auto___76523 = arguments.length;
var i__4731__auto___76524 = (0);
while(true){
if((i__4731__auto___76524 < len__4730__auto___76523)){
args__4736__auto__.push((arguments[i__4731__auto___76524]));

var G__76528 = (i__4731__auto___76524 + (1));
i__4731__auto___76524 = G__76528;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return pinkgorilla.nrepl.op.eval.fn_eval.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.fn_eval', pinkgorilla.nrepl.op.eval.fn_eval);

(pinkgorilla.nrepl.op.eval.fn_eval.cljs$core$IFn$_invoke$arity$variadic = (function (conn,function_as_string,params){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.nrepl.op.eval","/tmp/form-init5480154391856654582.clj",82,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["params: ",params], null);
}),null)),null,-1384707520);
var code = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
return pinkgorilla.nrepl.op.eval.nrepl_eval(conn,code);
}));

(pinkgorilla.nrepl.op.eval.fn_eval.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.nrepl.op.eval.fn_eval.cljs$lang$applyTo = (function (seq76495){
var G__76496 = cljs.core.first(seq76495);
var seq76495__$1 = cljs.core.next(seq76495);
var G__76497 = cljs.core.first(seq76495__$1);
var seq76495__$2 = cljs.core.next(seq76495__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__76496,G__76497,seq76495__$2);
}));


//# sourceMappingURL=pinkgorilla.nrepl.op.eval.js.map
