goog.provide('pinkgorilla.nrepl.ws.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('reagent.core');
goog.require('pinkgorilla.nrepl.ws.connection');
/**
 * make-request 
 * - sends `message` to websocket (so nrepl/cider can process the request)
 * - returns the eval id.
 * parameter:
 * - state: this gets returned by (ws-start!)
 * - message: a nrepl message (with or without request-id)
 * - callback: optional callback that return all fragments of a request
 * returns:
 * - cannel with response fragments
 */
pinkgorilla.nrepl.ws.client.nrepl_op = (function pinkgorilla$nrepl$ws$client$nrepl_op(conn,message){
var request_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var map__76214 = conn;
var map__76214__$1 = (((((!((map__76214 == null))))?(((((map__76214.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76214.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__76214):map__76214);
var requests = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76214__$1,new cljs.core.Keyword(null,"requests","requests",-733055638));
var input_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76214__$1,new cljs.core.Keyword(null,"input-ch","input-ch",-1864212482));
var request_id = (function (){var or__4120__auto__ = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(message);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
}
})();
var nrepl_msg = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),request_id], null)], 0));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(requests,cljs.core.assoc,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(request_id),request_ch);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init5480154391856654582.clj",52,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ws sending ws message: ",nrepl_msg], null);
}),null)),null,-950038368);

var c__71138__auto___76376 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_76221){
var state_val_76222 = (state_76221[(1)]);
if((state_val_76222 === (1))){
var state_76221__$1 = state_76221;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_76221__$1,(2),input_ch,nrepl_msg);
} else {
if((state_val_76222 === (2))){
var inst_76219 = (state_76221[(2)]);
var state_76221__$1 = state_76221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76221__$1,inst_76219);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto__ = null;
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto____0 = (function (){
var statearr_76227 = [null,null,null,null,null,null,null];
(statearr_76227[(0)] = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto__);

(statearr_76227[(1)] = (1));

return statearr_76227;
});
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto____1 = (function (state_76221){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_76221);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e76228){var ex__71106__auto__ = e76228;
var statearr_76230_76380 = state_76221;
(statearr_76230_76380[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_76221[(4)]))){
var statearr_76231_76381 = state_76221;
(statearr_76231_76381[(1)] = cljs.core.first((state_76221[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76383 = state_76221;
state_76221 = G__76383;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto__ = function(state_76221){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto____1.call(this,state_76221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto____0;
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto____1;
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_76233 = f__71139__auto__();
(statearr_76233[(6)] = c__71138__auto___76376);

return statearr_76233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return request_ch;
});
pinkgorilla.nrepl.ws.client.nrepl_op_complete = (function pinkgorilla$nrepl$ws$client$nrepl_op_complete(var_args){
var G__76237 = arguments.length;
switch (G__76237) {
case 2:
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$2 = (function (conn,msg){
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,msg,null);
}));

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3 = (function (conn,msg,transform_fn){
var result_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var fragments = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
var fragments_ch = pinkgorilla.nrepl.ws.client.nrepl_op(conn,msg);
var result_fn = (function (){
if(cljs.core.truth_(transform_fn)){
var G__76243 = cljs.core.deref(fragments);
return (transform_fn.cljs$core$IFn$_invoke$arity$1 ? transform_fn.cljs$core$IFn$_invoke$arity$1(G__76243) : transform_fn.call(null,G__76243));
} else {
return cljs.core.deref(fragments);
}
});
var c__71138__auto___76390 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_76267){
var state_val_76268 = (state_76267[(1)]);
if((state_val_76268 === (7))){
var inst_76263 = (state_76267[(2)]);
var state_76267__$1 = state_76267;
var statearr_76271_76393 = state_76267__$1;
(statearr_76271_76393[(2)] = inst_76263);

(statearr_76271_76393[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76268 === (1))){
var state_76267__$1 = state_76267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76267__$1,(2),fragments_ch);
} else {
if((state_val_76268 === (4))){
var inst_76265 = (state_76267[(2)]);
var state_76267__$1 = state_76267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76267__$1,inst_76265);
} else {
if((state_val_76268 === (6))){
var inst_76258 = result_fn();
var state_76267__$1 = state_76267;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_76267__$1,(9),result_ch,inst_76258);
} else {
if((state_val_76268 === (3))){
var inst_76248 = (state_76267[(7)]);
var state_76267__$1 = state_76267;
if(cljs.core.truth_(inst_76248)){
var statearr_76276_76397 = state_76267__$1;
(statearr_76276_76397[(1)] = (5));

} else {
var statearr_76278_76398 = state_76267__$1;
(statearr_76278_76398[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76268 === (2))){
var inst_76247 = (state_76267[(2)]);
var inst_76248 = inst_76247;
var state_76267__$1 = (function (){var statearr_76280 = state_76267;
(statearr_76280[(7)] = inst_76248);

return statearr_76280;
})();
var statearr_76281_76399 = state_76267__$1;
(statearr_76281_76399[(2)] = null);

(statearr_76281_76399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76268 === (9))){
var inst_76260 = (state_76267[(2)]);
var inst_76261 = cljs.core.async.close_BANG_(fragments_ch);
var state_76267__$1 = (function (){var statearr_76282 = state_76267;
(statearr_76282[(8)] = inst_76260);

return statearr_76282;
})();
var statearr_76283_76400 = state_76267__$1;
(statearr_76283_76400[(2)] = inst_76261);

(statearr_76283_76400[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76268 === (5))){
var inst_76248 = (state_76267[(7)]);
var inst_76253 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fragments,cljs.core.conj,inst_76248);
var state_76267__$1 = (function (){var statearr_76286 = state_76267;
(statearr_76286[(9)] = inst_76253);

return statearr_76286;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76267__$1,(8),fragments_ch);
} else {
if((state_val_76268 === (8))){
var inst_76255 = (state_76267[(2)]);
var inst_76248 = inst_76255;
var state_76267__$1 = (function (){var statearr_76288 = state_76267;
(statearr_76288[(7)] = inst_76248);

return statearr_76288;
})();
var statearr_76289_76401 = state_76267__$1;
(statearr_76289_76401[(2)] = null);

(statearr_76289_76401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$state_machine__71103__auto__ = null;
var pinkgorilla$nrepl$ws$client$state_machine__71103__auto____0 = (function (){
var statearr_76290 = [null,null,null,null,null,null,null,null,null,null];
(statearr_76290[(0)] = pinkgorilla$nrepl$ws$client$state_machine__71103__auto__);

(statearr_76290[(1)] = (1));

return statearr_76290;
});
var pinkgorilla$nrepl$ws$client$state_machine__71103__auto____1 = (function (state_76267){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_76267);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e76291){var ex__71106__auto__ = e76291;
var statearr_76292_76402 = state_76267;
(statearr_76292_76402[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_76267[(4)]))){
var statearr_76294_76403 = state_76267;
(statearr_76294_76403[(1)] = cljs.core.first((state_76267[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76404 = state_76267;
state_76267 = G__76404;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$state_machine__71103__auto__ = function(state_76267){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$state_machine__71103__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$state_machine__71103__auto____1.call(this,state_76267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$state_machine__71103__auto____0;
pinkgorilla$nrepl$ws$client$state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$state_machine__71103__auto____1;
return pinkgorilla$nrepl$ws$client$state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_76296 = f__71139__auto__();
(statearr_76296[(6)] = c__71138__auto___76390);

return statearr_76296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return result_ch;
}));

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$lang$maxFixedArity = 3);

/**
 * processes an incoming message that comes from channel (which comes 
 * via websocket via websocket-relay from nrepl)
 * Returns the corresponding request chan.
 */
pinkgorilla.nrepl.ws.client.chan_for_incoming_nrepl_msg = (function pinkgorilla$nrepl$ws$client$chan_for_incoming_nrepl_msg(requests,message){
var map__76300 = message;
var map__76300__$1 = (((((!((map__76300 == null))))?(((((map__76300.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76300.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__76300):map__76300);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76300__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76300__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var request_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(id);
var request_ch = (function (){var G__76303 = cljs.core.deref(requests);
return (request_id.cljs$core$IFn$_invoke$arity$1 ? request_id.cljs$core$IFn$_invoke$arity$1(G__76303) : request_id.call(null,G__76303));
})();
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init5480154391856654582.clj",85,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s fragment rcvd.",request_id], null);
}),null)),null,-1636810535);

if(cljs.core.truth_(request_ch)){
if(cljs.core.contains_QMARK_(status,new cljs.core.Keyword(null,"done","done",-889844188))){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init5480154391856654582.clj",89,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s request done.",request_id], null);
}),null)),null,-1133561546);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(requests,cljs.core.dissoc,request_id);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_ch,true], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_ch,false], null);
}
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,false], null);
}
});
pinkgorilla.nrepl.ws.client.dump_msg = (function pinkgorilla$nrepl$ws$client$dump_msg(msg){
var request_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(msg);
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"pinkgorilla.nrepl.ws.client","/tmp/form-init5480154391856654582.clj",97,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s dumping response. No associated request found: %s",request_id,msg], null);
}),null)),null,-1355954841);
});
/**
 * creates a nrepl connection via websocket
 * Intended to be used with nrepl-op
 */
pinkgorilla.nrepl.ws.client.nrepl_client_BANG_ = (function pinkgorilla$nrepl$ws$client$nrepl_client_BANG_(ws_url){
var conn = pinkgorilla.nrepl.ws.connection.ws_connect_BANG_(ws_url);
var requests = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var output_ch = new cljs.core.Keyword(null,"output-ch","output-ch",1069791231).cljs$core$IFn$_invoke$arity$1(conn);
var c__71138__auto___76405 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__71139__auto__ = (function (){var switch__71102__auto__ = (function (state_76336){
var state_val_76337 = (state_76336[(1)]);
if((state_val_76337 === (7))){
var inst_76330 = (state_76336[(2)]);
var state_76336__$1 = (function (){var statearr_76341 = state_76336;
(statearr_76341[(7)] = inst_76330);

return statearr_76341;
})();
var statearr_76342_76406 = state_76336__$1;
(statearr_76342_76406[(2)] = null);

(statearr_76342_76406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76337 === (1))){
var state_76336__$1 = state_76336;
var statearr_76344_76407 = state_76336__$1;
(statearr_76344_76407[(2)] = null);

(statearr_76344_76407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76337 === (4))){
var inst_76312 = (state_76336[(8)]);
var inst_76313 = (state_76336[(9)]);
var inst_76311 = (state_76336[(10)]);
var inst_76311__$1 = (state_76336[(2)]);
var inst_76312__$1 = pinkgorilla.nrepl.ws.client.chan_for_incoming_nrepl_msg(requests,inst_76311__$1);
var inst_76313__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76312__$1,(0),null);
var inst_76314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76312__$1,(1),null);
var state_76336__$1 = (function (){var statearr_76345 = state_76336;
(statearr_76345[(8)] = inst_76312__$1);

(statearr_76345[(9)] = inst_76313__$1);

(statearr_76345[(11)] = inst_76314);

(statearr_76345[(10)] = inst_76311__$1);

return statearr_76345;
})();
if(cljs.core.truth_(inst_76313__$1)){
var statearr_76347_76408 = state_76336__$1;
(statearr_76347_76408[(1)] = (5));

} else {
var statearr_76349_76409 = state_76336__$1;
(statearr_76349_76409[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76337 === (6))){
var inst_76311 = (state_76336[(10)]);
var inst_76328 = pinkgorilla.nrepl.ws.client.dump_msg(inst_76311);
var state_76336__$1 = state_76336;
var statearr_76351_76410 = state_76336__$1;
(statearr_76351_76410[(2)] = inst_76328);

(statearr_76351_76410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76337 === (3))){
var inst_76333 = (state_76336[(2)]);
var state_76336__$1 = state_76336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76336__$1,inst_76333);
} else {
if((state_val_76337 === (2))){
var state_76336__$1 = state_76336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76336__$1,(4),output_ch);
} else {
if((state_val_76337 === (11))){
var inst_76325 = (state_76336[(2)]);
var state_76336__$1 = state_76336;
var statearr_76353_76411 = state_76336__$1;
(statearr_76353_76411[(2)] = inst_76325);

(statearr_76353_76411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76337 === (9))){
var inst_76312 = (state_76336[(8)]);
var inst_76313 = (state_76336[(9)]);
var inst_76314 = (state_76336[(11)]);
var inst_76311 = (state_76336[(10)]);
var inst_76319 = (function (){var msg = inst_76311;
var vec__76307 = inst_76312;
var req_ch = inst_76313;
var done_QMARK_ = inst_76314;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s closing channel.",new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(msg)], null);
});
})();
var inst_76320 = (new cljs.core.Delay(inst_76319,null));
var inst_76321 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init5480154391856654582.clj",113,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_76320,null,-31799642);
var inst_76322 = cljs.core.async.close_BANG_(inst_76313);
var state_76336__$1 = (function (){var statearr_76357 = state_76336;
(statearr_76357[(12)] = inst_76321);

return statearr_76357;
})();
var statearr_76358_76412 = state_76336__$1;
(statearr_76358_76412[(2)] = inst_76322);

(statearr_76358_76412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76337 === (5))){
var inst_76313 = (state_76336[(9)]);
var inst_76311 = (state_76336[(10)]);
var state_76336__$1 = state_76336;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_76336__$1,(8),inst_76313,inst_76311);
} else {
if((state_val_76337 === (10))){
var state_76336__$1 = state_76336;
var statearr_76360_76413 = state_76336__$1;
(statearr_76360_76413[(2)] = null);

(statearr_76360_76413[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76337 === (8))){
var inst_76314 = (state_76336[(11)]);
var inst_76317 = (state_76336[(2)]);
var state_76336__$1 = (function (){var statearr_76362 = state_76336;
(statearr_76362[(13)] = inst_76317);

return statearr_76362;
})();
if(cljs.core.truth_(inst_76314)){
var statearr_76363_76414 = state_76336__$1;
(statearr_76363_76414[(1)] = (9));

} else {
var statearr_76364_76415 = state_76336__$1;
(statearr_76364_76415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto__ = null;
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto____0 = (function (){
var statearr_76367 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76367[(0)] = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto__);

(statearr_76367[(1)] = (1));

return statearr_76367;
});
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto____1 = (function (state_76336){
while(true){
var ret_value__71104__auto__ = (function (){try{while(true){
var result__71105__auto__ = switch__71102__auto__(state_76336);
if(cljs.core.keyword_identical_QMARK_(result__71105__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__71105__auto__;
}
break;
}
}catch (e76368){var ex__71106__auto__ = e76368;
var statearr_76369_76416 = state_76336;
(statearr_76369_76416[(2)] = ex__71106__auto__);


if(cljs.core.seq((state_76336[(4)]))){
var statearr_76370_76417 = state_76336;
(statearr_76370_76417[(1)] = cljs.core.first((state_76336[(4)])));

} else {
throw ex__71106__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__71104__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76418 = state_76336;
state_76336 = G__76418;
continue;
} else {
return ret_value__71104__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto__ = function(state_76336){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto____1.call(this,state_76336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto____0;
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto____1;
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__71103__auto__;
})()
})();
var state__71140__auto__ = (function (){var statearr_76371 = f__71139__auto__();
(statearr_76371[(6)] = c__71138__auto___76405);

return statearr_76371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__71140__auto__);
}));


return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"requests","requests",-733055638),requests);
});

//# sourceMappingURL=pinkgorilla.nrepl.ws.client.js.map
