goog.provide('pinkgorilla.ui.control.select');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('pinkgorilla.ui.control.button');
goog.require('pinkie.pinkie');
pinkgorilla.ui.control.select.css = (function pinkgorilla$ui$control$select$css(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"style","style",-496642736),".top-100 {top: 100%}\n           .bottom-100 {bottom: 100%}\n           .max-h-select {\n              max-height: 300px;\n           }\n          "], null);
});
pinkgorilla.ui.control.select.select_item = (function pinkgorilla$ui$control$select$select_item(text,selected_QMARK_,position,select){
var s = (cljs.core.truth_(selected_QMARK_)?"border-teal-600":null);
var p = (function (){var G__66681 = position;
var G__66681__$1 = (((G__66681 instanceof cljs.core.Keyword))?G__66681.fqn:null);
switch (G__66681__$1) {
case "first":
return "rounded-t";

break;
case "last":
return "rounded-b";

break;
default:
return "";

}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),["cursor-pointer w-full border-gray-100 border-b hover:bg-teal-100 ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return (select.cljs$core$IFn$_invoke$arity$1 ? select.cljs$core$IFn$_invoke$arity$1(text) : select.call(null,text));
}),new cljs.core.Keyword(null,"class","class",-2030961996),["flex w-full items-center p-2 pl-2 border-transparent bg-white border-l-2 relative hover:bg-teal-600 hover:text-teal-100 ",s].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"w-full items-center flex"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"mx-2 leading-6"], null),text], null)], null)], null)], null);
});
pinkgorilla.ui.control.select.button_remove_selection = (function pinkgorilla$ui$control$select$button_remove_selection(h){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"cursor-pointer w-6 h-full flex items-center text-gray-400 outline-none focus:outline-none",new cljs.core.Keyword(null,"on-click","on-click",1632826543),h], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"stroke","stroke",1741823555),new cljs.core.Keyword(null,"fill","fill",883462889),new cljs.core.Keyword(null,"stroke-linejoin","stroke-linejoin",-1810816406),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"xmlns","xmlns",-1862095571),new cljs.core.Keyword(null,"stroke-linecap","stroke-linecap",-1201103248),new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"viewBox","viewBox",-469489477),new cljs.core.Keyword(null,"height","height",1025178622)],["currentColor","none","round","100%","http://www.w3.org/2000/svg","round","2","feather feather-x w-4 h-4","0 0 24 24","100%"]),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"x1","x1",-1863922247),"18",new cljs.core.Keyword(null,"y1","y1",589123466),"6",new cljs.core.Keyword(null,"x2","x2",-1362513475),"6",new cljs.core.Keyword(null,"y2","y2",-718691301),"18"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"x1","x1",-1863922247),"6",new cljs.core.Keyword(null,"y1","y1",589123466),"6",new cljs.core.Keyword(null,"x2","x2",-1362513475),"18",new cljs.core.Keyword(null,"y2","y2",-718691301),"18"], null)], null)], null)], null)], null);
});
pinkgorilla.ui.control.select.button_dropdown = (function pinkgorilla$ui$control$select$button_dropdown(dropdown_QMARK_,h){
var points = (cljs.core.truth_(dropdown_QMARK_)?"18 15 12 9 6 15":"18 9  12 15 6 9");
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"text-gray-300 w-8 py-1 pl-2 pr-1 border-l flex items-center border-gray-200 svelte-1l8159u"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"cursor-pointer w-6 h-6 text-gray-600 outline-none focus:outline-none",new cljs.core.Keyword(null,"on-click","on-click",1632826543),h], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"stroke","stroke",1741823555),new cljs.core.Keyword(null,"fill","fill",883462889),new cljs.core.Keyword(null,"stroke-linejoin","stroke-linejoin",-1810816406),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"xmlns","xmlns",-1862095571),new cljs.core.Keyword(null,"stroke-linecap","stroke-linecap",-1201103248),new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"viewBox","viewBox",-469489477),new cljs.core.Keyword(null,"height","height",1025178622)],["currentColor","none","round","100%","http://www.w3.org/2000/svg","round","2","feather feather-chevron-up w-4 h-4","0 0 24 24","100%"]),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"polyline","polyline",-1731551044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"points","points",-1486596883),points], null)], null)], null)], null)], null);
});
pinkgorilla.ui.control.select.select = (function pinkgorilla$ui$control$select$select(items,val,change_fn){
var l = cljs.core.count(items);
var l1 = (l - (1));
var dropdown_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var toggle_dropdown = (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dropdown_QMARK_,cljs.core.not);
});
var selected_QMARK_ = (function (name){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,val);
});
var pos_key = (function (i){
var G__66683 = i;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),G__66683)){
return new cljs.core.Keyword(null,"first","first",-644103046);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"l1","l1",-790259990,null),G__66683)){
return new cljs.core.Keyword(null,"last","last",1105735132);
} else {
return null;

}
}
});
var select = (function (p1__66682_SHARP_){
(change_fn.cljs$core$IFn$_invoke$arity$1 ? change_fn.cljs$core$IFn$_invoke$arity$1(p1__66682_SHARP_) : change_fn.call(null,p1__66682_SHARP_));

return cljs.core.reset_BANG_(dropdown_QMARK_,false);
});
var unselect = (function (){
return (change_fn.cljs$core$IFn$_invoke$arity$1 ? change_fn.cljs$core$IFn$_invoke$arity$1("") : change_fn.call(null,""));
});
var no_op = (function (){
return cljs.core.List.EMPTY;
});
return (function (items__$1,val__$1,change_fn__$1){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.control.select.css], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"flex flex-col items-center relative"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"w-full svelte-1l8159u"], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"my-2 bg-white p-1 flex border border-gray-200 rounded svelte-1l8159u"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"flex flex-auto flex-wrap"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149),no_op,new cljs.core.Keyword(null,"class","class",-2030961996),"p-1 px-2 appearance-none outline-none w-full text-gray-800 svelte-1l8159u"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.control.select.button_remove_selection,unselect], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.control.select.button_dropdown,cljs.core.deref(dropdown_QMARK_),toggle_dropdown], null)], null)], null),(cljs.core.truth_(cljs.core.deref(dropdown_QMARK_))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),["absolute shadow z-50 w-full lef-0 rounded max-h-select top-100 ","overflow-y-auto svelte-5uyqqj"].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"flex flex-col w-full"], null),cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,v){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.control.select.select_item,v,selected_QMARK_(v),pos_key(i),select], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null));
}),items__$1))], null)], null):null)], null)], null);
});
});
pinkgorilla.ui.control.select.go_next = (function pinkgorilla$ui$control$select$go_next(v,list,action){
var new_index = (list.indexOf(v) + (1));
var new_index__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_index,cljs.core.count(list)))?(0):new_index);
var new_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(list,new_index__$1);
return (action.cljs$core$IFn$_invoke$arity$1 ? action.cljs$core$IFn$_invoke$arity$1(new_value) : action.call(null,new_value));
});
pinkgorilla.ui.control.select.go_prior = (function pinkgorilla$ui$control$select$go_prior(v,list,action){
var new_index = (list.indexOf(v) - (1));
var new_index__$1 = (((new_index < (0)))?(cljs.core.count(list) - (1)):new_index);
var new_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(list,new_index__$1);
return (action.cljs$core$IFn$_invoke$arity$1 ? action.cljs$core$IFn$_invoke$arity$1(new_value) : action.call(null,new_value));
});
pinkgorilla.ui.control.select.nav_buttons = (function pinkgorilla$ui$control$select$nav_buttons(items,v,change_fn){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.control.button.button,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return pinkgorilla.ui.control.select.go_next(v,items,change_fn);
})], null),"<"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.control.button.button,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return pinkgorilla.ui.control.select.go_next(v,items,change_fn);
})], null),">"], null)], null);
});
/**
 * select one item from a seq of items
 * parameters:
 *   options: this is an optional parameter, a map with keys:
 *            on-change fn with parameter selected-val 
 *            nav?      bool (show < > buttons)
 *   items: vec of selectable items
 *   val-atom: map inside an atom
 *   k: the key that the selected value is bound to in the val-atom
 * 
 * examle:
 * (def state reagent.core/atom {:letter "a"})
 * [select-map ["a" "b"] state :letter]
 *   
 */
pinkgorilla.ui.control.select.select_map = (function pinkgorilla$ui$control$select$select_map(var_args){
var G__66687 = arguments.length;
switch (G__66687) {
case 3:
return pinkgorilla.ui.control.select.select_map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return pinkgorilla.ui.control.select.select_map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.ui.control.select.select_map.cljs$core$IFn$_invoke$arity$3 = (function (items,val_atom,k){
return pinkgorilla.ui.control.select.select_map.cljs$core$IFn$_invoke$arity$4(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"nav?","nav?",1269039770),false], null),items,val_atom,k);
}));

(pinkgorilla.ui.control.select.select_map.cljs$core$IFn$_invoke$arity$4 = (function (p__66688,items,val_atom,k){
var map__66689 = p__66688;
var map__66689__$1 = (((((!((map__66689 == null))))?(((((map__66689.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66689.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66689):map__66689);
var options = map__66689__$1;
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66689__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var nav_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66689__$1,new cljs.core.Keyword(null,"nav?","nav?",1269039770));
var change_fn = (function (v){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(val_atom,cljs.core.assoc,k,v);

if(cljs.core.truth_(on_change)){
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(v) : on_change.call(null,v));
} else {
return null;
}
});
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.control.select.select,items,(function (){var G__66691 = cljs.core.deref(val_atom);
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__66691) : k.call(null,G__66691));
})(),change_fn], null),(cljs.core.truth_(nav_QMARK_)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.control.select.nav_buttons,items,(function (){var G__66692 = cljs.core.deref(val_atom);
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__66692) : k.call(null,G__66692));
})(),change_fn], null):null)], null);
}));

(pinkgorilla.ui.control.select.select_map.cljs$lang$maxFixedArity = 4);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkie.pinkie.component_registry,cljs.core.assoc,new cljs.core.Keyword("p","pselect","p/pselect",571979287),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fun","fun",-1265158045),pinkgorilla.ui.control.select.select,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.meta(new cljs.core.Var(function(){return pinkgorilla.ui.control.select.select;},new cljs.core.Symbol("pinkgorilla.ui.control.select","select","pinkgorilla.ui.control.select/select",320149987,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"category","category",-593092832),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Keyword(null,"control","control",1892578036),new cljs.core.Symbol(null,"pinkgorilla.ui.control.select","pinkgorilla.ui.control.select",-232580441,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),"pinkgorilla/ui/control/select.cljs",9,1,63,64,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"items","items",-1622480831,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"change-fn","change-fn",-1087994944,null)], null)),null,(cljs.core.truth_(pinkgorilla.ui.control.select.select)?pinkgorilla.ui.control.select.select.cljs$lang$test:null)]))),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword("p","pselect","p/pselect",571979287)], null));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkie.pinkie.component_registry,cljs.core.assoc,new cljs.core.Keyword("p","pselectm","p/pselectm",146322694),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fun","fun",-1265158045),pinkgorilla.ui.control.select.select_map,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.meta(new cljs.core.Var(function(){return pinkgorilla.ui.control.select.select_map;},new cljs.core.Symbol("pinkgorilla.ui.control.select","select-map","pinkgorilla.ui.control.select/select-map",1670572640,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"category","category",-593092832),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Keyword(null,"control","control",1892578036),new cljs.core.Symbol(null,"pinkgorilla.ui.control.select","pinkgorilla.ui.control.select",-232580441,null),new cljs.core.Symbol(null,"select-map","select-map",-397614229,null),"pinkgorilla/ui/control/select.cljs",13,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),4,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),4,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"items","items",-1622480831,null),new cljs.core.Symbol(null,"val-atom","val-atom",-1698903913,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-change","on-change",908485378,null),new cljs.core.Symbol(null,"nav?","nav?",-1385395999,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"options","options",1740170016,null)], null),new cljs.core.Symbol(null,"items","items",-1622480831,null),new cljs.core.Symbol(null,"val-atom","val-atom",-1698903913,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"items","items",-1622480831,null),new cljs.core.Symbol(null,"val-atom","val-atom",-1698903913,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-change","on-change",908485378,null),new cljs.core.Symbol(null,"nav?","nav?",-1385395999,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"options","options",1740170016,null)], null),new cljs.core.Symbol(null,"items","items",-1622480831,null),new cljs.core.Symbol(null,"val-atom","val-atom",-1698903913,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,132,133,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"items","items",-1622480831,null),new cljs.core.Symbol(null,"val-atom","val-atom",-1698903913,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-change","on-change",908485378,null),new cljs.core.Symbol(null,"nav?","nav?",-1385395999,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"options","options",1740170016,null)], null),new cljs.core.Symbol(null,"items","items",-1622480831,null),new cljs.core.Symbol(null,"val-atom","val-atom",-1698903913,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),"select one item from a seq of items\n   parameters:\n     options: this is an optional parameter, a map with keys:\n              on-change fn with parameter selected-val \n              nav?      bool (show < > buttons)\n     items: vec of selectable items\n     val-atom: map inside an atom\n     k: the key that the selected value is bound to in the val-atom\n\n   examle:\n   (def state reagent.core/atom {:letter \"a\"})\n   [select-map [\"a\" \"b\"] state :letter]\n  ",(cljs.core.truth_(pinkgorilla.ui.control.select.select_map)?pinkgorilla.ui.control.select.select_map.cljs$lang$test:null)]))),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword("p","pselectm","p/pselectm",146322694)], null));

//# sourceMappingURL=pinkgorilla.ui.control.select.js.map
