goog.provide('pinkie.html');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('reagent.dom');
goog.require('pinkie.pinkie');
pinkie.html.temp_comp_hack = (function pinkie$html$temp_comp_hack(no_kw){
if(cljs.core.truth_(no_kw)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.first(no_kw))], null),cljs.core.rest(no_kw));
} else {
return null;
}
});
/**
 * Setting innerHTML (dangerouslySetInnerHTML) or textContent does not
 *  execute scripts! Thats why we clone and replace the elements.
 */
pinkie.html.process_scripts_BANG_ = (function pinkie$html$process_scripts_BANG_(el){
var scripts = Array.from(el.getElementsByTagName("SCRIPT"));
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (script){
var newScript = (function (){var G__66642 = document.createElement("script");
(G__66642["textContent"] = script.textContent);

return G__66642;
})();
var temp__5733__auto___66643 = script.getAttribute("src");
if(cljs.core.truth_(temp__5733__auto___66643)){
var src_66644 = temp__5733__auto___66643;
newScript.setAttribute("src",src_66644);
} else {
}

return script.replaceWith(newScript);
}),scripts));
});
/**
 * inject html string to reagent. allows script injection
 */
pinkie.html.html = (function pinkie$html$html(html){
if(typeof html === 'string'){
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display-name","display-name",694513143),"htmlwrapper",new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),(function (this$){
return pinkie.html.process_scripts_BANG_(reagent.dom.dom_node(this$));
}),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dangerouslySetInnerHTML","dangerouslySetInnerHTML",-554971138),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"__html","__html",674048345),html], null)], null)], null);
})], null));
} else {
return null;
}
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkie.pinkie.component_registry,cljs.core.assoc,new cljs.core.Keyword("p","phtml","p/phtml",-631947583),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fun","fun",-1265158045),pinkie.html.html,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.meta(new cljs.core.Var(function(){return pinkie.html.html;},new cljs.core.Symbol("pinkie.html","html","pinkie.html/html",-23273247,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"category","category",-593092832),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Keyword(null,"ui","ui",-469653645),new cljs.core.Symbol(null,"pinkie.html","pinkie.html",-893939102,null),new cljs.core.Symbol(null,"html","html",641734630,null),"pinkie/html.cljs",7,1,62,63,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"html","html",641734630,null)], null)),"inject html string to reagent. allows script injection",(cljs.core.truth_(pinkie.html.html)?pinkie.html.html.cljs$lang$test:null)]))),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword("p","phtml","p/phtml",-631947583)], null));

//# sourceMappingURL=pinkie.html.js.map
