goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__63865 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__63866 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__63866);

try{try{var seq__63867 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__63868 = null;
var count__63869 = (0);
var i__63870 = (0);
while(true){
if((i__63870 < count__63869)){
var vec__63877 = chunk__63868.cljs$core$IIndexed$_nth$arity$2(null,i__63870);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63877,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63877,(1),null);
var temp__5733__auto___63922 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___63922)){
var effect_fn_63923 = temp__5733__auto___63922;
(effect_fn_63923.cljs$core$IFn$_invoke$arity$1 ? effect_fn_63923.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_63923.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__63924 = seq__63867;
var G__63925 = chunk__63868;
var G__63926 = count__63869;
var G__63927 = (i__63870 + (1));
seq__63867 = G__63924;
chunk__63868 = G__63925;
count__63869 = G__63926;
i__63870 = G__63927;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63867);
if(temp__5735__auto__){
var seq__63867__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63867__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63867__$1);
var G__63928 = cljs.core.chunk_rest(seq__63867__$1);
var G__63929 = c__4550__auto__;
var G__63930 = cljs.core.count(c__4550__auto__);
var G__63931 = (0);
seq__63867 = G__63928;
chunk__63868 = G__63929;
count__63869 = G__63930;
i__63870 = G__63931;
continue;
} else {
var vec__63880 = cljs.core.first(seq__63867__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63880,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63880,(1),null);
var temp__5733__auto___63932 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___63932)){
var effect_fn_63933 = temp__5733__auto___63932;
(effect_fn_63933.cljs$core$IFn$_invoke$arity$1 ? effect_fn_63933.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_63933.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__63934 = cljs.core.next(seq__63867__$1);
var G__63935 = null;
var G__63936 = (0);
var G__63937 = (0);
seq__63867 = G__63934;
chunk__63868 = G__63935;
count__63869 = G__63936;
i__63870 = G__63937;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__63571__auto___63938 = re_frame.interop.now();
var duration__63572__auto___63939 = (end__63571__auto___63938 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__63572__auto___63939,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__63571__auto___63938);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__63865);
}} else {
var seq__63883 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__63884 = null;
var count__63885 = (0);
var i__63886 = (0);
while(true){
if((i__63886 < count__63885)){
var vec__63893 = chunk__63884.cljs$core$IIndexed$_nth$arity$2(null,i__63886);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63893,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63893,(1),null);
var temp__5733__auto___63940 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___63940)){
var effect_fn_63941 = temp__5733__auto___63940;
(effect_fn_63941.cljs$core$IFn$_invoke$arity$1 ? effect_fn_63941.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_63941.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__63942 = seq__63883;
var G__63943 = chunk__63884;
var G__63944 = count__63885;
var G__63945 = (i__63886 + (1));
seq__63883 = G__63942;
chunk__63884 = G__63943;
count__63885 = G__63944;
i__63886 = G__63945;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63883);
if(temp__5735__auto__){
var seq__63883__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63883__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63883__$1);
var G__63946 = cljs.core.chunk_rest(seq__63883__$1);
var G__63947 = c__4550__auto__;
var G__63948 = cljs.core.count(c__4550__auto__);
var G__63949 = (0);
seq__63883 = G__63946;
chunk__63884 = G__63947;
count__63885 = G__63948;
i__63886 = G__63949;
continue;
} else {
var vec__63898 = cljs.core.first(seq__63883__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63898,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63898,(1),null);
var temp__5733__auto___63950 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___63950)){
var effect_fn_63951 = temp__5733__auto___63950;
(effect_fn_63951.cljs$core$IFn$_invoke$arity$1 ? effect_fn_63951.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_63951.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__63952 = cljs.core.next(seq__63883__$1);
var G__63953 = null;
var G__63954 = (0);
var G__63955 = (0);
seq__63883 = G__63952;
chunk__63884 = G__63953;
count__63885 = G__63954;
i__63886 = G__63955;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__63901 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__63902 = null;
var count__63903 = (0);
var i__63904 = (0);
while(true){
if((i__63904 < count__63903)){
var map__63910 = chunk__63902.cljs$core$IIndexed$_nth$arity$2(null,i__63904);
var map__63910__$1 = (((((!((map__63910 == null))))?(((((map__63910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63910.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63910):map__63910);
var effect = map__63910__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63910__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63910__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__63901,chunk__63902,count__63903,i__63904,map__63910,map__63910__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__63901,chunk__63902,count__63903,i__63904,map__63910,map__63910__$1,effect,ms,dispatch))
,ms);
}


var G__63960 = seq__63901;
var G__63961 = chunk__63902;
var G__63962 = count__63903;
var G__63963 = (i__63904 + (1));
seq__63901 = G__63960;
chunk__63902 = G__63961;
count__63903 = G__63962;
i__63904 = G__63963;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63901);
if(temp__5735__auto__){
var seq__63901__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63901__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63901__$1);
var G__63964 = cljs.core.chunk_rest(seq__63901__$1);
var G__63965 = c__4550__auto__;
var G__63966 = cljs.core.count(c__4550__auto__);
var G__63967 = (0);
seq__63901 = G__63964;
chunk__63902 = G__63965;
count__63903 = G__63966;
i__63904 = G__63967;
continue;
} else {
var map__63912 = cljs.core.first(seq__63901__$1);
var map__63912__$1 = (((((!((map__63912 == null))))?(((((map__63912.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63912.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63912):map__63912);
var effect = map__63912__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63912__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63912__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__63901,chunk__63902,count__63903,i__63904,map__63912,map__63912__$1,effect,ms,dispatch,seq__63901__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__63901,chunk__63902,count__63903,i__63904,map__63912,map__63912__$1,effect,ms,dispatch,seq__63901__$1,temp__5735__auto__))
,ms);
}


var G__63971 = cljs.core.next(seq__63901__$1);
var G__63972 = null;
var G__63973 = (0);
var G__63974 = (0);
seq__63901 = G__63971;
chunk__63902 = G__63972;
count__63903 = G__63973;
i__63904 = G__63974;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__63914 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__63915 = null;
var count__63916 = (0);
var i__63917 = (0);
while(true){
if((i__63917 < count__63916)){
var event = chunk__63915.cljs$core$IIndexed$_nth$arity$2(null,i__63917);
re_frame.router.dispatch(event);


var G__63975 = seq__63914;
var G__63976 = chunk__63915;
var G__63977 = count__63916;
var G__63978 = (i__63917 + (1));
seq__63914 = G__63975;
chunk__63915 = G__63976;
count__63916 = G__63977;
i__63917 = G__63978;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63914);
if(temp__5735__auto__){
var seq__63914__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63914__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63914__$1);
var G__63981 = cljs.core.chunk_rest(seq__63914__$1);
var G__63982 = c__4550__auto__;
var G__63983 = cljs.core.count(c__4550__auto__);
var G__63984 = (0);
seq__63914 = G__63981;
chunk__63915 = G__63982;
count__63916 = G__63983;
i__63917 = G__63984;
continue;
} else {
var event = cljs.core.first(seq__63914__$1);
re_frame.router.dispatch(event);


var G__63985 = cljs.core.next(seq__63914__$1);
var G__63986 = null;
var G__63987 = (0);
var G__63988 = (0);
seq__63914 = G__63985;
chunk__63915 = G__63986;
count__63916 = G__63987;
i__63917 = G__63988;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__63918 = cljs.core.seq(value);
var chunk__63919 = null;
var count__63920 = (0);
var i__63921 = (0);
while(true){
if((i__63921 < count__63920)){
var event = chunk__63919.cljs$core$IIndexed$_nth$arity$2(null,i__63921);
clear_event(event);


var G__63989 = seq__63918;
var G__63990 = chunk__63919;
var G__63991 = count__63920;
var G__63992 = (i__63921 + (1));
seq__63918 = G__63989;
chunk__63919 = G__63990;
count__63920 = G__63991;
i__63921 = G__63992;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63918);
if(temp__5735__auto__){
var seq__63918__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63918__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63918__$1);
var G__63993 = cljs.core.chunk_rest(seq__63918__$1);
var G__63994 = c__4550__auto__;
var G__63995 = cljs.core.count(c__4550__auto__);
var G__63996 = (0);
seq__63918 = G__63993;
chunk__63919 = G__63994;
count__63920 = G__63995;
i__63921 = G__63996;
continue;
} else {
var event = cljs.core.first(seq__63918__$1);
clear_event(event);


var G__63997 = cljs.core.next(seq__63918__$1);
var G__63998 = null;
var G__63999 = (0);
var G__64000 = (0);
seq__63918 = G__63997;
chunk__63919 = G__63998;
count__63920 = G__63999;
i__63921 = G__64000;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
