(ns pinkgorilla.notebook.app
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   ;[webly.build :refer [build-cli]]
   [ring.util.response :refer [response]]
   [webly.config :refer [webly-config]]
   [webly.web.handler :refer [make-handler add-ring-handler]]
   [webly.web.middleware :refer [wrap-api-handler]]
   [pinkgorilla.explorer.handler] ; side-effects   
   [pinkgorilla.explore.handler :refer [explore-directories-start]]
   [pinkgorilla.notebook.routes :refer [notebook-routes-backend notebook-routes-frontend]]
   [pinkgorilla.notebook.config :refer [notebook-config]]
   [ring.adapter.jetty9 :refer [run-jetty]]
   [pinkgorilla.nrepl.service.relay-jetty :refer [jetty-relay-handler #_run-relay-jetty]]
   [pinkgorilla.nrepl.service.nrepl-server :refer [run-nrepl-server]])
  (:gen-class))

(def config-atom (atom {}))

(defn config-handler
  [_]
  (response @config-atom))

(add-ring-handler :notebook/config (wrap-api-handler config-handler))

(add-ring-handler :nrepl/relay jetty-relay-handler)

(info "making handler ..")
(def handler (make-handler notebook-routes-backend notebook-routes-frontend))

(defn run-jetty-server [config]
  (let [ws-handler (jetty-relay-handler)
        relay-config (:relay config)
        {:keys [port route]} relay-config]
    (info "Starting notebook web server at port" port " ..")
    (run-jetty handler {:port port
                        :websockets {route ws-handler}
                        :allow-null-path-info true
                           ;:join?  false        
                        })))

(defn start-notebook-server [config]
  (info "pinkgorilla notebook starting..")
  (info "config: " config)
  (reset! config-atom config)
  (swap! webly-config assoc :timbre-loglevel (:timbre-loglevel config))
  (swap! webly-config assoc :title (get-in config [:frontend :title]))
  (swap! webly-config assoc :start "pinkgorilla.notebook.app.start (); ")

  (explore-directories-start (get-in config [:backend :explorer]))
  (run-nrepl-server (:backend config))
  (run-jetty-server (:backend config))
  ;(build-cli :watch "+dev" "demo.app/handler" "demo.app")
  )

(defn -main
  []
  (start-notebook-server notebook-config))