goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e75529){var e = e75529;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___75645 = arguments.length;
var i__4731__auto___75646 = (0);
while(true){
if((i__4731__auto___75646 < len__4730__auto___75645)){
args__4736__auto__.push((arguments[i__4731__auto___75646]));

var G__75647 = (i__4731__auto___75646 + (1));
i__4731__auto___75646 = G__75647;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__75534){
var vec__75535 = p__75534;
var map__75538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75535,(0),null);
var map__75538__$1 = (((((!((map__75538 == null))))?(((((map__75538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75538):map__75538);
var opts = map__75538__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75538__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75538__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75538__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75538__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__75540 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4120__auto__ = read_ch;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4120__auto__ = write_ch;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__75540__$1 = (((((!((map__75540 == null))))?(((((map__75540.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75540.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75540):map__75540);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75540__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75540__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__75530_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__75530_SHARP_);
}));

(web_socket.onclose = (function (p1__75531_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__75531_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__70899__auto___75648 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_75609){
var state_val_75610 = (state_75609[(1)]);
if((state_val_75610 === (7))){
var inst_75605 = (state_75609[(2)]);
var state_75609__$1 = state_75609;
var statearr_75611_75649 = state_75609__$1;
(statearr_75611_75649[(2)] = inst_75605);

(statearr_75611_75649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (20))){
var state_75609__$1 = state_75609;
var statearr_75612_75650 = state_75609__$1;
(statearr_75612_75650[(2)] = null);

(statearr_75612_75650[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (1))){
var inst_75542 = false;
var state_75609__$1 = (function (){var statearr_75613 = state_75609;
(statearr_75613[(7)] = inst_75542);

return statearr_75613;
})();
var statearr_75614_75651 = state_75609__$1;
(statearr_75614_75651[(2)] = null);

(statearr_75614_75651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (4))){
var inst_75557 = (state_75609[(8)]);
var inst_75559 = (state_75609[(9)]);
var inst_75551 = (state_75609[(10)]);
var inst_75557__$1 = (state_75609[(2)]);
var inst_75558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75557__$1,(0),null);
var inst_75559__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75557__$1,(1),null);
var inst_75560 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75559__$1,inst_75551);
var state_75609__$1 = (function (){var statearr_75615 = state_75609;
(statearr_75615[(8)] = inst_75557__$1);

(statearr_75615[(9)] = inst_75559__$1);

(statearr_75615[(11)] = inst_75558);

return statearr_75615;
})();
if(inst_75560){
var statearr_75616_75652 = state_75609__$1;
(statearr_75616_75652[(1)] = (5));

} else {
var statearr_75617_75653 = state_75609__$1;
(statearr_75617_75653[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (15))){
var inst_75590 = (state_75609[(2)]);
var state_75609__$1 = state_75609;
var statearr_75618_75654 = state_75609__$1;
(statearr_75618_75654[(2)] = inst_75590);

(statearr_75618_75654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (21))){
var inst_75601 = (state_75609[(2)]);
var state_75609__$1 = state_75609;
var statearr_75619_75655 = state_75609__$1;
(statearr_75619_75655[(2)] = inst_75601);

(statearr_75619_75655[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (13))){
var state_75609__$1 = state_75609;
var statearr_75620_75656 = state_75609__$1;
(statearr_75620_75656[(2)] = null);

(statearr_75620_75656[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (6))){
var inst_75552 = (state_75609[(12)]);
var inst_75559 = (state_75609[(9)]);
var inst_75574 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75559,inst_75552);
var state_75609__$1 = state_75609;
if(inst_75574){
var statearr_75621_75666 = state_75609__$1;
(statearr_75621_75666[(1)] = (9));

} else {
var statearr_75622_75732 = state_75609__$1;
(statearr_75622_75732[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (17))){
var state_75609__$1 = state_75609;
var statearr_75623_75734 = state_75609__$1;
(statearr_75623_75734[(2)] = initial_ch);

(statearr_75623_75734[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (3))){
var inst_75607 = (state_75609[(2)]);
var state_75609__$1 = state_75609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75609__$1,inst_75607);
} else {
if((state_val_75610 === (12))){
var inst_75542 = (state_75609[(7)]);
var state_75609__$1 = state_75609;
if(cljs.core.truth_(inst_75542)){
var statearr_75624_75736 = state_75609__$1;
(statearr_75624_75736[(1)] = (16));

} else {
var statearr_75625_75738 = state_75609__$1;
(statearr_75625_75738[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (2))){
var inst_75552 = (state_75609[(12)]);
var inst_75551 = (state_75609[(10)]);
var inst_75551__$1 = open_ch;
var inst_75552__$1 = close_ch;
var inst_75553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75554 = [inst_75551__$1,inst_75552__$1];
var inst_75555 = (new cljs.core.PersistentVector(null,2,(5),inst_75553,inst_75554,null));
var state_75609__$1 = (function (){var statearr_75626 = state_75609;
(statearr_75626[(12)] = inst_75552__$1);

(statearr_75626[(10)] = inst_75551__$1);

return statearr_75626;
})();
return cljs.core.async.ioc_alts_BANG_(state_75609__$1,(4),inst_75555);
} else {
if((state_val_75610 === (19))){
var inst_75558 = (state_75609[(11)]);
var state_75609__$1 = state_75609;
var statearr_75627_75749 = state_75609__$1;
(statearr_75627_75749[(2)] = inst_75558);

(statearr_75627_75749[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (11))){
var inst_75603 = (state_75609[(2)]);
var state_75609__$1 = state_75609;
var statearr_75628_75750 = state_75609__$1;
(statearr_75628_75750[(2)] = inst_75603);

(statearr_75628_75750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (9))){
var inst_75557 = (state_75609[(8)]);
var inst_75580 = (state_75609[(13)]);
var inst_75579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75557,(0),null);
var inst_75580__$1 = chord.client.close_event__GT_maybe_error(inst_75579);
var state_75609__$1 = (function (){var statearr_75629 = state_75609;
(statearr_75629[(13)] = inst_75580__$1);

return statearr_75629;
})();
if(cljs.core.truth_(inst_75580__$1)){
var statearr_75630_75751 = state_75609__$1;
(statearr_75630_75751[(1)] = (12));

} else {
var statearr_75631_75752 = state_75609__$1;
(statearr_75631_75752[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (5))){
var inst_75557 = (state_75609[(8)]);
var inst_75565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75557,(0),null);
var inst_75566 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_75567 = [ws_chan];
var inst_75568 = cljs.core.PersistentHashMap.fromArrays(inst_75566,inst_75567);
var state_75609__$1 = (function (){var statearr_75632 = state_75609;
(statearr_75632[(14)] = inst_75565);

return statearr_75632;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75609__$1,(8),initial_ch,inst_75568);
} else {
if((state_val_75610 === (14))){
var inst_75593 = (state_75609[(2)]);
var inst_75594 = cljs.core.async.close_BANG_(ws_chan);
var inst_75595 = cljs.core.async.close_BANG_(initial_ch);
var state_75609__$1 = (function (){var statearr_75633 = state_75609;
(statearr_75633[(15)] = inst_75594);

(statearr_75633[(16)] = inst_75593);

return statearr_75633;
})();
var statearr_75634_75756 = state_75609__$1;
(statearr_75634_75756[(2)] = inst_75595);

(statearr_75634_75756[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (16))){
var state_75609__$1 = state_75609;
var statearr_75635_75758 = state_75609__$1;
(statearr_75635_75758[(2)] = read_ch__$1);

(statearr_75635_75758[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (10))){
var inst_75559 = (state_75609[(9)]);
var inst_75597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75559,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_75609__$1 = state_75609;
if(inst_75597){
var statearr_75636_75761 = state_75609__$1;
(statearr_75636_75761[(1)] = (19));

} else {
var statearr_75637_75762 = state_75609__$1;
(statearr_75637_75762[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75610 === (18))){
var inst_75580 = (state_75609[(13)]);
var inst_75585 = (state_75609[(2)]);
var inst_75586 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75587 = [inst_75580];
var inst_75588 = cljs.core.PersistentHashMap.fromArrays(inst_75586,inst_75587);
var state_75609__$1 = state_75609;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75609__$1,(15),inst_75585,inst_75588);
} else {
if((state_val_75610 === (8))){
var inst_75570 = (state_75609[(2)]);
var inst_75571 = cljs.core.async.close_BANG_(initial_ch);
var inst_75542 = true;
var state_75609__$1 = (function (){var statearr_75638 = state_75609;
(statearr_75638[(7)] = inst_75542);

(statearr_75638[(17)] = inst_75571);

(statearr_75638[(18)] = inst_75570);

return statearr_75638;
})();
var statearr_75639_75767 = state_75609__$1;
(statearr_75639_75767[(2)] = null);

(statearr_75639_75767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__70864__auto__ = null;
var chord$client$state_machine__70864__auto____0 = (function (){
var statearr_75640 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75640[(0)] = chord$client$state_machine__70864__auto__);

(statearr_75640[(1)] = (1));

return statearr_75640;
});
var chord$client$state_machine__70864__auto____1 = (function (state_75609){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_75609);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e75641){var ex__70867__auto__ = e75641;
var statearr_75642_75769 = state_75609;
(statearr_75642_75769[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_75609[(4)]))){
var statearr_75643_75770 = state_75609;
(statearr_75643_75770[(1)] = cljs.core.first((state_75609[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75772 = state_75609;
state_75609 = G__75772;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
chord$client$state_machine__70864__auto__ = function(state_75609){
switch(arguments.length){
case 0:
return chord$client$state_machine__70864__auto____0.call(this);
case 1:
return chord$client$state_machine__70864__auto____1.call(this,state_75609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__70864__auto____0;
chord$client$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__70864__auto____1;
return chord$client$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_75644 = f__70900__auto__();
(statearr_75644[(6)] = c__70899__auto___75648);

return statearr_75644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq75532){
var G__75533 = cljs.core.first(seq75532);
var seq75532__$1 = cljs.core.next(seq75532);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75533,seq75532__$1);
}));


//# sourceMappingURL=chord.client.js.map
