goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__70957 = arguments.length;
switch (G__70957) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async70959 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async70959 = (function (f,blockable,meta70960){
this.f = f;
this.blockable = blockable;
this.meta70960 = meta70960;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async70959.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_70961,meta70960__$1){
var self__ = this;
var _70961__$1 = this;
return (new cljs.core.async.t_cljs$core$async70959(self__.f,self__.blockable,meta70960__$1));
}));

(cljs.core.async.t_cljs$core$async70959.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_70961){
var self__ = this;
var _70961__$1 = this;
return self__.meta70960;
}));

(cljs.core.async.t_cljs$core$async70959.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async70959.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async70959.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async70959.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async70959.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta70960","meta70960",1472380536,null)], null);
}));

(cljs.core.async.t_cljs$core$async70959.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async70959.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async70959");

(cljs.core.async.t_cljs$core$async70959.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async70959");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async70959.
 */
cljs.core.async.__GT_t_cljs$core$async70959 = (function cljs$core$async$__GT_t_cljs$core$async70959(f__$1,blockable__$1,meta70960){
return (new cljs.core.async.t_cljs$core$async70959(f__$1,blockable__$1,meta70960));
});

}

return (new cljs.core.async.t_cljs$core$async70959(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__70970 = arguments.length;
switch (G__70970) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__70978 = arguments.length;
switch (G__70978) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__70982 = arguments.length;
switch (G__70982) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_72528 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_72528) : fn1.call(null,val_72528));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_72528) : fn1.call(null,val_72528));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__70989 = arguments.length;
switch (G__70989) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___72536 = n;
var x_72537 = (0);
while(true){
if((x_72537 < n__4607__auto___72536)){
(a[x_72537] = x_72537);

var G__72539 = (x_72537 + (1));
x_72537 = G__72539;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async70992 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async70992 = (function (flag,meta70993){
this.flag = flag;
this.meta70993 = meta70993;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async70992.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_70994,meta70993__$1){
var self__ = this;
var _70994__$1 = this;
return (new cljs.core.async.t_cljs$core$async70992(self__.flag,meta70993__$1));
}));

(cljs.core.async.t_cljs$core$async70992.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_70994){
var self__ = this;
var _70994__$1 = this;
return self__.meta70993;
}));

(cljs.core.async.t_cljs$core$async70992.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async70992.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async70992.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async70992.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async70992.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta70993","meta70993",681945405,null)], null);
}));

(cljs.core.async.t_cljs$core$async70992.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async70992.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async70992");

(cljs.core.async.t_cljs$core$async70992.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async70992");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async70992.
 */
cljs.core.async.__GT_t_cljs$core$async70992 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async70992(flag__$1,meta70993){
return (new cljs.core.async.t_cljs$core$async70992(flag__$1,meta70993));
});

}

return (new cljs.core.async.t_cljs$core$async70992(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async70998 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async70998 = (function (flag,cb,meta70999){
this.flag = flag;
this.cb = cb;
this.meta70999 = meta70999;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async70998.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71000,meta70999__$1){
var self__ = this;
var _71000__$1 = this;
return (new cljs.core.async.t_cljs$core$async70998(self__.flag,self__.cb,meta70999__$1));
}));

(cljs.core.async.t_cljs$core$async70998.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71000){
var self__ = this;
var _71000__$1 = this;
return self__.meta70999;
}));

(cljs.core.async.t_cljs$core$async70998.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async70998.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async70998.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async70998.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async70998.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta70999","meta70999",-710762816,null)], null);
}));

(cljs.core.async.t_cljs$core$async70998.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async70998.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async70998");

(cljs.core.async.t_cljs$core$async70998.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async70998");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async70998.
 */
cljs.core.async.__GT_t_cljs$core$async70998 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async70998(flag__$1,cb__$1,meta70999){
return (new cljs.core.async.t_cljs$core$async70998(flag__$1,cb__$1,meta70999));
});

}

return (new cljs.core.async.t_cljs$core$async70998(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71005_SHARP_){
var G__71007 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71005_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__71007) : fret.call(null,G__71007));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71006_SHARP_){
var G__71009 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71006_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__71009) : fret.call(null,G__71009));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4120__auto__ = wport;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return port;
}
})()], null));
} else {
var G__72551 = (i + (1));
i = G__72551;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4120__auto__ = ret;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4109__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4109__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4109__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___72556 = arguments.length;
var i__4731__auto___72557 = (0);
while(true){
if((i__4731__auto___72557 < len__4730__auto___72556)){
args__4736__auto__.push((arguments[i__4731__auto___72557]));

var G__72558 = (i__4731__auto___72557 + (1));
i__4731__auto___72557 = G__72558;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__71015){
var map__71016 = p__71015;
var map__71016__$1 = (((((!((map__71016 == null))))?(((((map__71016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71016.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__71016):map__71016);
var opts = map__71016__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq71013){
var G__71014 = cljs.core.first(seq71013);
var seq71013__$1 = cljs.core.next(seq71013);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71014,seq71013__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__71020 = arguments.length;
switch (G__71020) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__70899__auto___72567 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71055){
var state_val_71056 = (state_71055[(1)]);
if((state_val_71056 === (7))){
var inst_71051 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71058_72568 = state_71055__$1;
(statearr_71058_72568[(2)] = inst_71051);

(statearr_71058_72568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (1))){
var state_71055__$1 = state_71055;
var statearr_71059_72569 = state_71055__$1;
(statearr_71059_72569[(2)] = null);

(statearr_71059_72569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (4))){
var inst_71031 = (state_71055[(7)]);
var inst_71031__$1 = (state_71055[(2)]);
var inst_71032 = (inst_71031__$1 == null);
var state_71055__$1 = (function (){var statearr_71060 = state_71055;
(statearr_71060[(7)] = inst_71031__$1);

return statearr_71060;
})();
if(cljs.core.truth_(inst_71032)){
var statearr_71061_72571 = state_71055__$1;
(statearr_71061_72571[(1)] = (5));

} else {
var statearr_71062_72574 = state_71055__$1;
(statearr_71062_72574[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (13))){
var state_71055__$1 = state_71055;
var statearr_71063_72575 = state_71055__$1;
(statearr_71063_72575[(2)] = null);

(statearr_71063_72575[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (6))){
var inst_71031 = (state_71055[(7)]);
var state_71055__$1 = state_71055;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71055__$1,(11),to,inst_71031);
} else {
if((state_val_71056 === (3))){
var inst_71053 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71055__$1,inst_71053);
} else {
if((state_val_71056 === (12))){
var state_71055__$1 = state_71055;
var statearr_71064_72577 = state_71055__$1;
(statearr_71064_72577[(2)] = null);

(statearr_71064_72577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (2))){
var state_71055__$1 = state_71055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71055__$1,(4),from);
} else {
if((state_val_71056 === (11))){
var inst_71041 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
if(cljs.core.truth_(inst_71041)){
var statearr_71067_72579 = state_71055__$1;
(statearr_71067_72579[(1)] = (12));

} else {
var statearr_71069_72582 = state_71055__$1;
(statearr_71069_72582[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (9))){
var state_71055__$1 = state_71055;
var statearr_71070_72583 = state_71055__$1;
(statearr_71070_72583[(2)] = null);

(statearr_71070_72583[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (5))){
var state_71055__$1 = state_71055;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71071_72585 = state_71055__$1;
(statearr_71071_72585[(1)] = (8));

} else {
var statearr_71072_72586 = state_71055__$1;
(statearr_71072_72586[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (14))){
var inst_71049 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71073_72587 = state_71055__$1;
(statearr_71073_72587[(2)] = inst_71049);

(statearr_71073_72587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (10))){
var inst_71038 = (state_71055[(2)]);
var state_71055__$1 = state_71055;
var statearr_71074_72588 = state_71055__$1;
(statearr_71074_72588[(2)] = inst_71038);

(statearr_71074_72588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71056 === (8))){
var inst_71035 = cljs.core.async.close_BANG_(to);
var state_71055__$1 = state_71055;
var statearr_71076_72590 = state_71055__$1;
(statearr_71076_72590[(2)] = inst_71035);

(statearr_71076_72590[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_71077 = [null,null,null,null,null,null,null,null];
(statearr_71077[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_71077[(1)] = (1));

return statearr_71077;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_71055){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71055);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71078){var ex__70867__auto__ = e71078;
var statearr_71079_72591 = state_71055;
(statearr_71079_72591[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71055[(4)]))){
var statearr_71080_72592 = state_71055;
(statearr_71080_72592[(1)] = cljs.core.first((state_71055[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72595 = state_71055;
state_71055 = G__72595;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_71055){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_71055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71081 = f__70900__auto__();
(statearr_71081[(6)] = c__70899__auto___72567);

return statearr_71081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__71083){
var vec__71084 = p__71083;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71084,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71084,(1),null);
var job = vec__71084;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__70899__auto___72597 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71091){
var state_val_71092 = (state_71091[(1)]);
if((state_val_71092 === (1))){
var state_71091__$1 = state_71091;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71091__$1,(2),res,v);
} else {
if((state_val_71092 === (2))){
var inst_71088 = (state_71091[(2)]);
var inst_71089 = cljs.core.async.close_BANG_(res);
var state_71091__$1 = (function (){var statearr_71095 = state_71091;
(statearr_71095[(7)] = inst_71088);

return statearr_71095;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_71091__$1,inst_71089);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0 = (function (){
var statearr_71099 = [null,null,null,null,null,null,null,null];
(statearr_71099[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__);

(statearr_71099[(1)] = (1));

return statearr_71099;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1 = (function (state_71091){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71091);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71101){var ex__70867__auto__ = e71101;
var statearr_71102_72599 = state_71091;
(statearr_71102_72599[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71091[(4)]))){
var statearr_71103_72600 = state_71091;
(statearr_71103_72600[(1)] = cljs.core.first((state_71091[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72603 = state_71091;
state_71091 = G__72603;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = function(state_71091){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1.call(this,state_71091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71105 = f__70900__auto__();
(statearr_71105[(6)] = c__70899__auto___72597);

return statearr_71105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__71107){
var vec__71108 = p__71107;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71108,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71108,(1),null);
var job = vec__71108;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4607__auto___72607 = n;
var __72608 = (0);
while(true){
if((__72608 < n__4607__auto___72607)){
var G__71111_72609 = type;
var G__71111_72610__$1 = (((G__71111_72609 instanceof cljs.core.Keyword))?G__71111_72609.fqn:null);
switch (G__71111_72610__$1) {
case "compute":
var c__70899__auto___72615 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__72608,c__70899__auto___72615,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async){
return (function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = ((function (__72608,c__70899__auto___72615,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async){
return (function (state_71124){
var state_val_71125 = (state_71124[(1)]);
if((state_val_71125 === (1))){
var state_71124__$1 = state_71124;
var statearr_71126_72629 = state_71124__$1;
(statearr_71126_72629[(2)] = null);

(statearr_71126_72629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71125 === (2))){
var state_71124__$1 = state_71124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71124__$1,(4),jobs);
} else {
if((state_val_71125 === (3))){
var inst_71122 = (state_71124[(2)]);
var state_71124__$1 = state_71124;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71124__$1,inst_71122);
} else {
if((state_val_71125 === (4))){
var inst_71114 = (state_71124[(2)]);
var inst_71115 = process(inst_71114);
var state_71124__$1 = state_71124;
if(cljs.core.truth_(inst_71115)){
var statearr_71127_72631 = state_71124__$1;
(statearr_71127_72631[(1)] = (5));

} else {
var statearr_71128_72632 = state_71124__$1;
(statearr_71128_72632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71125 === (5))){
var state_71124__$1 = state_71124;
var statearr_71131_72633 = state_71124__$1;
(statearr_71131_72633[(2)] = null);

(statearr_71131_72633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71125 === (6))){
var state_71124__$1 = state_71124;
var statearr_71132_72634 = state_71124__$1;
(statearr_71132_72634[(2)] = null);

(statearr_71132_72634[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71125 === (7))){
var inst_71120 = (state_71124[(2)]);
var state_71124__$1 = state_71124;
var statearr_71135_72637 = state_71124__$1;
(statearr_71135_72637[(2)] = inst_71120);

(statearr_71135_72637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__72608,c__70899__auto___72615,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async))
;
return ((function (__72608,switch__70863__auto__,c__70899__auto___72615,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0 = (function (){
var statearr_71137 = [null,null,null,null,null,null,null];
(statearr_71137[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__);

(statearr_71137[(1)] = (1));

return statearr_71137;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1 = (function (state_71124){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71124);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71138){var ex__70867__auto__ = e71138;
var statearr_71139_72642 = state_71124;
(statearr_71139_72642[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71124[(4)]))){
var statearr_71141_72643 = state_71124;
(statearr_71141_72643[(1)] = cljs.core.first((state_71124[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72646 = state_71124;
state_71124 = G__72646;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = function(state_71124){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1.call(this,state_71124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__;
})()
;})(__72608,switch__70863__auto__,c__70899__auto___72615,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async))
})();
var state__70901__auto__ = (function (){var statearr_71144 = f__70900__auto__();
(statearr_71144[(6)] = c__70899__auto___72615);

return statearr_71144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
});})(__72608,c__70899__auto___72615,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async))
);


break;
case "async":
var c__70899__auto___72649 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__72608,c__70899__auto___72649,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async){
return (function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = ((function (__72608,c__70899__auto___72649,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async){
return (function (state_71158){
var state_val_71160 = (state_71158[(1)]);
if((state_val_71160 === (1))){
var state_71158__$1 = state_71158;
var statearr_71162_72652 = state_71158__$1;
(statearr_71162_72652[(2)] = null);

(statearr_71162_72652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71160 === (2))){
var state_71158__$1 = state_71158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71158__$1,(4),jobs);
} else {
if((state_val_71160 === (3))){
var inst_71155 = (state_71158[(2)]);
var state_71158__$1 = state_71158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71158__$1,inst_71155);
} else {
if((state_val_71160 === (4))){
var inst_71147 = (state_71158[(2)]);
var inst_71148 = async(inst_71147);
var state_71158__$1 = state_71158;
if(cljs.core.truth_(inst_71148)){
var statearr_71163_72655 = state_71158__$1;
(statearr_71163_72655[(1)] = (5));

} else {
var statearr_71164_72656 = state_71158__$1;
(statearr_71164_72656[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71160 === (5))){
var state_71158__$1 = state_71158;
var statearr_71165_72659 = state_71158__$1;
(statearr_71165_72659[(2)] = null);

(statearr_71165_72659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71160 === (6))){
var state_71158__$1 = state_71158;
var statearr_71166_72660 = state_71158__$1;
(statearr_71166_72660[(2)] = null);

(statearr_71166_72660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71160 === (7))){
var inst_71153 = (state_71158[(2)]);
var state_71158__$1 = state_71158;
var statearr_71167_72662 = state_71158__$1;
(statearr_71167_72662[(2)] = inst_71153);

(statearr_71167_72662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__72608,c__70899__auto___72649,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async))
;
return ((function (__72608,switch__70863__auto__,c__70899__auto___72649,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0 = (function (){
var statearr_71168 = [null,null,null,null,null,null,null];
(statearr_71168[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__);

(statearr_71168[(1)] = (1));

return statearr_71168;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1 = (function (state_71158){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71158);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71169){var ex__70867__auto__ = e71169;
var statearr_71170_72666 = state_71158;
(statearr_71170_72666[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71158[(4)]))){
var statearr_71171_72667 = state_71158;
(statearr_71171_72667[(1)] = cljs.core.first((state_71158[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72668 = state_71158;
state_71158 = G__72668;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = function(state_71158){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1.call(this,state_71158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__;
})()
;})(__72608,switch__70863__auto__,c__70899__auto___72649,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async))
})();
var state__70901__auto__ = (function (){var statearr_71175 = f__70900__auto__();
(statearr_71175[(6)] = c__70899__auto___72649);

return statearr_71175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
});})(__72608,c__70899__auto___72649,G__71111_72609,G__71111_72610__$1,n__4607__auto___72607,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__71111_72610__$1)].join('')));

}

var G__72669 = (__72608 + (1));
__72608 = G__72669;
continue;
} else {
}
break;
}

var c__70899__auto___72670 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71197){
var state_val_71198 = (state_71197[(1)]);
if((state_val_71198 === (7))){
var inst_71193 = (state_71197[(2)]);
var state_71197__$1 = state_71197;
var statearr_71199_72671 = state_71197__$1;
(statearr_71199_72671[(2)] = inst_71193);

(statearr_71199_72671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71198 === (1))){
var state_71197__$1 = state_71197;
var statearr_71200_72672 = state_71197__$1;
(statearr_71200_72672[(2)] = null);

(statearr_71200_72672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71198 === (4))){
var inst_71178 = (state_71197[(7)]);
var inst_71178__$1 = (state_71197[(2)]);
var inst_71179 = (inst_71178__$1 == null);
var state_71197__$1 = (function (){var statearr_71201 = state_71197;
(statearr_71201[(7)] = inst_71178__$1);

return statearr_71201;
})();
if(cljs.core.truth_(inst_71179)){
var statearr_71202_72673 = state_71197__$1;
(statearr_71202_72673[(1)] = (5));

} else {
var statearr_71203_72674 = state_71197__$1;
(statearr_71203_72674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71198 === (6))){
var inst_71178 = (state_71197[(7)]);
var inst_71183 = (state_71197[(8)]);
var inst_71183__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_71184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71185 = [inst_71178,inst_71183__$1];
var inst_71186 = (new cljs.core.PersistentVector(null,2,(5),inst_71184,inst_71185,null));
var state_71197__$1 = (function (){var statearr_71204 = state_71197;
(statearr_71204[(8)] = inst_71183__$1);

return statearr_71204;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71197__$1,(8),jobs,inst_71186);
} else {
if((state_val_71198 === (3))){
var inst_71195 = (state_71197[(2)]);
var state_71197__$1 = state_71197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71197__$1,inst_71195);
} else {
if((state_val_71198 === (2))){
var state_71197__$1 = state_71197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71197__$1,(4),from);
} else {
if((state_val_71198 === (9))){
var inst_71190 = (state_71197[(2)]);
var state_71197__$1 = (function (){var statearr_71205 = state_71197;
(statearr_71205[(9)] = inst_71190);

return statearr_71205;
})();
var statearr_71206_72677 = state_71197__$1;
(statearr_71206_72677[(2)] = null);

(statearr_71206_72677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71198 === (5))){
var inst_71181 = cljs.core.async.close_BANG_(jobs);
var state_71197__$1 = state_71197;
var statearr_71207_72680 = state_71197__$1;
(statearr_71207_72680[(2)] = inst_71181);

(statearr_71207_72680[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71198 === (8))){
var inst_71183 = (state_71197[(8)]);
var inst_71188 = (state_71197[(2)]);
var state_71197__$1 = (function (){var statearr_71208 = state_71197;
(statearr_71208[(10)] = inst_71188);

return statearr_71208;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71197__$1,(9),results,inst_71183);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0 = (function (){
var statearr_71209 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71209[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__);

(statearr_71209[(1)] = (1));

return statearr_71209;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1 = (function (state_71197){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71197);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71210){var ex__70867__auto__ = e71210;
var statearr_71211_72683 = state_71197;
(statearr_71211_72683[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71197[(4)]))){
var statearr_71212_72684 = state_71197;
(statearr_71212_72684[(1)] = cljs.core.first((state_71197[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72685 = state_71197;
state_71197 = G__72685;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = function(state_71197){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1.call(this,state_71197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71213 = f__70900__auto__();
(statearr_71213[(6)] = c__70899__auto___72670);

return statearr_71213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


var c__70899__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71254){
var state_val_71255 = (state_71254[(1)]);
if((state_val_71255 === (7))){
var inst_71250 = (state_71254[(2)]);
var state_71254__$1 = state_71254;
var statearr_71256_72686 = state_71254__$1;
(statearr_71256_72686[(2)] = inst_71250);

(statearr_71256_72686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (20))){
var state_71254__$1 = state_71254;
var statearr_71257_72688 = state_71254__$1;
(statearr_71257_72688[(2)] = null);

(statearr_71257_72688[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (1))){
var state_71254__$1 = state_71254;
var statearr_71258_72689 = state_71254__$1;
(statearr_71258_72689[(2)] = null);

(statearr_71258_72689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (4))){
var inst_71219 = (state_71254[(7)]);
var inst_71219__$1 = (state_71254[(2)]);
var inst_71220 = (inst_71219__$1 == null);
var state_71254__$1 = (function (){var statearr_71259 = state_71254;
(statearr_71259[(7)] = inst_71219__$1);

return statearr_71259;
})();
if(cljs.core.truth_(inst_71220)){
var statearr_71260_72692 = state_71254__$1;
(statearr_71260_72692[(1)] = (5));

} else {
var statearr_71261_72694 = state_71254__$1;
(statearr_71261_72694[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (15))){
var inst_71232 = (state_71254[(8)]);
var state_71254__$1 = state_71254;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71254__$1,(18),to,inst_71232);
} else {
if((state_val_71255 === (21))){
var inst_71245 = (state_71254[(2)]);
var state_71254__$1 = state_71254;
var statearr_71262_72695 = state_71254__$1;
(statearr_71262_72695[(2)] = inst_71245);

(statearr_71262_72695[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (13))){
var inst_71247 = (state_71254[(2)]);
var state_71254__$1 = (function (){var statearr_71263 = state_71254;
(statearr_71263[(9)] = inst_71247);

return statearr_71263;
})();
var statearr_71264_72696 = state_71254__$1;
(statearr_71264_72696[(2)] = null);

(statearr_71264_72696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (6))){
var inst_71219 = (state_71254[(7)]);
var state_71254__$1 = state_71254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71254__$1,(11),inst_71219);
} else {
if((state_val_71255 === (17))){
var inst_71240 = (state_71254[(2)]);
var state_71254__$1 = state_71254;
if(cljs.core.truth_(inst_71240)){
var statearr_71265_72698 = state_71254__$1;
(statearr_71265_72698[(1)] = (19));

} else {
var statearr_71266_72700 = state_71254__$1;
(statearr_71266_72700[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (3))){
var inst_71252 = (state_71254[(2)]);
var state_71254__$1 = state_71254;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71254__$1,inst_71252);
} else {
if((state_val_71255 === (12))){
var inst_71229 = (state_71254[(10)]);
var state_71254__$1 = state_71254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71254__$1,(14),inst_71229);
} else {
if((state_val_71255 === (2))){
var state_71254__$1 = state_71254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71254__$1,(4),results);
} else {
if((state_val_71255 === (19))){
var state_71254__$1 = state_71254;
var statearr_71267_72701 = state_71254__$1;
(statearr_71267_72701[(2)] = null);

(statearr_71267_72701[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (11))){
var inst_71229 = (state_71254[(2)]);
var state_71254__$1 = (function (){var statearr_71268 = state_71254;
(statearr_71268[(10)] = inst_71229);

return statearr_71268;
})();
var statearr_71269_72702 = state_71254__$1;
(statearr_71269_72702[(2)] = null);

(statearr_71269_72702[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (9))){
var state_71254__$1 = state_71254;
var statearr_71270_72703 = state_71254__$1;
(statearr_71270_72703[(2)] = null);

(statearr_71270_72703[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (5))){
var state_71254__$1 = state_71254;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71271_72708 = state_71254__$1;
(statearr_71271_72708[(1)] = (8));

} else {
var statearr_71272_72709 = state_71254__$1;
(statearr_71272_72709[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (14))){
var inst_71232 = (state_71254[(8)]);
var inst_71232__$1 = (state_71254[(2)]);
var inst_71233 = (inst_71232__$1 == null);
var inst_71234 = cljs.core.not(inst_71233);
var state_71254__$1 = (function (){var statearr_71275 = state_71254;
(statearr_71275[(8)] = inst_71232__$1);

return statearr_71275;
})();
if(inst_71234){
var statearr_71277_72710 = state_71254__$1;
(statearr_71277_72710[(1)] = (15));

} else {
var statearr_71278_72717 = state_71254__$1;
(statearr_71278_72717[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (16))){
var state_71254__$1 = state_71254;
var statearr_71279_72718 = state_71254__$1;
(statearr_71279_72718[(2)] = false);

(statearr_71279_72718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (10))){
var inst_71226 = (state_71254[(2)]);
var state_71254__$1 = state_71254;
var statearr_71280_72719 = state_71254__$1;
(statearr_71280_72719[(2)] = inst_71226);

(statearr_71280_72719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (18))){
var inst_71237 = (state_71254[(2)]);
var state_71254__$1 = state_71254;
var statearr_71281_72720 = state_71254__$1;
(statearr_71281_72720[(2)] = inst_71237);

(statearr_71281_72720[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71255 === (8))){
var inst_71223 = cljs.core.async.close_BANG_(to);
var state_71254__$1 = state_71254;
var statearr_71282_72721 = state_71254__$1;
(statearr_71282_72721[(2)] = inst_71223);

(statearr_71282_72721[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0 = (function (){
var statearr_71283 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71283[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__);

(statearr_71283[(1)] = (1));

return statearr_71283;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1 = (function (state_71254){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71254);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71284){var ex__70867__auto__ = e71284;
var statearr_71285_72722 = state_71254;
(statearr_71285_72722[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71254[(4)]))){
var statearr_71286_72723 = state_71254;
(statearr_71286_72723[(1)] = cljs.core.first((state_71254[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72724 = state_71254;
state_71254 = G__72724;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__ = function(state_71254){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1.call(this,state_71254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70864__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71287 = f__70900__auto__();
(statearr_71287[(6)] = c__70899__auto__);

return statearr_71287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));

return c__70899__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__71290 = arguments.length;
switch (G__71290) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__71292 = arguments.length;
switch (G__71292) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__71297 = arguments.length;
switch (G__71297) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__70899__auto___72781 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71323){
var state_val_71324 = (state_71323[(1)]);
if((state_val_71324 === (7))){
var inst_71319 = (state_71323[(2)]);
var state_71323__$1 = state_71323;
var statearr_71325_72782 = state_71323__$1;
(statearr_71325_72782[(2)] = inst_71319);

(statearr_71325_72782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (1))){
var state_71323__$1 = state_71323;
var statearr_71326_72784 = state_71323__$1;
(statearr_71326_72784[(2)] = null);

(statearr_71326_72784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (4))){
var inst_71300 = (state_71323[(7)]);
var inst_71300__$1 = (state_71323[(2)]);
var inst_71301 = (inst_71300__$1 == null);
var state_71323__$1 = (function (){var statearr_71327 = state_71323;
(statearr_71327[(7)] = inst_71300__$1);

return statearr_71327;
})();
if(cljs.core.truth_(inst_71301)){
var statearr_71328_72787 = state_71323__$1;
(statearr_71328_72787[(1)] = (5));

} else {
var statearr_71329_72788 = state_71323__$1;
(statearr_71329_72788[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (13))){
var state_71323__$1 = state_71323;
var statearr_71330_72790 = state_71323__$1;
(statearr_71330_72790[(2)] = null);

(statearr_71330_72790[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (6))){
var inst_71300 = (state_71323[(7)]);
var inst_71306 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_71300) : p.call(null,inst_71300));
var state_71323__$1 = state_71323;
if(cljs.core.truth_(inst_71306)){
var statearr_71331_72792 = state_71323__$1;
(statearr_71331_72792[(1)] = (9));

} else {
var statearr_71332_72794 = state_71323__$1;
(statearr_71332_72794[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (3))){
var inst_71321 = (state_71323[(2)]);
var state_71323__$1 = state_71323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71323__$1,inst_71321);
} else {
if((state_val_71324 === (12))){
var state_71323__$1 = state_71323;
var statearr_71333_72796 = state_71323__$1;
(statearr_71333_72796[(2)] = null);

(statearr_71333_72796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (2))){
var state_71323__$1 = state_71323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71323__$1,(4),ch);
} else {
if((state_val_71324 === (11))){
var inst_71300 = (state_71323[(7)]);
var inst_71310 = (state_71323[(2)]);
var state_71323__$1 = state_71323;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71323__$1,(8),inst_71310,inst_71300);
} else {
if((state_val_71324 === (9))){
var state_71323__$1 = state_71323;
var statearr_71334_72799 = state_71323__$1;
(statearr_71334_72799[(2)] = tc);

(statearr_71334_72799[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (5))){
var inst_71303 = cljs.core.async.close_BANG_(tc);
var inst_71304 = cljs.core.async.close_BANG_(fc);
var state_71323__$1 = (function (){var statearr_71335 = state_71323;
(statearr_71335[(8)] = inst_71303);

return statearr_71335;
})();
var statearr_71336_72800 = state_71323__$1;
(statearr_71336_72800[(2)] = inst_71304);

(statearr_71336_72800[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (14))){
var inst_71317 = (state_71323[(2)]);
var state_71323__$1 = state_71323;
var statearr_71337_72803 = state_71323__$1;
(statearr_71337_72803[(2)] = inst_71317);

(statearr_71337_72803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (10))){
var state_71323__$1 = state_71323;
var statearr_71338_72806 = state_71323__$1;
(statearr_71338_72806[(2)] = fc);

(statearr_71338_72806[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71324 === (8))){
var inst_71312 = (state_71323[(2)]);
var state_71323__$1 = state_71323;
if(cljs.core.truth_(inst_71312)){
var statearr_71339_72807 = state_71323__$1;
(statearr_71339_72807[(1)] = (12));

} else {
var statearr_71340_72809 = state_71323__$1;
(statearr_71340_72809[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_71341 = [null,null,null,null,null,null,null,null,null];
(statearr_71341[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_71341[(1)] = (1));

return statearr_71341;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_71323){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71323);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71342){var ex__70867__auto__ = e71342;
var statearr_71343_72813 = state_71323;
(statearr_71343_72813[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71323[(4)]))){
var statearr_71344_72815 = state_71323;
(statearr_71344_72815[(1)] = cljs.core.first((state_71323[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72816 = state_71323;
state_71323 = G__72816;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_71323){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_71323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71345 = f__70900__auto__();
(statearr_71345[(6)] = c__70899__auto___72781);

return statearr_71345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__70899__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71367){
var state_val_71368 = (state_71367[(1)]);
if((state_val_71368 === (7))){
var inst_71363 = (state_71367[(2)]);
var state_71367__$1 = state_71367;
var statearr_71369_72820 = state_71367__$1;
(statearr_71369_72820[(2)] = inst_71363);

(statearr_71369_72820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71368 === (1))){
var inst_71346 = init;
var inst_71347 = inst_71346;
var state_71367__$1 = (function (){var statearr_71370 = state_71367;
(statearr_71370[(7)] = inst_71347);

return statearr_71370;
})();
var statearr_71371_72824 = state_71367__$1;
(statearr_71371_72824[(2)] = null);

(statearr_71371_72824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71368 === (4))){
var inst_71350 = (state_71367[(8)]);
var inst_71350__$1 = (state_71367[(2)]);
var inst_71351 = (inst_71350__$1 == null);
var state_71367__$1 = (function (){var statearr_71372 = state_71367;
(statearr_71372[(8)] = inst_71350__$1);

return statearr_71372;
})();
if(cljs.core.truth_(inst_71351)){
var statearr_71373_72826 = state_71367__$1;
(statearr_71373_72826[(1)] = (5));

} else {
var statearr_71374_72827 = state_71367__$1;
(statearr_71374_72827[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71368 === (6))){
var inst_71347 = (state_71367[(7)]);
var inst_71354 = (state_71367[(9)]);
var inst_71350 = (state_71367[(8)]);
var inst_71354__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_71347,inst_71350) : f.call(null,inst_71347,inst_71350));
var inst_71355 = cljs.core.reduced_QMARK_(inst_71354__$1);
var state_71367__$1 = (function (){var statearr_71375 = state_71367;
(statearr_71375[(9)] = inst_71354__$1);

return statearr_71375;
})();
if(inst_71355){
var statearr_71376_72831 = state_71367__$1;
(statearr_71376_72831[(1)] = (8));

} else {
var statearr_71377_72832 = state_71367__$1;
(statearr_71377_72832[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71368 === (3))){
var inst_71365 = (state_71367[(2)]);
var state_71367__$1 = state_71367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71367__$1,inst_71365);
} else {
if((state_val_71368 === (2))){
var state_71367__$1 = state_71367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71367__$1,(4),ch);
} else {
if((state_val_71368 === (9))){
var inst_71354 = (state_71367[(9)]);
var inst_71347 = inst_71354;
var state_71367__$1 = (function (){var statearr_71378 = state_71367;
(statearr_71378[(7)] = inst_71347);

return statearr_71378;
})();
var statearr_71379_72834 = state_71367__$1;
(statearr_71379_72834[(2)] = null);

(statearr_71379_72834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71368 === (5))){
var inst_71347 = (state_71367[(7)]);
var state_71367__$1 = state_71367;
var statearr_71380_72835 = state_71367__$1;
(statearr_71380_72835[(2)] = inst_71347);

(statearr_71380_72835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71368 === (10))){
var inst_71361 = (state_71367[(2)]);
var state_71367__$1 = state_71367;
var statearr_71381_72836 = state_71367__$1;
(statearr_71381_72836[(2)] = inst_71361);

(statearr_71381_72836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71368 === (8))){
var inst_71354 = (state_71367[(9)]);
var inst_71357 = cljs.core.deref(inst_71354);
var state_71367__$1 = state_71367;
var statearr_71382_72837 = state_71367__$1;
(statearr_71382_72837[(2)] = inst_71357);

(statearr_71382_72837[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__70864__auto__ = null;
var cljs$core$async$reduce_$_state_machine__70864__auto____0 = (function (){
var statearr_71383 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71383[(0)] = cljs$core$async$reduce_$_state_machine__70864__auto__);

(statearr_71383[(1)] = (1));

return statearr_71383;
});
var cljs$core$async$reduce_$_state_machine__70864__auto____1 = (function (state_71367){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71367);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71384){var ex__70867__auto__ = e71384;
var statearr_71385_72838 = state_71367;
(statearr_71385_72838[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71367[(4)]))){
var statearr_71386_72839 = state_71367;
(statearr_71386_72839[(1)] = cljs.core.first((state_71367[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72840 = state_71367;
state_71367 = G__72840;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__70864__auto__ = function(state_71367){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__70864__auto____1.call(this,state_71367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__70864__auto____0;
cljs$core$async$reduce_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__70864__auto____1;
return cljs$core$async$reduce_$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71387 = f__70900__auto__();
(statearr_71387[(6)] = c__70899__auto__);

return statearr_71387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));

return c__70899__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__70899__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71393){
var state_val_71394 = (state_71393[(1)]);
if((state_val_71394 === (1))){
var inst_71388 = cljs.core.async.reduce(f__$1,init,ch);
var state_71393__$1 = state_71393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71393__$1,(2),inst_71388);
} else {
if((state_val_71394 === (2))){
var inst_71390 = (state_71393[(2)]);
var inst_71391 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_71390) : f__$1.call(null,inst_71390));
var state_71393__$1 = state_71393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71393__$1,inst_71391);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__70864__auto__ = null;
var cljs$core$async$transduce_$_state_machine__70864__auto____0 = (function (){
var statearr_71395 = [null,null,null,null,null,null,null];
(statearr_71395[(0)] = cljs$core$async$transduce_$_state_machine__70864__auto__);

(statearr_71395[(1)] = (1));

return statearr_71395;
});
var cljs$core$async$transduce_$_state_machine__70864__auto____1 = (function (state_71393){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71393);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71396){var ex__70867__auto__ = e71396;
var statearr_71397_72842 = state_71393;
(statearr_71397_72842[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71393[(4)]))){
var statearr_71398_72843 = state_71393;
(statearr_71398_72843[(1)] = cljs.core.first((state_71393[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72845 = state_71393;
state_71393 = G__72845;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__70864__auto__ = function(state_71393){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__70864__auto____1.call(this,state_71393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__70864__auto____0;
cljs$core$async$transduce_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__70864__auto____1;
return cljs$core$async$transduce_$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71399 = f__70900__auto__();
(statearr_71399[(6)] = c__70899__auto__);

return statearr_71399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));

return c__70899__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__71401 = arguments.length;
switch (G__71401) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__70899__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71426){
var state_val_71427 = (state_71426[(1)]);
if((state_val_71427 === (7))){
var inst_71408 = (state_71426[(2)]);
var state_71426__$1 = state_71426;
var statearr_71428_72847 = state_71426__$1;
(statearr_71428_72847[(2)] = inst_71408);

(statearr_71428_72847[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (1))){
var inst_71402 = cljs.core.seq(coll);
var inst_71403 = inst_71402;
var state_71426__$1 = (function (){var statearr_71429 = state_71426;
(statearr_71429[(7)] = inst_71403);

return statearr_71429;
})();
var statearr_71430_72848 = state_71426__$1;
(statearr_71430_72848[(2)] = null);

(statearr_71430_72848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (4))){
var inst_71403 = (state_71426[(7)]);
var inst_71406 = cljs.core.first(inst_71403);
var state_71426__$1 = state_71426;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71426__$1,(7),ch,inst_71406);
} else {
if((state_val_71427 === (13))){
var inst_71420 = (state_71426[(2)]);
var state_71426__$1 = state_71426;
var statearr_71431_72849 = state_71426__$1;
(statearr_71431_72849[(2)] = inst_71420);

(statearr_71431_72849[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (6))){
var inst_71411 = (state_71426[(2)]);
var state_71426__$1 = state_71426;
if(cljs.core.truth_(inst_71411)){
var statearr_71432_72850 = state_71426__$1;
(statearr_71432_72850[(1)] = (8));

} else {
var statearr_71433_72851 = state_71426__$1;
(statearr_71433_72851[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (3))){
var inst_71424 = (state_71426[(2)]);
var state_71426__$1 = state_71426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71426__$1,inst_71424);
} else {
if((state_val_71427 === (12))){
var state_71426__$1 = state_71426;
var statearr_71434_72852 = state_71426__$1;
(statearr_71434_72852[(2)] = null);

(statearr_71434_72852[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (2))){
var inst_71403 = (state_71426[(7)]);
var state_71426__$1 = state_71426;
if(cljs.core.truth_(inst_71403)){
var statearr_71435_72853 = state_71426__$1;
(statearr_71435_72853[(1)] = (4));

} else {
var statearr_71436_72854 = state_71426__$1;
(statearr_71436_72854[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (11))){
var inst_71417 = cljs.core.async.close_BANG_(ch);
var state_71426__$1 = state_71426;
var statearr_71437_72855 = state_71426__$1;
(statearr_71437_72855[(2)] = inst_71417);

(statearr_71437_72855[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (9))){
var state_71426__$1 = state_71426;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71438_72856 = state_71426__$1;
(statearr_71438_72856[(1)] = (11));

} else {
var statearr_71439_72857 = state_71426__$1;
(statearr_71439_72857[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (5))){
var inst_71403 = (state_71426[(7)]);
var state_71426__$1 = state_71426;
var statearr_71440_72858 = state_71426__$1;
(statearr_71440_72858[(2)] = inst_71403);

(statearr_71440_72858[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (10))){
var inst_71422 = (state_71426[(2)]);
var state_71426__$1 = state_71426;
var statearr_71441_72859 = state_71426__$1;
(statearr_71441_72859[(2)] = inst_71422);

(statearr_71441_72859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71427 === (8))){
var inst_71403 = (state_71426[(7)]);
var inst_71413 = cljs.core.next(inst_71403);
var inst_71403__$1 = inst_71413;
var state_71426__$1 = (function (){var statearr_71442 = state_71426;
(statearr_71442[(7)] = inst_71403__$1);

return statearr_71442;
})();
var statearr_71443_72860 = state_71426__$1;
(statearr_71443_72860[(2)] = null);

(statearr_71443_72860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_71444 = [null,null,null,null,null,null,null,null];
(statearr_71444[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_71444[(1)] = (1));

return statearr_71444;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_71426){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71426);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71445){var ex__70867__auto__ = e71445;
var statearr_71446_72861 = state_71426;
(statearr_71446_72861[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71426[(4)]))){
var statearr_71447_72862 = state_71426;
(statearr_71447_72862[(1)] = cljs.core.first((state_71426[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72863 = state_71426;
state_71426 = G__72863;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_71426){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_71426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71448 = f__70900__auto__();
(statearr_71448[(6)] = c__70899__auto__);

return statearr_71448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));

return c__70899__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_72864 = (function (_){
var x__4422__auto__ = (((_ == null))?null:_);
var m__4423__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4423__auto__.call(null,_));
} else {
var m__4420__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4420__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_72864(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_72865 = (function (m,ch,close_QMARK_){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4423__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4420__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4420__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_72865(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_72867 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_72867(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_72868 = (function (m){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4423__auto__.call(null,m));
} else {
var m__4420__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4420__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_72868(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71449 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71449 = (function (ch,cs,meta71450){
this.ch = ch;
this.cs = cs;
this.meta71450 = meta71450;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71449.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71451,meta71450__$1){
var self__ = this;
var _71451__$1 = this;
return (new cljs.core.async.t_cljs$core$async71449(self__.ch,self__.cs,meta71450__$1));
}));

(cljs.core.async.t_cljs$core$async71449.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71451){
var self__ = this;
var _71451__$1 = this;
return self__.meta71450;
}));

(cljs.core.async.t_cljs$core$async71449.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71449.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async71449.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71449.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async71449.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async71449.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async71449.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta71450","meta71450",-1347102165,null)], null);
}));

(cljs.core.async.t_cljs$core$async71449.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71449.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71449");

(cljs.core.async.t_cljs$core$async71449.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71449");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71449.
 */
cljs.core.async.__GT_t_cljs$core$async71449 = (function cljs$core$async$mult_$___GT_t_cljs$core$async71449(ch__$1,cs__$1,meta71450){
return (new cljs.core.async.t_cljs$core$async71449(ch__$1,cs__$1,meta71450));
});

}

return (new cljs.core.async.t_cljs$core$async71449(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__70899__auto___72877 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71584){
var state_val_71585 = (state_71584[(1)]);
if((state_val_71585 === (7))){
var inst_71580 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71586_72878 = state_71584__$1;
(statearr_71586_72878[(2)] = inst_71580);

(statearr_71586_72878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (20))){
var inst_71485 = (state_71584[(7)]);
var inst_71497 = cljs.core.first(inst_71485);
var inst_71498 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71497,(0),null);
var inst_71499 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71497,(1),null);
var state_71584__$1 = (function (){var statearr_71587 = state_71584;
(statearr_71587[(8)] = inst_71498);

return statearr_71587;
})();
if(cljs.core.truth_(inst_71499)){
var statearr_71588_72879 = state_71584__$1;
(statearr_71588_72879[(1)] = (22));

} else {
var statearr_71589_72880 = state_71584__$1;
(statearr_71589_72880[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (27))){
var inst_71534 = (state_71584[(9)]);
var inst_71529 = (state_71584[(10)]);
var inst_71527 = (state_71584[(11)]);
var inst_71454 = (state_71584[(12)]);
var inst_71534__$1 = cljs.core._nth(inst_71527,inst_71529);
var inst_71535 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_71534__$1,inst_71454,done);
var state_71584__$1 = (function (){var statearr_71590 = state_71584;
(statearr_71590[(9)] = inst_71534__$1);

return statearr_71590;
})();
if(cljs.core.truth_(inst_71535)){
var statearr_71591_72881 = state_71584__$1;
(statearr_71591_72881[(1)] = (30));

} else {
var statearr_71592_72882 = state_71584__$1;
(statearr_71592_72882[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (1))){
var state_71584__$1 = state_71584;
var statearr_71593_72883 = state_71584__$1;
(statearr_71593_72883[(2)] = null);

(statearr_71593_72883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (24))){
var inst_71485 = (state_71584[(7)]);
var inst_71504 = (state_71584[(2)]);
var inst_71505 = cljs.core.next(inst_71485);
var inst_71463 = inst_71505;
var inst_71464 = null;
var inst_71465 = (0);
var inst_71466 = (0);
var state_71584__$1 = (function (){var statearr_71594 = state_71584;
(statearr_71594[(13)] = inst_71465);

(statearr_71594[(14)] = inst_71504);

(statearr_71594[(15)] = inst_71464);

(statearr_71594[(16)] = inst_71466);

(statearr_71594[(17)] = inst_71463);

return statearr_71594;
})();
var statearr_71595_72884 = state_71584__$1;
(statearr_71595_72884[(2)] = null);

(statearr_71595_72884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (39))){
var state_71584__$1 = state_71584;
var statearr_71599_72885 = state_71584__$1;
(statearr_71599_72885[(2)] = null);

(statearr_71599_72885[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (4))){
var inst_71454 = (state_71584[(12)]);
var inst_71454__$1 = (state_71584[(2)]);
var inst_71455 = (inst_71454__$1 == null);
var state_71584__$1 = (function (){var statearr_71600 = state_71584;
(statearr_71600[(12)] = inst_71454__$1);

return statearr_71600;
})();
if(cljs.core.truth_(inst_71455)){
var statearr_71601_72886 = state_71584__$1;
(statearr_71601_72886[(1)] = (5));

} else {
var statearr_71602_72887 = state_71584__$1;
(statearr_71602_72887[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (15))){
var inst_71465 = (state_71584[(13)]);
var inst_71464 = (state_71584[(15)]);
var inst_71466 = (state_71584[(16)]);
var inst_71463 = (state_71584[(17)]);
var inst_71481 = (state_71584[(2)]);
var inst_71482 = (inst_71466 + (1));
var tmp71596 = inst_71465;
var tmp71597 = inst_71464;
var tmp71598 = inst_71463;
var inst_71463__$1 = tmp71598;
var inst_71464__$1 = tmp71597;
var inst_71465__$1 = tmp71596;
var inst_71466__$1 = inst_71482;
var state_71584__$1 = (function (){var statearr_71603 = state_71584;
(statearr_71603[(13)] = inst_71465__$1);

(statearr_71603[(15)] = inst_71464__$1);

(statearr_71603[(18)] = inst_71481);

(statearr_71603[(16)] = inst_71466__$1);

(statearr_71603[(17)] = inst_71463__$1);

return statearr_71603;
})();
var statearr_71604_72888 = state_71584__$1;
(statearr_71604_72888[(2)] = null);

(statearr_71604_72888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (21))){
var inst_71508 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71608_72889 = state_71584__$1;
(statearr_71608_72889[(2)] = inst_71508);

(statearr_71608_72889[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (31))){
var inst_71534 = (state_71584[(9)]);
var inst_71538 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_71534);
var state_71584__$1 = state_71584;
var statearr_71609_72890 = state_71584__$1;
(statearr_71609_72890[(2)] = inst_71538);

(statearr_71609_72890[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (32))){
var inst_71529 = (state_71584[(10)]);
var inst_71527 = (state_71584[(11)]);
var inst_71526 = (state_71584[(19)]);
var inst_71528 = (state_71584[(20)]);
var inst_71540 = (state_71584[(2)]);
var inst_71541 = (inst_71529 + (1));
var tmp71605 = inst_71527;
var tmp71606 = inst_71526;
var tmp71607 = inst_71528;
var inst_71526__$1 = tmp71606;
var inst_71527__$1 = tmp71605;
var inst_71528__$1 = tmp71607;
var inst_71529__$1 = inst_71541;
var state_71584__$1 = (function (){var statearr_71610 = state_71584;
(statearr_71610[(10)] = inst_71529__$1);

(statearr_71610[(21)] = inst_71540);

(statearr_71610[(11)] = inst_71527__$1);

(statearr_71610[(19)] = inst_71526__$1);

(statearr_71610[(20)] = inst_71528__$1);

return statearr_71610;
})();
var statearr_71611_72891 = state_71584__$1;
(statearr_71611_72891[(2)] = null);

(statearr_71611_72891[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (40))){
var inst_71553 = (state_71584[(22)]);
var inst_71557 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_71553);
var state_71584__$1 = state_71584;
var statearr_71612_72892 = state_71584__$1;
(statearr_71612_72892[(2)] = inst_71557);

(statearr_71612_72892[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (33))){
var inst_71544 = (state_71584[(23)]);
var inst_71546 = cljs.core.chunked_seq_QMARK_(inst_71544);
var state_71584__$1 = state_71584;
if(inst_71546){
var statearr_71613_72893 = state_71584__$1;
(statearr_71613_72893[(1)] = (36));

} else {
var statearr_71614_72894 = state_71584__$1;
(statearr_71614_72894[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (13))){
var inst_71475 = (state_71584[(24)]);
var inst_71478 = cljs.core.async.close_BANG_(inst_71475);
var state_71584__$1 = state_71584;
var statearr_71615_72895 = state_71584__$1;
(statearr_71615_72895[(2)] = inst_71478);

(statearr_71615_72895[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (22))){
var inst_71498 = (state_71584[(8)]);
var inst_71501 = cljs.core.async.close_BANG_(inst_71498);
var state_71584__$1 = state_71584;
var statearr_71616_72896 = state_71584__$1;
(statearr_71616_72896[(2)] = inst_71501);

(statearr_71616_72896[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (36))){
var inst_71544 = (state_71584[(23)]);
var inst_71548 = cljs.core.chunk_first(inst_71544);
var inst_71549 = cljs.core.chunk_rest(inst_71544);
var inst_71550 = cljs.core.count(inst_71548);
var inst_71526 = inst_71549;
var inst_71527 = inst_71548;
var inst_71528 = inst_71550;
var inst_71529 = (0);
var state_71584__$1 = (function (){var statearr_71617 = state_71584;
(statearr_71617[(10)] = inst_71529);

(statearr_71617[(11)] = inst_71527);

(statearr_71617[(19)] = inst_71526);

(statearr_71617[(20)] = inst_71528);

return statearr_71617;
})();
var statearr_71618_72900 = state_71584__$1;
(statearr_71618_72900[(2)] = null);

(statearr_71618_72900[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (41))){
var inst_71544 = (state_71584[(23)]);
var inst_71559 = (state_71584[(2)]);
var inst_71560 = cljs.core.next(inst_71544);
var inst_71526 = inst_71560;
var inst_71527 = null;
var inst_71528 = (0);
var inst_71529 = (0);
var state_71584__$1 = (function (){var statearr_71619 = state_71584;
(statearr_71619[(10)] = inst_71529);

(statearr_71619[(11)] = inst_71527);

(statearr_71619[(19)] = inst_71526);

(statearr_71619[(25)] = inst_71559);

(statearr_71619[(20)] = inst_71528);

return statearr_71619;
})();
var statearr_71620_72901 = state_71584__$1;
(statearr_71620_72901[(2)] = null);

(statearr_71620_72901[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (43))){
var state_71584__$1 = state_71584;
var statearr_71621_72902 = state_71584__$1;
(statearr_71621_72902[(2)] = null);

(statearr_71621_72902[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (29))){
var inst_71568 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71622_72904 = state_71584__$1;
(statearr_71622_72904[(2)] = inst_71568);

(statearr_71622_72904[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (44))){
var inst_71577 = (state_71584[(2)]);
var state_71584__$1 = (function (){var statearr_71623 = state_71584;
(statearr_71623[(26)] = inst_71577);

return statearr_71623;
})();
var statearr_71624_72905 = state_71584__$1;
(statearr_71624_72905[(2)] = null);

(statearr_71624_72905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (6))){
var inst_71518 = (state_71584[(27)]);
var inst_71517 = cljs.core.deref(cs);
var inst_71518__$1 = cljs.core.keys(inst_71517);
var inst_71519 = cljs.core.count(inst_71518__$1);
var inst_71520 = cljs.core.reset_BANG_(dctr,inst_71519);
var inst_71525 = cljs.core.seq(inst_71518__$1);
var inst_71526 = inst_71525;
var inst_71527 = null;
var inst_71528 = (0);
var inst_71529 = (0);
var state_71584__$1 = (function (){var statearr_71625 = state_71584;
(statearr_71625[(10)] = inst_71529);

(statearr_71625[(11)] = inst_71527);

(statearr_71625[(19)] = inst_71526);

(statearr_71625[(27)] = inst_71518__$1);

(statearr_71625[(28)] = inst_71520);

(statearr_71625[(20)] = inst_71528);

return statearr_71625;
})();
var statearr_71626_72906 = state_71584__$1;
(statearr_71626_72906[(2)] = null);

(statearr_71626_72906[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (28))){
var inst_71526 = (state_71584[(19)]);
var inst_71544 = (state_71584[(23)]);
var inst_71544__$1 = cljs.core.seq(inst_71526);
var state_71584__$1 = (function (){var statearr_71627 = state_71584;
(statearr_71627[(23)] = inst_71544__$1);

return statearr_71627;
})();
if(inst_71544__$1){
var statearr_71628_72907 = state_71584__$1;
(statearr_71628_72907[(1)] = (33));

} else {
var statearr_71629_72908 = state_71584__$1;
(statearr_71629_72908[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (25))){
var inst_71529 = (state_71584[(10)]);
var inst_71528 = (state_71584[(20)]);
var inst_71531 = (inst_71529 < inst_71528);
var inst_71532 = inst_71531;
var state_71584__$1 = state_71584;
if(cljs.core.truth_(inst_71532)){
var statearr_71630_72909 = state_71584__$1;
(statearr_71630_72909[(1)] = (27));

} else {
var statearr_71631_72910 = state_71584__$1;
(statearr_71631_72910[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (34))){
var state_71584__$1 = state_71584;
var statearr_71632_72911 = state_71584__$1;
(statearr_71632_72911[(2)] = null);

(statearr_71632_72911[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (17))){
var state_71584__$1 = state_71584;
var statearr_71633_72912 = state_71584__$1;
(statearr_71633_72912[(2)] = null);

(statearr_71633_72912[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (3))){
var inst_71582 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71584__$1,inst_71582);
} else {
if((state_val_71585 === (12))){
var inst_71513 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71634_72913 = state_71584__$1;
(statearr_71634_72913[(2)] = inst_71513);

(statearr_71634_72913[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (2))){
var state_71584__$1 = state_71584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71584__$1,(4),ch);
} else {
if((state_val_71585 === (23))){
var state_71584__$1 = state_71584;
var statearr_71635_72914 = state_71584__$1;
(statearr_71635_72914[(2)] = null);

(statearr_71635_72914[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (35))){
var inst_71566 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71636_72915 = state_71584__$1;
(statearr_71636_72915[(2)] = inst_71566);

(statearr_71636_72915[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (19))){
var inst_71485 = (state_71584[(7)]);
var inst_71489 = cljs.core.chunk_first(inst_71485);
var inst_71490 = cljs.core.chunk_rest(inst_71485);
var inst_71491 = cljs.core.count(inst_71489);
var inst_71463 = inst_71490;
var inst_71464 = inst_71489;
var inst_71465 = inst_71491;
var inst_71466 = (0);
var state_71584__$1 = (function (){var statearr_71637 = state_71584;
(statearr_71637[(13)] = inst_71465);

(statearr_71637[(15)] = inst_71464);

(statearr_71637[(16)] = inst_71466);

(statearr_71637[(17)] = inst_71463);

return statearr_71637;
})();
var statearr_71638_72916 = state_71584__$1;
(statearr_71638_72916[(2)] = null);

(statearr_71638_72916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (11))){
var inst_71485 = (state_71584[(7)]);
var inst_71463 = (state_71584[(17)]);
var inst_71485__$1 = cljs.core.seq(inst_71463);
var state_71584__$1 = (function (){var statearr_71639 = state_71584;
(statearr_71639[(7)] = inst_71485__$1);

return statearr_71639;
})();
if(inst_71485__$1){
var statearr_71640_72917 = state_71584__$1;
(statearr_71640_72917[(1)] = (16));

} else {
var statearr_71641_72918 = state_71584__$1;
(statearr_71641_72918[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (9))){
var inst_71515 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71642_72919 = state_71584__$1;
(statearr_71642_72919[(2)] = inst_71515);

(statearr_71642_72919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (5))){
var inst_71461 = cljs.core.deref(cs);
var inst_71462 = cljs.core.seq(inst_71461);
var inst_71463 = inst_71462;
var inst_71464 = null;
var inst_71465 = (0);
var inst_71466 = (0);
var state_71584__$1 = (function (){var statearr_71643 = state_71584;
(statearr_71643[(13)] = inst_71465);

(statearr_71643[(15)] = inst_71464);

(statearr_71643[(16)] = inst_71466);

(statearr_71643[(17)] = inst_71463);

return statearr_71643;
})();
var statearr_71644_72920 = state_71584__$1;
(statearr_71644_72920[(2)] = null);

(statearr_71644_72920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (14))){
var state_71584__$1 = state_71584;
var statearr_71645_72921 = state_71584__$1;
(statearr_71645_72921[(2)] = null);

(statearr_71645_72921[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (45))){
var inst_71574 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71646_72922 = state_71584__$1;
(statearr_71646_72922[(2)] = inst_71574);

(statearr_71646_72922[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (26))){
var inst_71518 = (state_71584[(27)]);
var inst_71570 = (state_71584[(2)]);
var inst_71571 = cljs.core.seq(inst_71518);
var state_71584__$1 = (function (){var statearr_71647 = state_71584;
(statearr_71647[(29)] = inst_71570);

return statearr_71647;
})();
if(inst_71571){
var statearr_71648_72923 = state_71584__$1;
(statearr_71648_72923[(1)] = (42));

} else {
var statearr_71649_72924 = state_71584__$1;
(statearr_71649_72924[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (16))){
var inst_71485 = (state_71584[(7)]);
var inst_71487 = cljs.core.chunked_seq_QMARK_(inst_71485);
var state_71584__$1 = state_71584;
if(inst_71487){
var statearr_71650_72925 = state_71584__$1;
(statearr_71650_72925[(1)] = (19));

} else {
var statearr_71651_72926 = state_71584__$1;
(statearr_71651_72926[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (38))){
var inst_71563 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71652_72928 = state_71584__$1;
(statearr_71652_72928[(2)] = inst_71563);

(statearr_71652_72928[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (30))){
var state_71584__$1 = state_71584;
var statearr_71653_72929 = state_71584__$1;
(statearr_71653_72929[(2)] = null);

(statearr_71653_72929[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (10))){
var inst_71464 = (state_71584[(15)]);
var inst_71466 = (state_71584[(16)]);
var inst_71474 = cljs.core._nth(inst_71464,inst_71466);
var inst_71475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71474,(0),null);
var inst_71476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71474,(1),null);
var state_71584__$1 = (function (){var statearr_71654 = state_71584;
(statearr_71654[(24)] = inst_71475);

return statearr_71654;
})();
if(cljs.core.truth_(inst_71476)){
var statearr_71655_72930 = state_71584__$1;
(statearr_71655_72930[(1)] = (13));

} else {
var statearr_71656_72931 = state_71584__$1;
(statearr_71656_72931[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (18))){
var inst_71511 = (state_71584[(2)]);
var state_71584__$1 = state_71584;
var statearr_71657_72932 = state_71584__$1;
(statearr_71657_72932[(2)] = inst_71511);

(statearr_71657_72932[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (42))){
var state_71584__$1 = state_71584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71584__$1,(45),dchan);
} else {
if((state_val_71585 === (37))){
var inst_71553 = (state_71584[(22)]);
var inst_71544 = (state_71584[(23)]);
var inst_71454 = (state_71584[(12)]);
var inst_71553__$1 = cljs.core.first(inst_71544);
var inst_71554 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_71553__$1,inst_71454,done);
var state_71584__$1 = (function (){var statearr_71658 = state_71584;
(statearr_71658[(22)] = inst_71553__$1);

return statearr_71658;
})();
if(cljs.core.truth_(inst_71554)){
var statearr_71659_72933 = state_71584__$1;
(statearr_71659_72933[(1)] = (39));

} else {
var statearr_71660_72934 = state_71584__$1;
(statearr_71660_72934[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71585 === (8))){
var inst_71465 = (state_71584[(13)]);
var inst_71466 = (state_71584[(16)]);
var inst_71468 = (inst_71466 < inst_71465);
var inst_71469 = inst_71468;
var state_71584__$1 = state_71584;
if(cljs.core.truth_(inst_71469)){
var statearr_71661_72938 = state_71584__$1;
(statearr_71661_72938[(1)] = (10));

} else {
var statearr_71662_72939 = state_71584__$1;
(statearr_71662_72939[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__70864__auto__ = null;
var cljs$core$async$mult_$_state_machine__70864__auto____0 = (function (){
var statearr_71663 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71663[(0)] = cljs$core$async$mult_$_state_machine__70864__auto__);

(statearr_71663[(1)] = (1));

return statearr_71663;
});
var cljs$core$async$mult_$_state_machine__70864__auto____1 = (function (state_71584){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71584);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71664){var ex__70867__auto__ = e71664;
var statearr_71665_72942 = state_71584;
(statearr_71665_72942[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71584[(4)]))){
var statearr_71666_72944 = state_71584;
(statearr_71666_72944[(1)] = cljs.core.first((state_71584[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72945 = state_71584;
state_71584 = G__72945;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__70864__auto__ = function(state_71584){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__70864__auto____1.call(this,state_71584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__70864__auto____0;
cljs$core$async$mult_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__70864__auto____1;
return cljs$core$async$mult_$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71667 = f__70900__auto__();
(statearr_71667[(6)] = c__70899__auto___72877);

return statearr_71667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__71669 = arguments.length;
switch (G__71669) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_72954 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_72954(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_72961 = (function (m,ch){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4423__auto__.call(null,m,ch));
} else {
var m__4420__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4420__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_72961(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_72964 = (function (m){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4423__auto__.call(null,m));
} else {
var m__4420__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4420__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_72964(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_72967 = (function (m,state_map){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4423__auto__.call(null,m,state_map));
} else {
var m__4420__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4420__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_72967(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_72969 = (function (m,mode){
var x__4422__auto__ = (((m == null))?null:m);
var m__4423__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4423__auto__.call(null,m,mode));
} else {
var m__4420__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4420__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_72969(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___72970 = arguments.length;
var i__4731__auto___72971 = (0);
while(true){
if((i__4731__auto___72971 < len__4730__auto___72970)){
args__4736__auto__.push((arguments[i__4731__auto___72971]));

var G__72972 = (i__4731__auto___72971 + (1));
i__4731__auto___72971 = G__72972;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__71674){
var map__71675 = p__71674;
var map__71675__$1 = (((((!((map__71675 == null))))?(((((map__71675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71675.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__71675):map__71675);
var opts = map__71675__$1;
var statearr_71677_72973 = state;
(statearr_71677_72973[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_71678_72974 = state;
(statearr_71678_72974[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_71679_72975 = state;
(statearr_71679_72975[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq71670){
var G__71671 = cljs.core.first(seq71670);
var seq71670__$1 = cljs.core.next(seq71670);
var G__71672 = cljs.core.first(seq71670__$1);
var seq71670__$2 = cljs.core.next(seq71670__$1);
var G__71673 = cljs.core.first(seq71670__$2);
var seq71670__$3 = cljs.core.next(seq71670__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71671,G__71672,G__71673,seq71670__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71680 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71680 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta71681){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta71681 = meta71681;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71682,meta71681__$1){
var self__ = this;
var _71682__$1 = this;
return (new cljs.core.async.t_cljs$core$async71680(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta71681__$1));
}));

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71682){
var self__ = this;
var _71682__$1 = this;
return self__.meta71681;
}));

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71680.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async71680.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta71681","meta71681",336139931,null)], null);
}));

(cljs.core.async.t_cljs$core$async71680.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71680.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71680");

(cljs.core.async.t_cljs$core$async71680.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71680");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71680.
 */
cljs.core.async.__GT_t_cljs$core$async71680 = (function cljs$core$async$mix_$___GT_t_cljs$core$async71680(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta71681){
return (new cljs.core.async.t_cljs$core$async71680(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta71681));
});

}

return (new cljs.core.async.t_cljs$core$async71680(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__70899__auto___72976 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71784){
var state_val_71785 = (state_71784[(1)]);
if((state_val_71785 === (7))){
var inst_71699 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
var statearr_71786_72977 = state_71784__$1;
(statearr_71786_72977[(2)] = inst_71699);

(statearr_71786_72977[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (20))){
var inst_71711 = (state_71784[(7)]);
var state_71784__$1 = state_71784;
var statearr_71787_72978 = state_71784__$1;
(statearr_71787_72978[(2)] = inst_71711);

(statearr_71787_72978[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (27))){
var state_71784__$1 = state_71784;
var statearr_71788_72979 = state_71784__$1;
(statearr_71788_72979[(2)] = null);

(statearr_71788_72979[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (1))){
var inst_71686 = (state_71784[(8)]);
var inst_71686__$1 = calc_state();
var inst_71688 = (inst_71686__$1 == null);
var inst_71689 = cljs.core.not(inst_71688);
var state_71784__$1 = (function (){var statearr_71789 = state_71784;
(statearr_71789[(8)] = inst_71686__$1);

return statearr_71789;
})();
if(inst_71689){
var statearr_71790_72980 = state_71784__$1;
(statearr_71790_72980[(1)] = (2));

} else {
var statearr_71791_72981 = state_71784__$1;
(statearr_71791_72981[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (24))){
var inst_71735 = (state_71784[(9)]);
var inst_71744 = (state_71784[(10)]);
var inst_71758 = (state_71784[(11)]);
var inst_71758__$1 = (inst_71735.cljs$core$IFn$_invoke$arity$1 ? inst_71735.cljs$core$IFn$_invoke$arity$1(inst_71744) : inst_71735.call(null,inst_71744));
var state_71784__$1 = (function (){var statearr_71792 = state_71784;
(statearr_71792[(11)] = inst_71758__$1);

return statearr_71792;
})();
if(cljs.core.truth_(inst_71758__$1)){
var statearr_71793_72982 = state_71784__$1;
(statearr_71793_72982[(1)] = (29));

} else {
var statearr_71794_72983 = state_71784__$1;
(statearr_71794_72983[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (4))){
var inst_71702 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
if(cljs.core.truth_(inst_71702)){
var statearr_71795_72984 = state_71784__$1;
(statearr_71795_72984[(1)] = (8));

} else {
var statearr_71796_72985 = state_71784__$1;
(statearr_71796_72985[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (15))){
var inst_71729 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
if(cljs.core.truth_(inst_71729)){
var statearr_71797_72986 = state_71784__$1;
(statearr_71797_72986[(1)] = (19));

} else {
var statearr_71798_72987 = state_71784__$1;
(statearr_71798_72987[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (21))){
var inst_71734 = (state_71784[(12)]);
var inst_71734__$1 = (state_71784[(2)]);
var inst_71735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71734__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_71736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71734__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_71737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71734__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_71784__$1 = (function (){var statearr_71799 = state_71784;
(statearr_71799[(9)] = inst_71735);

(statearr_71799[(13)] = inst_71736);

(statearr_71799[(12)] = inst_71734__$1);

return statearr_71799;
})();
return cljs.core.async.ioc_alts_BANG_(state_71784__$1,(22),inst_71737);
} else {
if((state_val_71785 === (31))){
var inst_71766 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
if(cljs.core.truth_(inst_71766)){
var statearr_71800_72988 = state_71784__$1;
(statearr_71800_72988[(1)] = (32));

} else {
var statearr_71801_72989 = state_71784__$1;
(statearr_71801_72989[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (32))){
var inst_71743 = (state_71784[(14)]);
var state_71784__$1 = state_71784;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71784__$1,(35),out,inst_71743);
} else {
if((state_val_71785 === (33))){
var inst_71734 = (state_71784[(12)]);
var inst_71711 = inst_71734;
var state_71784__$1 = (function (){var statearr_71802 = state_71784;
(statearr_71802[(7)] = inst_71711);

return statearr_71802;
})();
var statearr_71803_72990 = state_71784__$1;
(statearr_71803_72990[(2)] = null);

(statearr_71803_72990[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (13))){
var inst_71711 = (state_71784[(7)]);
var inst_71718 = inst_71711.cljs$lang$protocol_mask$partition0$;
var inst_71719 = (inst_71718 & (64));
var inst_71720 = inst_71711.cljs$core$ISeq$;
var inst_71721 = (cljs.core.PROTOCOL_SENTINEL === inst_71720);
var inst_71722 = ((inst_71719) || (inst_71721));
var state_71784__$1 = state_71784;
if(cljs.core.truth_(inst_71722)){
var statearr_71804_72991 = state_71784__$1;
(statearr_71804_72991[(1)] = (16));

} else {
var statearr_71805_72992 = state_71784__$1;
(statearr_71805_72992[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (22))){
var inst_71744 = (state_71784[(10)]);
var inst_71743 = (state_71784[(14)]);
var inst_71742 = (state_71784[(2)]);
var inst_71743__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71742,(0),null);
var inst_71744__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71742,(1),null);
var inst_71745 = (inst_71743__$1 == null);
var inst_71746 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71744__$1,change);
var inst_71747 = ((inst_71745) || (inst_71746));
var state_71784__$1 = (function (){var statearr_71806 = state_71784;
(statearr_71806[(10)] = inst_71744__$1);

(statearr_71806[(14)] = inst_71743__$1);

return statearr_71806;
})();
if(cljs.core.truth_(inst_71747)){
var statearr_71807_72993 = state_71784__$1;
(statearr_71807_72993[(1)] = (23));

} else {
var statearr_71808_72994 = state_71784__$1;
(statearr_71808_72994[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (36))){
var inst_71734 = (state_71784[(12)]);
var inst_71711 = inst_71734;
var state_71784__$1 = (function (){var statearr_71809 = state_71784;
(statearr_71809[(7)] = inst_71711);

return statearr_71809;
})();
var statearr_71810_72995 = state_71784__$1;
(statearr_71810_72995[(2)] = null);

(statearr_71810_72995[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (29))){
var inst_71758 = (state_71784[(11)]);
var state_71784__$1 = state_71784;
var statearr_71811_72996 = state_71784__$1;
(statearr_71811_72996[(2)] = inst_71758);

(statearr_71811_72996[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (6))){
var state_71784__$1 = state_71784;
var statearr_71812_72997 = state_71784__$1;
(statearr_71812_72997[(2)] = false);

(statearr_71812_72997[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (28))){
var inst_71754 = (state_71784[(2)]);
var inst_71755 = calc_state();
var inst_71711 = inst_71755;
var state_71784__$1 = (function (){var statearr_71813 = state_71784;
(statearr_71813[(7)] = inst_71711);

(statearr_71813[(15)] = inst_71754);

return statearr_71813;
})();
var statearr_71814_72998 = state_71784__$1;
(statearr_71814_72998[(2)] = null);

(statearr_71814_72998[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (25))){
var inst_71780 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
var statearr_71815_72999 = state_71784__$1;
(statearr_71815_72999[(2)] = inst_71780);

(statearr_71815_72999[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (34))){
var inst_71778 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
var statearr_71816_73000 = state_71784__$1;
(statearr_71816_73000[(2)] = inst_71778);

(statearr_71816_73000[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (17))){
var state_71784__$1 = state_71784;
var statearr_71817_73001 = state_71784__$1;
(statearr_71817_73001[(2)] = false);

(statearr_71817_73001[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (3))){
var state_71784__$1 = state_71784;
var statearr_71818_73002 = state_71784__$1;
(statearr_71818_73002[(2)] = false);

(statearr_71818_73002[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (12))){
var inst_71782 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71784__$1,inst_71782);
} else {
if((state_val_71785 === (2))){
var inst_71686 = (state_71784[(8)]);
var inst_71691 = inst_71686.cljs$lang$protocol_mask$partition0$;
var inst_71692 = (inst_71691 & (64));
var inst_71693 = inst_71686.cljs$core$ISeq$;
var inst_71694 = (cljs.core.PROTOCOL_SENTINEL === inst_71693);
var inst_71695 = ((inst_71692) || (inst_71694));
var state_71784__$1 = state_71784;
if(cljs.core.truth_(inst_71695)){
var statearr_71819_73003 = state_71784__$1;
(statearr_71819_73003[(1)] = (5));

} else {
var statearr_71820_73004 = state_71784__$1;
(statearr_71820_73004[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (23))){
var inst_71743 = (state_71784[(14)]);
var inst_71749 = (inst_71743 == null);
var state_71784__$1 = state_71784;
if(cljs.core.truth_(inst_71749)){
var statearr_71821_73005 = state_71784__$1;
(statearr_71821_73005[(1)] = (26));

} else {
var statearr_71822_73006 = state_71784__$1;
(statearr_71822_73006[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (35))){
var inst_71769 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
if(cljs.core.truth_(inst_71769)){
var statearr_71823_73007 = state_71784__$1;
(statearr_71823_73007[(1)] = (36));

} else {
var statearr_71824_73008 = state_71784__$1;
(statearr_71824_73008[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (19))){
var inst_71711 = (state_71784[(7)]);
var inst_71731 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_71711);
var state_71784__$1 = state_71784;
var statearr_71825_73009 = state_71784__$1;
(statearr_71825_73009[(2)] = inst_71731);

(statearr_71825_73009[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (11))){
var inst_71711 = (state_71784[(7)]);
var inst_71715 = (inst_71711 == null);
var inst_71716 = cljs.core.not(inst_71715);
var state_71784__$1 = state_71784;
if(inst_71716){
var statearr_71826_73010 = state_71784__$1;
(statearr_71826_73010[(1)] = (13));

} else {
var statearr_71827_73011 = state_71784__$1;
(statearr_71827_73011[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (9))){
var inst_71686 = (state_71784[(8)]);
var state_71784__$1 = state_71784;
var statearr_71828_73012 = state_71784__$1;
(statearr_71828_73012[(2)] = inst_71686);

(statearr_71828_73012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (5))){
var state_71784__$1 = state_71784;
var statearr_71829_73013 = state_71784__$1;
(statearr_71829_73013[(2)] = true);

(statearr_71829_73013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (14))){
var state_71784__$1 = state_71784;
var statearr_71830_73015 = state_71784__$1;
(statearr_71830_73015[(2)] = false);

(statearr_71830_73015[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (26))){
var inst_71744 = (state_71784[(10)]);
var inst_71751 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_71744);
var state_71784__$1 = state_71784;
var statearr_71831_73016 = state_71784__$1;
(statearr_71831_73016[(2)] = inst_71751);

(statearr_71831_73016[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (16))){
var state_71784__$1 = state_71784;
var statearr_71832_73017 = state_71784__$1;
(statearr_71832_73017[(2)] = true);

(statearr_71832_73017[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (38))){
var inst_71774 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
var statearr_71833_73020 = state_71784__$1;
(statearr_71833_73020[(2)] = inst_71774);

(statearr_71833_73020[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (30))){
var inst_71735 = (state_71784[(9)]);
var inst_71744 = (state_71784[(10)]);
var inst_71736 = (state_71784[(13)]);
var inst_71761 = cljs.core.empty_QMARK_(inst_71735);
var inst_71762 = (inst_71736.cljs$core$IFn$_invoke$arity$1 ? inst_71736.cljs$core$IFn$_invoke$arity$1(inst_71744) : inst_71736.call(null,inst_71744));
var inst_71763 = cljs.core.not(inst_71762);
var inst_71764 = ((inst_71761) && (inst_71763));
var state_71784__$1 = state_71784;
var statearr_71834_73022 = state_71784__$1;
(statearr_71834_73022[(2)] = inst_71764);

(statearr_71834_73022[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (10))){
var inst_71686 = (state_71784[(8)]);
var inst_71707 = (state_71784[(2)]);
var inst_71708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71707,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_71709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71707,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_71710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71707,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_71711 = inst_71686;
var state_71784__$1 = (function (){var statearr_71835 = state_71784;
(statearr_71835[(16)] = inst_71710);

(statearr_71835[(17)] = inst_71709);

(statearr_71835[(18)] = inst_71708);

(statearr_71835[(7)] = inst_71711);

return statearr_71835;
})();
var statearr_71836_73023 = state_71784__$1;
(statearr_71836_73023[(2)] = null);

(statearr_71836_73023[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (18))){
var inst_71726 = (state_71784[(2)]);
var state_71784__$1 = state_71784;
var statearr_71837_73024 = state_71784__$1;
(statearr_71837_73024[(2)] = inst_71726);

(statearr_71837_73024[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (37))){
var state_71784__$1 = state_71784;
var statearr_71838_73025 = state_71784__$1;
(statearr_71838_73025[(2)] = null);

(statearr_71838_73025[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71785 === (8))){
var inst_71686 = (state_71784[(8)]);
var inst_71704 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_71686);
var state_71784__$1 = state_71784;
var statearr_71839_73026 = state_71784__$1;
(statearr_71839_73026[(2)] = inst_71704);

(statearr_71839_73026[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__70864__auto__ = null;
var cljs$core$async$mix_$_state_machine__70864__auto____0 = (function (){
var statearr_71840 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71840[(0)] = cljs$core$async$mix_$_state_machine__70864__auto__);

(statearr_71840[(1)] = (1));

return statearr_71840;
});
var cljs$core$async$mix_$_state_machine__70864__auto____1 = (function (state_71784){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71784);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71841){var ex__70867__auto__ = e71841;
var statearr_71842_73028 = state_71784;
(statearr_71842_73028[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71784[(4)]))){
var statearr_71843_73031 = state_71784;
(statearr_71843_73031[(1)] = cljs.core.first((state_71784[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73033 = state_71784;
state_71784 = G__73033;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__70864__auto__ = function(state_71784){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__70864__auto____1.call(this,state_71784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__70864__auto____0;
cljs$core$async$mix_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__70864__auto____1;
return cljs$core$async$mix_$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71844 = f__70900__auto__();
(statearr_71844[(6)] = c__70899__auto___72976);

return statearr_71844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_73034 = (function (p,v,ch,close_QMARK_){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4423__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4420__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4420__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_73034(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_73036 = (function (p,v,ch){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4423__auto__.call(null,p,v,ch));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4420__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_73036(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_73040 = (function() {
var G__73041 = null;
var G__73041__1 = (function (p){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4423__auto__.call(null,p));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4420__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__73041__2 = (function (p,v){
var x__4422__auto__ = (((p == null))?null:p);
var m__4423__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4422__auto__)]);
if((!((m__4423__auto__ == null)))){
return (m__4423__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4423__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4423__auto__.call(null,p,v));
} else {
var m__4420__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4420__auto__ == null)))){
return (m__4420__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4420__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4420__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__73041 = function(p,v){
switch(arguments.length){
case 1:
return G__73041__1.call(this,p);
case 2:
return G__73041__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__73041.cljs$core$IFn$_invoke$arity$1 = G__73041__1;
G__73041.cljs$core$IFn$_invoke$arity$2 = G__73041__2;
return G__73041;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__71846 = arguments.length;
switch (G__71846) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_73040(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_73040(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__71849 = arguments.length;
switch (G__71849) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4120__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__71847_SHARP_){
if(cljs.core.truth_((p1__71847_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__71847_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__71847_SHARP_.call(null,topic)))){
return p1__71847_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__71847_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async71850 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71850 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta71851){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta71851 = meta71851;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71852,meta71851__$1){
var self__ = this;
var _71852__$1 = this;
return (new cljs.core.async.t_cljs$core$async71850(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta71851__$1));
}));

(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71852){
var self__ = this;
var _71852__$1 = this;
return self__.meta71851;
}));

(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async71850.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async71850.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta71851","meta71851",-2051540689,null)], null);
}));

(cljs.core.async.t_cljs$core$async71850.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async71850.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71850");

(cljs.core.async.t_cljs$core$async71850.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async71850");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async71850.
 */
cljs.core.async.__GT_t_cljs$core$async71850 = (function cljs$core$async$__GT_t_cljs$core$async71850(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta71851){
return (new cljs.core.async.t_cljs$core$async71850(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta71851));
});

}

return (new cljs.core.async.t_cljs$core$async71850(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__70899__auto___73051 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_71924){
var state_val_71925 = (state_71924[(1)]);
if((state_val_71925 === (7))){
var inst_71920 = (state_71924[(2)]);
var state_71924__$1 = state_71924;
var statearr_71926_73052 = state_71924__$1;
(statearr_71926_73052[(2)] = inst_71920);

(statearr_71926_73052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (20))){
var state_71924__$1 = state_71924;
var statearr_71927_73053 = state_71924__$1;
(statearr_71927_73053[(2)] = null);

(statearr_71927_73053[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (1))){
var state_71924__$1 = state_71924;
var statearr_71928_73054 = state_71924__$1;
(statearr_71928_73054[(2)] = null);

(statearr_71928_73054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (24))){
var inst_71903 = (state_71924[(7)]);
var inst_71912 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_71903);
var state_71924__$1 = state_71924;
var statearr_71929_73055 = state_71924__$1;
(statearr_71929_73055[(2)] = inst_71912);

(statearr_71929_73055[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (4))){
var inst_71855 = (state_71924[(8)]);
var inst_71855__$1 = (state_71924[(2)]);
var inst_71856 = (inst_71855__$1 == null);
var state_71924__$1 = (function (){var statearr_71930 = state_71924;
(statearr_71930[(8)] = inst_71855__$1);

return statearr_71930;
})();
if(cljs.core.truth_(inst_71856)){
var statearr_71931_73058 = state_71924__$1;
(statearr_71931_73058[(1)] = (5));

} else {
var statearr_71932_73060 = state_71924__$1;
(statearr_71932_73060[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (15))){
var inst_71897 = (state_71924[(2)]);
var state_71924__$1 = state_71924;
var statearr_71933_73061 = state_71924__$1;
(statearr_71933_73061[(2)] = inst_71897);

(statearr_71933_73061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (21))){
var inst_71917 = (state_71924[(2)]);
var state_71924__$1 = (function (){var statearr_71934 = state_71924;
(statearr_71934[(9)] = inst_71917);

return statearr_71934;
})();
var statearr_71935_73062 = state_71924__$1;
(statearr_71935_73062[(2)] = null);

(statearr_71935_73062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (13))){
var inst_71879 = (state_71924[(10)]);
var inst_71881 = cljs.core.chunked_seq_QMARK_(inst_71879);
var state_71924__$1 = state_71924;
if(inst_71881){
var statearr_71936_73063 = state_71924__$1;
(statearr_71936_73063[(1)] = (16));

} else {
var statearr_71937_73064 = state_71924__$1;
(statearr_71937_73064[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (22))){
var inst_71909 = (state_71924[(2)]);
var state_71924__$1 = state_71924;
if(cljs.core.truth_(inst_71909)){
var statearr_71938_73065 = state_71924__$1;
(statearr_71938_73065[(1)] = (23));

} else {
var statearr_71939_73066 = state_71924__$1;
(statearr_71939_73066[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (6))){
var inst_71905 = (state_71924[(11)]);
var inst_71855 = (state_71924[(8)]);
var inst_71903 = (state_71924[(7)]);
var inst_71903__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_71855) : topic_fn.call(null,inst_71855));
var inst_71904 = cljs.core.deref(mults);
var inst_71905__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71904,inst_71903__$1);
var state_71924__$1 = (function (){var statearr_71940 = state_71924;
(statearr_71940[(11)] = inst_71905__$1);

(statearr_71940[(7)] = inst_71903__$1);

return statearr_71940;
})();
if(cljs.core.truth_(inst_71905__$1)){
var statearr_71941_73067 = state_71924__$1;
(statearr_71941_73067[(1)] = (19));

} else {
var statearr_71942_73068 = state_71924__$1;
(statearr_71942_73068[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (25))){
var inst_71914 = (state_71924[(2)]);
var state_71924__$1 = state_71924;
var statearr_71943_73069 = state_71924__$1;
(statearr_71943_73069[(2)] = inst_71914);

(statearr_71943_73069[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (17))){
var inst_71879 = (state_71924[(10)]);
var inst_71888 = cljs.core.first(inst_71879);
var inst_71889 = cljs.core.async.muxch_STAR_(inst_71888);
var inst_71890 = cljs.core.async.close_BANG_(inst_71889);
var inst_71891 = cljs.core.next(inst_71879);
var inst_71865 = inst_71891;
var inst_71866 = null;
var inst_71867 = (0);
var inst_71868 = (0);
var state_71924__$1 = (function (){var statearr_71944 = state_71924;
(statearr_71944[(12)] = inst_71868);

(statearr_71944[(13)] = inst_71865);

(statearr_71944[(14)] = inst_71867);

(statearr_71944[(15)] = inst_71866);

(statearr_71944[(16)] = inst_71890);

return statearr_71944;
})();
var statearr_71945_73073 = state_71924__$1;
(statearr_71945_73073[(2)] = null);

(statearr_71945_73073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (3))){
var inst_71922 = (state_71924[(2)]);
var state_71924__$1 = state_71924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71924__$1,inst_71922);
} else {
if((state_val_71925 === (12))){
var inst_71899 = (state_71924[(2)]);
var state_71924__$1 = state_71924;
var statearr_71946_73074 = state_71924__$1;
(statearr_71946_73074[(2)] = inst_71899);

(statearr_71946_73074[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (2))){
var state_71924__$1 = state_71924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71924__$1,(4),ch);
} else {
if((state_val_71925 === (23))){
var state_71924__$1 = state_71924;
var statearr_71947_73078 = state_71924__$1;
(statearr_71947_73078[(2)] = null);

(statearr_71947_73078[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (19))){
var inst_71905 = (state_71924[(11)]);
var inst_71855 = (state_71924[(8)]);
var inst_71907 = cljs.core.async.muxch_STAR_(inst_71905);
var state_71924__$1 = state_71924;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_71924__$1,(22),inst_71907,inst_71855);
} else {
if((state_val_71925 === (11))){
var inst_71865 = (state_71924[(13)]);
var inst_71879 = (state_71924[(10)]);
var inst_71879__$1 = cljs.core.seq(inst_71865);
var state_71924__$1 = (function (){var statearr_71948 = state_71924;
(statearr_71948[(10)] = inst_71879__$1);

return statearr_71948;
})();
if(inst_71879__$1){
var statearr_71949_73079 = state_71924__$1;
(statearr_71949_73079[(1)] = (13));

} else {
var statearr_71950_73080 = state_71924__$1;
(statearr_71950_73080[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (9))){
var inst_71901 = (state_71924[(2)]);
var state_71924__$1 = state_71924;
var statearr_71951_73081 = state_71924__$1;
(statearr_71951_73081[(2)] = inst_71901);

(statearr_71951_73081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (5))){
var inst_71862 = cljs.core.deref(mults);
var inst_71863 = cljs.core.vals(inst_71862);
var inst_71864 = cljs.core.seq(inst_71863);
var inst_71865 = inst_71864;
var inst_71866 = null;
var inst_71867 = (0);
var inst_71868 = (0);
var state_71924__$1 = (function (){var statearr_71952 = state_71924;
(statearr_71952[(12)] = inst_71868);

(statearr_71952[(13)] = inst_71865);

(statearr_71952[(14)] = inst_71867);

(statearr_71952[(15)] = inst_71866);

return statearr_71952;
})();
var statearr_71953_73082 = state_71924__$1;
(statearr_71953_73082[(2)] = null);

(statearr_71953_73082[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (14))){
var state_71924__$1 = state_71924;
var statearr_71957_73083 = state_71924__$1;
(statearr_71957_73083[(2)] = null);

(statearr_71957_73083[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (16))){
var inst_71879 = (state_71924[(10)]);
var inst_71883 = cljs.core.chunk_first(inst_71879);
var inst_71884 = cljs.core.chunk_rest(inst_71879);
var inst_71885 = cljs.core.count(inst_71883);
var inst_71865 = inst_71884;
var inst_71866 = inst_71883;
var inst_71867 = inst_71885;
var inst_71868 = (0);
var state_71924__$1 = (function (){var statearr_71958 = state_71924;
(statearr_71958[(12)] = inst_71868);

(statearr_71958[(13)] = inst_71865);

(statearr_71958[(14)] = inst_71867);

(statearr_71958[(15)] = inst_71866);

return statearr_71958;
})();
var statearr_71959_73084 = state_71924__$1;
(statearr_71959_73084[(2)] = null);

(statearr_71959_73084[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (10))){
var inst_71868 = (state_71924[(12)]);
var inst_71865 = (state_71924[(13)]);
var inst_71867 = (state_71924[(14)]);
var inst_71866 = (state_71924[(15)]);
var inst_71873 = cljs.core._nth(inst_71866,inst_71868);
var inst_71874 = cljs.core.async.muxch_STAR_(inst_71873);
var inst_71875 = cljs.core.async.close_BANG_(inst_71874);
var inst_71876 = (inst_71868 + (1));
var tmp71954 = inst_71865;
var tmp71955 = inst_71867;
var tmp71956 = inst_71866;
var inst_71865__$1 = tmp71954;
var inst_71866__$1 = tmp71956;
var inst_71867__$1 = tmp71955;
var inst_71868__$1 = inst_71876;
var state_71924__$1 = (function (){var statearr_71960 = state_71924;
(statearr_71960[(12)] = inst_71868__$1);

(statearr_71960[(13)] = inst_71865__$1);

(statearr_71960[(17)] = inst_71875);

(statearr_71960[(14)] = inst_71867__$1);

(statearr_71960[(15)] = inst_71866__$1);

return statearr_71960;
})();
var statearr_71961_73085 = state_71924__$1;
(statearr_71961_73085[(2)] = null);

(statearr_71961_73085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (18))){
var inst_71894 = (state_71924[(2)]);
var state_71924__$1 = state_71924;
var statearr_71962_73086 = state_71924__$1;
(statearr_71962_73086[(2)] = inst_71894);

(statearr_71962_73086[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71925 === (8))){
var inst_71868 = (state_71924[(12)]);
var inst_71867 = (state_71924[(14)]);
var inst_71870 = (inst_71868 < inst_71867);
var inst_71871 = inst_71870;
var state_71924__$1 = state_71924;
if(cljs.core.truth_(inst_71871)){
var statearr_71963_73087 = state_71924__$1;
(statearr_71963_73087[(1)] = (10));

} else {
var statearr_71964_73088 = state_71924__$1;
(statearr_71964_73088[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_71965 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71965[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_71965[(1)] = (1));

return statearr_71965;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_71924){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_71924);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e71966){var ex__70867__auto__ = e71966;
var statearr_71967_73089 = state_71924;
(statearr_71967_73089[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_71924[(4)]))){
var statearr_71968_73090 = state_71924;
(statearr_71968_73090[(1)] = cljs.core.first((state_71924[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73091 = state_71924;
state_71924 = G__73091;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_71924){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_71924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_71969 = f__70900__auto__();
(statearr_71969[(6)] = c__70899__auto___73051);

return statearr_71969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__71971 = arguments.length;
switch (G__71971) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__71973 = arguments.length;
switch (G__71973) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__71975 = arguments.length;
switch (G__71975) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__70899__auto___73095 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_72018){
var state_val_72019 = (state_72018[(1)]);
if((state_val_72019 === (7))){
var state_72018__$1 = state_72018;
var statearr_72020_73096 = state_72018__$1;
(statearr_72020_73096[(2)] = null);

(statearr_72020_73096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (1))){
var state_72018__$1 = state_72018;
var statearr_72021_73097 = state_72018__$1;
(statearr_72021_73097[(2)] = null);

(statearr_72021_73097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (4))){
var inst_71978 = (state_72018[(7)]);
var inst_71979 = (state_72018[(8)]);
var inst_71981 = (inst_71979 < inst_71978);
var state_72018__$1 = state_72018;
if(cljs.core.truth_(inst_71981)){
var statearr_72022_73098 = state_72018__$1;
(statearr_72022_73098[(1)] = (6));

} else {
var statearr_72023_73099 = state_72018__$1;
(statearr_72023_73099[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (15))){
var inst_72004 = (state_72018[(9)]);
var inst_72009 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_72004);
var state_72018__$1 = state_72018;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72018__$1,(17),out,inst_72009);
} else {
if((state_val_72019 === (13))){
var inst_72004 = (state_72018[(9)]);
var inst_72004__$1 = (state_72018[(2)]);
var inst_72005 = cljs.core.some(cljs.core.nil_QMARK_,inst_72004__$1);
var state_72018__$1 = (function (){var statearr_72024 = state_72018;
(statearr_72024[(9)] = inst_72004__$1);

return statearr_72024;
})();
if(cljs.core.truth_(inst_72005)){
var statearr_72025_73100 = state_72018__$1;
(statearr_72025_73100[(1)] = (14));

} else {
var statearr_72026_73101 = state_72018__$1;
(statearr_72026_73101[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (6))){
var state_72018__$1 = state_72018;
var statearr_72027_73102 = state_72018__$1;
(statearr_72027_73102[(2)] = null);

(statearr_72027_73102[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (17))){
var inst_72011 = (state_72018[(2)]);
var state_72018__$1 = (function (){var statearr_72029 = state_72018;
(statearr_72029[(10)] = inst_72011);

return statearr_72029;
})();
var statearr_72030_73103 = state_72018__$1;
(statearr_72030_73103[(2)] = null);

(statearr_72030_73103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (3))){
var inst_72016 = (state_72018[(2)]);
var state_72018__$1 = state_72018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72018__$1,inst_72016);
} else {
if((state_val_72019 === (12))){
var _ = (function (){var statearr_72031 = state_72018;
(statearr_72031[(4)] = cljs.core.rest((state_72018[(4)])));

return statearr_72031;
})();
var state_72018__$1 = state_72018;
var ex72028 = (state_72018__$1[(2)]);
var statearr_72032_73104 = state_72018__$1;
(statearr_72032_73104[(5)] = ex72028);


if((ex72028 instanceof Object)){
var statearr_72033_73105 = state_72018__$1;
(statearr_72033_73105[(1)] = (11));

(statearr_72033_73105[(5)] = null);

} else {
throw ex72028;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (2))){
var inst_71977 = cljs.core.reset_BANG_(dctr,cnt);
var inst_71978 = cnt;
var inst_71979 = (0);
var state_72018__$1 = (function (){var statearr_72034 = state_72018;
(statearr_72034[(11)] = inst_71977);

(statearr_72034[(7)] = inst_71978);

(statearr_72034[(8)] = inst_71979);

return statearr_72034;
})();
var statearr_72035_73106 = state_72018__$1;
(statearr_72035_73106[(2)] = null);

(statearr_72035_73106[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (11))){
var inst_71983 = (state_72018[(2)]);
var inst_71984 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_72018__$1 = (function (){var statearr_72036 = state_72018;
(statearr_72036[(12)] = inst_71983);

return statearr_72036;
})();
var statearr_72037_73107 = state_72018__$1;
(statearr_72037_73107[(2)] = inst_71984);

(statearr_72037_73107[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (9))){
var inst_71979 = (state_72018[(8)]);
var _ = (function (){var statearr_72038 = state_72018;
(statearr_72038[(4)] = cljs.core.cons((12),(state_72018[(4)])));

return statearr_72038;
})();
var inst_71990 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_71979) : chs__$1.call(null,inst_71979));
var inst_71991 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_71979) : done.call(null,inst_71979));
var inst_71992 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_71990,inst_71991);
var ___$1 = (function (){var statearr_72039 = state_72018;
(statearr_72039[(4)] = cljs.core.rest((state_72018[(4)])));

return statearr_72039;
})();
var state_72018__$1 = state_72018;
var statearr_72040_73108 = state_72018__$1;
(statearr_72040_73108[(2)] = inst_71992);

(statearr_72040_73108[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (5))){
var inst_72002 = (state_72018[(2)]);
var state_72018__$1 = (function (){var statearr_72041 = state_72018;
(statearr_72041[(13)] = inst_72002);

return statearr_72041;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72018__$1,(13),dchan);
} else {
if((state_val_72019 === (14))){
var inst_72007 = cljs.core.async.close_BANG_(out);
var state_72018__$1 = state_72018;
var statearr_72042_73109 = state_72018__$1;
(statearr_72042_73109[(2)] = inst_72007);

(statearr_72042_73109[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (16))){
var inst_72014 = (state_72018[(2)]);
var state_72018__$1 = state_72018;
var statearr_72043_73110 = state_72018__$1;
(statearr_72043_73110[(2)] = inst_72014);

(statearr_72043_73110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (10))){
var inst_71979 = (state_72018[(8)]);
var inst_71995 = (state_72018[(2)]);
var inst_71996 = (inst_71979 + (1));
var inst_71979__$1 = inst_71996;
var state_72018__$1 = (function (){var statearr_72044 = state_72018;
(statearr_72044[(14)] = inst_71995);

(statearr_72044[(8)] = inst_71979__$1);

return statearr_72044;
})();
var statearr_72045_73111 = state_72018__$1;
(statearr_72045_73111[(2)] = null);

(statearr_72045_73111[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72019 === (8))){
var inst_72000 = (state_72018[(2)]);
var state_72018__$1 = state_72018;
var statearr_72046_73112 = state_72018__$1;
(statearr_72046_73112[(2)] = inst_72000);

(statearr_72046_73112[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_72047 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72047[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_72047[(1)] = (1));

return statearr_72047;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_72018){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_72018);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e72048){var ex__70867__auto__ = e72048;
var statearr_72049_73117 = state_72018;
(statearr_72049_73117[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_72018[(4)]))){
var statearr_72050_73118 = state_72018;
(statearr_72050_73118[(1)] = cljs.core.first((state_72018[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73119 = state_72018;
state_72018 = G__73119;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_72018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_72018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_72051 = f__70900__auto__();
(statearr_72051[(6)] = c__70899__auto___73095);

return statearr_72051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__72054 = arguments.length;
switch (G__72054) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70899__auto___73121 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_72086){
var state_val_72087 = (state_72086[(1)]);
if((state_val_72087 === (7))){
var inst_72066 = (state_72086[(7)]);
var inst_72065 = (state_72086[(8)]);
var inst_72065__$1 = (state_72086[(2)]);
var inst_72066__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72065__$1,(0),null);
var inst_72067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72065__$1,(1),null);
var inst_72068 = (inst_72066__$1 == null);
var state_72086__$1 = (function (){var statearr_72088 = state_72086;
(statearr_72088[(7)] = inst_72066__$1);

(statearr_72088[(8)] = inst_72065__$1);

(statearr_72088[(9)] = inst_72067);

return statearr_72088;
})();
if(cljs.core.truth_(inst_72068)){
var statearr_72089_73122 = state_72086__$1;
(statearr_72089_73122[(1)] = (8));

} else {
var statearr_72090_73123 = state_72086__$1;
(statearr_72090_73123[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72087 === (1))){
var inst_72055 = cljs.core.vec(chs);
var inst_72056 = inst_72055;
var state_72086__$1 = (function (){var statearr_72091 = state_72086;
(statearr_72091[(10)] = inst_72056);

return statearr_72091;
})();
var statearr_72092_73124 = state_72086__$1;
(statearr_72092_73124[(2)] = null);

(statearr_72092_73124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72087 === (4))){
var inst_72056 = (state_72086[(10)]);
var state_72086__$1 = state_72086;
return cljs.core.async.ioc_alts_BANG_(state_72086__$1,(7),inst_72056);
} else {
if((state_val_72087 === (6))){
var inst_72082 = (state_72086[(2)]);
var state_72086__$1 = state_72086;
var statearr_72093_73125 = state_72086__$1;
(statearr_72093_73125[(2)] = inst_72082);

(statearr_72093_73125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72087 === (3))){
var inst_72084 = (state_72086[(2)]);
var state_72086__$1 = state_72086;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72086__$1,inst_72084);
} else {
if((state_val_72087 === (2))){
var inst_72056 = (state_72086[(10)]);
var inst_72058 = cljs.core.count(inst_72056);
var inst_72059 = (inst_72058 > (0));
var state_72086__$1 = state_72086;
if(cljs.core.truth_(inst_72059)){
var statearr_72095_73126 = state_72086__$1;
(statearr_72095_73126[(1)] = (4));

} else {
var statearr_72096_73127 = state_72086__$1;
(statearr_72096_73127[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72087 === (11))){
var inst_72056 = (state_72086[(10)]);
var inst_72075 = (state_72086[(2)]);
var tmp72094 = inst_72056;
var inst_72056__$1 = tmp72094;
var state_72086__$1 = (function (){var statearr_72097 = state_72086;
(statearr_72097[(11)] = inst_72075);

(statearr_72097[(10)] = inst_72056__$1);

return statearr_72097;
})();
var statearr_72098_73128 = state_72086__$1;
(statearr_72098_73128[(2)] = null);

(statearr_72098_73128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72087 === (9))){
var inst_72066 = (state_72086[(7)]);
var state_72086__$1 = state_72086;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72086__$1,(11),out,inst_72066);
} else {
if((state_val_72087 === (5))){
var inst_72080 = cljs.core.async.close_BANG_(out);
var state_72086__$1 = state_72086;
var statearr_72099_73129 = state_72086__$1;
(statearr_72099_73129[(2)] = inst_72080);

(statearr_72099_73129[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72087 === (10))){
var inst_72078 = (state_72086[(2)]);
var state_72086__$1 = state_72086;
var statearr_72100_73130 = state_72086__$1;
(statearr_72100_73130[(2)] = inst_72078);

(statearr_72100_73130[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72087 === (8))){
var inst_72066 = (state_72086[(7)]);
var inst_72065 = (state_72086[(8)]);
var inst_72056 = (state_72086[(10)]);
var inst_72067 = (state_72086[(9)]);
var inst_72070 = (function (){var cs = inst_72056;
var vec__72061 = inst_72065;
var v = inst_72066;
var c = inst_72067;
return (function (p1__72052_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__72052_SHARP_);
});
})();
var inst_72071 = cljs.core.filterv(inst_72070,inst_72056);
var inst_72056__$1 = inst_72071;
var state_72086__$1 = (function (){var statearr_72101 = state_72086;
(statearr_72101[(10)] = inst_72056__$1);

return statearr_72101;
})();
var statearr_72102_73131 = state_72086__$1;
(statearr_72102_73131[(2)] = null);

(statearr_72102_73131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_72103 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72103[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_72103[(1)] = (1));

return statearr_72103;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_72086){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_72086);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e72104){var ex__70867__auto__ = e72104;
var statearr_72105_73132 = state_72086;
(statearr_72105_73132[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_72086[(4)]))){
var statearr_72106_73133 = state_72086;
(statearr_72106_73133[(1)] = cljs.core.first((state_72086[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73134 = state_72086;
state_72086 = G__73134;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_72086){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_72086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_72107 = f__70900__auto__();
(statearr_72107[(6)] = c__70899__auto___73121);

return statearr_72107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__72109 = arguments.length;
switch (G__72109) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70899__auto___73136 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_72133){
var state_val_72134 = (state_72133[(1)]);
if((state_val_72134 === (7))){
var inst_72115 = (state_72133[(7)]);
var inst_72115__$1 = (state_72133[(2)]);
var inst_72116 = (inst_72115__$1 == null);
var inst_72117 = cljs.core.not(inst_72116);
var state_72133__$1 = (function (){var statearr_72135 = state_72133;
(statearr_72135[(7)] = inst_72115__$1);

return statearr_72135;
})();
if(inst_72117){
var statearr_72136_73138 = state_72133__$1;
(statearr_72136_73138[(1)] = (8));

} else {
var statearr_72137_73139 = state_72133__$1;
(statearr_72137_73139[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72134 === (1))){
var inst_72110 = (0);
var state_72133__$1 = (function (){var statearr_72138 = state_72133;
(statearr_72138[(8)] = inst_72110);

return statearr_72138;
})();
var statearr_72139_73140 = state_72133__$1;
(statearr_72139_73140[(2)] = null);

(statearr_72139_73140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72134 === (4))){
var state_72133__$1 = state_72133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72133__$1,(7),ch);
} else {
if((state_val_72134 === (6))){
var inst_72128 = (state_72133[(2)]);
var state_72133__$1 = state_72133;
var statearr_72140_73144 = state_72133__$1;
(statearr_72140_73144[(2)] = inst_72128);

(statearr_72140_73144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72134 === (3))){
var inst_72130 = (state_72133[(2)]);
var inst_72131 = cljs.core.async.close_BANG_(out);
var state_72133__$1 = (function (){var statearr_72141 = state_72133;
(statearr_72141[(9)] = inst_72130);

return statearr_72141;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72133__$1,inst_72131);
} else {
if((state_val_72134 === (2))){
var inst_72110 = (state_72133[(8)]);
var inst_72112 = (inst_72110 < n);
var state_72133__$1 = state_72133;
if(cljs.core.truth_(inst_72112)){
var statearr_72142_73145 = state_72133__$1;
(statearr_72142_73145[(1)] = (4));

} else {
var statearr_72143_73146 = state_72133__$1;
(statearr_72143_73146[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72134 === (11))){
var inst_72110 = (state_72133[(8)]);
var inst_72120 = (state_72133[(2)]);
var inst_72121 = (inst_72110 + (1));
var inst_72110__$1 = inst_72121;
var state_72133__$1 = (function (){var statearr_72144 = state_72133;
(statearr_72144[(8)] = inst_72110__$1);

(statearr_72144[(10)] = inst_72120);

return statearr_72144;
})();
var statearr_72145_73150 = state_72133__$1;
(statearr_72145_73150[(2)] = null);

(statearr_72145_73150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72134 === (9))){
var state_72133__$1 = state_72133;
var statearr_72146_73151 = state_72133__$1;
(statearr_72146_73151[(2)] = null);

(statearr_72146_73151[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72134 === (5))){
var state_72133__$1 = state_72133;
var statearr_72147_73152 = state_72133__$1;
(statearr_72147_73152[(2)] = null);

(statearr_72147_73152[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72134 === (10))){
var inst_72125 = (state_72133[(2)]);
var state_72133__$1 = state_72133;
var statearr_72148_73153 = state_72133__$1;
(statearr_72148_73153[(2)] = inst_72125);

(statearr_72148_73153[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72134 === (8))){
var inst_72115 = (state_72133[(7)]);
var state_72133__$1 = state_72133;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72133__$1,(11),out,inst_72115);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_72149 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72149[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_72149[(1)] = (1));

return statearr_72149;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_72133){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_72133);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e72150){var ex__70867__auto__ = e72150;
var statearr_72151_73154 = state_72133;
(statearr_72151_73154[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_72133[(4)]))){
var statearr_72152_73155 = state_72133;
(statearr_72152_73155[(1)] = cljs.core.first((state_72133[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73156 = state_72133;
state_72133 = G__73156;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_72133){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_72133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_72153 = f__70900__auto__();
(statearr_72153[(6)] = c__70899__auto___73136);

return statearr_72153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72155 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72155 = (function (f,ch,meta72156){
this.f = f;
this.ch = ch;
this.meta72156 = meta72156;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72157,meta72156__$1){
var self__ = this;
var _72157__$1 = this;
return (new cljs.core.async.t_cljs$core$async72155(self__.f,self__.ch,meta72156__$1));
}));

(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72157){
var self__ = this;
var _72157__$1 = this;
return self__.meta72156;
}));

(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72158 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72158 = (function (f,ch,meta72156,_,fn1,meta72159){
this.f = f;
this.ch = ch;
this.meta72156 = meta72156;
this._ = _;
this.fn1 = fn1;
this.meta72159 = meta72159;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72158.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72160,meta72159__$1){
var self__ = this;
var _72160__$1 = this;
return (new cljs.core.async.t_cljs$core$async72158(self__.f,self__.ch,self__.meta72156,self__._,self__.fn1,meta72159__$1));
}));

(cljs.core.async.t_cljs$core$async72158.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72160){
var self__ = this;
var _72160__$1 = this;
return self__.meta72159;
}));

(cljs.core.async.t_cljs$core$async72158.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72158.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async72158.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async72158.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__72154_SHARP_){
var G__72161 = (((p1__72154_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__72154_SHARP_) : self__.f.call(null,p1__72154_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__72161) : f1.call(null,G__72161));
});
}));

(cljs.core.async.t_cljs$core$async72158.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72156","meta72156",1054972810,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async72155","cljs.core.async/t_cljs$core$async72155",-410134541,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta72159","meta72159",1951473697,null)], null);
}));

(cljs.core.async.t_cljs$core$async72158.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72158.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72158");

(cljs.core.async.t_cljs$core$async72158.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72158");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72158.
 */
cljs.core.async.__GT_t_cljs$core$async72158 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async72158(f__$1,ch__$1,meta72156__$1,___$2,fn1__$1,meta72159){
return (new cljs.core.async.t_cljs$core$async72158(f__$1,ch__$1,meta72156__$1,___$2,fn1__$1,meta72159));
});

}

return (new cljs.core.async.t_cljs$core$async72158(self__.f,self__.ch,self__.meta72156,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4109__auto__ = ret;
if(cljs.core.truth_(and__4109__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4109__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__72162 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__72162) : self__.f.call(null,G__72162));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72155.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async72155.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72156","meta72156",1054972810,null)], null);
}));

(cljs.core.async.t_cljs$core$async72155.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72155.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72155");

(cljs.core.async.t_cljs$core$async72155.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72155");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72155.
 */
cljs.core.async.__GT_t_cljs$core$async72155 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async72155(f__$1,ch__$1,meta72156){
return (new cljs.core.async.t_cljs$core$async72155(f__$1,ch__$1,meta72156));
});

}

return (new cljs.core.async.t_cljs$core$async72155(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72163 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72163 = (function (f,ch,meta72164){
this.f = f;
this.ch = ch;
this.meta72164 = meta72164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72165,meta72164__$1){
var self__ = this;
var _72165__$1 = this;
return (new cljs.core.async.t_cljs$core$async72163(self__.f,self__.ch,meta72164__$1));
}));

(cljs.core.async.t_cljs$core$async72163.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72165){
var self__ = this;
var _72165__$1 = this;
return self__.meta72164;
}));

(cljs.core.async.t_cljs$core$async72163.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72163.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72163.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72163.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async72163.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72163.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async72163.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72164","meta72164",-354912546,null)], null);
}));

(cljs.core.async.t_cljs$core$async72163.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72163.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72163");

(cljs.core.async.t_cljs$core$async72163.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72163");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72163.
 */
cljs.core.async.__GT_t_cljs$core$async72163 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async72163(f__$1,ch__$1,meta72164){
return (new cljs.core.async.t_cljs$core$async72163(f__$1,ch__$1,meta72164));
});

}

return (new cljs.core.async.t_cljs$core$async72163(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async72166 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72166 = (function (p,ch,meta72167){
this.p = p;
this.ch = ch;
this.meta72167 = meta72167;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72168,meta72167__$1){
var self__ = this;
var _72168__$1 = this;
return (new cljs.core.async.t_cljs$core$async72166(self__.p,self__.ch,meta72167__$1));
}));

(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72168){
var self__ = this;
var _72168__$1 = this;
return self__.meta72167;
}));

(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async72166.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async72166.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72167","meta72167",-1019509000,null)], null);
}));

(cljs.core.async.t_cljs$core$async72166.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async72166.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72166");

(cljs.core.async.t_cljs$core$async72166.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"cljs.core.async/t_cljs$core$async72166");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async72166.
 */
cljs.core.async.__GT_t_cljs$core$async72166 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async72166(p__$1,ch__$1,meta72167){
return (new cljs.core.async.t_cljs$core$async72166(p__$1,ch__$1,meta72167));
});

}

return (new cljs.core.async.t_cljs$core$async72166(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__72170 = arguments.length;
switch (G__72170) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70899__auto___73162 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_72191){
var state_val_72192 = (state_72191[(1)]);
if((state_val_72192 === (7))){
var inst_72187 = (state_72191[(2)]);
var state_72191__$1 = state_72191;
var statearr_72193_73163 = state_72191__$1;
(statearr_72193_73163[(2)] = inst_72187);

(statearr_72193_73163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72192 === (1))){
var state_72191__$1 = state_72191;
var statearr_72194_73164 = state_72191__$1;
(statearr_72194_73164[(2)] = null);

(statearr_72194_73164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72192 === (4))){
var inst_72173 = (state_72191[(7)]);
var inst_72173__$1 = (state_72191[(2)]);
var inst_72174 = (inst_72173__$1 == null);
var state_72191__$1 = (function (){var statearr_72195 = state_72191;
(statearr_72195[(7)] = inst_72173__$1);

return statearr_72195;
})();
if(cljs.core.truth_(inst_72174)){
var statearr_72196_73165 = state_72191__$1;
(statearr_72196_73165[(1)] = (5));

} else {
var statearr_72197_73166 = state_72191__$1;
(statearr_72197_73166[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72192 === (6))){
var inst_72173 = (state_72191[(7)]);
var inst_72178 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_72173) : p.call(null,inst_72173));
var state_72191__$1 = state_72191;
if(cljs.core.truth_(inst_72178)){
var statearr_72198_73167 = state_72191__$1;
(statearr_72198_73167[(1)] = (8));

} else {
var statearr_72199_73168 = state_72191__$1;
(statearr_72199_73168[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72192 === (3))){
var inst_72189 = (state_72191[(2)]);
var state_72191__$1 = state_72191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72191__$1,inst_72189);
} else {
if((state_val_72192 === (2))){
var state_72191__$1 = state_72191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72191__$1,(4),ch);
} else {
if((state_val_72192 === (11))){
var inst_72181 = (state_72191[(2)]);
var state_72191__$1 = state_72191;
var statearr_72200_73169 = state_72191__$1;
(statearr_72200_73169[(2)] = inst_72181);

(statearr_72200_73169[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72192 === (9))){
var state_72191__$1 = state_72191;
var statearr_72201_73170 = state_72191__$1;
(statearr_72201_73170[(2)] = null);

(statearr_72201_73170[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72192 === (5))){
var inst_72176 = cljs.core.async.close_BANG_(out);
var state_72191__$1 = state_72191;
var statearr_72202_73171 = state_72191__$1;
(statearr_72202_73171[(2)] = inst_72176);

(statearr_72202_73171[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72192 === (10))){
var inst_72184 = (state_72191[(2)]);
var state_72191__$1 = (function (){var statearr_72203 = state_72191;
(statearr_72203[(8)] = inst_72184);

return statearr_72203;
})();
var statearr_72204_73173 = state_72191__$1;
(statearr_72204_73173[(2)] = null);

(statearr_72204_73173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72192 === (8))){
var inst_72173 = (state_72191[(7)]);
var state_72191__$1 = state_72191;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72191__$1,(11),out,inst_72173);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_72205 = [null,null,null,null,null,null,null,null,null];
(statearr_72205[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_72205[(1)] = (1));

return statearr_72205;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_72191){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_72191);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e72206){var ex__70867__auto__ = e72206;
var statearr_72207_73175 = state_72191;
(statearr_72207_73175[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_72191[(4)]))){
var statearr_72208_73176 = state_72191;
(statearr_72208_73176[(1)] = cljs.core.first((state_72191[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73177 = state_72191;
state_72191 = G__73177;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_72191){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_72191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_72209 = f__70900__auto__();
(statearr_72209[(6)] = c__70899__auto___73162);

return statearr_72209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__72211 = arguments.length;
switch (G__72211) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__70899__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_72273){
var state_val_72274 = (state_72273[(1)]);
if((state_val_72274 === (7))){
var inst_72269 = (state_72273[(2)]);
var state_72273__$1 = state_72273;
var statearr_72275_73179 = state_72273__$1;
(statearr_72275_73179[(2)] = inst_72269);

(statearr_72275_73179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (20))){
var inst_72239 = (state_72273[(7)]);
var inst_72250 = (state_72273[(2)]);
var inst_72251 = cljs.core.next(inst_72239);
var inst_72225 = inst_72251;
var inst_72226 = null;
var inst_72227 = (0);
var inst_72228 = (0);
var state_72273__$1 = (function (){var statearr_72276 = state_72273;
(statearr_72276[(8)] = inst_72227);

(statearr_72276[(9)] = inst_72226);

(statearr_72276[(10)] = inst_72250);

(statearr_72276[(11)] = inst_72228);

(statearr_72276[(12)] = inst_72225);

return statearr_72276;
})();
var statearr_72277_73180 = state_72273__$1;
(statearr_72277_73180[(2)] = null);

(statearr_72277_73180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (1))){
var state_72273__$1 = state_72273;
var statearr_72278_73181 = state_72273__$1;
(statearr_72278_73181[(2)] = null);

(statearr_72278_73181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (4))){
var inst_72214 = (state_72273[(13)]);
var inst_72214__$1 = (state_72273[(2)]);
var inst_72215 = (inst_72214__$1 == null);
var state_72273__$1 = (function (){var statearr_72279 = state_72273;
(statearr_72279[(13)] = inst_72214__$1);

return statearr_72279;
})();
if(cljs.core.truth_(inst_72215)){
var statearr_72280_73182 = state_72273__$1;
(statearr_72280_73182[(1)] = (5));

} else {
var statearr_72281_73183 = state_72273__$1;
(statearr_72281_73183[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (15))){
var state_72273__$1 = state_72273;
var statearr_72285_73184 = state_72273__$1;
(statearr_72285_73184[(2)] = null);

(statearr_72285_73184[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (21))){
var state_72273__$1 = state_72273;
var statearr_72286_73185 = state_72273__$1;
(statearr_72286_73185[(2)] = null);

(statearr_72286_73185[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (13))){
var inst_72227 = (state_72273[(8)]);
var inst_72226 = (state_72273[(9)]);
var inst_72228 = (state_72273[(11)]);
var inst_72225 = (state_72273[(12)]);
var inst_72235 = (state_72273[(2)]);
var inst_72236 = (inst_72228 + (1));
var tmp72282 = inst_72227;
var tmp72283 = inst_72226;
var tmp72284 = inst_72225;
var inst_72225__$1 = tmp72284;
var inst_72226__$1 = tmp72283;
var inst_72227__$1 = tmp72282;
var inst_72228__$1 = inst_72236;
var state_72273__$1 = (function (){var statearr_72287 = state_72273;
(statearr_72287[(8)] = inst_72227__$1);

(statearr_72287[(9)] = inst_72226__$1);

(statearr_72287[(14)] = inst_72235);

(statearr_72287[(11)] = inst_72228__$1);

(statearr_72287[(12)] = inst_72225__$1);

return statearr_72287;
})();
var statearr_72288_73186 = state_72273__$1;
(statearr_72288_73186[(2)] = null);

(statearr_72288_73186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (22))){
var state_72273__$1 = state_72273;
var statearr_72289_73187 = state_72273__$1;
(statearr_72289_73187[(2)] = null);

(statearr_72289_73187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (6))){
var inst_72214 = (state_72273[(13)]);
var inst_72223 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_72214) : f.call(null,inst_72214));
var inst_72224 = cljs.core.seq(inst_72223);
var inst_72225 = inst_72224;
var inst_72226 = null;
var inst_72227 = (0);
var inst_72228 = (0);
var state_72273__$1 = (function (){var statearr_72290 = state_72273;
(statearr_72290[(8)] = inst_72227);

(statearr_72290[(9)] = inst_72226);

(statearr_72290[(11)] = inst_72228);

(statearr_72290[(12)] = inst_72225);

return statearr_72290;
})();
var statearr_72291_73188 = state_72273__$1;
(statearr_72291_73188[(2)] = null);

(statearr_72291_73188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (17))){
var inst_72239 = (state_72273[(7)]);
var inst_72243 = cljs.core.chunk_first(inst_72239);
var inst_72244 = cljs.core.chunk_rest(inst_72239);
var inst_72245 = cljs.core.count(inst_72243);
var inst_72225 = inst_72244;
var inst_72226 = inst_72243;
var inst_72227 = inst_72245;
var inst_72228 = (0);
var state_72273__$1 = (function (){var statearr_72292 = state_72273;
(statearr_72292[(8)] = inst_72227);

(statearr_72292[(9)] = inst_72226);

(statearr_72292[(11)] = inst_72228);

(statearr_72292[(12)] = inst_72225);

return statearr_72292;
})();
var statearr_72293_73189 = state_72273__$1;
(statearr_72293_73189[(2)] = null);

(statearr_72293_73189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (3))){
var inst_72271 = (state_72273[(2)]);
var state_72273__$1 = state_72273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72273__$1,inst_72271);
} else {
if((state_val_72274 === (12))){
var inst_72259 = (state_72273[(2)]);
var state_72273__$1 = state_72273;
var statearr_72294_73190 = state_72273__$1;
(statearr_72294_73190[(2)] = inst_72259);

(statearr_72294_73190[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (2))){
var state_72273__$1 = state_72273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72273__$1,(4),in$);
} else {
if((state_val_72274 === (23))){
var inst_72267 = (state_72273[(2)]);
var state_72273__$1 = state_72273;
var statearr_72295_73191 = state_72273__$1;
(statearr_72295_73191[(2)] = inst_72267);

(statearr_72295_73191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (19))){
var inst_72254 = (state_72273[(2)]);
var state_72273__$1 = state_72273;
var statearr_72296_73192 = state_72273__$1;
(statearr_72296_73192[(2)] = inst_72254);

(statearr_72296_73192[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (11))){
var inst_72239 = (state_72273[(7)]);
var inst_72225 = (state_72273[(12)]);
var inst_72239__$1 = cljs.core.seq(inst_72225);
var state_72273__$1 = (function (){var statearr_72297 = state_72273;
(statearr_72297[(7)] = inst_72239__$1);

return statearr_72297;
})();
if(inst_72239__$1){
var statearr_72298_73193 = state_72273__$1;
(statearr_72298_73193[(1)] = (14));

} else {
var statearr_72299_73194 = state_72273__$1;
(statearr_72299_73194[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (9))){
var inst_72261 = (state_72273[(2)]);
var inst_72262 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_72273__$1 = (function (){var statearr_72300 = state_72273;
(statearr_72300[(15)] = inst_72261);

return statearr_72300;
})();
if(cljs.core.truth_(inst_72262)){
var statearr_72301_73195 = state_72273__$1;
(statearr_72301_73195[(1)] = (21));

} else {
var statearr_72302_73196 = state_72273__$1;
(statearr_72302_73196[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (5))){
var inst_72217 = cljs.core.async.close_BANG_(out);
var state_72273__$1 = state_72273;
var statearr_72303_73197 = state_72273__$1;
(statearr_72303_73197[(2)] = inst_72217);

(statearr_72303_73197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (14))){
var inst_72239 = (state_72273[(7)]);
var inst_72241 = cljs.core.chunked_seq_QMARK_(inst_72239);
var state_72273__$1 = state_72273;
if(inst_72241){
var statearr_72304_73198 = state_72273__$1;
(statearr_72304_73198[(1)] = (17));

} else {
var statearr_72305_73199 = state_72273__$1;
(statearr_72305_73199[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (16))){
var inst_72257 = (state_72273[(2)]);
var state_72273__$1 = state_72273;
var statearr_72306_73200 = state_72273__$1;
(statearr_72306_73200[(2)] = inst_72257);

(statearr_72306_73200[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72274 === (10))){
var inst_72226 = (state_72273[(9)]);
var inst_72228 = (state_72273[(11)]);
var inst_72233 = cljs.core._nth(inst_72226,inst_72228);
var state_72273__$1 = state_72273;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72273__$1,(13),out,inst_72233);
} else {
if((state_val_72274 === (18))){
var inst_72239 = (state_72273[(7)]);
var inst_72248 = cljs.core.first(inst_72239);
var state_72273__$1 = state_72273;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72273__$1,(20),out,inst_72248);
} else {
if((state_val_72274 === (8))){
var inst_72227 = (state_72273[(8)]);
var inst_72228 = (state_72273[(11)]);
var inst_72230 = (inst_72228 < inst_72227);
var inst_72231 = inst_72230;
var state_72273__$1 = state_72273;
if(cljs.core.truth_(inst_72231)){
var statearr_72307_73201 = state_72273__$1;
(statearr_72307_73201[(1)] = (10));

} else {
var statearr_72308_73202 = state_72273__$1;
(statearr_72308_73202[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__70864__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__70864__auto____0 = (function (){
var statearr_72309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72309[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__70864__auto__);

(statearr_72309[(1)] = (1));

return statearr_72309;
});
var cljs$core$async$mapcat_STAR__$_state_machine__70864__auto____1 = (function (state_72273){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_72273);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e72310){var ex__70867__auto__ = e72310;
var statearr_72311_73203 = state_72273;
(statearr_72311_73203[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_72273[(4)]))){
var statearr_72312_73204 = state_72273;
(statearr_72312_73204[(1)] = cljs.core.first((state_72273[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73205 = state_72273;
state_72273 = G__73205;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__70864__auto__ = function(state_72273){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__70864__auto____1.call(this,state_72273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__70864__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__70864__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_72313 = f__70900__auto__();
(statearr_72313[(6)] = c__70899__auto__);

return statearr_72313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));

return c__70899__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__72315 = arguments.length;
switch (G__72315) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__72317 = arguments.length;
switch (G__72317) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__72319 = arguments.length;
switch (G__72319) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70899__auto___73209 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_72343){
var state_val_72344 = (state_72343[(1)]);
if((state_val_72344 === (7))){
var inst_72338 = (state_72343[(2)]);
var state_72343__$1 = state_72343;
var statearr_72345_73210 = state_72343__$1;
(statearr_72345_73210[(2)] = inst_72338);

(statearr_72345_73210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72344 === (1))){
var inst_72320 = null;
var state_72343__$1 = (function (){var statearr_72346 = state_72343;
(statearr_72346[(7)] = inst_72320);

return statearr_72346;
})();
var statearr_72347_73212 = state_72343__$1;
(statearr_72347_73212[(2)] = null);

(statearr_72347_73212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72344 === (4))){
var inst_72323 = (state_72343[(8)]);
var inst_72323__$1 = (state_72343[(2)]);
var inst_72324 = (inst_72323__$1 == null);
var inst_72325 = cljs.core.not(inst_72324);
var state_72343__$1 = (function (){var statearr_72348 = state_72343;
(statearr_72348[(8)] = inst_72323__$1);

return statearr_72348;
})();
if(inst_72325){
var statearr_72349_73214 = state_72343__$1;
(statearr_72349_73214[(1)] = (5));

} else {
var statearr_72350_73215 = state_72343__$1;
(statearr_72350_73215[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72344 === (6))){
var state_72343__$1 = state_72343;
var statearr_72351_73216 = state_72343__$1;
(statearr_72351_73216[(2)] = null);

(statearr_72351_73216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72344 === (3))){
var inst_72340 = (state_72343[(2)]);
var inst_72341 = cljs.core.async.close_BANG_(out);
var state_72343__$1 = (function (){var statearr_72352 = state_72343;
(statearr_72352[(9)] = inst_72340);

return statearr_72352;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72343__$1,inst_72341);
} else {
if((state_val_72344 === (2))){
var state_72343__$1 = state_72343;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72343__$1,(4),ch);
} else {
if((state_val_72344 === (11))){
var inst_72323 = (state_72343[(8)]);
var inst_72332 = (state_72343[(2)]);
var inst_72320 = inst_72323;
var state_72343__$1 = (function (){var statearr_72353 = state_72343;
(statearr_72353[(10)] = inst_72332);

(statearr_72353[(7)] = inst_72320);

return statearr_72353;
})();
var statearr_72354_73220 = state_72343__$1;
(statearr_72354_73220[(2)] = null);

(statearr_72354_73220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72344 === (9))){
var inst_72323 = (state_72343[(8)]);
var state_72343__$1 = state_72343;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72343__$1,(11),out,inst_72323);
} else {
if((state_val_72344 === (5))){
var inst_72323 = (state_72343[(8)]);
var inst_72320 = (state_72343[(7)]);
var inst_72327 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72323,inst_72320);
var state_72343__$1 = state_72343;
if(inst_72327){
var statearr_72356_73221 = state_72343__$1;
(statearr_72356_73221[(1)] = (8));

} else {
var statearr_72357_73222 = state_72343__$1;
(statearr_72357_73222[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72344 === (10))){
var inst_72335 = (state_72343[(2)]);
var state_72343__$1 = state_72343;
var statearr_72358_73224 = state_72343__$1;
(statearr_72358_73224[(2)] = inst_72335);

(statearr_72358_73224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72344 === (8))){
var inst_72320 = (state_72343[(7)]);
var tmp72355 = inst_72320;
var inst_72320__$1 = tmp72355;
var state_72343__$1 = (function (){var statearr_72359 = state_72343;
(statearr_72359[(7)] = inst_72320__$1);

return statearr_72359;
})();
var statearr_72360_73225 = state_72343__$1;
(statearr_72360_73225[(2)] = null);

(statearr_72360_73225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_72361 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72361[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_72361[(1)] = (1));

return statearr_72361;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_72343){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_72343);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e72362){var ex__70867__auto__ = e72362;
var statearr_72363_73226 = state_72343;
(statearr_72363_73226[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_72343[(4)]))){
var statearr_72364_73227 = state_72343;
(statearr_72364_73227[(1)] = cljs.core.first((state_72343[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73228 = state_72343;
state_72343 = G__73228;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_72343){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_72343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_72365 = f__70900__auto__();
(statearr_72365[(6)] = c__70899__auto___73209);

return statearr_72365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__72367 = arguments.length;
switch (G__72367) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70899__auto___73230 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_72405){
var state_val_72406 = (state_72405[(1)]);
if((state_val_72406 === (7))){
var inst_72401 = (state_72405[(2)]);
var state_72405__$1 = state_72405;
var statearr_72407_73231 = state_72405__$1;
(statearr_72407_73231[(2)] = inst_72401);

(statearr_72407_73231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (1))){
var inst_72368 = (new Array(n));
var inst_72369 = inst_72368;
var inst_72370 = (0);
var state_72405__$1 = (function (){var statearr_72408 = state_72405;
(statearr_72408[(7)] = inst_72369);

(statearr_72408[(8)] = inst_72370);

return statearr_72408;
})();
var statearr_72409_73235 = state_72405__$1;
(statearr_72409_73235[(2)] = null);

(statearr_72409_73235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (4))){
var inst_72373 = (state_72405[(9)]);
var inst_72373__$1 = (state_72405[(2)]);
var inst_72374 = (inst_72373__$1 == null);
var inst_72375 = cljs.core.not(inst_72374);
var state_72405__$1 = (function (){var statearr_72410 = state_72405;
(statearr_72410[(9)] = inst_72373__$1);

return statearr_72410;
})();
if(inst_72375){
var statearr_72411_73236 = state_72405__$1;
(statearr_72411_73236[(1)] = (5));

} else {
var statearr_72412_73237 = state_72405__$1;
(statearr_72412_73237[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (15))){
var inst_72395 = (state_72405[(2)]);
var state_72405__$1 = state_72405;
var statearr_72413_73238 = state_72405__$1;
(statearr_72413_73238[(2)] = inst_72395);

(statearr_72413_73238[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (13))){
var state_72405__$1 = state_72405;
var statearr_72414_73239 = state_72405__$1;
(statearr_72414_73239[(2)] = null);

(statearr_72414_73239[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (6))){
var inst_72370 = (state_72405[(8)]);
var inst_72391 = (inst_72370 > (0));
var state_72405__$1 = state_72405;
if(cljs.core.truth_(inst_72391)){
var statearr_72415_73240 = state_72405__$1;
(statearr_72415_73240[(1)] = (12));

} else {
var statearr_72416_73242 = state_72405__$1;
(statearr_72416_73242[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (3))){
var inst_72403 = (state_72405[(2)]);
var state_72405__$1 = state_72405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72405__$1,inst_72403);
} else {
if((state_val_72406 === (12))){
var inst_72369 = (state_72405[(7)]);
var inst_72393 = cljs.core.vec(inst_72369);
var state_72405__$1 = state_72405;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72405__$1,(15),out,inst_72393);
} else {
if((state_val_72406 === (2))){
var state_72405__$1 = state_72405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72405__$1,(4),ch);
} else {
if((state_val_72406 === (11))){
var inst_72385 = (state_72405[(2)]);
var inst_72386 = (new Array(n));
var inst_72369 = inst_72386;
var inst_72370 = (0);
var state_72405__$1 = (function (){var statearr_72417 = state_72405;
(statearr_72417[(7)] = inst_72369);

(statearr_72417[(10)] = inst_72385);

(statearr_72417[(8)] = inst_72370);

return statearr_72417;
})();
var statearr_72418_73244 = state_72405__$1;
(statearr_72418_73244[(2)] = null);

(statearr_72418_73244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (9))){
var inst_72369 = (state_72405[(7)]);
var inst_72383 = cljs.core.vec(inst_72369);
var state_72405__$1 = state_72405;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72405__$1,(11),out,inst_72383);
} else {
if((state_val_72406 === (5))){
var inst_72369 = (state_72405[(7)]);
var inst_72378 = (state_72405[(11)]);
var inst_72373 = (state_72405[(9)]);
var inst_72370 = (state_72405[(8)]);
var inst_72377 = (inst_72369[inst_72370] = inst_72373);
var inst_72378__$1 = (inst_72370 + (1));
var inst_72379 = (inst_72378__$1 < n);
var state_72405__$1 = (function (){var statearr_72419 = state_72405;
(statearr_72419[(11)] = inst_72378__$1);

(statearr_72419[(12)] = inst_72377);

return statearr_72419;
})();
if(cljs.core.truth_(inst_72379)){
var statearr_72420_73248 = state_72405__$1;
(statearr_72420_73248[(1)] = (8));

} else {
var statearr_72421_73249 = state_72405__$1;
(statearr_72421_73249[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (14))){
var inst_72398 = (state_72405[(2)]);
var inst_72399 = cljs.core.async.close_BANG_(out);
var state_72405__$1 = (function (){var statearr_72423 = state_72405;
(statearr_72423[(13)] = inst_72398);

return statearr_72423;
})();
var statearr_72424_73251 = state_72405__$1;
(statearr_72424_73251[(2)] = inst_72399);

(statearr_72424_73251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (10))){
var inst_72389 = (state_72405[(2)]);
var state_72405__$1 = state_72405;
var statearr_72425_73252 = state_72405__$1;
(statearr_72425_73252[(2)] = inst_72389);

(statearr_72425_73252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72406 === (8))){
var inst_72369 = (state_72405[(7)]);
var inst_72378 = (state_72405[(11)]);
var tmp72422 = inst_72369;
var inst_72369__$1 = tmp72422;
var inst_72370 = inst_72378;
var state_72405__$1 = (function (){var statearr_72426 = state_72405;
(statearr_72426[(7)] = inst_72369__$1);

(statearr_72426[(8)] = inst_72370);

return statearr_72426;
})();
var statearr_72427_73253 = state_72405__$1;
(statearr_72427_73253[(2)] = null);

(statearr_72427_73253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_72428 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72428[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_72428[(1)] = (1));

return statearr_72428;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_72405){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_72405);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e72429){var ex__70867__auto__ = e72429;
var statearr_72430_73254 = state_72405;
(statearr_72430_73254[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_72405[(4)]))){
var statearr_72431_73255 = state_72405;
(statearr_72431_73255[(1)] = cljs.core.first((state_72405[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73256 = state_72405;
state_72405 = G__73256;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_72405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_72405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_72432 = f__70900__auto__();
(statearr_72432[(6)] = c__70899__auto___73230);

return statearr_72432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__72434 = arguments.length;
switch (G__72434) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__70899__auto___73258 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_72476){
var state_val_72477 = (state_72476[(1)]);
if((state_val_72477 === (7))){
var inst_72472 = (state_72476[(2)]);
var state_72476__$1 = state_72476;
var statearr_72478_73262 = state_72476__$1;
(statearr_72478_73262[(2)] = inst_72472);

(statearr_72478_73262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (1))){
var inst_72435 = [];
var inst_72436 = inst_72435;
var inst_72437 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_72476__$1 = (function (){var statearr_72479 = state_72476;
(statearr_72479[(7)] = inst_72437);

(statearr_72479[(8)] = inst_72436);

return statearr_72479;
})();
var statearr_72480_73263 = state_72476__$1;
(statearr_72480_73263[(2)] = null);

(statearr_72480_73263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (4))){
var inst_72440 = (state_72476[(9)]);
var inst_72440__$1 = (state_72476[(2)]);
var inst_72441 = (inst_72440__$1 == null);
var inst_72442 = cljs.core.not(inst_72441);
var state_72476__$1 = (function (){var statearr_72481 = state_72476;
(statearr_72481[(9)] = inst_72440__$1);

return statearr_72481;
})();
if(inst_72442){
var statearr_72482_73264 = state_72476__$1;
(statearr_72482_73264[(1)] = (5));

} else {
var statearr_72483_73265 = state_72476__$1;
(statearr_72483_73265[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (15))){
var inst_72466 = (state_72476[(2)]);
var state_72476__$1 = state_72476;
var statearr_72484_73266 = state_72476__$1;
(statearr_72484_73266[(2)] = inst_72466);

(statearr_72484_73266[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (13))){
var state_72476__$1 = state_72476;
var statearr_72485_73267 = state_72476__$1;
(statearr_72485_73267[(2)] = null);

(statearr_72485_73267[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (6))){
var inst_72436 = (state_72476[(8)]);
var inst_72461 = inst_72436.length;
var inst_72462 = (inst_72461 > (0));
var state_72476__$1 = state_72476;
if(cljs.core.truth_(inst_72462)){
var statearr_72486_73268 = state_72476__$1;
(statearr_72486_73268[(1)] = (12));

} else {
var statearr_72487_73269 = state_72476__$1;
(statearr_72487_73269[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (3))){
var inst_72474 = (state_72476[(2)]);
var state_72476__$1 = state_72476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72476__$1,inst_72474);
} else {
if((state_val_72477 === (12))){
var inst_72436 = (state_72476[(8)]);
var inst_72464 = cljs.core.vec(inst_72436);
var state_72476__$1 = state_72476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72476__$1,(15),out,inst_72464);
} else {
if((state_val_72477 === (2))){
var state_72476__$1 = state_72476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72476__$1,(4),ch);
} else {
if((state_val_72477 === (11))){
var inst_72444 = (state_72476[(10)]);
var inst_72440 = (state_72476[(9)]);
var inst_72454 = (state_72476[(2)]);
var inst_72455 = [];
var inst_72456 = inst_72455.push(inst_72440);
var inst_72436 = inst_72455;
var inst_72437 = inst_72444;
var state_72476__$1 = (function (){var statearr_72488 = state_72476;
(statearr_72488[(7)] = inst_72437);

(statearr_72488[(11)] = inst_72454);

(statearr_72488[(8)] = inst_72436);

(statearr_72488[(12)] = inst_72456);

return statearr_72488;
})();
var statearr_72489_73270 = state_72476__$1;
(statearr_72489_73270[(2)] = null);

(statearr_72489_73270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (9))){
var inst_72436 = (state_72476[(8)]);
var inst_72452 = cljs.core.vec(inst_72436);
var state_72476__$1 = state_72476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_72476__$1,(11),out,inst_72452);
} else {
if((state_val_72477 === (5))){
var inst_72437 = (state_72476[(7)]);
var inst_72444 = (state_72476[(10)]);
var inst_72440 = (state_72476[(9)]);
var inst_72444__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_72440) : f.call(null,inst_72440));
var inst_72445 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72444__$1,inst_72437);
var inst_72446 = cljs.core.keyword_identical_QMARK_(inst_72437,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_72447 = ((inst_72445) || (inst_72446));
var state_72476__$1 = (function (){var statearr_72490 = state_72476;
(statearr_72490[(10)] = inst_72444__$1);

return statearr_72490;
})();
if(cljs.core.truth_(inst_72447)){
var statearr_72491_73271 = state_72476__$1;
(statearr_72491_73271[(1)] = (8));

} else {
var statearr_72492_73272 = state_72476__$1;
(statearr_72492_73272[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (14))){
var inst_72469 = (state_72476[(2)]);
var inst_72470 = cljs.core.async.close_BANG_(out);
var state_72476__$1 = (function (){var statearr_72494 = state_72476;
(statearr_72494[(13)] = inst_72469);

return statearr_72494;
})();
var statearr_72495_73273 = state_72476__$1;
(statearr_72495_73273[(2)] = inst_72470);

(statearr_72495_73273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (10))){
var inst_72459 = (state_72476[(2)]);
var state_72476__$1 = state_72476;
var statearr_72496_73274 = state_72476__$1;
(statearr_72496_73274[(2)] = inst_72459);

(statearr_72496_73274[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72477 === (8))){
var inst_72444 = (state_72476[(10)]);
var inst_72436 = (state_72476[(8)]);
var inst_72440 = (state_72476[(9)]);
var inst_72449 = inst_72436.push(inst_72440);
var tmp72493 = inst_72436;
var inst_72436__$1 = tmp72493;
var inst_72437 = inst_72444;
var state_72476__$1 = (function (){var statearr_72497 = state_72476;
(statearr_72497[(14)] = inst_72449);

(statearr_72497[(7)] = inst_72437);

(statearr_72497[(8)] = inst_72436__$1);

return statearr_72497;
})();
var statearr_72498_73275 = state_72476__$1;
(statearr_72498_73275[(2)] = null);

(statearr_72498_73275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__70864__auto__ = null;
var cljs$core$async$state_machine__70864__auto____0 = (function (){
var statearr_72499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72499[(0)] = cljs$core$async$state_machine__70864__auto__);

(statearr_72499[(1)] = (1));

return statearr_72499;
});
var cljs$core$async$state_machine__70864__auto____1 = (function (state_72476){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_72476);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e72500){var ex__70867__auto__ = e72500;
var statearr_72501_73278 = state_72476;
(statearr_72501_73278[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_72476[(4)]))){
var statearr_72502_73280 = state_72476;
(statearr_72502_73280[(1)] = cljs.core.first((state_72476[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73281 = state_72476;
state_72476 = G__73281;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
cljs$core$async$state_machine__70864__auto__ = function(state_72476){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70864__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70864__auto____1.call(this,state_72476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70864__auto____0;
cljs$core$async$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70864__auto____1;
return cljs$core$async$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_72503 = f__70900__auto__();
(statearr_72503[(6)] = c__70899__auto___73258);

return statearr_72503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
