goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__74962__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__74962 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__74963__i = 0, G__74963__a = new Array(arguments.length -  0);
while (G__74963__i < G__74963__a.length) {G__74963__a[G__74963__i] = arguments[G__74963__i + 0]; ++G__74963__i;}
  args = new cljs.core.IndexedSeq(G__74963__a,0,null);
} 
return G__74962__delegate.call(this,args);};
G__74962.cljs$lang$maxFixedArity = 0;
G__74962.cljs$lang$applyTo = (function (arglist__74964){
var args = cljs.core.seq(arglist__74964);
return G__74962__delegate(args);
});
G__74962.cljs$core$IFn$_invoke$arity$variadic = G__74962__delegate;
return G__74962;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74965 = arguments.length;
var i__4731__auto___74966 = (0);
while(true){
if((i__4731__auto___74966 < len__4730__auto___74965)){
args__4736__auto__.push((arguments[i__4731__auto___74966]));

var G__74967 = (i__4731__auto___74966 + (1));
i__4731__auto___74966 = G__74967;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq74630){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq74630));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__74631 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74632 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__74631,G__74632) : com.rpl.specter.compiled_select.call(null,G__74631,G__74632));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__74633 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74634 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__74633,G__74634) : com.rpl.specter.compiled_select_one.call(null,G__74633,G__74634));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__74635 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74636 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__74635,G__74636) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__74635,G__74636));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__74637 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74638 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__74637,G__74638) : com.rpl.specter.compiled_select_first.call(null,G__74637,G__74638));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__74639 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74640 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__74639,G__74640) : com.rpl.specter.compiled_select_any.call(null,G__74639,G__74640));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__74642 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74643 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__74642,G__74643) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__74642,G__74643));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__74644 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__74645 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__74644,G__74645) : com.rpl.specter.compiled_traverse.call(null,G__74644,G__74645));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__74646 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__74646) : com.rpl.specter.compiled_traverse_all.call(null,G__74646));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__74647 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74648 = transform_fn;
var G__74649 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__74647,G__74648,G__74649) : com.rpl.specter.compiled_transform.call(null,G__74647,G__74648,G__74649));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__74650 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74651 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__74650,G__74651) : com.rpl.specter.compiled_multi_transform.call(null,G__74650,G__74651));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__74652 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74653 = val;
var G__74654 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__74652,G__74653,G__74654) : com.rpl.specter.compiled_setval.call(null,G__74652,G__74653,G__74654));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74968 = arguments.length;
var i__4731__auto___74969 = (0);
while(true){
if((i__4731__auto___74969 < len__4730__auto___74968)){
args__4736__auto__.push((arguments[i__4731__auto___74969]));

var G__74970 = (i__4731__auto___74969 + (1));
i__4731__auto___74969 = G__74970;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__74659){
var map__74660 = p__74659;
var map__74660__$1 = (((((!((map__74660 == null))))?(((((map__74660.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74660.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__74660):map__74660);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74660__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__74662 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74663 = transform_fn;
var G__74664 = structure;
var G__74665 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__74666 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__74662,G__74663,G__74664,G__74665,G__74666) : com.rpl.specter.compiled_replace_in.call(null,G__74662,G__74663,G__74664,G__74665,G__74666));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq74655){
var G__74656 = cljs.core.first(seq74655);
var seq74655__$1 = cljs.core.next(seq74655);
var G__74657 = cljs.core.first(seq74655__$1);
var seq74655__$2 = cljs.core.next(seq74655__$1);
var G__74658 = cljs.core.first(seq74655__$2);
var seq74655__$3 = cljs.core.next(seq74655__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74656,G__74657,G__74658,seq74655__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74971__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__74971 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__74972__i = 0, G__74972__a = new Array(arguments.length -  0);
while (G__74972__i < G__74972__a.length) {G__74972__a[G__74972__i] = arguments[G__74972__i + 0]; ++G__74972__i;}
  args = new cljs.core.IndexedSeq(G__74972__a,0,null);
} 
return G__74971__delegate.call(this,args);};
G__74971.cljs$lang$maxFixedArity = 0;
G__74971.cljs$lang$applyTo = (function (arglist__74973){
var args = cljs.core.seq(arglist__74973);
return G__74971__delegate(args);
});
G__74971.cljs$core$IFn$_invoke$arity$variadic = G__74971__delegate;
return G__74971;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74667 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74667 = (function (meta74668){
this.meta74668 = meta74668;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74667.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74669,meta74668__$1){
var self__ = this;
var _74669__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74667(meta74668__$1));
}));

(com.rpl.specter.t_com$rpl$specter74667.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74669){
var self__ = this;
var _74669__$1 = this;
return self__.meta74668;
}));

(com.rpl.specter.t_com$rpl$specter74667.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74667.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74667.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter74667.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74668","meta74668",-1439955183,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74667.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74667.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74667");

(com.rpl.specter.t_com$rpl$specter74667.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74667");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74667.
 */
com.rpl.specter.__GT_t_com$rpl$specter74667 = (function com$rpl$specter$__GT_t_com$rpl$specter74667(meta74668){
return (new com.rpl.specter.t_com$rpl$specter74667(meta74668));
});

}

return (new com.rpl.specter.t_com$rpl$specter74667(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74671 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74671 = (function (afn,meta74672){
this.afn = afn;
this.meta74672 = meta74672;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74671.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74673,meta74672__$1){
var self__ = this;
var _74673__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74671(self__.afn,meta74672__$1));
}));

(com.rpl.specter.t_com$rpl$specter74671.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74673){
var self__ = this;
var _74673__$1 = this;
return self__.meta74672;
}));

(com.rpl.specter.t_com$rpl$specter74671.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74671.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74671.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter74671.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta74672","meta74672",1886135941,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74671.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74671.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74671");

(com.rpl.specter.t_com$rpl$specter74671.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74671");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74671.
 */
com.rpl.specter.__GT_t_com$rpl$specter74671 = (function com$rpl$specter$__GT_t_com$rpl$specter74671(afn__$1,meta74672){
return (new com.rpl.specter.t_com$rpl$specter74671(afn__$1,meta74672));
});

}

return (new com.rpl.specter.t_com$rpl$specter74671(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74674 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74674 = (function (afn,meta74675){
this.afn = afn;
this.meta74675 = meta74675;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74674.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74676,meta74675__$1){
var self__ = this;
var _74676__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74674(self__.afn,meta74675__$1));
}));

(com.rpl.specter.t_com$rpl$specter74674.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74676){
var self__ = this;
var _74676__$1 = this;
return self__.meta74675;
}));

(com.rpl.specter.t_com$rpl$specter74674.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74674.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74674.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter74674.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta74675","meta74675",-1718687362,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74674.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74674.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74674");

(com.rpl.specter.t_com$rpl$specter74674.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74674");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74674.
 */
com.rpl.specter.__GT_t_com$rpl$specter74674 = (function com$rpl$specter$__GT_t_com$rpl$specter74674(afn__$1,meta74675){
return (new com.rpl.specter.t_com$rpl$specter74674(afn__$1,meta74675));
});

}

return (new com.rpl.specter.t_com$rpl$specter74674(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__74677 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__74677) : com.rpl.specter.terminal.call(null,G__74677));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74678 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74678 = (function (meta74679){
this.meta74679 = meta74679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74680,meta74679__$1){
var self__ = this;
var _74680__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74678(meta74679__$1));
}));

(com.rpl.specter.t_com$rpl$specter74678.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74680){
var self__ = this;
var _74680__$1 = this;
return self__.meta74679;
}));

(com.rpl.specter.t_com$rpl$specter74678.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74678.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74678.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74678.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74679","meta74679",1316351893,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74678.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74678.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74678");

(com.rpl.specter.t_com$rpl$specter74678.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74678");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74678.
 */
com.rpl.specter.__GT_t_com$rpl$specter74678 = (function com$rpl$specter$__GT_t_com$rpl$specter74678(meta74679){
return (new com.rpl.specter.t_com$rpl$specter74678(meta74679));
});

}

return (new com.rpl.specter.t_com$rpl$specter74678(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74682 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74682 = (function (meta74683){
this.meta74683 = meta74683;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74682.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74684,meta74683__$1){
var self__ = this;
var _74684__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74682(meta74683__$1));
}));

(com.rpl.specter.t_com$rpl$specter74682.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74684){
var self__ = this;
var _74684__$1 = this;
return self__.meta74683;
}));

(com.rpl.specter.t_com$rpl$specter74682.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74682.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74682.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter74682.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74683","meta74683",-937220906,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74682.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74682.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74682");

(com.rpl.specter.t_com$rpl$specter74682.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74682");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74682.
 */
com.rpl.specter.__GT_t_com$rpl$specter74682 = (function com$rpl$specter$__GT_t_com$rpl$specter74682(meta74683){
return (new com.rpl.specter.t_com$rpl$specter74682(meta74683));
});

}

return (new com.rpl.specter.t_com$rpl$specter74682(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,v){
var ret__37934__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74685 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74685 = (function (meta74686){
this.meta74686 = meta74686;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74685.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74687,meta74686__$1){
var self__ = this;
var _74687__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74685(meta74686__$1));
}));

(com.rpl.specter.t_com$rpl$specter74685.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74687){
var self__ = this;
var _74687__$1 = this;
return self__.meta74686;
}));

(com.rpl.specter.t_com$rpl$specter74685.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74685.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,v){
var ret__37934__auto__ = next_fn(v);
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter74685.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74685.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74686","meta74686",-1715198957,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74685.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74685.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74685");

(com.rpl.specter.t_com$rpl$specter74685.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74685");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74685.
 */
com.rpl.specter.__GT_t_com$rpl$specter74685 = (function com$rpl$specter$__GT_t_com$rpl$specter74685(meta74686){
return (new com.rpl.specter.t_com$rpl$specter74685(meta74686));
});

}

return (new com.rpl.specter.t_com$rpl$specter74685(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,k){
var ret__37934__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74688 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74688 = (function (meta74689){
this.meta74689 = meta74689;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74688.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74690,meta74689__$1){
var self__ = this;
var _74690__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74688(meta74689__$1));
}));

(com.rpl.specter.t_com$rpl$specter74688.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74690){
var self__ = this;
var _74690__$1 = this;
return self__.meta74689;
}));

(com.rpl.specter.t_com$rpl$specter74688.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74688.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,k){
var ret__37934__auto__ = next_fn(k);
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter74688.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74688.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74689","meta74689",1885590917,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74688.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74688.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74688");

(com.rpl.specter.t_com$rpl$specter74688.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74688");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74688.
 */
com.rpl.specter.__GT_t_com$rpl$specter74688 = (function com$rpl$specter$__GT_t_com$rpl$specter74688(meta74689){
return (new com.rpl.specter.t_com$rpl$specter74688(meta74689));
});

}

return (new com.rpl.specter.t_com$rpl$specter74688(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74692 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74692 = (function (meta74693){
this.meta74693 = meta74693;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74692.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74694,meta74693__$1){
var self__ = this;
var _74694__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74692(meta74693__$1));
}));

(com.rpl.specter.t_com$rpl$specter74692.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74694){
var self__ = this;
var _74694__$1 = this;
return self__.meta74693;
}));

(com.rpl.specter.t_com$rpl$specter74692.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74692.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39616__auto__,vals__39617__auto__,structure,next_fn__39618__auto__){
var self__ = this;
var this__39616__auto____$1 = this;
var G__74695 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39617__auto__,structure);
var G__74696 = structure;
return (next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2(G__74695,G__74696) : next_fn__39618__auto__.call(null,G__74695,G__74696));
}));

(com.rpl.specter.t_com$rpl$specter74692.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39616__auto__,vals__39617__auto__,structure,next_fn__39618__auto__){
var self__ = this;
var this__39616__auto____$1 = this;
var G__74697 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39617__auto__,structure);
var G__74698 = structure;
return (next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2(G__74697,G__74698) : next_fn__39618__auto__.call(null,G__74697,G__74698));
}));

(com.rpl.specter.t_com$rpl$specter74692.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74693","meta74693",-1749936330,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74692.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74692.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74692");

(com.rpl.specter.t_com$rpl$specter74692.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74692");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74692.
 */
com.rpl.specter.__GT_t_com$rpl$specter74692 = (function com$rpl$specter$__GT_t_com$rpl$specter74692(meta74693){
return (new com.rpl.specter.t_com$rpl$specter74692(meta74693));
});

}

return (new com.rpl.specter.t_com$rpl$specter74692(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__74699 = structure;
var G__74700 = s;
var G__74701 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__74702 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__74699,G__74700,G__74701,G__74702) : com.rpl.specter.navs.srange_transform.call(null,G__74699,G__74700,G__74701,G__74702));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74703 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74703 = (function (start_index_fn,end_index_fn,meta74704){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta74704 = meta74704;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74703.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74705,meta74704__$1){
var self__ = this;
var _74705__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74703(self__.start_index_fn,self__.end_index_fn,meta74704__$1));
}));

(com.rpl.specter.t_com$rpl$specter74703.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74705){
var self__ = this;
var _74705__$1 = this;
return self__.meta74704;
}));

(com.rpl.specter.t_com$rpl$specter74703.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74703.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74703.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__74706 = structure;
var G__74707 = s;
var G__74708 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__74709 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__74706,G__74707,G__74708,G__74709) : com.rpl.specter.navs.srange_transform.call(null,G__74706,G__74707,G__74708,G__74709));
}));

(com.rpl.specter.t_com$rpl$specter74703.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta74704","meta74704",1497237279,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74703.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74703.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74703");

(com.rpl.specter.t_com$rpl$specter74703.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74703");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74703.
 */
com.rpl.specter.__GT_t_com$rpl$specter74703 = (function com$rpl$specter$__GT_t_com$rpl$specter74703(start_index_fn__$1,end_index_fn__$1,meta74704){
return (new com.rpl.specter.t_com$rpl$specter74703(start_index_fn__$1,end_index_fn__$1,meta74704));
});

}

return (new com.rpl.specter.t_com$rpl$specter74703(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74710 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74710 = (function (start,end,meta74711){
this.start = start;
this.end = end;
this.meta74711 = meta74711;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74710.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74712,meta74711__$1){
var self__ = this;
var _74712__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74710(self__.start,self__.end,meta74711__$1));
}));

(com.rpl.specter.t_com$rpl$specter74710.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74712){
var self__ = this;
var _74712__$1 = this;
return self__.meta74711;
}));

(com.rpl.specter.t_com$rpl$specter74710.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74710.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74710.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter74710.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta74711","meta74711",-1250336183,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74710.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74710.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74710");

(com.rpl.specter.t_com$rpl$specter74710.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74710");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74710.
 */
com.rpl.specter.__GT_t_com$rpl$specter74710 = (function com$rpl$specter$__GT_t_com$rpl$specter74710(start__$1,end__$1,meta74711){
return (new com.rpl.specter.t_com$rpl$specter74710(start__$1,end__$1,meta74711));
});

}

return (new com.rpl.specter.t_com$rpl$specter74710(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,p__74714){
var vec__74715 = p__74714;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74715,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74715,(1),null);
var ret__37934__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74718 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74718 = (function (pred,meta74719){
this.pred = pred;
this.meta74719 = meta74719;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74718.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74720,meta74719__$1){
var self__ = this;
var _74720__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74718(self__.pred,meta74719__$1));
}));

(com.rpl.specter.t_com$rpl$specter74718.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74720){
var self__ = this;
var _74720__$1 = this;
return self__.meta74719;
}));

(com.rpl.specter.t_com$rpl$specter74718.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74718.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,p__74721){
var vec__74722 = p__74721;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74722,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74722,(1),null);
var ret__37934__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter74718.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74718.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta74719","meta74719",-969032862,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74718.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74718.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74718");

(com.rpl.specter.t_com$rpl$specter74718.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74718");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74718.
 */
com.rpl.specter.__GT_t_com$rpl$specter74718 = (function com$rpl$specter$__GT_t_com$rpl$specter74718(pred__$1,meta74719){
return (new com.rpl.specter.t_com$rpl$specter74718(pred__$1,meta74719));
});

}

return (new com.rpl.specter.t_com$rpl$specter74718(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__74725 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74725) : next_fn.call(null,G__74725));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__74726 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74726) : next_fn.call(null,G__74726));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74727 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74727 = (function (meta74728){
this.meta74728 = meta74728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74729,meta74728__$1){
var self__ = this;
var _74729__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74727(meta74728__$1));
}));

(com.rpl.specter.t_com$rpl$specter74727.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74729){
var self__ = this;
var _74729__$1 = this;
return self__.meta74728;
}));

(com.rpl.specter.t_com$rpl$specter74727.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74727.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter74727.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter74727.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74728","meta74728",-1253654977,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74727.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74727.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74727");

(com.rpl.specter.t_com$rpl$specter74727.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74727");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74727.
 */
com.rpl.specter.__GT_t_com$rpl$specter74727 = (function com$rpl$specter$__GT_t_com$rpl$specter74727(meta74728){
return (new com.rpl.specter.t_com$rpl$specter74727(meta74728));
});

}

return (new com.rpl.specter.t_com$rpl$specter74727(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__74730 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74730) : next_fn.call(null,G__74730));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__74731 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74731) : next_fn.call(null,G__74731));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74732 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74732 = (function (meta74733){
this.meta74733 = meta74733;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74732.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74734,meta74733__$1){
var self__ = this;
var _74734__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74732(meta74733__$1));
}));

(com.rpl.specter.t_com$rpl$specter74732.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74734){
var self__ = this;
var _74734__$1 = this;
return self__.meta74733;
}));

(com.rpl.specter.t_com$rpl$specter74732.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74732.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter74732.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter74732.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74733","meta74733",-1691114750,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74732.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74732.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74732");

(com.rpl.specter.t_com$rpl$specter74732.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74732");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74732.
 */
com.rpl.specter.__GT_t_com$rpl$specter74732 = (function com$rpl$specter$__GT_t_com$rpl$specter74732(meta74733){
return (new com.rpl.specter.t_com$rpl$specter74732(meta74733));
});

}

return (new com.rpl.specter.t_com$rpl$specter74732(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74736 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74736 = (function (meta74737){
this.meta74737 = meta74737;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74736.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74738,meta74737__$1){
var self__ = this;
var _74738__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74736(meta74737__$1));
}));

(com.rpl.specter.t_com$rpl$specter74736.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74738){
var self__ = this;
var _74738__$1 = this;
return self__.meta74737;
}));

(com.rpl.specter.t_com$rpl$specter74736.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74736.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74736.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter74736.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74737","meta74737",-1000600165,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74736.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74736.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74736");

(com.rpl.specter.t_com$rpl$specter74736.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74736");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74736.
 */
com.rpl.specter.__GT_t_com$rpl$specter74736 = (function com$rpl$specter$__GT_t_com$rpl$specter74736(meta74737){
return (new com.rpl.specter.t_com$rpl$specter74736(meta74737));
});

}

return (new com.rpl.specter.t_com$rpl$specter74736(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74739 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74739 = (function (meta74740){
this.meta74740 = meta74740;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74739.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74741,meta74740__$1){
var self__ = this;
var _74741__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74739(meta74740__$1));
}));

(com.rpl.specter.t_com$rpl$specter74739.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74741){
var self__ = this;
var _74741__$1 = this;
return self__.meta74740;
}));

(com.rpl.specter.t_com$rpl$specter74739.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74739.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74739.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter74739.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74740","meta74740",94453129,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74739.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74739.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74739");

(com.rpl.specter.t_com$rpl$specter74739.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74739");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74739.
 */
com.rpl.specter.__GT_t_com$rpl$specter74739 = (function com$rpl$specter$__GT_t_com$rpl$specter74739(meta74740){
return (new com.rpl.specter.t_com$rpl$specter74739(meta74740));
});

}

return (new com.rpl.specter.t_com$rpl$specter74739(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74742 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74742 = (function (meta74743){
this.meta74743 = meta74743;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74742.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74744,meta74743__$1){
var self__ = this;
var _74744__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74742(meta74743__$1));
}));

(com.rpl.specter.t_com$rpl$specter74742.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74744){
var self__ = this;
var _74744__$1 = this;
return self__.meta74743;
}));

(com.rpl.specter.t_com$rpl$specter74742.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74742.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74742.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter74742.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74743","meta74743",-1482108048,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74742.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74742.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74742");

(com.rpl.specter.t_com$rpl$specter74742.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74742");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74742.
 */
com.rpl.specter.__GT_t_com$rpl$specter74742 = (function com$rpl$specter$__GT_t_com$rpl$specter74742(meta74743){
return (new com.rpl.specter.t_com$rpl$specter74742(meta74743));
});

}

return (new com.rpl.specter.t_com$rpl$specter74742(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__74745 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74745) : next_fn.call(null,G__74745));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74746 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74746 = (function (aset,meta74747){
this.aset = aset;
this.meta74747 = meta74747;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74746.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74748,meta74747__$1){
var self__ = this;
var _74748__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74746(self__.aset,meta74747__$1));
}));

(com.rpl.specter.t_com$rpl$specter74746.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74748){
var self__ = this;
var _74748__$1 = this;
return self__.meta74747;
}));

(com.rpl.specter.t_com$rpl$specter74746.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74746.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter74746.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter74746.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta74747","meta74747",1951994486,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74746.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74746.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74746");

(com.rpl.specter.t_com$rpl$specter74746.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74746");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74746.
 */
com.rpl.specter.__GT_t_com$rpl$specter74746 = (function com$rpl$specter$__GT_t_com$rpl$specter74746(aset__$1,meta74747){
return (new com.rpl.specter.t_com$rpl$specter74746(aset__$1,meta74747));
});

}

return (new com.rpl.specter.t_com$rpl$specter74746(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__74750 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74750) : next_fn.call(null,G__74750));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74751 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74751 = (function (m_keys,meta74752){
this.m_keys = m_keys;
this.meta74752 = meta74752;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74751.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74753,meta74752__$1){
var self__ = this;
var _74753__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74751(self__.m_keys,meta74752__$1));
}));

(com.rpl.specter.t_com$rpl$specter74751.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74753){
var self__ = this;
var _74753__$1 = this;
return self__.meta74752;
}));

(com.rpl.specter.t_com$rpl$specter74751.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74751.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter74751.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter74751.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta74752","meta74752",-176108594,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74751.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74751.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74751");

(com.rpl.specter.t_com$rpl$specter74751.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74751");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74751.
 */
com.rpl.specter.__GT_t_com$rpl$specter74751 = (function com$rpl$specter$__GT_t_com$rpl$specter74751(m_keys__$1,meta74752){
return (new com.rpl.specter.t_com$rpl$specter74751(m_keys__$1,meta74752));
});

}

return (new com.rpl.specter.t_com$rpl$specter74751(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74976__delegate = function (path){
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74754 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74754 = (function (path,late,meta74755){
this.path = path;
this.late = late;
this.meta74755 = meta74755;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74754.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74756,meta74755__$1){
var self__ = this;
var _74756__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74754(self__.path,self__.late,meta74755__$1));
}));

(com.rpl.specter.t_com$rpl$specter74754.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74756){
var self__ = this;
var _74756__$1 = this;
return self__.meta74755;
}));

(com.rpl.specter.t_com$rpl$specter74754.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74754.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74754.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__74757 = self__.late;
var G__74758 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__74759 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__74757,G__74758,G__74759) : com.rpl.specter.compiled_transform.call(null,G__74757,G__74758,G__74759));
}));

(com.rpl.specter.t_com$rpl$specter74754.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74755","meta74755",1608284772,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74754.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74754.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74754");

(com.rpl.specter.t_com$rpl$specter74754.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74754");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74754.
 */
com.rpl.specter.__GT_t_com$rpl$specter74754 = (function com$rpl$specter$__GT_t_com$rpl$specter74754(path__$1,late__$1,meta74755){
return (new com.rpl.specter.t_com$rpl$specter74754(path__$1,late__$1,meta74755));
});

}

return (new com.rpl.specter.t_com$rpl$specter74754(path,late,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
};
var G__74976 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74977__i = 0, G__74977__a = new Array(arguments.length -  0);
while (G__74977__i < G__74977__a.length) {G__74977__a[G__74977__i] = arguments[G__74977__i + 0]; ++G__74977__i;}
  path = new cljs.core.IndexedSeq(G__74977__a,0,null);
} 
return G__74976__delegate.call(this,path);};
G__74976.cljs$lang$maxFixedArity = 0;
G__74976.cljs$lang$applyTo = (function (arglist__74978){
var path = cljs.core.seq(arglist__74978);
return G__74976__delegate(path);
});
G__74976.cljs$core$IFn$_invoke$arity$variadic = G__74976__delegate;
return G__74976;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74760 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74760 = (function (key,meta74761){
this.key = key;
this.meta74761 = meta74761;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74760.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74762,meta74761__$1){
var self__ = this;
var _74762__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74760(self__.key,meta74761__$1));
}));

(com.rpl.specter.t_com$rpl$specter74760.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74762){
var self__ = this;
var _74762__$1 = this;
return self__.meta74761;
}));

(com.rpl.specter.t_com$rpl$specter74760.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74760.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter74760.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter74760.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta74761","meta74761",-1429287015,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74760.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74760.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74760");

(com.rpl.specter.t_com$rpl$specter74760.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74760");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74760.
 */
com.rpl.specter.__GT_t_com$rpl$specter74760 = (function com$rpl$specter$__GT_t_com$rpl$specter74760(key__$1,meta74761){
return (new com.rpl.specter.t_com$rpl$specter74760(key__$1,meta74761));
});

}

return (new com.rpl.specter.t_com$rpl$specter74760(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74763 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74763 = (function (elem,meta74764){
this.elem = elem;
this.meta74764 = meta74764;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74763.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74765,meta74764__$1){
var self__ = this;
var _74765__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74763(self__.elem,meta74764__$1));
}));

(com.rpl.specter.t_com$rpl$specter74763.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74765){
var self__ = this;
var _74765__$1 = this;
return self__.meta74764;
}));

(com.rpl.specter.t_com$rpl$specter74763.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74763.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter74763.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter74763.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta74764","meta74764",724344414,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74763.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74763.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74763");

(com.rpl.specter.t_com$rpl$specter74763.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74763");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74763.
 */
com.rpl.specter.__GT_t_com$rpl$specter74763 = (function com$rpl$specter$__GT_t_com$rpl$specter74763(elem__$1,meta74764){
return (new com.rpl.specter.t_com$rpl$specter74763(elem__$1,meta74764));
});

}

return (new com.rpl.specter.t_com$rpl$specter74763(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74767 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74767 = (function (index,meta74768){
this.index = index;
this.meta74768 = meta74768;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74767.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74769,meta74768__$1){
var self__ = this;
var _74769__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74767(self__.index,meta74768__$1));
}));

(com.rpl.specter.t_com$rpl$specter74767.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74769){
var self__ = this;
var _74769__$1 = this;
return self__.meta74768;
}));

(com.rpl.specter.t_com$rpl$specter74767.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74767.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74767.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74770;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74771 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,755,758,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache74770 = info74771;

return info74771;
})():info__39626__auto__);
var precompiled74772 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74773 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled74772.cljs$core$IFn$_invoke$arity$1 ? precompiled74772.cljs$core$IFn$_invoke$arity$1(G__74773) : precompiled74772.call(null,G__74773));
} else {
return precompiled74772;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter74767.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta74768","meta74768",1875886161,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74767.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74767.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74767");

(com.rpl.specter.t_com$rpl$specter74767.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74767");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74767.
 */
com.rpl.specter.__GT_t_com$rpl$specter74767 = (function com$rpl$specter$__GT_t_com$rpl$specter74767(index__$1,meta74768){
return (new com.rpl.specter.t_com$rpl$specter74767(index__$1,meta74768));
});

}

return (new com.rpl.specter.t_com$rpl$specter74767(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74774 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74774 = (function (i,meta74775){
this.i = i;
this.meta74775 = meta74775;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74774.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74776,meta74775__$1){
var self__ = this;
var _74776__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74774(self__.i,meta74775__$1));
}));

(com.rpl.specter.t_com$rpl$specter74774.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74776){
var self__ = this;
var _74776__$1 = this;
return self__.meta74775;
}));

(com.rpl.specter.t_com$rpl$specter74774.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74774.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter74774.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__74980 = (j - (1));
var G__74981 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__74980;
s = G__74981;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__74982 = (j + (1));
var G__74983 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__74982;
s = G__74983;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74777;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74778 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,968,971,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache74777 = info74778;

return info74778;
})():info__39626__auto__);
var precompiled74779 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74780 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled74779.cljs$core$IFn$_invoke$arity$1 ? precompiled74779.cljs$core$IFn$_invoke$arity$1(G__74780) : precompiled74779.call(null,G__74780));
} else {
return precompiled74779;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74781;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74782 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache74781 = info74782;

return info74782;
})():info__39626__auto__);
var precompiled74783 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74784 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled74783.cljs$core$IFn$_invoke$arity$1 ? precompiled74783.cljs$core$IFn$_invoke$arity$1(G__74784) : precompiled74783.call(null,G__74784));
} else {
return precompiled74783;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter74774.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta74775","meta74775",-1327405700,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74774.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74774.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74774");

(com.rpl.specter.t_com$rpl$specter74774.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74774");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74774.
 */
com.rpl.specter.__GT_t_com$rpl$specter74774 = (function com$rpl$specter$__GT_t_com$rpl$specter74774(i__$1,meta74775){
return (new com.rpl.specter.t_com$rpl$specter74774(i__$1,meta74775));
});

}

return (new com.rpl.specter.t_com$rpl$specter74774(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,e){
var ret__37934__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__74787 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74787) : next_fn.call(null,G__74787));
})()
;
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__74788 = (function (){var G__74791 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74791) : next_fn.call(null,G__74791));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74788,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74788,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74792;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74793 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__74785_SHARP_){
return (p1__74785_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__74786_SHARP_){
return (p1__74786_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache74792 = info74793;

return info74793;
})():info__39626__auto__);
var precompiled74794 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74796 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__74785_SHARP_){
return (p1__74785_SHARP_ >= (curri + (1)));
}),(function (p1__74786_SHARP_){
return (p1__74786_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__74785_SHARP_){
return (p1__74785_SHARP_ >= (curri + (1)));
}),(function (p1__74786_SHARP_){
return (p1__74786_SHARP_ <= newi);
})], null);
return (precompiled74794.cljs$core$IFn$_invoke$arity$1 ? precompiled74794.cljs$core$IFn$_invoke$arity$1(G__74796) : precompiled74794.call(null,G__74796));
} else {
return precompiled74794;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74797;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74798 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache74797 = info74798;

return info74798;
})():info__39626__auto__);
var precompiled74799 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74800 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled74799.cljs$core$IFn$_invoke$arity$1 ? precompiled74799.cljs$core$IFn$_invoke$arity$1(G__74800) : precompiled74799.call(null,G__74800));
} else {
return precompiled74799;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74801;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74802 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache74801 = info74802;

return info74802;
})():info__39626__auto__);
var precompiled74803 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74804 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled74803.cljs$core$IFn$_invoke$arity$1 ? precompiled74803.cljs$core$IFn$_invoke$arity$1(G__74804) : precompiled74803.call(null,G__74804));
} else {
return precompiled74803;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74805 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74805 = (function (start,meta74806){
this.start = start;
this.meta74806 = meta74806;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74805.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74807,meta74806__$1){
var self__ = this;
var _74807__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74805(self__.start,meta74806__$1));
}));

(com.rpl.specter.t_com$rpl$specter74805.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74807){
var self__ = this;
var _74807__$1 = this;
return self__.meta74806;
}));

(com.rpl.specter.t_com$rpl$specter74805.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74805.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,e){
var ret__37934__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter74805.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__74808 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74808,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74808,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74811;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74812 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__74785_SHARP_){
return (p1__74785_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__74786_SHARP_){
return (p1__74786_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74785#","p1__74785#",1581125374,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74786#","p1__74786#",100441963,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache74811 = info74812;

return info74812;
})():info__39626__auto__);
var precompiled74813 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74814 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__74785_SHARP_){
return (p1__74785_SHARP_ >= (curri + (1)));
}),(function (p1__74786_SHARP_){
return (p1__74786_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__74785_SHARP_){
return (p1__74785_SHARP_ >= (curri + (1)));
}),(function (p1__74786_SHARP_){
return (p1__74786_SHARP_ <= newi);
})], null);
return (precompiled74813.cljs$core$IFn$_invoke$arity$1 ? precompiled74813.cljs$core$IFn$_invoke$arity$1(G__74814) : precompiled74813.call(null,G__74814));
} else {
return precompiled74813;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74815;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74816 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache74815 = info74816;

return info74816;
})():info__39626__auto__);
var precompiled74817 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74818 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled74817.cljs$core$IFn$_invoke$arity$1 ? precompiled74817.cljs$core$IFn$_invoke$arity$1(G__74818) : precompiled74817.call(null,G__74818));
} else {
return precompiled74817;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39626__auto__ = com.rpl.specter.pathcache74819;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74820 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache74819 = info74820;

return info74820;
})():info__39626__auto__);
var precompiled74821 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74822 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled74821.cljs$core$IFn$_invoke$arity$1 ? precompiled74821.cljs$core$IFn$_invoke$arity$1(G__74822) : precompiled74821.call(null,G__74822));
} else {
return precompiled74821;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter74805.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta74806","meta74806",770234246,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74805.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74805.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74805");

(com.rpl.specter.t_com$rpl$specter74805.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74805");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74805.
 */
com.rpl.specter.__GT_t_com$rpl$specter74805 = (function com$rpl$specter$__GT_t_com$rpl$specter74805(start__$1,meta74806){
return (new com.rpl.specter.t_com$rpl$specter74805(start__$1,meta74806));
});

}

return (new com.rpl.specter.t_com$rpl$specter74805(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74823 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74823 = (function (afn,meta74824){
this.afn = afn;
this.meta74824 = meta74824;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74823.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74825,meta74824__$1){
var self__ = this;
var _74825__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74823(self__.afn,meta74824__$1));
}));

(com.rpl.specter.t_com$rpl$specter74823.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74825){
var self__ = this;
var _74825__$1 = this;
return self__.meta74824;
}));

(com.rpl.specter.t_com$rpl$specter74823.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74823.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__74826 = vals;
var G__74827 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__74826,G__74827) : next_fn.call(null,G__74826,G__74827));
}));

(com.rpl.specter.t_com$rpl$specter74823.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__74828 = vals;
var G__74829 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__74828,G__74829) : next_fn.call(null,G__74828,G__74829));
}));

(com.rpl.specter.t_com$rpl$specter74823.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta74824","meta74824",247878507,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74823.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74823.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74823");

(com.rpl.specter.t_com$rpl$specter74823.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74823");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74823.
 */
com.rpl.specter.__GT_t_com$rpl$specter74823 = (function com$rpl$specter$__GT_t_com$rpl$specter74823(afn__$1,meta74824){
return (new com.rpl.specter.t_com$rpl$specter74823(afn__$1,meta74824));
});

}

return (new com.rpl.specter.t_com$rpl$specter74823(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__74831 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74831) : next_fn.call(null,G__74831));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__74832 = (function (){var G__74833 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74833) : next_fn.call(null,G__74833));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__74832) : unparse_fn.call(null,G__74832));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74834 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74834 = (function (parse_fn,unparse_fn,meta74835){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta74835 = meta74835;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74834.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74836,meta74835__$1){
var self__ = this;
var _74836__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74834(self__.parse_fn,self__.unparse_fn,meta74835__$1));
}));

(com.rpl.specter.t_com$rpl$specter74834.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74836){
var self__ = this;
var _74836__$1 = this;
return self__.meta74835;
}));

(com.rpl.specter.t_com$rpl$specter74834.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74834.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74834.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var G__74837 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__74837) : self__.unparse_fn.call(null,G__74837));
}));

(com.rpl.specter.t_com$rpl$specter74834.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta74835","meta74835",2030964251,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74834.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74834.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74834");

(com.rpl.specter.t_com$rpl$specter74834.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74834");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74834.
 */
com.rpl.specter.__GT_t_com$rpl$specter74834 = (function com$rpl$specter$__GT_t_com$rpl$specter74834(parse_fn__$1,unparse_fn__$1,meta74835){
return (new com.rpl.specter.t_com$rpl$specter74834(parse_fn__$1,unparse_fn__$1,meta74835));
});

}

return (new com.rpl.specter.t_com$rpl$specter74834(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__74838 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74838) : next_fn.call(null,G__74838));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74839 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74839 = (function (meta74840){
this.meta74840 = meta74840;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74839.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74841,meta74840__$1){
var self__ = this;
var _74841__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74839(meta74840__$1));
}));

(com.rpl.specter.t_com$rpl$specter74839.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74841){
var self__ = this;
var _74841__$1 = this;
return self__.meta74840;
}));

(com.rpl.specter.t_com$rpl$specter74839.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74839.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter74839.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter74839.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74840","meta74840",491122750,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74839.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74839.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74839");

(com.rpl.specter.t_com$rpl$specter74839.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74839");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74839.
 */
com.rpl.specter.__GT_t_com$rpl$specter74839 = (function com$rpl$specter$__GT_t_com$rpl$specter74839(meta74840){
return (new com.rpl.specter.t_com$rpl$specter74839(meta74840));
});

}

return (new com.rpl.specter.t_com$rpl$specter74839(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,s){
var ret__37934__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74842 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74842 = (function (re,meta74843){
this.re = re;
this.meta74843 = meta74843;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74842.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74844,meta74843__$1){
var self__ = this;
var _74844__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74842(self__.re,meta74843__$1));
}));

(com.rpl.specter.t_com$rpl$specter74842.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74844){
var self__ = this;
var _74844__$1 = this;
return self__.meta74843;
}));

(com.rpl.specter.t_com$rpl$specter74842.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74842.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__37933__auto__,s){
var ret__37934__auto__ = next_fn(s);
if((ret__37934__auto__ === com.rpl.specter.NONE)){
return curr__37933__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__37934__auto__)){
return cljs.core.reduced(ret__37934__auto__);
} else {
return ret__37934__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter74842.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74842.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta74843","meta74843",1640963770,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74842.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74842.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74842");

(com.rpl.specter.t_com$rpl$specter74842.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74842");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74842.
 */
com.rpl.specter.__GT_t_com$rpl$specter74842 = (function com$rpl$specter$__GT_t_com$rpl$specter74842(re__$1,meta74843){
return (new com.rpl.specter.t_com$rpl$specter74842(re__$1,meta74843));
});

}

return (new com.rpl.specter.t_com$rpl$specter74842(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74985__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74847 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74847 = (function (path,temp__5733__auto__,late,meta74848){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta74848 = meta74848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74849,meta74848__$1){
var self__ = this;
var _74849__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74847(self__.path,self__.temp__5733__auto__,self__.late,meta74848__$1));
}));

(com.rpl.specter.t_com$rpl$specter74847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74849){
var self__ = this;
var _74849__$1 = this;
return self__.meta74848;
}));

(com.rpl.specter.t_com$rpl$specter74847.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74847.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__74845_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__74845_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74847.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__74846_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__74846_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74848","meta74848",689552200,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74847.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74847.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74847");

(com.rpl.specter.t_com$rpl$specter74847.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74847");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74847.
 */
com.rpl.specter.__GT_t_com$rpl$specter74847 = (function com$rpl$specter$__GT_t_com$rpl$specter74847(path__$1,temp__5733__auto____$1,late__$1,meta74848){
return (new com.rpl.specter.t_com$rpl$specter74847(path__$1,temp__5733__auto____$1,late__$1,meta74848));
});

}

return (new com.rpl.specter.t_com$rpl$specter74847(path,temp__5733__auto__,late,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
}
};
var G__74985 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74986__i = 0, G__74986__a = new Array(arguments.length -  0);
while (G__74986__i < G__74986__a.length) {G__74986__a[G__74986__i] = arguments[G__74986__i + 0]; ++G__74986__i;}
  path = new cljs.core.IndexedSeq(G__74986__a,0,null);
} 
return G__74985__delegate.call(this,path);};
G__74985.cljs$lang$maxFixedArity = 0;
G__74985.cljs$lang$applyTo = (function (arglist__74987){
var path = cljs.core.seq(arglist__74987);
return G__74985__delegate(path);
});
G__74985.cljs$core$IFn$_invoke$arity$variadic = G__74985__delegate;
return G__74985;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74988__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74852 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74852 = (function (path,temp__5733__auto__,late,meta74853){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta74853 = meta74853;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74852.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74854,meta74853__$1){
var self__ = this;
var _74854__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74852(self__.path,self__.temp__5733__auto__,self__.late,meta74853__$1));
}));

(com.rpl.specter.t_com$rpl$specter74852.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74854){
var self__ = this;
var _74854__$1 = this;
return self__.meta74853;
}));

(com.rpl.specter.t_com$rpl$specter74852.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74852.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__74850_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__74850_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74852.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__74851_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__74851_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74852.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74853","meta74853",887211600,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74852.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74852.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74852");

(com.rpl.specter.t_com$rpl$specter74852.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74852");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74852.
 */
com.rpl.specter.__GT_t_com$rpl$specter74852 = (function com$rpl$specter$__GT_t_com$rpl$specter74852(path__$1,temp__5733__auto____$1,late__$1,meta74853){
return (new com.rpl.specter.t_com$rpl$specter74852(path__$1,temp__5733__auto____$1,late__$1,meta74853));
});

}

return (new com.rpl.specter.t_com$rpl$specter74852(path,temp__5733__auto__,late,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
}
};
var G__74988 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74995__i = 0, G__74995__a = new Array(arguments.length -  0);
while (G__74995__i < G__74995__a.length) {G__74995__a[G__74995__i] = arguments[G__74995__i + 0]; ++G__74995__i;}
  path = new cljs.core.IndexedSeq(G__74995__a,0,null);
} 
return G__74988__delegate.call(this,path);};
G__74988.cljs$lang$maxFixedArity = 0;
G__74988.cljs$lang$applyTo = (function (arglist__74996){
var path = cljs.core.seq(arglist__74996);
return G__74988__delegate(path);
});
G__74988.cljs$core$IFn$_invoke$arity$variadic = G__74988__delegate;
return G__74988;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74997__delegate = function (path){
var G__74856 = com.rpl.specter.ALL;
var G__74857 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__74856,G__74857) : com.rpl.specter.subselect.call(null,G__74856,G__74857));
};
var G__74997 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75000__i = 0, G__75000__a = new Array(arguments.length -  0);
while (G__75000__i < G__75000__a.length) {G__75000__a[G__75000__i] = arguments[G__75000__i + 0]; ++G__75000__i;}
  path = new cljs.core.IndexedSeq(G__75000__a,0,null);
} 
return G__74997__delegate.call(this,path);};
G__74997.cljs$lang$maxFixedArity = 0;
G__74997.cljs$lang$applyTo = (function (arglist__75002){
var path = cljs.core.seq(arglist__75002);
return G__74997__delegate(path);
});
G__74997.cljs$core$IFn$_invoke$arity$variadic = G__74997__delegate;
return G__74997;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74858 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74858 = (function (path,update_fn,late,late_fn,meta74859){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta74859 = meta74859;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74858.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74860,meta74859__$1){
var self__ = this;
var _74860__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74858(self__.path,self__.update_fn,self__.late,self__.late_fn,meta74859__$1));
}));

(com.rpl.specter.t_com$rpl$specter74858.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74860){
var self__ = this;
var _74860__$1 = this;
return self__.meta74859;
}));

(com.rpl.specter.t_com$rpl$specter74858.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74858.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74858.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74858.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta74859","meta74859",-162290413,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74858.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74858.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74858");

(com.rpl.specter.t_com$rpl$specter74858.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74858");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74858.
 */
com.rpl.specter.__GT_t_com$rpl$specter74858 = (function com$rpl$specter$__GT_t_com$rpl$specter74858(path__$1,update_fn__$1,late__$1,late_fn__$1,meta74859){
return (new com.rpl.specter.t_com$rpl$specter74858(path__$1,update_fn__$1,late__$1,late_fn__$1,meta74859));
});

}

return (new com.rpl.specter.t_com$rpl$specter74858(path,update_fn,late,late_fn,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74861 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74861 = (function (path,reduce_fn,late,late_fn,meta74862){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta74862 = meta74862;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74861.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74863,meta74862__$1){
var self__ = this;
var _74863__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74861(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta74862__$1));
}));

(com.rpl.specter.t_com$rpl$specter74861.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74863){
var self__ = this;
var _74863__$1 = this;
return self__.meta74862;
}));

(com.rpl.specter.t_com$rpl$specter74861.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74861.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter74861.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter74861.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta74862","meta74862",-1097774904,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74861.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74861.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74861");

(com.rpl.specter.t_com$rpl$specter74861.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74861");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74861.
 */
com.rpl.specter.__GT_t_com$rpl$specter74861 = (function com$rpl$specter$__GT_t_com$rpl$specter74861(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta74862){
return (new com.rpl.specter.t_com$rpl$specter74861(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta74862));
});

}

return (new com.rpl.specter.t_com$rpl$specter74861(path,reduce_fn,late,late_fn,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__74865 = (function (p1__74864_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__74864_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74865) : com.rpl.specter.pred.call(null,G__74865));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__74867 = (function (p1__74866_SHARP_){
return (p1__74866_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74867) : com.rpl.specter.pred.call(null,G__74867));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__74869 = (function (p1__74868_SHARP_){
return (p1__74868_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74869) : com.rpl.specter.pred.call(null,G__74869));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__74871 = (function (p1__74870_SHARP_){
return (p1__74870_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74871) : com.rpl.specter.pred.call(null,G__74871));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__74873 = (function (p1__74872_SHARP_){
return (p1__74872_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74873) : com.rpl.specter.pred.call(null,G__74873));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__74874 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74874) : next_fn.call(null,G__74874));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__74875 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74875) : next_fn.call(null,G__74875));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74876 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74876 = (function (v,meta74877){
this.v = v;
this.meta74877 = meta74877;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74876.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74878,meta74877__$1){
var self__ = this;
var _74878__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74876(self__.v,meta74877__$1));
}));

(com.rpl.specter.t_com$rpl$specter74876.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74878){
var self__ = this;
var _74878__$1 = this;
return self__.meta74877;
}));

(com.rpl.specter.t_com$rpl$specter74876.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74876.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter74876.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter74876.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta74877","meta74877",583405580,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74876.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74876.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74876");

(com.rpl.specter.t_com$rpl$specter74876.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74876");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74876.
 */
com.rpl.specter.__GT_t_com$rpl$specter74876 = (function com$rpl$specter$__GT_t_com$rpl$specter74876(v__$1,meta74877){
return (new com.rpl.specter.t_com$rpl$specter74876(v__$1,meta74877));
});

}

return (new com.rpl.specter.t_com$rpl$specter74876(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__74880 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__74880) : com.rpl.specter.nil__GT_val.call(null,G__74880));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__74881 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__74881) : com.rpl.specter.nil__GT_val.call(null,G__74881));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__74882 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__74882) : com.rpl.specter.nil__GT_val.call(null,G__74882));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__74883 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74883) : next_fn.call(null,G__74883));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__74884 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74884) : next_fn.call(null,G__74884));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74885 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74885 = (function (meta74886){
this.meta74886 = meta74886;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74885.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74887,meta74886__$1){
var self__ = this;
var _74887__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74885(meta74886__$1));
}));

(com.rpl.specter.t_com$rpl$specter74885.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74887){
var self__ = this;
var _74887__$1 = this;
return self__.meta74886;
}));

(com.rpl.specter.t_com$rpl$specter74885.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74885.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter74885.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter74885.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74886","meta74886",-1719339407,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74885.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74885.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74885");

(com.rpl.specter.t_com$rpl$specter74885.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74885");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74885.
 */
com.rpl.specter.__GT_t_com$rpl$specter74885 = (function com$rpl$specter$__GT_t_com$rpl$specter74885(meta74886){
return (new com.rpl.specter.t_com$rpl$specter74885(meta74886));
});

}

return (new com.rpl.specter.t_com$rpl$specter74885(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__74888 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74888) : next_fn.call(null,G__74888));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__74889 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74889) : next_fn.call(null,G__74889));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74890 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74890 = (function (meta74891){
this.meta74891 = meta74891;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74890.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74892,meta74891__$1){
var self__ = this;
var _74892__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74890(meta74891__$1));
}));

(com.rpl.specter.t_com$rpl$specter74890.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74892){
var self__ = this;
var _74892__$1 = this;
return self__.meta74891;
}));

(com.rpl.specter.t_com$rpl$specter74890.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74890.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter74890.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter74890.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74891","meta74891",-767495966,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74890.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74890.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74890");

(com.rpl.specter.t_com$rpl$specter74890.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74890");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74890.
 */
com.rpl.specter.__GT_t_com$rpl$specter74890 = (function com$rpl$specter$__GT_t_com$rpl$specter74890(meta74891){
return (new com.rpl.specter.t_com$rpl$specter74890(meta74891));
});

}

return (new com.rpl.specter.t_com$rpl$specter74890(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__74893 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74893) : next_fn.call(null,G__74893));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__74894 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74894) : next_fn.call(null,G__74894));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74895 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74895 = (function (meta74896){
this.meta74896 = meta74896;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74895.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74897,meta74896__$1){
var self__ = this;
var _74897__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74895(meta74896__$1));
}));

(com.rpl.specter.t_com$rpl$specter74895.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74897){
var self__ = this;
var _74897__$1 = this;
return self__.meta74896;
}));

(com.rpl.specter.t_com$rpl$specter74895.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74895.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter74895.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__38832__auto__,vals__38833__auto__,structure,next_fn__38834__auto__){
var self__ = this;
var this__38832__auto____$1 = this;
var next_fn = (function (s__38835__auto__){
return (next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__38834__auto__.cljs$core$IFn$_invoke$arity$2(vals__38833__auto__,s__38835__auto__) : next_fn__38834__auto__.call(null,vals__38833__auto__,s__38835__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter74895.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74896","meta74896",703569615,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74895.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74895.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74895");

(com.rpl.specter.t_com$rpl$specter74895.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74895");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74895.
 */
com.rpl.specter.__GT_t_com$rpl$specter74895 = (function com$rpl$specter$__GT_t_com$rpl$specter74895(meta74896){
return (new com.rpl.specter.t_com$rpl$specter74895(meta74896));
});

}

return (new com.rpl.specter.t_com$rpl$specter74895(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75003__delegate = function (path){
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74898 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74898 = (function (path,late,meta74899){
this.path = path;
this.late = late;
this.meta74899 = meta74899;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74898.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74900,meta74899__$1){
var self__ = this;
var _74900__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74898(self__.path,self__.late,meta74899__$1));
}));

(com.rpl.specter.t_com$rpl$specter74898.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74900){
var self__ = this;
var _74900__$1 = this;
return self__.meta74899;
}));

(com.rpl.specter.t_com$rpl$specter74898.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74898.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39616__auto__,vals__39617__auto__,structure,next_fn__39618__auto__){
var self__ = this;
var this__39616__auto____$1 = this;
var G__74901 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39617__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__74902 = structure;
return (next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2(G__74901,G__74902) : next_fn__39618__auto__.call(null,G__74901,G__74902));
}));

(com.rpl.specter.t_com$rpl$specter74898.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39616__auto__,vals__39617__auto__,structure,next_fn__39618__auto__){
var self__ = this;
var this__39616__auto____$1 = this;
var G__74903 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39617__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__74904 = structure;
return (next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2(G__74903,G__74904) : next_fn__39618__auto__.call(null,G__74903,G__74904));
}));

(com.rpl.specter.t_com$rpl$specter74898.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74899","meta74899",-966333370,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74898.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74898.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74898");

(com.rpl.specter.t_com$rpl$specter74898.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74898");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74898.
 */
com.rpl.specter.__GT_t_com$rpl$specter74898 = (function com$rpl$specter$__GT_t_com$rpl$specter74898(path__$1,late__$1,meta74899){
return (new com.rpl.specter.t_com$rpl$specter74898(path__$1,late__$1,meta74899));
});

}

return (new com.rpl.specter.t_com$rpl$specter74898(path,late,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
};
var G__75003 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75004__i = 0, G__75004__a = new Array(arguments.length -  0);
while (G__75004__i < G__75004__a.length) {G__75004__a[G__75004__i] = arguments[G__75004__i + 0]; ++G__75004__i;}
  path = new cljs.core.IndexedSeq(G__75004__a,0,null);
} 
return G__75003__delegate.call(this,path);};
G__75003.cljs$lang$maxFixedArity = 0;
G__75003.cljs$lang$applyTo = (function (arglist__75005){
var path = cljs.core.seq(arglist__75005);
return G__75003__delegate(path);
});
G__75003.cljs$core$IFn$_invoke$arity$variadic = G__75003__delegate;
return G__75003;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75006__delegate = function (path){
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74905 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74905 = (function (path,late,meta74906){
this.path = path;
this.late = late;
this.meta74906 = meta74906;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74905.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74907,meta74906__$1){
var self__ = this;
var _74907__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74905(self__.path,self__.late,meta74906__$1));
}));

(com.rpl.specter.t_com$rpl$specter74905.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74907){
var self__ = this;
var _74907__$1 = this;
return self__.meta74906;
}));

(com.rpl.specter.t_com$rpl$specter74905.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74905.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39616__auto__,vals__39617__auto__,structure,next_fn__39618__auto__){
var self__ = this;
var this__39616__auto____$1 = this;
var G__74908 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39617__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__74909 = structure;
return (next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2(G__74908,G__74909) : next_fn__39618__auto__.call(null,G__74908,G__74909));
}));

(com.rpl.specter.t_com$rpl$specter74905.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39616__auto__,vals__39617__auto__,structure,next_fn__39618__auto__){
var self__ = this;
var this__39616__auto____$1 = this;
var G__74910 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39617__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__74911 = structure;
return (next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2(G__74910,G__74911) : next_fn__39618__auto__.call(null,G__74910,G__74911));
}));

(com.rpl.specter.t_com$rpl$specter74905.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74906","meta74906",-1012863044,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74905.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74905.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74905");

(com.rpl.specter.t_com$rpl$specter74905.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74905");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74905.
 */
com.rpl.specter.__GT_t_com$rpl$specter74905 = (function com$rpl$specter$__GT_t_com$rpl$specter74905(path__$1,late__$1,meta74906){
return (new com.rpl.specter.t_com$rpl$specter74905(path__$1,late__$1,meta74906));
});

}

return (new com.rpl.specter.t_com$rpl$specter74905(path,late,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
};
var G__75006 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75007__i = 0, G__75007__a = new Array(arguments.length -  0);
while (G__75007__i < G__75007__a.length) {G__75007__a[G__75007__i] = arguments[G__75007__i + 0]; ++G__75007__i;}
  path = new cljs.core.IndexedSeq(G__75007__a,0,null);
} 
return G__75006__delegate.call(this,path);};
G__75006.cljs$lang$maxFixedArity = 0;
G__75006.cljs$lang$applyTo = (function (arglist__75008){
var path = cljs.core.seq(arglist__75008);
return G__75006__delegate(path);
});
G__75006.cljs$core$IFn$_invoke$arity$variadic = G__75006__delegate;
return G__75006;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74913 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74913 = (function (val,meta74914){
this.val = val;
this.meta74914 = meta74914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74915,meta74914__$1){
var self__ = this;
var _74915__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74913(self__.val,meta74914__$1));
}));

(com.rpl.specter.t_com$rpl$specter74913.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74915){
var self__ = this;
var _74915__$1 = this;
return self__.meta74914;
}));

(com.rpl.specter.t_com$rpl$specter74913.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74913.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39616__auto__,vals__39617__auto__,structure,next_fn__39618__auto__){
var self__ = this;
var this__39616__auto____$1 = this;
var G__74916 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39617__auto__,self__.val);
var G__74917 = structure;
return (next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2(G__74916,G__74917) : next_fn__39618__auto__.call(null,G__74916,G__74917));
}));

(com.rpl.specter.t_com$rpl$specter74913.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39616__auto__,vals__39617__auto__,structure,next_fn__39618__auto__){
var self__ = this;
var this__39616__auto____$1 = this;
var G__74918 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39617__auto__,self__.val);
var G__74919 = structure;
return (next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39618__auto__.cljs$core$IFn$_invoke$arity$2(G__74918,G__74919) : next_fn__39618__auto__.call(null,G__74918,G__74919));
}));

(com.rpl.specter.t_com$rpl$specter74913.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta74914","meta74914",-1260307036,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74913.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74913.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74913");

(com.rpl.specter.t_com$rpl$specter74913.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74913");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74913.
 */
com.rpl.specter.__GT_t_com$rpl$specter74913 = (function com$rpl$specter$__GT_t_com$rpl$specter74913(val__$1,meta74914){
return (new com.rpl.specter.t_com$rpl$specter74913(val__$1,meta74914));
});

}

return (new com.rpl.specter.t_com$rpl$specter74913(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75009__delegate = function (path){
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74920 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74920 = (function (path,late,meta74921){
this.path = path;
this.late = late;
this.meta74921 = meta74921;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74920.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74922,meta74921__$1){
var self__ = this;
var _74922__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74920(self__.path,self__.late,meta74921__$1));
}));

(com.rpl.specter.t_com$rpl$specter74920.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74922){
var self__ = this;
var _74922__$1 = this;
return self__.meta74921;
}));

(com.rpl.specter.t_com$rpl$specter74920.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74920.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter74920.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter74920.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74921","meta74921",304430905,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74920.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74920.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74920");

(com.rpl.specter.t_com$rpl$specter74920.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74920");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74920.
 */
com.rpl.specter.__GT_t_com$rpl$specter74920 = (function com$rpl$specter$__GT_t_com$rpl$specter74920(path__$1,late__$1,meta74921){
return (new com.rpl.specter.t_com$rpl$specter74920(path__$1,late__$1,meta74921));
});

}

return (new com.rpl.specter.t_com$rpl$specter74920(path,late,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
};
var G__75009 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75010__i = 0, G__75010__a = new Array(arguments.length -  0);
while (G__75010__i < G__75010__a.length) {G__75010__a[G__75010__i] = arguments[G__75010__i + 0]; ++G__75010__i;}
  path = new cljs.core.IndexedSeq(G__75010__a,0,null);
} 
return G__75009__delegate.call(this,path);};
G__75009.cljs$lang$maxFixedArity = 0;
G__75009.cljs$lang$applyTo = (function (arglist__75011){
var path = cljs.core.seq(arglist__75011);
return G__75009__delegate(path);
});
G__75009.cljs$core$IFn$_invoke$arity$variadic = G__75009__delegate;
return G__75009;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74925 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74925 = (function (meta74926){
this.meta74926 = meta74926;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74925.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74927,meta74926__$1){
var self__ = this;
var _74927__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74925(meta74926__$1));
}));

(com.rpl.specter.t_com$rpl$specter74925.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74927){
var self__ = this;
var _74927__$1 = this;
return self__.meta74926;
}));

(com.rpl.specter.t_com$rpl$specter74925.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74925.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__74928 = cljs.core.PersistentVector.EMPTY;
var G__74929 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__74928,G__74929) : next_fn.call(null,G__74928,G__74929));
}));

(com.rpl.specter.t_com$rpl$specter74925.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__74930 = cljs.core.PersistentVector.EMPTY;
var G__74931 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__74930,G__74931) : next_fn.call(null,G__74930,G__74931));
}));

(com.rpl.specter.t_com$rpl$specter74925.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74926","meta74926",619920832,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74925.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74925.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74925");

(com.rpl.specter.t_com$rpl$specter74925.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74925");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74925.
 */
com.rpl.specter.__GT_t_com$rpl$specter74925 = (function com$rpl$specter$__GT_t_com$rpl$specter74925(meta74926){
return (new com.rpl.specter.t_com$rpl$specter74925(meta74926));
});

}

return (new com.rpl.specter.t_com$rpl$specter74925(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__75012 = null;
var G__75012__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__75012__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74934 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74934 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta74935){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta74935 = meta74935;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74934.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74936,meta74935__$1){
var self__ = this;
var _74936__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74934(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta74935__$1));
}));

(com.rpl.specter.t_com$rpl$specter74934.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74936){
var self__ = this;
var _74936__$1 = this;
return self__.meta74935;
}));

(com.rpl.specter.t_com$rpl$specter74934.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74934.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter74934.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter74934.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta74935","meta74935",-2096936318,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74934.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74934.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74934");

(com.rpl.specter.t_com$rpl$specter74934.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74934");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74934.
 */
com.rpl.specter.__GT_t_com$rpl$specter74934 = (function com$rpl$specter$__GT_t_com$rpl$specter74934(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta74935){
return (new com.rpl.specter.t_com$rpl$specter74934(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta74935));
});

}

return (new com.rpl.specter.t_com$rpl$specter74934(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
} else {
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74937 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74937 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta74938){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta74938 = meta74938;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74937.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74939,meta74938__$1){
var self__ = this;
var _74939__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74937(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta74938__$1));
}));

(com.rpl.specter.t_com$rpl$specter74937.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74939){
var self__ = this;
var _74939__$1 = this;
return self__.meta74938;
}));

(com.rpl.specter.t_com$rpl$specter74937.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74937.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__74932_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__74932_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter74937.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__74933_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__74933_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter74937.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta74938","meta74938",-2136150706,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74937.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74937.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74937");

(com.rpl.specter.t_com$rpl$specter74937.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74937");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74937.
 */
com.rpl.specter.__GT_t_com$rpl$specter74937 = (function com$rpl$specter$__GT_t_com$rpl$specter74937(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta74938){
return (new com.rpl.specter.t_com$rpl$specter74937(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta74938));
});

}

return (new com.rpl.specter.t_com$rpl$specter74937(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
}
});
G__75012 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__75012__2.call(this,cond_p,then_path);
case 3:
return G__75012__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__75012.cljs$core$IFn$_invoke$arity$2 = G__75012__2;
G__75012.cljs$core$IFn$_invoke$arity$3 = G__75012__3;
return G__75012;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75013__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__74940){
var vec__74941 = p__74940;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74941,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74941,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__75013 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__75014__i = 0, G__75014__a = new Array(arguments.length -  0);
while (G__75014__i < G__75014__a.length) {G__75014__a[G__75014__i] = arguments[G__75014__i + 0]; ++G__75014__i;}
  conds = new cljs.core.IndexedSeq(G__75014__a,0,null);
} 
return G__75013__delegate.call(this,conds);};
G__75013.cljs$lang$maxFixedArity = 0;
G__75013.cljs$lang$applyTo = (function (arglist__75015){
var conds = cljs.core.seq(arglist__75015);
return G__75013__delegate(conds);
});
G__75013.cljs$core$IFn$_invoke$arity$variadic = G__75013__delegate;
return G__75013;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__75016 = null;
var G__75016__0 = (function (){
return com.rpl.specter.STAY;
});
var G__75016__1 = (function (path){
return path;
});
var G__75016__2 = (function (path1,path2){
var builder__39619__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74944 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74944 = (function (path1,path2,late1,late2,meta74945){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta74945 = meta74945;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74944.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74946,meta74945__$1){
var self__ = this;
var _74946__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74944(self__.path1,self__.path2,self__.late1,self__.late2,meta74945__$1));
}));

(com.rpl.specter.t_com$rpl$specter74944.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74946){
var self__ = this;
var _74946__$1 = this;
return self__.meta74945;
}));

(com.rpl.specter.t_com$rpl$specter74944.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74944.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter74944.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74944.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta74945","meta74945",-354405754,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74944.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74944.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74944");

(com.rpl.specter.t_com$rpl$specter74944.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74944");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74944.
 */
com.rpl.specter.__GT_t_com$rpl$specter74944 = (function com$rpl$specter$__GT_t_com$rpl$specter74944(path1__$1,path2__$1,late1__$1,late2__$1,meta74945){
return (new com.rpl.specter.t_com$rpl$specter74944(path1__$1,path2__$1,late1__$1,late2__$1,meta74945));
});

}

return (new com.rpl.specter.t_com$rpl$specter74944(path1,path2,late1,late2,null));
}));
var curr_params__39620__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39620__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39619__auto__,curr_params__39620__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39619__auto__,curr_params__39620__auto__,null);
}
});
var G__75016__3 = (function() { 
var G__75017__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__75017 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__75018__i = 0, G__75018__a = new Array(arguments.length -  2);
while (G__75018__i < G__75018__a.length) {G__75018__a[G__75018__i] = arguments[G__75018__i + 2]; ++G__75018__i;}
  paths = new cljs.core.IndexedSeq(G__75018__a,0,null);
} 
return G__75017__delegate.call(this,path1,path2,paths);};
G__75017.cljs$lang$maxFixedArity = 2;
G__75017.cljs$lang$applyTo = (function (arglist__75019){
var path1 = cljs.core.first(arglist__75019);
arglist__75019 = cljs.core.next(arglist__75019);
var path2 = cljs.core.first(arglist__75019);
var paths = cljs.core.rest(arglist__75019);
return G__75017__delegate(path1,path2,paths);
});
G__75017.cljs$core$IFn$_invoke$arity$variadic = G__75017__delegate;
return G__75017;
})()
;
G__75016 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__75016__0.call(this);
case 1:
return G__75016__1.call(this,path1);
case 2:
return G__75016__2.call(this,path1,path2);
default:
var G__75020 = null;
if (arguments.length > 2) {
var G__75021__i = 0, G__75021__a = new Array(arguments.length -  2);
while (G__75021__i < G__75021__a.length) {G__75021__a[G__75021__i] = arguments[G__75021__i + 2]; ++G__75021__i;}
G__75020 = new cljs.core.IndexedSeq(G__75021__a,0,null);
}
return G__75016__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__75020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__75016.cljs$lang$maxFixedArity = 2;
G__75016.cljs$lang$applyTo = G__75016__3.cljs$lang$applyTo;
G__75016.cljs$core$IFn$_invoke$arity$0 = G__75016__0;
G__75016.cljs$core$IFn$_invoke$arity$1 = G__75016__1;
G__75016.cljs$core$IFn$_invoke$arity$2 = G__75016__2;
G__75016.cljs$core$IFn$_invoke$arity$variadic = G__75016__3.cljs$core$IFn$_invoke$arity$variadic;
return G__75016;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75022__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__75022 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75023__i = 0, G__75023__a = new Array(arguments.length -  0);
while (G__75023__i < G__75023__a.length) {G__75023__a[G__75023__i] = arguments[G__75023__i + 0]; ++G__75023__i;}
  path = new cljs.core.IndexedSeq(G__75023__a,0,null);
} 
return G__75022__delegate.call(this,path);};
G__75022.cljs$lang$maxFixedArity = 0;
G__75022.cljs$lang$applyTo = (function (arglist__75024){
var path = cljs.core.seq(arglist__75024);
return G__75022__delegate(path);
});
G__75022.cljs$core$IFn$_invoke$arity$variadic = G__75022__delegate;
return G__75022;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75025__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__75025 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75026__i = 0, G__75026__a = new Array(arguments.length -  0);
while (G__75026__i < G__75026__a.length) {G__75026__a[G__75026__i] = arguments[G__75026__i + 0]; ++G__75026__i;}
  path = new cljs.core.IndexedSeq(G__75026__a,0,null);
} 
return G__75025__delegate.call(this,path);};
G__75025.cljs$lang$maxFixedArity = 0;
G__75025.cljs$lang$applyTo = (function (arglist__75027){
var path = cljs.core.seq(arglist__75027);
return G__75025__delegate(path);
});
G__75025.cljs$core$IFn$_invoke$arity$variadic = G__75025__delegate;
return G__75025;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__39626__auto__ = com.rpl.specter.pathcache74952;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74953 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache74952 = info74953;

return info74953;
})():info__39626__auto__);
var precompiled74954 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74955 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled74954.cljs$core$IFn$_invoke$arity$1 ? precompiled74954.cljs$core$IFn$_invoke$arity$1(G__74955) : precompiled74954.call(null,G__74955));
} else {
return precompiled74954;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__39626__auto__ = com.rpl.specter.pathcache74956;
var info__39626__auto____$1 = (((info__39626__auto__ == null))?(function (){var info74957 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,689,691,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache74956 = info74957;

return info74957;
})():info__39626__auto__);
var precompiled74958 = com.rpl.specter.impl.cached_path_info_precompiled(info__39626__auto____$1);
var dynamic_QMARK___39627__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39626__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39627__auto__)){
var G__74959 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled74958.cljs$core$IFn$_invoke$arity$1 ? precompiled74958.cljs$core$IFn$_invoke$arity$1(G__74959) : precompiled74958.call(null,G__74959));
} else {
return precompiled74958;
}
})());

return p;
}));
var empty__GT_NONE_75028 = (function (){var G__74960 = cljs.core.empty_QMARK_;
var G__74961 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__74960,G__74961) : com.rpl.specter.if_path.call(null,G__74960,G__74961));
})();
var compact_STAR__75029 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_75028) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_75028));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__75030__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__75029,path);
};
var G__75030 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__75031__i = 0, G__75031__a = new Array(arguments.length -  0);
while (G__75031__i < G__75031__a.length) {G__75031__a[G__75031__i] = arguments[G__75031__i + 0]; ++G__75031__i;}
  path = new cljs.core.IndexedSeq(G__75031__a,0,null);
} 
return G__75030__delegate.call(this,path);};
G__75030.cljs$lang$maxFixedArity = 0;
G__75030.cljs$lang$applyTo = (function (arglist__75032){
var path = cljs.core.seq(arglist__75032);
return G__75030__delegate(path);
});
G__75030.cljs$core$IFn$_invoke$arity$variadic = G__75030__delegate;
return G__75030;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
