goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__66732 = (line + (1));
var G__66733 = (1);
var G__66734 = (counter + (1));
line = G__66732;
col = G__66733;
counter = G__66734;
continue;
} else {
var G__66735 = line;
var G__66736 = (col + (1));
var G__66737 = (counter + (1));
line = G__66735;
col = G__66736;
counter = G__66737;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__66738 = cljs.core.next(chars);
var G__66739 = (n__$1 - (1));
chars = G__66738;
n__$1 = G__66739;
continue;
} else {
var G__66740 = cljs.core.next(chars);
var G__66741 = n__$1;
chars = G__66740;
n__$1 = G__66741;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__66720){
var map__66721 = p__66720;
var map__66721__$1 = (((((!((map__66721 == null))))?(((((map__66721.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66721.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66721):map__66721);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66721__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66721__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66721__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66721__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__66723_66742 = cljs.core.seq(full_reasons);
var chunk__66724_66743 = null;
var count__66725_66744 = (0);
var i__66726_66745 = (0);
while(true){
if((i__66726_66745 < count__66725_66744)){
var r_66746 = chunk__66724_66743.cljs$core$IIndexed$_nth$arity$2(null,i__66726_66745);
instaparse.failure.print_reason(r_66746);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__66747 = seq__66723_66742;
var G__66748 = chunk__66724_66743;
var G__66749 = count__66725_66744;
var G__66750 = (i__66726_66745 + (1));
seq__66723_66742 = G__66747;
chunk__66724_66743 = G__66748;
count__66725_66744 = G__66749;
i__66726_66745 = G__66750;
continue;
} else {
var temp__5735__auto___66751 = cljs.core.seq(seq__66723_66742);
if(temp__5735__auto___66751){
var seq__66723_66752__$1 = temp__5735__auto___66751;
if(cljs.core.chunked_seq_QMARK_(seq__66723_66752__$1)){
var c__4550__auto___66753 = cljs.core.chunk_first(seq__66723_66752__$1);
var G__66754 = cljs.core.chunk_rest(seq__66723_66752__$1);
var G__66755 = c__4550__auto___66753;
var G__66756 = cljs.core.count(c__4550__auto___66753);
var G__66757 = (0);
seq__66723_66742 = G__66754;
chunk__66724_66743 = G__66755;
count__66725_66744 = G__66756;
i__66726_66745 = G__66757;
continue;
} else {
var r_66758 = cljs.core.first(seq__66723_66752__$1);
instaparse.failure.print_reason(r_66758);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__66759 = cljs.core.next(seq__66723_66752__$1);
var G__66760 = null;
var G__66761 = (0);
var G__66762 = (0);
seq__66723_66742 = G__66759;
chunk__66724_66743 = G__66760;
count__66725_66744 = G__66761;
i__66726_66745 = G__66762;
continue;
}
} else {
}
}
break;
}

var seq__66728 = cljs.core.seq(partial_reasons);
var chunk__66729 = null;
var count__66730 = (0);
var i__66731 = (0);
while(true){
if((i__66731 < count__66730)){
var r = chunk__66729.cljs$core$IIndexed$_nth$arity$2(null,i__66731);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__66763 = seq__66728;
var G__66764 = chunk__66729;
var G__66765 = count__66730;
var G__66766 = (i__66731 + (1));
seq__66728 = G__66763;
chunk__66729 = G__66764;
count__66730 = G__66765;
i__66731 = G__66766;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__66728);
if(temp__5735__auto__){
var seq__66728__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__66728__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__66728__$1);
var G__66767 = cljs.core.chunk_rest(seq__66728__$1);
var G__66768 = c__4550__auto__;
var G__66769 = cljs.core.count(c__4550__auto__);
var G__66770 = (0);
seq__66728 = G__66767;
chunk__66729 = G__66768;
count__66730 = G__66769;
i__66731 = G__66770;
continue;
} else {
var r = cljs.core.first(seq__66728__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__66772 = cljs.core.next(seq__66728__$1);
var G__66773 = null;
var G__66774 = (0);
var G__66775 = (0);
seq__66728 = G__66772;
chunk__66729 = G__66773;
count__66730 = G__66774;
i__66731 = G__66775;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=instaparse.failure.js.map
