goog.provide('pinkgorilla.notebook.hydration');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('pinkgorilla.notebook.uuid');
goog.require('pinkgorilla.encoding.protocols');
goog.require('pinkgorilla.storage.protocols');
pinkgorilla.notebook.hydration.assoc_when = (function pinkgorilla$notebook$hydration$assoc_when(r,key,val){
if(cljs.core.truth_(val)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(r,key,val);
} else {
return r;
}
});
pinkgorilla.notebook.hydration.process_type = (function pinkgorilla$notebook$hydration$process_type(segment,type,fun){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(segment))){
return (fun.cljs$core$IFn$_invoke$arity$1 ? fun.cljs$core$IFn$_invoke$arity$1(segment) : fun.call(null,segment));
} else {
return segment;
}
});
pinkgorilla.notebook.hydration.dissoc_in = (function pinkgorilla$notebook$hydration$dissoc_in(m,p__68179){
var vec__68180 = p__68179;
var seq__68181 = cljs.core.seq(vec__68180);
var first__68182 = cljs.core.first(seq__68181);
var seq__68181__$1 = cljs.core.next(seq__68181);
var k = first__68182;
var ks = seq__68181__$1;
var keys = vec__68180;
if(ks){
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(temp__5733__auto__)){
var nextmap = temp__5733__auto__;
var newmap = (pinkgorilla.notebook.hydration.dissoc_in.cljs$core$IFn$_invoke$arity$2 ? pinkgorilla.notebook.hydration.dissoc_in.cljs$core$IFn$_invoke$arity$2(nextmap,ks) : pinkgorilla.notebook.hydration.dissoc_in.call(null,nextmap,ks));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,newmap);
} else {
return m;
}
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
}
});
pinkgorilla.notebook.hydration.hydrate_md = (function pinkgorilla$notebook$hydration$hydrate_md(s){
var md = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"value","value",305978217)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"md","md",707286655),new cljs.core.Keyword(null,"md","md",707286655),md], null);
});
pinkgorilla.notebook.hydration.hydrate_code = (function pinkgorilla$notebook$hydration$hydrate_code(s){
var code = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"value","value",305978217)], null));
var picasso_spec = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"value-response","value-response",-1249272942)], null));
var out = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"console-response","console-response",81719661)], null));
return pinkgorilla.notebook.hydration.assoc_when(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.hydration.assoc_when(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.hydration.assoc_when(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.Keyword(null,"content","content",15833224)),new cljs.core.Keyword(null,"code","code",1586293142),code),new cljs.core.Keyword(null,"value-response","value-response",-1249272942)),new cljs.core.Keyword(null,"picasso","picasso",-1388478491),picasso_spec),new cljs.core.Keyword(null,"console-response","console-response",81719661)),new cljs.core.Keyword(null,"out","out",-910545517),out);
});
pinkgorilla.notebook.hydration.hydrate_segment = (function pinkgorilla$notebook$hydration$hydrate_segment(segment){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(pinkgorilla.notebook.hydration.process_type(pinkgorilla.notebook.hydration.process_type(segment,new cljs.core.Keyword(null,"code","code",1586293142),pinkgorilla.notebook.hydration.hydrate_code),new cljs.core.Keyword(null,"free","free",801364328),pinkgorilla.notebook.hydration.hydrate_md),new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.notebook.uuid.id());
});
pinkgorilla.notebook.hydration.to_key = (function pinkgorilla$notebook$hydration$to_key(segment){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(segment),segment]);
});
pinkgorilla.notebook.hydration.hydrate = (function pinkgorilla$notebook$hydration$hydrate(notebook){
var segments = new cljs.core.Keyword(null,"segments","segments",1937535949).cljs$core$IFn$_invoke$arity$1(notebook);
var segments_hydrated = cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.hydration.hydrate_segment,segments));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"active","active",1895962068),null,new cljs.core.Keyword(null,"ns","ns",441598760),null,new cljs.core.Keyword(null,"queued","queued",1701634607),cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(notebook),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"segments","segments",1937535949),cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.hydration.to_key,segments_hydrated)),new cljs.core.Keyword(null,"order","order",-1254677256),cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"id","id",-1388402092),segments_hydrated))], 0));
});
pinkgorilla.notebook.hydration.load_notebook = (function pinkgorilla$notebook$hydration$load_notebook(storage,tokens){
var temp__5733__auto__ = pinkgorilla.storage.protocols.determine_encoding(storage);
if(cljs.core.truth_(temp__5733__auto__)){
var encoding_type = temp__5733__auto__;
return pinkgorilla.notebook.hydration.hydrate(pinkgorilla.encoding.protocols.decode.cljs$core$IFn$_invoke$arity$2(encoding_type,pinkgorilla.storage.protocols.storage_load(storage,tokens)));
} else {
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"pinkgorilla.notebook.hydration","/tmp/form-init5873427328806648633.clj",76,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cannot load notebook - format cannot be determined! ",storage], null);
}),null)),null,908677536);

return null;
}
});
pinkgorilla.notebook.hydration.segments_ordered = (function pinkgorilla$notebook$hydration$segments_ordered(notebook){
var segments = new cljs.core.Keyword(null,"segments","segments",1937535949).cljs$core$IFn$_invoke$arity$1(notebook);
var segment_ids_ordered = new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(notebook);
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__68183_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(segments,p1__68183_SHARP_);
}),segment_ids_ordered));
});
pinkgorilla.notebook.hydration.dehydrate_md = (function pinkgorilla$notebook$hydration$dehydrate_md(s){
var md = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"md","md",707286655)], null));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"free","free",801364328),new cljs.core.Keyword(null,"markup-visible","markup-visible",447471311),false,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"text/x-markdown",new cljs.core.Keyword(null,"value","value",305978217),md], null)], null);
});
pinkgorilla.notebook.hydration.dehydrate_code = (function pinkgorilla$notebook$hydration$dehydrate_code(segment){
var map__68184 = segment;
var map__68184__$1 = (((((!((map__68184 == null))))?(((((map__68184.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68184.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68184):map__68184);
var kernel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68184__$1,new cljs.core.Keyword(null,"kernel","kernel",-650895913));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68184__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var picasso__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68184__$1,new cljs.core.Keyword(null,"picasso","picasso",-1388478491));
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68184__$1,new cljs.core.Keyword(null,"out","out",-910545517));
return pinkgorilla.notebook.hydration.assoc_when(pinkgorilla.notebook.hydration.assoc_when(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"kernel","kernel",-650895913),kernel,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"text/x-clojure",new cljs.core.Keyword(null,"value","value",305978217),code], null)], null),new cljs.core.Keyword(null,"value-response","value-response",-1249272942),picasso__$1),new cljs.core.Keyword(null,"console-response","console-response",81719661),out);
});
pinkgorilla.notebook.hydration.dehydrate_segment = (function pinkgorilla$notebook$hydration$dehydrate_segment(segment){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.hydration.process_type(pinkgorilla.notebook.hydration.process_type(segment,new cljs.core.Keyword(null,"code","code",1586293142),pinkgorilla.notebook.hydration.dehydrate_code),new cljs.core.Keyword(null,"md","md",707286655),pinkgorilla.notebook.hydration.dehydrate_md),new cljs.core.Keyword(null,"id","id",-1388402092));
});
pinkgorilla.notebook.hydration.dehydrate = (function pinkgorilla$notebook$hydration$dehydrate(notebook){
var segments = pinkgorilla.notebook.hydration.segments_ordered(notebook);
var segments_dehydrated = cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.hydration.dehydrate_segment,segments));
var notebook_dehydrated = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(notebook),new cljs.core.Keyword(null,"segments","segments",1937535949),segments_dehydrated], null);
return notebook_dehydrated;
});
pinkgorilla.notebook.hydration.tap = (function pinkgorilla$notebook$hydration$tap(note,x){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook.hydration","/tmp/form-init5873427328806648633.clj",123,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [note,x], null);
}),null)),null,358829017);

return x;
});
pinkgorilla.notebook.hydration.save_nb = (function pinkgorilla$notebook$hydration$save_nb(storage,tokens,nb){
return pinkgorilla.storage.protocols.storage_save(storage,nb,tokens);
});
pinkgorilla.notebook.hydration.save_notebook = (function pinkgorilla$notebook$hydration$save_notebook(storage,tokens,notebook){
var temp__5733__auto__ = pinkgorilla.storage.protocols.determine_encoding(storage);
if(cljs.core.truth_(temp__5733__auto__)){
var format = temp__5733__auto__;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook.hydration","/tmp/form-init5873427328806648633.clj",131,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["saving notebook with format: ",format], null);
}),null)),null,18045223);

pinkgorilla.notebook.hydration.save_nb(storage,tokens,pinkgorilla.encoding.protocols.encode.cljs$core$IFn$_invoke$arity$2(format,pinkgorilla.notebook.hydration.dehydrate(notebook)));

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"success","success",1890645906),"notebook saved!"], null);
} else {
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"pinkgorilla.notebook.hydration","/tmp/form-init5873427328806648633.clj",139,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["could not save notebook, because encoding cannot be determined: ",storage], null);
}),null)),null,-1522626641);

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),"could not determine storage-format!"], null);
}
});
/**
 * creates a markdown segment
 */
pinkgorilla.notebook.hydration.create_free_segment = (function pinkgorilla$notebook$hydration$create_free_segment(content){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.notebook.uuid.id(),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"free","free",801364328),new cljs.core.Keyword(null,"markup-visible","markup-visible",447471311),false,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4120__auto__ = content;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "";
}
})(),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-markdown"], null)], null);
});
pinkgorilla.notebook.hydration.create_code_segment = (function pinkgorilla$notebook$hydration$create_code_segment(content){
return new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"id","id",-1388402092),pinkgorilla.notebook.uuid.id(),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"kernel","kernel",-650895913),new cljs.core.Keyword(null,"clj","clj",-660495428),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4120__auto__ = content;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "";
}
})(),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-clojure"], null),new cljs.core.Keyword(null,"console-response","console-response",81719661),"",new cljs.core.Keyword(null,"value-response","value-response",-1249272942),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"html",new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991)], null)], null),new cljs.core.Keyword(null,"error-text","error-text",2021893718),null,new cljs.core.Keyword(null,"exception","exception",-335277064),null], null);
});
pinkgorilla.notebook.hydration.to_code_segment = (function pinkgorilla$notebook$hydration$to_code_segment(free_segment){
return new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(free_segment),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"kernel","kernel",-650895913),new cljs.core.Keyword(null,"clj","clj",-660495428),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(free_segment,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"value","value",305978217)], null)),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-clojure"], null),new cljs.core.Keyword(null,"console-response","console-response",81719661),null,new cljs.core.Keyword(null,"value-response","value-response",-1249272942),null,new cljs.core.Keyword(null,"error-text","error-text",2021893718),null,new cljs.core.Keyword(null,"exception","exception",-335277064),null], null);
});
pinkgorilla.notebook.hydration.to_free_segment = (function pinkgorilla$notebook$hydration$to_free_segment(code_segment){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(code_segment),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"free","free",801364328),new cljs.core.Keyword(null,"markup-visible","markup-visible",447471311),false,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(code_segment,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"value","value",305978217)], null)),new cljs.core.Keyword(null,"type","type",1174270348),"text/x-markdown"], null)], null);
});
pinkgorilla.notebook.hydration.insert_segment_at = (function pinkgorilla$notebook$hydration$insert_segment_at(worksheet,new_index,new_segment){
var segment_order = new cljs.core.Keyword(null,"segment-order","segment-order",476484406).cljs$core$IFn$_invoke$arity$1(worksheet);
var segments = new cljs.core.Keyword(null,"segments","segments",1937535949).cljs$core$IFn$_invoke$arity$1(worksheet);
var new_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(new_segment);
var vec__68187 = cljs.core.split_at(new_index,segment_order);
var head = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68187,(0),null);
var tail = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68187,(1),null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([worksheet,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"active-segment","active-segment",-1021318054),new_id,new cljs.core.Keyword(null,"segments","segments",1937535949),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(segments,new_id,new_segment),new cljs.core.Keyword(null,"segment-order","segment-order",476484406),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(head,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(tail,new_id)))], null)], 0));
});
pinkgorilla.notebook.hydration.remove_segment = (function pinkgorilla$notebook$hydration$remove_segment(worksheet,seg_id){
var segment_order = new cljs.core.Keyword(null,"segment-order","segment-order",476484406).cljs$core$IFn$_invoke$arity$1(worksheet);
var active_id = new cljs.core.Keyword(null,"active-segment","active-segment",-1021318054).cljs$core$IFn$_invoke$arity$1(worksheet);
var seg_idx = segment_order.indexOf(seg_id);
var next_active_idx = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_id,seg_id)) && ((seg_idx > (0)))))?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(segment_order,(seg_idx - (1))):null);
var segments = new cljs.core.Keyword(null,"segments","segments",1937535949).cljs$core$IFn$_invoke$arity$1(worksheet);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([worksheet,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"active-segment","active-segment",-1021318054),next_active_idx,new cljs.core.Keyword(null,"segments","segments",1937535949),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(segments,seg_id),new cljs.core.Keyword(null,"segment-order","segment-order",476484406),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__68190_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(seg_id,p1__68190_SHARP_);
}),segment_order))], null)], 0));
});
pinkgorilla.notebook.hydration.update_segment = (function pinkgorilla$notebook$hydration$update_segment(fun,notebook,seg_id){
var segment = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(notebook,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"segments","segments",1937535949),seg_id], null));
var segment_new = (fun.cljs$core$IFn$_invoke$arity$1 ? fun.cljs$core$IFn$_invoke$arity$1(segment) : fun.call(null,segment));
return cljs.core.assoc_in(notebook,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"segments","segments",1937535949),seg_id], null),segment_new);
});
pinkgorilla.notebook.hydration.update_segment_active = (function pinkgorilla$notebook$hydration$update_segment_active(notebook,fun){
var seg_id = new cljs.core.Keyword(null,"active","active",1895962068).cljs$core$IFn$_invoke$arity$1(notebook);
return pinkgorilla.notebook.hydration.update_segment(fun,notebook,seg_id);
});
pinkgorilla.notebook.hydration.update_segment_all = (function pinkgorilla$notebook$hydration$update_segment_all(notebook,fun){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.notebook.hydration.update_segment,fun),notebook,new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(notebook));
});
pinkgorilla.notebook.hydration.clear_output = (function pinkgorilla$notebook$hydration$clear_output(segment){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(segment,new cljs.core.Keyword(null,"out","out",-910545517),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"picasso","picasso",-1388478491),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"err","err",-2089457205),new cljs.core.Keyword(null,"ex","ex",-1413771341),new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778)], 0));
});
pinkgorilla.notebook.hydration.clear_active = (function pinkgorilla$notebook$hydration$clear_active(notebook){
return pinkgorilla.notebook.hydration.update_segment_active(notebook,pinkgorilla.notebook.hydration.clear_output);
});
pinkgorilla.notebook.hydration.clear_all = (function pinkgorilla$notebook$hydration$clear_all(notebook){
return pinkgorilla.notebook.hydration.update_segment_all(notebook,pinkgorilla.notebook.hydration.clear_output);
});

//# sourceMappingURL=pinkgorilla.notebook.hydration.js.map
