goog.provide('pinkgorilla.notebook_ui.codemirror.extension.completion');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('re_frame.core');
goog.require('cljs.reader');
goog.require('reagent.core');
goog.require('cljs.tools.reader');
pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars = "[^\\s\\(\\)\\[\\]\\{\\},`']*";
pinkgorilla.notebook_ui.codemirror.extension.completion.word_in_line = (function pinkgorilla$notebook_ui$codemirror$extension$completion$word_in_line(line,lno,cno){
var back = cljs.core.get.cljs$core$IFn$_invoke$arity$2(line.slice((0),cno).match((new RegExp([pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars,"$"].join('')))),(0));
var forward = cljs.core.get.cljs$core$IFn$_invoke$arity$2(line.slice(cno).match((new RegExp(["^",pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars].join('')))),(0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),({"line": lno, "ch": (cno - cljs.core.count(back))}),new cljs.core.Keyword(null,"end","end",-268185958),({"line": lno, "ch": (cno + cljs.core.count(forward))})], null);
});
pinkgorilla.notebook_ui.codemirror.extension.completion.cm_get_range = (function pinkgorilla$notebook_ui$codemirror$extension$completion$cm_get_range(cm,range){
return cm.getRange(new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(range),new cljs.core.Keyword(null,"end","end",-268185958).cljs$core$IFn$_invoke$arity$1(range));
});
/**
 * Find the current 'word' according to CodeMirror's `wordChars' list
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.cm_current_word = (function pinkgorilla$notebook_ui$codemirror$extension$completion$cm_current_word(cm){
var pos = cm.getCursor();
var line_no = pos.line;
var column_no = pos.ch;
var line_range = cm.getLine(column_no,line_no);
if(cljs.core.truth_(line_range)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5873427328806648633.clj",92,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-range: ",line_range], null);
}),null)),null,-1605240553);

return pinkgorilla.notebook_ui.codemirror.extension.completion.cm_get_range(cm,pinkgorilla.notebook_ui.codemirror.extension.completion.word_in_line(line_range,line_no,column_no));
} else {
return null;
}
});
pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates = (function pinkgorilla$notebook_ui$codemirror$extension$completion$get_completion_candidates(cm){
var word = pinkgorilla.notebook_ui.codemirror.extension.completion.cm_current_word(cm);
if(cljs.core.empty_QMARK_(word)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5873427328806648633.clj",99,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["no current word - cannot get hint!"], null);
}),null)),null,486622306);
} else {
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5873427328806648633.clj",101,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["getting code-completion for word: ",word], null);
}),null)),null,109904495);

var G__75209_75221 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","hint","completion/hint",-1183694070),word,"user",""], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__75209_75221) : re_frame.core.dispatch.call(null,G__75209_75221));

return true;
}
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint(p__75210){
var map__75211 = p__75210;
var map__75211__$1 = (((((!((map__75211 == null))))?(((((map__75211.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75211.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75211):map__75211);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75211__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75211__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5873427328806648633.clj",108,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-get .. "], null);
}),null)),null,1364910856);

if(cljs.core.truth_(cm)){
pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates(cm);
} else {
}

return e.preventDefault();
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint_prior = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint_prior(p__75213){
var map__75214 = p__75213;
var map__75214__$1 = (((((!((map__75214 == null))))?(((((map__75214.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75214.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75214):map__75214);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75214__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75214__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5873427328806648633.clj",116,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-prior .. "], null);
}),null)),null,248278285);

var G__75216_75222 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","prior","completion/prior",-481875588)], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__75216_75222) : re_frame.core.dispatch.call(null,G__75216_75222));

return e.preventDefault();
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint_next = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint_next(p__75217){
var map__75218 = p__75217;
var map__75218__$1 = (((((!((map__75218 == null))))?(((((map__75218.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75218.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75218):map__75218);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75218__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75218__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init5873427328806648633.clj",123,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-next .. "], null);
}),null)),null,2075530572);

pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates(cm);

var G__75220_75223 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","next","completion/next",1497262191)], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__75220_75223) : re_frame.core.dispatch.call(null,G__75220_75223));

return e.preventDefault();
});

//# sourceMappingURL=pinkgorilla.notebook_ui.codemirror.extension.completion.js.map
