goog.provide('pinkgorilla.nrepl.op.eval');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('reagent.core');
goog.require('pinkgorilla.nrepl.ws.client');
/**
 * converts (:value message)
 * nrepl has to serialize the value before it hits clojure.
 * So this value gets formatted with edn.
 * Since the message is packaged as edn too, we have edn within edn.
 * 
 */
pinkgorilla.nrepl.op.eval.parse_value = (function pinkgorilla$nrepl$op$eval$parse_value(value){
try{var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.op.eval","/tmp/form-init5873427328806648633.clj",19,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["value: ",value], null);
}),null)),null,1854840165);
var data = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(value);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.op.eval","/tmp/form-init5873427328806648633.clj",21,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["converted: ",data], null);
}),null)),null,138503299);
return data;
}catch (e76237){if((e76237 instanceof Error)){
var e = e76237;
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.nrepl.op.eval","/tmp/form-init5873427328806648633.clj",27,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["parse-value ex: ",e," tried to parse: ",value], null);
}),null)),null,-1088385480);
} else {
throw e76237;

}
}});
/**
 * result is an atom, containing the eval result.
 * processes a fragment-response and modifies result-atom accordingly.
 */
pinkgorilla.nrepl.op.eval.on_eval_fragment = (function pinkgorilla$nrepl$op$eval$on_eval_fragment(result,p__76238){
var map__76239 = p__76238;
var map__76239__$1 = (((((!((map__76239 == null))))?(((((map__76239.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76239.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__76239):map__76239);
var message = map__76239__$1;
var out = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76239__$1,new cljs.core.Keyword(null,"out","out",-910545517));
var err = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76239__$1,new cljs.core.Keyword(null,"err","err",-2089457205));
var root_ex = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76239__$1,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76239__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76239__$1,new cljs.core.Keyword(null,"value","value",305978217));
var picasso__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76239__$1,new cljs.core.Keyword(null,"picasso","picasso",-1388478491));
var datafy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76239__$1,new cljs.core.Keyword(null,"datafy","datafy",863837122));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76239__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
if(cljs.core.truth_(out)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"out","out",-910545517),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"out","out",-910545517).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(out)].join(''));
} else {
}

if(cljs.core.truth_(err)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"err","err",-2089457205),err);
} else {
}

if(cljs.core.truth_(datafy)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"datafy","datafy",863837122),datafy);
} else {
}

if(cljs.core.truth_(ns)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"ns","ns",441598760),ns);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"value","value",305978217),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result)),value));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"picasso","picasso",-1388478491),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"picasso","picasso",-1388478491).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(result)),pinkgorilla.nrepl.op.eval.parse_value(picasso__$1)));
} else {
}

if(cljs.core.truth_(root_ex)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(result,cljs.core.assoc,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778),root_ex);
} else {
return null;
}
});
/**
 * evaluates a clj-snippet
 */
pinkgorilla.nrepl.op.eval.nrepl_eval = (function pinkgorilla$nrepl$op$eval$nrepl_eval(conn,code){
var result = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"picasso","picasso",-1388478491),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"ns","ns",441598760),null,new cljs.core.Keyword(null,"out","out",-910545517),"",new cljs.core.Keyword(null,"err","err",-2089457205),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"root-ex","root-ex",-1080814778),null], null));
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),"eval",new cljs.core.Keyword(null,"code","code",1586293142),code], null),(function (fragments){
var seq__76241_76264 = cljs.core.seq(fragments);
var chunk__76242_76265 = null;
var count__76243_76266 = (0);
var i__76244_76267 = (0);
while(true){
if((i__76244_76267 < count__76243_76266)){
var f_76268 = chunk__76242_76265.cljs$core$IIndexed$_nth$arity$2(null,i__76244_76267);
pinkgorilla.nrepl.op.eval.on_eval_fragment(result,f_76268);


var G__76269 = seq__76241_76264;
var G__76270 = chunk__76242_76265;
var G__76271 = count__76243_76266;
var G__76272 = (i__76244_76267 + (1));
seq__76241_76264 = G__76269;
chunk__76242_76265 = G__76270;
count__76243_76266 = G__76271;
i__76244_76267 = G__76272;
continue;
} else {
var temp__5735__auto___76273 = cljs.core.seq(seq__76241_76264);
if(temp__5735__auto___76273){
var seq__76241_76274__$1 = temp__5735__auto___76273;
if(cljs.core.chunked_seq_QMARK_(seq__76241_76274__$1)){
var c__4550__auto___76275 = cljs.core.chunk_first(seq__76241_76274__$1);
var G__76276 = cljs.core.chunk_rest(seq__76241_76274__$1);
var G__76277 = c__4550__auto___76275;
var G__76278 = cljs.core.count(c__4550__auto___76275);
var G__76279 = (0);
seq__76241_76264 = G__76276;
chunk__76242_76265 = G__76277;
count__76243_76266 = G__76278;
i__76244_76267 = G__76279;
continue;
} else {
var f_76280 = cljs.core.first(seq__76241_76274__$1);
pinkgorilla.nrepl.op.eval.on_eval_fragment(result,f_76280);


var G__76281 = cljs.core.next(seq__76241_76274__$1);
var G__76282 = null;
var G__76283 = (0);
var G__76284 = (0);
seq__76241_76264 = G__76281;
chunk__76242_76265 = G__76282;
count__76243_76266 = G__76283;
i__76244_76267 = G__76284;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(result);
}));
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.nrepl_eval', pinkgorilla.nrepl.op.eval.nrepl_eval);
/**
 * evaluates a clojure expression
 * returns result via callback
 * 
 * execute this in browser console:
 * pinkgorilla.kernel.nrepl.clj_eval_cb ("(+ 7 9 )", 
 *  (function (r) {console.log ("result!!: " +r);}))
 * 
 */
pinkgorilla.nrepl.op.eval.nrepl_eval_cb = (function pinkgorilla$nrepl$op$eval$nrepl_eval_cb(conn,snippet,cb){
var ch = pinkgorilla.nrepl.op.eval.nrepl_eval(conn,snippet);
var c__70899__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_76249){
var state_val_76250 = (state_76249[(1)]);
if((state_val_76250 === (1))){
var state_76249__$1 = state_76249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76249__$1,(2),ch);
} else {
if((state_val_76250 === (2))){
var inst_76246 = (state_76249[(2)]);
var inst_76247 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_76246) : cb.call(null,inst_76246));
var state_76249__$1 = state_76249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76249__$1,inst_76247);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto__ = null;
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto____0 = (function (){
var statearr_76251 = [null,null,null,null,null,null,null];
(statearr_76251[(0)] = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto__);

(statearr_76251[(1)] = (1));

return statearr_76251;
});
var pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto____1 = (function (state_76249){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_76249);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e76252){var ex__70867__auto__ = e76252;
var statearr_76253_76285 = state_76249;
(statearr_76253_76285[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_76249[(4)]))){
var statearr_76254_76286 = state_76249;
(statearr_76254_76286[(1)] = cljs.core.first((state_76249[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76287 = state_76249;
state_76249 = G__76287;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto__ = function(state_76249){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto____1.call(this,state_76249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto____0;
pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto____1;
return pinkgorilla$nrepl$op$eval$nrepl_eval_cb_$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_76255 = f__70900__auto__();
(statearr_76255[(6)] = c__70899__auto__);

return statearr_76255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));

return c__70899__auto__;
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.nrepl_eval_cb', pinkgorilla.nrepl.op.eval.nrepl_eval_cb);
/**
 * executes a clojure ```function-as-string``` (from clojurescript) 
 */
pinkgorilla.nrepl.op.eval.fn_eval = (function pinkgorilla$nrepl$op$eval$fn_eval(var_args){
var args__4736__auto__ = [];
var len__4730__auto___76288 = arguments.length;
var i__4731__auto___76289 = (0);
while(true){
if((i__4731__auto___76289 < len__4730__auto___76288)){
args__4736__auto__.push((arguments[i__4731__auto___76289]));

var G__76290 = (i__4731__auto___76289 + (1));
i__4731__auto___76289 = G__76290;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return pinkgorilla.nrepl.op.eval.fn_eval.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('pinkgorilla.nrepl.op.eval.fn_eval', pinkgorilla.nrepl.op.eval.fn_eval);

(pinkgorilla.nrepl.op.eval.fn_eval.cljs$core$IFn$_invoke$arity$variadic = (function (conn,function_as_string,params){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.nrepl.op.eval","/tmp/form-init5873427328806648633.clj",82,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["params: ",params], null);
}),null)),null,798446684);
var code = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",function_as_string], null),params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [")"], null)], 0));
return pinkgorilla.nrepl.op.eval.nrepl_eval(conn,code);
}));

(pinkgorilla.nrepl.op.eval.fn_eval.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.nrepl.op.eval.fn_eval.cljs$lang$applyTo = (function (seq76256){
var G__76257 = cljs.core.first(seq76256);
var seq76256__$1 = cljs.core.next(seq76256);
var G__76258 = cljs.core.first(seq76256__$1);
var seq76256__$2 = cljs.core.next(seq76256__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__76257,G__76258,seq76256__$2);
}));


//# sourceMappingURL=pinkgorilla.nrepl.op.eval.js.map
