goog.provide('pinkgorilla.nrepl.ws.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('taoensso.timbre');
goog.require('cljs_uuid_utils.core');
goog.require('reagent.core');
goog.require('pinkgorilla.nrepl.ws.connection');
/**
 * make-request 
 * - sends `message` to websocket (so nrepl/cider can process the request)
 * - returns the eval id.
 * parameter:
 * - state: this gets returned by (ws-start!)
 * - message: a nrepl message (with or without request-id)
 * - callback: optional callback that return all fragments of a request
 * returns:
 * - cannel with response fragments
 */
pinkgorilla.nrepl.ws.client.nrepl_op = (function pinkgorilla$nrepl$ws$client$nrepl_op(conn,message){
var request_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var map__75975 = conn;
var map__75975__$1 = (((((!((map__75975 == null))))?(((((map__75975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75975.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75975):map__75975);
var requests = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75975__$1,new cljs.core.Keyword(null,"requests","requests",-733055638));
var input_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75975__$1,new cljs.core.Keyword(null,"input-ch","input-ch",-1864212482));
var request_id = (function (){var or__4120__auto__ = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(message);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
}
})();
var nrepl_msg = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([message,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),request_id], null)], 0));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(requests,cljs.core.assoc,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(request_id),request_ch);

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init5873427328806648633.clj",52,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ws sending ws message: ",nrepl_msg], null);
}),null)),null,1354848160);

var c__70899__auto___76129 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_75982){
var state_val_75983 = (state_75982[(1)]);
if((state_val_75983 === (1))){
var state_75982__$1 = state_75982;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75982__$1,(2),input_ch,nrepl_msg);
} else {
if((state_val_75983 === (2))){
var inst_75980 = (state_75982[(2)]);
var state_75982__$1 = state_75982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75982__$1,inst_75980);
} else {
return null;
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto__ = null;
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto____0 = (function (){
var statearr_75987 = [null,null,null,null,null,null,null];
(statearr_75987[(0)] = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto__);

(statearr_75987[(1)] = (1));

return statearr_75987;
});
var pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto____1 = (function (state_75982){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_75982);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e75989){var ex__70867__auto__ = e75989;
var statearr_75990_76134 = state_75982;
(statearr_75990_76134[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_75982[(4)]))){
var statearr_75992_76135 = state_75982;
(statearr_75992_76135[(1)] = cljs.core.first((state_75982[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76136 = state_75982;
state_75982 = G__76136;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto__ = function(state_75982){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto____1.call(this,state_75982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto____0;
pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto____1;
return pinkgorilla$nrepl$ws$client$nrepl_op_$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_75994 = f__70900__auto__();
(statearr_75994[(6)] = c__70899__auto___76129);

return statearr_75994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return request_ch;
});
pinkgorilla.nrepl.ws.client.nrepl_op_complete = (function pinkgorilla$nrepl$ws$client$nrepl_op_complete(var_args){
var G__75998 = arguments.length;
switch (G__75998) {
case 2:
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$2 = (function (conn,msg){
return pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3(conn,msg,null);
}));

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$core$IFn$_invoke$arity$3 = (function (conn,msg,transform_fn){
var result_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var fragments = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
var fragments_ch = pinkgorilla.nrepl.ws.client.nrepl_op(conn,msg);
var result_fn = (function (){
if(cljs.core.truth_(transform_fn)){
var G__76001 = cljs.core.deref(fragments);
return (transform_fn.cljs$core$IFn$_invoke$arity$1 ? transform_fn.cljs$core$IFn$_invoke$arity$1(G__76001) : transform_fn.call(null,G__76001));
} else {
return cljs.core.deref(fragments);
}
});
var c__70899__auto___76139 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_76022){
var state_val_76023 = (state_76022[(1)]);
if((state_val_76023 === (7))){
var inst_76018 = (state_76022[(2)]);
var state_76022__$1 = state_76022;
var statearr_76025_76140 = state_76022__$1;
(statearr_76025_76140[(2)] = inst_76018);

(statearr_76025_76140[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76023 === (1))){
var state_76022__$1 = state_76022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76022__$1,(2),fragments_ch);
} else {
if((state_val_76023 === (4))){
var inst_76020 = (state_76022[(2)]);
var state_76022__$1 = state_76022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76022__$1,inst_76020);
} else {
if((state_val_76023 === (6))){
var inst_76013 = result_fn();
var state_76022__$1 = state_76022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_76022__$1,(9),result_ch,inst_76013);
} else {
if((state_val_76023 === (3))){
var inst_76005 = (state_76022[(7)]);
var state_76022__$1 = state_76022;
if(cljs.core.truth_(inst_76005)){
var statearr_76031_76143 = state_76022__$1;
(statearr_76031_76143[(1)] = (5));

} else {
var statearr_76032_76145 = state_76022__$1;
(statearr_76032_76145[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76023 === (2))){
var inst_76004 = (state_76022[(2)]);
var inst_76005 = inst_76004;
var state_76022__$1 = (function (){var statearr_76033 = state_76022;
(statearr_76033[(7)] = inst_76005);

return statearr_76033;
})();
var statearr_76034_76146 = state_76022__$1;
(statearr_76034_76146[(2)] = null);

(statearr_76034_76146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76023 === (9))){
var inst_76015 = (state_76022[(2)]);
var inst_76016 = cljs.core.async.close_BANG_(fragments_ch);
var state_76022__$1 = (function (){var statearr_76035 = state_76022;
(statearr_76035[(8)] = inst_76015);

return statearr_76035;
})();
var statearr_76036_76148 = state_76022__$1;
(statearr_76036_76148[(2)] = inst_76016);

(statearr_76036_76148[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76023 === (5))){
var inst_76005 = (state_76022[(7)]);
var inst_76008 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fragments,cljs.core.conj,inst_76005);
var state_76022__$1 = (function (){var statearr_76037 = state_76022;
(statearr_76037[(9)] = inst_76008);

return statearr_76037;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76022__$1,(8),fragments_ch);
} else {
if((state_val_76023 === (8))){
var inst_76010 = (state_76022[(2)]);
var inst_76005 = inst_76010;
var state_76022__$1 = (function (){var statearr_76039 = state_76022;
(statearr_76039[(7)] = inst_76005);

return statearr_76039;
})();
var statearr_76041_76149 = state_76022__$1;
(statearr_76041_76149[(2)] = null);

(statearr_76041_76149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$state_machine__70864__auto__ = null;
var pinkgorilla$nrepl$ws$client$state_machine__70864__auto____0 = (function (){
var statearr_76044 = [null,null,null,null,null,null,null,null,null,null];
(statearr_76044[(0)] = pinkgorilla$nrepl$ws$client$state_machine__70864__auto__);

(statearr_76044[(1)] = (1));

return statearr_76044;
});
var pinkgorilla$nrepl$ws$client$state_machine__70864__auto____1 = (function (state_76022){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_76022);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e76047){var ex__70867__auto__ = e76047;
var statearr_76048_76150 = state_76022;
(statearr_76048_76150[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_76022[(4)]))){
var statearr_76049_76151 = state_76022;
(statearr_76049_76151[(1)] = cljs.core.first((state_76022[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76152 = state_76022;
state_76022 = G__76152;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$state_machine__70864__auto__ = function(state_76022){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$state_machine__70864__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$state_machine__70864__auto____1.call(this,state_76022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$state_machine__70864__auto____0;
pinkgorilla$nrepl$ws$client$state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$state_machine__70864__auto____1;
return pinkgorilla$nrepl$ws$client$state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_76052 = f__70900__auto__();
(statearr_76052[(6)] = c__70899__auto___76139);

return statearr_76052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return result_ch;
}));

(pinkgorilla.nrepl.ws.client.nrepl_op_complete.cljs$lang$maxFixedArity = 3);

/**
 * processes an incoming message that comes from channel (which comes 
 * via websocket via websocket-relay from nrepl)
 * Returns the corresponding request chan.
 */
pinkgorilla.nrepl.ws.client.chan_for_incoming_nrepl_msg = (function pinkgorilla$nrepl$ws$client$chan_for_incoming_nrepl_msg(requests,message){
var map__76054 = message;
var map__76054__$1 = (((((!((map__76054 == null))))?(((((map__76054.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76054.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__76054):map__76054);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76054__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76054__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var request_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(id);
var request_ch = (function (){var G__76058 = cljs.core.deref(requests);
return (request_id.cljs$core$IFn$_invoke$arity$1 ? request_id.cljs$core$IFn$_invoke$arity$1(G__76058) : request_id.call(null,G__76058));
})();
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init5873427328806648633.clj",85,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s fragment rcvd.",request_id], null);
}),null)),null,1199236480);

if(cljs.core.truth_(request_ch)){
if(cljs.core.contains_QMARK_(status,new cljs.core.Keyword(null,"done","done",-889844188))){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init5873427328806648633.clj",89,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s request done.",request_id], null);
}),null)),null,-481690088);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(requests,cljs.core.dissoc,request_id);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_ch,true], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_ch,false], null);
}
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,false], null);
}
});
pinkgorilla.nrepl.ws.client.dump_msg = (function pinkgorilla$nrepl$ws$client$dump_msg(msg){
var request_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(msg);
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"pinkgorilla.nrepl.ws.client","/tmp/form-init5873427328806648633.clj",97,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s dumping response. No associated request found: %s",request_id,msg], null);
}),null)),null,-847303583);
});
/**
 * creates a nrepl connection via websocket
 * Intended to be used with nrepl-op
 */
pinkgorilla.nrepl.ws.client.nrepl_client_BANG_ = (function pinkgorilla$nrepl$ws$client$nrepl_client_BANG_(ws_url){
var conn = pinkgorilla.nrepl.ws.connection.ws_connect_BANG_(ws_url);
var requests = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var output_ch = new cljs.core.Keyword(null,"output-ch","output-ch",1069791231).cljs$core$IFn$_invoke$arity$1(conn);
var c__70899__auto___76160 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70900__auto__ = (function (){var switch__70863__auto__ = (function (state_76093){
var state_val_76094 = (state_76093[(1)]);
if((state_val_76094 === (7))){
var inst_76088 = (state_76093[(2)]);
var state_76093__$1 = (function (){var statearr_76096 = state_76093;
(statearr_76096[(7)] = inst_76088);

return statearr_76096;
})();
var statearr_76097_76163 = state_76093__$1;
(statearr_76097_76163[(2)] = null);

(statearr_76097_76163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76094 === (1))){
var state_76093__$1 = state_76093;
var statearr_76098_76165 = state_76093__$1;
(statearr_76098_76165[(2)] = null);

(statearr_76098_76165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76094 === (4))){
var inst_76072 = (state_76093[(8)]);
var inst_76070 = (state_76093[(9)]);
var inst_76071 = (state_76093[(10)]);
var inst_76070__$1 = (state_76093[(2)]);
var inst_76071__$1 = pinkgorilla.nrepl.ws.client.chan_for_incoming_nrepl_msg(requests,inst_76070__$1);
var inst_76072__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76071__$1,(0),null);
var inst_76073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76071__$1,(1),null);
var state_76093__$1 = (function (){var statearr_76099 = state_76093;
(statearr_76099[(8)] = inst_76072__$1);

(statearr_76099[(9)] = inst_76070__$1);

(statearr_76099[(11)] = inst_76073);

(statearr_76099[(10)] = inst_76071__$1);

return statearr_76099;
})();
if(cljs.core.truth_(inst_76072__$1)){
var statearr_76100_76167 = state_76093__$1;
(statearr_76100_76167[(1)] = (5));

} else {
var statearr_76101_76169 = state_76093__$1;
(statearr_76101_76169[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76094 === (6))){
var inst_76070 = (state_76093[(9)]);
var inst_76086 = pinkgorilla.nrepl.ws.client.dump_msg(inst_76070);
var state_76093__$1 = state_76093;
var statearr_76102_76171 = state_76093__$1;
(statearr_76102_76171[(2)] = inst_76086);

(statearr_76102_76171[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76094 === (3))){
var inst_76091 = (state_76093[(2)]);
var state_76093__$1 = state_76093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76093__$1,inst_76091);
} else {
if((state_val_76094 === (2))){
var state_76093__$1 = state_76093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76093__$1,(4),output_ch);
} else {
if((state_val_76094 === (11))){
var inst_76084 = (state_76093[(2)]);
var state_76093__$1 = state_76093;
var statearr_76104_76172 = state_76093__$1;
(statearr_76104_76172[(2)] = inst_76084);

(statearr_76104_76172[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76094 === (9))){
var inst_76072 = (state_76093[(8)]);
var inst_76070 = (state_76093[(9)]);
var inst_76073 = (state_76093[(11)]);
var inst_76071 = (state_76093[(10)]);
var inst_76078 = (function (){var msg = inst_76070;
var vec__76066 = inst_76071;
var req_ch = inst_76072;
var done_QMARK_ = inst_76073;
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s closing channel.",new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(msg)], null);
});
})();
var inst_76079 = (new cljs.core.Delay(inst_76078,null));
var inst_76080 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.nrepl.ws.client","/tmp/form-init5873427328806648633.clj",113,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_76079,null,-1496793494);
var inst_76081 = cljs.core.async.close_BANG_(inst_76072);
var state_76093__$1 = (function (){var statearr_76105 = state_76093;
(statearr_76105[(12)] = inst_76080);

return statearr_76105;
})();
var statearr_76106_76173 = state_76093__$1;
(statearr_76106_76173[(2)] = inst_76081);

(statearr_76106_76173[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76094 === (5))){
var inst_76072 = (state_76093[(8)]);
var inst_76070 = (state_76093[(9)]);
var state_76093__$1 = state_76093;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_76093__$1,(8),inst_76072,inst_76070);
} else {
if((state_val_76094 === (10))){
var state_76093__$1 = state_76093;
var statearr_76110_76174 = state_76093__$1;
(statearr_76110_76174[(2)] = null);

(statearr_76110_76174[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76094 === (8))){
var inst_76073 = (state_76093[(11)]);
var inst_76076 = (state_76093[(2)]);
var state_76093__$1 = (function (){var statearr_76112 = state_76093;
(statearr_76112[(13)] = inst_76076);

return statearr_76112;
})();
if(cljs.core.truth_(inst_76073)){
var statearr_76114_76175 = state_76093__$1;
(statearr_76114_76175[(1)] = (9));

} else {
var statearr_76115_76176 = state_76093__$1;
(statearr_76115_76176[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto__ = null;
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto____0 = (function (){
var statearr_76117 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76117[(0)] = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto__);

(statearr_76117[(1)] = (1));

return statearr_76117;
});
var pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto____1 = (function (state_76093){
while(true){
var ret_value__70865__auto__ = (function (){try{while(true){
var result__70866__auto__ = switch__70863__auto__(state_76093);
if(cljs.core.keyword_identical_QMARK_(result__70866__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70866__auto__;
}
break;
}
}catch (e76118){var ex__70867__auto__ = e76118;
var statearr_76119_76177 = state_76093;
(statearr_76119_76177[(2)] = ex__70867__auto__);


if(cljs.core.seq((state_76093[(4)]))){
var statearr_76120_76178 = state_76093;
(statearr_76120_76178[(1)] = cljs.core.first((state_76093[(4)])));

} else {
throw ex__70867__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76179 = state_76093;
state_76093 = G__76179;
continue;
} else {
return ret_value__70865__auto__;
}
break;
}
});
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto__ = function(state_76093){
switch(arguments.length){
case 0:
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto____0.call(this);
case 1:
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto____1.call(this,state_76093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$0 = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto____0;
pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto__.cljs$core$IFn$_invoke$arity$1 = pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto____1;
return pinkgorilla$nrepl$ws$client$nrepl_client_BANG__$_state_machine__70864__auto__;
})()
})();
var state__70901__auto__ = (function (){var statearr_76123 = f__70900__auto__();
(statearr_76123[(6)] = c__70899__auto___76160);

return statearr_76123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70901__auto__);
}));


return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"requests","requests",-733055638),requests);
});

//# sourceMappingURL=pinkgorilla.nrepl.ws.client.js.map
