goog.provide('pinkgorilla.storage.gist');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('taoensso.timbre');
goog.require('pinkgorilla.storage.filename_encoding');
goog.require('pinkgorilla.storage.protocols');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
pinkgorilla.storage.gist.StorageGist = (function (id,filename,user,is_public,description,__meta,__extmap,__hash){
this.id = id;
this.filename = filename;
this.user = user;
this.is_public = is_public;
this.description = description;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4374__auto__,k__4375__auto__){
var self__ = this;
var this__4374__auto____$1 = this;
return this__4374__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4375__auto__,null);
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4376__auto__,k67700,else__4377__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var G__67704 = k67700;
var G__67704__$1 = (((G__67704 instanceof cljs.core.Keyword))?G__67704.fqn:null);
switch (G__67704__$1) {
case "id":
return self__.id;

break;
case "filename":
return self__.filename;

break;
case "user":
return self__.user;

break;
case "is-public":
return self__.is_public;

break;
case "description":
return self__.description;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k67700,else__4377__auto__);

}
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4393__auto__,f__4394__auto__,init__4395__auto__){
var self__ = this;
var this__4393__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4396__auto__,p__67705){
var vec__67706 = p__67705;
var k__4397__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67706,(0),null);
var v__4398__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67706,(1),null);
return (f__4394__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4394__auto__.cljs$core$IFn$_invoke$arity$3(ret__4396__auto__,k__4397__auto__,v__4398__auto__) : f__4394__auto__.call(null,ret__4396__auto__,k__4397__auto__,v__4398__auto__));
}),init__4395__auto__,this__4393__auto____$1);
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4388__auto__,writer__4389__auto__,opts__4390__auto__){
var self__ = this;
var this__4388__auto____$1 = this;
var pr_pair__4391__auto__ = (function (keyval__4392__auto__){
return cljs.core.pr_sequential_writer(writer__4389__auto__,cljs.core.pr_writer,""," ","",opts__4390__auto__,keyval__4392__auto__);
});
return cljs.core.pr_sequential_writer(writer__4389__auto__,pr_pair__4391__auto__,"#pinkgorilla.storage.gist.StorageGist{",", ","}",opts__4390__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"filename","filename",-1428840783),self__.filename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"user","user",1532431356),self__.user],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"is-public","is-public",-21753154),self__.is_public],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null))], null),self__.__extmap));
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__67699){
var self__ = this;
var G__67699__$1 = this;
return (new cljs.core.RecordIter((0),G__67699__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"filename","filename",-1428840783),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"is-public","is-public",-21753154),new cljs.core.Keyword(null,"description","description",-1428560544)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4372__auto__){
var self__ = this;
var this__4372__auto____$1 = this;
return self__.__meta;
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4369__auto__){
var self__ = this;
var this__4369__auto____$1 = this;
return (new pinkgorilla.storage.gist.StorageGist(self__.id,self__.filename,self__.user,self__.is_public,self__.description,self__.__meta,self__.__extmap,self__.__hash));
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4370__auto__){
var self__ = this;
var this__4370__auto____$1 = this;
var h__4232__auto__ = self__.__hash;
if((!((h__4232__auto__ == null)))){
return h__4232__auto__;
} else {
var h__4232__auto____$1 = (function (coll__4371__auto__){
return (-979315818 ^ cljs.core.hash_unordered_coll(coll__4371__auto__));
})(this__4370__auto____$1);
(self__.__hash = h__4232__auto____$1);

return h__4232__auto____$1;
}
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this67701,other67702){
var self__ = this;
var this67701__$1 = this;
return (((!((other67702 == null)))) && ((this67701__$1.constructor === other67702.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67701__$1.id,other67702.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67701__$1.filename,other67702.filename)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67701__$1.user,other67702.user)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67701__$1.is_public,other67702.is_public)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67701__$1.description,other67702.description)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67701__$1.__extmap,other67702.__extmap)));
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4383__auto__,k__4384__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"description","description",-1428560544),null,new cljs.core.Keyword(null,"filename","filename",-1428840783),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"user","user",1532431356),null,new cljs.core.Keyword(null,"is-public","is-public",-21753154),null], null), null),k__4384__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4383__auto____$1),self__.__meta),k__4384__auto__);
} else {
return (new pinkgorilla.storage.gist.StorageGist(self__.id,self__.filename,self__.user,self__.is_public,self__.description,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4384__auto__)),null));
}
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4381__auto__,k__4382__auto__,G__67699){
var self__ = this;
var this__4381__auto____$1 = this;
var pred__67709 = cljs.core.keyword_identical_QMARK_;
var expr__67710 = k__4382__auto__;
if(cljs.core.truth_((pred__67709.cljs$core$IFn$_invoke$arity$2 ? pred__67709.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"id","id",-1388402092),expr__67710) : pred__67709.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__67710)))){
return (new pinkgorilla.storage.gist.StorageGist(G__67699,self__.filename,self__.user,self__.is_public,self__.description,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__67709.cljs$core$IFn$_invoke$arity$2 ? pred__67709.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"filename","filename",-1428840783),expr__67710) : pred__67709.call(null,new cljs.core.Keyword(null,"filename","filename",-1428840783),expr__67710)))){
return (new pinkgorilla.storage.gist.StorageGist(self__.id,G__67699,self__.user,self__.is_public,self__.description,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__67709.cljs$core$IFn$_invoke$arity$2 ? pred__67709.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"user","user",1532431356),expr__67710) : pred__67709.call(null,new cljs.core.Keyword(null,"user","user",1532431356),expr__67710)))){
return (new pinkgorilla.storage.gist.StorageGist(self__.id,self__.filename,G__67699,self__.is_public,self__.description,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__67709.cljs$core$IFn$_invoke$arity$2 ? pred__67709.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"is-public","is-public",-21753154),expr__67710) : pred__67709.call(null,new cljs.core.Keyword(null,"is-public","is-public",-21753154),expr__67710)))){
return (new pinkgorilla.storage.gist.StorageGist(self__.id,self__.filename,self__.user,G__67699,self__.description,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__67709.cljs$core$IFn$_invoke$arity$2 ? pred__67709.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"description","description",-1428560544),expr__67710) : pred__67709.call(null,new cljs.core.Keyword(null,"description","description",-1428560544),expr__67710)))){
return (new pinkgorilla.storage.gist.StorageGist(self__.id,self__.filename,self__.user,self__.is_public,G__67699,self__.__meta,self__.__extmap,null));
} else {
return (new pinkgorilla.storage.gist.StorageGist(self__.id,self__.filename,self__.user,self__.is_public,self__.description,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4382__auto__,G__67699),null));
}
}
}
}
}
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4386__auto__){
var self__ = this;
var this__4386__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"filename","filename",-1428840783),self__.filename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"user","user",1532431356),self__.user,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"is-public","is-public",-21753154),self__.is_public,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"description","description",-1428560544),self__.description,null))], null),self__.__extmap));
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4373__auto__,G__67699){
var self__ = this;
var this__4373__auto____$1 = this;
return (new pinkgorilla.storage.gist.StorageGist(self__.id,self__.filename,self__.user,self__.is_public,self__.description,G__67699,self__.__extmap,self__.__hash));
}));

(pinkgorilla.storage.gist.StorageGist.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4379__auto__,entry__4380__auto__){
var self__ = this;
var this__4379__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4380__auto__)){
return this__4379__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4380__auto__,(0)),cljs.core._nth(entry__4380__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4379__auto____$1,entry__4380__auto__);
}
}));

(pinkgorilla.storage.gist.StorageGist.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"filename","filename",211690744,null),new cljs.core.Symbol(null,"user","user",-1122004413,null),new cljs.core.Symbol(null,"is-public","is-public",1618778373,null),new cljs.core.Symbol(null,"description","description",211970983,null)], null);
}));

(pinkgorilla.storage.gist.StorageGist.cljs$lang$type = true);

(pinkgorilla.storage.gist.StorageGist.cljs$lang$ctorPrSeq = (function (this__4417__auto__){
return (new cljs.core.List(null,"pinkgorilla.storage.gist/StorageGist",null,(1),null));
}));

(pinkgorilla.storage.gist.StorageGist.cljs$lang$ctorPrWriter = (function (this__4417__auto__,writer__4418__auto__){
return cljs.core._write(writer__4418__auto__,"pinkgorilla.storage.gist/StorageGist");
}));

/**
 * Positional factory function for pinkgorilla.storage.gist/StorageGist.
 */
pinkgorilla.storage.gist.__GT_StorageGist = (function pinkgorilla$storage$gist$__GT_StorageGist(id,filename,user,is_public,description){
return (new pinkgorilla.storage.gist.StorageGist(id,filename,user,is_public,description,null,null,null));
});

/**
 * Factory function for pinkgorilla.storage.gist/StorageGist, taking a map of keywords to field values.
 */
pinkgorilla.storage.gist.map__GT_StorageGist = (function pinkgorilla$storage$gist$map__GT_StorageGist(G__67703){
var extmap__4413__auto__ = (function (){var G__67712 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__67703,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"filename","filename",-1428840783),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"is-public","is-public",-21753154),new cljs.core.Keyword(null,"description","description",-1428560544)], 0));
if(cljs.core.record_QMARK_(G__67703)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__67712);
} else {
return G__67712;
}
})();
return (new pinkgorilla.storage.gist.StorageGist(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__67703),new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(G__67703),new cljs.core.Keyword(null,"user","user",1532431356).cljs$core$IFn$_invoke$arity$1(G__67703),new cljs.core.Keyword(null,"is-public","is-public",-21753154).cljs$core$IFn$_invoke$arity$1(G__67703),new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(G__67703),null,cljs.core.not_empty(extmap__4413__auto__),null));
});

/**
 * hack: on server query params in post-body arrive as null as string 
 */
pinkgorilla.storage.gist.hack_null = (function pinkgorilla$storage$gist$hack_null(id){
if((id == null)){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",id)){
return null;
} else {
return id;
}
}
});
pinkgorilla.storage.protocols.query_params_to_storage.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"gist","gist",96143031),(function (_,params){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"pinkgorilla.storage.gist","/tmp/form-init5873427328806648633.clj",22,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["gist params: ",params], null);
}),null)),null,-1357737394);

return (new pinkgorilla.storage.gist.StorageGist((function (){var or__4120__auto__ = pinkgorilla.storage.gist.hack_null(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(params));
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return null;
}
})(),new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(params),(function (){var or__4120__auto__ = new cljs.core.Keyword(null,"user","user",1532431356).cljs$core$IFn$_invoke$arity$1(params);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "";
}
})(),(function (){var or__4120__auto__ = new cljs.core.Keyword(null,"is-public","is-public",-21753154).cljs$core$IFn$_invoke$arity$1(params);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return true;
}
})(),(function (){var or__4120__auto__ = new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(params);
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return "";
}
})(),null,null,null));
}));
(pinkgorilla.storage.gist.StorageGist.prototype.pinkgorilla$storage$protocols$Storage$ = cljs.core.PROTOCOL_SENTINEL);

(pinkgorilla.storage.gist.StorageGist.prototype.pinkgorilla$storage$protocols$Storage$storagetype$arity$1 = (function (self){
var self__$1 = this;
return new cljs.core.Keyword(null,"gist","gist",96143031);
}));

(pinkgorilla.storage.gist.StorageGist.prototype.pinkgorilla$storage$protocols$Storage$external_url$arity$1 = (function (self){
var self__$1 = this;
return ["https://gist.github.com/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.user),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.id)].join('');
}));

(pinkgorilla.storage.gist.StorageGist.prototype.pinkgorilla$storage$protocols$Storage$gorilla_path$arity$1 = (function (self){
var self__$1 = this;
return ["?source=gist ","&filename=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.filename),"&id=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__$1.id)].join('');
}));
(pinkgorilla.storage.gist.StorageGist.prototype.pinkgorilla$storage$protocols$FromFilename$ = cljs.core.PROTOCOL_SENTINEL);

(pinkgorilla.storage.gist.StorageGist.prototype.pinkgorilla$storage$protocols$FromFilename$determine_encoding$arity$1 = (function (this$){
var this$__$1 = this;
return pinkgorilla.storage.filename_encoding.filename__GT_encoding(this$__$1,new cljs.core.Keyword(null,"filename","filename",-1428840783));
}));

(pinkgorilla.storage.gist.StorageGist.prototype.pinkgorilla$storage$protocols$FromFilename$determine_name$arity$1 = (function (this$){
var this$__$1 = this;
return pinkgorilla.storage.filename_encoding.filename__GT_name(this$__$1,new cljs.core.Keyword(null,"filename","filename",-1428840783));
}));

//# sourceMappingURL=pinkgorilla.storage.gist.js.map
