goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__63626 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__63627 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__63627);

try{try{var seq__63628 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__63629 = null;
var count__63630 = (0);
var i__63631 = (0);
while(true){
if((i__63631 < count__63630)){
var vec__63638 = chunk__63629.cljs$core$IIndexed$_nth$arity$2(null,i__63631);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63638,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63638,(1),null);
var temp__5733__auto___63683 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___63683)){
var effect_fn_63684 = temp__5733__auto___63683;
(effect_fn_63684.cljs$core$IFn$_invoke$arity$1 ? effect_fn_63684.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_63684.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__63685 = seq__63628;
var G__63686 = chunk__63629;
var G__63687 = count__63630;
var G__63688 = (i__63631 + (1));
seq__63628 = G__63685;
chunk__63629 = G__63686;
count__63630 = G__63687;
i__63631 = G__63688;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63628);
if(temp__5735__auto__){
var seq__63628__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63628__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63628__$1);
var G__63689 = cljs.core.chunk_rest(seq__63628__$1);
var G__63690 = c__4550__auto__;
var G__63691 = cljs.core.count(c__4550__auto__);
var G__63692 = (0);
seq__63628 = G__63689;
chunk__63629 = G__63690;
count__63630 = G__63691;
i__63631 = G__63692;
continue;
} else {
var vec__63641 = cljs.core.first(seq__63628__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63641,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63641,(1),null);
var temp__5733__auto___63697 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___63697)){
var effect_fn_63698 = temp__5733__auto___63697;
(effect_fn_63698.cljs$core$IFn$_invoke$arity$1 ? effect_fn_63698.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_63698.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__63699 = cljs.core.next(seq__63628__$1);
var G__63700 = null;
var G__63701 = (0);
var G__63702 = (0);
seq__63628 = G__63699;
chunk__63629 = G__63700;
count__63630 = G__63701;
i__63631 = G__63702;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__63332__auto___63703 = re_frame.interop.now();
var duration__63333__auto___63704 = (end__63332__auto___63703 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__63333__auto___63704,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__63332__auto___63703);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__63626);
}} else {
var seq__63644 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__63645 = null;
var count__63646 = (0);
var i__63647 = (0);
while(true){
if((i__63647 < count__63646)){
var vec__63656 = chunk__63645.cljs$core$IIndexed$_nth$arity$2(null,i__63647);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63656,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63656,(1),null);
var temp__5733__auto___63708 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___63708)){
var effect_fn_63709 = temp__5733__auto___63708;
(effect_fn_63709.cljs$core$IFn$_invoke$arity$1 ? effect_fn_63709.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_63709.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__63710 = seq__63644;
var G__63711 = chunk__63645;
var G__63712 = count__63646;
var G__63713 = (i__63647 + (1));
seq__63644 = G__63710;
chunk__63645 = G__63711;
count__63646 = G__63712;
i__63647 = G__63713;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63644);
if(temp__5735__auto__){
var seq__63644__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63644__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63644__$1);
var G__63714 = cljs.core.chunk_rest(seq__63644__$1);
var G__63715 = c__4550__auto__;
var G__63716 = cljs.core.count(c__4550__auto__);
var G__63717 = (0);
seq__63644 = G__63714;
chunk__63645 = G__63715;
count__63646 = G__63716;
i__63647 = G__63717;
continue;
} else {
var vec__63659 = cljs.core.first(seq__63644__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63659,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63659,(1),null);
var temp__5733__auto___63718 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___63718)){
var effect_fn_63719 = temp__5733__auto___63718;
(effect_fn_63719.cljs$core$IFn$_invoke$arity$1 ? effect_fn_63719.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_63719.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__63720 = cljs.core.next(seq__63644__$1);
var G__63721 = null;
var G__63722 = (0);
var G__63723 = (0);
seq__63644 = G__63720;
chunk__63645 = G__63721;
count__63646 = G__63722;
i__63647 = G__63723;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__63662 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__63663 = null;
var count__63664 = (0);
var i__63665 = (0);
while(true){
if((i__63665 < count__63664)){
var map__63671 = chunk__63663.cljs$core$IIndexed$_nth$arity$2(null,i__63665);
var map__63671__$1 = (((((!((map__63671 == null))))?(((((map__63671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63671.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63671):map__63671);
var effect = map__63671__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63671__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63671__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__63662,chunk__63663,count__63664,i__63665,map__63671,map__63671__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__63662,chunk__63663,count__63664,i__63665,map__63671,map__63671__$1,effect,ms,dispatch))
,ms);
}


var G__63726 = seq__63662;
var G__63727 = chunk__63663;
var G__63728 = count__63664;
var G__63729 = (i__63665 + (1));
seq__63662 = G__63726;
chunk__63663 = G__63727;
count__63664 = G__63728;
i__63665 = G__63729;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63662);
if(temp__5735__auto__){
var seq__63662__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63662__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63662__$1);
var G__63730 = cljs.core.chunk_rest(seq__63662__$1);
var G__63731 = c__4550__auto__;
var G__63732 = cljs.core.count(c__4550__auto__);
var G__63733 = (0);
seq__63662 = G__63730;
chunk__63663 = G__63731;
count__63664 = G__63732;
i__63665 = G__63733;
continue;
} else {
var map__63673 = cljs.core.first(seq__63662__$1);
var map__63673__$1 = (((((!((map__63673 == null))))?(((((map__63673.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63673.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63673):map__63673);
var effect = map__63673__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63673__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63673__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__63662,chunk__63663,count__63664,i__63665,map__63673,map__63673__$1,effect,ms,dispatch,seq__63662__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__63662,chunk__63663,count__63664,i__63665,map__63673,map__63673__$1,effect,ms,dispatch,seq__63662__$1,temp__5735__auto__))
,ms);
}


var G__63734 = cljs.core.next(seq__63662__$1);
var G__63735 = null;
var G__63736 = (0);
var G__63737 = (0);
seq__63662 = G__63734;
chunk__63663 = G__63735;
count__63664 = G__63736;
i__63665 = G__63737;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__63675 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__63676 = null;
var count__63677 = (0);
var i__63678 = (0);
while(true){
if((i__63678 < count__63677)){
var event = chunk__63676.cljs$core$IIndexed$_nth$arity$2(null,i__63678);
re_frame.router.dispatch(event);


var G__63738 = seq__63675;
var G__63739 = chunk__63676;
var G__63740 = count__63677;
var G__63741 = (i__63678 + (1));
seq__63675 = G__63738;
chunk__63676 = G__63739;
count__63677 = G__63740;
i__63678 = G__63741;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63675);
if(temp__5735__auto__){
var seq__63675__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63675__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63675__$1);
var G__63742 = cljs.core.chunk_rest(seq__63675__$1);
var G__63743 = c__4550__auto__;
var G__63744 = cljs.core.count(c__4550__auto__);
var G__63745 = (0);
seq__63675 = G__63742;
chunk__63676 = G__63743;
count__63677 = G__63744;
i__63678 = G__63745;
continue;
} else {
var event = cljs.core.first(seq__63675__$1);
re_frame.router.dispatch(event);


var G__63746 = cljs.core.next(seq__63675__$1);
var G__63747 = null;
var G__63748 = (0);
var G__63749 = (0);
seq__63675 = G__63746;
chunk__63676 = G__63747;
count__63677 = G__63748;
i__63678 = G__63749;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__63679 = cljs.core.seq(value);
var chunk__63680 = null;
var count__63681 = (0);
var i__63682 = (0);
while(true){
if((i__63682 < count__63681)){
var event = chunk__63680.cljs$core$IIndexed$_nth$arity$2(null,i__63682);
clear_event(event);


var G__63750 = seq__63679;
var G__63751 = chunk__63680;
var G__63752 = count__63681;
var G__63753 = (i__63682 + (1));
seq__63679 = G__63750;
chunk__63680 = G__63751;
count__63681 = G__63752;
i__63682 = G__63753;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63679);
if(temp__5735__auto__){
var seq__63679__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63679__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63679__$1);
var G__63754 = cljs.core.chunk_rest(seq__63679__$1);
var G__63755 = c__4550__auto__;
var G__63756 = cljs.core.count(c__4550__auto__);
var G__63757 = (0);
seq__63679 = G__63754;
chunk__63680 = G__63755;
count__63681 = G__63756;
i__63682 = G__63757;
continue;
} else {
var event = cljs.core.first(seq__63679__$1);
clear_event(event);


var G__63758 = cljs.core.next(seq__63679__$1);
var G__63759 = null;
var G__63760 = (0);
var G__63761 = (0);
seq__63679 = G__63758;
chunk__63680 = G__63759;
count__63681 = G__63760;
i__63682 = G__63761;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
