goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__63352){
var map__63353 = p__63352;
var map__63353__$1 = (((((!((map__63353 == null))))?(((((map__63353.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63353.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63353):map__63353);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63353__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63353__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63353__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63353__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4120__auto__ = child_of;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__63355_63383 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__63356_63384 = null;
var count__63357_63385 = (0);
var i__63358_63386 = (0);
while(true){
if((i__63358_63386 < count__63357_63385)){
var vec__63369_63387 = chunk__63356_63384.cljs$core$IIndexed$_nth$arity$2(null,i__63358_63386);
var k_63388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63369_63387,(0),null);
var cb_63389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63369_63387,(1),null);
try{var G__63373_63390 = cljs.core.deref(re_frame.trace.traces);
(cb_63389.cljs$core$IFn$_invoke$arity$1 ? cb_63389.cljs$core$IFn$_invoke$arity$1(G__63373_63390) : cb_63389.call(null,G__63373_63390));
}catch (e63372){var e_63392 = e63372;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_63388,"while storing",cljs.core.deref(re_frame.trace.traces),e_63392], 0));
}

var G__63395 = seq__63355_63383;
var G__63396 = chunk__63356_63384;
var G__63397 = count__63357_63385;
var G__63398 = (i__63358_63386 + (1));
seq__63355_63383 = G__63395;
chunk__63356_63384 = G__63396;
count__63357_63385 = G__63397;
i__63358_63386 = G__63398;
continue;
} else {
var temp__5735__auto___63399 = cljs.core.seq(seq__63355_63383);
if(temp__5735__auto___63399){
var seq__63355_63400__$1 = temp__5735__auto___63399;
if(cljs.core.chunked_seq_QMARK_(seq__63355_63400__$1)){
var c__4550__auto___63401 = cljs.core.chunk_first(seq__63355_63400__$1);
var G__63402 = cljs.core.chunk_rest(seq__63355_63400__$1);
var G__63403 = c__4550__auto___63401;
var G__63404 = cljs.core.count(c__4550__auto___63401);
var G__63405 = (0);
seq__63355_63383 = G__63402;
chunk__63356_63384 = G__63403;
count__63357_63385 = G__63404;
i__63358_63386 = G__63405;
continue;
} else {
var vec__63374_63406 = cljs.core.first(seq__63355_63400__$1);
var k_63407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63374_63406,(0),null);
var cb_63408 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63374_63406,(1),null);
try{var G__63378_63409 = cljs.core.deref(re_frame.trace.traces);
(cb_63408.cljs$core$IFn$_invoke$arity$1 ? cb_63408.cljs$core$IFn$_invoke$arity$1(G__63378_63409) : cb_63408.call(null,G__63378_63409));
}catch (e63377){var e_63410 = e63377;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_63407,"while storing",cljs.core.deref(re_frame.trace.traces),e_63410], 0));
}

var G__63411 = cljs.core.next(seq__63355_63400__$1);
var G__63412 = null;
var G__63413 = (0);
var G__63414 = (0);
seq__63355_63383 = G__63411;
chunk__63356_63384 = G__63412;
count__63357_63385 = G__63413;
i__63358_63386 = G__63414;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
