(ns pinkgorilla.notebook.app
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   [re-frame.core :refer [dispatch dispatch-sync reg-event-fx]]
   [webly.web.app]
   [pinkgorilla.notebook-ui.app.init :refer [notebook-init!]]
   [pinkgorilla.notebook.views.explorer] ; side-effects
   [pinkgorilla.notebook.views.about] ; side-effects
   [pinkgorilla.notebook.views.docs] ; side-effects
   ; configuration
   [webly.config :refer [webly-config]]
   [pinkgorilla.notebook.config :refer [default-notebook-config]]
   [pinkgorilla.notebook.routes :refer [notebook-routes-backend]]
   [pinkgorilla.notebook.events-config] ; side-effects
   ))

(defn start-notebook-frontend [config]
  (swap! webly-config assoc :timbre-loglevel (:timbre-loglevel config))
  (info "pinkgorilla notebook app starting ..")
  (dispatch [:explorer/init (get-in config [:frontend :explorer])])
  (notebook-init! (:frontend config))
  (webly.web.app/start notebook-routes-backend)
  (webly.web.app/mount-app))

(reg-event-fx
 :notebook/start
 (fn [_ [_ config]]
   (start-notebook-frontend config)
   nil))

(reg-event-fx
 :notebook/start-default-config
 (fn [_ _]
   (start-notebook-frontend default-notebook-config)
   nil))


; todo - get frontend config via api endpoint


(defn ^:export start []
  ;(start-notebook-frontend default-notebook-config)
  (dispatch [:config/load])
  ;(dispatch [:notebook/start-default-config])
  )
