(ns pinkgorilla.notebook.events-config
  "Events related configuration loading"
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [clojure.string :as str]
   [ajax.core :as ajax]
   [re-frame.core :refer [reg-event-db reg-event-fx dispatch]]
   [webly.user.notifications.core :refer [add-notification]]))

;; base-path (str/replace (:path app-url) #"[^/]+$" "")

; load configuration

(reg-event-fx
 :config/load
 (fn [{:keys [db]} _]
   (info "loading configuration from server ..")
   {:db       db
    :http-xhrio {:method          :get
                 :uri             "/api/config"
                 :timeout         5000                     ;; optional see API docs
                 :response-format (ajax/transit-response-format) ;; IMPORTANT!: You must provide this.
                 :on-success      [:config/load-success]
                 :on-failure      [:config/load-error]}}))

(reg-event-fx
 :config/load-success
 (fn [cofx [_ config]]
   (info "config rcvd: " config)
   (dispatch [:notebook/start config])
   #_(let [all-bindings (get-in response [:cljs :key-bindings])
           visible-commands (keybindings/visible-commands all-bindings)]
       {:db         (-> (assoc-in (:db cofx) [:config] response)
                        (assoc-in [:palette :all-visible-commands] visible-commands))
        :dispatch-n (list [:init-cljs] [:explore-load])})
   ;
   nil))

(reg-event-db
 :config/load-error
 (fn [db [_ response]]
   (error "ERROR RESPONSE: " response)
   (let [details (str (:status-text response) " (" (:status response) ")")]
     (add-notification :danger "Error loading notebook config - usng default config!")
     (dispatch [:notebook/start-default-config])
     db)))



