(ns pinkgorilla.notebook.views.docs
  (:require
   [re-frame.core :refer [dispatch]]
   [webly.web.handler :refer [reagent-page]]
   [webly.web.routes :refer [goto!]]))

(defn credit [user txt]
  [:li
   [:span
    [:a.w-16 {:href (str "https://github.com/deas" user)} user]
    txt]])

(defn action [{:keys [on-click href]} text]
  [:div.w-48.h-24.p-5.border-2.border-solid.border-gray-500.rounded.text-center.text-lg.cursor-pointer.bg-pink-100.hover:bg-pink-400
   {:on-click on-click
    :href href} text])

(defn notebook-docs []
  [:div.container
   [:h1.mt-5.text-2xl.italic "Welcome to" [:span.pl-5.text-pink-800.text-3xl.non-italic "PinkGorilla Notebook"]]

   [:p {:on-click #(goto! :notebook/about)} "goto main"]

   [:div.bg-orange-300.mt-5
    [:h1.text-2xl "Documentation"]

    [:h1 "Notebook Evals"]
    [:p "shift enter - eval current cell"]
    [:p "alt-g k - keybinding dialog"]
    [:p "alt-g e - explorer window"]
    [:p "alt-g m - main window"]
    [:p "alt-g d - docs window"]
    [:p "alt-g n - notebook window"]
    [:p "alt-g i - repl info window"]


    ; eval-sniffer


    [:h1 "Eval Sniffer"]
    [:li "Work in your favorite ide, and build a notebook with gorilla visualisations."]
    [:li "Eval :gorilla/on in the repl"]
    [:li "A new notebook appears in /explorer (in unsaved)"]
    [:li "In /nrepl/info you can see the sessions that are currentl being sniffed."]
    [:li "To stop sniffing eval :gorilla/off in the repl"]]])

(defmethod reagent-page :notebook/docs [& args]
  [notebook-docs])