(ns pinkgorilla.notebook-ui.buffer.snippets
  (:require
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkgorilla.ui.config :refer [link-css]]
   ["highlight.js/lib/core" :as hljs]
   ["highlight.js/lib/languages/javascript" :as javascript]
   ["highlight.js/lib/languages/markdown" :as markdown]
   ["highlight.js/lib/languages/plaintext" :as plaintext]
   ["highlight.js/lib/languages/clojure" :as clojure]
   ["highlight.js/lib/languages/clojure-repl" :as clojure-repl]
   [pinkgorilla.notebook-ui.buffer.eval-result :refer [eval-result-view]]))

(.registerLanguage hljs "javascript" javascript)
(.registerLanguage hljs "markdown" markdown)
(.registerLanguage hljs "plaintext" plaintext)
(.registerLanguage hljs "clojure" clojure)
(.registerLanguage hljs "clojure-repl" clojure-repl)


;; todo https://github.com/baskeboler/cljs-karaoke-client/blob/master/package.json
;;  "react-highlight.js": "^1.0.7",

;(.initHighlightingOnLoad hljs)

; nicely formatted notebooks:
; https://nextjournal.com/gigasquid/parens-for-python---seaborn-visualizations
; https://www.maria.cloud/gallery?eval=true




; https://codepen.io/elomatreb/pen/hbgxp

; span {
;    display: block;
;    line-height: 1.5rem;
;    
;    &:before {
;      counter-increment: line;
;      content: counter(line);
;      display: inline-block;
;      border-right: 1px solid #ddd;
;      padding: 0 .5em;
;      margin-right: .5em;
;      color: #888
;    }


(defn code-view [c]
  [:div.text-left.bg-gray-100 ; .border-solid
   [:pre ;.clojure
    [:code {:ref  #(when % (.highlightBlock hljs %))}
    ;.w-full.font-mono
    ;[:p
     c
    ; ]
     ]]])

(defn snippet [{:keys [code] :as eval-result}]
  [:div.w-full.mt-5.p-2
   (when code
     [code-view code])
   [eval-result-view eval-result]])

;(def theme "default.css")
;(def theme "zenburn")
(def theme "github")

(defn ^{:category :pinkie}
  snippets
  "renders a snippet list"
  [list]
  [:div.w-full.h-full.bg-gray-100
   [link-css (str "highlight.js/styles/" theme ".css")]
   ;[:link {:rel "stylesheet" :href (str "/highlight.js/styles/" theme ".css")}]
   (into [:div] (map snippet list))])

(register-component :p/snippets snippets)