(ns pinkgorilla.notebook-ui.kernel.picasso
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop]]
   [reagent.ratom :refer [reaction]])
  (:require
   [taoensso.timbre :refer-macros (info)]
   [cljs.core.async :as async :refer [<! >! chan timeout close!]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [picasso.protocols :refer [paint]]
   [pinkie.html :refer [html]]
   [pinkie.error :refer [error-boundary]]
   [pinkie.pinkie-render :refer [reagent-inject]]))

; picasso in nrepl middleware converts value to picasso-spec
; picasso-spec gets rendered to reagent with paint.
; picasso defines :reagent and :hiccup
; todo: add hiccup style-as-string to style-as-map converter.

(defmethod paint :html [picasso-spec]
  [html (:content picasso-spec)])

(defmethod paint :pinkie [picasso-spec]
  [error-boundary
   [reagent-inject {:map-keywords true}
    (:content picasso-spec)]])

