(ns pinkgorilla.notebook-ui.keybindings.default)

(def code-editor-keybindings
  [{:desc    "move to next auto-completion candidate"
    :kb      "tab"
    :handler [:completion/next]}
   {:desc   "move to prior auto-completion candidate"
    :kb      "shift-tab"
    :handler [:completion/prior]}

   {:name    "command:worksheet:completions"
    :desc    "Show possible auto-completions."
    :kb      "ctrl-space"
    :handler [:worksheet:completions]}
   {:name    "command:evaluator:evaluate"
    :desc    "Evaluate the highlighted segment."
    :kb      "shift-enter"
    :handler [:worksheet:evaluate]}])

(def default-key-bindings
  [{:name    "command:app:commands"
    :desc    "Show the command list."
    :kb      "alt+g alt+g"
    :handler [:app:commands]}
   #_{:name       "command:worksheet:leaveBack"
      :desc       "Move to the previous segment."
      :showInMenu false
      :handler    :worksheet:leaveBack}
   #_{:name       "command:worksheet:leaveForward"
      :desc       "Move to the next segment."
      :showInMenu false
      :handler    :worksheet:leaveForward}

   {:name    "command:evaluator:evaluate-all"
    :desc    "Evaluate all segments."
    :kb      "alt+shift+enter"
    :handler [:worksheet:evaluate-all]}
   {:name    "command:worksheet:clear-output"
    :desc    "Clear the output of the highlighted segment."
    :kb      "alt+g alt+o"
    :handler [:worksheet:clear-output]}
   {:name    "command:worksheet:clear-all"
    :desc    "Clear the output of all code segments."
    :kb      "alt+g alt+z"
    :handler [:worksheet:clear-all-output]}
   {:name    "command:worksheet:delete"
    :desc    "Delete the highlighted segment."
    :kb      "alt+g alt+x"
    :handler [:worksheet:delete]}
   {:name    "command:worksheet:undo"
    :desc    "Undo the last segment operation."
    :kb      "alt+g alt+\\"
    :handler [:undo] #_"worksheet:undelete"}
   {:name    "command:worksheet:changeToFree"
    :desc    "Convert the highlighted segment to a markdown segment."
    :kb      "alt+g alt+m"
    :handler [:worksheet:changeToFree]}
   {:name    "command:worksheet:changeToCode"
    :desc    "Convert the highlighted segment to a clojure segment."
    :kb      "alt+g alt+j"
    :handler [:worksheet:changeToCode]}
   {:name    "command:app:open"
    :desc    "Load a Notebook"
    :kb      "alt+g alt+l"
    :handler [:browse-files-local]}
   {:name    "command:app:save"
    :desc    "Save the notebook"
    :kb      "alt+g alt+s"
    :handler [:save-notebook]}
   {:name    "command:app:showsettings"
    :desc    "Settings Edit."
    :kb      ["ctrl+1" "alt+g alt+1"]
    :handler [:dialog-show :settings]}
   {:name    "command:app:kernel-toggle"
    :desc    "Kernel Toggle."
    :kb      ["ctrl+3" "alt+g alt+3"]
    :handler [:app:kernel-toggle]}
   {:name    "command:app:showmeta"
    :desc    "Meta Edit."
    :kb      ["ctrl+2" "alt+g alt+2"]
    :handler [:dialog-show :meta]}
   {:name    "command:nav:explore"
    :desc    "Explore Notebooks."
    :kb      ["ctrl+4" "alt+g alt+4"]
    :handler [:nav "/explore"]}
   {:name    "command:app:saveas"
    :desc    "Save the worksheet to a new filename."
    :kb      "alt+g alt+e"
    :handler [:app:saveas]}
   {:name    "command:worksheet:newBelow"
    :desc    "Create a new segment below the highlighted segment."
    :kb      "alt+g alt+n"
    :handler [:worksheet:newBelow]}
   {:name    "command:worksheet:newAbove"
    :desc    "Create a new segment above the highlighted segment."
    :kb      "alt+g alt+b"
    :handler [:worksheet:newAbove]}
   {:name    "command:worksheet:moveUp"
    :desc    "Move the highlighted segment up the worksheet."
    :kb      "alt+g alt+u"
    :handler [:worksheet:moveUp]}
   {:name    "command:worksheet:moveDown"
    :desc    "Move the highlighted segment down the worksheet."
    :kb      "alt+g alt+d"
    :handler [:worksheet:moveDown]}
   #_{:name    "command:docs:clojuredocs"
      :desc    "Look up the symbol under the cursor in ClojureDocs."
      :kb      "alt+g alt+c"
      :handler clojuredocs}
   {:name    "command:app:reset-worksheet"
    :desc    "Reset the worksheet - a fresh start."
    :handler [:nav "/reset"]}])
