(ns pinkgorilla.notebook-ui.buffer.eval-result
  (:require
   [pinkgorilla.ui.config :refer [link-css]]
   [picasso.protocols :refer [paint]]
   [picasso.paint.core :refer [->reagent]]
   [pinkgorilla.notebook-ui.buffer.console :refer [console-view]]
   [pinkgorilla.notebook-ui.buffer.error :refer [error-text]]
   [pinkgorilla.notebook-ui.buffer.stacktrace :refer [stacktrace-table]]))

(defn picasso-cell [ps]
  (into [:div.flex.flex-col.w-full.mt-5 ;.bg-gray-100
         ]
        (->reagent ps)
        ;(map (fn [s] [paint s]) ps)
        ))

(defn eval-result-view [{:keys [picasso out err] :as result}]
  [:div.w-full.mt-5.p-2
   ;(when err
    ; [stacktrace-table result]
   [error-text result]
     ;[console-cell err]
     ;)

   (when out
     [console-view out])

   (when picasso
     [picasso-cell picasso])])

