(ns pinkgorilla.notebook-ui.keybindings.setup
  (:require
   [re-frame.core :as r :refer [reg-event-db dispatch]]
   [taoensso.timbre :refer-macros [infof]]
   [keybind.core :as key]))

(def current (atom 0))

(defn id []
  (swap! current inc)
  (keyword (str @current)))

(defn bind-key [{:keys [kb handler]}]
  (infof "binding %s to %s" kb handler)
  (key/bind! kb (id) #(dispatch handler)))

(defn ^:export init-keybindings!
  [keybindings]
  (doall (for [kb keybindings]
           (bind-key kb))))

