(ns pinkgorilla.notebook-ui.eval-result.code
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.ui.config :refer [link-css]]
   [pinkgorilla.notebook-ui.eval-result.code-viewer :refer [code-view code-viewer-theme]]))

(defn code-theme []
  [:div
   [code-viewer-theme]])

(defn code-edit [{:keys [id code active?] :as eval-result}]
  #_[:pre ;.clojure
     [:code {:ref  #(when % (.highlightBlock hljs %))
             :contenteditable "true"
             :on-input (fn [evt]
                         (let [v (-> evt .-target .-value)] ; 
                           (info "code changed!" v)
                        ;(reset! ratom v)
                           ))
           ;:value code
             }
      code]]
  (info "eval result: " eval-result)
  [:textarea.font-mono.text-left.w-full.text-gray-70
   {:value (or code "")
    :on-change (fn [evt]
                 (let [v (-> evt .-target .-value)] ; 
                   (info "code changed!" v)
                   (dispatch [:notebook/set-code id v])
                        ;(reset! ratom v)
                   ))}])

(defn code-component [{:keys [code active?] :as eval-result}]
  [:div.text-left.bg-gray-100 ; .border-solid
   {:class (when active? "border border-solid border-red-600")}
   (if active?
     [code-edit eval-result]
     [code-view eval-result])])