(ns pinkgorilla.notebook-ui.codemirror.editor
  (:require
   [taoensso.timbre :refer-macros [debug info]]
   [reagent.core :as r]
   [reagent.dom :as rd]
   [re-frame.core :refer [dispatch subscribe]]
   ["codemirror" :as CodeMirror]

   ["codemirror/addon/edit/closebrackets"]
   ["codemirror/addon/edit/matchbrackets"]
   ["codemirror/addon/hint/show-hint"]
   ["codemirror/addon/runmode/runmode"]
   ["codemirror/addon/runmode/colorize"]

   ["codemirror/mode/clojure/clojure"]
   ["codemirror/mode/markdown/markdown"]
   ; [cljsjs.codemirror.mode.xml]
   ; [cljsjs.codemirror.mode.javascript]
   ; ["parinfer-codemirror"]
   ; [cljsjs.codemirror.mode.clojure-parinfer]

   ;["codemirror/keymap/vim"]
   [pinkgorilla.ui.config :refer [link-css]]
   [pinkgorilla.notebook-ui.codemirror.theme]
   [pinkgorilla.notebook-ui.codemirror.highlight]
   [pinkgorilla.notebook-ui.codemirror.key-binding :refer [on-key-down on-key-up]]

   [pinkgorilla.notebook-ui.codemirror.options :refer [cm-default-opts]]
   [pinkgorilla.notebook-ui.codemirror.extension :refer [run-extension]]
   [pinkgorilla.notebook-ui.codemirror.extensions :refer [cm-fun]]))

(defn on-mousedown [cm evt]
  (debug "on-mousedown"))

(defn focus-cm!
  [cm]
  (when cm
    (.focus cm)))

(defn codemirror-reagent
  "Create a code-mirror editor that knows a fair amount about being a good
  repl. The parameters:
  :style (reagent style map) will be applied to the container element"
  [buffer cm-opts]
  (let [opts  (merge
               {:value (:code @buffer)}
               cm-fun
               cm-default-opts
               cm-opts)
        buffer-a (atom buffer) ; atom in atom. the currently viewed buffer can change
        cm (atom nil)
        run (fn [handler] (run-extension {:cm-opts opts
                                          :cm cm
                                          :buffer @buffer-a}
                                         handler))]
    (r/create-class
     {:component-did-mount
      (fn [this]
        (let [el (rd/dom-node this)
              opts-js (clj->js opts)
              _ (info "creating cm for: " el " opts: " opts)
              ;cm_ (CodeMirror. el opts-js)
              cm_ (.fromTextArea CodeMirror el opts-js)]

          (reset! cm cm_)
          (.setValue cm_ (:code @buffer))
          ;(.setOption inst "theme" (:theme opts))
          (.on cm_ "change" (fn [] (run [:save-code])))
          (.on cm_ "keydown"  (partial on-key-down opts))
          ; (.on inst "keyup"  on-key-up)          
          (.on cm_ "mousedown" on-mousedown)
          ;(when on-cm-init (on-cm-init inst))
          ;(focus-cm! inst)
          (.setSize cm_ "100%" "100%")))

      :component-did-update
      (fn [this old-argv]
        (let [[_ buffer _] (r/argv this)]
          (reset! buffer-a buffer)
          (info "current buffer: " (:id @buffer))
          (run [:load-code])))

      :reagent-render
      #_(fn [_ _ _]
          @buffer
        ;[:pre {:class "static-code clojure"}]
          [:div {:style (:style opts)
                 :class (:class opts)}])
      (fn []
        [:textarea])})))

(defn code-mirror [buffer-id options]
  (let [buffer (subscribe [:buffer/view buffer-id])]
    (fn [buffer-id options]
      [:div.w-full.h-full.bg-red-200 ; if this is :<> then it can fuck up flexbox styling
     ; dynamically loading css will not work the first time
     ; the editor is shown. css might get rendered after codemirror. 
       [link-css "codemirror/lib/codemirror.css"]
       [codemirror-reagent buffer options]])))

