(ns pinkgorilla.notebook-ui.notebook.component
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkgorilla.notebook-ui.eval-result.code :refer [code-theme]]
   [pinkgorilla.notebook-ui.codemirror.theme :refer [theme-codemirror]]
   [pinkgorilla.notebook-ui.notebook.segment :refer [segment-view]]))

(defn ^{:category :pinkie}
  snippets
  "renders a snippet list"
  [list]
  [:div.w-full.h-full.bg-gray-100
   [code-theme]
   (into [:div] (map segment-view list))])

; use from encoding / hydration

(defn segments-ordered [notebook]
  (let [segments (:segments notebook)
        segment-ids-ordered (:order notebook)]
    (vec (map #(get segments %) segment-ids-ordered))))

(defn code? [segment]
  (= :code (:type segment)))

(defn theme []
  (let [settings (subscribe [:settings])
        code-editor (or (:code-editor @settings) :text)]
    [:div
     [code-theme]
     (case code-editor
       :codemirror [theme-codemirror])]))

(defn notebook-viewer [storage notebook]
  (let [segments (segments-ordered notebook)
        settings (subscribe [:settings])
        layout (or (:layout @settings) :vertical)
        segment-active @(subscribe [:notebook/segment-active])]
    (dispatch [:notebook/activate! storage])
    (when-not (:active notebook)
      (dispatch [:notebook/move :last]))
    [:div.w-full.h-full.bg-gray-100.overflow-scroll
     [theme]
     (if (= layout :single)
       [segment-view segment-active]
       (into [:div] (map segment-view segments)))]))

(register-component :p/snippets snippets)