(ns pinkgorilla.notebook-ui.kernel.events
  (:require
   [taoensso.timbre :refer-macros [info]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]))

; kernels:
; keys: :clj :cljs 
; values: :nrepl/eval :cljs-selfhosted/eval :shadow/eval
(def kernels (atom {}))

(defn kernel->msg-type [kernel]
  (if-let [impl (get @kernels kernel)]
    impl
    :mock/eval))

(reg-event-fx
 :kernel/register-kernel
 (fn [_ [_ kernel msg-type]]
   (info "Registering Kernel " kernel " -> " msg-type)
   (swap! kernels assoc kernel msg-type)
   nil))

(reg-event-fx
 :kernel/eval
 (fn [_ [_ kernel code result-location]]
   (let [msg-type (kernel->msg-type kernel)]
     (dispatch [msg-type kernel code result-location]))))

(reg-event-db
 :kernel/save-result
 (fn [db [_ path data eval?]]
   (info "saving nrepl result path: " path " data: " data)
   (let [segment (get-in db path)
         segment-updated (merge segment data)
         x (-> db
               (assoc-in path segment-updated))]
     ;(info "seg: " (get-in db path))
     ;(info "db: " (get-in x [:document :documents]))
     (when eval?
       (dispatch [:notebook/evaluate-next-queued]))
     x)))
